/*-------------------------------------------------------------------------
 * PIC32MZ0512EFF064 processor header
 * Build date : Aug 03 2020
 *
 * Copyright (c) 2020, Microchip Technology Inc. and its subsidiaries ("Microchip")
 * All rights reserved.
 * 
 * This software is developed by Microchip Technology Inc. and its
 * subsidiaries ("Microchip").
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are 
 * met:
 * 
 * 1.      Redistributions of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 * 2.      Redistributions in binary form must reproduce the above 
 *         copyright notice, this list of conditions and the following 
 *         disclaimer in the documentation and/or other materials provided 
 *         with the distribution. Publication is not required when this file 
 *         is used in an embedded application.
 * 3.      Microchip's name may not be used to endorse or promote products
 *         derived from this software without specific prior written 
 *         permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY MICROCHIP "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL MICROCHIP BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWSOEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

#pragma once
#ifndef __32MZ0512EFF064_H
#define __32MZ0512EFF064_H

#if defined (__LANGUAGE_C__) || defined (__LANGUAGE_C_PLUS_PLUS)

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

#define CFGCON CFGCON
extern volatile uint32_t   CFGCON __attribute__((section("sfrs"), address(0xBF800000)));
typedef union {
  struct {
    uint32_t TDOEN:1;
    uint32_t :1;
    uint32_t TROEN:1;
    uint32_t JTAGEN:1;
    uint32_t ECCCON:2;
    uint32_t :1;
    uint32_t IOANCPN:1;
    uint32_t USBSSEN:1;
    uint32_t :2;
    uint32_t PGLOCK:1;
    uint32_t PMDLOCK:1;
    uint32_t IOLOCK:1;
    uint32_t :2;
    uint32_t OCACLK:1;
    uint32_t ICACLK:1;
    uint32_t :6;
    uint32_t CPUPRI:1;
    uint32_t DMAPRI:1;
  };
  struct {
    uint32_t :7;
    uint32_t IOANCPEN:1;
  };
} __CFGCONbits_t;
extern volatile __CFGCONbits_t CFGCONbits __asm__ ("CFGCON") __attribute__((section("sfrs"), address(0xBF800000)));
#define DEVID DEVID
extern volatile uint32_t   DEVID __attribute__((section("sfrs"), address(0xBF800020)));
typedef struct {
  uint32_t DEVID:28;
  uint32_t VER:4;
} __DEVIDbits_t;
extern volatile __DEVIDbits_t DEVIDbits __asm__ ("DEVID") __attribute__((section("sfrs"), address(0xBF800020)));
#define SYSKEY SYSKEY
extern volatile uint32_t   SYSKEY __attribute__((section("sfrs"), address(0xBF800030)));
typedef struct {
  uint32_t SYSKEY:32;
} __SYSKEYbits_t;
extern volatile __SYSKEYbits_t SYSKEYbits __asm__ ("SYSKEY") __attribute__((section("sfrs"), address(0xBF800030)));
#define PMD1 PMD1
extern volatile uint32_t   PMD1 __attribute__((section("sfrs"), address(0xBF800040)));
typedef struct {
  uint32_t ADCMD:1;
  uint32_t :11;
  uint32_t CVRMD:1;
} __PMD1bits_t;
extern volatile __PMD1bits_t PMD1bits __asm__ ("PMD1") __attribute__((section("sfrs"), address(0xBF800040)));
extern volatile uint32_t        PMD1CLR __attribute__((section("sfrs"),address(0xBF800044)));
extern volatile uint32_t        PMD1SET __attribute__((section("sfrs"),address(0xBF800048)));
extern volatile uint32_t        PMD1INV __attribute__((section("sfrs"),address(0xBF80004C)));
#define PMD2 PMD2
extern volatile uint32_t   PMD2 __attribute__((section("sfrs"), address(0xBF800050)));
typedef struct {
  uint32_t CMP1MD:1;
  uint32_t CMP2MD:1;
} __PMD2bits_t;
extern volatile __PMD2bits_t PMD2bits __asm__ ("PMD2") __attribute__((section("sfrs"), address(0xBF800050)));
extern volatile uint32_t        PMD2CLR __attribute__((section("sfrs"),address(0xBF800054)));
extern volatile uint32_t        PMD2SET __attribute__((section("sfrs"),address(0xBF800058)));
extern volatile uint32_t        PMD2INV __attribute__((section("sfrs"),address(0xBF80005C)));
#define PMD3 PMD3
extern volatile uint32_t   PMD3 __attribute__((section("sfrs"), address(0xBF800060)));
typedef struct {
  uint32_t IC1MD:1;
  uint32_t IC2MD:1;
  uint32_t IC3MD:1;
  uint32_t IC4MD:1;
  uint32_t IC5MD:1;
  uint32_t IC6MD:1;
  uint32_t IC7MD:1;
  uint32_t IC8MD:1;
  uint32_t IC9MD:1;
  uint32_t :7;
  uint32_t OC1MD:1;
  uint32_t OC2MD:1;
  uint32_t OC3MD:1;
  uint32_t OC4MD:1;
  uint32_t OC5MD:1;
  uint32_t OC6MD:1;
  uint32_t OC7MD:1;
  uint32_t OC8MD:1;
  uint32_t OC9MD:1;
} __PMD3bits_t;
extern volatile __PMD3bits_t PMD3bits __asm__ ("PMD3") __attribute__((section("sfrs"), address(0xBF800060)));
extern volatile uint32_t        PMD3CLR __attribute__((section("sfrs"),address(0xBF800064)));
extern volatile uint32_t        PMD3SET __attribute__((section("sfrs"),address(0xBF800068)));
extern volatile uint32_t        PMD3INV __attribute__((section("sfrs"),address(0xBF80006C)));
#define PMD4 PMD4
extern volatile uint32_t   PMD4 __attribute__((section("sfrs"), address(0xBF800070)));
typedef struct {
  uint32_t T1MD:1;
  uint32_t T2MD:1;
  uint32_t T3MD:1;
  uint32_t T4MD:1;
  uint32_t T5MD:1;
  uint32_t T6MD:1;
  uint32_t T7MD:1;
  uint32_t T8MD:1;
  uint32_t T9MD:1;
} __PMD4bits_t;
extern volatile __PMD4bits_t PMD4bits __asm__ ("PMD4") __attribute__((section("sfrs"), address(0xBF800070)));
extern volatile uint32_t        PMD4CLR __attribute__((section("sfrs"),address(0xBF800074)));
extern volatile uint32_t        PMD4SET __attribute__((section("sfrs"),address(0xBF800078)));
extern volatile uint32_t        PMD4INV __attribute__((section("sfrs"),address(0xBF80007C)));
#define PMD5 PMD5
extern volatile uint32_t   PMD5 __attribute__((section("sfrs"), address(0xBF800080)));
typedef struct {
  uint32_t U1MD:1;
  uint32_t U2MD:1;
  uint32_t U3MD:1;
  uint32_t U4MD:1;
  uint32_t U5MD:1;
  uint32_t U6MD:1;
  uint32_t :2;
  uint32_t SPI1MD:1;
  uint32_t SPI2MD:1;
  uint32_t SPI3MD:1;
  uint32_t SPI4MD:1;
  uint32_t :4;
  uint32_t I2C1MD:1;
  uint32_t :1;
  uint32_t I2C3MD:1;
  uint32_t I2C4MD:1;
  uint32_t I2C5MD:1;
  uint32_t :3;
  uint32_t USBMD:1;
  uint32_t :3;
  uint32_t CAN1MD:1;
  uint32_t CAN2MD:1;
} __PMD5bits_t;
extern volatile __PMD5bits_t PMD5bits __asm__ ("PMD5") __attribute__((section("sfrs"), address(0xBF800080)));
extern volatile uint32_t        PMD5CLR __attribute__((section("sfrs"),address(0xBF800084)));
extern volatile uint32_t        PMD5SET __attribute__((section("sfrs"),address(0xBF800088)));
extern volatile uint32_t        PMD5INV __attribute__((section("sfrs"),address(0xBF80008C)));
#define PMD6 PMD6
extern volatile uint32_t   PMD6 __attribute__((section("sfrs"), address(0xBF800090)));
typedef struct {
  uint32_t RTCCMD:1;
  uint32_t :7;
  uint32_t REFO1MD:1;
  uint32_t REFO2MD:1;
  uint32_t REFO3MD:1;
  uint32_t REFO4MD:1;
  uint32_t :4;
  uint32_t PMPMD:1;
  uint32_t :6;
  uint32_t SQI1MD:1;
  uint32_t :4;
  uint32_t ETHMD:1;
} __PMD6bits_t;
extern volatile __PMD6bits_t PMD6bits __asm__ ("PMD6") __attribute__((section("sfrs"), address(0xBF800090)));
extern volatile uint32_t        PMD6CLR __attribute__((section("sfrs"),address(0xBF800094)));
extern volatile uint32_t        PMD6SET __attribute__((section("sfrs"),address(0xBF800098)));
extern volatile uint32_t        PMD6INV __attribute__((section("sfrs"),address(0xBF80009C)));
#define PMD7 PMD7
extern volatile uint32_t   PMD7 __attribute__((section("sfrs"), address(0xBF8000A0)));
typedef struct {
  uint32_t :4;
  uint32_t DMAMD:1;
  uint32_t :15;
  uint32_t RNGMD:1;
} __PMD7bits_t;
extern volatile __PMD7bits_t PMD7bits __asm__ ("PMD7") __attribute__((section("sfrs"), address(0xBF8000A0)));
extern volatile uint32_t        PMD7CLR __attribute__((section("sfrs"),address(0xBF8000A4)));
extern volatile uint32_t        PMD7SET __attribute__((section("sfrs"),address(0xBF8000A8)));
extern volatile uint32_t        PMD7INV __attribute__((section("sfrs"),address(0xBF8000AC)));
#define CFGPG CFGPG
extern volatile uint32_t   CFGPG __attribute__((section("sfrs"), address(0xBF8000E0)));
typedef struct {
  uint32_t CPUPG:2;
  uint32_t :2;
  uint32_t DMAPG:2;
  uint32_t :2;
  uint32_t USBPG:2;
  uint32_t :2;
  uint32_t CAN1PG:2;
  uint32_t CAN2PG:2;
  uint32_t ETHPG:2;
  uint32_t :2;
  uint32_t SQI1PG:2;
  uint32_t FCPG:2;
  uint32_t :6;
  uint32_t ICD1PG:2;
} __CFGPGbits_t;
extern volatile __CFGPGbits_t CFGPGbits __asm__ ("CFGPG") __attribute__((section("sfrs"), address(0xBF8000E0)));
#define NVMCON NVMCON
extern volatile uint32_t   NVMCON __attribute__((section("sfrs"), address(0xBF800600)));
typedef union {
  struct {
    uint32_t NVMOP:4;
    uint32_t :2;
    uint32_t BFSWAP:1;
    uint32_t PFSWAP:1;
    uint32_t :4;
    uint32_t LVDERR:1;
    uint32_t WRERR:1;
    uint32_t WREN:1;
    uint32_t WR:1;
  };
  struct {
    uint32_t NVMOP0:1;
    uint32_t NVMOP1:1;
    uint32_t NVMOP2:1;
    uint32_t NVMOP3:1;
    uint32_t :3;
    uint32_t SWAP:1;
  };
  struct {
    uint32_t PROGOP:4;
  };
  struct {
    uint32_t PROGOP0:1;
    uint32_t PROGOP1:1;
    uint32_t PROGOP2:1;
    uint32_t PROGOP3:1;
  };
  struct {
    uint32_t w:32;
  };
} __NVMCONbits_t;
extern volatile __NVMCONbits_t NVMCONbits __asm__ ("NVMCON") __attribute__((section("sfrs"), address(0xBF800600)));
extern volatile uint32_t        NVMCONCLR __attribute__((section("sfrs"),address(0xBF800604)));
extern volatile uint32_t        NVMCONSET __attribute__((section("sfrs"),address(0xBF800608)));
extern volatile uint32_t        NVMCONINV __attribute__((section("sfrs"),address(0xBF80060C)));
#define NVMKEY NVMKEY
extern volatile uint32_t   NVMKEY __attribute__((section("sfrs"), address(0xBF800610)));
#define NVMADDR NVMADDR
extern volatile uint32_t   NVMADDR __attribute__((section("sfrs"), address(0xBF800620)));
extern volatile uint32_t        NVMADDRCLR __attribute__((section("sfrs"),address(0xBF800624)));
extern volatile uint32_t        NVMADDRSET __attribute__((section("sfrs"),address(0xBF800628)));
extern volatile uint32_t        NVMADDRINV __attribute__((section("sfrs"),address(0xBF80062C)));
#define NVMDATA0 NVMDATA0
extern volatile uint32_t   NVMDATA0 __attribute__((section("sfrs"), address(0xBF800630)));
extern volatile uint32_t        NVMDATA0CLR __attribute__((section("sfrs"),address(0xBF800634)));
extern volatile uint32_t        NVMDATA0SET __attribute__((section("sfrs"),address(0xBF800638)));
extern volatile uint32_t        NVMDATA0INV __attribute__((section("sfrs"),address(0xBF80063C)));
#define NVMDATA1 NVMDATA1
extern volatile uint32_t   NVMDATA1 __attribute__((section("sfrs"), address(0xBF800640)));
extern volatile uint32_t        NVMDATA1CLR __attribute__((section("sfrs"),address(0xBF800644)));
extern volatile uint32_t        NVMDATA1SET __attribute__((section("sfrs"),address(0xBF800648)));
extern volatile uint32_t        NVMDATA1INV __attribute__((section("sfrs"),address(0xBF80064C)));
#define NVMDATA2 NVMDATA2
extern volatile uint32_t   NVMDATA2 __attribute__((section("sfrs"), address(0xBF800650)));
extern volatile uint32_t        NVMDATA2CLR __attribute__((section("sfrs"),address(0xBF800654)));
extern volatile uint32_t        NVMDATA2SET __attribute__((section("sfrs"),address(0xBF800658)));
extern volatile uint32_t        NVMDATA2INV __attribute__((section("sfrs"),address(0xBF80065C)));
#define NVMDATA3 NVMDATA3
extern volatile uint32_t   NVMDATA3 __attribute__((section("sfrs"), address(0xBF800660)));
extern volatile uint32_t        NVMDATA3CLR __attribute__((section("sfrs"),address(0xBF800664)));
extern volatile uint32_t        NVMDATA3SET __attribute__((section("sfrs"),address(0xBF800668)));
extern volatile uint32_t        NVMDATA3INV __attribute__((section("sfrs"),address(0xBF80066C)));
#define NVMSRCADDR NVMSRCADDR
extern volatile uint32_t   NVMSRCADDR __attribute__((section("sfrs"), address(0xBF800670)));
extern volatile uint32_t        NVMSRCADDRCLR __attribute__((section("sfrs"),address(0xBF800674)));
extern volatile uint32_t        NVMSRCADDRSET __attribute__((section("sfrs"),address(0xBF800678)));
extern volatile uint32_t        NVMSRCADDRINV __attribute__((section("sfrs"),address(0xBF80067C)));
#define NVMPWP NVMPWP
extern volatile uint32_t   NVMPWP __attribute__((section("sfrs"), address(0xBF800680)));
typedef struct {
  uint32_t PWP:24;
  uint32_t :7;
  uint32_t PWPULOCK:1;
} __NVMPWPbits_t;
extern volatile __NVMPWPbits_t NVMPWPbits __asm__ ("NVMPWP") __attribute__((section("sfrs"), address(0xBF800680)));
extern volatile uint32_t        NVMPWPCLR __attribute__((section("sfrs"),address(0xBF800684)));
extern volatile uint32_t        NVMPWPSET __attribute__((section("sfrs"),address(0xBF800688)));
extern volatile uint32_t        NVMPWPINV __attribute__((section("sfrs"),address(0xBF80068C)));
#define NVMBWP NVMBWP
extern volatile uint32_t   NVMBWP __attribute__((section("sfrs"), address(0xBF800690)));
typedef struct {
  uint32_t UBWP0:1;
  uint32_t UBWP1:1;
  uint32_t UBWP2:1;
  uint32_t UBWP3:1;
  uint32_t UBWP4:1;
  uint32_t :2;
  uint32_t UBWPULOCK:1;
  uint32_t LBWP0:1;
  uint32_t LBWP1:1;
  uint32_t LBWP2:1;
  uint32_t LBWP3:1;
  uint32_t LBWP4:1;
  uint32_t :2;
  uint32_t LBWPULOCK:1;
} __NVMBWPbits_t;
extern volatile __NVMBWPbits_t NVMBWPbits __asm__ ("NVMBWP") __attribute__((section("sfrs"), address(0xBF800690)));
extern volatile uint32_t        NVMBWPCLR __attribute__((section("sfrs"),address(0xBF800694)));
extern volatile uint32_t        NVMBWPSET __attribute__((section("sfrs"),address(0xBF800698)));
extern volatile uint32_t        NVMBWPINV __attribute__((section("sfrs"),address(0xBF80069C)));
#define NVMCON2 NVMCON2
extern volatile uint32_t   NVMCON2 __attribute__((section("sfrs"), address(0xBF8006A0)));
typedef struct {
  uint32_t :6;
  uint32_t SWAPLOCK:2;
} __NVMCON2bits_t;
extern volatile __NVMCON2bits_t NVMCON2bits __asm__ ("NVMCON2") __attribute__((section("sfrs"), address(0xBF8006A0)));
extern volatile uint32_t        NVMCON2CLR __attribute__((section("sfrs"),address(0xBF8006A4)));
extern volatile uint32_t        NVMCON2SET __attribute__((section("sfrs"),address(0xBF8006A8)));
extern volatile uint32_t        NVMCON2INV __attribute__((section("sfrs"),address(0xBF8006AC)));
#define WDTCON WDTCON
extern volatile uint32_t   WDTCON __attribute__((section("sfrs"), address(0xBF800800)));
typedef struct {
  uint32_t WDTWINEN:1;
  uint32_t :7;
  uint32_t RUNDIV:5;
  uint32_t :2;
  uint32_t ON:1;
  uint32_t WDTCLRKEY:16;
} __WDTCONbits_t;
extern volatile __WDTCONbits_t WDTCONbits __asm__ ("WDTCON") __attribute__((section("sfrs"), address(0xBF800800)));
extern volatile uint32_t        WDTCONCLR __attribute__((section("sfrs"),address(0xBF800804)));
extern volatile uint32_t        WDTCONSET __attribute__((section("sfrs"),address(0xBF800808)));
extern volatile uint32_t        WDTCONINV __attribute__((section("sfrs"),address(0xBF80080C)));
#define DMTCON DMTCON
extern volatile uint32_t   DMTCON __attribute__((section("sfrs"), address(0xBF800A00)));
typedef struct {
  uint32_t :15;
  uint32_t ON:1;
} __DMTCONbits_t;
extern volatile __DMTCONbits_t DMTCONbits __asm__ ("DMTCON") __attribute__((section("sfrs"), address(0xBF800A00)));
#define DMTPRECLR DMTPRECLR
extern volatile uint32_t   DMTPRECLR __attribute__((section("sfrs"), address(0xBF800A10)));
typedef struct {
  uint32_t :8;
  uint32_t STEP1:8;
} __DMTPRECLRbits_t;
extern volatile __DMTPRECLRbits_t DMTPRECLRbits __asm__ ("DMTPRECLR") __attribute__((section("sfrs"), address(0xBF800A10)));
#define DMTCLR DMTCLR
extern volatile uint32_t   DMTCLR __attribute__((section("sfrs"), address(0xBF800A20)));
typedef struct {
  uint32_t STEP2:8;
} __DMTCLRbits_t;
extern volatile __DMTCLRbits_t DMTCLRbits __asm__ ("DMTCLR") __attribute__((section("sfrs"), address(0xBF800A20)));
#define DMTSTAT DMTSTAT
extern volatile uint32_t   DMTSTAT __attribute__((section("sfrs"), address(0xBF800A30)));
typedef union {
  struct {
    uint32_t WINOPN:1;
    uint32_t :4;
    uint32_t DMTEVENT:1;
    uint32_t BAD:2;
  };
  struct {
    uint32_t :6;
    uint32_t BAD2:1;
    uint32_t BAD1:1;
  };
  struct {
    uint32_t w:32;
  };
} __DMTSTATbits_t;
extern volatile __DMTSTATbits_t DMTSTATbits __asm__ ("DMTSTAT") __attribute__((section("sfrs"), address(0xBF800A30)));
#define DMTCNT DMTCNT
extern volatile uint32_t   DMTCNT __attribute__((section("sfrs"), address(0xBF800A40)));
typedef struct {
  uint32_t COUNTER:32;
} __DMTCNTbits_t;
extern volatile __DMTCNTbits_t DMTCNTbits __asm__ ("DMTCNT") __attribute__((section("sfrs"), address(0xBF800A40)));
#define DMTPSCNT DMTPSCNT
extern volatile uint32_t   DMTPSCNT __attribute__((section("sfrs"), address(0xBF800A60)));
typedef struct {
  uint32_t PSCNT:32;
} __DMTPSCNTbits_t;
extern volatile __DMTPSCNTbits_t DMTPSCNTbits __asm__ ("DMTPSCNT") __attribute__((section("sfrs"), address(0xBF800A60)));
#define DMTPSINTV DMTPSINTV
extern volatile uint32_t   DMTPSINTV __attribute__((section("sfrs"), address(0xBF800A70)));
typedef struct {
  uint32_t PSINTV:32;
} __DMTPSINTVbits_t;
extern volatile __DMTPSINTVbits_t DMTPSINTVbits __asm__ ("DMTPSINTV") __attribute__((section("sfrs"), address(0xBF800A70)));
#define RTCCON RTCCON
extern volatile uint32_t   RTCCON __attribute__((section("sfrs"), address(0xBF800C00)));
typedef union {
  struct {
    uint32_t RTCOE:1;
    uint32_t HALFSEC:1;
    uint32_t RTCSYNC:1;
    uint32_t RTCWREN:1;
    uint32_t :2;
    uint32_t RTCCLKON:1;
    uint32_t RTCOUTSEL:2;
    uint32_t RTCCLKSEL:2;
    uint32_t :2;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t CAL:10;
  };
  struct {
    uint32_t w:32;
  };
} __RTCCONbits_t;
extern volatile __RTCCONbits_t RTCCONbits __asm__ ("RTCCON") __attribute__((section("sfrs"), address(0xBF800C00)));
extern volatile uint32_t        RTCCONCLR __attribute__((section("sfrs"),address(0xBF800C04)));
extern volatile uint32_t        RTCCONSET __attribute__((section("sfrs"),address(0xBF800C08)));
extern volatile uint32_t        RTCCONINV __attribute__((section("sfrs"),address(0xBF800C0C)));
#define RTCALRM RTCALRM
extern volatile uint32_t   RTCALRM __attribute__((section("sfrs"), address(0xBF800C10)));
typedef union {
  struct {
    uint32_t ARPT:8;
    uint32_t AMASK:4;
    uint32_t ALRMSYNC:1;
    uint32_t PIV:1;
    uint32_t CHIME:1;
    uint32_t ALRMEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __RTCALRMbits_t;
extern volatile __RTCALRMbits_t RTCALRMbits __asm__ ("RTCALRM") __attribute__((section("sfrs"), address(0xBF800C10)));
extern volatile uint32_t        RTCALRMCLR __attribute__((section("sfrs"),address(0xBF800C14)));
extern volatile uint32_t        RTCALRMSET __attribute__((section("sfrs"),address(0xBF800C18)));
extern volatile uint32_t        RTCALRMINV __attribute__((section("sfrs"),address(0xBF800C1C)));
#define RTCTIME RTCTIME
extern volatile uint32_t   RTCTIME __attribute__((section("sfrs"), address(0xBF800C20)));
typedef union {
  struct {
    uint32_t :8;
    uint32_t SEC01:4;
    uint32_t SEC10:4;
    uint32_t MIN01:4;
    uint32_t MIN10:4;
    uint32_t HR01:4;
    uint32_t HR10:4;
  };
  struct {
    uint32_t w:32;
  };
} __RTCTIMEbits_t;
extern volatile __RTCTIMEbits_t RTCTIMEbits __asm__ ("RTCTIME") __attribute__((section("sfrs"), address(0xBF800C20)));
extern volatile uint32_t        RTCTIMECLR __attribute__((section("sfrs"),address(0xBF800C24)));
extern volatile uint32_t        RTCTIMESET __attribute__((section("sfrs"),address(0xBF800C28)));
extern volatile uint32_t        RTCTIMEINV __attribute__((section("sfrs"),address(0xBF800C2C)));
#define RTCDATE RTCDATE
extern volatile uint32_t   RTCDATE __attribute__((section("sfrs"), address(0xBF800C30)));
typedef union {
  struct {
    uint32_t WDAY01:4;
    uint32_t :4;
    uint32_t DAY01:4;
    uint32_t DAY10:4;
    uint32_t MONTH01:4;
    uint32_t MONTH10:4;
    uint32_t YEAR01:4;
    uint32_t YEAR10:4;
  };
  struct {
    uint32_t w:32;
  };
} __RTCDATEbits_t;
extern volatile __RTCDATEbits_t RTCDATEbits __asm__ ("RTCDATE") __attribute__((section("sfrs"), address(0xBF800C30)));
extern volatile uint32_t        RTCDATECLR __attribute__((section("sfrs"),address(0xBF800C34)));
extern volatile uint32_t        RTCDATESET __attribute__((section("sfrs"),address(0xBF800C38)));
extern volatile uint32_t        RTCDATEINV __attribute__((section("sfrs"),address(0xBF800C3C)));
#define ALRMTIME ALRMTIME
extern volatile uint32_t   ALRMTIME __attribute__((section("sfrs"), address(0xBF800C40)));
typedef union {
  struct {
    uint32_t :8;
    uint32_t SEC01:4;
    uint32_t SEC10:4;
    uint32_t MIN01:4;
    uint32_t MIN10:4;
    uint32_t HR01:4;
    uint32_t HR10:4;
  };
  struct {
    uint32_t w:32;
  };
} __ALRMTIMEbits_t;
extern volatile __ALRMTIMEbits_t ALRMTIMEbits __asm__ ("ALRMTIME") __attribute__((section("sfrs"), address(0xBF800C40)));
extern volatile uint32_t        ALRMTIMECLR __attribute__((section("sfrs"),address(0xBF800C44)));
extern volatile uint32_t        ALRMTIMESET __attribute__((section("sfrs"),address(0xBF800C48)));
extern volatile uint32_t        ALRMTIMEINV __attribute__((section("sfrs"),address(0xBF800C4C)));
#define ALRMDATE ALRMDATE
extern volatile uint32_t   ALRMDATE __attribute__((section("sfrs"), address(0xBF800C50)));
typedef union {
  struct {
    uint32_t WDAY01:4;
    uint32_t :4;
    uint32_t DAY01:4;
    uint32_t DAY10:4;
    uint32_t MONTH01:4;
    uint32_t MONTH10:4;
  };
  struct {
    uint32_t w:32;
  };
} __ALRMDATEbits_t;
extern volatile __ALRMDATEbits_t ALRMDATEbits __asm__ ("ALRMDATE") __attribute__((section("sfrs"), address(0xBF800C50)));
extern volatile uint32_t        ALRMDATECLR __attribute__((section("sfrs"),address(0xBF800C54)));
extern volatile uint32_t        ALRMDATESET __attribute__((section("sfrs"),address(0xBF800C58)));
extern volatile uint32_t        ALRMDATEINV __attribute__((section("sfrs"),address(0xBF800C5C)));
#define CVRCON CVRCON
extern volatile uint32_t   CVRCON __attribute__((section("sfrs"), address(0xBF800E00)));
typedef union {
  struct {
    uint32_t CVR:4;
    uint32_t CVRSS:1;
    uint32_t CVRR:1;
    uint32_t CVROE:1;
    uint32_t :8;
    uint32_t ON:1;
  };
  struct {
    uint32_t CVR0:1;
    uint32_t CVR1:1;
    uint32_t CVR2:1;
    uint32_t CVR3:1;
  };
  struct {
    uint32_t w:32;
  };
} __CVRCONbits_t;
extern volatile __CVRCONbits_t CVRCONbits __asm__ ("CVRCON") __attribute__((section("sfrs"), address(0xBF800E00)));
extern volatile uint32_t        CVRCONCLR __attribute__((section("sfrs"),address(0xBF800E04)));
extern volatile uint32_t        CVRCONSET __attribute__((section("sfrs"),address(0xBF800E08)));
extern volatile uint32_t        CVRCONINV __attribute__((section("sfrs"),address(0xBF800E0C)));
#define _ICDCON _ICDCON
extern volatile uint32_t   _ICDCON __attribute__((section("sfrs"), address(0xBF801130)));
typedef struct {
  uint32_t CKSWBKEN:1;
  uint32_t SLPBKEN:1;
  uint32_t WDTBKEN:1;
  uint32_t WDTEN:1;
  uint32_t RSTBUG:1;
  uint32_t DMTBKEN:1;
  uint32_t DMTEN:1;
  uint32_t :7;
  uint32_t FRZ:1;
} ___ICDCONbits_t;
extern volatile ___ICDCONbits_t _ICDCONbits __asm__ ("_ICDCON") __attribute__((section("sfrs"), address(0xBF801130)));
#define _ICDSTAT _ICDSTAT
extern volatile uint32_t   _ICDSTAT __attribute__((section("sfrs"), address(0xBF801140)));
typedef struct {
  uint32_t CKSWBF:1;
  uint32_t SLPBF:1;
  uint32_t WDTBF:1;
  uint32_t DMTBF:1;
} ___ICDSTATbits_t;
extern volatile ___ICDSTATbits_t _ICDSTATbits __asm__ ("_ICDSTAT") __attribute__((section("sfrs"), address(0xBF801140)));
#define OSCCON OSCCON
extern volatile uint32_t   OSCCON __attribute__((section("sfrs"), address(0xBF801200)));
typedef struct {
  uint32_t OSWEN:1;
  uint32_t SOSCEN:1;
  uint32_t :1;
  uint32_t CF:1;
  uint32_t SLPEN:1;
  uint32_t :2;
  uint32_t CLKLOCK:1;
  uint32_t NOSC:3;
  uint32_t :1;
  uint32_t COSC:3;
  uint32_t :6;
  uint32_t SLP2SPD:1;
  uint32_t :1;
  uint32_t DRMEN:1;
  uint32_t FRCDIV:3;
} __OSCCONbits_t;
extern volatile __OSCCONbits_t OSCCONbits __asm__ ("OSCCON") __attribute__((section("sfrs"), address(0xBF801200)));
extern volatile uint32_t        OSCCONCLR __attribute__((section("sfrs"),address(0xBF801204)));
extern volatile uint32_t        OSCCONSET __attribute__((section("sfrs"),address(0xBF801208)));
extern volatile uint32_t        OSCCONINV __attribute__((section("sfrs"),address(0xBF80120C)));
#define OSCTUN OSCTUN
extern volatile uint32_t   OSCTUN __attribute__((section("sfrs"), address(0xBF801210)));
typedef struct {
  uint32_t TUN:6;
} __OSCTUNbits_t;
extern volatile __OSCTUNbits_t OSCTUNbits __asm__ ("OSCTUN") __attribute__((section("sfrs"), address(0xBF801210)));
extern volatile uint32_t        OSCTUNCLR __attribute__((section("sfrs"),address(0xBF801214)));
extern volatile uint32_t        OSCTUNSET __attribute__((section("sfrs"),address(0xBF801218)));
extern volatile uint32_t        OSCTUNINV __attribute__((section("sfrs"),address(0xBF80121C)));
#define SPLLCON SPLLCON
extern volatile uint32_t   SPLLCON __attribute__((section("sfrs"), address(0xBF801220)));
typedef struct {
  uint32_t PLLRANGE:3;
  uint32_t :4;
  uint32_t PLLICLK:1;
  uint32_t PLLIDIV:3;
  uint32_t :5;
  uint32_t PLLMULT:7;
  uint32_t :1;
  uint32_t PLLODIV:3;
} __SPLLCONbits_t;
extern volatile __SPLLCONbits_t SPLLCONbits __asm__ ("SPLLCON") __attribute__((section("sfrs"), address(0xBF801220)));
extern volatile uint32_t        SPLLCONCLR __attribute__((section("sfrs"),address(0xBF801224)));
extern volatile uint32_t        SPLLCONSET __attribute__((section("sfrs"),address(0xBF801228)));
extern volatile uint32_t        SPLLCONINV __attribute__((section("sfrs"),address(0xBF80122C)));
#define RCON RCON
extern volatile uint32_t   RCON __attribute__((section("sfrs"), address(0xBF801240)));
typedef struct {
  uint32_t POR:1;
  uint32_t BOR:1;
  uint32_t IDLE:1;
  uint32_t SLEEP:1;
  uint32_t WDTO:1;
  uint32_t DMTO:1;
  uint32_t SWR:1;
  uint32_t EXTR:1;
  uint32_t :1;
  uint32_t CMR:1;
  uint32_t :16;
  uint32_t BCFGFAIL:1;
  uint32_t BCFGERR:1;
} __RCONbits_t;
extern volatile __RCONbits_t RCONbits __asm__ ("RCON") __attribute__((section("sfrs"), address(0xBF801240)));
extern volatile uint32_t        RCONCLR __attribute__((section("sfrs"),address(0xBF801244)));
extern volatile uint32_t        RCONSET __attribute__((section("sfrs"),address(0xBF801248)));
extern volatile uint32_t        RCONINV __attribute__((section("sfrs"),address(0xBF80124C)));
#define RSWRST RSWRST
extern volatile uint32_t   RSWRST __attribute__((section("sfrs"), address(0xBF801250)));
typedef struct {
  uint32_t SWRST:1;
} __RSWRSTbits_t;
extern volatile __RSWRSTbits_t RSWRSTbits __asm__ ("RSWRST") __attribute__((section("sfrs"), address(0xBF801250)));
extern volatile uint32_t        RSWRSTCLR __attribute__((section("sfrs"),address(0xBF801254)));
extern volatile uint32_t        RSWRSTSET __attribute__((section("sfrs"),address(0xBF801258)));
extern volatile uint32_t        RSWRSTINV __attribute__((section("sfrs"),address(0xBF80125C)));
#define RNMICON RNMICON
extern volatile uint32_t   RNMICON __attribute__((section("sfrs"), address(0xBF801260)));
typedef union {
  struct {
    uint32_t NMICNT:16;
    uint32_t WDTS:1;
    uint32_t CF:1;
    uint32_t :1;
    uint32_t GNMI:1;
    uint32_t :3;
    uint32_t SWNMI:1;
    uint32_t WDTO:1;
    uint32_t DMTO:1;
  };
  struct {
    uint32_t :24;
    uint32_t WDTR:1;
  };
} __RNMICONbits_t;
extern volatile __RNMICONbits_t RNMICONbits __asm__ ("RNMICON") __attribute__((section("sfrs"), address(0xBF801260)));
extern volatile uint32_t        RNMICONCLR __attribute__((section("sfrs"),address(0xBF801264)));
extern volatile uint32_t        RNMICONSET __attribute__((section("sfrs"),address(0xBF801268)));
extern volatile uint32_t        RNMICONINV __attribute__((section("sfrs"),address(0xBF80126C)));
#define PWRCON PWRCON
extern volatile uint32_t   PWRCON __attribute__((section("sfrs"), address(0xBF801270)));
typedef struct {
  uint32_t VREGS:1;
} __PWRCONbits_t;
extern volatile __PWRCONbits_t PWRCONbits __asm__ ("PWRCON") __attribute__((section("sfrs"), address(0xBF801270)));
extern volatile uint32_t        PWRCONCLR __attribute__((section("sfrs"),address(0xBF801274)));
extern volatile uint32_t        PWRCONSET __attribute__((section("sfrs"),address(0xBF801278)));
extern volatile uint32_t        PWRCONINV __attribute__((section("sfrs"),address(0xBF80127C)));
#define REFO1CON REFO1CON
extern volatile uint32_t   REFO1CON __attribute__((section("sfrs"), address(0xBF801280)));
typedef struct {
  uint32_t ROSEL:4;
  uint32_t :4;
  uint32_t ACTIVE:1;
  uint32_t DIVSWEN:1;
  uint32_t :1;
  uint32_t RSLP:1;
  uint32_t OE:1;
  uint32_t SIDL:1;
  uint32_t :1;
  uint32_t ON:1;
  uint32_t RODIV:15;
} __REFO1CONbits_t;
extern volatile __REFO1CONbits_t REFO1CONbits __asm__ ("REFO1CON") __attribute__((section("sfrs"), address(0xBF801280)));
extern volatile uint32_t        REFO1CONCLR __attribute__((section("sfrs"),address(0xBF801284)));
extern volatile uint32_t        REFO1CONSET __attribute__((section("sfrs"),address(0xBF801288)));
extern volatile uint32_t        REFO1CONINV __attribute__((section("sfrs"),address(0xBF80128C)));
#define REFO1TRIM REFO1TRIM
extern volatile uint32_t   REFO1TRIM __attribute__((section("sfrs"), address(0xBF801290)));
typedef struct {
  uint32_t :23;
  uint32_t ROTRIM:9;
} __REFO1TRIMbits_t;
extern volatile __REFO1TRIMbits_t REFO1TRIMbits __asm__ ("REFO1TRIM") __attribute__((section("sfrs"), address(0xBF801290)));
extern volatile uint32_t        REFO1TRIMCLR __attribute__((section("sfrs"),address(0xBF801294)));
extern volatile uint32_t        REFO1TRIMSET __attribute__((section("sfrs"),address(0xBF801298)));
extern volatile uint32_t        REFO1TRIMINV __attribute__((section("sfrs"),address(0xBF80129C)));
#define REFO2CON REFO2CON
extern volatile uint32_t   REFO2CON __attribute__((section("sfrs"), address(0xBF8012A0)));
typedef struct {
  uint32_t ROSEL:4;
  uint32_t :4;
  uint32_t ACTIVE:1;
  uint32_t DIVSWEN:1;
  uint32_t :1;
  uint32_t RSLP:1;
  uint32_t OE:1;
  uint32_t SIDL:1;
  uint32_t :1;
  uint32_t ON:1;
  uint32_t RODIV:15;
} __REFO2CONbits_t;
extern volatile __REFO2CONbits_t REFO2CONbits __asm__ ("REFO2CON") __attribute__((section("sfrs"), address(0xBF8012A0)));
extern volatile uint32_t        REFO2CONCLR __attribute__((section("sfrs"),address(0xBF8012A4)));
extern volatile uint32_t        REFO2CONSET __attribute__((section("sfrs"),address(0xBF8012A8)));
extern volatile uint32_t        REFO2CONINV __attribute__((section("sfrs"),address(0xBF8012AC)));
#define REFO2TRIM REFO2TRIM
extern volatile uint32_t   REFO2TRIM __attribute__((section("sfrs"), address(0xBF8012B0)));
typedef struct {
  uint32_t :23;
  uint32_t ROTRIM:9;
} __REFO2TRIMbits_t;
extern volatile __REFO2TRIMbits_t REFO2TRIMbits __asm__ ("REFO2TRIM") __attribute__((section("sfrs"), address(0xBF8012B0)));
extern volatile uint32_t        REFO2TRIMCLR __attribute__((section("sfrs"),address(0xBF8012B4)));
extern volatile uint32_t        REFO2TRIMSET __attribute__((section("sfrs"),address(0xBF8012B8)));
extern volatile uint32_t        REFO2TRIMINV __attribute__((section("sfrs"),address(0xBF8012BC)));
#define REFO3CON REFO3CON
extern volatile uint32_t   REFO3CON __attribute__((section("sfrs"), address(0xBF8012C0)));
typedef struct {
  uint32_t ROSEL:4;
  uint32_t :4;
  uint32_t ACTIVE:1;
  uint32_t DIVSWEN:1;
  uint32_t :1;
  uint32_t RSLP:1;
  uint32_t OE:1;
  uint32_t SIDL:1;
  uint32_t :1;
  uint32_t ON:1;
  uint32_t RODIV:15;
} __REFO3CONbits_t;
extern volatile __REFO3CONbits_t REFO3CONbits __asm__ ("REFO3CON") __attribute__((section("sfrs"), address(0xBF8012C0)));
extern volatile uint32_t        REFO3CONCLR __attribute__((section("sfrs"),address(0xBF8012C4)));
extern volatile uint32_t        REFO3CONSET __attribute__((section("sfrs"),address(0xBF8012C8)));
extern volatile uint32_t        REFO3CONINV __attribute__((section("sfrs"),address(0xBF8012CC)));
#define REFO3TRIM REFO3TRIM
extern volatile uint32_t   REFO3TRIM __attribute__((section("sfrs"), address(0xBF8012D0)));
typedef struct {
  uint32_t :23;
  uint32_t ROTRIM:9;
} __REFO3TRIMbits_t;
extern volatile __REFO3TRIMbits_t REFO3TRIMbits __asm__ ("REFO3TRIM") __attribute__((section("sfrs"), address(0xBF8012D0)));
extern volatile uint32_t        REFO3TRIMCLR __attribute__((section("sfrs"),address(0xBF8012D4)));
extern volatile uint32_t        REFO3TRIMSET __attribute__((section("sfrs"),address(0xBF8012D8)));
extern volatile uint32_t        REFO3TRIMINV __attribute__((section("sfrs"),address(0xBF8012DC)));
#define REFO4CON REFO4CON
extern volatile uint32_t   REFO4CON __attribute__((section("sfrs"), address(0xBF8012E0)));
typedef struct {
  uint32_t ROSEL:4;
  uint32_t :4;
  uint32_t ACTIVE:1;
  uint32_t DIVSWEN:1;
  uint32_t :1;
  uint32_t RSLP:1;
  uint32_t OE:1;
  uint32_t SIDL:1;
  uint32_t :1;
  uint32_t ON:1;
  uint32_t RODIV:15;
} __REFO4CONbits_t;
extern volatile __REFO4CONbits_t REFO4CONbits __asm__ ("REFO4CON") __attribute__((section("sfrs"), address(0xBF8012E0)));
extern volatile uint32_t        REFO4CONCLR __attribute__((section("sfrs"),address(0xBF8012E4)));
extern volatile uint32_t        REFO4CONSET __attribute__((section("sfrs"),address(0xBF8012E8)));
extern volatile uint32_t        REFO4CONINV __attribute__((section("sfrs"),address(0xBF8012EC)));
#define REFO4TRIM REFO4TRIM
extern volatile uint32_t   REFO4TRIM __attribute__((section("sfrs"), address(0xBF8012F0)));
typedef struct {
  uint32_t :23;
  uint32_t ROTRIM:9;
} __REFO4TRIMbits_t;
extern volatile __REFO4TRIMbits_t REFO4TRIMbits __asm__ ("REFO4TRIM") __attribute__((section("sfrs"), address(0xBF8012F0)));
extern volatile uint32_t        REFO4TRIMCLR __attribute__((section("sfrs"),address(0xBF8012F4)));
extern volatile uint32_t        REFO4TRIMSET __attribute__((section("sfrs"),address(0xBF8012F8)));
extern volatile uint32_t        REFO4TRIMINV __attribute__((section("sfrs"),address(0xBF8012FC)));
#define PB1DIV PB1DIV
extern volatile uint32_t   PB1DIV __attribute__((section("sfrs"), address(0xBF801300)));
typedef struct {
  uint32_t PBDIV:7;
  uint32_t :4;
  uint32_t PBDIVRDY:1;
} __PB1DIVbits_t;
extern volatile __PB1DIVbits_t PB1DIVbits __asm__ ("PB1DIV") __attribute__((section("sfrs"), address(0xBF801300)));
extern volatile uint32_t        PB1DIVCLR __attribute__((section("sfrs"),address(0xBF801304)));
extern volatile uint32_t        PB1DIVSET __attribute__((section("sfrs"),address(0xBF801308)));
extern volatile uint32_t        PB1DIVINV __attribute__((section("sfrs"),address(0xBF80130C)));
#define PB2DIV PB2DIV
extern volatile uint32_t   PB2DIV __attribute__((section("sfrs"), address(0xBF801310)));
typedef struct {
  uint32_t PBDIV:7;
  uint32_t :4;
  uint32_t PBDIVRDY:1;
  uint32_t :3;
  uint32_t ON:1;
} __PB2DIVbits_t;
extern volatile __PB2DIVbits_t PB2DIVbits __asm__ ("PB2DIV") __attribute__((section("sfrs"), address(0xBF801310)));
extern volatile uint32_t        PB2DIVCLR __attribute__((section("sfrs"),address(0xBF801314)));
extern volatile uint32_t        PB2DIVSET __attribute__((section("sfrs"),address(0xBF801318)));
extern volatile uint32_t        PB2DIVINV __attribute__((section("sfrs"),address(0xBF80131C)));
#define PB3DIV PB3DIV
extern volatile uint32_t   PB3DIV __attribute__((section("sfrs"), address(0xBF801320)));
typedef struct {
  uint32_t PBDIV:7;
  uint32_t :4;
  uint32_t PBDIVRDY:1;
  uint32_t :3;
  uint32_t ON:1;
} __PB3DIVbits_t;
extern volatile __PB3DIVbits_t PB3DIVbits __asm__ ("PB3DIV") __attribute__((section("sfrs"), address(0xBF801320)));
extern volatile uint32_t        PB3DIVCLR __attribute__((section("sfrs"),address(0xBF801324)));
extern volatile uint32_t        PB3DIVSET __attribute__((section("sfrs"),address(0xBF801328)));
extern volatile uint32_t        PB3DIVINV __attribute__((section("sfrs"),address(0xBF80132C)));
#define PB4DIV PB4DIV
extern volatile uint32_t   PB4DIV __attribute__((section("sfrs"), address(0xBF801330)));
typedef struct {
  uint32_t PBDIV:7;
  uint32_t :4;
  uint32_t PBDIVRDY:1;
  uint32_t :3;
  uint32_t ON:1;
} __PB4DIVbits_t;
extern volatile __PB4DIVbits_t PB4DIVbits __asm__ ("PB4DIV") __attribute__((section("sfrs"), address(0xBF801330)));
extern volatile uint32_t        PB4DIVCLR __attribute__((section("sfrs"),address(0xBF801334)));
extern volatile uint32_t        PB4DIVSET __attribute__((section("sfrs"),address(0xBF801338)));
extern volatile uint32_t        PB4DIVINV __attribute__((section("sfrs"),address(0xBF80133C)));
#define PB5DIV PB5DIV
extern volatile uint32_t   PB5DIV __attribute__((section("sfrs"), address(0xBF801340)));
typedef struct {
  uint32_t PBDIV:7;
  uint32_t :4;
  uint32_t PBDIVRDY:1;
  uint32_t :3;
  uint32_t ON:1;
} __PB5DIVbits_t;
extern volatile __PB5DIVbits_t PB5DIVbits __asm__ ("PB5DIV") __attribute__((section("sfrs"), address(0xBF801340)));
extern volatile uint32_t        PB5DIVCLR __attribute__((section("sfrs"),address(0xBF801344)));
extern volatile uint32_t        PB5DIVSET __attribute__((section("sfrs"),address(0xBF801348)));
extern volatile uint32_t        PB5DIVINV __attribute__((section("sfrs"),address(0xBF80134C)));
#define PB7DIV PB7DIV
extern volatile uint32_t   PB7DIV __attribute__((section("sfrs"), address(0xBF801360)));
typedef struct {
  uint32_t PBDIV:7;
  uint32_t :4;
  uint32_t PBDIVRDY:1;
  uint32_t :3;
  uint32_t ON:1;
} __PB7DIVbits_t;
extern volatile __PB7DIVbits_t PB7DIVbits __asm__ ("PB7DIV") __attribute__((section("sfrs"), address(0xBF801360)));
extern volatile uint32_t        PB7DIVCLR __attribute__((section("sfrs"),address(0xBF801364)));
extern volatile uint32_t        PB7DIVSET __attribute__((section("sfrs"),address(0xBF801368)));
extern volatile uint32_t        PB7DIVINV __attribute__((section("sfrs"),address(0xBF80136C)));
#define PB8DIV PB8DIV
extern volatile uint32_t   PB8DIV __attribute__((section("sfrs"), address(0xBF801370)));
typedef struct {
  uint32_t PBDIV:7;
  uint32_t :4;
  uint32_t PBDIVRDY:1;
  uint32_t :3;
  uint32_t ON:1;
} __PB8DIVbits_t;
extern volatile __PB8DIVbits_t PB8DIVbits __asm__ ("PB8DIV") __attribute__((section("sfrs"), address(0xBF801370)));
extern volatile uint32_t        PB8DIVCLR __attribute__((section("sfrs"),address(0xBF801374)));
extern volatile uint32_t        PB8DIVSET __attribute__((section("sfrs"),address(0xBF801378)));
extern volatile uint32_t        PB8DIVINV __attribute__((section("sfrs"),address(0xBF80137C)));
#define SLEWCON SLEWCON
extern volatile uint32_t   SLEWCON __attribute__((section("sfrs"), address(0xBF8013C0)));
typedef struct {
  uint32_t BUSY:1;
  uint32_t DNEN:1;
  uint32_t UPEN:1;
  uint32_t :5;
  uint32_t SLWDIV:3;
  uint32_t :5;
  uint32_t SYSDIV:4;
} __SLEWCONbits_t;
extern volatile __SLEWCONbits_t SLEWCONbits __asm__ ("SLEWCON") __attribute__((section("sfrs"), address(0xBF8013C0)));
extern volatile uint32_t        SLEWCONCLR __attribute__((section("sfrs"),address(0xBF8013C4)));
extern volatile uint32_t        SLEWCONSET __attribute__((section("sfrs"),address(0xBF8013C8)));
extern volatile uint32_t        SLEWCONINV __attribute__((section("sfrs"),address(0xBF8013CC)));
#define CLKSTAT CLKSTAT
extern volatile uint32_t   CLKSTAT __attribute__((section("sfrs"), address(0xBF8013D0)));
typedef union {
  struct {
    uint32_t FRCRDY:1;
    uint32_t SPDIVRDY:1;
    uint32_t POSCRDY:1;
    uint32_t :1;
    uint32_t SOSCRDY:1;
    uint32_t LPRCRDY:1;
  };
  struct {
    uint32_t :1;
    uint32_t DIVSPLLRDY:1;
  };
} __CLKSTATbits_t;
extern volatile __CLKSTATbits_t CLKSTATbits __asm__ ("CLKSTAT") __attribute__((section("sfrs"), address(0xBF8013D0)));
extern volatile uint32_t        CLKSTATCLR __attribute__((section("sfrs"),address(0xBF8013D4)));
extern volatile uint32_t        CLKSTATSET __attribute__((section("sfrs"),address(0xBF8013D8)));
extern volatile uint32_t        CLKSTATINV __attribute__((section("sfrs"),address(0xBF8013DC)));
#define INT1R INT1R
extern volatile uint32_t   INT1R __attribute__((section("sfrs"), address(0xBF801404)));
typedef struct {
  uint32_t INT1R:4;
} __INT1Rbits_t;
extern volatile __INT1Rbits_t INT1Rbits __asm__ ("INT1R") __attribute__((section("sfrs"), address(0xBF801404)));
#define INT2R INT2R
extern volatile uint32_t   INT2R __attribute__((section("sfrs"), address(0xBF801408)));
typedef struct {
  uint32_t INT2R:4;
} __INT2Rbits_t;
extern volatile __INT2Rbits_t INT2Rbits __asm__ ("INT2R") __attribute__((section("sfrs"), address(0xBF801408)));
#define INT3R INT3R
extern volatile uint32_t   INT3R __attribute__((section("sfrs"), address(0xBF80140C)));
typedef struct {
  uint32_t INT3R:4;
} __INT3Rbits_t;
extern volatile __INT3Rbits_t INT3Rbits __asm__ ("INT3R") __attribute__((section("sfrs"), address(0xBF80140C)));
#define INT4R INT4R
extern volatile uint32_t   INT4R __attribute__((section("sfrs"), address(0xBF801410)));
typedef struct {
  uint32_t INT4R:4;
} __INT4Rbits_t;
extern volatile __INT4Rbits_t INT4Rbits __asm__ ("INT4R") __attribute__((section("sfrs"), address(0xBF801410)));
#define T2CKR T2CKR
extern volatile uint32_t   T2CKR __attribute__((section("sfrs"), address(0xBF801418)));
typedef struct {
  uint32_t T2CKR:4;
} __T2CKRbits_t;
extern volatile __T2CKRbits_t T2CKRbits __asm__ ("T2CKR") __attribute__((section("sfrs"), address(0xBF801418)));
#define T3CKR T3CKR
extern volatile uint32_t   T3CKR __attribute__((section("sfrs"), address(0xBF80141C)));
typedef struct {
  uint32_t T3CKR:4;
} __T3CKRbits_t;
extern volatile __T3CKRbits_t T3CKRbits __asm__ ("T3CKR") __attribute__((section("sfrs"), address(0xBF80141C)));
#define T4CKR T4CKR
extern volatile uint32_t   T4CKR __attribute__((section("sfrs"), address(0xBF801420)));
typedef struct {
  uint32_t T4CKR:4;
} __T4CKRbits_t;
extern volatile __T4CKRbits_t T4CKRbits __asm__ ("T4CKR") __attribute__((section("sfrs"), address(0xBF801420)));
#define T5CKR T5CKR
extern volatile uint32_t   T5CKR __attribute__((section("sfrs"), address(0xBF801424)));
typedef struct {
  uint32_t T5CKR:4;
} __T5CKRbits_t;
extern volatile __T5CKRbits_t T5CKRbits __asm__ ("T5CKR") __attribute__((section("sfrs"), address(0xBF801424)));
#define T6CKR T6CKR
extern volatile uint32_t   T6CKR __attribute__((section("sfrs"), address(0xBF801428)));
typedef struct {
  uint32_t T6CKR:4;
} __T6CKRbits_t;
extern volatile __T6CKRbits_t T6CKRbits __asm__ ("T6CKR") __attribute__((section("sfrs"), address(0xBF801428)));
#define T7CKR T7CKR
extern volatile uint32_t   T7CKR __attribute__((section("sfrs"), address(0xBF80142C)));
typedef struct {
  uint32_t T7CKR:4;
} __T7CKRbits_t;
extern volatile __T7CKRbits_t T7CKRbits __asm__ ("T7CKR") __attribute__((section("sfrs"), address(0xBF80142C)));
#define T8CKR T8CKR
extern volatile uint32_t   T8CKR __attribute__((section("sfrs"), address(0xBF801430)));
typedef struct {
  uint32_t T8CKR:4;
} __T8CKRbits_t;
extern volatile __T8CKRbits_t T8CKRbits __asm__ ("T8CKR") __attribute__((section("sfrs"), address(0xBF801430)));
#define T9CKR T9CKR
extern volatile uint32_t   T9CKR __attribute__((section("sfrs"), address(0xBF801434)));
typedef struct {
  uint32_t T9CKR:4;
} __T9CKRbits_t;
extern volatile __T9CKRbits_t T9CKRbits __asm__ ("T9CKR") __attribute__((section("sfrs"), address(0xBF801434)));
#define IC1R IC1R
extern volatile uint32_t   IC1R __attribute__((section("sfrs"), address(0xBF801438)));
typedef struct {
  uint32_t IC1R:4;
} __IC1Rbits_t;
extern volatile __IC1Rbits_t IC1Rbits __asm__ ("IC1R") __attribute__((section("sfrs"), address(0xBF801438)));
#define IC2R IC2R
extern volatile uint32_t   IC2R __attribute__((section("sfrs"), address(0xBF80143C)));
typedef struct {
  uint32_t IC2R:4;
} __IC2Rbits_t;
extern volatile __IC2Rbits_t IC2Rbits __asm__ ("IC2R") __attribute__((section("sfrs"), address(0xBF80143C)));
#define IC3R IC3R
extern volatile uint32_t   IC3R __attribute__((section("sfrs"), address(0xBF801440)));
typedef struct {
  uint32_t IC3R:4;
} __IC3Rbits_t;
extern volatile __IC3Rbits_t IC3Rbits __asm__ ("IC3R") __attribute__((section("sfrs"), address(0xBF801440)));
#define IC4R IC4R
extern volatile uint32_t   IC4R __attribute__((section("sfrs"), address(0xBF801444)));
typedef struct {
  uint32_t IC4R:4;
} __IC4Rbits_t;
extern volatile __IC4Rbits_t IC4Rbits __asm__ ("IC4R") __attribute__((section("sfrs"), address(0xBF801444)));
#define IC5R IC5R
extern volatile uint32_t   IC5R __attribute__((section("sfrs"), address(0xBF801448)));
typedef struct {
  uint32_t IC5R:4;
} __IC5Rbits_t;
extern volatile __IC5Rbits_t IC5Rbits __asm__ ("IC5R") __attribute__((section("sfrs"), address(0xBF801448)));
#define IC6R IC6R
extern volatile uint32_t   IC6R __attribute__((section("sfrs"), address(0xBF80144C)));
typedef struct {
  uint32_t IC6R:4;
} __IC6Rbits_t;
extern volatile __IC6Rbits_t IC6Rbits __asm__ ("IC6R") __attribute__((section("sfrs"), address(0xBF80144C)));
#define IC7R IC7R
extern volatile uint32_t   IC7R __attribute__((section("sfrs"), address(0xBF801450)));
typedef struct {
  uint32_t IC7R:4;
} __IC7Rbits_t;
extern volatile __IC7Rbits_t IC7Rbits __asm__ ("IC7R") __attribute__((section("sfrs"), address(0xBF801450)));
#define IC8R IC8R
extern volatile uint32_t   IC8R __attribute__((section("sfrs"), address(0xBF801454)));
typedef struct {
  uint32_t IC8R:4;
} __IC8Rbits_t;
extern volatile __IC8Rbits_t IC8Rbits __asm__ ("IC8R") __attribute__((section("sfrs"), address(0xBF801454)));
#define IC9R IC9R
extern volatile uint32_t   IC9R __attribute__((section("sfrs"), address(0xBF801458)));
typedef struct {
  uint32_t IC9R:4;
} __IC9Rbits_t;
extern volatile __IC9Rbits_t IC9Rbits __asm__ ("IC9R") __attribute__((section("sfrs"), address(0xBF801458)));
#define OCFAR OCFAR
extern volatile uint32_t   OCFAR __attribute__((section("sfrs"), address(0xBF801460)));
typedef struct {
  uint32_t OCFAR:4;
} __OCFARbits_t;
extern volatile __OCFARbits_t OCFARbits __asm__ ("OCFAR") __attribute__((section("sfrs"), address(0xBF801460)));
#define U1RXR U1RXR
extern volatile uint32_t   U1RXR __attribute__((section("sfrs"), address(0xBF801468)));
typedef struct {
  uint32_t U1RXR:4;
} __U1RXRbits_t;
extern volatile __U1RXRbits_t U1RXRbits __asm__ ("U1RXR") __attribute__((section("sfrs"), address(0xBF801468)));
#define U1CTSR U1CTSR
extern volatile uint32_t   U1CTSR __attribute__((section("sfrs"), address(0xBF80146C)));
typedef struct {
  uint32_t U1CTSR:4;
} __U1CTSRbits_t;
extern volatile __U1CTSRbits_t U1CTSRbits __asm__ ("U1CTSR") __attribute__((section("sfrs"), address(0xBF80146C)));
#define U2RXR U2RXR
extern volatile uint32_t   U2RXR __attribute__((section("sfrs"), address(0xBF801470)));
typedef struct {
  uint32_t U2RXR:4;
} __U2RXRbits_t;
extern volatile __U2RXRbits_t U2RXRbits __asm__ ("U2RXR") __attribute__((section("sfrs"), address(0xBF801470)));
#define U2CTSR U2CTSR
extern volatile uint32_t   U2CTSR __attribute__((section("sfrs"), address(0xBF801474)));
typedef struct {
  uint32_t U2CTSR:4;
} __U2CTSRbits_t;
extern volatile __U2CTSRbits_t U2CTSRbits __asm__ ("U2CTSR") __attribute__((section("sfrs"), address(0xBF801474)));
#define U3RXR U3RXR
extern volatile uint32_t   U3RXR __attribute__((section("sfrs"), address(0xBF801478)));
typedef struct {
  uint32_t U3RXR:4;
} __U3RXRbits_t;
extern volatile __U3RXRbits_t U3RXRbits __asm__ ("U3RXR") __attribute__((section("sfrs"), address(0xBF801478)));
#define U3CTSR U3CTSR
extern volatile uint32_t   U3CTSR __attribute__((section("sfrs"), address(0xBF80147C)));
typedef struct {
  uint32_t U3CTSR:4;
} __U3CTSRbits_t;
extern volatile __U3CTSRbits_t U3CTSRbits __asm__ ("U3CTSR") __attribute__((section("sfrs"), address(0xBF80147C)));
#define U4RXR U4RXR
extern volatile uint32_t   U4RXR __attribute__((section("sfrs"), address(0xBF801480)));
typedef struct {
  uint32_t U4RXR:4;
} __U4RXRbits_t;
extern volatile __U4RXRbits_t U4RXRbits __asm__ ("U4RXR") __attribute__((section("sfrs"), address(0xBF801480)));
#define U4CTSR U4CTSR
extern volatile uint32_t   U4CTSR __attribute__((section("sfrs"), address(0xBF801484)));
typedef struct {
  uint32_t U4CTSR:4;
} __U4CTSRbits_t;
extern volatile __U4CTSRbits_t U4CTSRbits __asm__ ("U4CTSR") __attribute__((section("sfrs"), address(0xBF801484)));
#define U5RXR U5RXR
extern volatile uint32_t   U5RXR __attribute__((section("sfrs"), address(0xBF801488)));
typedef struct {
  uint32_t U5RXR:4;
} __U5RXRbits_t;
extern volatile __U5RXRbits_t U5RXRbits __asm__ ("U5RXR") __attribute__((section("sfrs"), address(0xBF801488)));
#define U5CTSR U5CTSR
extern volatile uint32_t   U5CTSR __attribute__((section("sfrs"), address(0xBF80148C)));
typedef struct {
  uint32_t U5CTSR:4;
} __U5CTSRbits_t;
extern volatile __U5CTSRbits_t U5CTSRbits __asm__ ("U5CTSR") __attribute__((section("sfrs"), address(0xBF80148C)));
#define U6RXR U6RXR
extern volatile uint32_t   U6RXR __attribute__((section("sfrs"), address(0xBF801490)));
typedef struct {
  uint32_t U6RXR:4;
} __U6RXRbits_t;
extern volatile __U6RXRbits_t U6RXRbits __asm__ ("U6RXR") __attribute__((section("sfrs"), address(0xBF801490)));
#define U6CTSR U6CTSR
extern volatile uint32_t   U6CTSR __attribute__((section("sfrs"), address(0xBF801494)));
typedef struct {
  uint32_t U6CTSR:4;
} __U6CTSRbits_t;
extern volatile __U6CTSRbits_t U6CTSRbits __asm__ ("U6CTSR") __attribute__((section("sfrs"), address(0xBF801494)));
#define SDI1R SDI1R
extern volatile uint32_t   SDI1R __attribute__((section("sfrs"), address(0xBF80149C)));
typedef struct {
  uint32_t SDI1R:4;
} __SDI1Rbits_t;
extern volatile __SDI1Rbits_t SDI1Rbits __asm__ ("SDI1R") __attribute__((section("sfrs"), address(0xBF80149C)));
#define SS1R SS1R
extern volatile uint32_t   SS1R __attribute__((section("sfrs"), address(0xBF8014A0)));
typedef struct {
  uint32_t SS1R:4;
} __SS1Rbits_t;
extern volatile __SS1Rbits_t SS1Rbits __asm__ ("SS1R") __attribute__((section("sfrs"), address(0xBF8014A0)));
#define SDI2R SDI2R
extern volatile uint32_t   SDI2R __attribute__((section("sfrs"), address(0xBF8014A8)));
typedef struct {
  uint32_t SDI2R:4;
} __SDI2Rbits_t;
extern volatile __SDI2Rbits_t SDI2Rbits __asm__ ("SDI2R") __attribute__((section("sfrs"), address(0xBF8014A8)));
#define SS2R SS2R
extern volatile uint32_t   SS2R __attribute__((section("sfrs"), address(0xBF8014AC)));
typedef struct {
  uint32_t SS2R:4;
} __SS2Rbits_t;
extern volatile __SS2Rbits_t SS2Rbits __asm__ ("SS2R") __attribute__((section("sfrs"), address(0xBF8014AC)));
#define SDI3R SDI3R
extern volatile uint32_t   SDI3R __attribute__((section("sfrs"), address(0xBF8014B4)));
typedef struct {
  uint32_t SDI3R:4;
} __SDI3Rbits_t;
extern volatile __SDI3Rbits_t SDI3Rbits __asm__ ("SDI3R") __attribute__((section("sfrs"), address(0xBF8014B4)));
#define SS3R SS3R
extern volatile uint32_t   SS3R __attribute__((section("sfrs"), address(0xBF8014B8)));
typedef struct {
  uint32_t SS3R:4;
} __SS3Rbits_t;
extern volatile __SS3Rbits_t SS3Rbits __asm__ ("SS3R") __attribute__((section("sfrs"), address(0xBF8014B8)));
#define SDI4R SDI4R
extern volatile uint32_t   SDI4R __attribute__((section("sfrs"), address(0xBF8014C0)));
typedef struct {
  uint32_t SDI4R:4;
} __SDI4Rbits_t;
extern volatile __SDI4Rbits_t SDI4Rbits __asm__ ("SDI4R") __attribute__((section("sfrs"), address(0xBF8014C0)));
#define SS4R SS4R
extern volatile uint32_t   SS4R __attribute__((section("sfrs"), address(0xBF8014C4)));
typedef struct {
  uint32_t SS4R:4;
} __SS4Rbits_t;
extern volatile __SS4Rbits_t SS4Rbits __asm__ ("SS4R") __attribute__((section("sfrs"), address(0xBF8014C4)));
#define C1RXR C1RXR
extern volatile uint32_t   C1RXR __attribute__((section("sfrs"), address(0xBF8014E0)));
typedef struct {
  uint32_t C1RXR:4;
} __C1RXRbits_t;
extern volatile __C1RXRbits_t C1RXRbits __asm__ ("C1RXR") __attribute__((section("sfrs"), address(0xBF8014E0)));
#define C2RXR C2RXR
extern volatile uint32_t   C2RXR __attribute__((section("sfrs"), address(0xBF8014E4)));
typedef struct {
  uint32_t C2RXR:4;
} __C2RXRbits_t;
extern volatile __C2RXRbits_t C2RXRbits __asm__ ("C2RXR") __attribute__((section("sfrs"), address(0xBF8014E4)));
#define REFCLKI1R REFCLKI1R
extern volatile uint32_t   REFCLKI1R __attribute__((section("sfrs"), address(0xBF8014E8)));
typedef struct {
  uint32_t REFCLKI1R:4;
} __REFCLKI1Rbits_t;
extern volatile __REFCLKI1Rbits_t REFCLKI1Rbits __asm__ ("REFCLKI1R") __attribute__((section("sfrs"), address(0xBF8014E8)));
#define REFCLKI3R REFCLKI3R
extern volatile uint32_t   REFCLKI3R __attribute__((section("sfrs"), address(0xBF8014F0)));
typedef struct {
  uint32_t REFCLKI3R:4;
} __REFCLKI3Rbits_t;
extern volatile __REFCLKI3Rbits_t REFCLKI3Rbits __asm__ ("REFCLKI3R") __attribute__((section("sfrs"), address(0xBF8014F0)));
#define REFCLKI4R REFCLKI4R
extern volatile uint32_t   REFCLKI4R __attribute__((section("sfrs"), address(0xBF8014F4)));
typedef struct {
  uint32_t REFCLKI4R:4;
} __REFCLKI4Rbits_t;
extern volatile __REFCLKI4Rbits_t REFCLKI4Rbits __asm__ ("REFCLKI4R") __attribute__((section("sfrs"), address(0xBF8014F4)));
#define RPB0R RPB0R
extern volatile uint32_t   RPB0R __attribute__((section("sfrs"), address(0xBF801540)));
typedef struct {
  uint32_t RPB0R:4;
} __RPB0Rbits_t;
extern volatile __RPB0Rbits_t RPB0Rbits __asm__ ("RPB0R") __attribute__((section("sfrs"), address(0xBF801540)));
#define RPB1R RPB1R
extern volatile uint32_t   RPB1R __attribute__((section("sfrs"), address(0xBF801544)));
typedef struct {
  uint32_t RPB1R:4;
} __RPB1Rbits_t;
extern volatile __RPB1Rbits_t RPB1Rbits __asm__ ("RPB1R") __attribute__((section("sfrs"), address(0xBF801544)));
#define RPB2R RPB2R
extern volatile uint32_t   RPB2R __attribute__((section("sfrs"), address(0xBF801548)));
typedef struct {
  uint32_t RPB2R:4;
} __RPB2Rbits_t;
extern volatile __RPB2Rbits_t RPB2Rbits __asm__ ("RPB2R") __attribute__((section("sfrs"), address(0xBF801548)));
#define RPB3R RPB3R
extern volatile uint32_t   RPB3R __attribute__((section("sfrs"), address(0xBF80154C)));
typedef struct {
  uint32_t RPB3R:4;
} __RPB3Rbits_t;
extern volatile __RPB3Rbits_t RPB3Rbits __asm__ ("RPB3R") __attribute__((section("sfrs"), address(0xBF80154C)));
#define RPB5R RPB5R
extern volatile uint32_t   RPB5R __attribute__((section("sfrs"), address(0xBF801554)));
typedef struct {
  uint32_t RPB5R:4;
} __RPB5Rbits_t;
extern volatile __RPB5Rbits_t RPB5Rbits __asm__ ("RPB5R") __attribute__((section("sfrs"), address(0xBF801554)));
#define RPB6R RPB6R
extern volatile uint32_t   RPB6R __attribute__((section("sfrs"), address(0xBF801558)));
typedef struct {
  uint32_t RPB6R:4;
} __RPB6Rbits_t;
extern volatile __RPB6Rbits_t RPB6Rbits __asm__ ("RPB6R") __attribute__((section("sfrs"), address(0xBF801558)));
#define RPB7R RPB7R
extern volatile uint32_t   RPB7R __attribute__((section("sfrs"), address(0xBF80155C)));
typedef struct {
  uint32_t RPB7R:4;
} __RPB7Rbits_t;
extern volatile __RPB7Rbits_t RPB7Rbits __asm__ ("RPB7R") __attribute__((section("sfrs"), address(0xBF80155C)));
#define RPB8R RPB8R
extern volatile uint32_t   RPB8R __attribute__((section("sfrs"), address(0xBF801560)));
typedef struct {
  uint32_t RPB8R:4;
} __RPB8Rbits_t;
extern volatile __RPB8Rbits_t RPB8Rbits __asm__ ("RPB8R") __attribute__((section("sfrs"), address(0xBF801560)));
#define RPB9R RPB9R
extern volatile uint32_t   RPB9R __attribute__((section("sfrs"), address(0xBF801564)));
typedef struct {
  uint32_t RPB9R:4;
} __RPB9Rbits_t;
extern volatile __RPB9Rbits_t RPB9Rbits __asm__ ("RPB9R") __attribute__((section("sfrs"), address(0xBF801564)));
#define RPB10R RPB10R
extern volatile uint32_t   RPB10R __attribute__((section("sfrs"), address(0xBF801568)));
typedef struct {
  uint32_t RPB10R:4;
} __RPB10Rbits_t;
extern volatile __RPB10Rbits_t RPB10Rbits __asm__ ("RPB10R") __attribute__((section("sfrs"), address(0xBF801568)));
#define RPB14R RPB14R
extern volatile uint32_t   RPB14R __attribute__((section("sfrs"), address(0xBF801578)));
typedef struct {
  uint32_t RPB14R:4;
} __RPB14Rbits_t;
extern volatile __RPB14Rbits_t RPB14Rbits __asm__ ("RPB14R") __attribute__((section("sfrs"), address(0xBF801578)));
#define RPB15R RPB15R
extern volatile uint32_t   RPB15R __attribute__((section("sfrs"), address(0xBF80157C)));
typedef struct {
  uint32_t RPB15R:4;
} __RPB15Rbits_t;
extern volatile __RPB15Rbits_t RPB15Rbits __asm__ ("RPB15R") __attribute__((section("sfrs"), address(0xBF80157C)));
#define RPC13R RPC13R
extern volatile uint32_t   RPC13R __attribute__((section("sfrs"), address(0xBF8015B4)));
typedef struct {
  uint32_t RPC13R:4;
} __RPC13Rbits_t;
extern volatile __RPC13Rbits_t RPC13Rbits __asm__ ("RPC13R") __attribute__((section("sfrs"), address(0xBF8015B4)));
#define RPC14R RPC14R
extern volatile uint32_t   RPC14R __attribute__((section("sfrs"), address(0xBF8015B8)));
typedef struct {
  uint32_t RPC14R:4;
} __RPC14Rbits_t;
extern volatile __RPC14Rbits_t RPC14Rbits __asm__ ("RPC14R") __attribute__((section("sfrs"), address(0xBF8015B8)));
#define RPD0R RPD0R
extern volatile uint32_t   RPD0R __attribute__((section("sfrs"), address(0xBF8015C0)));
typedef struct {
  uint32_t RPD0R:4;
} __RPD0Rbits_t;
extern volatile __RPD0Rbits_t RPD0Rbits __asm__ ("RPD0R") __attribute__((section("sfrs"), address(0xBF8015C0)));
#define RPD1R RPD1R
extern volatile uint32_t   RPD1R __attribute__((section("sfrs"), address(0xBF8015C4)));
typedef struct {
  uint32_t RPD1R:4;
} __RPD1Rbits_t;
extern volatile __RPD1Rbits_t RPD1Rbits __asm__ ("RPD1R") __attribute__((section("sfrs"), address(0xBF8015C4)));
#define RPD2R RPD2R
extern volatile uint32_t   RPD2R __attribute__((section("sfrs"), address(0xBF8015C8)));
typedef struct {
  uint32_t RPD2R:4;
} __RPD2Rbits_t;
extern volatile __RPD2Rbits_t RPD2Rbits __asm__ ("RPD2R") __attribute__((section("sfrs"), address(0xBF8015C8)));
#define RPD3R RPD3R
extern volatile uint32_t   RPD3R __attribute__((section("sfrs"), address(0xBF8015CC)));
typedef struct {
  uint32_t RPD3R:4;
} __RPD3Rbits_t;
extern volatile __RPD3Rbits_t RPD3Rbits __asm__ ("RPD3R") __attribute__((section("sfrs"), address(0xBF8015CC)));
#define RPD4R RPD4R
extern volatile uint32_t   RPD4R __attribute__((section("sfrs"), address(0xBF8015D0)));
typedef struct {
  uint32_t RPD4R:4;
} __RPD4Rbits_t;
extern volatile __RPD4Rbits_t RPD4Rbits __asm__ ("RPD4R") __attribute__((section("sfrs"), address(0xBF8015D0)));
#define RPD5R RPD5R
extern volatile uint32_t   RPD5R __attribute__((section("sfrs"), address(0xBF8015D4)));
typedef struct {
  uint32_t RPD5R:4;
} __RPD5Rbits_t;
extern volatile __RPD5Rbits_t RPD5Rbits __asm__ ("RPD5R") __attribute__((section("sfrs"), address(0xBF8015D4)));
#define RPD9R RPD9R
extern volatile uint32_t   RPD9R __attribute__((section("sfrs"), address(0xBF8015E4)));
typedef struct {
  uint32_t RPD9R:4;
} __RPD9Rbits_t;
extern volatile __RPD9Rbits_t RPD9Rbits __asm__ ("RPD9R") __attribute__((section("sfrs"), address(0xBF8015E4)));
#define RPD10R RPD10R
extern volatile uint32_t   RPD10R __attribute__((section("sfrs"), address(0xBF8015E8)));
typedef struct {
  uint32_t RPD10R:4;
} __RPD10Rbits_t;
extern volatile __RPD10Rbits_t RPD10Rbits __asm__ ("RPD10R") __attribute__((section("sfrs"), address(0xBF8015E8)));
#define RPD11R RPD11R
extern volatile uint32_t   RPD11R __attribute__((section("sfrs"), address(0xBF8015EC)));
typedef struct {
  uint32_t RPD11R:4;
} __RPD11Rbits_t;
extern volatile __RPD11Rbits_t RPD11Rbits __asm__ ("RPD11R") __attribute__((section("sfrs"), address(0xBF8015EC)));
#define RPE3R RPE3R
extern volatile uint32_t   RPE3R __attribute__((section("sfrs"), address(0xBF80160C)));
typedef struct {
  uint32_t RPE3R:4;
} __RPE3Rbits_t;
extern volatile __RPE3Rbits_t RPE3Rbits __asm__ ("RPE3R") __attribute__((section("sfrs"), address(0xBF80160C)));
#define RPE5R RPE5R
extern volatile uint32_t   RPE5R __attribute__((section("sfrs"), address(0xBF801614)));
typedef struct {
  uint32_t RPE5R:4;
} __RPE5Rbits_t;
extern volatile __RPE5Rbits_t RPE5Rbits __asm__ ("RPE5R") __attribute__((section("sfrs"), address(0xBF801614)));
#define RPF0R RPF0R
extern volatile uint32_t   RPF0R __attribute__((section("sfrs"), address(0xBF801640)));
typedef struct {
  uint32_t RPF0R:4;
} __RPF0Rbits_t;
extern volatile __RPF0Rbits_t RPF0Rbits __asm__ ("RPF0R") __attribute__((section("sfrs"), address(0xBF801640)));
#define RPF1R RPF1R
extern volatile uint32_t   RPF1R __attribute__((section("sfrs"), address(0xBF801644)));
typedef struct {
  uint32_t RPF1R:4;
} __RPF1Rbits_t;
extern volatile __RPF1Rbits_t RPF1Rbits __asm__ ("RPF1R") __attribute__((section("sfrs"), address(0xBF801644)));
#define RPF3R RPF3R
extern volatile uint32_t   RPF3R __attribute__((section("sfrs"), address(0xBF80164C)));
typedef struct {
  uint32_t RPF3R:4;
} __RPF3Rbits_t;
extern volatile __RPF3Rbits_t RPF3Rbits __asm__ ("RPF3R") __attribute__((section("sfrs"), address(0xBF80164C)));
#define RPF4R RPF4R
extern volatile uint32_t   RPF4R __attribute__((section("sfrs"), address(0xBF801650)));
typedef struct {
  uint32_t RPF4R:4;
} __RPF4Rbits_t;
extern volatile __RPF4Rbits_t RPF4Rbits __asm__ ("RPF4R") __attribute__((section("sfrs"), address(0xBF801650)));
#define RPF5R RPF5R
extern volatile uint32_t   RPF5R __attribute__((section("sfrs"), address(0xBF801654)));
typedef struct {
  uint32_t RPF5R:4;
} __RPF5Rbits_t;
extern volatile __RPF5Rbits_t RPF5Rbits __asm__ ("RPF5R") __attribute__((section("sfrs"), address(0xBF801654)));
#define RPG6R RPG6R
extern volatile uint32_t   RPG6R __attribute__((section("sfrs"), address(0xBF801698)));
typedef struct {
  uint32_t RPG6R:4;
} __RPG6Rbits_t;
extern volatile __RPG6Rbits_t RPG6Rbits __asm__ ("RPG6R") __attribute__((section("sfrs"), address(0xBF801698)));
#define RPG7R RPG7R
extern volatile uint32_t   RPG7R __attribute__((section("sfrs"), address(0xBF80169C)));
typedef struct {
  uint32_t RPG7R:4;
} __RPG7Rbits_t;
extern volatile __RPG7Rbits_t RPG7Rbits __asm__ ("RPG7R") __attribute__((section("sfrs"), address(0xBF80169C)));
#define RPG8R RPG8R
extern volatile uint32_t   RPG8R __attribute__((section("sfrs"), address(0xBF8016A0)));
typedef struct {
  uint32_t RPG8R:4;
} __RPG8Rbits_t;
extern volatile __RPG8Rbits_t RPG8Rbits __asm__ ("RPG8R") __attribute__((section("sfrs"), address(0xBF8016A0)));
#define RPG9R RPG9R
extern volatile uint32_t   RPG9R __attribute__((section("sfrs"), address(0xBF8016A4)));
typedef struct {
  uint32_t RPG9R:4;
} __RPG9Rbits_t;
extern volatile __RPG9Rbits_t RPG9Rbits __asm__ ("RPG9R") __attribute__((section("sfrs"), address(0xBF8016A4)));
#define INTCON INTCON
extern volatile uint32_t   INTCON __attribute__((section("sfrs"), address(0xBF810000)));
typedef struct {
  uint32_t INT0EP:1;
  uint32_t INT1EP:1;
  uint32_t INT2EP:1;
  uint32_t INT3EP:1;
  uint32_t INT4EP:1;
  uint32_t :3;
  uint32_t TPC:3;
  uint32_t :1;
  uint32_t MVEC:1;
  uint32_t :11;
  uint32_t NMIKEY:8;
} __INTCONbits_t;
extern volatile __INTCONbits_t INTCONbits __asm__ ("INTCON") __attribute__((section("sfrs"), address(0xBF810000)));
extern volatile uint32_t        INTCONCLR __attribute__((section("sfrs"),address(0xBF810004)));
extern volatile uint32_t        INTCONSET __attribute__((section("sfrs"),address(0xBF810008)));
extern volatile uint32_t        INTCONINV __attribute__((section("sfrs"),address(0xBF81000C)));
#define PRISS PRISS
extern volatile uint32_t   PRISS __attribute__((section("sfrs"), address(0xBF810010)));
typedef struct {
  uint32_t SS0:1;
  uint32_t :3;
  uint32_t PRI1SS:4;
  uint32_t PRI2SS:4;
  uint32_t PRI3SS:4;
  uint32_t PRI4SS:4;
  uint32_t PRI5SS:4;
  uint32_t PRI6SS:4;
  uint32_t PRI7SS:4;
} __PRISSbits_t;
extern volatile __PRISSbits_t PRISSbits __asm__ ("PRISS") __attribute__((section("sfrs"), address(0xBF810010)));
extern volatile uint32_t        PRISSCLR __attribute__((section("sfrs"),address(0xBF810014)));
extern volatile uint32_t        PRISSSET __attribute__((section("sfrs"),address(0xBF810018)));
extern volatile uint32_t        PRISSINV __attribute__((section("sfrs"),address(0xBF81001C)));
#define INTSTAT INTSTAT
extern volatile uint32_t   INTSTAT __attribute__((section("sfrs"), address(0xBF810020)));
typedef struct {
  uint32_t SIRQ:8;
  uint32_t SRIPL:3;
} __INTSTATbits_t;
extern volatile __INTSTATbits_t INTSTATbits __asm__ ("INTSTAT") __attribute__((section("sfrs"), address(0xBF810020)));
extern volatile uint32_t        INTSTATCLR __attribute__((section("sfrs"),address(0xBF810024)));
extern volatile uint32_t        INTSTATSET __attribute__((section("sfrs"),address(0xBF810028)));
extern volatile uint32_t        INTSTATINV __attribute__((section("sfrs"),address(0xBF81002C)));
#define IPTMR IPTMR
extern volatile uint32_t   IPTMR __attribute__((section("sfrs"), address(0xBF810030)));
typedef struct {
  uint32_t IPTMR:32;
} __IPTMRbits_t;
extern volatile __IPTMRbits_t IPTMRbits __asm__ ("IPTMR") __attribute__((section("sfrs"), address(0xBF810030)));
extern volatile uint32_t        IPTMRCLR __attribute__((section("sfrs"),address(0xBF810034)));
extern volatile uint32_t        IPTMRSET __attribute__((section("sfrs"),address(0xBF810038)));
extern volatile uint32_t        IPTMRINV __attribute__((section("sfrs"),address(0xBF81003C)));
#define IFS0 IFS0
extern volatile uint32_t   IFS0 __attribute__((section("sfrs"), address(0xBF810040)));
typedef union {
  struct {
    uint32_t CTIF:1;
    uint32_t CS0IF:1;
    uint32_t CS1IF:1;
    uint32_t INT0IF:1;
    uint32_t T1IF:1;
    uint32_t IC1EIF:1;
    uint32_t IC1IF:1;
    uint32_t OC1IF:1;
    uint32_t INT1IF:1;
    uint32_t T2IF:1;
    uint32_t IC2EIF:1;
    uint32_t IC2IF:1;
    uint32_t OC2IF:1;
    uint32_t INT2IF:1;
    uint32_t T3IF:1;
    uint32_t IC3EIF:1;
    uint32_t IC3IF:1;
    uint32_t OC3IF:1;
    uint32_t INT3IF:1;
    uint32_t T4IF:1;
    uint32_t IC4EIF:1;
    uint32_t IC4IF:1;
    uint32_t OC4IF:1;
    uint32_t INT4IF:1;
    uint32_t T5IF:1;
    uint32_t IC5EIF:1;
    uint32_t IC5IF:1;
    uint32_t OC5IF:1;
    uint32_t T6IF:1;
    uint32_t IC6EIF:1;
    uint32_t IC6IF:1;
    uint32_t OC6IF:1;
  };
  struct {
    uint32_t w:32;
  };
} __IFS0bits_t;
extern volatile __IFS0bits_t IFS0bits __asm__ ("IFS0") __attribute__((section("sfrs"), address(0xBF810040)));
extern volatile uint32_t        IFS0CLR __attribute__((section("sfrs"),address(0xBF810044)));
extern volatile uint32_t        IFS0SET __attribute__((section("sfrs"),address(0xBF810048)));
extern volatile uint32_t        IFS0INV __attribute__((section("sfrs"),address(0xBF81004C)));
#define IFS1 IFS1
extern volatile uint32_t   IFS1 __attribute__((section("sfrs"), address(0xBF810050)));
typedef union {
  struct {
    uint32_t T7IF:1;
    uint32_t IC7EIF:1;
    uint32_t IC7IF:1;
    uint32_t OC7IF:1;
    uint32_t T8IF:1;
    uint32_t IC8EIF:1;
    uint32_t IC8IF:1;
    uint32_t OC8IF:1;
    uint32_t T9IF:1;
    uint32_t IC9EIF:1;
    uint32_t IC9IF:1;
    uint32_t OC9IF:1;
    uint32_t ADCIF:1;
    uint32_t ADCFIFOIF:1;
    uint32_t ADCDC1IF:1;
    uint32_t ADCDC2IF:1;
    uint32_t ADCDC3IF:1;
    uint32_t ADCDC4IF:1;
    uint32_t ADCDC5IF:1;
    uint32_t ADCDC6IF:1;
    uint32_t ADCDF1IF:1;
    uint32_t ADCDF2IF:1;
    uint32_t ADCDF3IF:1;
    uint32_t ADCDF4IF:1;
    uint32_t ADCDF5IF:1;
    uint32_t ADCDF6IF:1;
    uint32_t ADCFLTIF:1;
    uint32_t ADCD0IF:1;
    uint32_t ADCD1IF:1;
    uint32_t ADCD2IF:1;
    uint32_t ADCD3IF:1;
    uint32_t ADCD4IF:1;
  };
  struct {
    uint32_t w:32;
  };
} __IFS1bits_t;
extern volatile __IFS1bits_t IFS1bits __asm__ ("IFS1") __attribute__((section("sfrs"), address(0xBF810050)));
extern volatile uint32_t        IFS1CLR __attribute__((section("sfrs"),address(0xBF810054)));
extern volatile uint32_t        IFS1SET __attribute__((section("sfrs"),address(0xBF810058)));
extern volatile uint32_t        IFS1INV __attribute__((section("sfrs"),address(0xBF81005C)));
#define IFS2 IFS2
extern volatile uint32_t   IFS2 __attribute__((section("sfrs"), address(0xBF810060)));
typedef union {
  struct {
    uint32_t ADCD5IF:1;
    uint32_t ADCD6IF:1;
    uint32_t ADCD7IF:1;
    uint32_t ADCD8IF:1;
    uint32_t ADCD9IF:1;
    uint32_t ADCD10IF:1;
    uint32_t ADCD11IF:1;
    uint32_t ADCD12IF:1;
    uint32_t ADCD13IF:1;
    uint32_t ADCD14IF:1;
    uint32_t ADCD15IF:1;
    uint32_t ADCD16IF:1;
    uint32_t ADCD17IF:1;
    uint32_t ADCD18IF:1;
  };
  struct {
    uint32_t w:32;
  };
} __IFS2bits_t;
extern volatile __IFS2bits_t IFS2bits __asm__ ("IFS2") __attribute__((section("sfrs"), address(0xBF810060)));
extern volatile uint32_t        IFS2CLR __attribute__((section("sfrs"),address(0xBF810064)));
extern volatile uint32_t        IFS2SET __attribute__((section("sfrs"),address(0xBF810068)));
extern volatile uint32_t        IFS2INV __attribute__((section("sfrs"),address(0xBF81006C)));
#define IFS3 IFS3
extern volatile uint32_t   IFS3 __attribute__((section("sfrs"), address(0xBF810070)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t ADCD43IF:1;
    uint32_t ADCD44IF:1;
    uint32_t CPCIF:1;
    uint32_t CFDCIF:1;
    uint32_t SBIF:1;
    uint32_t :2;
    uint32_t SPI1EIF:1;
    uint32_t SPI1RXIF:1;
    uint32_t SPI1TXIF:1;
    uint32_t U1EIF:1;
    uint32_t U1RXIF:1;
    uint32_t U1TXIF:1;
    uint32_t I2C1BIF:1;
    uint32_t I2C1SIF:1;
    uint32_t I2C1MIF:1;
    uint32_t :1;
    uint32_t CNBIF:1;
    uint32_t CNCIF:1;
    uint32_t CNDIF:1;
    uint32_t CNEIF:1;
    uint32_t CNFIF:1;
    uint32_t CNGIF:1;
  };
  struct {
    uint32_t w:32;
  };
} __IFS3bits_t;
extern volatile __IFS3bits_t IFS3bits __asm__ ("IFS3") __attribute__((section("sfrs"), address(0xBF810070)));
extern volatile uint32_t        IFS3CLR __attribute__((section("sfrs"),address(0xBF810074)));
extern volatile uint32_t        IFS3SET __attribute__((section("sfrs"),address(0xBF810078)));
extern volatile uint32_t        IFS3INV __attribute__((section("sfrs"),address(0xBF81007C)));
#define IFS4 IFS4
extern volatile uint32_t   IFS4 __attribute__((section("sfrs"), address(0xBF810080)));
typedef union {
  struct {
    uint32_t PMPIF:1;
    uint32_t PMPEIF:1;
    uint32_t CMP1IF:1;
    uint32_t CMP2IF:1;
    uint32_t USBIF:1;
    uint32_t USBDMAIF:1;
    uint32_t DMA0IF:1;
    uint32_t DMA1IF:1;
    uint32_t DMA2IF:1;
    uint32_t DMA3IF:1;
    uint32_t DMA4IF:1;
    uint32_t DMA5IF:1;
    uint32_t DMA6IF:1;
    uint32_t DMA7IF:1;
    uint32_t SPI2EIF:1;
    uint32_t SPI2RXIF:1;
    uint32_t SPI2TXIF:1;
    uint32_t U2EIF:1;
    uint32_t U2RXIF:1;
    uint32_t U2TXIF:1;
    uint32_t :3;
    uint32_t CAN1IF:1;
    uint32_t CAN2IF:1;
    uint32_t ETHIF:1;
    uint32_t SPI3EIF:1;
    uint32_t SPI3RXIF:1;
    uint32_t SPI3TXIF:1;
    uint32_t U3EIF:1;
    uint32_t U3RXIF:1;
    uint32_t U3TXIF:1;
  };
  struct {
    uint32_t w:32;
  };
} __IFS4bits_t;
extern volatile __IFS4bits_t IFS4bits __asm__ ("IFS4") __attribute__((section("sfrs"), address(0xBF810080)));
extern volatile uint32_t        IFS4CLR __attribute__((section("sfrs"),address(0xBF810084)));
extern volatile uint32_t        IFS4SET __attribute__((section("sfrs"),address(0xBF810088)));
extern volatile uint32_t        IFS4INV __attribute__((section("sfrs"),address(0xBF81008C)));
#define IFS5 IFS5
extern volatile uint32_t   IFS5 __attribute__((section("sfrs"), address(0xBF810090)));
typedef union {
  struct {
    uint32_t I2C3BIF:1;
    uint32_t I2C3SIF:1;
    uint32_t I2C3MIF:1;
    uint32_t SPI4EIF:1;
    uint32_t SPI4RXIF:1;
    uint32_t SPI4TXIF:1;
    uint32_t RTCCIF:1;
    uint32_t FCEIF:1;
    uint32_t PREIF:1;
    uint32_t SQI1IF:1;
    uint32_t U4EIF:1;
    uint32_t U4RXIF:1;
    uint32_t U4TXIF:1;
    uint32_t I2C4BIF:1;
    uint32_t I2C4SIF:1;
    uint32_t I2C4MIF:1;
    uint32_t :3;
    uint32_t U5EIF:1;
    uint32_t U5RXIF:1;
    uint32_t U5TXIF:1;
    uint32_t I2C5BIF:1;
    uint32_t I2C5SIF:1;
    uint32_t I2C5MIF:1;
    uint32_t :3;
    uint32_t U6EIF:1;
    uint32_t U6RXIF:1;
    uint32_t U6TXIF:1;
  };
  struct {
    uint32_t w:32;
  };
} __IFS5bits_t;
extern volatile __IFS5bits_t IFS5bits __asm__ ("IFS5") __attribute__((section("sfrs"), address(0xBF810090)));
extern volatile uint32_t        IFS5CLR __attribute__((section("sfrs"),address(0xBF810094)));
extern volatile uint32_t        IFS5SET __attribute__((section("sfrs"),address(0xBF810098)));
extern volatile uint32_t        IFS5INV __attribute__((section("sfrs"),address(0xBF81009C)));
#define IFS6 IFS6
extern volatile uint32_t   IFS6 __attribute__((section("sfrs"), address(0xBF8100A0)));
typedef union {
  struct {
    uint32_t ADCEOSIF:1;
    uint32_t ADCARDYIF:1;
    uint32_t ADCURDYIF:1;
    uint32_t :1;
    uint32_t ADCGRPIF:1;
    uint32_t :1;
    uint32_t ADC0EIF:1;
    uint32_t ADC1EIF:1;
    uint32_t ADC2EIF:1;
    uint32_t ADC3EIF:1;
    uint32_t ADC4EIF:1;
    uint32_t :2;
    uint32_t ADC7EIF:1;
    uint32_t ADC0WIF:1;
    uint32_t ADC1WIF:1;
    uint32_t ADC2WIF:1;
    uint32_t ADC3WIF:1;
    uint32_t ADC4WIF:1;
    uint32_t :2;
    uint32_t ADC7WIF:1;
  };
  struct {
    uint32_t w:32;
  };
} __IFS6bits_t;
extern volatile __IFS6bits_t IFS6bits __asm__ ("IFS6") __attribute__((section("sfrs"), address(0xBF8100A0)));
extern volatile uint32_t        IFS6CLR __attribute__((section("sfrs"),address(0xBF8100A4)));
extern volatile uint32_t        IFS6SET __attribute__((section("sfrs"),address(0xBF8100A8)));
extern volatile uint32_t        IFS6INV __attribute__((section("sfrs"),address(0xBF8100AC)));
#define IEC0 IEC0
extern volatile uint32_t   IEC0 __attribute__((section("sfrs"), address(0xBF8100C0)));
typedef union {
  struct {
    uint32_t CTIE:1;
    uint32_t CS0IE:1;
    uint32_t CS1IE:1;
    uint32_t INT0IE:1;
    uint32_t T1IE:1;
    uint32_t IC1EIE:1;
    uint32_t IC1IE:1;
    uint32_t OC1IE:1;
    uint32_t INT1IE:1;
    uint32_t T2IE:1;
    uint32_t IC2EIE:1;
    uint32_t IC2IE:1;
    uint32_t OC2IE:1;
    uint32_t INT2IE:1;
    uint32_t T3IE:1;
    uint32_t IC3EIE:1;
    uint32_t IC3IE:1;
    uint32_t OC3IE:1;
    uint32_t INT3IE:1;
    uint32_t T4IE:1;
    uint32_t IC4EIE:1;
    uint32_t IC4IE:1;
    uint32_t OC4IE:1;
    uint32_t INT4IE:1;
    uint32_t T5IE:1;
    uint32_t IC5EIE:1;
    uint32_t IC5IE:1;
    uint32_t OC5IE:1;
    uint32_t T6IE:1;
    uint32_t IC6EIE:1;
    uint32_t IC6IE:1;
    uint32_t OC6IE:1;
  };
  struct {
    uint32_t w:32;
  };
} __IEC0bits_t;
extern volatile __IEC0bits_t IEC0bits __asm__ ("IEC0") __attribute__((section("sfrs"), address(0xBF8100C0)));
extern volatile uint32_t        IEC0CLR __attribute__((section("sfrs"),address(0xBF8100C4)));
extern volatile uint32_t        IEC0SET __attribute__((section("sfrs"),address(0xBF8100C8)));
extern volatile uint32_t        IEC0INV __attribute__((section("sfrs"),address(0xBF8100CC)));
#define IEC1 IEC1
extern volatile uint32_t   IEC1 __attribute__((section("sfrs"), address(0xBF8100D0)));
typedef union {
  struct {
    uint32_t T7IE:1;
    uint32_t IC7EIE:1;
    uint32_t IC7IE:1;
    uint32_t OC7IE:1;
    uint32_t T8IE:1;
    uint32_t IC8EIE:1;
    uint32_t IC8IE:1;
    uint32_t OC8IE:1;
    uint32_t T9IE:1;
    uint32_t IC9EIE:1;
    uint32_t IC9IE:1;
    uint32_t OC9IE:1;
    uint32_t ADCIE:1;
    uint32_t ADCFIFOIE:1;
    uint32_t ADCDC1IE:1;
    uint32_t ADCDC2IE:1;
    uint32_t ADCDC3IE:1;
    uint32_t ADCDC4IE:1;
    uint32_t ADCDC5IE:1;
    uint32_t ADCDC6IE:1;
    uint32_t ADCDF1IE:1;
    uint32_t ADCDF2IE:1;
    uint32_t ADCDF3IE:1;
    uint32_t ADCDF4IE:1;
    uint32_t ADCDF5IE:1;
    uint32_t ADCDF6IE:1;
    uint32_t ADCFLTIE:1;
    uint32_t ADCD0IE:1;
    uint32_t ADCD1IE:1;
    uint32_t ADCD2IE:1;
    uint32_t ADCD3IE:1;
    uint32_t ADCD4IE:1;
  };
  struct {
    uint32_t w:32;
  };
} __IEC1bits_t;
extern volatile __IEC1bits_t IEC1bits __asm__ ("IEC1") __attribute__((section("sfrs"), address(0xBF8100D0)));
extern volatile uint32_t        IEC1CLR __attribute__((section("sfrs"),address(0xBF8100D4)));
extern volatile uint32_t        IEC1SET __attribute__((section("sfrs"),address(0xBF8100D8)));
extern volatile uint32_t        IEC1INV __attribute__((section("sfrs"),address(0xBF8100DC)));
#define IEC2 IEC2
extern volatile uint32_t   IEC2 __attribute__((section("sfrs"), address(0xBF8100E0)));
typedef union {
  struct {
    uint32_t ADCD5IE:1;
    uint32_t ADCD6IE:1;
    uint32_t ADCD7IE:1;
    uint32_t ADCD8IE:1;
    uint32_t ADCD9IE:1;
    uint32_t ADCD10IE:1;
    uint32_t ADCD11IE:1;
    uint32_t ADCD12IE:1;
    uint32_t ADCD13IE:1;
    uint32_t ADCD14IE:1;
    uint32_t ADCD15IE:1;
    uint32_t ADCD16IE:1;
    uint32_t ADCD17IE:1;
    uint32_t ADCD18IE:1;
  };
  struct {
    uint32_t w:32;
  };
} __IEC2bits_t;
extern volatile __IEC2bits_t IEC2bits __asm__ ("IEC2") __attribute__((section("sfrs"), address(0xBF8100E0)));
extern volatile uint32_t        IEC2CLR __attribute__((section("sfrs"),address(0xBF8100E4)));
extern volatile uint32_t        IEC2SET __attribute__((section("sfrs"),address(0xBF8100E8)));
extern volatile uint32_t        IEC2INV __attribute__((section("sfrs"),address(0xBF8100EC)));
#define IEC3 IEC3
extern volatile uint32_t   IEC3 __attribute__((section("sfrs"), address(0xBF8100F0)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t ADCD43IE:1;
    uint32_t ADCD44IE:1;
    uint32_t CPCIE:1;
    uint32_t CFDCIE:1;
    uint32_t SBIE:1;
    uint32_t :2;
    uint32_t SPI1EIE:1;
    uint32_t SPI1RXIE:1;
    uint32_t SPI1TXIE:1;
    uint32_t U1EIE:1;
    uint32_t U1RXIE:1;
    uint32_t U1TXIE:1;
    uint32_t I2C1BIE:1;
    uint32_t I2C1SIE:1;
    uint32_t I2C1MIE:1;
    uint32_t :1;
    uint32_t CNBIE:1;
    uint32_t CNCIE:1;
    uint32_t CNDIE:1;
    uint32_t CNEIE:1;
    uint32_t CNFIE:1;
    uint32_t CNGIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __IEC3bits_t;
extern volatile __IEC3bits_t IEC3bits __asm__ ("IEC3") __attribute__((section("sfrs"), address(0xBF8100F0)));
extern volatile uint32_t        IEC3CLR __attribute__((section("sfrs"),address(0xBF8100F4)));
extern volatile uint32_t        IEC3SET __attribute__((section("sfrs"),address(0xBF8100F8)));
extern volatile uint32_t        IEC3INV __attribute__((section("sfrs"),address(0xBF8100FC)));
#define IEC4 IEC4
extern volatile uint32_t   IEC4 __attribute__((section("sfrs"), address(0xBF810100)));
typedef union {
  struct {
    uint32_t PMPIE:1;
    uint32_t PMPEIE:1;
    uint32_t CMP1IE:1;
    uint32_t CMP2IE:1;
    uint32_t USBIE:1;
    uint32_t USBDMAIE:1;
    uint32_t DMA0IE:1;
    uint32_t DMA1IE:1;
    uint32_t DMA2IE:1;
    uint32_t DMA3IE:1;
    uint32_t DMA4IE:1;
    uint32_t DMA5IE:1;
    uint32_t DMA6IE:1;
    uint32_t DMA7IE:1;
    uint32_t SPI2EIE:1;
    uint32_t SPI2RXIE:1;
    uint32_t SPI2TXIE:1;
    uint32_t U2EIE:1;
    uint32_t U2RXIE:1;
    uint32_t U2TXIE:1;
    uint32_t :3;
    uint32_t CAN1IE:1;
    uint32_t CAN2IE:1;
    uint32_t ETHIE:1;
    uint32_t SPI3EIE:1;
    uint32_t SPI3RXIE:1;
    uint32_t SPI3TXIE:1;
    uint32_t U3EIE:1;
    uint32_t U3RXIE:1;
    uint32_t U3TXIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __IEC4bits_t;
extern volatile __IEC4bits_t IEC4bits __asm__ ("IEC4") __attribute__((section("sfrs"), address(0xBF810100)));
extern volatile uint32_t        IEC4CLR __attribute__((section("sfrs"),address(0xBF810104)));
extern volatile uint32_t        IEC4SET __attribute__((section("sfrs"),address(0xBF810108)));
extern volatile uint32_t        IEC4INV __attribute__((section("sfrs"),address(0xBF81010C)));
#define IEC5 IEC5
extern volatile uint32_t   IEC5 __attribute__((section("sfrs"), address(0xBF810110)));
typedef union {
  struct {
    uint32_t I2C3BIE:1;
    uint32_t I2C3SIE:1;
    uint32_t I2C3MIE:1;
    uint32_t SPI4EIE:1;
    uint32_t SPI4RXIE:1;
    uint32_t SPI4TXIE:1;
    uint32_t RTCCIE:1;
    uint32_t FCEIE:1;
    uint32_t PREIE:1;
    uint32_t SQI1IE:1;
    uint32_t U4EIE:1;
    uint32_t U4RXIE:1;
    uint32_t U4TXIE:1;
    uint32_t I2C4BIE:1;
    uint32_t I2C4SIE:1;
    uint32_t I2C4MIE:1;
    uint32_t :3;
    uint32_t U5EIE:1;
    uint32_t U5RXIE:1;
    uint32_t U5TXIE:1;
    uint32_t I2C5BIE:1;
    uint32_t I2C5SIE:1;
    uint32_t I2C5MIE:1;
    uint32_t :3;
    uint32_t U6EIE:1;
    uint32_t U6RXIE:1;
    uint32_t U6TXIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __IEC5bits_t;
extern volatile __IEC5bits_t IEC5bits __asm__ ("IEC5") __attribute__((section("sfrs"), address(0xBF810110)));
extern volatile uint32_t        IEC5CLR __attribute__((section("sfrs"),address(0xBF810114)));
extern volatile uint32_t        IEC5SET __attribute__((section("sfrs"),address(0xBF810118)));
extern volatile uint32_t        IEC5INV __attribute__((section("sfrs"),address(0xBF81011C)));
#define IEC6 IEC6
extern volatile uint32_t   IEC6 __attribute__((section("sfrs"), address(0xBF810120)));
typedef union {
  struct {
    uint32_t ADCEOSIE:1;
    uint32_t ADCARDYIE:1;
    uint32_t ADCURDYIE:1;
    uint32_t :1;
    uint32_t ADCGRPIE:1;
    uint32_t :1;
    uint32_t ADC0EIE:1;
    uint32_t ADC1EIE:1;
    uint32_t ADC2EIE:1;
    uint32_t ADC3EIE:1;
    uint32_t ADC4EIE:1;
    uint32_t :2;
    uint32_t ADC7EIE:1;
    uint32_t ADC0WIE:1;
    uint32_t ADC1WIE:1;
    uint32_t ADC2WIE:1;
    uint32_t ADC3WIE:1;
    uint32_t ADC4WIE:1;
    uint32_t :2;
    uint32_t ADC7WIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __IEC6bits_t;
extern volatile __IEC6bits_t IEC6bits __asm__ ("IEC6") __attribute__((section("sfrs"), address(0xBF810120)));
extern volatile uint32_t        IEC6CLR __attribute__((section("sfrs"),address(0xBF810124)));
extern volatile uint32_t        IEC6SET __attribute__((section("sfrs"),address(0xBF810128)));
extern volatile uint32_t        IEC6INV __attribute__((section("sfrs"),address(0xBF81012C)));
#define IPC0 IPC0
extern volatile uint32_t   IPC0 __attribute__((section("sfrs"), address(0xBF810140)));
typedef union {
  struct {
    uint32_t CTIS:2;
    uint32_t CTIP:3;
    uint32_t :3;
    uint32_t CS0IS:2;
    uint32_t CS0IP:3;
    uint32_t :3;
    uint32_t CS1IS:2;
    uint32_t CS1IP:3;
    uint32_t :3;
    uint32_t INT0IS:2;
    uint32_t INT0IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC0bits_t;
extern volatile __IPC0bits_t IPC0bits __asm__ ("IPC0") __attribute__((section("sfrs"), address(0xBF810140)));
extern volatile uint32_t        IPC0CLR __attribute__((section("sfrs"),address(0xBF810144)));
extern volatile uint32_t        IPC0SET __attribute__((section("sfrs"),address(0xBF810148)));
extern volatile uint32_t        IPC0INV __attribute__((section("sfrs"),address(0xBF81014C)));
#define IPC1 IPC1
extern volatile uint32_t   IPC1 __attribute__((section("sfrs"), address(0xBF810150)));
typedef union {
  struct {
    uint32_t T1IS:2;
    uint32_t T1IP:3;
    uint32_t :3;
    uint32_t IC1EIS:2;
    uint32_t IC1EIP:3;
    uint32_t :3;
    uint32_t IC1IS:2;
    uint32_t IC1IP:3;
    uint32_t :3;
    uint32_t OC1IS:2;
    uint32_t OC1IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC1bits_t;
extern volatile __IPC1bits_t IPC1bits __asm__ ("IPC1") __attribute__((section("sfrs"), address(0xBF810150)));
extern volatile uint32_t        IPC1CLR __attribute__((section("sfrs"),address(0xBF810154)));
extern volatile uint32_t        IPC1SET __attribute__((section("sfrs"),address(0xBF810158)));
extern volatile uint32_t        IPC1INV __attribute__((section("sfrs"),address(0xBF81015C)));
#define IPC2 IPC2
extern volatile uint32_t   IPC2 __attribute__((section("sfrs"), address(0xBF810160)));
typedef union {
  struct {
    uint32_t INT1IS:2;
    uint32_t INT1IP:3;
    uint32_t :3;
    uint32_t T2IS:2;
    uint32_t T2IP:3;
    uint32_t :3;
    uint32_t IC2EIS:2;
    uint32_t IC2EIP:3;
    uint32_t :3;
    uint32_t IC2IS:2;
    uint32_t IC2IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC2bits_t;
extern volatile __IPC2bits_t IPC2bits __asm__ ("IPC2") __attribute__((section("sfrs"), address(0xBF810160)));
extern volatile uint32_t        IPC2CLR __attribute__((section("sfrs"),address(0xBF810164)));
extern volatile uint32_t        IPC2SET __attribute__((section("sfrs"),address(0xBF810168)));
extern volatile uint32_t        IPC2INV __attribute__((section("sfrs"),address(0xBF81016C)));
#define IPC3 IPC3
extern volatile uint32_t   IPC3 __attribute__((section("sfrs"), address(0xBF810170)));
typedef union {
  struct {
    uint32_t OC2IS:2;
    uint32_t OC2IP:3;
    uint32_t :3;
    uint32_t INT2IS:2;
    uint32_t INT2IP:3;
    uint32_t :3;
    uint32_t T3IS:2;
    uint32_t T3IP:3;
    uint32_t :3;
    uint32_t IC3EIS:2;
    uint32_t IC3EIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC3bits_t;
extern volatile __IPC3bits_t IPC3bits __asm__ ("IPC3") __attribute__((section("sfrs"), address(0xBF810170)));
extern volatile uint32_t        IPC3CLR __attribute__((section("sfrs"),address(0xBF810174)));
extern volatile uint32_t        IPC3SET __attribute__((section("sfrs"),address(0xBF810178)));
extern volatile uint32_t        IPC3INV __attribute__((section("sfrs"),address(0xBF81017C)));
#define IPC4 IPC4
extern volatile uint32_t   IPC4 __attribute__((section("sfrs"), address(0xBF810180)));
typedef union {
  struct {
    uint32_t IC3IS:2;
    uint32_t IC3IP:3;
    uint32_t :3;
    uint32_t OC3IS:2;
    uint32_t OC3IP:3;
    uint32_t :3;
    uint32_t INT3IS:2;
    uint32_t INT3IP:3;
    uint32_t :3;
    uint32_t T4IS:2;
    uint32_t T4IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC4bits_t;
extern volatile __IPC4bits_t IPC4bits __asm__ ("IPC4") __attribute__((section("sfrs"), address(0xBF810180)));
extern volatile uint32_t        IPC4CLR __attribute__((section("sfrs"),address(0xBF810184)));
extern volatile uint32_t        IPC4SET __attribute__((section("sfrs"),address(0xBF810188)));
extern volatile uint32_t        IPC4INV __attribute__((section("sfrs"),address(0xBF81018C)));
#define IPC5 IPC5
extern volatile uint32_t   IPC5 __attribute__((section("sfrs"), address(0xBF810190)));
typedef union {
  struct {
    uint32_t IC4EIS:2;
    uint32_t IC4EIP:3;
    uint32_t :3;
    uint32_t IC4IS:2;
    uint32_t IC4IP:3;
    uint32_t :3;
    uint32_t OC4IS:2;
    uint32_t OC4IP:3;
    uint32_t :3;
    uint32_t INT4IS:2;
    uint32_t INT4IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC5bits_t;
extern volatile __IPC5bits_t IPC5bits __asm__ ("IPC5") __attribute__((section("sfrs"), address(0xBF810190)));
extern volatile uint32_t        IPC5CLR __attribute__((section("sfrs"),address(0xBF810194)));
extern volatile uint32_t        IPC5SET __attribute__((section("sfrs"),address(0xBF810198)));
extern volatile uint32_t        IPC5INV __attribute__((section("sfrs"),address(0xBF81019C)));
#define IPC6 IPC6
extern volatile uint32_t   IPC6 __attribute__((section("sfrs"), address(0xBF8101A0)));
typedef union {
  struct {
    uint32_t T5IS:2;
    uint32_t T5IP:3;
    uint32_t :3;
    uint32_t IC5EIS:2;
    uint32_t IC5EIP:3;
    uint32_t :3;
    uint32_t IC5IS:2;
    uint32_t IC5IP:3;
    uint32_t :3;
    uint32_t OC5IS:2;
    uint32_t OC5IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC6bits_t;
extern volatile __IPC6bits_t IPC6bits __asm__ ("IPC6") __attribute__((section("sfrs"), address(0xBF8101A0)));
extern volatile uint32_t        IPC6CLR __attribute__((section("sfrs"),address(0xBF8101A4)));
extern volatile uint32_t        IPC6SET __attribute__((section("sfrs"),address(0xBF8101A8)));
extern volatile uint32_t        IPC6INV __attribute__((section("sfrs"),address(0xBF8101AC)));
#define IPC7 IPC7
extern volatile uint32_t   IPC7 __attribute__((section("sfrs"), address(0xBF8101B0)));
typedef union {
  struct {
    uint32_t T6IS:2;
    uint32_t T6IP:3;
    uint32_t :3;
    uint32_t IC6EIS:2;
    uint32_t IC6EIP:3;
    uint32_t :3;
    uint32_t IC6IS:2;
    uint32_t IC6IP:3;
    uint32_t :3;
    uint32_t OC6IS:2;
    uint32_t OC6IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC7bits_t;
extern volatile __IPC7bits_t IPC7bits __asm__ ("IPC7") __attribute__((section("sfrs"), address(0xBF8101B0)));
extern volatile uint32_t        IPC7CLR __attribute__((section("sfrs"),address(0xBF8101B4)));
extern volatile uint32_t        IPC7SET __attribute__((section("sfrs"),address(0xBF8101B8)));
extern volatile uint32_t        IPC7INV __attribute__((section("sfrs"),address(0xBF8101BC)));
#define IPC8 IPC8
extern volatile uint32_t   IPC8 __attribute__((section("sfrs"), address(0xBF8101C0)));
typedef union {
  struct {
    uint32_t T7IS:2;
    uint32_t T7IP:3;
    uint32_t :3;
    uint32_t IC7EIS:2;
    uint32_t IC7EIP:3;
    uint32_t :3;
    uint32_t IC7IS:2;
    uint32_t IC7IP:3;
    uint32_t :3;
    uint32_t OC7IS:2;
    uint32_t OC7IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC8bits_t;
extern volatile __IPC8bits_t IPC8bits __asm__ ("IPC8") __attribute__((section("sfrs"), address(0xBF8101C0)));
extern volatile uint32_t        IPC8CLR __attribute__((section("sfrs"),address(0xBF8101C4)));
extern volatile uint32_t        IPC8SET __attribute__((section("sfrs"),address(0xBF8101C8)));
extern volatile uint32_t        IPC8INV __attribute__((section("sfrs"),address(0xBF8101CC)));
#define IPC9 IPC9
extern volatile uint32_t   IPC9 __attribute__((section("sfrs"), address(0xBF8101D0)));
typedef union {
  struct {
    uint32_t T8IS:2;
    uint32_t T8IP:3;
    uint32_t :3;
    uint32_t IC8EIS:2;
    uint32_t IC8EIP:3;
    uint32_t :3;
    uint32_t IC8IS:2;
    uint32_t IC8IP:3;
    uint32_t :3;
    uint32_t OC8IS:2;
    uint32_t OC8IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC9bits_t;
extern volatile __IPC9bits_t IPC9bits __asm__ ("IPC9") __attribute__((section("sfrs"), address(0xBF8101D0)));
extern volatile uint32_t        IPC9CLR __attribute__((section("sfrs"),address(0xBF8101D4)));
extern volatile uint32_t        IPC9SET __attribute__((section("sfrs"),address(0xBF8101D8)));
extern volatile uint32_t        IPC9INV __attribute__((section("sfrs"),address(0xBF8101DC)));
#define IPC10 IPC10
extern volatile uint32_t   IPC10 __attribute__((section("sfrs"), address(0xBF8101E0)));
typedef union {
  struct {
    uint32_t T9IS:2;
    uint32_t T9IP:3;
    uint32_t :3;
    uint32_t IC9EIS:2;
    uint32_t IC9EIP:3;
    uint32_t :3;
    uint32_t IC9IS:2;
    uint32_t IC9IP:3;
    uint32_t :3;
    uint32_t OC9IS:2;
    uint32_t OC9IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC10bits_t;
extern volatile __IPC10bits_t IPC10bits __asm__ ("IPC10") __attribute__((section("sfrs"), address(0xBF8101E0)));
extern volatile uint32_t        IPC10CLR __attribute__((section("sfrs"),address(0xBF8101E4)));
extern volatile uint32_t        IPC10SET __attribute__((section("sfrs"),address(0xBF8101E8)));
extern volatile uint32_t        IPC10INV __attribute__((section("sfrs"),address(0xBF8101EC)));
#define IPC11 IPC11
extern volatile uint32_t   IPC11 __attribute__((section("sfrs"), address(0xBF8101F0)));
typedef union {
  struct {
    uint32_t ADCIS:2;
    uint32_t ADCIP:3;
    uint32_t :3;
    uint32_t ADCFIFOIS:2;
    uint32_t ADCFIFOIP:3;
    uint32_t :3;
    uint32_t ADCDC1IS:2;
    uint32_t ADCDC1IP:3;
    uint32_t :3;
    uint32_t ADCDC2IS:2;
    uint32_t ADCDC2IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC11bits_t;
extern volatile __IPC11bits_t IPC11bits __asm__ ("IPC11") __attribute__((section("sfrs"), address(0xBF8101F0)));
extern volatile uint32_t        IPC11CLR __attribute__((section("sfrs"),address(0xBF8101F4)));
extern volatile uint32_t        IPC11SET __attribute__((section("sfrs"),address(0xBF8101F8)));
extern volatile uint32_t        IPC11INV __attribute__((section("sfrs"),address(0xBF8101FC)));
#define IPC12 IPC12
extern volatile uint32_t   IPC12 __attribute__((section("sfrs"), address(0xBF810200)));
typedef union {
  struct {
    uint32_t ADCDC3IS:2;
    uint32_t ADCDC3IP:3;
    uint32_t :3;
    uint32_t ADCDC4IS:2;
    uint32_t ADCDC4IP:3;
    uint32_t :3;
    uint32_t ADCDC5IS:2;
    uint32_t ADCDC5IP:3;
    uint32_t :3;
    uint32_t ADCDC6IS:2;
    uint32_t ADCDC6IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC12bits_t;
extern volatile __IPC12bits_t IPC12bits __asm__ ("IPC12") __attribute__((section("sfrs"), address(0xBF810200)));
extern volatile uint32_t        IPC12CLR __attribute__((section("sfrs"),address(0xBF810204)));
extern volatile uint32_t        IPC12SET __attribute__((section("sfrs"),address(0xBF810208)));
extern volatile uint32_t        IPC12INV __attribute__((section("sfrs"),address(0xBF81020C)));
#define IPC13 IPC13
extern volatile uint32_t   IPC13 __attribute__((section("sfrs"), address(0xBF810210)));
typedef union {
  struct {
    uint32_t ADCDF1IS:2;
    uint32_t ADCDF1IP:3;
    uint32_t :3;
    uint32_t ADCDF2IS:2;
    uint32_t ADCDF2IP:3;
    uint32_t :3;
    uint32_t ADCDF3IS:2;
    uint32_t ADCDF3IP:3;
    uint32_t :3;
    uint32_t ADCDF4IS:2;
    uint32_t ADCDF4IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC13bits_t;
extern volatile __IPC13bits_t IPC13bits __asm__ ("IPC13") __attribute__((section("sfrs"), address(0xBF810210)));
extern volatile uint32_t        IPC13CLR __attribute__((section("sfrs"),address(0xBF810214)));
extern volatile uint32_t        IPC13SET __attribute__((section("sfrs"),address(0xBF810218)));
extern volatile uint32_t        IPC13INV __attribute__((section("sfrs"),address(0xBF81021C)));
#define IPC14 IPC14
extern volatile uint32_t   IPC14 __attribute__((section("sfrs"), address(0xBF810220)));
typedef union {
  struct {
    uint32_t ADCDF5IS:2;
    uint32_t ADCDF5IP:3;
    uint32_t :3;
    uint32_t ADCDF6IS:2;
    uint32_t ADCDF6IP:3;
    uint32_t :3;
    uint32_t ADCFLTIS:2;
    uint32_t ADCFLTIP:3;
    uint32_t :3;
    uint32_t ADCD0IS:2;
    uint32_t ADCD0IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC14bits_t;
extern volatile __IPC14bits_t IPC14bits __asm__ ("IPC14") __attribute__((section("sfrs"), address(0xBF810220)));
extern volatile uint32_t        IPC14CLR __attribute__((section("sfrs"),address(0xBF810224)));
extern volatile uint32_t        IPC14SET __attribute__((section("sfrs"),address(0xBF810228)));
extern volatile uint32_t        IPC14INV __attribute__((section("sfrs"),address(0xBF81022C)));
#define IPC15 IPC15
extern volatile uint32_t   IPC15 __attribute__((section("sfrs"), address(0xBF810230)));
typedef union {
  struct {
    uint32_t ADCD1IS:2;
    uint32_t ADCD1IP:3;
    uint32_t :3;
    uint32_t ADCD2IS:2;
    uint32_t ADCD2IP:3;
    uint32_t :3;
    uint32_t ADCD3IS:2;
    uint32_t ADCD3IP:3;
    uint32_t :3;
    uint32_t ADCD4IS:2;
    uint32_t ADCD4IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC15bits_t;
extern volatile __IPC15bits_t IPC15bits __asm__ ("IPC15") __attribute__((section("sfrs"), address(0xBF810230)));
extern volatile uint32_t        IPC15CLR __attribute__((section("sfrs"),address(0xBF810234)));
extern volatile uint32_t        IPC15SET __attribute__((section("sfrs"),address(0xBF810238)));
extern volatile uint32_t        IPC15INV __attribute__((section("sfrs"),address(0xBF81023C)));
#define IPC16 IPC16
extern volatile uint32_t   IPC16 __attribute__((section("sfrs"), address(0xBF810240)));
typedef union {
  struct {
    uint32_t ADCD5IS:2;
    uint32_t ADCD5IP:3;
    uint32_t :3;
    uint32_t ADCD6IS:2;
    uint32_t ADCD6IP:3;
    uint32_t :3;
    uint32_t ADCD7IS:2;
    uint32_t ADCD7IP:3;
    uint32_t :3;
    uint32_t ADCD8IS:2;
    uint32_t ADCD8IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC16bits_t;
extern volatile __IPC16bits_t IPC16bits __asm__ ("IPC16") __attribute__((section("sfrs"), address(0xBF810240)));
extern volatile uint32_t        IPC16CLR __attribute__((section("sfrs"),address(0xBF810244)));
extern volatile uint32_t        IPC16SET __attribute__((section("sfrs"),address(0xBF810248)));
extern volatile uint32_t        IPC16INV __attribute__((section("sfrs"),address(0xBF81024C)));
#define IPC17 IPC17
extern volatile uint32_t   IPC17 __attribute__((section("sfrs"), address(0xBF810250)));
typedef union {
  struct {
    uint32_t ADCD9IS:2;
    uint32_t ADCD9IP:3;
    uint32_t :3;
    uint32_t ADCD10IS:2;
    uint32_t ADCD10IP:3;
    uint32_t :3;
    uint32_t ADCD11IS:2;
    uint32_t ADCD11IP:3;
    uint32_t :3;
    uint32_t ADCD12IS:2;
    uint32_t ADCD12IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC17bits_t;
extern volatile __IPC17bits_t IPC17bits __asm__ ("IPC17") __attribute__((section("sfrs"), address(0xBF810250)));
extern volatile uint32_t        IPC17CLR __attribute__((section("sfrs"),address(0xBF810254)));
extern volatile uint32_t        IPC17SET __attribute__((section("sfrs"),address(0xBF810258)));
extern volatile uint32_t        IPC17INV __attribute__((section("sfrs"),address(0xBF81025C)));
#define IPC18 IPC18
extern volatile uint32_t   IPC18 __attribute__((section("sfrs"), address(0xBF810260)));
typedef union {
  struct {
    uint32_t ADCD13IS:2;
    uint32_t ADCD13IP:3;
    uint32_t :3;
    uint32_t ADCD14IS:2;
    uint32_t ADCD14IP:3;
    uint32_t :3;
    uint32_t ADCD15IS:2;
    uint32_t ADCD15IP:3;
    uint32_t :3;
    uint32_t ADCD16IS:2;
    uint32_t ADCD16IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC18bits_t;
extern volatile __IPC18bits_t IPC18bits __asm__ ("IPC18") __attribute__((section("sfrs"), address(0xBF810260)));
extern volatile uint32_t        IPC18CLR __attribute__((section("sfrs"),address(0xBF810264)));
extern volatile uint32_t        IPC18SET __attribute__((section("sfrs"),address(0xBF810268)));
extern volatile uint32_t        IPC18INV __attribute__((section("sfrs"),address(0xBF81026C)));
#define IPC19 IPC19
extern volatile uint32_t   IPC19 __attribute__((section("sfrs"), address(0xBF810270)));
typedef union {
  struct {
    uint32_t ADCD17IS:2;
    uint32_t ADCD17IP:3;
    uint32_t :3;
    uint32_t ADCD18IS:2;
    uint32_t ADCD18IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC19bits_t;
extern volatile __IPC19bits_t IPC19bits __asm__ ("IPC19") __attribute__((section("sfrs"), address(0xBF810270)));
extern volatile uint32_t        IPC19CLR __attribute__((section("sfrs"),address(0xBF810274)));
extern volatile uint32_t        IPC19SET __attribute__((section("sfrs"),address(0xBF810278)));
extern volatile uint32_t        IPC19INV __attribute__((section("sfrs"),address(0xBF81027C)));
#define IPC25 IPC25
extern volatile uint32_t   IPC25 __attribute__((section("sfrs"), address(0xBF8102D0)));
typedef union {
  struct {
    uint32_t :16;
    uint32_t ADCD43IS:2;
    uint32_t ADCD43IP:3;
    uint32_t :3;
    uint32_t ADCD44IS:2;
    uint32_t ADCD44IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC25bits_t;
extern volatile __IPC25bits_t IPC25bits __asm__ ("IPC25") __attribute__((section("sfrs"), address(0xBF8102D0)));
extern volatile uint32_t        IPC25CLR __attribute__((section("sfrs"),address(0xBF8102D4)));
extern volatile uint32_t        IPC25SET __attribute__((section("sfrs"),address(0xBF8102D8)));
extern volatile uint32_t        IPC25INV __attribute__((section("sfrs"),address(0xBF8102DC)));
#define IPC26 IPC26
extern volatile uint32_t   IPC26 __attribute__((section("sfrs"), address(0xBF8102E0)));
typedef union {
  struct {
    uint32_t CPCIS:2;
    uint32_t CPCIP:3;
    uint32_t :3;
    uint32_t CFDCIS:2;
    uint32_t CFDCIP:3;
    uint32_t :3;
    uint32_t SBIS:2;
    uint32_t SBIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC26bits_t;
extern volatile __IPC26bits_t IPC26bits __asm__ ("IPC26") __attribute__((section("sfrs"), address(0xBF8102E0)));
extern volatile uint32_t        IPC26CLR __attribute__((section("sfrs"),address(0xBF8102E4)));
extern volatile uint32_t        IPC26SET __attribute__((section("sfrs"),address(0xBF8102E8)));
extern volatile uint32_t        IPC26INV __attribute__((section("sfrs"),address(0xBF8102EC)));
#define IPC27 IPC27
extern volatile uint32_t   IPC27 __attribute__((section("sfrs"), address(0xBF8102F0)));
typedef union {
  struct {
    uint32_t :8;
    uint32_t SPI1EIS:2;
    uint32_t SPI1EIP:3;
    uint32_t :3;
    uint32_t SPI1RXIS:2;
    uint32_t SPI1RXIP:3;
    uint32_t :3;
    uint32_t SPI1TXIS:2;
    uint32_t SPI1TXIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC27bits_t;
extern volatile __IPC27bits_t IPC27bits __asm__ ("IPC27") __attribute__((section("sfrs"), address(0xBF8102F0)));
extern volatile uint32_t        IPC27CLR __attribute__((section("sfrs"),address(0xBF8102F4)));
extern volatile uint32_t        IPC27SET __attribute__((section("sfrs"),address(0xBF8102F8)));
extern volatile uint32_t        IPC27INV __attribute__((section("sfrs"),address(0xBF8102FC)));
#define IPC28 IPC28
extern volatile uint32_t   IPC28 __attribute__((section("sfrs"), address(0xBF810300)));
typedef union {
  struct {
    uint32_t U1EIS:2;
    uint32_t U1EIP:3;
    uint32_t :3;
    uint32_t U1RXIS:2;
    uint32_t U1RXIP:3;
    uint32_t :3;
    uint32_t U1TXIS:2;
    uint32_t U1TXIP:3;
    uint32_t :3;
    uint32_t I2C1BIS:2;
    uint32_t I2C1BIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC28bits_t;
extern volatile __IPC28bits_t IPC28bits __asm__ ("IPC28") __attribute__((section("sfrs"), address(0xBF810300)));
extern volatile uint32_t        IPC28CLR __attribute__((section("sfrs"),address(0xBF810304)));
extern volatile uint32_t        IPC28SET __attribute__((section("sfrs"),address(0xBF810308)));
extern volatile uint32_t        IPC28INV __attribute__((section("sfrs"),address(0xBF81030C)));
#define IPC29 IPC29
extern volatile uint32_t   IPC29 __attribute__((section("sfrs"), address(0xBF810310)));
typedef union {
  struct {
    uint32_t I2C1SIS:2;
    uint32_t I2C1SIP:3;
    uint32_t :3;
    uint32_t I2C1MIS:2;
    uint32_t I2C1MIP:3;
    uint32_t :11;
    uint32_t CNBIS:2;
    uint32_t CNBIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC29bits_t;
extern volatile __IPC29bits_t IPC29bits __asm__ ("IPC29") __attribute__((section("sfrs"), address(0xBF810310)));
extern volatile uint32_t        IPC29CLR __attribute__((section("sfrs"),address(0xBF810314)));
extern volatile uint32_t        IPC29SET __attribute__((section("sfrs"),address(0xBF810318)));
extern volatile uint32_t        IPC29INV __attribute__((section("sfrs"),address(0xBF81031C)));
#define IPC30 IPC30
extern volatile uint32_t   IPC30 __attribute__((section("sfrs"), address(0xBF810320)));
typedef union {
  struct {
    uint32_t CNCIS:2;
    uint32_t CNCIP:3;
    uint32_t :3;
    uint32_t CNDIS:2;
    uint32_t CNDIP:3;
    uint32_t :3;
    uint32_t CNEIS:2;
    uint32_t CNEIP:3;
    uint32_t :3;
    uint32_t CNFIS:2;
    uint32_t CNFIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC30bits_t;
extern volatile __IPC30bits_t IPC30bits __asm__ ("IPC30") __attribute__((section("sfrs"), address(0xBF810320)));
extern volatile uint32_t        IPC30CLR __attribute__((section("sfrs"),address(0xBF810324)));
extern volatile uint32_t        IPC30SET __attribute__((section("sfrs"),address(0xBF810328)));
extern volatile uint32_t        IPC30INV __attribute__((section("sfrs"),address(0xBF81032C)));
#define IPC31 IPC31
extern volatile uint32_t   IPC31 __attribute__((section("sfrs"), address(0xBF810330)));
typedef union {
  struct {
    uint32_t CNGIS:2;
    uint32_t CNGIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC31bits_t;
extern volatile __IPC31bits_t IPC31bits __asm__ ("IPC31") __attribute__((section("sfrs"), address(0xBF810330)));
extern volatile uint32_t        IPC31CLR __attribute__((section("sfrs"),address(0xBF810334)));
extern volatile uint32_t        IPC31SET __attribute__((section("sfrs"),address(0xBF810338)));
extern volatile uint32_t        IPC31INV __attribute__((section("sfrs"),address(0xBF81033C)));
#define IPC32 IPC32
extern volatile uint32_t   IPC32 __attribute__((section("sfrs"), address(0xBF810340)));
typedef union {
  struct {
    uint32_t PMPIS:2;
    uint32_t PMPIP:3;
    uint32_t :3;
    uint32_t PMPEIS:2;
    uint32_t PMPEIP:3;
    uint32_t :3;
    uint32_t CMP1IS:2;
    uint32_t CMP1IP:3;
    uint32_t :3;
    uint32_t CMP2IS:2;
    uint32_t CMP2IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC32bits_t;
extern volatile __IPC32bits_t IPC32bits __asm__ ("IPC32") __attribute__((section("sfrs"), address(0xBF810340)));
extern volatile uint32_t        IPC32CLR __attribute__((section("sfrs"),address(0xBF810344)));
extern volatile uint32_t        IPC32SET __attribute__((section("sfrs"),address(0xBF810348)));
extern volatile uint32_t        IPC32INV __attribute__((section("sfrs"),address(0xBF81034C)));
#define IPC33 IPC33
extern volatile uint32_t   IPC33 __attribute__((section("sfrs"), address(0xBF810350)));
typedef union {
  struct {
    uint32_t USBIS:2;
    uint32_t USBIP:3;
    uint32_t :3;
    uint32_t USBDMAIS:2;
    uint32_t USBDMAIP:3;
    uint32_t :3;
    uint32_t DMA0IS:2;
    uint32_t DMA0IP:3;
    uint32_t :3;
    uint32_t DMA1IS:2;
    uint32_t DMA1IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC33bits_t;
extern volatile __IPC33bits_t IPC33bits __asm__ ("IPC33") __attribute__((section("sfrs"), address(0xBF810350)));
extern volatile uint32_t        IPC33CLR __attribute__((section("sfrs"),address(0xBF810354)));
extern volatile uint32_t        IPC33SET __attribute__((section("sfrs"),address(0xBF810358)));
extern volatile uint32_t        IPC33INV __attribute__((section("sfrs"),address(0xBF81035C)));
#define IPC34 IPC34
extern volatile uint32_t   IPC34 __attribute__((section("sfrs"), address(0xBF810360)));
typedef union {
  struct {
    uint32_t DMA2IS:2;
    uint32_t DMA2IP:3;
    uint32_t :3;
    uint32_t DMA3IS:2;
    uint32_t DMA3IP:3;
    uint32_t :3;
    uint32_t DMA4IS:2;
    uint32_t DMA4IP:3;
    uint32_t :3;
    uint32_t DMA5IS:2;
    uint32_t DMA5IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC34bits_t;
extern volatile __IPC34bits_t IPC34bits __asm__ ("IPC34") __attribute__((section("sfrs"), address(0xBF810360)));
extern volatile uint32_t        IPC34CLR __attribute__((section("sfrs"),address(0xBF810364)));
extern volatile uint32_t        IPC34SET __attribute__((section("sfrs"),address(0xBF810368)));
extern volatile uint32_t        IPC34INV __attribute__((section("sfrs"),address(0xBF81036C)));
#define IPC35 IPC35
extern volatile uint32_t   IPC35 __attribute__((section("sfrs"), address(0xBF810370)));
typedef union {
  struct {
    uint32_t DMA6IS:2;
    uint32_t DMA6IP:3;
    uint32_t :3;
    uint32_t DMA7IS:2;
    uint32_t DMA7IP:3;
    uint32_t :3;
    uint32_t SPI2EIS:2;
    uint32_t SPI2EIP:3;
    uint32_t :3;
    uint32_t SPI2RXIS:2;
    uint32_t SPI2RXIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC35bits_t;
extern volatile __IPC35bits_t IPC35bits __asm__ ("IPC35") __attribute__((section("sfrs"), address(0xBF810370)));
extern volatile uint32_t        IPC35CLR __attribute__((section("sfrs"),address(0xBF810374)));
extern volatile uint32_t        IPC35SET __attribute__((section("sfrs"),address(0xBF810378)));
extern volatile uint32_t        IPC35INV __attribute__((section("sfrs"),address(0xBF81037C)));
#define IPC36 IPC36
extern volatile uint32_t   IPC36 __attribute__((section("sfrs"), address(0xBF810380)));
typedef union {
  struct {
    uint32_t SPI2TXIS:2;
    uint32_t SPI2TXIP:3;
    uint32_t :3;
    uint32_t U2EIS:2;
    uint32_t U2EIP:3;
    uint32_t :3;
    uint32_t U2RXIS:2;
    uint32_t U2RXIP:3;
    uint32_t :3;
    uint32_t U2TXIS:2;
    uint32_t U2TXIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC36bits_t;
extern volatile __IPC36bits_t IPC36bits __asm__ ("IPC36") __attribute__((section("sfrs"), address(0xBF810380)));
extern volatile uint32_t        IPC36CLR __attribute__((section("sfrs"),address(0xBF810384)));
extern volatile uint32_t        IPC36SET __attribute__((section("sfrs"),address(0xBF810388)));
extern volatile uint32_t        IPC36INV __attribute__((section("sfrs"),address(0xBF81038C)));
#define IPC37 IPC37
extern volatile uint32_t   IPC37 __attribute__((section("sfrs"), address(0xBF810390)));
typedef union {
  struct {
    uint32_t :24;
    uint32_t CAN1IS:2;
    uint32_t CAN1IP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC37bits_t;
extern volatile __IPC37bits_t IPC37bits __asm__ ("IPC37") __attribute__((section("sfrs"), address(0xBF810390)));
extern volatile uint32_t        IPC37CLR __attribute__((section("sfrs"),address(0xBF810394)));
extern volatile uint32_t        IPC37SET __attribute__((section("sfrs"),address(0xBF810398)));
extern volatile uint32_t        IPC37INV __attribute__((section("sfrs"),address(0xBF81039C)));
#define IPC38 IPC38
extern volatile uint32_t   IPC38 __attribute__((section("sfrs"), address(0xBF8103A0)));
typedef union {
  struct {
    uint32_t CAN2IS:2;
    uint32_t CAN2IP:3;
    uint32_t :3;
    uint32_t ETHIS:2;
    uint32_t ETHIP:3;
    uint32_t :3;
    uint32_t SPI3EIS:2;
    uint32_t SPI3EIP:3;
    uint32_t :3;
    uint32_t SPI3RXIS:2;
    uint32_t SPI3RXIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC38bits_t;
extern volatile __IPC38bits_t IPC38bits __asm__ ("IPC38") __attribute__((section("sfrs"), address(0xBF8103A0)));
extern volatile uint32_t        IPC38CLR __attribute__((section("sfrs"),address(0xBF8103A4)));
extern volatile uint32_t        IPC38SET __attribute__((section("sfrs"),address(0xBF8103A8)));
extern volatile uint32_t        IPC38INV __attribute__((section("sfrs"),address(0xBF8103AC)));
#define IPC39 IPC39
extern volatile uint32_t   IPC39 __attribute__((section("sfrs"), address(0xBF8103B0)));
typedef union {
  struct {
    uint32_t SPI3TXIS:2;
    uint32_t SPI3TXIP:3;
    uint32_t :3;
    uint32_t U3EIS:2;
    uint32_t U3EIP:3;
    uint32_t :3;
    uint32_t U3RXIS:2;
    uint32_t U3RXIP:3;
    uint32_t :3;
    uint32_t U3TXIS:2;
    uint32_t U3TXIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC39bits_t;
extern volatile __IPC39bits_t IPC39bits __asm__ ("IPC39") __attribute__((section("sfrs"), address(0xBF8103B0)));
extern volatile uint32_t        IPC39CLR __attribute__((section("sfrs"),address(0xBF8103B4)));
extern volatile uint32_t        IPC39SET __attribute__((section("sfrs"),address(0xBF8103B8)));
extern volatile uint32_t        IPC39INV __attribute__((section("sfrs"),address(0xBF8103BC)));
#define IPC40 IPC40
extern volatile uint32_t   IPC40 __attribute__((section("sfrs"), address(0xBF8103C0)));
typedef union {
  struct {
    uint32_t I2C3BIS:2;
    uint32_t I2C3BIP:3;
    uint32_t :3;
    uint32_t I2C3SIS:2;
    uint32_t I2C3SIP:3;
    uint32_t :3;
    uint32_t I2C3MIS:2;
    uint32_t I2C3MIP:3;
    uint32_t :3;
    uint32_t SPI4EIS:2;
    uint32_t SPI4EIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC40bits_t;
extern volatile __IPC40bits_t IPC40bits __asm__ ("IPC40") __attribute__((section("sfrs"), address(0xBF8103C0)));
extern volatile uint32_t        IPC40CLR __attribute__((section("sfrs"),address(0xBF8103C4)));
extern volatile uint32_t        IPC40SET __attribute__((section("sfrs"),address(0xBF8103C8)));
extern volatile uint32_t        IPC40INV __attribute__((section("sfrs"),address(0xBF8103CC)));
#define IPC41 IPC41
extern volatile uint32_t   IPC41 __attribute__((section("sfrs"), address(0xBF8103D0)));
typedef union {
  struct {
    uint32_t SPI4RXIS:2;
    uint32_t SPI4RXIP:3;
    uint32_t :3;
    uint32_t SPI4TXIS:2;
    uint32_t SPI4TXIP:3;
    uint32_t :3;
    uint32_t RTCCIS:2;
    uint32_t RTCCIP:3;
    uint32_t :3;
    uint32_t FCEIS:2;
    uint32_t FCEIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC41bits_t;
extern volatile __IPC41bits_t IPC41bits __asm__ ("IPC41") __attribute__((section("sfrs"), address(0xBF8103D0)));
extern volatile uint32_t        IPC41CLR __attribute__((section("sfrs"),address(0xBF8103D4)));
extern volatile uint32_t        IPC41SET __attribute__((section("sfrs"),address(0xBF8103D8)));
extern volatile uint32_t        IPC41INV __attribute__((section("sfrs"),address(0xBF8103DC)));
#define IPC42 IPC42
extern volatile uint32_t   IPC42 __attribute__((section("sfrs"), address(0xBF8103E0)));
typedef union {
  struct {
    uint32_t PREIS:2;
    uint32_t PREIP:3;
    uint32_t :3;
    uint32_t SQI1IS:2;
    uint32_t SQI1IP:3;
    uint32_t :3;
    uint32_t U4EIS:2;
    uint32_t U4EIP:3;
    uint32_t :3;
    uint32_t U4RXIS:2;
    uint32_t U4RXIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC42bits_t;
extern volatile __IPC42bits_t IPC42bits __asm__ ("IPC42") __attribute__((section("sfrs"), address(0xBF8103E0)));
extern volatile uint32_t        IPC42CLR __attribute__((section("sfrs"),address(0xBF8103E4)));
extern volatile uint32_t        IPC42SET __attribute__((section("sfrs"),address(0xBF8103E8)));
extern volatile uint32_t        IPC42INV __attribute__((section("sfrs"),address(0xBF8103EC)));
#define IPC43 IPC43
extern volatile uint32_t   IPC43 __attribute__((section("sfrs"), address(0xBF8103F0)));
typedef union {
  struct {
    uint32_t U4TXIS:2;
    uint32_t U4TXIP:3;
    uint32_t :3;
    uint32_t I2C4BIS:2;
    uint32_t I2C4BIP:3;
    uint32_t :3;
    uint32_t I2C4SIS:2;
    uint32_t I2C4SIP:3;
    uint32_t :3;
    uint32_t I2C4MIS:2;
    uint32_t I2C4MIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC43bits_t;
extern volatile __IPC43bits_t IPC43bits __asm__ ("IPC43") __attribute__((section("sfrs"), address(0xBF8103F0)));
extern volatile uint32_t        IPC43CLR __attribute__((section("sfrs"),address(0xBF8103F4)));
extern volatile uint32_t        IPC43SET __attribute__((section("sfrs"),address(0xBF8103F8)));
extern volatile uint32_t        IPC43INV __attribute__((section("sfrs"),address(0xBF8103FC)));
#define IPC44 IPC44
extern volatile uint32_t   IPC44 __attribute__((section("sfrs"), address(0xBF810400)));
typedef union {
  struct {
    uint32_t :24;
    uint32_t U5EIS:2;
    uint32_t U5EIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC44bits_t;
extern volatile __IPC44bits_t IPC44bits __asm__ ("IPC44") __attribute__((section("sfrs"), address(0xBF810400)));
extern volatile uint32_t        IPC44CLR __attribute__((section("sfrs"),address(0xBF810404)));
extern volatile uint32_t        IPC44SET __attribute__((section("sfrs"),address(0xBF810408)));
extern volatile uint32_t        IPC44INV __attribute__((section("sfrs"),address(0xBF81040C)));
#define IPC45 IPC45
extern volatile uint32_t   IPC45 __attribute__((section("sfrs"), address(0xBF810410)));
typedef union {
  struct {
    uint32_t U5RXIS:2;
    uint32_t U5RXIP:3;
    uint32_t :3;
    uint32_t U5TXIS:2;
    uint32_t U5TXIP:3;
    uint32_t :3;
    uint32_t I2C5BIS:2;
    uint32_t I2C5BIP:3;
    uint32_t :3;
    uint32_t I2C5SIS:2;
    uint32_t I2C5SIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC45bits_t;
extern volatile __IPC45bits_t IPC45bits __asm__ ("IPC45") __attribute__((section("sfrs"), address(0xBF810410)));
extern volatile uint32_t        IPC45CLR __attribute__((section("sfrs"),address(0xBF810414)));
extern volatile uint32_t        IPC45SET __attribute__((section("sfrs"),address(0xBF810418)));
extern volatile uint32_t        IPC45INV __attribute__((section("sfrs"),address(0xBF81041C)));
#define IPC46 IPC46
extern volatile uint32_t   IPC46 __attribute__((section("sfrs"), address(0xBF810420)));
typedef union {
  struct {
    uint32_t I2C5MIS:2;
    uint32_t I2C5MIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC46bits_t;
extern volatile __IPC46bits_t IPC46bits __asm__ ("IPC46") __attribute__((section("sfrs"), address(0xBF810420)));
extern volatile uint32_t        IPC46CLR __attribute__((section("sfrs"),address(0xBF810424)));
extern volatile uint32_t        IPC46SET __attribute__((section("sfrs"),address(0xBF810428)));
extern volatile uint32_t        IPC46INV __attribute__((section("sfrs"),address(0xBF81042C)));
#define IPC47 IPC47
extern volatile uint32_t   IPC47 __attribute__((section("sfrs"), address(0xBF810430)));
typedef union {
  struct {
    uint32_t U6EIS:2;
    uint32_t U6EIP:3;
    uint32_t :3;
    uint32_t U6RXIS:2;
    uint32_t U6RXIP:3;
    uint32_t :3;
    uint32_t U6TXIS:2;
    uint32_t U6TXIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC47bits_t;
extern volatile __IPC47bits_t IPC47bits __asm__ ("IPC47") __attribute__((section("sfrs"), address(0xBF810430)));
extern volatile uint32_t        IPC47CLR __attribute__((section("sfrs"),address(0xBF810434)));
extern volatile uint32_t        IPC47SET __attribute__((section("sfrs"),address(0xBF810438)));
extern volatile uint32_t        IPC47INV __attribute__((section("sfrs"),address(0xBF81043C)));
#define IPC48 IPC48
extern volatile uint32_t   IPC48 __attribute__((section("sfrs"), address(0xBF810440)));
typedef union {
  struct {
    uint32_t ADCEOSIS:2;
    uint32_t ADCEOSIP:3;
    uint32_t :3;
    uint32_t ADCARDYIS:2;
    uint32_t ADCARDYIP:3;
    uint32_t :3;
    uint32_t ADCURDYIS:2;
    uint32_t ADCURDYIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC48bits_t;
extern volatile __IPC48bits_t IPC48bits __asm__ ("IPC48") __attribute__((section("sfrs"), address(0xBF810440)));
extern volatile uint32_t        IPC48CLR __attribute__((section("sfrs"),address(0xBF810444)));
extern volatile uint32_t        IPC48SET __attribute__((section("sfrs"),address(0xBF810448)));
extern volatile uint32_t        IPC48INV __attribute__((section("sfrs"),address(0xBF81044C)));
#define IPC49 IPC49
extern volatile uint32_t   IPC49 __attribute__((section("sfrs"), address(0xBF810450)));
typedef union {
  struct {
    uint32_t ADCGRPIS:2;
    uint32_t ADCGRPIP:3;
    uint32_t :11;
    uint32_t ADC0EIS:2;
    uint32_t ADC0EIP:3;
    uint32_t :3;
    uint32_t ADC1EIS:2;
    uint32_t ADC1EIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC49bits_t;
extern volatile __IPC49bits_t IPC49bits __asm__ ("IPC49") __attribute__((section("sfrs"), address(0xBF810450)));
extern volatile uint32_t        IPC49CLR __attribute__((section("sfrs"),address(0xBF810454)));
extern volatile uint32_t        IPC49SET __attribute__((section("sfrs"),address(0xBF810458)));
extern volatile uint32_t        IPC49INV __attribute__((section("sfrs"),address(0xBF81045C)));
#define IPC50 IPC50
extern volatile uint32_t   IPC50 __attribute__((section("sfrs"), address(0xBF810460)));
typedef union {
  struct {
    uint32_t ADC2EIS:2;
    uint32_t ADC2EIP:3;
    uint32_t :3;
    uint32_t ADC3EIS:2;
    uint32_t ADC3EIP:3;
    uint32_t :3;
    uint32_t ADC4EIS:2;
    uint32_t ADC4EIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC50bits_t;
extern volatile __IPC50bits_t IPC50bits __asm__ ("IPC50") __attribute__((section("sfrs"), address(0xBF810460)));
extern volatile uint32_t        IPC50CLR __attribute__((section("sfrs"),address(0xBF810464)));
extern volatile uint32_t        IPC50SET __attribute__((section("sfrs"),address(0xBF810468)));
extern volatile uint32_t        IPC50INV __attribute__((section("sfrs"),address(0xBF81046C)));
#define IPC51 IPC51
extern volatile uint32_t   IPC51 __attribute__((section("sfrs"), address(0xBF810470)));
typedef union {
  struct {
    uint32_t :8;
    uint32_t ADC7EIS:2;
    uint32_t ADC7EIP:3;
    uint32_t :3;
    uint32_t ADC0WIS:2;
    uint32_t ADC0WIP:3;
    uint32_t :3;
    uint32_t ADC1WIS:2;
    uint32_t ADC1WIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC51bits_t;
extern volatile __IPC51bits_t IPC51bits __asm__ ("IPC51") __attribute__((section("sfrs"), address(0xBF810470)));
extern volatile uint32_t        IPC51CLR __attribute__((section("sfrs"),address(0xBF810474)));
extern volatile uint32_t        IPC51SET __attribute__((section("sfrs"),address(0xBF810478)));
extern volatile uint32_t        IPC51INV __attribute__((section("sfrs"),address(0xBF81047C)));
#define IPC52 IPC52
extern volatile uint32_t   IPC52 __attribute__((section("sfrs"), address(0xBF810480)));
typedef union {
  struct {
    uint32_t ADC2WIS:2;
    uint32_t ADC2WIP:3;
    uint32_t :3;
    uint32_t ADC3WIS:2;
    uint32_t ADC3WIP:3;
    uint32_t :3;
    uint32_t ADC4WIS:2;
    uint32_t ADC4WIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC52bits_t;
extern volatile __IPC52bits_t IPC52bits __asm__ ("IPC52") __attribute__((section("sfrs"), address(0xBF810480)));
extern volatile uint32_t        IPC52CLR __attribute__((section("sfrs"),address(0xBF810484)));
extern volatile uint32_t        IPC52SET __attribute__((section("sfrs"),address(0xBF810488)));
extern volatile uint32_t        IPC52INV __attribute__((section("sfrs"),address(0xBF81048C)));
#define IPC53 IPC53
extern volatile uint32_t   IPC53 __attribute__((section("sfrs"), address(0xBF810490)));
typedef union {
  struct {
    uint32_t :8;
    uint32_t ADC7WIS:2;
    uint32_t ADC7WIP:3;
  };
  struct {
    uint32_t w:32;
  };
} __IPC53bits_t;
extern volatile __IPC53bits_t IPC53bits __asm__ ("IPC53") __attribute__((section("sfrs"), address(0xBF810490)));
extern volatile uint32_t        IPC53CLR __attribute__((section("sfrs"),address(0xBF810494)));
extern volatile uint32_t        IPC53SET __attribute__((section("sfrs"),address(0xBF810498)));
extern volatile uint32_t        IPC53INV __attribute__((section("sfrs"),address(0xBF81049C)));
#define OFF000 OFF000
extern volatile uint32_t   OFF000 __attribute__((section("sfrs"), address(0xBF810540)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF000bits_t;
extern volatile __OFF000bits_t OFF000bits __asm__ ("OFF000") __attribute__((section("sfrs"), address(0xBF810540)));
#define OFF001 OFF001
extern volatile uint32_t   OFF001 __attribute__((section("sfrs"), address(0xBF810544)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF001bits_t;
extern volatile __OFF001bits_t OFF001bits __asm__ ("OFF001") __attribute__((section("sfrs"), address(0xBF810544)));
#define OFF002 OFF002
extern volatile uint32_t   OFF002 __attribute__((section("sfrs"), address(0xBF810548)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF002bits_t;
extern volatile __OFF002bits_t OFF002bits __asm__ ("OFF002") __attribute__((section("sfrs"), address(0xBF810548)));
#define OFF003 OFF003
extern volatile uint32_t   OFF003 __attribute__((section("sfrs"), address(0xBF81054C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF003bits_t;
extern volatile __OFF003bits_t OFF003bits __asm__ ("OFF003") __attribute__((section("sfrs"), address(0xBF81054C)));
#define OFF004 OFF004
extern volatile uint32_t   OFF004 __attribute__((section("sfrs"), address(0xBF810550)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF004bits_t;
extern volatile __OFF004bits_t OFF004bits __asm__ ("OFF004") __attribute__((section("sfrs"), address(0xBF810550)));
#define OFF005 OFF005
extern volatile uint32_t   OFF005 __attribute__((section("sfrs"), address(0xBF810554)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF005bits_t;
extern volatile __OFF005bits_t OFF005bits __asm__ ("OFF005") __attribute__((section("sfrs"), address(0xBF810554)));
#define OFF006 OFF006
extern volatile uint32_t   OFF006 __attribute__((section("sfrs"), address(0xBF810558)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF006bits_t;
extern volatile __OFF006bits_t OFF006bits __asm__ ("OFF006") __attribute__((section("sfrs"), address(0xBF810558)));
#define OFF007 OFF007
extern volatile uint32_t   OFF007 __attribute__((section("sfrs"), address(0xBF81055C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF007bits_t;
extern volatile __OFF007bits_t OFF007bits __asm__ ("OFF007") __attribute__((section("sfrs"), address(0xBF81055C)));
#define OFF008 OFF008
extern volatile uint32_t   OFF008 __attribute__((section("sfrs"), address(0xBF810560)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF008bits_t;
extern volatile __OFF008bits_t OFF008bits __asm__ ("OFF008") __attribute__((section("sfrs"), address(0xBF810560)));
#define OFF009 OFF009
extern volatile uint32_t   OFF009 __attribute__((section("sfrs"), address(0xBF810564)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF009bits_t;
extern volatile __OFF009bits_t OFF009bits __asm__ ("OFF009") __attribute__((section("sfrs"), address(0xBF810564)));
#define OFF010 OFF010
extern volatile uint32_t   OFF010 __attribute__((section("sfrs"), address(0xBF810568)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF010bits_t;
extern volatile __OFF010bits_t OFF010bits __asm__ ("OFF010") __attribute__((section("sfrs"), address(0xBF810568)));
#define OFF011 OFF011
extern volatile uint32_t   OFF011 __attribute__((section("sfrs"), address(0xBF81056C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF011bits_t;
extern volatile __OFF011bits_t OFF011bits __asm__ ("OFF011") __attribute__((section("sfrs"), address(0xBF81056C)));
#define OFF012 OFF012
extern volatile uint32_t   OFF012 __attribute__((section("sfrs"), address(0xBF810570)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF012bits_t;
extern volatile __OFF012bits_t OFF012bits __asm__ ("OFF012") __attribute__((section("sfrs"), address(0xBF810570)));
#define OFF013 OFF013
extern volatile uint32_t   OFF013 __attribute__((section("sfrs"), address(0xBF810574)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF013bits_t;
extern volatile __OFF013bits_t OFF013bits __asm__ ("OFF013") __attribute__((section("sfrs"), address(0xBF810574)));
#define OFF014 OFF014
extern volatile uint32_t   OFF014 __attribute__((section("sfrs"), address(0xBF810578)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF014bits_t;
extern volatile __OFF014bits_t OFF014bits __asm__ ("OFF014") __attribute__((section("sfrs"), address(0xBF810578)));
#define OFF015 OFF015
extern volatile uint32_t   OFF015 __attribute__((section("sfrs"), address(0xBF81057C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF015bits_t;
extern volatile __OFF015bits_t OFF015bits __asm__ ("OFF015") __attribute__((section("sfrs"), address(0xBF81057C)));
#define OFF016 OFF016
extern volatile uint32_t   OFF016 __attribute__((section("sfrs"), address(0xBF810580)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF016bits_t;
extern volatile __OFF016bits_t OFF016bits __asm__ ("OFF016") __attribute__((section("sfrs"), address(0xBF810580)));
#define OFF017 OFF017
extern volatile uint32_t   OFF017 __attribute__((section("sfrs"), address(0xBF810584)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF017bits_t;
extern volatile __OFF017bits_t OFF017bits __asm__ ("OFF017") __attribute__((section("sfrs"), address(0xBF810584)));
#define OFF018 OFF018
extern volatile uint32_t   OFF018 __attribute__((section("sfrs"), address(0xBF810588)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF018bits_t;
extern volatile __OFF018bits_t OFF018bits __asm__ ("OFF018") __attribute__((section("sfrs"), address(0xBF810588)));
#define OFF019 OFF019
extern volatile uint32_t   OFF019 __attribute__((section("sfrs"), address(0xBF81058C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF019bits_t;
extern volatile __OFF019bits_t OFF019bits __asm__ ("OFF019") __attribute__((section("sfrs"), address(0xBF81058C)));
#define OFF020 OFF020
extern volatile uint32_t   OFF020 __attribute__((section("sfrs"), address(0xBF810590)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF020bits_t;
extern volatile __OFF020bits_t OFF020bits __asm__ ("OFF020") __attribute__((section("sfrs"), address(0xBF810590)));
#define OFF021 OFF021
extern volatile uint32_t   OFF021 __attribute__((section("sfrs"), address(0xBF810594)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF021bits_t;
extern volatile __OFF021bits_t OFF021bits __asm__ ("OFF021") __attribute__((section("sfrs"), address(0xBF810594)));
#define OFF022 OFF022
extern volatile uint32_t   OFF022 __attribute__((section("sfrs"), address(0xBF810598)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF022bits_t;
extern volatile __OFF022bits_t OFF022bits __asm__ ("OFF022") __attribute__((section("sfrs"), address(0xBF810598)));
#define OFF023 OFF023
extern volatile uint32_t   OFF023 __attribute__((section("sfrs"), address(0xBF81059C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF023bits_t;
extern volatile __OFF023bits_t OFF023bits __asm__ ("OFF023") __attribute__((section("sfrs"), address(0xBF81059C)));
#define OFF024 OFF024
extern volatile uint32_t   OFF024 __attribute__((section("sfrs"), address(0xBF8105A0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF024bits_t;
extern volatile __OFF024bits_t OFF024bits __asm__ ("OFF024") __attribute__((section("sfrs"), address(0xBF8105A0)));
#define OFF025 OFF025
extern volatile uint32_t   OFF025 __attribute__((section("sfrs"), address(0xBF8105A4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF025bits_t;
extern volatile __OFF025bits_t OFF025bits __asm__ ("OFF025") __attribute__((section("sfrs"), address(0xBF8105A4)));
#define OFF026 OFF026
extern volatile uint32_t   OFF026 __attribute__((section("sfrs"), address(0xBF8105A8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF026bits_t;
extern volatile __OFF026bits_t OFF026bits __asm__ ("OFF026") __attribute__((section("sfrs"), address(0xBF8105A8)));
#define OFF027 OFF027
extern volatile uint32_t   OFF027 __attribute__((section("sfrs"), address(0xBF8105AC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF027bits_t;
extern volatile __OFF027bits_t OFF027bits __asm__ ("OFF027") __attribute__((section("sfrs"), address(0xBF8105AC)));
#define OFF028 OFF028
extern volatile uint32_t   OFF028 __attribute__((section("sfrs"), address(0xBF8105B0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF028bits_t;
extern volatile __OFF028bits_t OFF028bits __asm__ ("OFF028") __attribute__((section("sfrs"), address(0xBF8105B0)));
#define OFF029 OFF029
extern volatile uint32_t   OFF029 __attribute__((section("sfrs"), address(0xBF8105B4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF029bits_t;
extern volatile __OFF029bits_t OFF029bits __asm__ ("OFF029") __attribute__((section("sfrs"), address(0xBF8105B4)));
#define OFF030 OFF030
extern volatile uint32_t   OFF030 __attribute__((section("sfrs"), address(0xBF8105B8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF030bits_t;
extern volatile __OFF030bits_t OFF030bits __asm__ ("OFF030") __attribute__((section("sfrs"), address(0xBF8105B8)));
#define OFF031 OFF031
extern volatile uint32_t   OFF031 __attribute__((section("sfrs"), address(0xBF8105BC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF031bits_t;
extern volatile __OFF031bits_t OFF031bits __asm__ ("OFF031") __attribute__((section("sfrs"), address(0xBF8105BC)));
#define OFF032 OFF032
extern volatile uint32_t   OFF032 __attribute__((section("sfrs"), address(0xBF8105C0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF032bits_t;
extern volatile __OFF032bits_t OFF032bits __asm__ ("OFF032") __attribute__((section("sfrs"), address(0xBF8105C0)));
#define OFF033 OFF033
extern volatile uint32_t   OFF033 __attribute__((section("sfrs"), address(0xBF8105C4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF033bits_t;
extern volatile __OFF033bits_t OFF033bits __asm__ ("OFF033") __attribute__((section("sfrs"), address(0xBF8105C4)));
#define OFF034 OFF034
extern volatile uint32_t   OFF034 __attribute__((section("sfrs"), address(0xBF8105C8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF034bits_t;
extern volatile __OFF034bits_t OFF034bits __asm__ ("OFF034") __attribute__((section("sfrs"), address(0xBF8105C8)));
#define OFF035 OFF035
extern volatile uint32_t   OFF035 __attribute__((section("sfrs"), address(0xBF8105CC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF035bits_t;
extern volatile __OFF035bits_t OFF035bits __asm__ ("OFF035") __attribute__((section("sfrs"), address(0xBF8105CC)));
#define OFF036 OFF036
extern volatile uint32_t   OFF036 __attribute__((section("sfrs"), address(0xBF8105D0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF036bits_t;
extern volatile __OFF036bits_t OFF036bits __asm__ ("OFF036") __attribute__((section("sfrs"), address(0xBF8105D0)));
#define OFF037 OFF037
extern volatile uint32_t   OFF037 __attribute__((section("sfrs"), address(0xBF8105D4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF037bits_t;
extern volatile __OFF037bits_t OFF037bits __asm__ ("OFF037") __attribute__((section("sfrs"), address(0xBF8105D4)));
#define OFF038 OFF038
extern volatile uint32_t   OFF038 __attribute__((section("sfrs"), address(0xBF8105D8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF038bits_t;
extern volatile __OFF038bits_t OFF038bits __asm__ ("OFF038") __attribute__((section("sfrs"), address(0xBF8105D8)));
#define OFF039 OFF039
extern volatile uint32_t   OFF039 __attribute__((section("sfrs"), address(0xBF8105DC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF039bits_t;
extern volatile __OFF039bits_t OFF039bits __asm__ ("OFF039") __attribute__((section("sfrs"), address(0xBF8105DC)));
#define OFF040 OFF040
extern volatile uint32_t   OFF040 __attribute__((section("sfrs"), address(0xBF8105E0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF040bits_t;
extern volatile __OFF040bits_t OFF040bits __asm__ ("OFF040") __attribute__((section("sfrs"), address(0xBF8105E0)));
#define OFF041 OFF041
extern volatile uint32_t   OFF041 __attribute__((section("sfrs"), address(0xBF8105E4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF041bits_t;
extern volatile __OFF041bits_t OFF041bits __asm__ ("OFF041") __attribute__((section("sfrs"), address(0xBF8105E4)));
#define OFF042 OFF042
extern volatile uint32_t   OFF042 __attribute__((section("sfrs"), address(0xBF8105E8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF042bits_t;
extern volatile __OFF042bits_t OFF042bits __asm__ ("OFF042") __attribute__((section("sfrs"), address(0xBF8105E8)));
#define OFF043 OFF043
extern volatile uint32_t   OFF043 __attribute__((section("sfrs"), address(0xBF8105EC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF043bits_t;
extern volatile __OFF043bits_t OFF043bits __asm__ ("OFF043") __attribute__((section("sfrs"), address(0xBF8105EC)));
#define OFF044 OFF044
extern volatile uint32_t   OFF044 __attribute__((section("sfrs"), address(0xBF8105F0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF044bits_t;
extern volatile __OFF044bits_t OFF044bits __asm__ ("OFF044") __attribute__((section("sfrs"), address(0xBF8105F0)));
#define OFF045 OFF045
extern volatile uint32_t   OFF045 __attribute__((section("sfrs"), address(0xBF8105F4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF045bits_t;
extern volatile __OFF045bits_t OFF045bits __asm__ ("OFF045") __attribute__((section("sfrs"), address(0xBF8105F4)));
#define OFF046 OFF046
extern volatile uint32_t   OFF046 __attribute__((section("sfrs"), address(0xBF8105F8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF046bits_t;
extern volatile __OFF046bits_t OFF046bits __asm__ ("OFF046") __attribute__((section("sfrs"), address(0xBF8105F8)));
#define OFF047 OFF047
extern volatile uint32_t   OFF047 __attribute__((section("sfrs"), address(0xBF8105FC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF047bits_t;
extern volatile __OFF047bits_t OFF047bits __asm__ ("OFF047") __attribute__((section("sfrs"), address(0xBF8105FC)));
#define OFF048 OFF048
extern volatile uint32_t   OFF048 __attribute__((section("sfrs"), address(0xBF810600)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF048bits_t;
extern volatile __OFF048bits_t OFF048bits __asm__ ("OFF048") __attribute__((section("sfrs"), address(0xBF810600)));
#define OFF049 OFF049
extern volatile uint32_t   OFF049 __attribute__((section("sfrs"), address(0xBF810604)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF049bits_t;
extern volatile __OFF049bits_t OFF049bits __asm__ ("OFF049") __attribute__((section("sfrs"), address(0xBF810604)));
#define OFF050 OFF050
extern volatile uint32_t   OFF050 __attribute__((section("sfrs"), address(0xBF810608)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF050bits_t;
extern volatile __OFF050bits_t OFF050bits __asm__ ("OFF050") __attribute__((section("sfrs"), address(0xBF810608)));
#define OFF051 OFF051
extern volatile uint32_t   OFF051 __attribute__((section("sfrs"), address(0xBF81060C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF051bits_t;
extern volatile __OFF051bits_t OFF051bits __asm__ ("OFF051") __attribute__((section("sfrs"), address(0xBF81060C)));
#define OFF052 OFF052
extern volatile uint32_t   OFF052 __attribute__((section("sfrs"), address(0xBF810610)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF052bits_t;
extern volatile __OFF052bits_t OFF052bits __asm__ ("OFF052") __attribute__((section("sfrs"), address(0xBF810610)));
#define OFF053 OFF053
extern volatile uint32_t   OFF053 __attribute__((section("sfrs"), address(0xBF810614)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF053bits_t;
extern volatile __OFF053bits_t OFF053bits __asm__ ("OFF053") __attribute__((section("sfrs"), address(0xBF810614)));
#define OFF054 OFF054
extern volatile uint32_t   OFF054 __attribute__((section("sfrs"), address(0xBF810618)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF054bits_t;
extern volatile __OFF054bits_t OFF054bits __asm__ ("OFF054") __attribute__((section("sfrs"), address(0xBF810618)));
#define OFF055 OFF055
extern volatile uint32_t   OFF055 __attribute__((section("sfrs"), address(0xBF81061C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF055bits_t;
extern volatile __OFF055bits_t OFF055bits __asm__ ("OFF055") __attribute__((section("sfrs"), address(0xBF81061C)));
#define OFF056 OFF056
extern volatile uint32_t   OFF056 __attribute__((section("sfrs"), address(0xBF810620)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF056bits_t;
extern volatile __OFF056bits_t OFF056bits __asm__ ("OFF056") __attribute__((section("sfrs"), address(0xBF810620)));
#define OFF057 OFF057
extern volatile uint32_t   OFF057 __attribute__((section("sfrs"), address(0xBF810624)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF057bits_t;
extern volatile __OFF057bits_t OFF057bits __asm__ ("OFF057") __attribute__((section("sfrs"), address(0xBF810624)));
#define OFF059 OFF059
extern volatile uint32_t   OFF059 __attribute__((section("sfrs"), address(0xBF81062C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF059bits_t;
extern volatile __OFF059bits_t OFF059bits __asm__ ("OFF059") __attribute__((section("sfrs"), address(0xBF81062C)));
#define OFF060 OFF060
extern volatile uint32_t   OFF060 __attribute__((section("sfrs"), address(0xBF810630)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF060bits_t;
extern volatile __OFF060bits_t OFF060bits __asm__ ("OFF060") __attribute__((section("sfrs"), address(0xBF810630)));
#define OFF061 OFF061
extern volatile uint32_t   OFF061 __attribute__((section("sfrs"), address(0xBF810634)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF061bits_t;
extern volatile __OFF061bits_t OFF061bits __asm__ ("OFF061") __attribute__((section("sfrs"), address(0xBF810634)));
#define OFF062 OFF062
extern volatile uint32_t   OFF062 __attribute__((section("sfrs"), address(0xBF810638)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF062bits_t;
extern volatile __OFF062bits_t OFF062bits __asm__ ("OFF062") __attribute__((section("sfrs"), address(0xBF810638)));
#define OFF063 OFF063
extern volatile uint32_t   OFF063 __attribute__((section("sfrs"), address(0xBF81063C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF063bits_t;
extern volatile __OFF063bits_t OFF063bits __asm__ ("OFF063") __attribute__((section("sfrs"), address(0xBF81063C)));
#define OFF064 OFF064
extern volatile uint32_t   OFF064 __attribute__((section("sfrs"), address(0xBF810640)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF064bits_t;
extern volatile __OFF064bits_t OFF064bits __asm__ ("OFF064") __attribute__((section("sfrs"), address(0xBF810640)));
#define OFF065 OFF065
extern volatile uint32_t   OFF065 __attribute__((section("sfrs"), address(0xBF810644)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF065bits_t;
extern volatile __OFF065bits_t OFF065bits __asm__ ("OFF065") __attribute__((section("sfrs"), address(0xBF810644)));
#define OFF066 OFF066
extern volatile uint32_t   OFF066 __attribute__((section("sfrs"), address(0xBF810648)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF066bits_t;
extern volatile __OFF066bits_t OFF066bits __asm__ ("OFF066") __attribute__((section("sfrs"), address(0xBF810648)));
#define OFF067 OFF067
extern volatile uint32_t   OFF067 __attribute__((section("sfrs"), address(0xBF81064C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF067bits_t;
extern volatile __OFF067bits_t OFF067bits __asm__ ("OFF067") __attribute__((section("sfrs"), address(0xBF81064C)));
#define OFF068 OFF068
extern volatile uint32_t   OFF068 __attribute__((section("sfrs"), address(0xBF810650)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF068bits_t;
extern volatile __OFF068bits_t OFF068bits __asm__ ("OFF068") __attribute__((section("sfrs"), address(0xBF810650)));
#define OFF069 OFF069
extern volatile uint32_t   OFF069 __attribute__((section("sfrs"), address(0xBF810654)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF069bits_t;
extern volatile __OFF069bits_t OFF069bits __asm__ ("OFF069") __attribute__((section("sfrs"), address(0xBF810654)));
#define OFF070 OFF070
extern volatile uint32_t   OFF070 __attribute__((section("sfrs"), address(0xBF810658)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF070bits_t;
extern volatile __OFF070bits_t OFF070bits __asm__ ("OFF070") __attribute__((section("sfrs"), address(0xBF810658)));
#define OFF071 OFF071
extern volatile uint32_t   OFF071 __attribute__((section("sfrs"), address(0xBF81065C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF071bits_t;
extern volatile __OFF071bits_t OFF071bits __asm__ ("OFF071") __attribute__((section("sfrs"), address(0xBF81065C)));
#define OFF072 OFF072
extern volatile uint32_t   OFF072 __attribute__((section("sfrs"), address(0xBF810660)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF072bits_t;
extern volatile __OFF072bits_t OFF072bits __asm__ ("OFF072") __attribute__((section("sfrs"), address(0xBF810660)));
#define OFF073 OFF073
extern volatile uint32_t   OFF073 __attribute__((section("sfrs"), address(0xBF810664)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF073bits_t;
extern volatile __OFF073bits_t OFF073bits __asm__ ("OFF073") __attribute__((section("sfrs"), address(0xBF810664)));
#define OFF074 OFF074
extern volatile uint32_t   OFF074 __attribute__((section("sfrs"), address(0xBF810668)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF074bits_t;
extern volatile __OFF074bits_t OFF074bits __asm__ ("OFF074") __attribute__((section("sfrs"), address(0xBF810668)));
#define OFF075 OFF075
extern volatile uint32_t   OFF075 __attribute__((section("sfrs"), address(0xBF81066C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF075bits_t;
extern volatile __OFF075bits_t OFF075bits __asm__ ("OFF075") __attribute__((section("sfrs"), address(0xBF81066C)));
#define OFF076 OFF076
extern volatile uint32_t   OFF076 __attribute__((section("sfrs"), address(0xBF810670)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF076bits_t;
extern volatile __OFF076bits_t OFF076bits __asm__ ("OFF076") __attribute__((section("sfrs"), address(0xBF810670)));
#define OFF077 OFF077
extern volatile uint32_t   OFF077 __attribute__((section("sfrs"), address(0xBF810674)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF077bits_t;
extern volatile __OFF077bits_t OFF077bits __asm__ ("OFF077") __attribute__((section("sfrs"), address(0xBF810674)));
#define OFF102 OFF102
extern volatile uint32_t   OFF102 __attribute__((section("sfrs"), address(0xBF8106D8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF102bits_t;
extern volatile __OFF102bits_t OFF102bits __asm__ ("OFF102") __attribute__((section("sfrs"), address(0xBF8106D8)));
#define OFF103 OFF103
extern volatile uint32_t   OFF103 __attribute__((section("sfrs"), address(0xBF8106DC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF103bits_t;
extern volatile __OFF103bits_t OFF103bits __asm__ ("OFF103") __attribute__((section("sfrs"), address(0xBF8106DC)));
#define OFF104 OFF104
extern volatile uint32_t   OFF104 __attribute__((section("sfrs"), address(0xBF8106E0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF104bits_t;
extern volatile __OFF104bits_t OFF104bits __asm__ ("OFF104") __attribute__((section("sfrs"), address(0xBF8106E0)));
#define OFF105 OFF105
extern volatile uint32_t   OFF105 __attribute__((section("sfrs"), address(0xBF8106E4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF105bits_t;
extern volatile __OFF105bits_t OFF105bits __asm__ ("OFF105") __attribute__((section("sfrs"), address(0xBF8106E4)));
#define OFF106 OFF106
extern volatile uint32_t   OFF106 __attribute__((section("sfrs"), address(0xBF8106E8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF106bits_t;
extern volatile __OFF106bits_t OFF106bits __asm__ ("OFF106") __attribute__((section("sfrs"), address(0xBF8106E8)));
#define OFF109 OFF109
extern volatile uint32_t   OFF109 __attribute__((section("sfrs"), address(0xBF8106F4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF109bits_t;
extern volatile __OFF109bits_t OFF109bits __asm__ ("OFF109") __attribute__((section("sfrs"), address(0xBF8106F4)));
#define OFF110 OFF110
extern volatile uint32_t   OFF110 __attribute__((section("sfrs"), address(0xBF8106F8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF110bits_t;
extern volatile __OFF110bits_t OFF110bits __asm__ ("OFF110") __attribute__((section("sfrs"), address(0xBF8106F8)));
#define OFF111 OFF111
extern volatile uint32_t   OFF111 __attribute__((section("sfrs"), address(0xBF8106FC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF111bits_t;
extern volatile __OFF111bits_t OFF111bits __asm__ ("OFF111") __attribute__((section("sfrs"), address(0xBF8106FC)));
#define OFF112 OFF112
extern volatile uint32_t   OFF112 __attribute__((section("sfrs"), address(0xBF810700)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF112bits_t;
extern volatile __OFF112bits_t OFF112bits __asm__ ("OFF112") __attribute__((section("sfrs"), address(0xBF810700)));
#define OFF113 OFF113
extern volatile uint32_t   OFF113 __attribute__((section("sfrs"), address(0xBF810704)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF113bits_t;
extern volatile __OFF113bits_t OFF113bits __asm__ ("OFF113") __attribute__((section("sfrs"), address(0xBF810704)));
#define OFF114 OFF114
extern volatile uint32_t   OFF114 __attribute__((section("sfrs"), address(0xBF810708)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF114bits_t;
extern volatile __OFF114bits_t OFF114bits __asm__ ("OFF114") __attribute__((section("sfrs"), address(0xBF810708)));
#define OFF115 OFF115
extern volatile uint32_t   OFF115 __attribute__((section("sfrs"), address(0xBF81070C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF115bits_t;
extern volatile __OFF115bits_t OFF115bits __asm__ ("OFF115") __attribute__((section("sfrs"), address(0xBF81070C)));
#define OFF116 OFF116
extern volatile uint32_t   OFF116 __attribute__((section("sfrs"), address(0xBF810710)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF116bits_t;
extern volatile __OFF116bits_t OFF116bits __asm__ ("OFF116") __attribute__((section("sfrs"), address(0xBF810710)));
#define OFF117 OFF117
extern volatile uint32_t   OFF117 __attribute__((section("sfrs"), address(0xBF810714)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF117bits_t;
extern volatile __OFF117bits_t OFF117bits __asm__ ("OFF117") __attribute__((section("sfrs"), address(0xBF810714)));
#define OFF119 OFF119
extern volatile uint32_t   OFF119 __attribute__((section("sfrs"), address(0xBF81071C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF119bits_t;
extern volatile __OFF119bits_t OFF119bits __asm__ ("OFF119") __attribute__((section("sfrs"), address(0xBF81071C)));
#define OFF120 OFF120
extern volatile uint32_t   OFF120 __attribute__((section("sfrs"), address(0xBF810720)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF120bits_t;
extern volatile __OFF120bits_t OFF120bits __asm__ ("OFF120") __attribute__((section("sfrs"), address(0xBF810720)));
#define OFF121 OFF121
extern volatile uint32_t   OFF121 __attribute__((section("sfrs"), address(0xBF810724)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF121bits_t;
extern volatile __OFF121bits_t OFF121bits __asm__ ("OFF121") __attribute__((section("sfrs"), address(0xBF810724)));
#define OFF122 OFF122
extern volatile uint32_t   OFF122 __attribute__((section("sfrs"), address(0xBF810728)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF122bits_t;
extern volatile __OFF122bits_t OFF122bits __asm__ ("OFF122") __attribute__((section("sfrs"), address(0xBF810728)));
#define OFF123 OFF123
extern volatile uint32_t   OFF123 __attribute__((section("sfrs"), address(0xBF81072C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF123bits_t;
extern volatile __OFF123bits_t OFF123bits __asm__ ("OFF123") __attribute__((section("sfrs"), address(0xBF81072C)));
#define OFF124 OFF124
extern volatile uint32_t   OFF124 __attribute__((section("sfrs"), address(0xBF810730)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF124bits_t;
extern volatile __OFF124bits_t OFF124bits __asm__ ("OFF124") __attribute__((section("sfrs"), address(0xBF810730)));
#define OFF128 OFF128
extern volatile uint32_t   OFF128 __attribute__((section("sfrs"), address(0xBF810740)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF128bits_t;
extern volatile __OFF128bits_t OFF128bits __asm__ ("OFF128") __attribute__((section("sfrs"), address(0xBF810740)));
#define OFF129 OFF129
extern volatile uint32_t   OFF129 __attribute__((section("sfrs"), address(0xBF810744)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF129bits_t;
extern volatile __OFF129bits_t OFF129bits __asm__ ("OFF129") __attribute__((section("sfrs"), address(0xBF810744)));
#define OFF130 OFF130
extern volatile uint32_t   OFF130 __attribute__((section("sfrs"), address(0xBF810748)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF130bits_t;
extern volatile __OFF130bits_t OFF130bits __asm__ ("OFF130") __attribute__((section("sfrs"), address(0xBF810748)));
#define OFF131 OFF131
extern volatile uint32_t   OFF131 __attribute__((section("sfrs"), address(0xBF81074C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF131bits_t;
extern volatile __OFF131bits_t OFF131bits __asm__ ("OFF131") __attribute__((section("sfrs"), address(0xBF81074C)));
#define OFF132 OFF132
extern volatile uint32_t   OFF132 __attribute__((section("sfrs"), address(0xBF810750)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF132bits_t;
extern volatile __OFF132bits_t OFF132bits __asm__ ("OFF132") __attribute__((section("sfrs"), address(0xBF810750)));
#define OFF133 OFF133
extern volatile uint32_t   OFF133 __attribute__((section("sfrs"), address(0xBF810754)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF133bits_t;
extern volatile __OFF133bits_t OFF133bits __asm__ ("OFF133") __attribute__((section("sfrs"), address(0xBF810754)));
#define OFF134 OFF134
extern volatile uint32_t   OFF134 __attribute__((section("sfrs"), address(0xBF810758)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF134bits_t;
extern volatile __OFF134bits_t OFF134bits __asm__ ("OFF134") __attribute__((section("sfrs"), address(0xBF810758)));
#define OFF135 OFF135
extern volatile uint32_t   OFF135 __attribute__((section("sfrs"), address(0xBF81075C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF135bits_t;
extern volatile __OFF135bits_t OFF135bits __asm__ ("OFF135") __attribute__((section("sfrs"), address(0xBF81075C)));
#define OFF136 OFF136
extern volatile uint32_t   OFF136 __attribute__((section("sfrs"), address(0xBF810760)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF136bits_t;
extern volatile __OFF136bits_t OFF136bits __asm__ ("OFF136") __attribute__((section("sfrs"), address(0xBF810760)));
#define OFF137 OFF137
extern volatile uint32_t   OFF137 __attribute__((section("sfrs"), address(0xBF810764)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF137bits_t;
extern volatile __OFF137bits_t OFF137bits __asm__ ("OFF137") __attribute__((section("sfrs"), address(0xBF810764)));
#define OFF138 OFF138
extern volatile uint32_t   OFF138 __attribute__((section("sfrs"), address(0xBF810768)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF138bits_t;
extern volatile __OFF138bits_t OFF138bits __asm__ ("OFF138") __attribute__((section("sfrs"), address(0xBF810768)));
#define OFF139 OFF139
extern volatile uint32_t   OFF139 __attribute__((section("sfrs"), address(0xBF81076C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF139bits_t;
extern volatile __OFF139bits_t OFF139bits __asm__ ("OFF139") __attribute__((section("sfrs"), address(0xBF81076C)));
#define OFF140 OFF140
extern volatile uint32_t   OFF140 __attribute__((section("sfrs"), address(0xBF810770)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF140bits_t;
extern volatile __OFF140bits_t OFF140bits __asm__ ("OFF140") __attribute__((section("sfrs"), address(0xBF810770)));
#define OFF141 OFF141
extern volatile uint32_t   OFF141 __attribute__((section("sfrs"), address(0xBF810774)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF141bits_t;
extern volatile __OFF141bits_t OFF141bits __asm__ ("OFF141") __attribute__((section("sfrs"), address(0xBF810774)));
#define OFF142 OFF142
extern volatile uint32_t   OFF142 __attribute__((section("sfrs"), address(0xBF810778)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF142bits_t;
extern volatile __OFF142bits_t OFF142bits __asm__ ("OFF142") __attribute__((section("sfrs"), address(0xBF810778)));
#define OFF143 OFF143
extern volatile uint32_t   OFF143 __attribute__((section("sfrs"), address(0xBF81077C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF143bits_t;
extern volatile __OFF143bits_t OFF143bits __asm__ ("OFF143") __attribute__((section("sfrs"), address(0xBF81077C)));
#define OFF144 OFF144
extern volatile uint32_t   OFF144 __attribute__((section("sfrs"), address(0xBF810780)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF144bits_t;
extern volatile __OFF144bits_t OFF144bits __asm__ ("OFF144") __attribute__((section("sfrs"), address(0xBF810780)));
#define OFF145 OFF145
extern volatile uint32_t   OFF145 __attribute__((section("sfrs"), address(0xBF810784)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF145bits_t;
extern volatile __OFF145bits_t OFF145bits __asm__ ("OFF145") __attribute__((section("sfrs"), address(0xBF810784)));
#define OFF146 OFF146
extern volatile uint32_t   OFF146 __attribute__((section("sfrs"), address(0xBF810788)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF146bits_t;
extern volatile __OFF146bits_t OFF146bits __asm__ ("OFF146") __attribute__((section("sfrs"), address(0xBF810788)));
#define OFF147 OFF147
extern volatile uint32_t   OFF147 __attribute__((section("sfrs"), address(0xBF81078C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF147bits_t;
extern volatile __OFF147bits_t OFF147bits __asm__ ("OFF147") __attribute__((section("sfrs"), address(0xBF81078C)));
#define OFF151 OFF151
extern volatile uint32_t   OFF151 __attribute__((section("sfrs"), address(0xBF81079C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF151bits_t;
extern volatile __OFF151bits_t OFF151bits __asm__ ("OFF151") __attribute__((section("sfrs"), address(0xBF81079C)));
#define OFF152 OFF152
extern volatile uint32_t   OFF152 __attribute__((section("sfrs"), address(0xBF8107A0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF152bits_t;
extern volatile __OFF152bits_t OFF152bits __asm__ ("OFF152") __attribute__((section("sfrs"), address(0xBF8107A0)));
#define OFF153 OFF153
extern volatile uint32_t   OFF153 __attribute__((section("sfrs"), address(0xBF8107A4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF153bits_t;
extern volatile __OFF153bits_t OFF153bits __asm__ ("OFF153") __attribute__((section("sfrs"), address(0xBF8107A4)));
#define OFF154 OFF154
extern volatile uint32_t   OFF154 __attribute__((section("sfrs"), address(0xBF8107A8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF154bits_t;
extern volatile __OFF154bits_t OFF154bits __asm__ ("OFF154") __attribute__((section("sfrs"), address(0xBF8107A8)));
#define OFF155 OFF155
extern volatile uint32_t   OFF155 __attribute__((section("sfrs"), address(0xBF8107AC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF155bits_t;
extern volatile __OFF155bits_t OFF155bits __asm__ ("OFF155") __attribute__((section("sfrs"), address(0xBF8107AC)));
#define OFF156 OFF156
extern volatile uint32_t   OFF156 __attribute__((section("sfrs"), address(0xBF8107B0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF156bits_t;
extern volatile __OFF156bits_t OFF156bits __asm__ ("OFF156") __attribute__((section("sfrs"), address(0xBF8107B0)));
#define OFF157 OFF157
extern volatile uint32_t   OFF157 __attribute__((section("sfrs"), address(0xBF8107B4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF157bits_t;
extern volatile __OFF157bits_t OFF157bits __asm__ ("OFF157") __attribute__((section("sfrs"), address(0xBF8107B4)));
#define OFF158 OFF158
extern volatile uint32_t   OFF158 __attribute__((section("sfrs"), address(0xBF8107B8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF158bits_t;
extern volatile __OFF158bits_t OFF158bits __asm__ ("OFF158") __attribute__((section("sfrs"), address(0xBF8107B8)));
#define OFF159 OFF159
extern volatile uint32_t   OFF159 __attribute__((section("sfrs"), address(0xBF8107BC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF159bits_t;
extern volatile __OFF159bits_t OFF159bits __asm__ ("OFF159") __attribute__((section("sfrs"), address(0xBF8107BC)));
#define OFF160 OFF160
extern volatile uint32_t   OFF160 __attribute__((section("sfrs"), address(0xBF8107C0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF160bits_t;
extern volatile __OFF160bits_t OFF160bits __asm__ ("OFF160") __attribute__((section("sfrs"), address(0xBF8107C0)));
#define OFF161 OFF161
extern volatile uint32_t   OFF161 __attribute__((section("sfrs"), address(0xBF8107C4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF161bits_t;
extern volatile __OFF161bits_t OFF161bits __asm__ ("OFF161") __attribute__((section("sfrs"), address(0xBF8107C4)));
#define OFF162 OFF162
extern volatile uint32_t   OFF162 __attribute__((section("sfrs"), address(0xBF8107C8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF162bits_t;
extern volatile __OFF162bits_t OFF162bits __asm__ ("OFF162") __attribute__((section("sfrs"), address(0xBF8107C8)));
#define OFF163 OFF163
extern volatile uint32_t   OFF163 __attribute__((section("sfrs"), address(0xBF8107CC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF163bits_t;
extern volatile __OFF163bits_t OFF163bits __asm__ ("OFF163") __attribute__((section("sfrs"), address(0xBF8107CC)));
#define OFF164 OFF164
extern volatile uint32_t   OFF164 __attribute__((section("sfrs"), address(0xBF8107D0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF164bits_t;
extern volatile __OFF164bits_t OFF164bits __asm__ ("OFF164") __attribute__((section("sfrs"), address(0xBF8107D0)));
#define OFF165 OFF165
extern volatile uint32_t   OFF165 __attribute__((section("sfrs"), address(0xBF8107D4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF165bits_t;
extern volatile __OFF165bits_t OFF165bits __asm__ ("OFF165") __attribute__((section("sfrs"), address(0xBF8107D4)));
#define OFF166 OFF166
extern volatile uint32_t   OFF166 __attribute__((section("sfrs"), address(0xBF8107D8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF166bits_t;
extern volatile __OFF166bits_t OFF166bits __asm__ ("OFF166") __attribute__((section("sfrs"), address(0xBF8107D8)));
#define OFF167 OFF167
extern volatile uint32_t   OFF167 __attribute__((section("sfrs"), address(0xBF8107DC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF167bits_t;
extern volatile __OFF167bits_t OFF167bits __asm__ ("OFF167") __attribute__((section("sfrs"), address(0xBF8107DC)));
#define OFF168 OFF168
extern volatile uint32_t   OFF168 __attribute__((section("sfrs"), address(0xBF8107E0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF168bits_t;
extern volatile __OFF168bits_t OFF168bits __asm__ ("OFF168") __attribute__((section("sfrs"), address(0xBF8107E0)));
#define OFF169 OFF169
extern volatile uint32_t   OFF169 __attribute__((section("sfrs"), address(0xBF8107E4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF169bits_t;
extern volatile __OFF169bits_t OFF169bits __asm__ ("OFF169") __attribute__((section("sfrs"), address(0xBF8107E4)));
#define OFF170 OFF170
extern volatile uint32_t   OFF170 __attribute__((section("sfrs"), address(0xBF8107E8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF170bits_t;
extern volatile __OFF170bits_t OFF170bits __asm__ ("OFF170") __attribute__((section("sfrs"), address(0xBF8107E8)));
#define OFF171 OFF171
extern volatile uint32_t   OFF171 __attribute__((section("sfrs"), address(0xBF8107EC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF171bits_t;
extern volatile __OFF171bits_t OFF171bits __asm__ ("OFF171") __attribute__((section("sfrs"), address(0xBF8107EC)));
#define OFF172 OFF172
extern volatile uint32_t   OFF172 __attribute__((section("sfrs"), address(0xBF8107F0)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF172bits_t;
extern volatile __OFF172bits_t OFF172bits __asm__ ("OFF172") __attribute__((section("sfrs"), address(0xBF8107F0)));
#define OFF173 OFF173
extern volatile uint32_t   OFF173 __attribute__((section("sfrs"), address(0xBF8107F4)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF173bits_t;
extern volatile __OFF173bits_t OFF173bits __asm__ ("OFF173") __attribute__((section("sfrs"), address(0xBF8107F4)));
#define OFF174 OFF174
extern volatile uint32_t   OFF174 __attribute__((section("sfrs"), address(0xBF8107F8)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF174bits_t;
extern volatile __OFF174bits_t OFF174bits __asm__ ("OFF174") __attribute__((section("sfrs"), address(0xBF8107F8)));
#define OFF175 OFF175
extern volatile uint32_t   OFF175 __attribute__((section("sfrs"), address(0xBF8107FC)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF175bits_t;
extern volatile __OFF175bits_t OFF175bits __asm__ ("OFF175") __attribute__((section("sfrs"), address(0xBF8107FC)));
#define OFF179 OFF179
extern volatile uint32_t   OFF179 __attribute__((section("sfrs"), address(0xBF81080C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF179bits_t;
extern volatile __OFF179bits_t OFF179bits __asm__ ("OFF179") __attribute__((section("sfrs"), address(0xBF81080C)));
#define OFF180 OFF180
extern volatile uint32_t   OFF180 __attribute__((section("sfrs"), address(0xBF810810)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF180bits_t;
extern volatile __OFF180bits_t OFF180bits __asm__ ("OFF180") __attribute__((section("sfrs"), address(0xBF810810)));
#define OFF181 OFF181
extern volatile uint32_t   OFF181 __attribute__((section("sfrs"), address(0xBF810814)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF181bits_t;
extern volatile __OFF181bits_t OFF181bits __asm__ ("OFF181") __attribute__((section("sfrs"), address(0xBF810814)));
#define OFF182 OFF182
extern volatile uint32_t   OFF182 __attribute__((section("sfrs"), address(0xBF810818)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF182bits_t;
extern volatile __OFF182bits_t OFF182bits __asm__ ("OFF182") __attribute__((section("sfrs"), address(0xBF810818)));
#define OFF183 OFF183
extern volatile uint32_t   OFF183 __attribute__((section("sfrs"), address(0xBF81081C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF183bits_t;
extern volatile __OFF183bits_t OFF183bits __asm__ ("OFF183") __attribute__((section("sfrs"), address(0xBF81081C)));
#define OFF184 OFF184
extern volatile uint32_t   OFF184 __attribute__((section("sfrs"), address(0xBF810820)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF184bits_t;
extern volatile __OFF184bits_t OFF184bits __asm__ ("OFF184") __attribute__((section("sfrs"), address(0xBF810820)));
#define OFF188 OFF188
extern volatile uint32_t   OFF188 __attribute__((section("sfrs"), address(0xBF810830)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF188bits_t;
extern volatile __OFF188bits_t OFF188bits __asm__ ("OFF188") __attribute__((section("sfrs"), address(0xBF810830)));
#define OFF189 OFF189
extern volatile uint32_t   OFF189 __attribute__((section("sfrs"), address(0xBF810834)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF189bits_t;
extern volatile __OFF189bits_t OFF189bits __asm__ ("OFF189") __attribute__((section("sfrs"), address(0xBF810834)));
#define OFF190 OFF190
extern volatile uint32_t   OFF190 __attribute__((section("sfrs"), address(0xBF810838)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF190bits_t;
extern volatile __OFF190bits_t OFF190bits __asm__ ("OFF190") __attribute__((section("sfrs"), address(0xBF810838)));
#define OFF192 OFF192
extern volatile uint32_t   OFF192 __attribute__((section("sfrs"), address(0xBF810840)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF192bits_t;
extern volatile __OFF192bits_t OFF192bits __asm__ ("OFF192") __attribute__((section("sfrs"), address(0xBF810840)));
#define OFF193 OFF193
extern volatile uint32_t   OFF193 __attribute__((section("sfrs"), address(0xBF810844)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF193bits_t;
extern volatile __OFF193bits_t OFF193bits __asm__ ("OFF193") __attribute__((section("sfrs"), address(0xBF810844)));
#define OFF194 OFF194
extern volatile uint32_t   OFF194 __attribute__((section("sfrs"), address(0xBF810848)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF194bits_t;
extern volatile __OFF194bits_t OFF194bits __asm__ ("OFF194") __attribute__((section("sfrs"), address(0xBF810848)));
#define OFF196 OFF196
extern volatile uint32_t   OFF196 __attribute__((section("sfrs"), address(0xBF810850)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF196bits_t;
extern volatile __OFF196bits_t OFF196bits __asm__ ("OFF196") __attribute__((section("sfrs"), address(0xBF810850)));
#define OFF198 OFF198
extern volatile uint32_t   OFF198 __attribute__((section("sfrs"), address(0xBF810858)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF198bits_t;
extern volatile __OFF198bits_t OFF198bits __asm__ ("OFF198") __attribute__((section("sfrs"), address(0xBF810858)));
#define OFF199 OFF199
extern volatile uint32_t   OFF199 __attribute__((section("sfrs"), address(0xBF81085C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF199bits_t;
extern volatile __OFF199bits_t OFF199bits __asm__ ("OFF199") __attribute__((section("sfrs"), address(0xBF81085C)));
#define OFF200 OFF200
extern volatile uint32_t   OFF200 __attribute__((section("sfrs"), address(0xBF810860)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF200bits_t;
extern volatile __OFF200bits_t OFF200bits __asm__ ("OFF200") __attribute__((section("sfrs"), address(0xBF810860)));
#define OFF201 OFF201
extern volatile uint32_t   OFF201 __attribute__((section("sfrs"), address(0xBF810864)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF201bits_t;
extern volatile __OFF201bits_t OFF201bits __asm__ ("OFF201") __attribute__((section("sfrs"), address(0xBF810864)));
#define OFF202 OFF202
extern volatile uint32_t   OFF202 __attribute__((section("sfrs"), address(0xBF810868)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF202bits_t;
extern volatile __OFF202bits_t OFF202bits __asm__ ("OFF202") __attribute__((section("sfrs"), address(0xBF810868)));
#define OFF205 OFF205
extern volatile uint32_t   OFF205 __attribute__((section("sfrs"), address(0xBF810874)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF205bits_t;
extern volatile __OFF205bits_t OFF205bits __asm__ ("OFF205") __attribute__((section("sfrs"), address(0xBF810874)));
#define OFF206 OFF206
extern volatile uint32_t   OFF206 __attribute__((section("sfrs"), address(0xBF810878)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF206bits_t;
extern volatile __OFF206bits_t OFF206bits __asm__ ("OFF206") __attribute__((section("sfrs"), address(0xBF810878)));
#define OFF207 OFF207
extern volatile uint32_t   OFF207 __attribute__((section("sfrs"), address(0xBF81087C)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF207bits_t;
extern volatile __OFF207bits_t OFF207bits __asm__ ("OFF207") __attribute__((section("sfrs"), address(0xBF81087C)));
#define OFF208 OFF208
extern volatile uint32_t   OFF208 __attribute__((section("sfrs"), address(0xBF810880)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF208bits_t;
extern volatile __OFF208bits_t OFF208bits __asm__ ("OFF208") __attribute__((section("sfrs"), address(0xBF810880)));
#define OFF209 OFF209
extern volatile uint32_t   OFF209 __attribute__((section("sfrs"), address(0xBF810884)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF209bits_t;
extern volatile __OFF209bits_t OFF209bits __asm__ ("OFF209") __attribute__((section("sfrs"), address(0xBF810884)));
#define OFF210 OFF210
extern volatile uint32_t   OFF210 __attribute__((section("sfrs"), address(0xBF810888)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF210bits_t;
extern volatile __OFF210bits_t OFF210bits __asm__ ("OFF210") __attribute__((section("sfrs"), address(0xBF810888)));
#define OFF213 OFF213
extern volatile uint32_t   OFF213 __attribute__((section("sfrs"), address(0xBF810894)));
typedef struct {
  uint32_t :1;
  uint32_t VOFF:17;
} __OFF213bits_t;
extern volatile __OFF213bits_t OFF213bits __asm__ ("OFF213") __attribute__((section("sfrs"), address(0xBF810894)));
#define DMACON DMACON
extern volatile uint32_t   DMACON __attribute__((section("sfrs"), address(0xBF811000)));
typedef struct {
  uint32_t :11;
  uint32_t DMABUSY:1;
  uint32_t SUSPEND:1;
  uint32_t :2;
  uint32_t ON:1;
} __DMACONbits_t;
extern volatile __DMACONbits_t DMACONbits __asm__ ("DMACON") __attribute__((section("sfrs"), address(0xBF811000)));
extern volatile uint32_t        DMACONCLR __attribute__((section("sfrs"),address(0xBF811004)));
extern volatile uint32_t        DMACONSET __attribute__((section("sfrs"),address(0xBF811008)));
extern volatile uint32_t        DMACONINV __attribute__((section("sfrs"),address(0xBF81100C)));
#define DMASTAT DMASTAT
extern volatile uint32_t   DMASTAT __attribute__((section("sfrs"), address(0xBF811010)));
typedef struct {
  uint32_t DMACH:3;
  uint32_t :28;
  uint32_t RDWR:1;
} __DMASTATbits_t;
extern volatile __DMASTATbits_t DMASTATbits __asm__ ("DMASTAT") __attribute__((section("sfrs"), address(0xBF811010)));
extern volatile uint32_t        DMASTATCLR __attribute__((section("sfrs"),address(0xBF811014)));
extern volatile uint32_t        DMASTATSET __attribute__((section("sfrs"),address(0xBF811018)));
extern volatile uint32_t        DMASTATINV __attribute__((section("sfrs"),address(0xBF81101C)));
#define DMAADDR DMAADDR
extern volatile uint32_t   DMAADDR __attribute__((section("sfrs"), address(0xBF811020)));
typedef struct {
  uint32_t DMAADDR:32;
} __DMAADDRbits_t;
extern volatile __DMAADDRbits_t DMAADDRbits __asm__ ("DMAADDR") __attribute__((section("sfrs"), address(0xBF811020)));
extern volatile uint32_t        DMAADDRCLR __attribute__((section("sfrs"),address(0xBF811024)));
extern volatile uint32_t        DMAADDRSET __attribute__((section("sfrs"),address(0xBF811028)));
extern volatile uint32_t        DMAADDRINV __attribute__((section("sfrs"),address(0xBF81102C)));
#define DCRCCON DCRCCON
extern volatile uint32_t   DCRCCON __attribute__((section("sfrs"), address(0xBF811030)));
typedef struct {
  uint32_t CRCCH:3;
  uint32_t :2;
  uint32_t CRCTYP:1;
  uint32_t CRCAPP:1;
  uint32_t CRCEN:1;
  uint32_t PLEN:5;
  uint32_t :11;
  uint32_t BITO:1;
  uint32_t :2;
  uint32_t WBO:1;
  uint32_t BYTO:2;
} __DCRCCONbits_t;
extern volatile __DCRCCONbits_t DCRCCONbits __asm__ ("DCRCCON") __attribute__((section("sfrs"), address(0xBF811030)));
extern volatile uint32_t        DCRCCONCLR __attribute__((section("sfrs"),address(0xBF811034)));
extern volatile uint32_t        DCRCCONSET __attribute__((section("sfrs"),address(0xBF811038)));
extern volatile uint32_t        DCRCCONINV __attribute__((section("sfrs"),address(0xBF81103C)));
#define DCRCDATA DCRCDATA
extern volatile uint32_t   DCRCDATA __attribute__((section("sfrs"), address(0xBF811040)));
typedef struct {
  uint32_t DCRCDATA:32;
} __DCRCDATAbits_t;
extern volatile __DCRCDATAbits_t DCRCDATAbits __asm__ ("DCRCDATA") __attribute__((section("sfrs"), address(0xBF811040)));
extern volatile uint32_t        DCRCDATACLR __attribute__((section("sfrs"),address(0xBF811044)));
extern volatile uint32_t        DCRCDATASET __attribute__((section("sfrs"),address(0xBF811048)));
extern volatile uint32_t        DCRCDATAINV __attribute__((section("sfrs"),address(0xBF81104C)));
#define DCRCXOR DCRCXOR
extern volatile uint32_t   DCRCXOR __attribute__((section("sfrs"), address(0xBF811050)));
typedef struct {
  uint32_t DCRCXOR:32;
} __DCRCXORbits_t;
extern volatile __DCRCXORbits_t DCRCXORbits __asm__ ("DCRCXOR") __attribute__((section("sfrs"), address(0xBF811050)));
extern volatile uint32_t        DCRCXORCLR __attribute__((section("sfrs"),address(0xBF811054)));
extern volatile uint32_t        DCRCXORSET __attribute__((section("sfrs"),address(0xBF811058)));
extern volatile uint32_t        DCRCXORINV __attribute__((section("sfrs"),address(0xBF81105C)));
#define DCH0CON DCH0CON
extern volatile uint32_t   DCH0CON __attribute__((section("sfrs"), address(0xBF811060)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH0CONbits_t;
extern volatile __DCH0CONbits_t DCH0CONbits __asm__ ("DCH0CON") __attribute__((section("sfrs"), address(0xBF811060)));
extern volatile uint32_t        DCH0CONCLR __attribute__((section("sfrs"),address(0xBF811064)));
extern volatile uint32_t        DCH0CONSET __attribute__((section("sfrs"),address(0xBF811068)));
extern volatile uint32_t        DCH0CONINV __attribute__((section("sfrs"),address(0xBF81106C)));
#define DCH0ECON DCH0ECON
extern volatile uint32_t   DCH0ECON __attribute__((section("sfrs"), address(0xBF811070)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH0ECONbits_t;
extern volatile __DCH0ECONbits_t DCH0ECONbits __asm__ ("DCH0ECON") __attribute__((section("sfrs"), address(0xBF811070)));
extern volatile uint32_t        DCH0ECONCLR __attribute__((section("sfrs"),address(0xBF811074)));
extern volatile uint32_t        DCH0ECONSET __attribute__((section("sfrs"),address(0xBF811078)));
extern volatile uint32_t        DCH0ECONINV __attribute__((section("sfrs"),address(0xBF81107C)));
#define DCH0INT DCH0INT
extern volatile uint32_t   DCH0INT __attribute__((section("sfrs"), address(0xBF811080)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH0INTbits_t;
extern volatile __DCH0INTbits_t DCH0INTbits __asm__ ("DCH0INT") __attribute__((section("sfrs"), address(0xBF811080)));
extern volatile uint32_t        DCH0INTCLR __attribute__((section("sfrs"),address(0xBF811084)));
extern volatile uint32_t        DCH0INTSET __attribute__((section("sfrs"),address(0xBF811088)));
extern volatile uint32_t        DCH0INTINV __attribute__((section("sfrs"),address(0xBF81108C)));
#define DCH0SSA DCH0SSA
extern volatile uint32_t   DCH0SSA __attribute__((section("sfrs"), address(0xBF811090)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH0SSAbits_t;
extern volatile __DCH0SSAbits_t DCH0SSAbits __asm__ ("DCH0SSA") __attribute__((section("sfrs"), address(0xBF811090)));
extern volatile uint32_t        DCH0SSACLR __attribute__((section("sfrs"),address(0xBF811094)));
extern volatile uint32_t        DCH0SSASET __attribute__((section("sfrs"),address(0xBF811098)));
extern volatile uint32_t        DCH0SSAINV __attribute__((section("sfrs"),address(0xBF81109C)));
#define DCH0DSA DCH0DSA
extern volatile uint32_t   DCH0DSA __attribute__((section("sfrs"), address(0xBF8110A0)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH0DSAbits_t;
extern volatile __DCH0DSAbits_t DCH0DSAbits __asm__ ("DCH0DSA") __attribute__((section("sfrs"), address(0xBF8110A0)));
extern volatile uint32_t        DCH0DSACLR __attribute__((section("sfrs"),address(0xBF8110A4)));
extern volatile uint32_t        DCH0DSASET __attribute__((section("sfrs"),address(0xBF8110A8)));
extern volatile uint32_t        DCH0DSAINV __attribute__((section("sfrs"),address(0xBF8110AC)));
#define DCH0SSIZ DCH0SSIZ
extern volatile uint32_t   DCH0SSIZ __attribute__((section("sfrs"), address(0xBF8110B0)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH0SSIZbits_t;
extern volatile __DCH0SSIZbits_t DCH0SSIZbits __asm__ ("DCH0SSIZ") __attribute__((section("sfrs"), address(0xBF8110B0)));
extern volatile uint32_t        DCH0SSIZCLR __attribute__((section("sfrs"),address(0xBF8110B4)));
extern volatile uint32_t        DCH0SSIZSET __attribute__((section("sfrs"),address(0xBF8110B8)));
extern volatile uint32_t        DCH0SSIZINV __attribute__((section("sfrs"),address(0xBF8110BC)));
#define DCH0DSIZ DCH0DSIZ
extern volatile uint32_t   DCH0DSIZ __attribute__((section("sfrs"), address(0xBF8110C0)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH0DSIZbits_t;
extern volatile __DCH0DSIZbits_t DCH0DSIZbits __asm__ ("DCH0DSIZ") __attribute__((section("sfrs"), address(0xBF8110C0)));
extern volatile uint32_t        DCH0DSIZCLR __attribute__((section("sfrs"),address(0xBF8110C4)));
extern volatile uint32_t        DCH0DSIZSET __attribute__((section("sfrs"),address(0xBF8110C8)));
extern volatile uint32_t        DCH0DSIZINV __attribute__((section("sfrs"),address(0xBF8110CC)));
#define DCH0SPTR DCH0SPTR
extern volatile uint32_t   DCH0SPTR __attribute__((section("sfrs"), address(0xBF8110D0)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH0SPTRbits_t;
extern volatile __DCH0SPTRbits_t DCH0SPTRbits __asm__ ("DCH0SPTR") __attribute__((section("sfrs"), address(0xBF8110D0)));
extern volatile uint32_t        DCH0SPTRCLR __attribute__((section("sfrs"),address(0xBF8110D4)));
extern volatile uint32_t        DCH0SPTRSET __attribute__((section("sfrs"),address(0xBF8110D8)));
extern volatile uint32_t        DCH0SPTRINV __attribute__((section("sfrs"),address(0xBF8110DC)));
#define DCH0DPTR DCH0DPTR
extern volatile uint32_t   DCH0DPTR __attribute__((section("sfrs"), address(0xBF8110E0)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH0DPTRbits_t;
extern volatile __DCH0DPTRbits_t DCH0DPTRbits __asm__ ("DCH0DPTR") __attribute__((section("sfrs"), address(0xBF8110E0)));
extern volatile uint32_t        DCH0DPTRCLR __attribute__((section("sfrs"),address(0xBF8110E4)));
extern volatile uint32_t        DCH0DPTRSET __attribute__((section("sfrs"),address(0xBF8110E8)));
extern volatile uint32_t        DCH0DPTRINV __attribute__((section("sfrs"),address(0xBF8110EC)));
#define DCH0CSIZ DCH0CSIZ
extern volatile uint32_t   DCH0CSIZ __attribute__((section("sfrs"), address(0xBF8110F0)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH0CSIZbits_t;
extern volatile __DCH0CSIZbits_t DCH0CSIZbits __asm__ ("DCH0CSIZ") __attribute__((section("sfrs"), address(0xBF8110F0)));
extern volatile uint32_t        DCH0CSIZCLR __attribute__((section("sfrs"),address(0xBF8110F4)));
extern volatile uint32_t        DCH0CSIZSET __attribute__((section("sfrs"),address(0xBF8110F8)));
extern volatile uint32_t        DCH0CSIZINV __attribute__((section("sfrs"),address(0xBF8110FC)));
#define DCH0CPTR DCH0CPTR
extern volatile uint32_t   DCH0CPTR __attribute__((section("sfrs"), address(0xBF811100)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH0CPTRbits_t;
extern volatile __DCH0CPTRbits_t DCH0CPTRbits __asm__ ("DCH0CPTR") __attribute__((section("sfrs"), address(0xBF811100)));
#define DCS0CPTR DCS0CPTR
extern volatile uint32_t   DCS0CPTR __attribute__((section("sfrs"), address(0xBF811100)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS0CPTRbits_t;
extern volatile __DCS0CPTRbits_t DCS0CPTRbits __asm__ ("DCS0CPTR") __attribute__((section("sfrs"), address(0xBF811100)));
extern volatile uint32_t        DCH0CPTRCLR __attribute__((section("sfrs"),address(0xBF811104)));
extern volatile uint32_t        DCS0CPTRCLR __attribute__((section("sfrs"),address(0xBF811104)));
extern volatile uint32_t        DCH0CPTRSET __attribute__((section("sfrs"),address(0xBF811108)));
extern volatile uint32_t        DCS0CPTRSET __attribute__((section("sfrs"),address(0xBF811108)));
extern volatile uint32_t        DCH0CPTRINV __attribute__((section("sfrs"),address(0xBF81110C)));
extern volatile uint32_t        DCS0CPTRINV __attribute__((section("sfrs"),address(0xBF81110C)));
#define DCH0DAT DCH0DAT
extern volatile uint32_t   DCH0DAT __attribute__((section("sfrs"), address(0xBF811110)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH0DATbits_t;
extern volatile __DCH0DATbits_t DCH0DATbits __asm__ ("DCH0DAT") __attribute__((section("sfrs"), address(0xBF811110)));
extern volatile uint32_t        DCH0DATCLR __attribute__((section("sfrs"),address(0xBF811114)));
extern volatile uint32_t        DCH0DATSET __attribute__((section("sfrs"),address(0xBF811118)));
extern volatile uint32_t        DCH0DATINV __attribute__((section("sfrs"),address(0xBF81111C)));
#define DCH1CON DCH1CON
extern volatile uint32_t   DCH1CON __attribute__((section("sfrs"), address(0xBF811120)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH1CONbits_t;
extern volatile __DCH1CONbits_t DCH1CONbits __asm__ ("DCH1CON") __attribute__((section("sfrs"), address(0xBF811120)));
extern volatile uint32_t        DCH1CONCLR __attribute__((section("sfrs"),address(0xBF811124)));
extern volatile uint32_t        DCH1CONSET __attribute__((section("sfrs"),address(0xBF811128)));
extern volatile uint32_t        DCH1CONINV __attribute__((section("sfrs"),address(0xBF81112C)));
#define DCH1ECON DCH1ECON
extern volatile uint32_t   DCH1ECON __attribute__((section("sfrs"), address(0xBF811130)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH1ECONbits_t;
extern volatile __DCH1ECONbits_t DCH1ECONbits __asm__ ("DCH1ECON") __attribute__((section("sfrs"), address(0xBF811130)));
extern volatile uint32_t        DCH1ECONCLR __attribute__((section("sfrs"),address(0xBF811134)));
extern volatile uint32_t        DCH1ECONSET __attribute__((section("sfrs"),address(0xBF811138)));
extern volatile uint32_t        DCH1ECONINV __attribute__((section("sfrs"),address(0xBF81113C)));
#define DCH1INT DCH1INT
extern volatile uint32_t   DCH1INT __attribute__((section("sfrs"), address(0xBF811140)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH1INTbits_t;
extern volatile __DCH1INTbits_t DCH1INTbits __asm__ ("DCH1INT") __attribute__((section("sfrs"), address(0xBF811140)));
extern volatile uint32_t        DCH1INTCLR __attribute__((section("sfrs"),address(0xBF811144)));
extern volatile uint32_t        DCH1INTSET __attribute__((section("sfrs"),address(0xBF811148)));
extern volatile uint32_t        DCH1INTINV __attribute__((section("sfrs"),address(0xBF81114C)));
#define DCH1SSA DCH1SSA
extern volatile uint32_t   DCH1SSA __attribute__((section("sfrs"), address(0xBF811150)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH1SSAbits_t;
extern volatile __DCH1SSAbits_t DCH1SSAbits __asm__ ("DCH1SSA") __attribute__((section("sfrs"), address(0xBF811150)));
extern volatile uint32_t        DCH1SSACLR __attribute__((section("sfrs"),address(0xBF811154)));
extern volatile uint32_t        DCH1SSASET __attribute__((section("sfrs"),address(0xBF811158)));
extern volatile uint32_t        DCH1SSAINV __attribute__((section("sfrs"),address(0xBF81115C)));
#define DCH1DSA DCH1DSA
extern volatile uint32_t   DCH1DSA __attribute__((section("sfrs"), address(0xBF811160)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH1DSAbits_t;
extern volatile __DCH1DSAbits_t DCH1DSAbits __asm__ ("DCH1DSA") __attribute__((section("sfrs"), address(0xBF811160)));
extern volatile uint32_t        DCH1DSACLR __attribute__((section("sfrs"),address(0xBF811164)));
extern volatile uint32_t        DCH1DSASET __attribute__((section("sfrs"),address(0xBF811168)));
extern volatile uint32_t        DCH1DSAINV __attribute__((section("sfrs"),address(0xBF81116C)));
#define DCH1SSIZ DCH1SSIZ
extern volatile uint32_t   DCH1SSIZ __attribute__((section("sfrs"), address(0xBF811170)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH1SSIZbits_t;
extern volatile __DCH1SSIZbits_t DCH1SSIZbits __asm__ ("DCH1SSIZ") __attribute__((section("sfrs"), address(0xBF811170)));
extern volatile uint32_t        DCH1SSIZCLR __attribute__((section("sfrs"),address(0xBF811174)));
extern volatile uint32_t        DCH1SSIZSET __attribute__((section("sfrs"),address(0xBF811178)));
extern volatile uint32_t        DCH1SSIZINV __attribute__((section("sfrs"),address(0xBF81117C)));
#define DCH1DSIZ DCH1DSIZ
extern volatile uint32_t   DCH1DSIZ __attribute__((section("sfrs"), address(0xBF811180)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH1DSIZbits_t;
extern volatile __DCH1DSIZbits_t DCH1DSIZbits __asm__ ("DCH1DSIZ") __attribute__((section("sfrs"), address(0xBF811180)));
extern volatile uint32_t        DCH1DSIZCLR __attribute__((section("sfrs"),address(0xBF811184)));
extern volatile uint32_t        DCH1DSIZSET __attribute__((section("sfrs"),address(0xBF811188)));
extern volatile uint32_t        DCH1DSIZINV __attribute__((section("sfrs"),address(0xBF81118C)));
#define DCH1SPTR DCH1SPTR
extern volatile uint32_t   DCH1SPTR __attribute__((section("sfrs"), address(0xBF811190)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH1SPTRbits_t;
extern volatile __DCH1SPTRbits_t DCH1SPTRbits __asm__ ("DCH1SPTR") __attribute__((section("sfrs"), address(0xBF811190)));
extern volatile uint32_t        DCH1SPTRCLR __attribute__((section("sfrs"),address(0xBF811194)));
extern volatile uint32_t        DCH1SPTRSET __attribute__((section("sfrs"),address(0xBF811198)));
extern volatile uint32_t        DCH1SPTRINV __attribute__((section("sfrs"),address(0xBF81119C)));
#define DCH1DPTR DCH1DPTR
extern volatile uint32_t   DCH1DPTR __attribute__((section("sfrs"), address(0xBF8111A0)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH1DPTRbits_t;
extern volatile __DCH1DPTRbits_t DCH1DPTRbits __asm__ ("DCH1DPTR") __attribute__((section("sfrs"), address(0xBF8111A0)));
extern volatile uint32_t        DCH1DPTRCLR __attribute__((section("sfrs"),address(0xBF8111A4)));
extern volatile uint32_t        DCH1DPTRSET __attribute__((section("sfrs"),address(0xBF8111A8)));
extern volatile uint32_t        DCH1DPTRINV __attribute__((section("sfrs"),address(0xBF8111AC)));
#define DCH1CSIZ DCH1CSIZ
extern volatile uint32_t   DCH1CSIZ __attribute__((section("sfrs"), address(0xBF8111B0)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH1CSIZbits_t;
extern volatile __DCH1CSIZbits_t DCH1CSIZbits __asm__ ("DCH1CSIZ") __attribute__((section("sfrs"), address(0xBF8111B0)));
extern volatile uint32_t        DCH1CSIZCLR __attribute__((section("sfrs"),address(0xBF8111B4)));
extern volatile uint32_t        DCH1CSIZSET __attribute__((section("sfrs"),address(0xBF8111B8)));
extern volatile uint32_t        DCH1CSIZINV __attribute__((section("sfrs"),address(0xBF8111BC)));
#define DCH1CPTR DCH1CPTR
extern volatile uint32_t   DCH1CPTR __attribute__((section("sfrs"), address(0xBF8111C0)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH1CPTRbits_t;
extern volatile __DCH1CPTRbits_t DCH1CPTRbits __asm__ ("DCH1CPTR") __attribute__((section("sfrs"), address(0xBF8111C0)));
#define DCS1CPTR DCS1CPTR
extern volatile uint32_t   DCS1CPTR __attribute__((section("sfrs"), address(0xBF8111C0)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS1CPTRbits_t;
extern volatile __DCS1CPTRbits_t DCS1CPTRbits __asm__ ("DCS1CPTR") __attribute__((section("sfrs"), address(0xBF8111C0)));
extern volatile uint32_t        DCH1CPTRCLR __attribute__((section("sfrs"),address(0xBF8111C4)));
extern volatile uint32_t        DCS1CPTRCLR __attribute__((section("sfrs"),address(0xBF8111C4)));
extern volatile uint32_t        DCH1CPTRSET __attribute__((section("sfrs"),address(0xBF8111C8)));
extern volatile uint32_t        DCS1CPTRSET __attribute__((section("sfrs"),address(0xBF8111C8)));
extern volatile uint32_t        DCH1CPTRINV __attribute__((section("sfrs"),address(0xBF8111CC)));
extern volatile uint32_t        DCS1CPTRINV __attribute__((section("sfrs"),address(0xBF8111CC)));
#define DCH1DAT DCH1DAT
extern volatile uint32_t   DCH1DAT __attribute__((section("sfrs"), address(0xBF8111D0)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH1DATbits_t;
extern volatile __DCH1DATbits_t DCH1DATbits __asm__ ("DCH1DAT") __attribute__((section("sfrs"), address(0xBF8111D0)));
extern volatile uint32_t        DCH1DATCLR __attribute__((section("sfrs"),address(0xBF8111D4)));
extern volatile uint32_t        DCH1DATSET __attribute__((section("sfrs"),address(0xBF8111D8)));
extern volatile uint32_t        DCH1DATINV __attribute__((section("sfrs"),address(0xBF8111DC)));
#define DCH2CON DCH2CON
extern volatile uint32_t   DCH2CON __attribute__((section("sfrs"), address(0xBF8111E0)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH2CONbits_t;
extern volatile __DCH2CONbits_t DCH2CONbits __asm__ ("DCH2CON") __attribute__((section("sfrs"), address(0xBF8111E0)));
extern volatile uint32_t        DCH2CONCLR __attribute__((section("sfrs"),address(0xBF8111E4)));
extern volatile uint32_t        DCH2CONSET __attribute__((section("sfrs"),address(0xBF8111E8)));
extern volatile uint32_t        DCH2CONINV __attribute__((section("sfrs"),address(0xBF8111EC)));
#define DCH2ECON DCH2ECON
extern volatile uint32_t   DCH2ECON __attribute__((section("sfrs"), address(0xBF8111F0)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH2ECONbits_t;
extern volatile __DCH2ECONbits_t DCH2ECONbits __asm__ ("DCH2ECON") __attribute__((section("sfrs"), address(0xBF8111F0)));
extern volatile uint32_t        DCH2ECONCLR __attribute__((section("sfrs"),address(0xBF8111F4)));
extern volatile uint32_t        DCH2ECONSET __attribute__((section("sfrs"),address(0xBF8111F8)));
extern volatile uint32_t        DCH2ECONINV __attribute__((section("sfrs"),address(0xBF8111FC)));
#define DCH2INT DCH2INT
extern volatile uint32_t   DCH2INT __attribute__((section("sfrs"), address(0xBF811200)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH2INTbits_t;
extern volatile __DCH2INTbits_t DCH2INTbits __asm__ ("DCH2INT") __attribute__((section("sfrs"), address(0xBF811200)));
extern volatile uint32_t        DCH2INTCLR __attribute__((section("sfrs"),address(0xBF811204)));
extern volatile uint32_t        DCH2INTSET __attribute__((section("sfrs"),address(0xBF811208)));
extern volatile uint32_t        DCH2INTINV __attribute__((section("sfrs"),address(0xBF81120C)));
#define DCH2SSA DCH2SSA
extern volatile uint32_t   DCH2SSA __attribute__((section("sfrs"), address(0xBF811210)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH2SSAbits_t;
extern volatile __DCH2SSAbits_t DCH2SSAbits __asm__ ("DCH2SSA") __attribute__((section("sfrs"), address(0xBF811210)));
extern volatile uint32_t        DCH2SSACLR __attribute__((section("sfrs"),address(0xBF811214)));
extern volatile uint32_t        DCH2SSASET __attribute__((section("sfrs"),address(0xBF811218)));
extern volatile uint32_t        DCH2SSAINV __attribute__((section("sfrs"),address(0xBF81121C)));
#define DCH2DSA DCH2DSA
extern volatile uint32_t   DCH2DSA __attribute__((section("sfrs"), address(0xBF811220)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH2DSAbits_t;
extern volatile __DCH2DSAbits_t DCH2DSAbits __asm__ ("DCH2DSA") __attribute__((section("sfrs"), address(0xBF811220)));
extern volatile uint32_t        DCH2DSACLR __attribute__((section("sfrs"),address(0xBF811224)));
extern volatile uint32_t        DCH2DSASET __attribute__((section("sfrs"),address(0xBF811228)));
extern volatile uint32_t        DCH2DSAINV __attribute__((section("sfrs"),address(0xBF81122C)));
#define DCH2SSIZ DCH2SSIZ
extern volatile uint32_t   DCH2SSIZ __attribute__((section("sfrs"), address(0xBF811230)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH2SSIZbits_t;
extern volatile __DCH2SSIZbits_t DCH2SSIZbits __asm__ ("DCH2SSIZ") __attribute__((section("sfrs"), address(0xBF811230)));
extern volatile uint32_t        DCH2SSIZCLR __attribute__((section("sfrs"),address(0xBF811234)));
extern volatile uint32_t        DCH2SSIZSET __attribute__((section("sfrs"),address(0xBF811238)));
extern volatile uint32_t        DCH2SSIZINV __attribute__((section("sfrs"),address(0xBF81123C)));
#define DCH2DSIZ DCH2DSIZ
extern volatile uint32_t   DCH2DSIZ __attribute__((section("sfrs"), address(0xBF811240)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH2DSIZbits_t;
extern volatile __DCH2DSIZbits_t DCH2DSIZbits __asm__ ("DCH2DSIZ") __attribute__((section("sfrs"), address(0xBF811240)));
extern volatile uint32_t        DCH2DSIZCLR __attribute__((section("sfrs"),address(0xBF811244)));
extern volatile uint32_t        DCH2DSIZSET __attribute__((section("sfrs"),address(0xBF811248)));
extern volatile uint32_t        DCH2DSIZINV __attribute__((section("sfrs"),address(0xBF81124C)));
#define DCH2SPTR DCH2SPTR
extern volatile uint32_t   DCH2SPTR __attribute__((section("sfrs"), address(0xBF811250)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH2SPTRbits_t;
extern volatile __DCH2SPTRbits_t DCH2SPTRbits __asm__ ("DCH2SPTR") __attribute__((section("sfrs"), address(0xBF811250)));
extern volatile uint32_t        DCH2SPTRCLR __attribute__((section("sfrs"),address(0xBF811254)));
extern volatile uint32_t        DCH2SPTRSET __attribute__((section("sfrs"),address(0xBF811258)));
extern volatile uint32_t        DCH2SPTRINV __attribute__((section("sfrs"),address(0xBF81125C)));
#define DCH2DPTR DCH2DPTR
extern volatile uint32_t   DCH2DPTR __attribute__((section("sfrs"), address(0xBF811260)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH2DPTRbits_t;
extern volatile __DCH2DPTRbits_t DCH2DPTRbits __asm__ ("DCH2DPTR") __attribute__((section("sfrs"), address(0xBF811260)));
extern volatile uint32_t        DCH2DPTRCLR __attribute__((section("sfrs"),address(0xBF811264)));
extern volatile uint32_t        DCH2DPTRSET __attribute__((section("sfrs"),address(0xBF811268)));
extern volatile uint32_t        DCH2DPTRINV __attribute__((section("sfrs"),address(0xBF81126C)));
#define DCH2CSIZ DCH2CSIZ
extern volatile uint32_t   DCH2CSIZ __attribute__((section("sfrs"), address(0xBF811270)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH2CSIZbits_t;
extern volatile __DCH2CSIZbits_t DCH2CSIZbits __asm__ ("DCH2CSIZ") __attribute__((section("sfrs"), address(0xBF811270)));
extern volatile uint32_t        DCH2CSIZCLR __attribute__((section("sfrs"),address(0xBF811274)));
extern volatile uint32_t        DCH2CSIZSET __attribute__((section("sfrs"),address(0xBF811278)));
extern volatile uint32_t        DCH2CSIZINV __attribute__((section("sfrs"),address(0xBF81127C)));
#define DCH2CPTR DCH2CPTR
extern volatile uint32_t   DCH2CPTR __attribute__((section("sfrs"), address(0xBF811280)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH2CPTRbits_t;
extern volatile __DCH2CPTRbits_t DCH2CPTRbits __asm__ ("DCH2CPTR") __attribute__((section("sfrs"), address(0xBF811280)));
#define DCS2CPTR DCS2CPTR
extern volatile uint32_t   DCS2CPTR __attribute__((section("sfrs"), address(0xBF811280)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS2CPTRbits_t;
extern volatile __DCS2CPTRbits_t DCS2CPTRbits __asm__ ("DCS2CPTR") __attribute__((section("sfrs"), address(0xBF811280)));
extern volatile uint32_t        DCH2CPTRCLR __attribute__((section("sfrs"),address(0xBF811284)));
extern volatile uint32_t        DCS2CPTRCLR __attribute__((section("sfrs"),address(0xBF811284)));
extern volatile uint32_t        DCH2CPTRSET __attribute__((section("sfrs"),address(0xBF811288)));
extern volatile uint32_t        DCS2CPTRSET __attribute__((section("sfrs"),address(0xBF811288)));
extern volatile uint32_t        DCH2CPTRINV __attribute__((section("sfrs"),address(0xBF81128C)));
extern volatile uint32_t        DCS2CPTRINV __attribute__((section("sfrs"),address(0xBF81128C)));
#define DCH2DAT DCH2DAT
extern volatile uint32_t   DCH2DAT __attribute__((section("sfrs"), address(0xBF811290)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH2DATbits_t;
extern volatile __DCH2DATbits_t DCH2DATbits __asm__ ("DCH2DAT") __attribute__((section("sfrs"), address(0xBF811290)));
extern volatile uint32_t        DCH2DATCLR __attribute__((section("sfrs"),address(0xBF811294)));
extern volatile uint32_t        DCH2DATSET __attribute__((section("sfrs"),address(0xBF811298)));
extern volatile uint32_t        DCH2DATINV __attribute__((section("sfrs"),address(0xBF81129C)));
#define DCH3CON DCH3CON
extern volatile uint32_t   DCH3CON __attribute__((section("sfrs"), address(0xBF8112A0)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH3CONbits_t;
extern volatile __DCH3CONbits_t DCH3CONbits __asm__ ("DCH3CON") __attribute__((section("sfrs"), address(0xBF8112A0)));
extern volatile uint32_t        DCH3CONCLR __attribute__((section("sfrs"),address(0xBF8112A4)));
extern volatile uint32_t        DCH3CONSET __attribute__((section("sfrs"),address(0xBF8112A8)));
extern volatile uint32_t        DCH3CONINV __attribute__((section("sfrs"),address(0xBF8112AC)));
#define DCH3ECON DCH3ECON
extern volatile uint32_t   DCH3ECON __attribute__((section("sfrs"), address(0xBF8112B0)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH3ECONbits_t;
extern volatile __DCH3ECONbits_t DCH3ECONbits __asm__ ("DCH3ECON") __attribute__((section("sfrs"), address(0xBF8112B0)));
extern volatile uint32_t        DCH3ECONCLR __attribute__((section("sfrs"),address(0xBF8112B4)));
extern volatile uint32_t        DCH3ECONSET __attribute__((section("sfrs"),address(0xBF8112B8)));
extern volatile uint32_t        DCH3ECONINV __attribute__((section("sfrs"),address(0xBF8112BC)));
#define DCH3INT DCH3INT
extern volatile uint32_t   DCH3INT __attribute__((section("sfrs"), address(0xBF8112C0)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH3INTbits_t;
extern volatile __DCH3INTbits_t DCH3INTbits __asm__ ("DCH3INT") __attribute__((section("sfrs"), address(0xBF8112C0)));
extern volatile uint32_t        DCH3INTCLR __attribute__((section("sfrs"),address(0xBF8112C4)));
extern volatile uint32_t        DCH3INTSET __attribute__((section("sfrs"),address(0xBF8112C8)));
extern volatile uint32_t        DCH3INTINV __attribute__((section("sfrs"),address(0xBF8112CC)));
#define DCH3SSA DCH3SSA
extern volatile uint32_t   DCH3SSA __attribute__((section("sfrs"), address(0xBF8112D0)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH3SSAbits_t;
extern volatile __DCH3SSAbits_t DCH3SSAbits __asm__ ("DCH3SSA") __attribute__((section("sfrs"), address(0xBF8112D0)));
extern volatile uint32_t        DCH3SSACLR __attribute__((section("sfrs"),address(0xBF8112D4)));
extern volatile uint32_t        DCH3SSASET __attribute__((section("sfrs"),address(0xBF8112D8)));
extern volatile uint32_t        DCH3SSAINV __attribute__((section("sfrs"),address(0xBF8112DC)));
#define DCH3DSA DCH3DSA
extern volatile uint32_t   DCH3DSA __attribute__((section("sfrs"), address(0xBF8112E0)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH3DSAbits_t;
extern volatile __DCH3DSAbits_t DCH3DSAbits __asm__ ("DCH3DSA") __attribute__((section("sfrs"), address(0xBF8112E0)));
extern volatile uint32_t        DCH3DSACLR __attribute__((section("sfrs"),address(0xBF8112E4)));
extern volatile uint32_t        DCH3DSASET __attribute__((section("sfrs"),address(0xBF8112E8)));
extern volatile uint32_t        DCH3DSAINV __attribute__((section("sfrs"),address(0xBF8112EC)));
#define DCH3SSIZ DCH3SSIZ
extern volatile uint32_t   DCH3SSIZ __attribute__((section("sfrs"), address(0xBF8112F0)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH3SSIZbits_t;
extern volatile __DCH3SSIZbits_t DCH3SSIZbits __asm__ ("DCH3SSIZ") __attribute__((section("sfrs"), address(0xBF8112F0)));
extern volatile uint32_t        DCH3SSIZCLR __attribute__((section("sfrs"),address(0xBF8112F4)));
extern volatile uint32_t        DCH3SSIZSET __attribute__((section("sfrs"),address(0xBF8112F8)));
extern volatile uint32_t        DCH3SSIZINV __attribute__((section("sfrs"),address(0xBF8112FC)));
#define DCH3DSIZ DCH3DSIZ
extern volatile uint32_t   DCH3DSIZ __attribute__((section("sfrs"), address(0xBF811300)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH3DSIZbits_t;
extern volatile __DCH3DSIZbits_t DCH3DSIZbits __asm__ ("DCH3DSIZ") __attribute__((section("sfrs"), address(0xBF811300)));
extern volatile uint32_t        DCH3DSIZCLR __attribute__((section("sfrs"),address(0xBF811304)));
extern volatile uint32_t        DCH3DSIZSET __attribute__((section("sfrs"),address(0xBF811308)));
extern volatile uint32_t        DCH3DSIZINV __attribute__((section("sfrs"),address(0xBF81130C)));
#define DCH3SPTR DCH3SPTR
extern volatile uint32_t   DCH3SPTR __attribute__((section("sfrs"), address(0xBF811310)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH3SPTRbits_t;
extern volatile __DCH3SPTRbits_t DCH3SPTRbits __asm__ ("DCH3SPTR") __attribute__((section("sfrs"), address(0xBF811310)));
extern volatile uint32_t        DCH3SPTRCLR __attribute__((section("sfrs"),address(0xBF811314)));
extern volatile uint32_t        DCH3SPTRSET __attribute__((section("sfrs"),address(0xBF811318)));
extern volatile uint32_t        DCH3SPTRINV __attribute__((section("sfrs"),address(0xBF81131C)));
#define DCH3DPTR DCH3DPTR
extern volatile uint32_t   DCH3DPTR __attribute__((section("sfrs"), address(0xBF811320)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH3DPTRbits_t;
extern volatile __DCH3DPTRbits_t DCH3DPTRbits __asm__ ("DCH3DPTR") __attribute__((section("sfrs"), address(0xBF811320)));
extern volatile uint32_t        DCH3DPTRCLR __attribute__((section("sfrs"),address(0xBF811324)));
extern volatile uint32_t        DCH3DPTRSET __attribute__((section("sfrs"),address(0xBF811328)));
extern volatile uint32_t        DCH3DPTRINV __attribute__((section("sfrs"),address(0xBF81132C)));
#define DCH3CSIZ DCH3CSIZ
extern volatile uint32_t   DCH3CSIZ __attribute__((section("sfrs"), address(0xBF811330)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH3CSIZbits_t;
extern volatile __DCH3CSIZbits_t DCH3CSIZbits __asm__ ("DCH3CSIZ") __attribute__((section("sfrs"), address(0xBF811330)));
extern volatile uint32_t        DCH3CSIZCLR __attribute__((section("sfrs"),address(0xBF811334)));
extern volatile uint32_t        DCH3CSIZSET __attribute__((section("sfrs"),address(0xBF811338)));
extern volatile uint32_t        DCH3CSIZINV __attribute__((section("sfrs"),address(0xBF81133C)));
#define DCH3CPTR DCH3CPTR
extern volatile uint32_t   DCH3CPTR __attribute__((section("sfrs"), address(0xBF811340)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH3CPTRbits_t;
extern volatile __DCH3CPTRbits_t DCH3CPTRbits __asm__ ("DCH3CPTR") __attribute__((section("sfrs"), address(0xBF811340)));
#define DCS3CPTR DCS3CPTR
extern volatile uint32_t   DCS3CPTR __attribute__((section("sfrs"), address(0xBF811340)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS3CPTRbits_t;
extern volatile __DCS3CPTRbits_t DCS3CPTRbits __asm__ ("DCS3CPTR") __attribute__((section("sfrs"), address(0xBF811340)));
extern volatile uint32_t        DCH3CPTRCLR __attribute__((section("sfrs"),address(0xBF811344)));
extern volatile uint32_t        DCS3CPTRCLR __attribute__((section("sfrs"),address(0xBF811344)));
extern volatile uint32_t        DCH3CPTRSET __attribute__((section("sfrs"),address(0xBF811348)));
extern volatile uint32_t        DCS3CPTRSET __attribute__((section("sfrs"),address(0xBF811348)));
extern volatile uint32_t        DCH3CPTRINV __attribute__((section("sfrs"),address(0xBF81134C)));
extern volatile uint32_t        DCS3CPTRINV __attribute__((section("sfrs"),address(0xBF81134C)));
#define DCH3DAT DCH3DAT
extern volatile uint32_t   DCH3DAT __attribute__((section("sfrs"), address(0xBF811350)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH3DATbits_t;
extern volatile __DCH3DATbits_t DCH3DATbits __asm__ ("DCH3DAT") __attribute__((section("sfrs"), address(0xBF811350)));
extern volatile uint32_t        DCH3DATCLR __attribute__((section("sfrs"),address(0xBF811354)));
extern volatile uint32_t        DCH3DATSET __attribute__((section("sfrs"),address(0xBF811358)));
extern volatile uint32_t        DCH3DATINV __attribute__((section("sfrs"),address(0xBF81135C)));
#define DCH4CON DCH4CON
extern volatile uint32_t   DCH4CON __attribute__((section("sfrs"), address(0xBF811360)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH4CONbits_t;
extern volatile __DCH4CONbits_t DCH4CONbits __asm__ ("DCH4CON") __attribute__((section("sfrs"), address(0xBF811360)));
extern volatile uint32_t        DCH4CONCLR __attribute__((section("sfrs"),address(0xBF811364)));
extern volatile uint32_t        DCH4CONSET __attribute__((section("sfrs"),address(0xBF811368)));
extern volatile uint32_t        DCH4CONINV __attribute__((section("sfrs"),address(0xBF81136C)));
#define DCH4ECON DCH4ECON
extern volatile uint32_t   DCH4ECON __attribute__((section("sfrs"), address(0xBF811370)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH4ECONbits_t;
extern volatile __DCH4ECONbits_t DCH4ECONbits __asm__ ("DCH4ECON") __attribute__((section("sfrs"), address(0xBF811370)));
extern volatile uint32_t        DCH4ECONCLR __attribute__((section("sfrs"),address(0xBF811374)));
extern volatile uint32_t        DCH4ECONSET __attribute__((section("sfrs"),address(0xBF811378)));
extern volatile uint32_t        DCH4ECONINV __attribute__((section("sfrs"),address(0xBF81137C)));
#define DCH4INT DCH4INT
extern volatile uint32_t   DCH4INT __attribute__((section("sfrs"), address(0xBF811380)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH4INTbits_t;
extern volatile __DCH4INTbits_t DCH4INTbits __asm__ ("DCH4INT") __attribute__((section("sfrs"), address(0xBF811380)));
extern volatile uint32_t        DCH4INTCLR __attribute__((section("sfrs"),address(0xBF811384)));
extern volatile uint32_t        DCH4INTSET __attribute__((section("sfrs"),address(0xBF811388)));
extern volatile uint32_t        DCH4INTINV __attribute__((section("sfrs"),address(0xBF81138C)));
#define DCH4SSA DCH4SSA
extern volatile uint32_t   DCH4SSA __attribute__((section("sfrs"), address(0xBF811390)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH4SSAbits_t;
extern volatile __DCH4SSAbits_t DCH4SSAbits __asm__ ("DCH4SSA") __attribute__((section("sfrs"), address(0xBF811390)));
extern volatile uint32_t        DCH4SSACLR __attribute__((section("sfrs"),address(0xBF811394)));
extern volatile uint32_t        DCH4SSASET __attribute__((section("sfrs"),address(0xBF811398)));
extern volatile uint32_t        DCH4SSAINV __attribute__((section("sfrs"),address(0xBF81139C)));
#define DCH4DSA DCH4DSA
extern volatile uint32_t   DCH4DSA __attribute__((section("sfrs"), address(0xBF8113A0)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH4DSAbits_t;
extern volatile __DCH4DSAbits_t DCH4DSAbits __asm__ ("DCH4DSA") __attribute__((section("sfrs"), address(0xBF8113A0)));
extern volatile uint32_t        DCH4DSACLR __attribute__((section("sfrs"),address(0xBF8113A4)));
extern volatile uint32_t        DCH4DSASET __attribute__((section("sfrs"),address(0xBF8113A8)));
extern volatile uint32_t        DCH4DSAINV __attribute__((section("sfrs"),address(0xBF8113AC)));
#define DCH4SSIZ DCH4SSIZ
extern volatile uint32_t   DCH4SSIZ __attribute__((section("sfrs"), address(0xBF8113B0)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH4SSIZbits_t;
extern volatile __DCH4SSIZbits_t DCH4SSIZbits __asm__ ("DCH4SSIZ") __attribute__((section("sfrs"), address(0xBF8113B0)));
extern volatile uint32_t        DCH4SSIZCLR __attribute__((section("sfrs"),address(0xBF8113B4)));
extern volatile uint32_t        DCH4SSIZSET __attribute__((section("sfrs"),address(0xBF8113B8)));
extern volatile uint32_t        DCH4SSIZINV __attribute__((section("sfrs"),address(0xBF8113BC)));
#define DCH4DSIZ DCH4DSIZ
extern volatile uint32_t   DCH4DSIZ __attribute__((section("sfrs"), address(0xBF8113C0)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH4DSIZbits_t;
extern volatile __DCH4DSIZbits_t DCH4DSIZbits __asm__ ("DCH4DSIZ") __attribute__((section("sfrs"), address(0xBF8113C0)));
extern volatile uint32_t        DCH4DSIZCLR __attribute__((section("sfrs"),address(0xBF8113C4)));
extern volatile uint32_t        DCH4DSIZSET __attribute__((section("sfrs"),address(0xBF8113C8)));
extern volatile uint32_t        DCH4DSIZINV __attribute__((section("sfrs"),address(0xBF8113CC)));
#define DCH4SPTR DCH4SPTR
extern volatile uint32_t   DCH4SPTR __attribute__((section("sfrs"), address(0xBF8113D0)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH4SPTRbits_t;
extern volatile __DCH4SPTRbits_t DCH4SPTRbits __asm__ ("DCH4SPTR") __attribute__((section("sfrs"), address(0xBF8113D0)));
extern volatile uint32_t        DCH4SPTRCLR __attribute__((section("sfrs"),address(0xBF8113D4)));
extern volatile uint32_t        DCH4SPTRSET __attribute__((section("sfrs"),address(0xBF8113D8)));
extern volatile uint32_t        DCH4SPTRINV __attribute__((section("sfrs"),address(0xBF8113DC)));
#define DCH4DPTR DCH4DPTR
extern volatile uint32_t   DCH4DPTR __attribute__((section("sfrs"), address(0xBF8113E0)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH4DPTRbits_t;
extern volatile __DCH4DPTRbits_t DCH4DPTRbits __asm__ ("DCH4DPTR") __attribute__((section("sfrs"), address(0xBF8113E0)));
extern volatile uint32_t        DCH4DPTRCLR __attribute__((section("sfrs"),address(0xBF8113E4)));
extern volatile uint32_t        DCH4DPTRSET __attribute__((section("sfrs"),address(0xBF8113E8)));
extern volatile uint32_t        DCH4DPTRINV __attribute__((section("sfrs"),address(0xBF8113EC)));
#define DCH4CSIZ DCH4CSIZ
extern volatile uint32_t   DCH4CSIZ __attribute__((section("sfrs"), address(0xBF8113F0)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH4CSIZbits_t;
extern volatile __DCH4CSIZbits_t DCH4CSIZbits __asm__ ("DCH4CSIZ") __attribute__((section("sfrs"), address(0xBF8113F0)));
extern volatile uint32_t        DCH4CSIZCLR __attribute__((section("sfrs"),address(0xBF8113F4)));
extern volatile uint32_t        DCH4CSIZSET __attribute__((section("sfrs"),address(0xBF8113F8)));
extern volatile uint32_t        DCH4CSIZINV __attribute__((section("sfrs"),address(0xBF8113FC)));
#define DCH4CPTR DCH4CPTR
extern volatile uint32_t   DCH4CPTR __attribute__((section("sfrs"), address(0xBF811400)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH4CPTRbits_t;
extern volatile __DCH4CPTRbits_t DCH4CPTRbits __asm__ ("DCH4CPTR") __attribute__((section("sfrs"), address(0xBF811400)));
#define DCS4CPTR DCS4CPTR
extern volatile uint32_t   DCS4CPTR __attribute__((section("sfrs"), address(0xBF811400)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS4CPTRbits_t;
extern volatile __DCS4CPTRbits_t DCS4CPTRbits __asm__ ("DCS4CPTR") __attribute__((section("sfrs"), address(0xBF811400)));
extern volatile uint32_t        DCH4CPTRCLR __attribute__((section("sfrs"),address(0xBF811404)));
extern volatile uint32_t        DCS4CPTRCLR __attribute__((section("sfrs"),address(0xBF811404)));
extern volatile uint32_t        DCH4CPTRSET __attribute__((section("sfrs"),address(0xBF811408)));
extern volatile uint32_t        DCS4CPTRSET __attribute__((section("sfrs"),address(0xBF811408)));
extern volatile uint32_t        DCH4CPTRINV __attribute__((section("sfrs"),address(0xBF81140C)));
extern volatile uint32_t        DCS4CPTRINV __attribute__((section("sfrs"),address(0xBF81140C)));
#define DCH4DAT DCH4DAT
extern volatile uint32_t   DCH4DAT __attribute__((section("sfrs"), address(0xBF811410)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH4DATbits_t;
extern volatile __DCH4DATbits_t DCH4DATbits __asm__ ("DCH4DAT") __attribute__((section("sfrs"), address(0xBF811410)));
extern volatile uint32_t        DCH4DATCLR __attribute__((section("sfrs"),address(0xBF811414)));
extern volatile uint32_t        DCH4DATSET __attribute__((section("sfrs"),address(0xBF811418)));
extern volatile uint32_t        DCH4DATINV __attribute__((section("sfrs"),address(0xBF81141C)));
#define DCH5CON DCH5CON
extern volatile uint32_t   DCH5CON __attribute__((section("sfrs"), address(0xBF811420)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH5CONbits_t;
extern volatile __DCH5CONbits_t DCH5CONbits __asm__ ("DCH5CON") __attribute__((section("sfrs"), address(0xBF811420)));
extern volatile uint32_t        DCH5CONCLR __attribute__((section("sfrs"),address(0xBF811424)));
extern volatile uint32_t        DCH5CONSET __attribute__((section("sfrs"),address(0xBF811428)));
extern volatile uint32_t        DCH5CONINV __attribute__((section("sfrs"),address(0xBF81142C)));
#define DCH5ECON DCH5ECON
extern volatile uint32_t   DCH5ECON __attribute__((section("sfrs"), address(0xBF811430)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH5ECONbits_t;
extern volatile __DCH5ECONbits_t DCH5ECONbits __asm__ ("DCH5ECON") __attribute__((section("sfrs"), address(0xBF811430)));
extern volatile uint32_t        DCH5ECONCLR __attribute__((section("sfrs"),address(0xBF811434)));
extern volatile uint32_t        DCH5ECONSET __attribute__((section("sfrs"),address(0xBF811438)));
extern volatile uint32_t        DCH5ECONINV __attribute__((section("sfrs"),address(0xBF81143C)));
#define DCH5INT DCH5INT
extern volatile uint32_t   DCH5INT __attribute__((section("sfrs"), address(0xBF811440)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH5INTbits_t;
extern volatile __DCH5INTbits_t DCH5INTbits __asm__ ("DCH5INT") __attribute__((section("sfrs"), address(0xBF811440)));
extern volatile uint32_t        DCH5INTCLR __attribute__((section("sfrs"),address(0xBF811444)));
extern volatile uint32_t        DCH5INTSET __attribute__((section("sfrs"),address(0xBF811448)));
extern volatile uint32_t        DCH5INTINV __attribute__((section("sfrs"),address(0xBF81144C)));
#define DCH5SSA DCH5SSA
extern volatile uint32_t   DCH5SSA __attribute__((section("sfrs"), address(0xBF811450)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH5SSAbits_t;
extern volatile __DCH5SSAbits_t DCH5SSAbits __asm__ ("DCH5SSA") __attribute__((section("sfrs"), address(0xBF811450)));
extern volatile uint32_t        DCH5SSACLR __attribute__((section("sfrs"),address(0xBF811454)));
extern volatile uint32_t        DCH5SSASET __attribute__((section("sfrs"),address(0xBF811458)));
extern volatile uint32_t        DCH5SSAINV __attribute__((section("sfrs"),address(0xBF81145C)));
#define DCH5DSA DCH5DSA
extern volatile uint32_t   DCH5DSA __attribute__((section("sfrs"), address(0xBF811460)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH5DSAbits_t;
extern volatile __DCH5DSAbits_t DCH5DSAbits __asm__ ("DCH5DSA") __attribute__((section("sfrs"), address(0xBF811460)));
extern volatile uint32_t        DCH5DSACLR __attribute__((section("sfrs"),address(0xBF811464)));
extern volatile uint32_t        DCH5DSASET __attribute__((section("sfrs"),address(0xBF811468)));
extern volatile uint32_t        DCH5DSAINV __attribute__((section("sfrs"),address(0xBF81146C)));
#define DCH5SSIZ DCH5SSIZ
extern volatile uint32_t   DCH5SSIZ __attribute__((section("sfrs"), address(0xBF811470)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH5SSIZbits_t;
extern volatile __DCH5SSIZbits_t DCH5SSIZbits __asm__ ("DCH5SSIZ") __attribute__((section("sfrs"), address(0xBF811470)));
extern volatile uint32_t        DCH5SSIZCLR __attribute__((section("sfrs"),address(0xBF811474)));
extern volatile uint32_t        DCH5SSIZSET __attribute__((section("sfrs"),address(0xBF811478)));
extern volatile uint32_t        DCH5SSIZINV __attribute__((section("sfrs"),address(0xBF81147C)));
#define DCH5DSIZ DCH5DSIZ
extern volatile uint32_t   DCH5DSIZ __attribute__((section("sfrs"), address(0xBF811480)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH5DSIZbits_t;
extern volatile __DCH5DSIZbits_t DCH5DSIZbits __asm__ ("DCH5DSIZ") __attribute__((section("sfrs"), address(0xBF811480)));
extern volatile uint32_t        DCH5DSIZCLR __attribute__((section("sfrs"),address(0xBF811484)));
extern volatile uint32_t        DCH5DSIZSET __attribute__((section("sfrs"),address(0xBF811488)));
extern volatile uint32_t        DCH5DSIZINV __attribute__((section("sfrs"),address(0xBF81148C)));
#define DCH5SPTR DCH5SPTR
extern volatile uint32_t   DCH5SPTR __attribute__((section("sfrs"), address(0xBF811490)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH5SPTRbits_t;
extern volatile __DCH5SPTRbits_t DCH5SPTRbits __asm__ ("DCH5SPTR") __attribute__((section("sfrs"), address(0xBF811490)));
extern volatile uint32_t        DCH5SPTRCLR __attribute__((section("sfrs"),address(0xBF811494)));
extern volatile uint32_t        DCH5SPTRSET __attribute__((section("sfrs"),address(0xBF811498)));
extern volatile uint32_t        DCH5SPTRINV __attribute__((section("sfrs"),address(0xBF81149C)));
#define DCH5DPTR DCH5DPTR
extern volatile uint32_t   DCH5DPTR __attribute__((section("sfrs"), address(0xBF8114A0)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH5DPTRbits_t;
extern volatile __DCH5DPTRbits_t DCH5DPTRbits __asm__ ("DCH5DPTR") __attribute__((section("sfrs"), address(0xBF8114A0)));
extern volatile uint32_t        DCH5DPTRCLR __attribute__((section("sfrs"),address(0xBF8114A4)));
extern volatile uint32_t        DCH5DPTRSET __attribute__((section("sfrs"),address(0xBF8114A8)));
extern volatile uint32_t        DCH5DPTRINV __attribute__((section("sfrs"),address(0xBF8114AC)));
#define DCH5CSIZ DCH5CSIZ
extern volatile uint32_t   DCH5CSIZ __attribute__((section("sfrs"), address(0xBF8114B0)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH5CSIZbits_t;
extern volatile __DCH5CSIZbits_t DCH5CSIZbits __asm__ ("DCH5CSIZ") __attribute__((section("sfrs"), address(0xBF8114B0)));
extern volatile uint32_t        DCH5CSIZCLR __attribute__((section("sfrs"),address(0xBF8114B4)));
extern volatile uint32_t        DCH5CSIZSET __attribute__((section("sfrs"),address(0xBF8114B8)));
extern volatile uint32_t        DCH5CSIZINV __attribute__((section("sfrs"),address(0xBF8114BC)));
#define DCH5CPTR DCH5CPTR
extern volatile uint32_t   DCH5CPTR __attribute__((section("sfrs"), address(0xBF8114C0)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH5CPTRbits_t;
extern volatile __DCH5CPTRbits_t DCH5CPTRbits __asm__ ("DCH5CPTR") __attribute__((section("sfrs"), address(0xBF8114C0)));
#define DCS5CPTR DCS5CPTR
extern volatile uint32_t   DCS5CPTR __attribute__((section("sfrs"), address(0xBF8114C0)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS5CPTRbits_t;
extern volatile __DCS5CPTRbits_t DCS5CPTRbits __asm__ ("DCS5CPTR") __attribute__((section("sfrs"), address(0xBF8114C0)));
extern volatile uint32_t        DCH5CPTRCLR __attribute__((section("sfrs"),address(0xBF8114C4)));
extern volatile uint32_t        DCS5CPTRCLR __attribute__((section("sfrs"),address(0xBF8114C4)));
extern volatile uint32_t        DCH5CPTRSET __attribute__((section("sfrs"),address(0xBF8114C8)));
extern volatile uint32_t        DCS5CPTRSET __attribute__((section("sfrs"),address(0xBF8114C8)));
extern volatile uint32_t        DCH5CPTRINV __attribute__((section("sfrs"),address(0xBF8114CC)));
extern volatile uint32_t        DCS5CPTRINV __attribute__((section("sfrs"),address(0xBF8114CC)));
#define DCH5DAT DCH5DAT
extern volatile uint32_t   DCH5DAT __attribute__((section("sfrs"), address(0xBF8114D0)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH5DATbits_t;
extern volatile __DCH5DATbits_t DCH5DATbits __asm__ ("DCH5DAT") __attribute__((section("sfrs"), address(0xBF8114D0)));
extern volatile uint32_t        DCH5DATCLR __attribute__((section("sfrs"),address(0xBF8114D4)));
extern volatile uint32_t        DCH5DATSET __attribute__((section("sfrs"),address(0xBF8114D8)));
extern volatile uint32_t        DCH5DATINV __attribute__((section("sfrs"),address(0xBF8114DC)));
#define DCH6CON DCH6CON
extern volatile uint32_t   DCH6CON __attribute__((section("sfrs"), address(0xBF8114E0)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH6CONbits_t;
extern volatile __DCH6CONbits_t DCH6CONbits __asm__ ("DCH6CON") __attribute__((section("sfrs"), address(0xBF8114E0)));
extern volatile uint32_t        DCH6CONCLR __attribute__((section("sfrs"),address(0xBF8114E4)));
extern volatile uint32_t        DCH6CONSET __attribute__((section("sfrs"),address(0xBF8114E8)));
extern volatile uint32_t        DCH6CONINV __attribute__((section("sfrs"),address(0xBF8114EC)));
#define DCH6ECON DCH6ECON
extern volatile uint32_t   DCH6ECON __attribute__((section("sfrs"), address(0xBF8114F0)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH6ECONbits_t;
extern volatile __DCH6ECONbits_t DCH6ECONbits __asm__ ("DCH6ECON") __attribute__((section("sfrs"), address(0xBF8114F0)));
extern volatile uint32_t        DCH6ECONCLR __attribute__((section("sfrs"),address(0xBF8114F4)));
extern volatile uint32_t        DCH6ECONSET __attribute__((section("sfrs"),address(0xBF8114F8)));
extern volatile uint32_t        DCH6ECONINV __attribute__((section("sfrs"),address(0xBF8114FC)));
#define DCH6INT DCH6INT
extern volatile uint32_t   DCH6INT __attribute__((section("sfrs"), address(0xBF811500)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH6INTbits_t;
extern volatile __DCH6INTbits_t DCH6INTbits __asm__ ("DCH6INT") __attribute__((section("sfrs"), address(0xBF811500)));
extern volatile uint32_t        DCH6INTCLR __attribute__((section("sfrs"),address(0xBF811504)));
extern volatile uint32_t        DCH6INTSET __attribute__((section("sfrs"),address(0xBF811508)));
extern volatile uint32_t        DCH6INTINV __attribute__((section("sfrs"),address(0xBF81150C)));
#define DCH6SSA DCH6SSA
extern volatile uint32_t   DCH6SSA __attribute__((section("sfrs"), address(0xBF811510)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH6SSAbits_t;
extern volatile __DCH6SSAbits_t DCH6SSAbits __asm__ ("DCH6SSA") __attribute__((section("sfrs"), address(0xBF811510)));
extern volatile uint32_t        DCH6SSACLR __attribute__((section("sfrs"),address(0xBF811514)));
extern volatile uint32_t        DCH6SSASET __attribute__((section("sfrs"),address(0xBF811518)));
extern volatile uint32_t        DCH6SSAINV __attribute__((section("sfrs"),address(0xBF81151C)));
#define DCH6DSA DCH6DSA
extern volatile uint32_t   DCH6DSA __attribute__((section("sfrs"), address(0xBF811520)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH6DSAbits_t;
extern volatile __DCH6DSAbits_t DCH6DSAbits __asm__ ("DCH6DSA") __attribute__((section("sfrs"), address(0xBF811520)));
extern volatile uint32_t        DCH6DSACLR __attribute__((section("sfrs"),address(0xBF811524)));
extern volatile uint32_t        DCH6DSASET __attribute__((section("sfrs"),address(0xBF811528)));
extern volatile uint32_t        DCH6DSAINV __attribute__((section("sfrs"),address(0xBF81152C)));
#define DCH6SSIZ DCH6SSIZ
extern volatile uint32_t   DCH6SSIZ __attribute__((section("sfrs"), address(0xBF811530)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH6SSIZbits_t;
extern volatile __DCH6SSIZbits_t DCH6SSIZbits __asm__ ("DCH6SSIZ") __attribute__((section("sfrs"), address(0xBF811530)));
extern volatile uint32_t        DCH6SSIZCLR __attribute__((section("sfrs"),address(0xBF811534)));
extern volatile uint32_t        DCH6SSIZSET __attribute__((section("sfrs"),address(0xBF811538)));
extern volatile uint32_t        DCH6SSIZINV __attribute__((section("sfrs"),address(0xBF81153C)));
#define DCH6DSIZ DCH6DSIZ
extern volatile uint32_t   DCH6DSIZ __attribute__((section("sfrs"), address(0xBF811540)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH6DSIZbits_t;
extern volatile __DCH6DSIZbits_t DCH6DSIZbits __asm__ ("DCH6DSIZ") __attribute__((section("sfrs"), address(0xBF811540)));
extern volatile uint32_t        DCH6DSIZCLR __attribute__((section("sfrs"),address(0xBF811544)));
extern volatile uint32_t        DCH6DSIZSET __attribute__((section("sfrs"),address(0xBF811548)));
extern volatile uint32_t        DCH6DSIZINV __attribute__((section("sfrs"),address(0xBF81154C)));
#define DCH6SPTR DCH6SPTR
extern volatile uint32_t   DCH6SPTR __attribute__((section("sfrs"), address(0xBF811550)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH6SPTRbits_t;
extern volatile __DCH6SPTRbits_t DCH6SPTRbits __asm__ ("DCH6SPTR") __attribute__((section("sfrs"), address(0xBF811550)));
extern volatile uint32_t        DCH6SPTRCLR __attribute__((section("sfrs"),address(0xBF811554)));
extern volatile uint32_t        DCH6SPTRSET __attribute__((section("sfrs"),address(0xBF811558)));
extern volatile uint32_t        DCH6SPTRINV __attribute__((section("sfrs"),address(0xBF81155C)));
#define DCH6DPTR DCH6DPTR
extern volatile uint32_t   DCH6DPTR __attribute__((section("sfrs"), address(0xBF811560)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH6DPTRbits_t;
extern volatile __DCH6DPTRbits_t DCH6DPTRbits __asm__ ("DCH6DPTR") __attribute__((section("sfrs"), address(0xBF811560)));
extern volatile uint32_t        DCH6DPTRCLR __attribute__((section("sfrs"),address(0xBF811564)));
extern volatile uint32_t        DCH6DPTRSET __attribute__((section("sfrs"),address(0xBF811568)));
extern volatile uint32_t        DCH6DPTRINV __attribute__((section("sfrs"),address(0xBF81156C)));
#define DCH6CSIZ DCH6CSIZ
extern volatile uint32_t   DCH6CSIZ __attribute__((section("sfrs"), address(0xBF811570)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH6CSIZbits_t;
extern volatile __DCH6CSIZbits_t DCH6CSIZbits __asm__ ("DCH6CSIZ") __attribute__((section("sfrs"), address(0xBF811570)));
extern volatile uint32_t        DCH6CSIZCLR __attribute__((section("sfrs"),address(0xBF811574)));
extern volatile uint32_t        DCH6CSIZSET __attribute__((section("sfrs"),address(0xBF811578)));
extern volatile uint32_t        DCH6CSIZINV __attribute__((section("sfrs"),address(0xBF81157C)));
#define DCH6CPTR DCH6CPTR
extern volatile uint32_t   DCH6CPTR __attribute__((section("sfrs"), address(0xBF811580)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH6CPTRbits_t;
extern volatile __DCH6CPTRbits_t DCH6CPTRbits __asm__ ("DCH6CPTR") __attribute__((section("sfrs"), address(0xBF811580)));
#define DCS6CPTR DCS6CPTR
extern volatile uint32_t   DCS6CPTR __attribute__((section("sfrs"), address(0xBF811580)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS6CPTRbits_t;
extern volatile __DCS6CPTRbits_t DCS6CPTRbits __asm__ ("DCS6CPTR") __attribute__((section("sfrs"), address(0xBF811580)));
extern volatile uint32_t        DCH6CPTRCLR __attribute__((section("sfrs"),address(0xBF811584)));
extern volatile uint32_t        DCS6CPTRCLR __attribute__((section("sfrs"),address(0xBF811584)));
extern volatile uint32_t        DCH6CPTRSET __attribute__((section("sfrs"),address(0xBF811588)));
extern volatile uint32_t        DCS6CPTRSET __attribute__((section("sfrs"),address(0xBF811588)));
extern volatile uint32_t        DCH6CPTRINV __attribute__((section("sfrs"),address(0xBF81158C)));
extern volatile uint32_t        DCS6CPTRINV __attribute__((section("sfrs"),address(0xBF81158C)));
#define DCH6DAT DCH6DAT
extern volatile uint32_t   DCH6DAT __attribute__((section("sfrs"), address(0xBF811590)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH6DATbits_t;
extern volatile __DCH6DATbits_t DCH6DATbits __asm__ ("DCH6DAT") __attribute__((section("sfrs"), address(0xBF811590)));
extern volatile uint32_t        DCH6DATCLR __attribute__((section("sfrs"),address(0xBF811594)));
extern volatile uint32_t        DCH6DATSET __attribute__((section("sfrs"),address(0xBF811598)));
extern volatile uint32_t        DCH6DATINV __attribute__((section("sfrs"),address(0xBF81159C)));
#define DCH7CON DCH7CON
extern volatile uint32_t   DCH7CON __attribute__((section("sfrs"), address(0xBF8115A0)));
typedef struct {
  uint32_t CHPRI:2;
  uint32_t CHEDET:1;
  uint32_t :1;
  uint32_t CHAEN:1;
  uint32_t CHCHN:1;
  uint32_t CHAED:1;
  uint32_t CHEN:1;
  uint32_t CHCHNS:1;
  uint32_t :2;
  uint32_t CHPATLEN:1;
  uint32_t :1;
  uint32_t CHPIGNEN:1;
  uint32_t :1;
  uint32_t CHBUSY:1;
  uint32_t :8;
  uint32_t CHPIGN:8;
} __DCH7CONbits_t;
extern volatile __DCH7CONbits_t DCH7CONbits __asm__ ("DCH7CON") __attribute__((section("sfrs"), address(0xBF8115A0)));
extern volatile uint32_t        DCH7CONCLR __attribute__((section("sfrs"),address(0xBF8115A4)));
extern volatile uint32_t        DCH7CONSET __attribute__((section("sfrs"),address(0xBF8115A8)));
extern volatile uint32_t        DCH7CONINV __attribute__((section("sfrs"),address(0xBF8115AC)));
#define DCH7ECON DCH7ECON
extern volatile uint32_t   DCH7ECON __attribute__((section("sfrs"), address(0xBF8115B0)));
typedef struct {
  uint32_t :3;
  uint32_t AIRQEN:1;
  uint32_t SIRQEN:1;
  uint32_t PATEN:1;
  uint32_t CABORT:1;
  uint32_t CFORCE:1;
  uint32_t CHSIRQ:8;
  uint32_t CHAIRQ:8;
} __DCH7ECONbits_t;
extern volatile __DCH7ECONbits_t DCH7ECONbits __asm__ ("DCH7ECON") __attribute__((section("sfrs"), address(0xBF8115B0)));
extern volatile uint32_t        DCH7ECONCLR __attribute__((section("sfrs"),address(0xBF8115B4)));
extern volatile uint32_t        DCH7ECONSET __attribute__((section("sfrs"),address(0xBF8115B8)));
extern volatile uint32_t        DCH7ECONINV __attribute__((section("sfrs"),address(0xBF8115BC)));
#define DCH7INT DCH7INT
extern volatile uint32_t   DCH7INT __attribute__((section("sfrs"), address(0xBF8115C0)));
typedef struct {
  uint32_t CHERIF:1;
  uint32_t CHTAIF:1;
  uint32_t CHCCIF:1;
  uint32_t CHBCIF:1;
  uint32_t CHDHIF:1;
  uint32_t CHDDIF:1;
  uint32_t CHSHIF:1;
  uint32_t CHSDIF:1;
  uint32_t :8;
  uint32_t CHERIE:1;
  uint32_t CHTAIE:1;
  uint32_t CHCCIE:1;
  uint32_t CHBCIE:1;
  uint32_t CHDHIE:1;
  uint32_t CHDDIE:1;
  uint32_t CHSHIE:1;
  uint32_t CHSDIE:1;
} __DCH7INTbits_t;
extern volatile __DCH7INTbits_t DCH7INTbits __asm__ ("DCH7INT") __attribute__((section("sfrs"), address(0xBF8115C0)));
extern volatile uint32_t        DCH7INTCLR __attribute__((section("sfrs"),address(0xBF8115C4)));
extern volatile uint32_t        DCH7INTSET __attribute__((section("sfrs"),address(0xBF8115C8)));
extern volatile uint32_t        DCH7INTINV __attribute__((section("sfrs"),address(0xBF8115CC)));
#define DCH7SSA DCH7SSA
extern volatile uint32_t   DCH7SSA __attribute__((section("sfrs"), address(0xBF8115D0)));
typedef struct {
  uint32_t CHSSA:32;
} __DCH7SSAbits_t;
extern volatile __DCH7SSAbits_t DCH7SSAbits __asm__ ("DCH7SSA") __attribute__((section("sfrs"), address(0xBF8115D0)));
extern volatile uint32_t        DCH7SSACLR __attribute__((section("sfrs"),address(0xBF8115D4)));
extern volatile uint32_t        DCH7SSASET __attribute__((section("sfrs"),address(0xBF8115D8)));
extern volatile uint32_t        DCH7SSAINV __attribute__((section("sfrs"),address(0xBF8115DC)));
#define DCH7DSA DCH7DSA
extern volatile uint32_t   DCH7DSA __attribute__((section("sfrs"), address(0xBF8115E0)));
typedef struct {
  uint32_t CHDSA:32;
} __DCH7DSAbits_t;
extern volatile __DCH7DSAbits_t DCH7DSAbits __asm__ ("DCH7DSA") __attribute__((section("sfrs"), address(0xBF8115E0)));
extern volatile uint32_t        DCH7DSACLR __attribute__((section("sfrs"),address(0xBF8115E4)));
extern volatile uint32_t        DCH7DSASET __attribute__((section("sfrs"),address(0xBF8115E8)));
extern volatile uint32_t        DCH7DSAINV __attribute__((section("sfrs"),address(0xBF8115EC)));
#define DCH7SSIZ DCH7SSIZ
extern volatile uint32_t   DCH7SSIZ __attribute__((section("sfrs"), address(0xBF8115F0)));
typedef struct {
  uint32_t CHSSIZ:16;
} __DCH7SSIZbits_t;
extern volatile __DCH7SSIZbits_t DCH7SSIZbits __asm__ ("DCH7SSIZ") __attribute__((section("sfrs"), address(0xBF8115F0)));
extern volatile uint32_t        DCH7SSIZCLR __attribute__((section("sfrs"),address(0xBF8115F4)));
extern volatile uint32_t        DCH7SSIZSET __attribute__((section("sfrs"),address(0xBF8115F8)));
extern volatile uint32_t        DCH7SSIZINV __attribute__((section("sfrs"),address(0xBF8115FC)));
#define DCH7DSIZ DCH7DSIZ
extern volatile uint32_t   DCH7DSIZ __attribute__((section("sfrs"), address(0xBF811600)));
typedef struct {
  uint32_t CHDSIZ:16;
} __DCH7DSIZbits_t;
extern volatile __DCH7DSIZbits_t DCH7DSIZbits __asm__ ("DCH7DSIZ") __attribute__((section("sfrs"), address(0xBF811600)));
extern volatile uint32_t        DCH7DSIZCLR __attribute__((section("sfrs"),address(0xBF811604)));
extern volatile uint32_t        DCH7DSIZSET __attribute__((section("sfrs"),address(0xBF811608)));
extern volatile uint32_t        DCH7DSIZINV __attribute__((section("sfrs"),address(0xBF81160C)));
#define DCH7SPTR DCH7SPTR
extern volatile uint32_t   DCH7SPTR __attribute__((section("sfrs"), address(0xBF811610)));
typedef struct {
  uint32_t CHSPTR:16;
} __DCH7SPTRbits_t;
extern volatile __DCH7SPTRbits_t DCH7SPTRbits __asm__ ("DCH7SPTR") __attribute__((section("sfrs"), address(0xBF811610)));
extern volatile uint32_t        DCH7SPTRCLR __attribute__((section("sfrs"),address(0xBF811614)));
extern volatile uint32_t        DCH7SPTRSET __attribute__((section("sfrs"),address(0xBF811618)));
extern volatile uint32_t        DCH7SPTRINV __attribute__((section("sfrs"),address(0xBF81161C)));
#define DCH7DPTR DCH7DPTR
extern volatile uint32_t   DCH7DPTR __attribute__((section("sfrs"), address(0xBF811620)));
typedef struct {
  uint32_t CHDPTR:16;
} __DCH7DPTRbits_t;
extern volatile __DCH7DPTRbits_t DCH7DPTRbits __asm__ ("DCH7DPTR") __attribute__((section("sfrs"), address(0xBF811620)));
extern volatile uint32_t        DCH7DPTRCLR __attribute__((section("sfrs"),address(0xBF811624)));
extern volatile uint32_t        DCH7DPTRSET __attribute__((section("sfrs"),address(0xBF811628)));
extern volatile uint32_t        DCH7DPTRINV __attribute__((section("sfrs"),address(0xBF81162C)));
#define DCH7CSIZ DCH7CSIZ
extern volatile uint32_t   DCH7CSIZ __attribute__((section("sfrs"), address(0xBF811630)));
typedef struct {
  uint32_t CHCSIZ:16;
} __DCH7CSIZbits_t;
extern volatile __DCH7CSIZbits_t DCH7CSIZbits __asm__ ("DCH7CSIZ") __attribute__((section("sfrs"), address(0xBF811630)));
extern volatile uint32_t        DCH7CSIZCLR __attribute__((section("sfrs"),address(0xBF811634)));
extern volatile uint32_t        DCH7CSIZSET __attribute__((section("sfrs"),address(0xBF811638)));
extern volatile uint32_t        DCH7CSIZINV __attribute__((section("sfrs"),address(0xBF81163C)));
#define DCH7CPTR DCH7CPTR
extern volatile uint32_t   DCH7CPTR __attribute__((section("sfrs"), address(0xBF811640)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCH7CPTRbits_t;
extern volatile __DCH7CPTRbits_t DCH7CPTRbits __asm__ ("DCH7CPTR") __attribute__((section("sfrs"), address(0xBF811640)));
#define DCS7CPTR DCS7CPTR
extern volatile uint32_t   DCS7CPTR __attribute__((section("sfrs"), address(0xBF811640)));
typedef struct {
  uint32_t CHCPTR:16;
} __DCS7CPTRbits_t;
extern volatile __DCS7CPTRbits_t DCS7CPTRbits __asm__ ("DCS7CPTR") __attribute__((section("sfrs"), address(0xBF811640)));
extern volatile uint32_t        DCH7CPTRCLR __attribute__((section("sfrs"),address(0xBF811644)));
extern volatile uint32_t        DCS7CPTRCLR __attribute__((section("sfrs"),address(0xBF811644)));
extern volatile uint32_t        DCH7CPTRSET __attribute__((section("sfrs"),address(0xBF811648)));
extern volatile uint32_t        DCS7CPTRSET __attribute__((section("sfrs"),address(0xBF811648)));
extern volatile uint32_t        DCH7CPTRINV __attribute__((section("sfrs"),address(0xBF81164C)));
extern volatile uint32_t        DCS7CPTRINV __attribute__((section("sfrs"),address(0xBF81164C)));
#define DCH7DAT DCH7DAT
extern volatile uint32_t   DCH7DAT __attribute__((section("sfrs"), address(0xBF811650)));
typedef struct {
  uint32_t CHPDAT:16;
} __DCH7DATbits_t;
extern volatile __DCH7DATbits_t DCH7DATbits __asm__ ("DCH7DAT") __attribute__((section("sfrs"), address(0xBF811650)));
extern volatile uint32_t        DCH7DATCLR __attribute__((section("sfrs"),address(0xBF811654)));
extern volatile uint32_t        DCH7DATSET __attribute__((section("sfrs"),address(0xBF811658)));
extern volatile uint32_t        DCH7DATINV __attribute__((section("sfrs"),address(0xBF81165C)));
#define I2C1CON I2C1CON
extern volatile uint32_t   I2C1CON __attribute__((section("sfrs"), address(0xBF820000)));
typedef union {
  struct {
    uint32_t SEN:1;
    uint32_t RSEN:1;
    uint32_t PEN:1;
    uint32_t RCEN:1;
    uint32_t ACKEN:1;
    uint32_t ACKDT:1;
    uint32_t STREN:1;
    uint32_t GCEN:1;
    uint32_t SMEN:1;
    uint32_t DISSLW:1;
    uint32_t A10M:1;
    uint32_t STRICT:1;
    uint32_t SCLREL:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t DHEN:1;
    uint32_t AHEN:1;
    uint32_t SBCDE:1;
    uint32_t SDAHT:1;
    uint32_t BOEN:1;
    uint32_t SCIE:1;
    uint32_t PCIE:1;
  };
  struct {
    uint32_t :11;
    uint32_t IPMIEN:1;
    uint32_t :1;
    uint32_t I2CSIDL:1;
    uint32_t :1;
    uint32_t I2CEN:1;
  };
} __I2C1CONbits_t;
extern volatile __I2C1CONbits_t I2C1CONbits __asm__ ("I2C1CON") __attribute__((section("sfrs"), address(0xBF820000)));
extern volatile uint32_t        I2C1CONCLR __attribute__((section("sfrs"),address(0xBF820004)));
extern volatile uint32_t        I2C1CONSET __attribute__((section("sfrs"),address(0xBF820008)));
extern volatile uint32_t        I2C1CONINV __attribute__((section("sfrs"),address(0xBF82000C)));
#define I2C1STAT I2C1STAT
extern volatile uint32_t   I2C1STAT __attribute__((section("sfrs"), address(0xBF820010)));
typedef union {
  struct {
    uint32_t TBF:1;
    uint32_t RBF:1;
    uint32_t R_W:1;
    uint32_t S:1;
    uint32_t P:1;
    uint32_t D_A:1;
    uint32_t I2COV:1;
    uint32_t IWCOL:1;
    uint32_t ADD10:1;
    uint32_t GCSTAT:1;
    uint32_t BCL:1;
    uint32_t :2;
    uint32_t ACKTIM:1;
    uint32_t TRSTAT:1;
    uint32_t ACKSTAT:1;
  };
  struct {
    uint32_t :6;
    uint32_t I2CPOV:1;
  };
} __I2C1STATbits_t;
extern volatile __I2C1STATbits_t I2C1STATbits __asm__ ("I2C1STAT") __attribute__((section("sfrs"), address(0xBF820010)));
extern volatile uint32_t        I2C1STATCLR __attribute__((section("sfrs"),address(0xBF820014)));
extern volatile uint32_t        I2C1STATSET __attribute__((section("sfrs"),address(0xBF820018)));
extern volatile uint32_t        I2C1STATINV __attribute__((section("sfrs"),address(0xBF82001C)));
#define I2C1ADD I2C1ADD
extern volatile uint32_t   I2C1ADD __attribute__((section("sfrs"), address(0xBF820020)));
typedef struct {
  uint32_t I2CADD:10;
} __I2C1ADDbits_t;
extern volatile __I2C1ADDbits_t I2C1ADDbits __asm__ ("I2C1ADD") __attribute__((section("sfrs"), address(0xBF820020)));
extern volatile uint32_t        I2C1ADDCLR __attribute__((section("sfrs"),address(0xBF820024)));
extern volatile uint32_t        I2C1ADDSET __attribute__((section("sfrs"),address(0xBF820028)));
extern volatile uint32_t        I2C1ADDINV __attribute__((section("sfrs"),address(0xBF82002C)));
#define I2C1MSK I2C1MSK
extern volatile uint32_t   I2C1MSK __attribute__((section("sfrs"), address(0xBF820030)));
typedef union {
  struct {
    uint32_t I2CMSK:10;
  };
  struct {
    uint32_t AMSK:10;
  };
} __I2C1MSKbits_t;
extern volatile __I2C1MSKbits_t I2C1MSKbits __asm__ ("I2C1MSK") __attribute__((section("sfrs"), address(0xBF820030)));
extern volatile uint32_t        I2C1MSKCLR __attribute__((section("sfrs"),address(0xBF820034)));
extern volatile uint32_t        I2C1MSKSET __attribute__((section("sfrs"),address(0xBF820038)));
extern volatile uint32_t        I2C1MSKINV __attribute__((section("sfrs"),address(0xBF82003C)));
#define I2C1BRG I2C1BRG
extern volatile uint32_t   I2C1BRG __attribute__((section("sfrs"), address(0xBF820040)));
typedef struct {
  uint32_t I2CBRG:16;
} __I2C1BRGbits_t;
extern volatile __I2C1BRGbits_t I2C1BRGbits __asm__ ("I2C1BRG") __attribute__((section("sfrs"), address(0xBF820040)));
extern volatile uint32_t        I2C1BRGCLR __attribute__((section("sfrs"),address(0xBF820044)));
extern volatile uint32_t        I2C1BRGSET __attribute__((section("sfrs"),address(0xBF820048)));
extern volatile uint32_t        I2C1BRGINV __attribute__((section("sfrs"),address(0xBF82004C)));
#define I2C1TRN I2C1TRN
extern volatile uint32_t   I2C1TRN __attribute__((section("sfrs"), address(0xBF820050)));
typedef struct {
  uint32_t I2CTRN:8;
} __I2C1TRNbits_t;
extern volatile __I2C1TRNbits_t I2C1TRNbits __asm__ ("I2C1TRN") __attribute__((section("sfrs"), address(0xBF820050)));
extern volatile uint32_t        I2C1TRNCLR __attribute__((section("sfrs"),address(0xBF820054)));
extern volatile uint32_t        I2C1TRNSET __attribute__((section("sfrs"),address(0xBF820058)));
extern volatile uint32_t        I2C1TRNINV __attribute__((section("sfrs"),address(0xBF82005C)));
#define I2C1RCV I2C1RCV
extern volatile uint32_t   I2C1RCV __attribute__((section("sfrs"), address(0xBF820060)));
typedef struct {
  uint32_t I2CRCV:8;
} __I2C1RCVbits_t;
extern volatile __I2C1RCVbits_t I2C1RCVbits __asm__ ("I2C1RCV") __attribute__((section("sfrs"), address(0xBF820060)));
extern volatile uint32_t        I2C1RCVCLR __attribute__((section("sfrs"),address(0xBF820064)));
extern volatile uint32_t        I2C1RCVSET __attribute__((section("sfrs"),address(0xBF820068)));
extern volatile uint32_t        I2C1RCVINV __attribute__((section("sfrs"),address(0xBF82006C)));
#define I2C3CON I2C3CON
extern volatile uint32_t   I2C3CON __attribute__((section("sfrs"), address(0xBF820400)));
typedef union {
  struct {
    uint32_t SEN:1;
    uint32_t RSEN:1;
    uint32_t PEN:1;
    uint32_t RCEN:1;
    uint32_t ACKEN:1;
    uint32_t ACKDT:1;
    uint32_t STREN:1;
    uint32_t GCEN:1;
    uint32_t SMEN:1;
    uint32_t DISSLW:1;
    uint32_t A10M:1;
    uint32_t STRICT:1;
    uint32_t SCLREL:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t DHEN:1;
    uint32_t AHEN:1;
    uint32_t SBCDE:1;
    uint32_t SDAHT:1;
    uint32_t BOEN:1;
    uint32_t SCIE:1;
    uint32_t PCIE:1;
  };
  struct {
    uint32_t :11;
    uint32_t IPMIEN:1;
    uint32_t :1;
    uint32_t I2CSIDL:1;
    uint32_t :1;
    uint32_t I2CEN:1;
  };
} __I2C3CONbits_t;
extern volatile __I2C3CONbits_t I2C3CONbits __asm__ ("I2C3CON") __attribute__((section("sfrs"), address(0xBF820400)));
extern volatile uint32_t        I2C3CONCLR __attribute__((section("sfrs"),address(0xBF820404)));
extern volatile uint32_t        I2C3CONSET __attribute__((section("sfrs"),address(0xBF820408)));
extern volatile uint32_t        I2C3CONINV __attribute__((section("sfrs"),address(0xBF82040C)));
#define I2C3STAT I2C3STAT
extern volatile uint32_t   I2C3STAT __attribute__((section("sfrs"), address(0xBF820410)));
typedef union {
  struct {
    uint32_t TBF:1;
    uint32_t RBF:1;
    uint32_t R_W:1;
    uint32_t S:1;
    uint32_t P:1;
    uint32_t D_A:1;
    uint32_t I2COV:1;
    uint32_t IWCOL:1;
    uint32_t ADD10:1;
    uint32_t GCSTAT:1;
    uint32_t BCL:1;
    uint32_t :2;
    uint32_t ACKTIM:1;
    uint32_t TRSTAT:1;
    uint32_t ACKSTAT:1;
  };
  struct {
    uint32_t :6;
    uint32_t I2CPOV:1;
  };
} __I2C3STATbits_t;
extern volatile __I2C3STATbits_t I2C3STATbits __asm__ ("I2C3STAT") __attribute__((section("sfrs"), address(0xBF820410)));
extern volatile uint32_t        I2C3STATCLR __attribute__((section("sfrs"),address(0xBF820414)));
extern volatile uint32_t        I2C3STATSET __attribute__((section("sfrs"),address(0xBF820418)));
extern volatile uint32_t        I2C3STATINV __attribute__((section("sfrs"),address(0xBF82041C)));
#define I2C3ADD I2C3ADD
extern volatile uint32_t   I2C3ADD __attribute__((section("sfrs"), address(0xBF820420)));
typedef struct {
  uint32_t I2CADD:10;
} __I2C3ADDbits_t;
extern volatile __I2C3ADDbits_t I2C3ADDbits __asm__ ("I2C3ADD") __attribute__((section("sfrs"), address(0xBF820420)));
extern volatile uint32_t        I2C3ADDCLR __attribute__((section("sfrs"),address(0xBF820424)));
extern volatile uint32_t        I2C3ADDSET __attribute__((section("sfrs"),address(0xBF820428)));
extern volatile uint32_t        I2C3ADDINV __attribute__((section("sfrs"),address(0xBF82042C)));
#define I2C3MSK I2C3MSK
extern volatile uint32_t   I2C3MSK __attribute__((section("sfrs"), address(0xBF820430)));
typedef union {
  struct {
    uint32_t I2CMSK:10;
  };
  struct {
    uint32_t AMSK:10;
  };
} __I2C3MSKbits_t;
extern volatile __I2C3MSKbits_t I2C3MSKbits __asm__ ("I2C3MSK") __attribute__((section("sfrs"), address(0xBF820430)));
extern volatile uint32_t        I2C3MSKCLR __attribute__((section("sfrs"),address(0xBF820434)));
extern volatile uint32_t        I2C3MSKSET __attribute__((section("sfrs"),address(0xBF820438)));
extern volatile uint32_t        I2C3MSKINV __attribute__((section("sfrs"),address(0xBF82043C)));
#define I2C3BRG I2C3BRG
extern volatile uint32_t   I2C3BRG __attribute__((section("sfrs"), address(0xBF820440)));
typedef struct {
  uint32_t I2CBRG:16;
} __I2C3BRGbits_t;
extern volatile __I2C3BRGbits_t I2C3BRGbits __asm__ ("I2C3BRG") __attribute__((section("sfrs"), address(0xBF820440)));
extern volatile uint32_t        I2C3BRGCLR __attribute__((section("sfrs"),address(0xBF820444)));
extern volatile uint32_t        I2C3BRGSET __attribute__((section("sfrs"),address(0xBF820448)));
extern volatile uint32_t        I2C3BRGINV __attribute__((section("sfrs"),address(0xBF82044C)));
#define I2C3TRN I2C3TRN
extern volatile uint32_t   I2C3TRN __attribute__((section("sfrs"), address(0xBF820450)));
typedef struct {
  uint32_t I2CTRN:8;
} __I2C3TRNbits_t;
extern volatile __I2C3TRNbits_t I2C3TRNbits __asm__ ("I2C3TRN") __attribute__((section("sfrs"), address(0xBF820450)));
extern volatile uint32_t        I2C3TRNCLR __attribute__((section("sfrs"),address(0xBF820454)));
extern volatile uint32_t        I2C3TRNSET __attribute__((section("sfrs"),address(0xBF820458)));
extern volatile uint32_t        I2C3TRNINV __attribute__((section("sfrs"),address(0xBF82045C)));
#define I2C3RCV I2C3RCV
extern volatile uint32_t   I2C3RCV __attribute__((section("sfrs"), address(0xBF820460)));
typedef struct {
  uint32_t I2CRCV:8;
} __I2C3RCVbits_t;
extern volatile __I2C3RCVbits_t I2C3RCVbits __asm__ ("I2C3RCV") __attribute__((section("sfrs"), address(0xBF820460)));
extern volatile uint32_t        I2C3RCVCLR __attribute__((section("sfrs"),address(0xBF820464)));
extern volatile uint32_t        I2C3RCVSET __attribute__((section("sfrs"),address(0xBF820468)));
extern volatile uint32_t        I2C3RCVINV __attribute__((section("sfrs"),address(0xBF82046C)));
#define I2C4CON I2C4CON
extern volatile uint32_t   I2C4CON __attribute__((section("sfrs"), address(0xBF820600)));
typedef union {
  struct {
    uint32_t SEN:1;
    uint32_t RSEN:1;
    uint32_t PEN:1;
    uint32_t RCEN:1;
    uint32_t ACKEN:1;
    uint32_t ACKDT:1;
    uint32_t STREN:1;
    uint32_t GCEN:1;
    uint32_t SMEN:1;
    uint32_t DISSLW:1;
    uint32_t A10M:1;
    uint32_t STRICT:1;
    uint32_t SCLREL:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t DHEN:1;
    uint32_t AHEN:1;
    uint32_t SBCDE:1;
    uint32_t SDAHT:1;
    uint32_t BOEN:1;
    uint32_t SCIE:1;
    uint32_t PCIE:1;
  };
  struct {
    uint32_t :11;
    uint32_t IPMIEN:1;
    uint32_t :1;
    uint32_t I2CSIDL:1;
    uint32_t :1;
    uint32_t I2CEN:1;
  };
} __I2C4CONbits_t;
extern volatile __I2C4CONbits_t I2C4CONbits __asm__ ("I2C4CON") __attribute__((section("sfrs"), address(0xBF820600)));
extern volatile uint32_t        I2C4CONCLR __attribute__((section("sfrs"),address(0xBF820604)));
extern volatile uint32_t        I2C4CONSET __attribute__((section("sfrs"),address(0xBF820608)));
extern volatile uint32_t        I2C4CONINV __attribute__((section("sfrs"),address(0xBF82060C)));
#define I2C4STAT I2C4STAT
extern volatile uint32_t   I2C4STAT __attribute__((section("sfrs"), address(0xBF820610)));
typedef union {
  struct {
    uint32_t TBF:1;
    uint32_t RBF:1;
    uint32_t R_W:1;
    uint32_t S:1;
    uint32_t P:1;
    uint32_t D_A:1;
    uint32_t I2COV:1;
    uint32_t IWCOL:1;
    uint32_t ADD10:1;
    uint32_t GCSTAT:1;
    uint32_t BCL:1;
    uint32_t :2;
    uint32_t ACKTIM:1;
    uint32_t TRSTAT:1;
    uint32_t ACKSTAT:1;
  };
  struct {
    uint32_t :6;
    uint32_t I2CPOV:1;
  };
} __I2C4STATbits_t;
extern volatile __I2C4STATbits_t I2C4STATbits __asm__ ("I2C4STAT") __attribute__((section("sfrs"), address(0xBF820610)));
extern volatile uint32_t        I2C4STATCLR __attribute__((section("sfrs"),address(0xBF820614)));
extern volatile uint32_t        I2C4STATSET __attribute__((section("sfrs"),address(0xBF820618)));
extern volatile uint32_t        I2C4STATINV __attribute__((section("sfrs"),address(0xBF82061C)));
#define I2C4ADD I2C4ADD
extern volatile uint32_t   I2C4ADD __attribute__((section("sfrs"), address(0xBF820620)));
typedef struct {
  uint32_t I2CADD:10;
} __I2C4ADDbits_t;
extern volatile __I2C4ADDbits_t I2C4ADDbits __asm__ ("I2C4ADD") __attribute__((section("sfrs"), address(0xBF820620)));
extern volatile uint32_t        I2C4ADDCLR __attribute__((section("sfrs"),address(0xBF820624)));
extern volatile uint32_t        I2C4ADDSET __attribute__((section("sfrs"),address(0xBF820628)));
extern volatile uint32_t        I2C4ADDINV __attribute__((section("sfrs"),address(0xBF82062C)));
#define I2C4MSK I2C4MSK
extern volatile uint32_t   I2C4MSK __attribute__((section("sfrs"), address(0xBF820630)));
typedef union {
  struct {
    uint32_t I2CMSK:10;
  };
  struct {
    uint32_t AMSK:10;
  };
} __I2C4MSKbits_t;
extern volatile __I2C4MSKbits_t I2C4MSKbits __asm__ ("I2C4MSK") __attribute__((section("sfrs"), address(0xBF820630)));
extern volatile uint32_t        I2C4MSKCLR __attribute__((section("sfrs"),address(0xBF820634)));
extern volatile uint32_t        I2C4MSKSET __attribute__((section("sfrs"),address(0xBF820638)));
extern volatile uint32_t        I2C4MSKINV __attribute__((section("sfrs"),address(0xBF82063C)));
#define I2C4BRG I2C4BRG
extern volatile uint32_t   I2C4BRG __attribute__((section("sfrs"), address(0xBF820640)));
typedef struct {
  uint32_t I2CBRG:16;
} __I2C4BRGbits_t;
extern volatile __I2C4BRGbits_t I2C4BRGbits __asm__ ("I2C4BRG") __attribute__((section("sfrs"), address(0xBF820640)));
extern volatile uint32_t        I2C4BRGCLR __attribute__((section("sfrs"),address(0xBF820644)));
extern volatile uint32_t        I2C4BRGSET __attribute__((section("sfrs"),address(0xBF820648)));
extern volatile uint32_t        I2C4BRGINV __attribute__((section("sfrs"),address(0xBF82064C)));
#define I2C4TRN I2C4TRN
extern volatile uint32_t   I2C4TRN __attribute__((section("sfrs"), address(0xBF820650)));
typedef struct {
  uint32_t I2CTRN:8;
} __I2C4TRNbits_t;
extern volatile __I2C4TRNbits_t I2C4TRNbits __asm__ ("I2C4TRN") __attribute__((section("sfrs"), address(0xBF820650)));
extern volatile uint32_t        I2C4TRNCLR __attribute__((section("sfrs"),address(0xBF820654)));
extern volatile uint32_t        I2C4TRNSET __attribute__((section("sfrs"),address(0xBF820658)));
extern volatile uint32_t        I2C4TRNINV __attribute__((section("sfrs"),address(0xBF82065C)));
#define I2C4RCV I2C4RCV
extern volatile uint32_t   I2C4RCV __attribute__((section("sfrs"), address(0xBF820660)));
typedef struct {
  uint32_t I2CRCV:8;
} __I2C4RCVbits_t;
extern volatile __I2C4RCVbits_t I2C4RCVbits __asm__ ("I2C4RCV") __attribute__((section("sfrs"), address(0xBF820660)));
extern volatile uint32_t        I2C4RCVCLR __attribute__((section("sfrs"),address(0xBF820664)));
extern volatile uint32_t        I2C4RCVSET __attribute__((section("sfrs"),address(0xBF820668)));
extern volatile uint32_t        I2C4RCVINV __attribute__((section("sfrs"),address(0xBF82066C)));
#define I2C5CON I2C5CON
extern volatile uint32_t   I2C5CON __attribute__((section("sfrs"), address(0xBF820800)));
typedef union {
  struct {
    uint32_t SEN:1;
    uint32_t RSEN:1;
    uint32_t PEN:1;
    uint32_t RCEN:1;
    uint32_t ACKEN:1;
    uint32_t ACKDT:1;
    uint32_t STREN:1;
    uint32_t GCEN:1;
    uint32_t SMEN:1;
    uint32_t DISSLW:1;
    uint32_t A10M:1;
    uint32_t STRICT:1;
    uint32_t SCLREL:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t DHEN:1;
    uint32_t AHEN:1;
    uint32_t SBCDE:1;
    uint32_t SDAHT:1;
    uint32_t BOEN:1;
    uint32_t SCIE:1;
    uint32_t PCIE:1;
  };
  struct {
    uint32_t :11;
    uint32_t IPMIEN:1;
    uint32_t :1;
    uint32_t I2CSIDL:1;
    uint32_t :1;
    uint32_t I2CEN:1;
  };
} __I2C5CONbits_t;
extern volatile __I2C5CONbits_t I2C5CONbits __asm__ ("I2C5CON") __attribute__((section("sfrs"), address(0xBF820800)));
extern volatile uint32_t        I2C5CONCLR __attribute__((section("sfrs"),address(0xBF820804)));
extern volatile uint32_t        I2C5CONSET __attribute__((section("sfrs"),address(0xBF820808)));
extern volatile uint32_t        I2C5CONINV __attribute__((section("sfrs"),address(0xBF82080C)));
#define I2C5STAT I2C5STAT
extern volatile uint32_t   I2C5STAT __attribute__((section("sfrs"), address(0xBF820810)));
typedef union {
  struct {
    uint32_t TBF:1;
    uint32_t RBF:1;
    uint32_t R_W:1;
    uint32_t S:1;
    uint32_t P:1;
    uint32_t D_A:1;
    uint32_t I2COV:1;
    uint32_t IWCOL:1;
    uint32_t ADD10:1;
    uint32_t GCSTAT:1;
    uint32_t BCL:1;
    uint32_t :2;
    uint32_t ACKTIM:1;
    uint32_t TRSTAT:1;
    uint32_t ACKSTAT:1;
  };
  struct {
    uint32_t :6;
    uint32_t I2CPOV:1;
  };
} __I2C5STATbits_t;
extern volatile __I2C5STATbits_t I2C5STATbits __asm__ ("I2C5STAT") __attribute__((section("sfrs"), address(0xBF820810)));
extern volatile uint32_t        I2C5STATCLR __attribute__((section("sfrs"),address(0xBF820814)));
extern volatile uint32_t        I2C5STATSET __attribute__((section("sfrs"),address(0xBF820818)));
extern volatile uint32_t        I2C5STATINV __attribute__((section("sfrs"),address(0xBF82081C)));
#define I2C5ADD I2C5ADD
extern volatile uint32_t   I2C5ADD __attribute__((section("sfrs"), address(0xBF820820)));
typedef struct {
  uint32_t I2CADD:10;
} __I2C5ADDbits_t;
extern volatile __I2C5ADDbits_t I2C5ADDbits __asm__ ("I2C5ADD") __attribute__((section("sfrs"), address(0xBF820820)));
extern volatile uint32_t        I2C5ADDCLR __attribute__((section("sfrs"),address(0xBF820824)));
extern volatile uint32_t        I2C5ADDSET __attribute__((section("sfrs"),address(0xBF820828)));
extern volatile uint32_t        I2C5ADDINV __attribute__((section("sfrs"),address(0xBF82082C)));
#define I2C5MSK I2C5MSK
extern volatile uint32_t   I2C5MSK __attribute__((section("sfrs"), address(0xBF820830)));
typedef union {
  struct {
    uint32_t I2CMSK:10;
  };
  struct {
    uint32_t AMSK:10;
  };
} __I2C5MSKbits_t;
extern volatile __I2C5MSKbits_t I2C5MSKbits __asm__ ("I2C5MSK") __attribute__((section("sfrs"), address(0xBF820830)));
extern volatile uint32_t        I2C5MSKCLR __attribute__((section("sfrs"),address(0xBF820834)));
extern volatile uint32_t        I2C5MSKSET __attribute__((section("sfrs"),address(0xBF820838)));
extern volatile uint32_t        I2C5MSKINV __attribute__((section("sfrs"),address(0xBF82083C)));
#define I2C5BRG I2C5BRG
extern volatile uint32_t   I2C5BRG __attribute__((section("sfrs"), address(0xBF820840)));
typedef struct {
  uint32_t I2CBRG:16;
} __I2C5BRGbits_t;
extern volatile __I2C5BRGbits_t I2C5BRGbits __asm__ ("I2C5BRG") __attribute__((section("sfrs"), address(0xBF820840)));
extern volatile uint32_t        I2C5BRGCLR __attribute__((section("sfrs"),address(0xBF820844)));
extern volatile uint32_t        I2C5BRGSET __attribute__((section("sfrs"),address(0xBF820848)));
extern volatile uint32_t        I2C5BRGINV __attribute__((section("sfrs"),address(0xBF82084C)));
#define I2C5TRN I2C5TRN
extern volatile uint32_t   I2C5TRN __attribute__((section("sfrs"), address(0xBF820850)));
typedef struct {
  uint32_t I2CTRN:8;
} __I2C5TRNbits_t;
extern volatile __I2C5TRNbits_t I2C5TRNbits __asm__ ("I2C5TRN") __attribute__((section("sfrs"), address(0xBF820850)));
extern volatile uint32_t        I2C5TRNCLR __attribute__((section("sfrs"),address(0xBF820854)));
extern volatile uint32_t        I2C5TRNSET __attribute__((section("sfrs"),address(0xBF820858)));
extern volatile uint32_t        I2C5TRNINV __attribute__((section("sfrs"),address(0xBF82085C)));
#define I2C5RCV I2C5RCV
extern volatile uint32_t   I2C5RCV __attribute__((section("sfrs"), address(0xBF820860)));
typedef struct {
  uint32_t I2CRCV:8;
} __I2C5RCVbits_t;
extern volatile __I2C5RCVbits_t I2C5RCVbits __asm__ ("I2C5RCV") __attribute__((section("sfrs"), address(0xBF820860)));
extern volatile uint32_t        I2C5RCVCLR __attribute__((section("sfrs"),address(0xBF820864)));
extern volatile uint32_t        I2C5RCVSET __attribute__((section("sfrs"),address(0xBF820868)));
extern volatile uint32_t        I2C5RCVINV __attribute__((section("sfrs"),address(0xBF82086C)));
#define SPI1CON SPI1CON
extern volatile uint32_t   SPI1CON __attribute__((section("sfrs"), address(0xBF821000)));
typedef union {
  struct {
    uint32_t SRXISEL:2;
    uint32_t STXISEL:2;
    uint32_t DISSDI:1;
    uint32_t MSTEN:1;
    uint32_t CKP:1;
    uint32_t SSEN:1;
    uint32_t CKE:1;
    uint32_t SMP:1;
    uint32_t MODE16:1;
    uint32_t MODE32:1;
    uint32_t DISSDO:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t ENHBUF:1;
    uint32_t SPIFE:1;
    uint32_t :5;
    uint32_t MCLKSEL:1;
    uint32_t FRMCNT:3;
    uint32_t FRMSYPW:1;
    uint32_t MSSEN:1;
    uint32_t FRMPOL:1;
    uint32_t FRMSYNC:1;
    uint32_t FRMEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI1CONbits_t;
extern volatile __SPI1CONbits_t SPI1CONbits __asm__ ("SPI1CON") __attribute__((section("sfrs"), address(0xBF821000)));
extern volatile uint32_t        SPI1CONCLR __attribute__((section("sfrs"),address(0xBF821004)));
extern volatile uint32_t        SPI1CONSET __attribute__((section("sfrs"),address(0xBF821008)));
extern volatile uint32_t        SPI1CONINV __attribute__((section("sfrs"),address(0xBF82100C)));
#define SPI1STAT SPI1STAT
extern volatile uint32_t   SPI1STAT __attribute__((section("sfrs"), address(0xBF821010)));
typedef union {
  struct {
    uint32_t SPIRBF:1;
    uint32_t SPITBF:1;
    uint32_t :1;
    uint32_t SPITBE:1;
    uint32_t :1;
    uint32_t SPIRBE:1;
    uint32_t SPIROV:1;
    uint32_t SRMT:1;
    uint32_t SPITUR:1;
    uint32_t :2;
    uint32_t SPIBUSY:1;
    uint32_t FRMERR:1;
    uint32_t :3;
    uint32_t TXBUFELM:5;
    uint32_t :3;
    uint32_t RXBUFELM:5;
  };
  struct {
    uint32_t w:32;
  };
} __SPI1STATbits_t;
extern volatile __SPI1STATbits_t SPI1STATbits __asm__ ("SPI1STAT") __attribute__((section("sfrs"), address(0xBF821010)));
extern volatile uint32_t        SPI1STATCLR __attribute__((section("sfrs"),address(0xBF821014)));
extern volatile uint32_t        SPI1STATSET __attribute__((section("sfrs"),address(0xBF821018)));
extern volatile uint32_t        SPI1STATINV __attribute__((section("sfrs"),address(0xBF82101C)));
#define SPI1BUF SPI1BUF
extern volatile uint32_t   SPI1BUF __attribute__((section("sfrs"), address(0xBF821020)));
#define SPI1BRG SPI1BRG
extern volatile uint32_t   SPI1BRG __attribute__((section("sfrs"), address(0xBF821030)));
extern volatile uint32_t        SPI1BRGCLR __attribute__((section("sfrs"),address(0xBF821034)));
extern volatile uint32_t        SPI1BRGSET __attribute__((section("sfrs"),address(0xBF821038)));
extern volatile uint32_t        SPI1BRGINV __attribute__((section("sfrs"),address(0xBF82103C)));
#define SPI1CON2 SPI1CON2
extern volatile uint32_t   SPI1CON2 __attribute__((section("sfrs"), address(0xBF821040)));
typedef union {
  struct {
    uint32_t AUDMOD:2;
    uint32_t :1;
    uint32_t AUDMONO:1;
    uint32_t :3;
    uint32_t AUDEN:1;
    uint32_t IGNTUR:1;
    uint32_t IGNROV:1;
    uint32_t SPITUREN:1;
    uint32_t SPIROVEN:1;
    uint32_t FRMERREN:1;
    uint32_t :2;
    uint32_t SPISGNEXT:1;
  };
  struct {
    uint32_t AUDMOD0:1;
    uint32_t AUDMOD1:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI1CON2bits_t;
extern volatile __SPI1CON2bits_t SPI1CON2bits __asm__ ("SPI1CON2") __attribute__((section("sfrs"), address(0xBF821040)));
extern volatile uint32_t        SPI1CON2CLR __attribute__((section("sfrs"),address(0xBF821044)));
extern volatile uint32_t        SPI1CON2SET __attribute__((section("sfrs"),address(0xBF821048)));
extern volatile uint32_t        SPI1CON2INV __attribute__((section("sfrs"),address(0xBF82104C)));
#define SPI2CON SPI2CON
extern volatile uint32_t   SPI2CON __attribute__((section("sfrs"), address(0xBF821200)));
typedef union {
  struct {
    uint32_t SRXISEL:2;
    uint32_t STXISEL:2;
    uint32_t DISSDI:1;
    uint32_t MSTEN:1;
    uint32_t CKP:1;
    uint32_t SSEN:1;
    uint32_t CKE:1;
    uint32_t SMP:1;
    uint32_t MODE16:1;
    uint32_t MODE32:1;
    uint32_t DISSDO:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t ENHBUF:1;
    uint32_t SPIFE:1;
    uint32_t :5;
    uint32_t MCLKSEL:1;
    uint32_t FRMCNT:3;
    uint32_t FRMSYPW:1;
    uint32_t MSSEN:1;
    uint32_t FRMPOL:1;
    uint32_t FRMSYNC:1;
    uint32_t FRMEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI2CONbits_t;
extern volatile __SPI2CONbits_t SPI2CONbits __asm__ ("SPI2CON") __attribute__((section("sfrs"), address(0xBF821200)));
extern volatile uint32_t        SPI2CONCLR __attribute__((section("sfrs"),address(0xBF821204)));
extern volatile uint32_t        SPI2CONSET __attribute__((section("sfrs"),address(0xBF821208)));
extern volatile uint32_t        SPI2CONINV __attribute__((section("sfrs"),address(0xBF82120C)));
#define SPI2STAT SPI2STAT
extern volatile uint32_t   SPI2STAT __attribute__((section("sfrs"), address(0xBF821210)));
typedef union {
  struct {
    uint32_t SPIRBF:1;
    uint32_t SPITBF:1;
    uint32_t :1;
    uint32_t SPITBE:1;
    uint32_t :1;
    uint32_t SPIRBE:1;
    uint32_t SPIROV:1;
    uint32_t SRMT:1;
    uint32_t SPITUR:1;
    uint32_t :2;
    uint32_t SPIBUSY:1;
    uint32_t FRMERR:1;
    uint32_t :3;
    uint32_t TXBUFELM:5;
    uint32_t :3;
    uint32_t RXBUFELM:5;
  };
  struct {
    uint32_t w:32;
  };
} __SPI2STATbits_t;
extern volatile __SPI2STATbits_t SPI2STATbits __asm__ ("SPI2STAT") __attribute__((section("sfrs"), address(0xBF821210)));
extern volatile uint32_t        SPI2STATCLR __attribute__((section("sfrs"),address(0xBF821214)));
extern volatile uint32_t        SPI2STATSET __attribute__((section("sfrs"),address(0xBF821218)));
extern volatile uint32_t        SPI2STATINV __attribute__((section("sfrs"),address(0xBF82121C)));
#define SPI2BUF SPI2BUF
extern volatile uint32_t   SPI2BUF __attribute__((section("sfrs"), address(0xBF821220)));
#define SPI2BRG SPI2BRG
extern volatile uint32_t   SPI2BRG __attribute__((section("sfrs"), address(0xBF821230)));
extern volatile uint32_t        SPI2BRGCLR __attribute__((section("sfrs"),address(0xBF821234)));
extern volatile uint32_t        SPI2BRGSET __attribute__((section("sfrs"),address(0xBF821238)));
extern volatile uint32_t        SPI2BRGINV __attribute__((section("sfrs"),address(0xBF82123C)));
#define SPI2CON2 SPI2CON2
extern volatile uint32_t   SPI2CON2 __attribute__((section("sfrs"), address(0xBF821240)));
typedef union {
  struct {
    uint32_t AUDMOD:2;
    uint32_t :1;
    uint32_t AUDMONO:1;
    uint32_t :3;
    uint32_t AUDEN:1;
    uint32_t IGNTUR:1;
    uint32_t IGNROV:1;
    uint32_t SPITUREN:1;
    uint32_t SPIROVEN:1;
    uint32_t FRMERREN:1;
    uint32_t :2;
    uint32_t SPISGNEXT:1;
  };
  struct {
    uint32_t AUDMOD0:1;
    uint32_t AUDMOD1:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI2CON2bits_t;
extern volatile __SPI2CON2bits_t SPI2CON2bits __asm__ ("SPI2CON2") __attribute__((section("sfrs"), address(0xBF821240)));
extern volatile uint32_t        SPI2CON2CLR __attribute__((section("sfrs"),address(0xBF821244)));
extern volatile uint32_t        SPI2CON2SET __attribute__((section("sfrs"),address(0xBF821248)));
extern volatile uint32_t        SPI2CON2INV __attribute__((section("sfrs"),address(0xBF82124C)));
#define SPI3CON SPI3CON
extern volatile uint32_t   SPI3CON __attribute__((section("sfrs"), address(0xBF821400)));
typedef union {
  struct {
    uint32_t SRXISEL:2;
    uint32_t STXISEL:2;
    uint32_t DISSDI:1;
    uint32_t MSTEN:1;
    uint32_t CKP:1;
    uint32_t SSEN:1;
    uint32_t CKE:1;
    uint32_t SMP:1;
    uint32_t MODE16:1;
    uint32_t MODE32:1;
    uint32_t DISSDO:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t ENHBUF:1;
    uint32_t SPIFE:1;
    uint32_t :5;
    uint32_t MCLKSEL:1;
    uint32_t FRMCNT:3;
    uint32_t FRMSYPW:1;
    uint32_t MSSEN:1;
    uint32_t FRMPOL:1;
    uint32_t FRMSYNC:1;
    uint32_t FRMEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI3CONbits_t;
extern volatile __SPI3CONbits_t SPI3CONbits __asm__ ("SPI3CON") __attribute__((section("sfrs"), address(0xBF821400)));
extern volatile uint32_t        SPI3CONCLR __attribute__((section("sfrs"),address(0xBF821404)));
extern volatile uint32_t        SPI3CONSET __attribute__((section("sfrs"),address(0xBF821408)));
extern volatile uint32_t        SPI3CONINV __attribute__((section("sfrs"),address(0xBF82140C)));
#define SPI3STAT SPI3STAT
extern volatile uint32_t   SPI3STAT __attribute__((section("sfrs"), address(0xBF821410)));
typedef union {
  struct {
    uint32_t SPIRBF:1;
    uint32_t SPITBF:1;
    uint32_t :1;
    uint32_t SPITBE:1;
    uint32_t :1;
    uint32_t SPIRBE:1;
    uint32_t SPIROV:1;
    uint32_t SRMT:1;
    uint32_t SPITUR:1;
    uint32_t :2;
    uint32_t SPIBUSY:1;
    uint32_t FRMERR:1;
    uint32_t :3;
    uint32_t TXBUFELM:5;
    uint32_t :3;
    uint32_t RXBUFELM:5;
  };
  struct {
    uint32_t w:32;
  };
} __SPI3STATbits_t;
extern volatile __SPI3STATbits_t SPI3STATbits __asm__ ("SPI3STAT") __attribute__((section("sfrs"), address(0xBF821410)));
extern volatile uint32_t        SPI3STATCLR __attribute__((section("sfrs"),address(0xBF821414)));
extern volatile uint32_t        SPI3STATSET __attribute__((section("sfrs"),address(0xBF821418)));
extern volatile uint32_t        SPI3STATINV __attribute__((section("sfrs"),address(0xBF82141C)));
#define SPI3BUF SPI3BUF
extern volatile uint32_t   SPI3BUF __attribute__((section("sfrs"), address(0xBF821420)));
#define SPI3BRG SPI3BRG
extern volatile uint32_t   SPI3BRG __attribute__((section("sfrs"), address(0xBF821430)));
extern volatile uint32_t        SPI3BRGCLR __attribute__((section("sfrs"),address(0xBF821434)));
extern volatile uint32_t        SPI3BRGSET __attribute__((section("sfrs"),address(0xBF821438)));
extern volatile uint32_t        SPI3BRGINV __attribute__((section("sfrs"),address(0xBF82143C)));
#define SPI3CON2 SPI3CON2
extern volatile uint32_t   SPI3CON2 __attribute__((section("sfrs"), address(0xBF821440)));
typedef union {
  struct {
    uint32_t AUDMOD:2;
    uint32_t :1;
    uint32_t AUDMONO:1;
    uint32_t :3;
    uint32_t AUDEN:1;
    uint32_t IGNTUR:1;
    uint32_t IGNROV:1;
    uint32_t SPITUREN:1;
    uint32_t SPIROVEN:1;
    uint32_t FRMERREN:1;
    uint32_t :2;
    uint32_t SPISGNEXT:1;
  };
  struct {
    uint32_t AUDMOD0:1;
    uint32_t AUDMOD1:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI3CON2bits_t;
extern volatile __SPI3CON2bits_t SPI3CON2bits __asm__ ("SPI3CON2") __attribute__((section("sfrs"), address(0xBF821440)));
extern volatile uint32_t        SPI3CON2CLR __attribute__((section("sfrs"),address(0xBF821444)));
extern volatile uint32_t        SPI3CON2SET __attribute__((section("sfrs"),address(0xBF821448)));
extern volatile uint32_t        SPI3CON2INV __attribute__((section("sfrs"),address(0xBF82144C)));
#define SPI4CON SPI4CON
extern volatile uint32_t   SPI4CON __attribute__((section("sfrs"), address(0xBF821600)));
typedef union {
  struct {
    uint32_t SRXISEL:2;
    uint32_t STXISEL:2;
    uint32_t DISSDI:1;
    uint32_t MSTEN:1;
    uint32_t CKP:1;
    uint32_t SSEN:1;
    uint32_t CKE:1;
    uint32_t SMP:1;
    uint32_t MODE16:1;
    uint32_t MODE32:1;
    uint32_t DISSDO:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t ENHBUF:1;
    uint32_t SPIFE:1;
    uint32_t :5;
    uint32_t MCLKSEL:1;
    uint32_t FRMCNT:3;
    uint32_t FRMSYPW:1;
    uint32_t MSSEN:1;
    uint32_t FRMPOL:1;
    uint32_t FRMSYNC:1;
    uint32_t FRMEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI4CONbits_t;
extern volatile __SPI4CONbits_t SPI4CONbits __asm__ ("SPI4CON") __attribute__((section("sfrs"), address(0xBF821600)));
extern volatile uint32_t        SPI4CONCLR __attribute__((section("sfrs"),address(0xBF821604)));
extern volatile uint32_t        SPI4CONSET __attribute__((section("sfrs"),address(0xBF821608)));
extern volatile uint32_t        SPI4CONINV __attribute__((section("sfrs"),address(0xBF82160C)));
#define SPI4STAT SPI4STAT
extern volatile uint32_t   SPI4STAT __attribute__((section("sfrs"), address(0xBF821610)));
typedef union {
  struct {
    uint32_t SPIRBF:1;
    uint32_t SPITBF:1;
    uint32_t :1;
    uint32_t SPITBE:1;
    uint32_t :1;
    uint32_t SPIRBE:1;
    uint32_t SPIROV:1;
    uint32_t SRMT:1;
    uint32_t SPITUR:1;
    uint32_t :2;
    uint32_t SPIBUSY:1;
    uint32_t FRMERR:1;
    uint32_t :3;
    uint32_t TXBUFELM:5;
    uint32_t :3;
    uint32_t RXBUFELM:5;
  };
  struct {
    uint32_t w:32;
  };
} __SPI4STATbits_t;
extern volatile __SPI4STATbits_t SPI4STATbits __asm__ ("SPI4STAT") __attribute__((section("sfrs"), address(0xBF821610)));
extern volatile uint32_t        SPI4STATCLR __attribute__((section("sfrs"),address(0xBF821614)));
extern volatile uint32_t        SPI4STATSET __attribute__((section("sfrs"),address(0xBF821618)));
extern volatile uint32_t        SPI4STATINV __attribute__((section("sfrs"),address(0xBF82161C)));
#define SPI4BUF SPI4BUF
extern volatile uint32_t   SPI4BUF __attribute__((section("sfrs"), address(0xBF821620)));
#define SPI4BRG SPI4BRG
extern volatile uint32_t   SPI4BRG __attribute__((section("sfrs"), address(0xBF821630)));
extern volatile uint32_t        SPI4BRGCLR __attribute__((section("sfrs"),address(0xBF821634)));
extern volatile uint32_t        SPI4BRGSET __attribute__((section("sfrs"),address(0xBF821638)));
extern volatile uint32_t        SPI4BRGINV __attribute__((section("sfrs"),address(0xBF82163C)));
#define SPI4CON2 SPI4CON2
extern volatile uint32_t   SPI4CON2 __attribute__((section("sfrs"), address(0xBF821640)));
typedef union {
  struct {
    uint32_t AUDMOD:2;
    uint32_t :1;
    uint32_t AUDMONO:1;
    uint32_t :3;
    uint32_t AUDEN:1;
    uint32_t IGNTUR:1;
    uint32_t IGNROV:1;
    uint32_t SPITUREN:1;
    uint32_t SPIROVEN:1;
    uint32_t FRMERREN:1;
    uint32_t :2;
    uint32_t SPISGNEXT:1;
  };
  struct {
    uint32_t AUDMOD0:1;
    uint32_t AUDMOD1:1;
  };
  struct {
    uint32_t w:32;
  };
} __SPI4CON2bits_t;
extern volatile __SPI4CON2bits_t SPI4CON2bits __asm__ ("SPI4CON2") __attribute__((section("sfrs"), address(0xBF821640)));
extern volatile uint32_t        SPI4CON2CLR __attribute__((section("sfrs"),address(0xBF821644)));
extern volatile uint32_t        SPI4CON2SET __attribute__((section("sfrs"),address(0xBF821648)));
extern volatile uint32_t        SPI4CON2INV __attribute__((section("sfrs"),address(0xBF82164C)));
#define U1MODE U1MODE
extern volatile uint32_t   U1MODE __attribute__((section("sfrs"), address(0xBF822000)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __U1MODEbits_t;
extern volatile __U1MODEbits_t U1MODEbits __asm__ ("U1MODE") __attribute__((section("sfrs"), address(0xBF822000)));
#define UABMODE UABMODE
extern volatile uint32_t   UABMODE __attribute__((section("sfrs"), address(0xBF822000)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __UABMODEbits_t;
extern volatile __UABMODEbits_t UABMODEbits __asm__ ("UABMODE") __attribute__((section("sfrs"), address(0xBF822000)));
extern volatile uint32_t        U1MODECLR __attribute__((section("sfrs"),address(0xBF822004)));
extern volatile uint32_t        UABMODECLR __attribute__((section("sfrs"),address(0xBF822004)));
extern volatile uint32_t        U1MODESET __attribute__((section("sfrs"),address(0xBF822008)));
extern volatile uint32_t        UABMODESET __attribute__((section("sfrs"),address(0xBF822008)));
extern volatile uint32_t        U1MODEINV __attribute__((section("sfrs"),address(0xBF82200C)));
extern volatile uint32_t        UABMODEINV __attribute__((section("sfrs"),address(0xBF82200C)));
#define U1STA U1STA
extern volatile uint32_t   U1STA __attribute__((section("sfrs"), address(0xBF822010)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __U1STAbits_t;
extern volatile __U1STAbits_t U1STAbits __asm__ ("U1STA") __attribute__((section("sfrs"), address(0xBF822010)));
#define UABSTA UABSTA
extern volatile uint32_t   UABSTA __attribute__((section("sfrs"), address(0xBF822010)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __UABSTAbits_t;
extern volatile __UABSTAbits_t UABSTAbits __asm__ ("UABSTA") __attribute__((section("sfrs"), address(0xBF822010)));
extern volatile uint32_t        U1STACLR __attribute__((section("sfrs"),address(0xBF822014)));
extern volatile uint32_t        UABSTACLR __attribute__((section("sfrs"),address(0xBF822014)));
extern volatile uint32_t        U1STASET __attribute__((section("sfrs"),address(0xBF822018)));
extern volatile uint32_t        UABSTASET __attribute__((section("sfrs"),address(0xBF822018)));
extern volatile uint32_t        U1STAINV __attribute__((section("sfrs"),address(0xBF82201C)));
extern volatile uint32_t        UABSTAINV __attribute__((section("sfrs"),address(0xBF82201C)));
#define U1TXREG U1TXREG
extern volatile uint32_t   U1TXREG __attribute__((section("sfrs"), address(0xBF822020)));
#define UABTXREG UABTXREG
extern volatile uint32_t   UABTXREG __attribute__((section("sfrs"), address(0xBF822020)));
#define U1RXREG U1RXREG
extern volatile uint32_t   U1RXREG __attribute__((section("sfrs"), address(0xBF822030)));
#define UABRXREG UABRXREG
extern volatile uint32_t   UABRXREG __attribute__((section("sfrs"), address(0xBF822030)));
#define U1BRG U1BRG
extern volatile uint32_t   U1BRG __attribute__((section("sfrs"), address(0xBF822040)));
#define UABBRG UABBRG
extern volatile uint32_t   UABBRG __attribute__((section("sfrs"), address(0xBF822040)));
extern volatile uint32_t        U1BRGCLR __attribute__((section("sfrs"),address(0xBF822044)));
extern volatile uint32_t        UABBRGCLR __attribute__((section("sfrs"),address(0xBF822044)));
extern volatile uint32_t        U1BRGSET __attribute__((section("sfrs"),address(0xBF822048)));
extern volatile uint32_t        UABBRGSET __attribute__((section("sfrs"),address(0xBF822048)));
extern volatile uint32_t        U1BRGINV __attribute__((section("sfrs"),address(0xBF82204C)));
extern volatile uint32_t        UABBRGINV __attribute__((section("sfrs"),address(0xBF82204C)));
#define U2MODE U2MODE
extern volatile uint32_t   U2MODE __attribute__((section("sfrs"), address(0xBF822200)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __U2MODEbits_t;
extern volatile __U2MODEbits_t U2MODEbits __asm__ ("U2MODE") __attribute__((section("sfrs"), address(0xBF822200)));
#define UCDMODE UCDMODE
extern volatile uint32_t   UCDMODE __attribute__((section("sfrs"), address(0xBF822200)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __UCDMODEbits_t;
extern volatile __UCDMODEbits_t UCDMODEbits __asm__ ("UCDMODE") __attribute__((section("sfrs"), address(0xBF822200)));
extern volatile uint32_t        U2MODECLR __attribute__((section("sfrs"),address(0xBF822204)));
extern volatile uint32_t        UCDMODECLR __attribute__((section("sfrs"),address(0xBF822204)));
extern volatile uint32_t        U2MODESET __attribute__((section("sfrs"),address(0xBF822208)));
extern volatile uint32_t        UCDMODESET __attribute__((section("sfrs"),address(0xBF822208)));
extern volatile uint32_t        U2MODEINV __attribute__((section("sfrs"),address(0xBF82220C)));
extern volatile uint32_t        UCDMODEINV __attribute__((section("sfrs"),address(0xBF82220C)));
#define U2STA U2STA
extern volatile uint32_t   U2STA __attribute__((section("sfrs"), address(0xBF822210)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __U2STAbits_t;
extern volatile __U2STAbits_t U2STAbits __asm__ ("U2STA") __attribute__((section("sfrs"), address(0xBF822210)));
#define UCDSTA UCDSTA
extern volatile uint32_t   UCDSTA __attribute__((section("sfrs"), address(0xBF822210)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __UCDSTAbits_t;
extern volatile __UCDSTAbits_t UCDSTAbits __asm__ ("UCDSTA") __attribute__((section("sfrs"), address(0xBF822210)));
extern volatile uint32_t        U2STACLR __attribute__((section("sfrs"),address(0xBF822214)));
extern volatile uint32_t        UCDSTACLR __attribute__((section("sfrs"),address(0xBF822214)));
extern volatile uint32_t        U2STASET __attribute__((section("sfrs"),address(0xBF822218)));
extern volatile uint32_t        UCDSTASET __attribute__((section("sfrs"),address(0xBF822218)));
extern volatile uint32_t        U2STAINV __attribute__((section("sfrs"),address(0xBF82221C)));
extern volatile uint32_t        UCDSTAINV __attribute__((section("sfrs"),address(0xBF82221C)));
#define U2TXREG U2TXREG
extern volatile uint32_t   U2TXREG __attribute__((section("sfrs"), address(0xBF822220)));
#define UCDTXREG UCDTXREG
extern volatile uint32_t   UCDTXREG __attribute__((section("sfrs"), address(0xBF822220)));
#define U2RXREG U2RXREG
extern volatile uint32_t   U2RXREG __attribute__((section("sfrs"), address(0xBF822230)));
#define UCDRXREG UCDRXREG
extern volatile uint32_t   UCDRXREG __attribute__((section("sfrs"), address(0xBF822230)));
#define U2BRG U2BRG
extern volatile uint32_t   U2BRG __attribute__((section("sfrs"), address(0xBF822240)));
#define UCDBRG UCDBRG
extern volatile uint32_t   UCDBRG __attribute__((section("sfrs"), address(0xBF822240)));
extern volatile uint32_t        U2BRGCLR __attribute__((section("sfrs"),address(0xBF822244)));
extern volatile uint32_t        UCDBRGCLR __attribute__((section("sfrs"),address(0xBF822244)));
extern volatile uint32_t        U2BRGSET __attribute__((section("sfrs"),address(0xBF822248)));
extern volatile uint32_t        UCDBRGSET __attribute__((section("sfrs"),address(0xBF822248)));
extern volatile uint32_t        U2BRGINV __attribute__((section("sfrs"),address(0xBF82224C)));
extern volatile uint32_t        UCDBRGINV __attribute__((section("sfrs"),address(0xBF82224C)));
#define U3MODE U3MODE
extern volatile uint32_t   U3MODE __attribute__((section("sfrs"), address(0xBF822400)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __U3MODEbits_t;
extern volatile __U3MODEbits_t U3MODEbits __asm__ ("U3MODE") __attribute__((section("sfrs"), address(0xBF822400)));
#define UEFMODE UEFMODE
extern volatile uint32_t   UEFMODE __attribute__((section("sfrs"), address(0xBF822400)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __UEFMODEbits_t;
extern volatile __UEFMODEbits_t UEFMODEbits __asm__ ("UEFMODE") __attribute__((section("sfrs"), address(0xBF822400)));
extern volatile uint32_t        U3MODECLR __attribute__((section("sfrs"),address(0xBF822404)));
extern volatile uint32_t        UEFMODECLR __attribute__((section("sfrs"),address(0xBF822404)));
extern volatile uint32_t        U3MODESET __attribute__((section("sfrs"),address(0xBF822408)));
extern volatile uint32_t        UEFMODESET __attribute__((section("sfrs"),address(0xBF822408)));
extern volatile uint32_t        U3MODEINV __attribute__((section("sfrs"),address(0xBF82240C)));
extern volatile uint32_t        UEFMODEINV __attribute__((section("sfrs"),address(0xBF82240C)));
#define U3STA U3STA
extern volatile uint32_t   U3STA __attribute__((section("sfrs"), address(0xBF822410)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __U3STAbits_t;
extern volatile __U3STAbits_t U3STAbits __asm__ ("U3STA") __attribute__((section("sfrs"), address(0xBF822410)));
#define UEFSTA UEFSTA
extern volatile uint32_t   UEFSTA __attribute__((section("sfrs"), address(0xBF822410)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __UEFSTAbits_t;
extern volatile __UEFSTAbits_t UEFSTAbits __asm__ ("UEFSTA") __attribute__((section("sfrs"), address(0xBF822410)));
extern volatile uint32_t        U3STACLR __attribute__((section("sfrs"),address(0xBF822414)));
extern volatile uint32_t        UEFSTACLR __attribute__((section("sfrs"),address(0xBF822414)));
extern volatile uint32_t        U3STASET __attribute__((section("sfrs"),address(0xBF822418)));
extern volatile uint32_t        UEFSTASET __attribute__((section("sfrs"),address(0xBF822418)));
extern volatile uint32_t        U3STAINV __attribute__((section("sfrs"),address(0xBF82241C)));
extern volatile uint32_t        UEFSTAINV __attribute__((section("sfrs"),address(0xBF82241C)));
#define U3TXREG U3TXREG
extern volatile uint32_t   U3TXREG __attribute__((section("sfrs"), address(0xBF822420)));
#define UEFTXREG UEFTXREG
extern volatile uint32_t   UEFTXREG __attribute__((section("sfrs"), address(0xBF822420)));
#define U3RXREG U3RXREG
extern volatile uint32_t   U3RXREG __attribute__((section("sfrs"), address(0xBF822430)));
#define UEFRXREG UEFRXREG
extern volatile uint32_t   UEFRXREG __attribute__((section("sfrs"), address(0xBF822430)));
#define U3BRG U3BRG
extern volatile uint32_t   U3BRG __attribute__((section("sfrs"), address(0xBF822440)));
#define UEFBRG UEFBRG
extern volatile uint32_t   UEFBRG __attribute__((section("sfrs"), address(0xBF822440)));
extern volatile uint32_t        U3BRGCLR __attribute__((section("sfrs"),address(0xBF822444)));
extern volatile uint32_t        UEFBRGCLR __attribute__((section("sfrs"),address(0xBF822444)));
extern volatile uint32_t        U3BRGSET __attribute__((section("sfrs"),address(0xBF822448)));
extern volatile uint32_t        UEFBRGSET __attribute__((section("sfrs"),address(0xBF822448)));
extern volatile uint32_t        U3BRGINV __attribute__((section("sfrs"),address(0xBF82244C)));
extern volatile uint32_t        UEFBRGINV __attribute__((section("sfrs"),address(0xBF82244C)));
#define U4MODE U4MODE
extern volatile uint32_t   U4MODE __attribute__((section("sfrs"), address(0xBF822600)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __U4MODEbits_t;
extern volatile __U4MODEbits_t U4MODEbits __asm__ ("U4MODE") __attribute__((section("sfrs"), address(0xBF822600)));
#define UGHMODE UGHMODE
extern volatile uint32_t   UGHMODE __attribute__((section("sfrs"), address(0xBF822600)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __UGHMODEbits_t;
extern volatile __UGHMODEbits_t UGHMODEbits __asm__ ("UGHMODE") __attribute__((section("sfrs"), address(0xBF822600)));
extern volatile uint32_t        U4MODECLR __attribute__((section("sfrs"),address(0xBF822604)));
extern volatile uint32_t        UGHMODECLR __attribute__((section("sfrs"),address(0xBF822604)));
extern volatile uint32_t        U4MODESET __attribute__((section("sfrs"),address(0xBF822608)));
extern volatile uint32_t        UGHMODESET __attribute__((section("sfrs"),address(0xBF822608)));
extern volatile uint32_t        U4MODEINV __attribute__((section("sfrs"),address(0xBF82260C)));
extern volatile uint32_t        UGHMODEINV __attribute__((section("sfrs"),address(0xBF82260C)));
#define U4STA U4STA
extern volatile uint32_t   U4STA __attribute__((section("sfrs"), address(0xBF822610)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __U4STAbits_t;
extern volatile __U4STAbits_t U4STAbits __asm__ ("U4STA") __attribute__((section("sfrs"), address(0xBF822610)));
#define UGHSTA UGHSTA
extern volatile uint32_t   UGHSTA __attribute__((section("sfrs"), address(0xBF822610)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __UGHSTAbits_t;
extern volatile __UGHSTAbits_t UGHSTAbits __asm__ ("UGHSTA") __attribute__((section("sfrs"), address(0xBF822610)));
extern volatile uint32_t        U4STACLR __attribute__((section("sfrs"),address(0xBF822614)));
extern volatile uint32_t        UGHSTACLR __attribute__((section("sfrs"),address(0xBF822614)));
extern volatile uint32_t        U4STASET __attribute__((section("sfrs"),address(0xBF822618)));
extern volatile uint32_t        UGHSTASET __attribute__((section("sfrs"),address(0xBF822618)));
extern volatile uint32_t        U4STAINV __attribute__((section("sfrs"),address(0xBF82261C)));
extern volatile uint32_t        UGHSTAINV __attribute__((section("sfrs"),address(0xBF82261C)));
#define U4TXREG U4TXREG
extern volatile uint32_t   U4TXREG __attribute__((section("sfrs"), address(0xBF822620)));
#define UGHTXREG UGHTXREG
extern volatile uint32_t   UGHTXREG __attribute__((section("sfrs"), address(0xBF822620)));
#define U4RXREG U4RXREG
extern volatile uint32_t   U4RXREG __attribute__((section("sfrs"), address(0xBF822630)));
#define UGHRXREG UGHRXREG
extern volatile uint32_t   UGHRXREG __attribute__((section("sfrs"), address(0xBF822630)));
#define U4BRG U4BRG
extern volatile uint32_t   U4BRG __attribute__((section("sfrs"), address(0xBF822640)));
#define UGHBRG UGHBRG
extern volatile uint32_t   UGHBRG __attribute__((section("sfrs"), address(0xBF822640)));
extern volatile uint32_t        U4BRGCLR __attribute__((section("sfrs"),address(0xBF822644)));
extern volatile uint32_t        UGHBRGCLR __attribute__((section("sfrs"),address(0xBF822644)));
extern volatile uint32_t        U4BRGSET __attribute__((section("sfrs"),address(0xBF822648)));
extern volatile uint32_t        UGHBRGSET __attribute__((section("sfrs"),address(0xBF822648)));
extern volatile uint32_t        U4BRGINV __attribute__((section("sfrs"),address(0xBF82264C)));
extern volatile uint32_t        UGHBRGINV __attribute__((section("sfrs"),address(0xBF82264C)));
#define U5MODE U5MODE
extern volatile uint32_t   U5MODE __attribute__((section("sfrs"), address(0xBF822800)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __U5MODEbits_t;
extern volatile __U5MODEbits_t U5MODEbits __asm__ ("U5MODE") __attribute__((section("sfrs"), address(0xBF822800)));
#define UJKMODE UJKMODE
extern volatile uint32_t   UJKMODE __attribute__((section("sfrs"), address(0xBF822800)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __UJKMODEbits_t;
extern volatile __UJKMODEbits_t UJKMODEbits __asm__ ("UJKMODE") __attribute__((section("sfrs"), address(0xBF822800)));
extern volatile uint32_t        U5MODECLR __attribute__((section("sfrs"),address(0xBF822804)));
extern volatile uint32_t        UJKMODECLR __attribute__((section("sfrs"),address(0xBF822804)));
extern volatile uint32_t        U5MODESET __attribute__((section("sfrs"),address(0xBF822808)));
extern volatile uint32_t        UJKMODESET __attribute__((section("sfrs"),address(0xBF822808)));
extern volatile uint32_t        U5MODEINV __attribute__((section("sfrs"),address(0xBF82280C)));
extern volatile uint32_t        UJKMODEINV __attribute__((section("sfrs"),address(0xBF82280C)));
#define U5STA U5STA
extern volatile uint32_t   U5STA __attribute__((section("sfrs"), address(0xBF822810)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __U5STAbits_t;
extern volatile __U5STAbits_t U5STAbits __asm__ ("U5STA") __attribute__((section("sfrs"), address(0xBF822810)));
#define UJKSTA UJKSTA
extern volatile uint32_t   UJKSTA __attribute__((section("sfrs"), address(0xBF822810)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __UJKSTAbits_t;
extern volatile __UJKSTAbits_t UJKSTAbits __asm__ ("UJKSTA") __attribute__((section("sfrs"), address(0xBF822810)));
extern volatile uint32_t        U5STACLR __attribute__((section("sfrs"),address(0xBF822814)));
extern volatile uint32_t        UJKSTACLR __attribute__((section("sfrs"),address(0xBF822814)));
extern volatile uint32_t        U5STASET __attribute__((section("sfrs"),address(0xBF822818)));
extern volatile uint32_t        UJKSTASET __attribute__((section("sfrs"),address(0xBF822818)));
extern volatile uint32_t        U5STAINV __attribute__((section("sfrs"),address(0xBF82281C)));
extern volatile uint32_t        UJKSTAINV __attribute__((section("sfrs"),address(0xBF82281C)));
#define U5TXREG U5TXREG
extern volatile uint32_t   U5TXREG __attribute__((section("sfrs"), address(0xBF822820)));
#define UJKTXREG UJKTXREG
extern volatile uint32_t   UJKTXREG __attribute__((section("sfrs"), address(0xBF822820)));
#define U5RXREG U5RXREG
extern volatile uint32_t   U5RXREG __attribute__((section("sfrs"), address(0xBF822830)));
#define UJKRXREG UJKRXREG
extern volatile uint32_t   UJKRXREG __attribute__((section("sfrs"), address(0xBF822830)));
#define U5BRG U5BRG
extern volatile uint32_t   U5BRG __attribute__((section("sfrs"), address(0xBF822840)));
#define UJKBRG UJKBRG
extern volatile uint32_t   UJKBRG __attribute__((section("sfrs"), address(0xBF822840)));
extern volatile uint32_t        U5BRGCLR __attribute__((section("sfrs"),address(0xBF822844)));
extern volatile uint32_t        UJKBRGCLR __attribute__((section("sfrs"),address(0xBF822844)));
extern volatile uint32_t        U5BRGSET __attribute__((section("sfrs"),address(0xBF822848)));
extern volatile uint32_t        UJKBRGSET __attribute__((section("sfrs"),address(0xBF822848)));
extern volatile uint32_t        U5BRGINV __attribute__((section("sfrs"),address(0xBF82284C)));
extern volatile uint32_t        UJKBRGINV __attribute__((section("sfrs"),address(0xBF82284C)));
#define U6MODE U6MODE
extern volatile uint32_t   U6MODE __attribute__((section("sfrs"), address(0xBF822A00)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __U6MODEbits_t;
extern volatile __U6MODEbits_t U6MODEbits __asm__ ("U6MODE") __attribute__((section("sfrs"), address(0xBF822A00)));
#define ULMMODE ULMMODE
extern volatile uint32_t   ULMMODE __attribute__((section("sfrs"), address(0xBF822A00)));
typedef union {
  struct {
    uint32_t STSEL:1;
    uint32_t PDSEL:2;
    uint32_t BRGH:1;
    uint32_t RXINV:1;
    uint32_t ABAUD:1;
    uint32_t LPBACK:1;
    uint32_t WAKE:1;
    uint32_t UEN:2;
    uint32_t :1;
    uint32_t RTSMD:1;
    uint32_t IREN:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :1;
    uint32_t PDSEL0:1;
    uint32_t PDSEL1:1;
    uint32_t :5;
    uint32_t UEN0:1;
    uint32_t UEN1:1;
  };
  struct {
    uint32_t :13;
    uint32_t USIDL:1;
    uint32_t :1;
    uint32_t UARTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __ULMMODEbits_t;
extern volatile __ULMMODEbits_t ULMMODEbits __asm__ ("ULMMODE") __attribute__((section("sfrs"), address(0xBF822A00)));
extern volatile uint32_t        U6MODECLR __attribute__((section("sfrs"),address(0xBF822A04)));
extern volatile uint32_t        ULMMODECLR __attribute__((section("sfrs"),address(0xBF822A04)));
extern volatile uint32_t        U6MODESET __attribute__((section("sfrs"),address(0xBF822A08)));
extern volatile uint32_t        ULMMODESET __attribute__((section("sfrs"),address(0xBF822A08)));
extern volatile uint32_t        U6MODEINV __attribute__((section("sfrs"),address(0xBF822A0C)));
extern volatile uint32_t        ULMMODEINV __attribute__((section("sfrs"),address(0xBF822A0C)));
#define U6STA U6STA
extern volatile uint32_t   U6STA __attribute__((section("sfrs"), address(0xBF822A10)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __U6STAbits_t;
extern volatile __U6STAbits_t U6STAbits __asm__ ("U6STA") __attribute__((section("sfrs"), address(0xBF822A10)));
#define ULMSTA ULMSTA
extern volatile uint32_t   ULMSTA __attribute__((section("sfrs"), address(0xBF822A10)));
typedef union {
  struct {
    uint32_t URXDA:1;
    uint32_t OERR:1;
    uint32_t FERR:1;
    uint32_t PERR:1;
    uint32_t RIDLE:1;
    uint32_t ADDEN:1;
    uint32_t URXISEL:2;
    uint32_t TRMT:1;
    uint32_t UTXBF:1;
    uint32_t UTXEN:1;
    uint32_t UTXBRK:1;
    uint32_t URXEN:1;
    uint32_t UTXINV:1;
    uint32_t UTXISEL:2;
    uint32_t ADDR:8;
    uint32_t ADM_EN:1;
  };
  struct {
    uint32_t :6;
    uint32_t URXISEL0:1;
    uint32_t URXISEL1:1;
    uint32_t :6;
    uint32_t UTXISEL0:1;
    uint32_t UTXISEL1:1;
  };
  struct {
    uint32_t :14;
    uint32_t UTXSEL:2;
  };
  struct {
    uint32_t w:32;
  };
} __ULMSTAbits_t;
extern volatile __ULMSTAbits_t ULMSTAbits __asm__ ("ULMSTA") __attribute__((section("sfrs"), address(0xBF822A10)));
extern volatile uint32_t        U6STACLR __attribute__((section("sfrs"),address(0xBF822A14)));
extern volatile uint32_t        ULMSTACLR __attribute__((section("sfrs"),address(0xBF822A14)));
extern volatile uint32_t        U6STASET __attribute__((section("sfrs"),address(0xBF822A18)));
extern volatile uint32_t        ULMSTASET __attribute__((section("sfrs"),address(0xBF822A18)));
extern volatile uint32_t        U6STAINV __attribute__((section("sfrs"),address(0xBF822A1C)));
extern volatile uint32_t        ULMSTAINV __attribute__((section("sfrs"),address(0xBF822A1C)));
#define U6TXREG U6TXREG
extern volatile uint32_t   U6TXREG __attribute__((section("sfrs"), address(0xBF822A20)));
#define ULMTXREG ULMTXREG
extern volatile uint32_t   ULMTXREG __attribute__((section("sfrs"), address(0xBF822A20)));
#define U6RXREG U6RXREG
extern volatile uint32_t   U6RXREG __attribute__((section("sfrs"), address(0xBF822A30)));
#define ULMRXREG ULMRXREG
extern volatile uint32_t   ULMRXREG __attribute__((section("sfrs"), address(0xBF822A30)));
#define U6BRG U6BRG
extern volatile uint32_t   U6BRG __attribute__((section("sfrs"), address(0xBF822A40)));
#define ULMBRG ULMBRG
extern volatile uint32_t   ULMBRG __attribute__((section("sfrs"), address(0xBF822A40)));
extern volatile uint32_t        U6BRGCLR __attribute__((section("sfrs"),address(0xBF822A44)));
extern volatile uint32_t        ULMBRGCLR __attribute__((section("sfrs"),address(0xBF822A44)));
extern volatile uint32_t        U6BRGSET __attribute__((section("sfrs"),address(0xBF822A48)));
extern volatile uint32_t        ULMBRGSET __attribute__((section("sfrs"),address(0xBF822A48)));
extern volatile uint32_t        U6BRGINV __attribute__((section("sfrs"),address(0xBF822A4C)));
extern volatile uint32_t        ULMBRGINV __attribute__((section("sfrs"),address(0xBF822A4C)));
#define PMCON PMCON
extern volatile uint32_t   PMCON __attribute__((section("sfrs"), address(0xBF82E000)));
typedef union {
  struct {
    uint32_t RDSP:1;
    uint32_t WRSP:1;
    uint32_t :1;
    uint32_t CS1P:1;
    uint32_t CS2P:1;
    uint32_t ALP:1;
    uint32_t CSF:2;
    uint32_t PTRDEN:1;
    uint32_t PTWREN:1;
    uint32_t PMPTTL:1;
    uint32_t ADRMUX:2;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t :1;
    uint32_t DUALBUF:1;
    uint32_t :5;
    uint32_t RDSTART:1;
  };
  struct {
    uint32_t :6;
    uint32_t CSF0:1;
    uint32_t CSF1:1;
    uint32_t :3;
    uint32_t ADRMUX0:1;
    uint32_t ADRMUX1:1;
  };
  struct {
    uint32_t :13;
    uint32_t PSIDL:1;
    uint32_t :1;
    uint32_t PMPEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __PMCONbits_t;
extern volatile __PMCONbits_t PMCONbits __asm__ ("PMCON") __attribute__((section("sfrs"), address(0xBF82E000)));
extern volatile uint32_t        PMCONCLR __attribute__((section("sfrs"),address(0xBF82E004)));
extern volatile uint32_t        PMCONSET __attribute__((section("sfrs"),address(0xBF82E008)));
extern volatile uint32_t        PMCONINV __attribute__((section("sfrs"),address(0xBF82E00C)));
#define PMMODE PMMODE
extern volatile uint32_t   PMMODE __attribute__((section("sfrs"), address(0xBF82E010)));
typedef union {
  struct {
    uint32_t WAITE:2;
    uint32_t WAITM:4;
    uint32_t WAITB:2;
    uint32_t MODE:2;
    uint32_t MODE16:1;
    uint32_t INCM:2;
    uint32_t IRQM:2;
    uint32_t BUSY:1;
  };
  struct {
    uint32_t WAITE0:1;
    uint32_t WAITE1:1;
    uint32_t WAITM0:1;
    uint32_t WAITM1:1;
    uint32_t WAITM2:1;
    uint32_t WAITM3:1;
    uint32_t WAITB0:1;
    uint32_t WAITB1:1;
    uint32_t MODE0:1;
    uint32_t MODE1:1;
    uint32_t :1;
    uint32_t INCM0:1;
    uint32_t INCM1:1;
    uint32_t IRQM0:1;
    uint32_t IRQM1:1;
  };
  struct {
    uint32_t w:32;
  };
} __PMMODEbits_t;
extern volatile __PMMODEbits_t PMMODEbits __asm__ ("PMMODE") __attribute__((section("sfrs"), address(0xBF82E010)));
extern volatile uint32_t        PMMODECLR __attribute__((section("sfrs"),address(0xBF82E014)));
extern volatile uint32_t        PMMODESET __attribute__((section("sfrs"),address(0xBF82E018)));
extern volatile uint32_t        PMMODEINV __attribute__((section("sfrs"),address(0xBF82E01C)));
#define PMADDR PMADDR
extern volatile uint32_t   PMADDR __attribute__((section("sfrs"), address(0xBF82E020)));
typedef union {
  struct {
    uint32_t ADDR:14;
    uint32_t ADDR14:1;
    uint32_t ADDR15:1;
  };
  struct {
    uint32_t :14;
    uint32_t CS:2;
  };
  struct {
    uint32_t :14;
    uint32_t CS1:1;
    uint32_t CS2:1;
  };
  struct {
    uint32_t w:32;
  };
} __PMADDRbits_t;
extern volatile __PMADDRbits_t PMADDRbits __asm__ ("PMADDR") __attribute__((section("sfrs"), address(0xBF82E020)));
extern volatile uint32_t        PMADDRCLR __attribute__((section("sfrs"),address(0xBF82E024)));
extern volatile uint32_t        PMADDRSET __attribute__((section("sfrs"),address(0xBF82E028)));
extern volatile uint32_t        PMADDRINV __attribute__((section("sfrs"),address(0xBF82E02C)));
#define PMDOUT PMDOUT
extern volatile uint32_t   PMDOUT __attribute__((section("sfrs"), address(0xBF82E030)));
typedef union {
  struct {
    uint32_t DATAOUT:32;
  };
  struct {
    uint32_t w:32;
  };
} __PMDOUTbits_t;
extern volatile __PMDOUTbits_t PMDOUTbits __asm__ ("PMDOUT") __attribute__((section("sfrs"), address(0xBF82E030)));
extern volatile uint32_t        PMDOUTCLR __attribute__((section("sfrs"),address(0xBF82E034)));
extern volatile uint32_t        PMDOUTSET __attribute__((section("sfrs"),address(0xBF82E038)));
extern volatile uint32_t        PMDOUTINV __attribute__((section("sfrs"),address(0xBF82E03C)));
#define PMDIN PMDIN
extern volatile uint32_t   PMDIN __attribute__((section("sfrs"), address(0xBF82E040)));
typedef union {
  struct {
    uint32_t DATAIN:32;
  };
  struct {
    uint32_t w:32;
  };
} __PMDINbits_t;
extern volatile __PMDINbits_t PMDINbits __asm__ ("PMDIN") __attribute__((section("sfrs"), address(0xBF82E040)));
extern volatile uint32_t        PMDINCLR __attribute__((section("sfrs"),address(0xBF82E044)));
extern volatile uint32_t        PMDINSET __attribute__((section("sfrs"),address(0xBF82E048)));
extern volatile uint32_t        PMDININV __attribute__((section("sfrs"),address(0xBF82E04C)));
#define PMAEN PMAEN
extern volatile uint32_t   PMAEN __attribute__((section("sfrs"), address(0xBF82E050)));
typedef union {
  struct {
    uint32_t PTEN:24;
  };
  struct {
    uint32_t w:32;
  };
} __PMAENbits_t;
extern volatile __PMAENbits_t PMAENbits __asm__ ("PMAEN") __attribute__((section("sfrs"), address(0xBF82E050)));
extern volatile uint32_t        PMAENCLR __attribute__((section("sfrs"),address(0xBF82E054)));
extern volatile uint32_t        PMAENSET __attribute__((section("sfrs"),address(0xBF82E058)));
extern volatile uint32_t        PMAENINV __attribute__((section("sfrs"),address(0xBF82E05C)));
#define PMSTAT PMSTAT
extern volatile uint32_t   PMSTAT __attribute__((section("sfrs"), address(0xBF82E060)));
typedef union {
  struct {
    uint32_t OB0E:1;
    uint32_t OB1E:1;
    uint32_t OB2E:1;
    uint32_t OB3E:1;
    uint32_t :2;
    uint32_t OBUF:1;
    uint32_t OBE:1;
    uint32_t IB0F:1;
    uint32_t IB1F:1;
    uint32_t IB2F:1;
    uint32_t IB3F:1;
    uint32_t :2;
    uint32_t IBOV:1;
    uint32_t IBF:1;
  };
  struct {
    uint32_t w:32;
  };
} __PMSTATbits_t;
extern volatile __PMSTATbits_t PMSTATbits __asm__ ("PMSTAT") __attribute__((section("sfrs"), address(0xBF82E060)));
extern volatile uint32_t        PMSTATCLR __attribute__((section("sfrs"),address(0xBF82E064)));
extern volatile uint32_t        PMSTATSET __attribute__((section("sfrs"),address(0xBF82E068)));
extern volatile uint32_t        PMSTATINV __attribute__((section("sfrs"),address(0xBF82E06C)));
#define PMWADDR PMWADDR
extern volatile uint32_t   PMWADDR __attribute__((section("sfrs"), address(0xBF82E070)));
typedef union {
  struct {
    uint32_t WADDR:24;
  };
  struct {
    uint32_t :14;
    uint32_t WCS:2;
    uint32_t :6;
    uint32_t WCSA:2;
  };
  struct {
    uint32_t :14;
    uint32_t WCS1:1;
    uint32_t WCS2:1;
    uint32_t :6;
    uint32_t WCS1A:1;
    uint32_t WCS2A:1;
  };
  struct {
    uint32_t w:32;
  };
  struct {
    uint32_t :14;
    uint32_t WADDR14:1;
    uint32_t WADDR15:1;
    uint32_t :6;
    uint32_t WADDR22:1;
    uint32_t WADDR23:1;
  };
} __PMWADDRbits_t;
extern volatile __PMWADDRbits_t PMWADDRbits __asm__ ("PMWADDR") __attribute__((section("sfrs"), address(0xBF82E070)));
extern volatile uint32_t        PMWADDRCLR __attribute__((section("sfrs"),address(0xBF82E074)));
extern volatile uint32_t        PMWADDRSET __attribute__((section("sfrs"),address(0xBF82E078)));
extern volatile uint32_t        PMWADDRINV __attribute__((section("sfrs"),address(0xBF82E07C)));
#define PMRADDR PMRADDR
extern volatile uint32_t   PMRADDR __attribute__((section("sfrs"), address(0xBF82E080)));
typedef union {
  struct {
    uint32_t RADDR:14;
    uint32_t RADDR14:1;
    uint32_t RADDR15:1;
  };
  struct {
    uint32_t :14;
    uint32_t RCS:2;
  };
  struct {
    uint32_t :14;
    uint32_t RCS1:1;
    uint32_t RCS2:1;
  };
  struct {
    uint32_t w:32;
  };
} __PMRADDRbits_t;
extern volatile __PMRADDRbits_t PMRADDRbits __asm__ ("PMRADDR") __attribute__((section("sfrs"), address(0xBF82E080)));
extern volatile uint32_t        PMRADDRCLR __attribute__((section("sfrs"),address(0xBF82E084)));
extern volatile uint32_t        PMRADDRSET __attribute__((section("sfrs"),address(0xBF82E088)));
extern volatile uint32_t        PMRADDRINV __attribute__((section("sfrs"),address(0xBF82E08C)));
#define PMRDIN PMRDIN
extern volatile uint32_t   PMRDIN __attribute__((section("sfrs"), address(0xBF82E090)));
typedef union {
  struct {
    uint32_t RDATAIN:32;
  };
  struct {
    uint32_t w:32;
  };
} __PMRDINbits_t;
extern volatile __PMRDINbits_t PMRDINbits __asm__ ("PMRDIN") __attribute__((section("sfrs"), address(0xBF82E090)));
extern volatile uint32_t        PMRDINCLR __attribute__((section("sfrs"),address(0xBF82E094)));
extern volatile uint32_t        PMRDINSET __attribute__((section("sfrs"),address(0xBF82E098)));
extern volatile uint32_t        PMRDININV __attribute__((section("sfrs"),address(0xBF82E09C)));
#define T1CON T1CON
extern volatile uint32_t   T1CON __attribute__((section("sfrs"), address(0xBF840000)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t TSYNC:1;
    uint32_t :1;
    uint32_t TCKPS:2;
    uint32_t :1;
    uint32_t TGATE:1;
    uint32_t :3;
    uint32_t TWIP:1;
    uint32_t TWDIS:1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T1CONbits_t;
extern volatile __T1CONbits_t T1CONbits __asm__ ("T1CON") __attribute__((section("sfrs"), address(0xBF840000)));
extern volatile uint32_t        T1CONCLR __attribute__((section("sfrs"),address(0xBF840004)));
extern volatile uint32_t        T1CONSET __attribute__((section("sfrs"),address(0xBF840008)));
extern volatile uint32_t        T1CONINV __attribute__((section("sfrs"),address(0xBF84000C)));
#define TMR1 TMR1
extern volatile uint32_t   TMR1 __attribute__((section("sfrs"), address(0xBF840010)));
extern volatile uint32_t        TMR1CLR __attribute__((section("sfrs"),address(0xBF840014)));
extern volatile uint32_t        TMR1SET __attribute__((section("sfrs"),address(0xBF840018)));
extern volatile uint32_t        TMR1INV __attribute__((section("sfrs"),address(0xBF84001C)));
#define PR1 PR1
extern volatile uint32_t   PR1 __attribute__((section("sfrs"), address(0xBF840020)));
extern volatile uint32_t        PR1CLR __attribute__((section("sfrs"),address(0xBF840024)));
extern volatile uint32_t        PR1SET __attribute__((section("sfrs"),address(0xBF840028)));
extern volatile uint32_t        PR1INV __attribute__((section("sfrs"),address(0xBF84002C)));
#define T2CON T2CON
extern volatile uint32_t   T2CON __attribute__((section("sfrs"), address(0xBF840200)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :1;
    uint32_t T32:1;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T2CONbits_t;
extern volatile __T2CONbits_t T2CONbits __asm__ ("T2CON") __attribute__((section("sfrs"), address(0xBF840200)));
extern volatile uint32_t        T2CONCLR __attribute__((section("sfrs"),address(0xBF840204)));
extern volatile uint32_t        T2CONSET __attribute__((section("sfrs"),address(0xBF840208)));
extern volatile uint32_t        T2CONINV __attribute__((section("sfrs"),address(0xBF84020C)));
#define TMR2 TMR2
extern volatile uint32_t   TMR2 __attribute__((section("sfrs"), address(0xBF840210)));
extern volatile uint32_t        TMR2CLR __attribute__((section("sfrs"),address(0xBF840214)));
extern volatile uint32_t        TMR2SET __attribute__((section("sfrs"),address(0xBF840218)));
extern volatile uint32_t        TMR2INV __attribute__((section("sfrs"),address(0xBF84021C)));
#define PR2 PR2
extern volatile uint32_t   PR2 __attribute__((section("sfrs"), address(0xBF840220)));
extern volatile uint32_t        PR2CLR __attribute__((section("sfrs"),address(0xBF840224)));
extern volatile uint32_t        PR2SET __attribute__((section("sfrs"),address(0xBF840228)));
extern volatile uint32_t        PR2INV __attribute__((section("sfrs"),address(0xBF84022C)));
#define T3CON T3CON
extern volatile uint32_t   T3CON __attribute__((section("sfrs"), address(0xBF840400)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :2;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T3CONbits_t;
extern volatile __T3CONbits_t T3CONbits __asm__ ("T3CON") __attribute__((section("sfrs"), address(0xBF840400)));
extern volatile uint32_t        T3CONCLR __attribute__((section("sfrs"),address(0xBF840404)));
extern volatile uint32_t        T3CONSET __attribute__((section("sfrs"),address(0xBF840408)));
extern volatile uint32_t        T3CONINV __attribute__((section("sfrs"),address(0xBF84040C)));
#define TMR3 TMR3
extern volatile uint32_t   TMR3 __attribute__((section("sfrs"), address(0xBF840410)));
extern volatile uint32_t        TMR3CLR __attribute__((section("sfrs"),address(0xBF840414)));
extern volatile uint32_t        TMR3SET __attribute__((section("sfrs"),address(0xBF840418)));
extern volatile uint32_t        TMR3INV __attribute__((section("sfrs"),address(0xBF84041C)));
#define PR3 PR3
extern volatile uint32_t   PR3 __attribute__((section("sfrs"), address(0xBF840420)));
extern volatile uint32_t        PR3CLR __attribute__((section("sfrs"),address(0xBF840424)));
extern volatile uint32_t        PR3SET __attribute__((section("sfrs"),address(0xBF840428)));
extern volatile uint32_t        PR3INV __attribute__((section("sfrs"),address(0xBF84042C)));
#define T4CON T4CON
extern volatile uint32_t   T4CON __attribute__((section("sfrs"), address(0xBF840600)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :1;
    uint32_t T32:1;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T4CONbits_t;
extern volatile __T4CONbits_t T4CONbits __asm__ ("T4CON") __attribute__((section("sfrs"), address(0xBF840600)));
extern volatile uint32_t        T4CONCLR __attribute__((section("sfrs"),address(0xBF840604)));
extern volatile uint32_t        T4CONSET __attribute__((section("sfrs"),address(0xBF840608)));
extern volatile uint32_t        T4CONINV __attribute__((section("sfrs"),address(0xBF84060C)));
#define TMR4 TMR4
extern volatile uint32_t   TMR4 __attribute__((section("sfrs"), address(0xBF840610)));
extern volatile uint32_t        TMR4CLR __attribute__((section("sfrs"),address(0xBF840614)));
extern volatile uint32_t        TMR4SET __attribute__((section("sfrs"),address(0xBF840618)));
extern volatile uint32_t        TMR4INV __attribute__((section("sfrs"),address(0xBF84061C)));
#define PR4 PR4
extern volatile uint32_t   PR4 __attribute__((section("sfrs"), address(0xBF840620)));
extern volatile uint32_t        PR4CLR __attribute__((section("sfrs"),address(0xBF840624)));
extern volatile uint32_t        PR4SET __attribute__((section("sfrs"),address(0xBF840628)));
extern volatile uint32_t        PR4INV __attribute__((section("sfrs"),address(0xBF84062C)));
#define T5CON T5CON
extern volatile uint32_t   T5CON __attribute__((section("sfrs"), address(0xBF840800)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :2;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T5CONbits_t;
extern volatile __T5CONbits_t T5CONbits __asm__ ("T5CON") __attribute__((section("sfrs"), address(0xBF840800)));
extern volatile uint32_t        T5CONCLR __attribute__((section("sfrs"),address(0xBF840804)));
extern volatile uint32_t        T5CONSET __attribute__((section("sfrs"),address(0xBF840808)));
extern volatile uint32_t        T5CONINV __attribute__((section("sfrs"),address(0xBF84080C)));
#define TMR5 TMR5
extern volatile uint32_t   TMR5 __attribute__((section("sfrs"), address(0xBF840810)));
extern volatile uint32_t        TMR5CLR __attribute__((section("sfrs"),address(0xBF840814)));
extern volatile uint32_t        TMR5SET __attribute__((section("sfrs"),address(0xBF840818)));
extern volatile uint32_t        TMR5INV __attribute__((section("sfrs"),address(0xBF84081C)));
#define PR5 PR5
extern volatile uint32_t   PR5 __attribute__((section("sfrs"), address(0xBF840820)));
extern volatile uint32_t        PR5CLR __attribute__((section("sfrs"),address(0xBF840824)));
extern volatile uint32_t        PR5SET __attribute__((section("sfrs"),address(0xBF840828)));
extern volatile uint32_t        PR5INV __attribute__((section("sfrs"),address(0xBF84082C)));
#define T6CON T6CON
extern volatile uint32_t   T6CON __attribute__((section("sfrs"), address(0xBF840A00)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :1;
    uint32_t T32:1;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T6CONbits_t;
extern volatile __T6CONbits_t T6CONbits __asm__ ("T6CON") __attribute__((section("sfrs"), address(0xBF840A00)));
extern volatile uint32_t        T6CONCLR __attribute__((section("sfrs"),address(0xBF840A04)));
extern volatile uint32_t        T6CONSET __attribute__((section("sfrs"),address(0xBF840A08)));
extern volatile uint32_t        T6CONINV __attribute__((section("sfrs"),address(0xBF840A0C)));
#define TMR6 TMR6
extern volatile uint32_t   TMR6 __attribute__((section("sfrs"), address(0xBF840A10)));
extern volatile uint32_t        TMR6CLR __attribute__((section("sfrs"),address(0xBF840A14)));
extern volatile uint32_t        TMR6SET __attribute__((section("sfrs"),address(0xBF840A18)));
extern volatile uint32_t        TMR6INV __attribute__((section("sfrs"),address(0xBF840A1C)));
#define PR6 PR6
extern volatile uint32_t   PR6 __attribute__((section("sfrs"), address(0xBF840A20)));
extern volatile uint32_t        PR6CLR __attribute__((section("sfrs"),address(0xBF840A24)));
extern volatile uint32_t        PR6SET __attribute__((section("sfrs"),address(0xBF840A28)));
extern volatile uint32_t        PR6INV __attribute__((section("sfrs"),address(0xBF840A2C)));
#define T7CON T7CON
extern volatile uint32_t   T7CON __attribute__((section("sfrs"), address(0xBF840C00)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :2;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T7CONbits_t;
extern volatile __T7CONbits_t T7CONbits __asm__ ("T7CON") __attribute__((section("sfrs"), address(0xBF840C00)));
extern volatile uint32_t        T7CONCLR __attribute__((section("sfrs"),address(0xBF840C04)));
extern volatile uint32_t        T7CONSET __attribute__((section("sfrs"),address(0xBF840C08)));
extern volatile uint32_t        T7CONINV __attribute__((section("sfrs"),address(0xBF840C0C)));
#define TMR7 TMR7
extern volatile uint32_t   TMR7 __attribute__((section("sfrs"), address(0xBF840C10)));
extern volatile uint32_t        TMR7CLR __attribute__((section("sfrs"),address(0xBF840C14)));
extern volatile uint32_t        TMR7SET __attribute__((section("sfrs"),address(0xBF840C18)));
extern volatile uint32_t        TMR7INV __attribute__((section("sfrs"),address(0xBF840C1C)));
#define PR7 PR7
extern volatile uint32_t   PR7 __attribute__((section("sfrs"), address(0xBF840C20)));
extern volatile uint32_t        PR7CLR __attribute__((section("sfrs"),address(0xBF840C24)));
extern volatile uint32_t        PR7SET __attribute__((section("sfrs"),address(0xBF840C28)));
extern volatile uint32_t        PR7INV __attribute__((section("sfrs"),address(0xBF840C2C)));
#define T8CON T8CON
extern volatile uint32_t   T8CON __attribute__((section("sfrs"), address(0xBF840E00)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :1;
    uint32_t T32:1;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T8CONbits_t;
extern volatile __T8CONbits_t T8CONbits __asm__ ("T8CON") __attribute__((section("sfrs"), address(0xBF840E00)));
extern volatile uint32_t        T8CONCLR __attribute__((section("sfrs"),address(0xBF840E04)));
extern volatile uint32_t        T8CONSET __attribute__((section("sfrs"),address(0xBF840E08)));
extern volatile uint32_t        T8CONINV __attribute__((section("sfrs"),address(0xBF840E0C)));
#define TMR8 TMR8
extern volatile uint32_t   TMR8 __attribute__((section("sfrs"), address(0xBF840E10)));
extern volatile uint32_t        TMR8CLR __attribute__((section("sfrs"),address(0xBF840E14)));
extern volatile uint32_t        TMR8SET __attribute__((section("sfrs"),address(0xBF840E18)));
extern volatile uint32_t        TMR8INV __attribute__((section("sfrs"),address(0xBF840E1C)));
#define PR8 PR8
extern volatile uint32_t   PR8 __attribute__((section("sfrs"), address(0xBF840E20)));
extern volatile uint32_t        PR8CLR __attribute__((section("sfrs"),address(0xBF840E24)));
extern volatile uint32_t        PR8SET __attribute__((section("sfrs"),address(0xBF840E28)));
extern volatile uint32_t        PR8INV __attribute__((section("sfrs"),address(0xBF840E2C)));
#define T9CON T9CON
extern volatile uint32_t   T9CON __attribute__((section("sfrs"), address(0xBF841000)));
typedef union {
  struct {
    uint32_t :1;
    uint32_t TCS:1;
    uint32_t :2;
    uint32_t TCKPS:3;
    uint32_t TGATE:1;
    uint32_t :5;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t :4;
    uint32_t TCKPS0:1;
    uint32_t TCKPS1:1;
    uint32_t TCKPS2:1;
  };
  struct {
    uint32_t :13;
    uint32_t TSIDL:1;
    uint32_t :1;
    uint32_t TON:1;
  };
  struct {
    uint32_t w:32;
  };
} __T9CONbits_t;
extern volatile __T9CONbits_t T9CONbits __asm__ ("T9CON") __attribute__((section("sfrs"), address(0xBF841000)));
extern volatile uint32_t        T9CONCLR __attribute__((section("sfrs"),address(0xBF841004)));
extern volatile uint32_t        T9CONSET __attribute__((section("sfrs"),address(0xBF841008)));
extern volatile uint32_t        T9CONINV __attribute__((section("sfrs"),address(0xBF84100C)));
#define TMR9 TMR9
extern volatile uint32_t   TMR9 __attribute__((section("sfrs"), address(0xBF841010)));
extern volatile uint32_t        TMR9CLR __attribute__((section("sfrs"),address(0xBF841014)));
extern volatile uint32_t        TMR9SET __attribute__((section("sfrs"),address(0xBF841018)));
extern volatile uint32_t        TMR9INV __attribute__((section("sfrs"),address(0xBF84101C)));
#define PR9 PR9
extern volatile uint32_t   PR9 __attribute__((section("sfrs"), address(0xBF841020)));
extern volatile uint32_t        PR9CLR __attribute__((section("sfrs"),address(0xBF841024)));
extern volatile uint32_t        PR9SET __attribute__((section("sfrs"),address(0xBF841028)));
extern volatile uint32_t        PR9INV __attribute__((section("sfrs"),address(0xBF84102C)));
#define IC1CON IC1CON
extern volatile uint32_t   IC1CON __attribute__((section("sfrs"), address(0xBF842000)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC1CONbits_t;
extern volatile __IC1CONbits_t IC1CONbits __asm__ ("IC1CON") __attribute__((section("sfrs"), address(0xBF842000)));
extern volatile uint32_t        IC1CONCLR __attribute__((section("sfrs"),address(0xBF842004)));
extern volatile uint32_t        IC1CONSET __attribute__((section("sfrs"),address(0xBF842008)));
extern volatile uint32_t        IC1CONINV __attribute__((section("sfrs"),address(0xBF84200C)));
#define IC1BUF IC1BUF
extern volatile uint32_t   IC1BUF __attribute__((section("sfrs"), address(0xBF842010)));
#define IC2CON IC2CON
extern volatile uint32_t   IC2CON __attribute__((section("sfrs"), address(0xBF842200)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC2CONbits_t;
extern volatile __IC2CONbits_t IC2CONbits __asm__ ("IC2CON") __attribute__((section("sfrs"), address(0xBF842200)));
extern volatile uint32_t        IC2CONCLR __attribute__((section("sfrs"),address(0xBF842204)));
extern volatile uint32_t        IC2CONSET __attribute__((section("sfrs"),address(0xBF842208)));
extern volatile uint32_t        IC2CONINV __attribute__((section("sfrs"),address(0xBF84220C)));
#define IC2BUF IC2BUF
extern volatile uint32_t   IC2BUF __attribute__((section("sfrs"), address(0xBF842210)));
#define IC3CON IC3CON
extern volatile uint32_t   IC3CON __attribute__((section("sfrs"), address(0xBF842400)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC3CONbits_t;
extern volatile __IC3CONbits_t IC3CONbits __asm__ ("IC3CON") __attribute__((section("sfrs"), address(0xBF842400)));
extern volatile uint32_t        IC3CONCLR __attribute__((section("sfrs"),address(0xBF842404)));
extern volatile uint32_t        IC3CONSET __attribute__((section("sfrs"),address(0xBF842408)));
extern volatile uint32_t        IC3CONINV __attribute__((section("sfrs"),address(0xBF84240C)));
#define IC3BUF IC3BUF
extern volatile uint32_t   IC3BUF __attribute__((section("sfrs"), address(0xBF842410)));
#define IC4CON IC4CON
extern volatile uint32_t   IC4CON __attribute__((section("sfrs"), address(0xBF842600)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC4CONbits_t;
extern volatile __IC4CONbits_t IC4CONbits __asm__ ("IC4CON") __attribute__((section("sfrs"), address(0xBF842600)));
extern volatile uint32_t        IC4CONCLR __attribute__((section("sfrs"),address(0xBF842604)));
extern volatile uint32_t        IC4CONSET __attribute__((section("sfrs"),address(0xBF842608)));
extern volatile uint32_t        IC4CONINV __attribute__((section("sfrs"),address(0xBF84260C)));
#define IC4BUF IC4BUF
extern volatile uint32_t   IC4BUF __attribute__((section("sfrs"), address(0xBF842610)));
#define IC5CON IC5CON
extern volatile uint32_t   IC5CON __attribute__((section("sfrs"), address(0xBF842800)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC5CONbits_t;
extern volatile __IC5CONbits_t IC5CONbits __asm__ ("IC5CON") __attribute__((section("sfrs"), address(0xBF842800)));
extern volatile uint32_t        IC5CONCLR __attribute__((section("sfrs"),address(0xBF842804)));
extern volatile uint32_t        IC5CONSET __attribute__((section("sfrs"),address(0xBF842808)));
extern volatile uint32_t        IC5CONINV __attribute__((section("sfrs"),address(0xBF84280C)));
#define IC5BUF IC5BUF
extern volatile uint32_t   IC5BUF __attribute__((section("sfrs"), address(0xBF842810)));
#define IC6CON IC6CON
extern volatile uint32_t   IC6CON __attribute__((section("sfrs"), address(0xBF842A00)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC6CONbits_t;
extern volatile __IC6CONbits_t IC6CONbits __asm__ ("IC6CON") __attribute__((section("sfrs"), address(0xBF842A00)));
extern volatile uint32_t        IC6CONCLR __attribute__((section("sfrs"),address(0xBF842A04)));
extern volatile uint32_t        IC6CONSET __attribute__((section("sfrs"),address(0xBF842A08)));
extern volatile uint32_t        IC6CONINV __attribute__((section("sfrs"),address(0xBF842A0C)));
#define IC6BUF IC6BUF
extern volatile uint32_t   IC6BUF __attribute__((section("sfrs"), address(0xBF842A10)));
#define IC7CON IC7CON
extern volatile uint32_t   IC7CON __attribute__((section("sfrs"), address(0xBF842C00)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC7CONbits_t;
extern volatile __IC7CONbits_t IC7CONbits __asm__ ("IC7CON") __attribute__((section("sfrs"), address(0xBF842C00)));
extern volatile uint32_t        IC7CONCLR __attribute__((section("sfrs"),address(0xBF842C04)));
extern volatile uint32_t        IC7CONSET __attribute__((section("sfrs"),address(0xBF842C08)));
extern volatile uint32_t        IC7CONINV __attribute__((section("sfrs"),address(0xBF842C0C)));
#define IC7BUF IC7BUF
extern volatile uint32_t   IC7BUF __attribute__((section("sfrs"), address(0xBF842C10)));
#define IC8CON IC8CON
extern volatile uint32_t   IC8CON __attribute__((section("sfrs"), address(0xBF842E00)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC8CONbits_t;
extern volatile __IC8CONbits_t IC8CONbits __asm__ ("IC8CON") __attribute__((section("sfrs"), address(0xBF842E00)));
extern volatile uint32_t        IC8CONCLR __attribute__((section("sfrs"),address(0xBF842E04)));
extern volatile uint32_t        IC8CONSET __attribute__((section("sfrs"),address(0xBF842E08)));
extern volatile uint32_t        IC8CONINV __attribute__((section("sfrs"),address(0xBF842E0C)));
#define IC8BUF IC8BUF
extern volatile uint32_t   IC8BUF __attribute__((section("sfrs"), address(0xBF842E10)));
#define IC9CON IC9CON
extern volatile uint32_t   IC9CON __attribute__((section("sfrs"), address(0xBF843000)));
typedef union {
  struct {
    uint32_t ICM:3;
    uint32_t ICBNE:1;
    uint32_t ICOV:1;
    uint32_t ICI:2;
    uint32_t ICTMR:1;
    uint32_t C32:1;
    uint32_t FEDGE:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t ICM0:1;
    uint32_t ICM1:1;
    uint32_t ICM2:1;
    uint32_t :2;
    uint32_t ICI0:1;
    uint32_t ICI1:1;
  };
  struct {
    uint32_t :13;
    uint32_t ICSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __IC9CONbits_t;
extern volatile __IC9CONbits_t IC9CONbits __asm__ ("IC9CON") __attribute__((section("sfrs"), address(0xBF843000)));
extern volatile uint32_t        IC9CONCLR __attribute__((section("sfrs"),address(0xBF843004)));
extern volatile uint32_t        IC9CONSET __attribute__((section("sfrs"),address(0xBF843008)));
extern volatile uint32_t        IC9CONINV __attribute__((section("sfrs"),address(0xBF84300C)));
#define IC9BUF IC9BUF
extern volatile uint32_t   IC9BUF __attribute__((section("sfrs"), address(0xBF843010)));
#define OC1CON OC1CON
extern volatile uint32_t   OC1CON __attribute__((section("sfrs"), address(0xBF844000)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC1CONbits_t;
extern volatile __OC1CONbits_t OC1CONbits __asm__ ("OC1CON") __attribute__((section("sfrs"), address(0xBF844000)));
extern volatile uint32_t        OC1CONCLR __attribute__((section("sfrs"),address(0xBF844004)));
extern volatile uint32_t        OC1CONSET __attribute__((section("sfrs"),address(0xBF844008)));
extern volatile uint32_t        OC1CONINV __attribute__((section("sfrs"),address(0xBF84400C)));
#define OC1R OC1R
extern volatile uint32_t   OC1R __attribute__((section("sfrs"), address(0xBF844010)));
extern volatile uint32_t        OC1RCLR __attribute__((section("sfrs"),address(0xBF844014)));
extern volatile uint32_t        OC1RSET __attribute__((section("sfrs"),address(0xBF844018)));
extern volatile uint32_t        OC1RINV __attribute__((section("sfrs"),address(0xBF84401C)));
#define OC1RS OC1RS
extern volatile uint32_t   OC1RS __attribute__((section("sfrs"), address(0xBF844020)));
extern volatile uint32_t        OC1RSCLR __attribute__((section("sfrs"),address(0xBF844024)));
extern volatile uint32_t        OC1RSSET __attribute__((section("sfrs"),address(0xBF844028)));
extern volatile uint32_t        OC1RSINV __attribute__((section("sfrs"),address(0xBF84402C)));
#define OC2CON OC2CON
extern volatile uint32_t   OC2CON __attribute__((section("sfrs"), address(0xBF844200)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC2CONbits_t;
extern volatile __OC2CONbits_t OC2CONbits __asm__ ("OC2CON") __attribute__((section("sfrs"), address(0xBF844200)));
extern volatile uint32_t        OC2CONCLR __attribute__((section("sfrs"),address(0xBF844204)));
extern volatile uint32_t        OC2CONSET __attribute__((section("sfrs"),address(0xBF844208)));
extern volatile uint32_t        OC2CONINV __attribute__((section("sfrs"),address(0xBF84420C)));
#define OC2R OC2R
extern volatile uint32_t   OC2R __attribute__((section("sfrs"), address(0xBF844210)));
extern volatile uint32_t        OC2RCLR __attribute__((section("sfrs"),address(0xBF844214)));
extern volatile uint32_t        OC2RSET __attribute__((section("sfrs"),address(0xBF844218)));
extern volatile uint32_t        OC2RINV __attribute__((section("sfrs"),address(0xBF84421C)));
#define OC2RS OC2RS
extern volatile uint32_t   OC2RS __attribute__((section("sfrs"), address(0xBF844220)));
extern volatile uint32_t        OC2RSCLR __attribute__((section("sfrs"),address(0xBF844224)));
extern volatile uint32_t        OC2RSSET __attribute__((section("sfrs"),address(0xBF844228)));
extern volatile uint32_t        OC2RSINV __attribute__((section("sfrs"),address(0xBF84422C)));
#define OC3CON OC3CON
extern volatile uint32_t   OC3CON __attribute__((section("sfrs"), address(0xBF844400)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC3CONbits_t;
extern volatile __OC3CONbits_t OC3CONbits __asm__ ("OC3CON") __attribute__((section("sfrs"), address(0xBF844400)));
extern volatile uint32_t        OC3CONCLR __attribute__((section("sfrs"),address(0xBF844404)));
extern volatile uint32_t        OC3CONSET __attribute__((section("sfrs"),address(0xBF844408)));
extern volatile uint32_t        OC3CONINV __attribute__((section("sfrs"),address(0xBF84440C)));
#define OC3R OC3R
extern volatile uint32_t   OC3R __attribute__((section("sfrs"), address(0xBF844410)));
extern volatile uint32_t        OC3RCLR __attribute__((section("sfrs"),address(0xBF844414)));
extern volatile uint32_t        OC3RSET __attribute__((section("sfrs"),address(0xBF844418)));
extern volatile uint32_t        OC3RINV __attribute__((section("sfrs"),address(0xBF84441C)));
#define OC3RS OC3RS
extern volatile uint32_t   OC3RS __attribute__((section("sfrs"), address(0xBF844420)));
extern volatile uint32_t        OC3RSCLR __attribute__((section("sfrs"),address(0xBF844424)));
extern volatile uint32_t        OC3RSSET __attribute__((section("sfrs"),address(0xBF844428)));
extern volatile uint32_t        OC3RSINV __attribute__((section("sfrs"),address(0xBF84442C)));
#define OC4CON OC4CON
extern volatile uint32_t   OC4CON __attribute__((section("sfrs"), address(0xBF844600)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC4CONbits_t;
extern volatile __OC4CONbits_t OC4CONbits __asm__ ("OC4CON") __attribute__((section("sfrs"), address(0xBF844600)));
extern volatile uint32_t        OC4CONCLR __attribute__((section("sfrs"),address(0xBF844604)));
extern volatile uint32_t        OC4CONSET __attribute__((section("sfrs"),address(0xBF844608)));
extern volatile uint32_t        OC4CONINV __attribute__((section("sfrs"),address(0xBF84460C)));
#define OC4R OC4R
extern volatile uint32_t   OC4R __attribute__((section("sfrs"), address(0xBF844610)));
extern volatile uint32_t        OC4RCLR __attribute__((section("sfrs"),address(0xBF844614)));
extern volatile uint32_t        OC4RSET __attribute__((section("sfrs"),address(0xBF844618)));
extern volatile uint32_t        OC4RINV __attribute__((section("sfrs"),address(0xBF84461C)));
#define OC4RS OC4RS
extern volatile uint32_t   OC4RS __attribute__((section("sfrs"), address(0xBF844620)));
extern volatile uint32_t        OC4RSCLR __attribute__((section("sfrs"),address(0xBF844624)));
extern volatile uint32_t        OC4RSSET __attribute__((section("sfrs"),address(0xBF844628)));
extern volatile uint32_t        OC4RSINV __attribute__((section("sfrs"),address(0xBF84462C)));
#define OC5CON OC5CON
extern volatile uint32_t   OC5CON __attribute__((section("sfrs"), address(0xBF844800)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC5CONbits_t;
extern volatile __OC5CONbits_t OC5CONbits __asm__ ("OC5CON") __attribute__((section("sfrs"), address(0xBF844800)));
extern volatile uint32_t        OC5CONCLR __attribute__((section("sfrs"),address(0xBF844804)));
extern volatile uint32_t        OC5CONSET __attribute__((section("sfrs"),address(0xBF844808)));
extern volatile uint32_t        OC5CONINV __attribute__((section("sfrs"),address(0xBF84480C)));
#define OC5R OC5R
extern volatile uint32_t   OC5R __attribute__((section("sfrs"), address(0xBF844810)));
extern volatile uint32_t        OC5RCLR __attribute__((section("sfrs"),address(0xBF844814)));
extern volatile uint32_t        OC5RSET __attribute__((section("sfrs"),address(0xBF844818)));
extern volatile uint32_t        OC5RINV __attribute__((section("sfrs"),address(0xBF84481C)));
#define OC5RS OC5RS
extern volatile uint32_t   OC5RS __attribute__((section("sfrs"), address(0xBF844820)));
extern volatile uint32_t        OC5RSCLR __attribute__((section("sfrs"),address(0xBF844824)));
extern volatile uint32_t        OC5RSSET __attribute__((section("sfrs"),address(0xBF844828)));
extern volatile uint32_t        OC5RSINV __attribute__((section("sfrs"),address(0xBF84482C)));
#define OC6CON OC6CON
extern volatile uint32_t   OC6CON __attribute__((section("sfrs"), address(0xBF844A00)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC6CONbits_t;
extern volatile __OC6CONbits_t OC6CONbits __asm__ ("OC6CON") __attribute__((section("sfrs"), address(0xBF844A00)));
extern volatile uint32_t        OC6CONCLR __attribute__((section("sfrs"),address(0xBF844A04)));
extern volatile uint32_t        OC6CONSET __attribute__((section("sfrs"),address(0xBF844A08)));
extern volatile uint32_t        OC6CONINV __attribute__((section("sfrs"),address(0xBF844A0C)));
#define OC6R OC6R
extern volatile uint32_t   OC6R __attribute__((section("sfrs"), address(0xBF844A10)));
extern volatile uint32_t        OC6RCLR __attribute__((section("sfrs"),address(0xBF844A14)));
extern volatile uint32_t        OC6RSET __attribute__((section("sfrs"),address(0xBF844A18)));
extern volatile uint32_t        OC6RINV __attribute__((section("sfrs"),address(0xBF844A1C)));
#define OC6RS OC6RS
extern volatile uint32_t   OC6RS __attribute__((section("sfrs"), address(0xBF844A20)));
extern volatile uint32_t        OC6RSCLR __attribute__((section("sfrs"),address(0xBF844A24)));
extern volatile uint32_t        OC6RSSET __attribute__((section("sfrs"),address(0xBF844A28)));
extern volatile uint32_t        OC6RSINV __attribute__((section("sfrs"),address(0xBF844A2C)));
#define OC7CON OC7CON
extern volatile uint32_t   OC7CON __attribute__((section("sfrs"), address(0xBF844C00)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC7CONbits_t;
extern volatile __OC7CONbits_t OC7CONbits __asm__ ("OC7CON") __attribute__((section("sfrs"), address(0xBF844C00)));
extern volatile uint32_t        OC7CONCLR __attribute__((section("sfrs"),address(0xBF844C04)));
extern volatile uint32_t        OC7CONSET __attribute__((section("sfrs"),address(0xBF844C08)));
extern volatile uint32_t        OC7CONINV __attribute__((section("sfrs"),address(0xBF844C0C)));
#define OC7R OC7R
extern volatile uint32_t   OC7R __attribute__((section("sfrs"), address(0xBF844C10)));
extern volatile uint32_t        OC7RCLR __attribute__((section("sfrs"),address(0xBF844C14)));
extern volatile uint32_t        OC7RSET __attribute__((section("sfrs"),address(0xBF844C18)));
extern volatile uint32_t        OC7RINV __attribute__((section("sfrs"),address(0xBF844C1C)));
#define OC7RS OC7RS
extern volatile uint32_t   OC7RS __attribute__((section("sfrs"), address(0xBF844C20)));
extern volatile uint32_t        OC7RSCLR __attribute__((section("sfrs"),address(0xBF844C24)));
extern volatile uint32_t        OC7RSSET __attribute__((section("sfrs"),address(0xBF844C28)));
extern volatile uint32_t        OC7RSINV __attribute__((section("sfrs"),address(0xBF844C2C)));
#define OC8CON OC8CON
extern volatile uint32_t   OC8CON __attribute__((section("sfrs"), address(0xBF844E00)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC8CONbits_t;
extern volatile __OC8CONbits_t OC8CONbits __asm__ ("OC8CON") __attribute__((section("sfrs"), address(0xBF844E00)));
extern volatile uint32_t        OC8CONCLR __attribute__((section("sfrs"),address(0xBF844E04)));
extern volatile uint32_t        OC8CONSET __attribute__((section("sfrs"),address(0xBF844E08)));
extern volatile uint32_t        OC8CONINV __attribute__((section("sfrs"),address(0xBF844E0C)));
#define OC8R OC8R
extern volatile uint32_t   OC8R __attribute__((section("sfrs"), address(0xBF844E10)));
extern volatile uint32_t        OC8RCLR __attribute__((section("sfrs"),address(0xBF844E14)));
extern volatile uint32_t        OC8RSET __attribute__((section("sfrs"),address(0xBF844E18)));
extern volatile uint32_t        OC8RINV __attribute__((section("sfrs"),address(0xBF844E1C)));
#define OC8RS OC8RS
extern volatile uint32_t   OC8RS __attribute__((section("sfrs"), address(0xBF844E20)));
extern volatile uint32_t        OC8RSCLR __attribute__((section("sfrs"),address(0xBF844E24)));
extern volatile uint32_t        OC8RSSET __attribute__((section("sfrs"),address(0xBF844E28)));
extern volatile uint32_t        OC8RSINV __attribute__((section("sfrs"),address(0xBF844E2C)));
#define OC9CON OC9CON
extern volatile uint32_t   OC9CON __attribute__((section("sfrs"), address(0xBF845000)));
typedef union {
  struct {
    uint32_t OCM:3;
    uint32_t OCTSEL:1;
    uint32_t OCFLT:1;
    uint32_t OC32:1;
    uint32_t :7;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
  };
  struct {
    uint32_t OCM0:1;
    uint32_t OCM1:1;
    uint32_t OCM2:1;
  };
  struct {
    uint32_t :13;
    uint32_t OCSIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __OC9CONbits_t;
extern volatile __OC9CONbits_t OC9CONbits __asm__ ("OC9CON") __attribute__((section("sfrs"), address(0xBF845000)));
extern volatile uint32_t        OC9CONCLR __attribute__((section("sfrs"),address(0xBF845004)));
extern volatile uint32_t        OC9CONSET __attribute__((section("sfrs"),address(0xBF845008)));
extern volatile uint32_t        OC9CONINV __attribute__((section("sfrs"),address(0xBF84500C)));
#define OC9R OC9R
extern volatile uint32_t   OC9R __attribute__((section("sfrs"), address(0xBF845010)));
extern volatile uint32_t        OC9RCLR __attribute__((section("sfrs"),address(0xBF845014)));
extern volatile uint32_t        OC9RSET __attribute__((section("sfrs"),address(0xBF845018)));
extern volatile uint32_t        OC9RINV __attribute__((section("sfrs"),address(0xBF84501C)));
#define OC9RS OC9RS
extern volatile uint32_t   OC9RS __attribute__((section("sfrs"), address(0xBF845020)));
extern volatile uint32_t        OC9RSCLR __attribute__((section("sfrs"),address(0xBF845024)));
extern volatile uint32_t        OC9RSSET __attribute__((section("sfrs"),address(0xBF845028)));
extern volatile uint32_t        OC9RSINV __attribute__((section("sfrs"),address(0xBF84502C)));
#define ADCCON1 ADCCON1
extern volatile uint32_t   ADCCON1 __attribute__((section("sfrs"), address(0xBF84B000)));
typedef struct {
  uint32_t :3;
  uint32_t STRGLVL:1;
  uint32_t IRQVS:3;
  uint32_t :2;
  uint32_t FSPBCLKEN:1;
  uint32_t FSSCLKEN:1;
  uint32_t CVDEN:1;
  uint32_t AICPMPEN:1;
  uint32_t SIDL:1;
  uint32_t :1;
  uint32_t ON:1;
  uint32_t STRGSRC:5;
  uint32_t SELRES:2;
  uint32_t FRACT:1;
  uint32_t TRBSLV:3;
  uint32_t TRBMST:3;
  uint32_t TRBERR:1;
  uint32_t TRBEN:1;
} __ADCCON1bits_t;
extern volatile __ADCCON1bits_t ADCCON1bits __asm__ ("ADCCON1") __attribute__((section("sfrs"), address(0xBF84B000)));
#define ADCCON2 ADCCON2
extern volatile uint32_t   ADCCON2 __attribute__((section("sfrs"), address(0xBF84B004)));
typedef struct {
  uint32_t ADCDIV:7;
  uint32_t :1;
  uint32_t ADCEIS:3;
  uint32_t :1;
  uint32_t ADCEIOVR:1;
  uint32_t EOSIEN:1;
  uint32_t REFFLTIEN:1;
  uint32_t BGVRIEN:1;
  uint32_t SAMC:10;
  uint32_t CVDCPL:3;
  uint32_t EOSRDY:1;
  uint32_t REFFLT:1;
  uint32_t BGVRRDY:1;
} __ADCCON2bits_t;
extern volatile __ADCCON2bits_t ADCCON2bits __asm__ ("ADCCON2") __attribute__((section("sfrs"), address(0xBF84B004)));
#define ADCCON3 ADCCON3
extern volatile uint32_t   ADCCON3 __attribute__((section("sfrs"), address(0xBF84B008)));
typedef struct {
  uint32_t ADINSEL:6;
  uint32_t GSWTRG:1;
  uint32_t GLSWTRG:1;
  uint32_t RQCNVRT:1;
  uint32_t SAMP:1;
  uint32_t UPDRDY:1;
  uint32_t UPDIEN:1;
  uint32_t TRGSUSP:1;
  uint32_t VREFSEL:3;
  uint32_t DIGEN0:1;
  uint32_t DIGEN1:1;
  uint32_t DIGEN2:1;
  uint32_t DIGEN3:1;
  uint32_t DIGEN4:1;
  uint32_t :2;
  uint32_t DIGEN7:1;
  uint32_t CONCLKDIV:6;
  uint32_t ADCSEL:2;
} __ADCCON3bits_t;
extern volatile __ADCCON3bits_t ADCCON3bits __asm__ ("ADCCON3") __attribute__((section("sfrs"), address(0xBF84B008)));
#define ADCTRGMODE ADCTRGMODE
extern volatile uint32_t   ADCTRGMODE __attribute__((section("sfrs"), address(0xBF84B00C)));
typedef struct {
  uint32_t SSAMPEN0:1;
  uint32_t SSAMPEN1:1;
  uint32_t SSAMPEN2:1;
  uint32_t SSAMPEN3:1;
  uint32_t SSAMPEN4:1;
  uint32_t :3;
  uint32_t STRGEN0:1;
  uint32_t STRGEN1:1;
  uint32_t STRGEN2:1;
  uint32_t STRGEN3:1;
  uint32_t STRGEN4:1;
  uint32_t :3;
  uint32_t SH0ALT:2;
  uint32_t SH1ALT:2;
  uint32_t SH2ALT:2;
  uint32_t SH3ALT:2;
  uint32_t SH4ALT:2;
} __ADCTRGMODEbits_t;
extern volatile __ADCTRGMODEbits_t ADCTRGMODEbits __asm__ ("ADCTRGMODE") __attribute__((section("sfrs"), address(0xBF84B00C)));
#define ADCIMCON1 ADCIMCON1
extern volatile uint32_t   ADCIMCON1 __attribute__((section("sfrs"), address(0xBF84B010)));
typedef struct {
  uint32_t SIGN0:1;
  uint32_t DIFF0:1;
  uint32_t SIGN1:1;
  uint32_t DIFF1:1;
  uint32_t SIGN2:1;
  uint32_t DIFF2:1;
  uint32_t SIGN3:1;
  uint32_t DIFF3:1;
  uint32_t SIGN4:1;
  uint32_t DIFF4:1;
  uint32_t SIGN5:1;
  uint32_t DIFF5:1;
  uint32_t SIGN6:1;
  uint32_t DIFF6:1;
  uint32_t SIGN7:1;
  uint32_t DIFF7:1;
  uint32_t SIGN8:1;
  uint32_t DIFF8:1;
  uint32_t SIGN9:1;
  uint32_t DIFF9:1;
  uint32_t SIGN10:1;
  uint32_t DIFF10:1;
  uint32_t SIGN11:1;
  uint32_t DIFF11:1;
  uint32_t SIGN12:1;
  uint32_t DIFF12:1;
  uint32_t SIGN13:1;
  uint32_t DIFF13:1;
  uint32_t SIGN14:1;
  uint32_t DIFF14:1;
  uint32_t SIGN15:1;
  uint32_t DIFF15:1;
} __ADCIMCON1bits_t;
extern volatile __ADCIMCON1bits_t ADCIMCON1bits __asm__ ("ADCIMCON1") __attribute__((section("sfrs"), address(0xBF84B010)));
#define ADCIMCON2 ADCIMCON2
extern volatile uint32_t   ADCIMCON2 __attribute__((section("sfrs"), address(0xBF84B014)));
typedef struct {
  uint32_t SIGN16:1;
  uint32_t DIFF16:1;
  uint32_t SIGN17:1;
  uint32_t DIFF17:1;
  uint32_t SIGN18:1;
  uint32_t DIFF18:1;
} __ADCIMCON2bits_t;
extern volatile __ADCIMCON2bits_t ADCIMCON2bits __asm__ ("ADCIMCON2") __attribute__((section("sfrs"), address(0xBF84B014)));
#define ADCIMCON3 ADCIMCON3
extern volatile uint32_t   ADCIMCON3 __attribute__((section("sfrs"), address(0xBF84B018)));
typedef struct {
  uint32_t :22;
  uint32_t SIGN43:1;
  uint32_t DIFF43:1;
  uint32_t SIGN44:1;
  uint32_t DIFF44:1;
} __ADCIMCON3bits_t;
extern volatile __ADCIMCON3bits_t ADCIMCON3bits __asm__ ("ADCIMCON3") __attribute__((section("sfrs"), address(0xBF84B018)));
#define ADCGIRQEN1 ADCGIRQEN1
extern volatile uint32_t   ADCGIRQEN1 __attribute__((section("sfrs"), address(0xBF84B020)));
typedef struct {
  uint32_t AGIEN0:1;
  uint32_t AGIEN1:1;
  uint32_t AGIEN2:1;
  uint32_t AGIEN3:1;
  uint32_t AGIEN4:1;
  uint32_t AGIEN5:1;
  uint32_t AGIEN6:1;
  uint32_t AGIEN7:1;
  uint32_t AGIEN8:1;
  uint32_t AGIEN9:1;
  uint32_t AGIEN10:1;
  uint32_t AGIEN11:1;
  uint32_t AGIEN12:1;
  uint32_t AGIEN13:1;
  uint32_t AGIEN14:1;
  uint32_t AGIEN15:1;
  uint32_t AGIEN16:1;
  uint32_t AGIEN17:1;
  uint32_t AGIEN18:1;
} __ADCGIRQEN1bits_t;
extern volatile __ADCGIRQEN1bits_t ADCGIRQEN1bits __asm__ ("ADCGIRQEN1") __attribute__((section("sfrs"), address(0xBF84B020)));
#define ADCGIRQEN2 ADCGIRQEN2
extern volatile uint32_t   ADCGIRQEN2 __attribute__((section("sfrs"), address(0xBF84B024)));
typedef struct {
  uint32_t :11;
  uint32_t AGIEN43:1;
  uint32_t AGIEN44:1;
} __ADCGIRQEN2bits_t;
extern volatile __ADCGIRQEN2bits_t ADCGIRQEN2bits __asm__ ("ADCGIRQEN2") __attribute__((section("sfrs"), address(0xBF84B024)));
#define ADCCSS1 ADCCSS1
extern volatile uint32_t   ADCCSS1 __attribute__((section("sfrs"), address(0xBF84B028)));
typedef struct {
  uint32_t CSS0:1;
  uint32_t CSS1:1;
  uint32_t CSS2:1;
  uint32_t CSS3:1;
  uint32_t CSS4:1;
  uint32_t CSS5:1;
  uint32_t CSS6:1;
  uint32_t CSS7:1;
  uint32_t CSS8:1;
  uint32_t CSS9:1;
  uint32_t CSS10:1;
  uint32_t CSS11:1;
  uint32_t CSS12:1;
  uint32_t CSS13:1;
  uint32_t CSS14:1;
  uint32_t CSS15:1;
  uint32_t CSS16:1;
  uint32_t CSS17:1;
  uint32_t CSS18:1;
} __ADCCSS1bits_t;
extern volatile __ADCCSS1bits_t ADCCSS1bits __asm__ ("ADCCSS1") __attribute__((section("sfrs"), address(0xBF84B028)));
#define ADCCSS2 ADCCSS2
extern volatile uint32_t   ADCCSS2 __attribute__((section("sfrs"), address(0xBF84B02C)));
typedef struct {
  uint32_t :11;
  uint32_t CSS43:1;
  uint32_t CSS44:1;
} __ADCCSS2bits_t;
extern volatile __ADCCSS2bits_t ADCCSS2bits __asm__ ("ADCCSS2") __attribute__((section("sfrs"), address(0xBF84B02C)));
#define ADCDSTAT1 ADCDSTAT1
extern volatile uint32_t   ADCDSTAT1 __attribute__((section("sfrs"), address(0xBF84B030)));
typedef struct {
  uint32_t ARDY0:1;
  uint32_t ARDY1:1;
  uint32_t ARDY2:1;
  uint32_t ARDY3:1;
  uint32_t ARDY4:1;
  uint32_t ARDY5:1;
  uint32_t ARDY6:1;
  uint32_t ARDY7:1;
  uint32_t ARDY8:1;
  uint32_t ARDY9:1;
  uint32_t ARDY10:1;
  uint32_t ARDY11:1;
  uint32_t ARDY12:1;
  uint32_t ARDY13:1;
  uint32_t ARDY14:1;
  uint32_t ARDY15:1;
  uint32_t ARDY16:1;
  uint32_t ARDY17:1;
  uint32_t ARDY18:1;
} __ADCDSTAT1bits_t;
extern volatile __ADCDSTAT1bits_t ADCDSTAT1bits __asm__ ("ADCDSTAT1") __attribute__((section("sfrs"), address(0xBF84B030)));
#define ADCDSTAT2 ADCDSTAT2
extern volatile uint32_t   ADCDSTAT2 __attribute__((section("sfrs"), address(0xBF84B034)));
typedef struct {
  uint32_t :11;
  uint32_t ARDY43:1;
  uint32_t ARDY44:1;
} __ADCDSTAT2bits_t;
extern volatile __ADCDSTAT2bits_t ADCDSTAT2bits __asm__ ("ADCDSTAT2") __attribute__((section("sfrs"), address(0xBF84B034)));
#define ADCCMPEN1 ADCCMPEN1
extern volatile uint32_t   ADCCMPEN1 __attribute__((section("sfrs"), address(0xBF84B038)));
typedef struct {
  uint32_t CMPE0:1;
  uint32_t CMPE1:1;
  uint32_t CMPE2:1;
  uint32_t CMPE3:1;
  uint32_t CMPE4:1;
  uint32_t CMPE5:1;
  uint32_t CMPE6:1;
  uint32_t CMPE7:1;
  uint32_t CMPE8:1;
  uint32_t CMPE9:1;
  uint32_t CMPE10:1;
  uint32_t CMPE11:1;
  uint32_t CMPE12:1;
  uint32_t CMPE13:1;
  uint32_t CMPE14:1;
  uint32_t CMPE15:1;
  uint32_t CMPE16:1;
  uint32_t CMPE17:1;
  uint32_t CMPE18:1;
} __ADCCMPEN1bits_t;
extern volatile __ADCCMPEN1bits_t ADCCMPEN1bits __asm__ ("ADCCMPEN1") __attribute__((section("sfrs"), address(0xBF84B038)));
#define ADCCMP1 ADCCMP1
extern volatile uint32_t   ADCCMP1 __attribute__((section("sfrs"), address(0xBF84B03C)));
typedef struct {
  uint32_t DCMPLO:16;
  uint32_t DCMPHI:16;
} __ADCCMP1bits_t;
extern volatile __ADCCMP1bits_t ADCCMP1bits __asm__ ("ADCCMP1") __attribute__((section("sfrs"), address(0xBF84B03C)));
#define ADCCMPEN2 ADCCMPEN2
extern volatile uint32_t   ADCCMPEN2 __attribute__((section("sfrs"), address(0xBF84B040)));
typedef struct {
  uint32_t CMPE0:1;
  uint32_t CMPE1:1;
  uint32_t CMPE2:1;
  uint32_t CMPE3:1;
  uint32_t CMPE4:1;
  uint32_t CMPE5:1;
  uint32_t CMPE6:1;
  uint32_t CMPE7:1;
  uint32_t CMPE8:1;
  uint32_t CMPE9:1;
  uint32_t CMPE10:1;
  uint32_t CMPE11:1;
  uint32_t CMPE12:1;
  uint32_t CMPE13:1;
  uint32_t CMPE14:1;
  uint32_t CMPE15:1;
  uint32_t CMPE16:1;
  uint32_t CMPE17:1;
  uint32_t CMPE18:1;
} __ADCCMPEN2bits_t;
extern volatile __ADCCMPEN2bits_t ADCCMPEN2bits __asm__ ("ADCCMPEN2") __attribute__((section("sfrs"), address(0xBF84B040)));
#define ADCCMP2 ADCCMP2
extern volatile uint32_t   ADCCMP2 __attribute__((section("sfrs"), address(0xBF84B044)));
typedef struct {
  uint32_t DCMPLO:16;
  uint32_t DCMPHI:16;
} __ADCCMP2bits_t;
extern volatile __ADCCMP2bits_t ADCCMP2bits __asm__ ("ADCCMP2") __attribute__((section("sfrs"), address(0xBF84B044)));
#define ADCCMPEN3 ADCCMPEN3
extern volatile uint32_t   ADCCMPEN3 __attribute__((section("sfrs"), address(0xBF84B048)));
typedef struct {
  uint32_t CMPE0:1;
  uint32_t CMPE1:1;
  uint32_t CMPE2:1;
  uint32_t CMPE3:1;
  uint32_t CMPE4:1;
  uint32_t CMPE5:1;
  uint32_t CMPE6:1;
  uint32_t CMPE7:1;
  uint32_t CMPE8:1;
  uint32_t CMPE9:1;
  uint32_t CMPE10:1;
  uint32_t CMPE11:1;
  uint32_t CMPE12:1;
  uint32_t CMPE13:1;
  uint32_t CMPE14:1;
  uint32_t CMPE15:1;
  uint32_t CMPE16:1;
  uint32_t CMPE17:1;
  uint32_t CMPE18:1;
} __ADCCMPEN3bits_t;
extern volatile __ADCCMPEN3bits_t ADCCMPEN3bits __asm__ ("ADCCMPEN3") __attribute__((section("sfrs"), address(0xBF84B048)));
#define ADCCMP3 ADCCMP3
extern volatile uint32_t   ADCCMP3 __attribute__((section("sfrs"), address(0xBF84B04C)));
typedef struct {
  uint32_t DCMPLO:16;
  uint32_t DCMPHI:16;
} __ADCCMP3bits_t;
extern volatile __ADCCMP3bits_t ADCCMP3bits __asm__ ("ADCCMP3") __attribute__((section("sfrs"), address(0xBF84B04C)));
#define ADCCMPEN4 ADCCMPEN4
extern volatile uint32_t   ADCCMPEN4 __attribute__((section("sfrs"), address(0xBF84B050)));
typedef struct {
  uint32_t CMPE0:1;
  uint32_t CMPE1:1;
  uint32_t CMPE2:1;
  uint32_t CMPE3:1;
  uint32_t CMPE4:1;
  uint32_t CMPE5:1;
  uint32_t CMPE6:1;
  uint32_t CMPE7:1;
  uint32_t CMPE8:1;
  uint32_t CMPE9:1;
  uint32_t CMPE10:1;
  uint32_t CMPE11:1;
  uint32_t CMPE12:1;
  uint32_t CMPE13:1;
  uint32_t CMPE14:1;
  uint32_t CMPE15:1;
  uint32_t CMPE16:1;
  uint32_t CMPE17:1;
  uint32_t CMPE18:1;
} __ADCCMPEN4bits_t;
extern volatile __ADCCMPEN4bits_t ADCCMPEN4bits __asm__ ("ADCCMPEN4") __attribute__((section("sfrs"), address(0xBF84B050)));
#define ADCCMP4 ADCCMP4
extern volatile uint32_t   ADCCMP4 __attribute__((section("sfrs"), address(0xBF84B054)));
typedef struct {
  uint32_t DCMPLO:16;
  uint32_t DCMPHI:16;
} __ADCCMP4bits_t;
extern volatile __ADCCMP4bits_t ADCCMP4bits __asm__ ("ADCCMP4") __attribute__((section("sfrs"), address(0xBF84B054)));
#define ADCCMPEN5 ADCCMPEN5
extern volatile uint32_t   ADCCMPEN5 __attribute__((section("sfrs"), address(0xBF84B058)));
typedef struct {
  uint32_t CMPE0:1;
  uint32_t CMPE1:1;
  uint32_t CMPE2:1;
  uint32_t CMPE3:1;
  uint32_t CMPE4:1;
  uint32_t CMPE5:1;
  uint32_t CMPE6:1;
  uint32_t CMPE7:1;
  uint32_t CMPE8:1;
  uint32_t CMPE9:1;
  uint32_t CMPE10:1;
  uint32_t CMPE11:1;
  uint32_t CMPE12:1;
  uint32_t CMPE13:1;
  uint32_t CMPE14:1;
  uint32_t CMPE15:1;
  uint32_t CMPE16:1;
  uint32_t CMPE17:1;
  uint32_t CMPE18:1;
} __ADCCMPEN5bits_t;
extern volatile __ADCCMPEN5bits_t ADCCMPEN5bits __asm__ ("ADCCMPEN5") __attribute__((section("sfrs"), address(0xBF84B058)));
#define ADCCMP5 ADCCMP5
extern volatile uint32_t   ADCCMP5 __attribute__((section("sfrs"), address(0xBF84B05C)));
typedef struct {
  uint32_t DCMPLO:16;
  uint32_t DCMPHI:16;
} __ADCCMP5bits_t;
extern volatile __ADCCMP5bits_t ADCCMP5bits __asm__ ("ADCCMP5") __attribute__((section("sfrs"), address(0xBF84B05C)));
#define ADCCMPEN6 ADCCMPEN6
extern volatile uint32_t   ADCCMPEN6 __attribute__((section("sfrs"), address(0xBF84B060)));
typedef struct {
  uint32_t CMPE0:1;
  uint32_t CMPE1:1;
  uint32_t CMPE2:1;
  uint32_t CMPE3:1;
  uint32_t CMPE4:1;
  uint32_t CMPE5:1;
  uint32_t CMPE6:1;
  uint32_t CMPE7:1;
  uint32_t CMPE8:1;
  uint32_t CMPE9:1;
  uint32_t CMPE10:1;
  uint32_t CMPE11:1;
  uint32_t CMPE12:1;
  uint32_t CMPE13:1;
  uint32_t CMPE14:1;
  uint32_t CMPE15:1;
  uint32_t CMPE16:1;
  uint32_t CMPE17:1;
  uint32_t CMPE18:1;
} __ADCCMPEN6bits_t;
extern volatile __ADCCMPEN6bits_t ADCCMPEN6bits __asm__ ("ADCCMPEN6") __attribute__((section("sfrs"), address(0xBF84B060)));
#define ADCCMP6 ADCCMP6
extern volatile uint32_t   ADCCMP6 __attribute__((section("sfrs"), address(0xBF84B064)));
typedef struct {
  uint32_t DCMPLO:16;
  uint32_t DCMPHI:16;
} __ADCCMP6bits_t;
extern volatile __ADCCMP6bits_t ADCCMP6bits __asm__ ("ADCCMP6") __attribute__((section("sfrs"), address(0xBF84B064)));
#define ADCFLTR1 ADCFLTR1
extern volatile uint32_t   ADCFLTR1 __attribute__((section("sfrs"), address(0xBF84B068)));
typedef struct {
  uint32_t FLTRDATA:16;
  uint32_t CHNLID:5;
  uint32_t :3;
  uint32_t AFRDY:1;
  uint32_t AFGIEN:1;
  uint32_t OVRSAM:3;
  uint32_t DFMODE:1;
  uint32_t DATA16EN:1;
  uint32_t AFEN:1;
} __ADCFLTR1bits_t;
extern volatile __ADCFLTR1bits_t ADCFLTR1bits __asm__ ("ADCFLTR1") __attribute__((section("sfrs"), address(0xBF84B068)));
#define ADCFLTR2 ADCFLTR2
extern volatile uint32_t   ADCFLTR2 __attribute__((section("sfrs"), address(0xBF84B06C)));
typedef struct {
  uint32_t FLTRDATA:16;
  uint32_t CHNLID:5;
  uint32_t :3;
  uint32_t AFRDY:1;
  uint32_t AFGIEN:1;
  uint32_t OVRSAM:3;
  uint32_t DFMODE:1;
  uint32_t DATA16EN:1;
  uint32_t AFEN:1;
} __ADCFLTR2bits_t;
extern volatile __ADCFLTR2bits_t ADCFLTR2bits __asm__ ("ADCFLTR2") __attribute__((section("sfrs"), address(0xBF84B06C)));
#define ADCFLTR3 ADCFLTR3
extern volatile uint32_t   ADCFLTR3 __attribute__((section("sfrs"), address(0xBF84B070)));
typedef struct {
  uint32_t FLTRDATA:16;
  uint32_t CHNLID:5;
  uint32_t :3;
  uint32_t AFRDY:1;
  uint32_t AFGIEN:1;
  uint32_t OVRSAM:3;
  uint32_t DFMODE:1;
  uint32_t DATA16EN:1;
  uint32_t AFEN:1;
} __ADCFLTR3bits_t;
extern volatile __ADCFLTR3bits_t ADCFLTR3bits __asm__ ("ADCFLTR3") __attribute__((section("sfrs"), address(0xBF84B070)));
#define ADCFLTR4 ADCFLTR4
extern volatile uint32_t   ADCFLTR4 __attribute__((section("sfrs"), address(0xBF84B074)));
typedef struct {
  uint32_t FLTRDATA:16;
  uint32_t CHNLID:5;
  uint32_t :3;
  uint32_t AFRDY:1;
  uint32_t AFGIEN:1;
  uint32_t OVRSAM:3;
  uint32_t DFMODE:1;
  uint32_t DATA16EN:1;
  uint32_t AFEN:1;
} __ADCFLTR4bits_t;
extern volatile __ADCFLTR4bits_t ADCFLTR4bits __asm__ ("ADCFLTR4") __attribute__((section("sfrs"), address(0xBF84B074)));
#define ADCFLTR5 ADCFLTR5
extern volatile uint32_t   ADCFLTR5 __attribute__((section("sfrs"), address(0xBF84B078)));
typedef struct {
  uint32_t FLTRDATA:16;
  uint32_t CHNLID:5;
  uint32_t :3;
  uint32_t AFRDY:1;
  uint32_t AFGIEN:1;
  uint32_t OVRSAM:3;
  uint32_t DFMODE:1;
  uint32_t DATA16EN:1;
  uint32_t AFEN:1;
} __ADCFLTR5bits_t;
extern volatile __ADCFLTR5bits_t ADCFLTR5bits __asm__ ("ADCFLTR5") __attribute__((section("sfrs"), address(0xBF84B078)));
#define ADCFLTR6 ADCFLTR6
extern volatile uint32_t   ADCFLTR6 __attribute__((section("sfrs"), address(0xBF84B07C)));
typedef struct {
  uint32_t FLTRDATA:16;
  uint32_t CHNLID:5;
  uint32_t :3;
  uint32_t AFRDY:1;
  uint32_t AFGIEN:1;
  uint32_t OVRSAM:3;
  uint32_t DFMODE:1;
  uint32_t DATA16EN:1;
  uint32_t AFEN:1;
} __ADCFLTR6bits_t;
extern volatile __ADCFLTR6bits_t ADCFLTR6bits __asm__ ("ADCFLTR6") __attribute__((section("sfrs"), address(0xBF84B07C)));
#define ADCTRG1 ADCTRG1
extern volatile uint32_t   ADCTRG1 __attribute__((section("sfrs"), address(0xBF84B080)));
typedef struct {
  uint32_t TRGSRC0:5;
  uint32_t :3;
  uint32_t TRGSRC1:5;
  uint32_t :3;
  uint32_t TRGSRC2:5;
  uint32_t :3;
  uint32_t TRGSRC3:5;
} __ADCTRG1bits_t;
extern volatile __ADCTRG1bits_t ADCTRG1bits __asm__ ("ADCTRG1") __attribute__((section("sfrs"), address(0xBF84B080)));
#define ADCTRG2 ADCTRG2
extern volatile uint32_t   ADCTRG2 __attribute__((section("sfrs"), address(0xBF84B084)));
typedef struct {
  uint32_t TRGSRC4:5;
  uint32_t :3;
  uint32_t TRGSRC5:5;
  uint32_t :3;
  uint32_t TRGSRC6:5;
  uint32_t :3;
  uint32_t TRGSRC7:5;
} __ADCTRG2bits_t;
extern volatile __ADCTRG2bits_t ADCTRG2bits __asm__ ("ADCTRG2") __attribute__((section("sfrs"), address(0xBF84B084)));
#define ADCTRG3 ADCTRG3
extern volatile uint32_t   ADCTRG3 __attribute__((section("sfrs"), address(0xBF84B088)));
typedef struct {
  uint32_t TRGSRC8:5;
  uint32_t :3;
  uint32_t TRGSRC9:5;
  uint32_t :3;
  uint32_t TRGSRC10:5;
  uint32_t :3;
  uint32_t TRGSRC11:5;
} __ADCTRG3bits_t;
extern volatile __ADCTRG3bits_t ADCTRG3bits __asm__ ("ADCTRG3") __attribute__((section("sfrs"), address(0xBF84B088)));
#define ADCCMPCON1 ADCCMPCON1
extern volatile uint32_t   ADCCMPCON1 __attribute__((section("sfrs"), address(0xBF84B0A0)));
typedef struct {
  uint32_t IELOLO:1;
  uint32_t IELOHI:1;
  uint32_t IEHILO:1;
  uint32_t IEHIHI:1;
  uint32_t IEBTWN:1;
  uint32_t DCMPED:1;
  uint32_t DCMPGIEN:1;
  uint32_t ENDCMP:1;
  uint32_t AINID:6;
  uint32_t :2;
  uint32_t CVDDATA:16;
} __ADCCMPCON1bits_t;
extern volatile __ADCCMPCON1bits_t ADCCMPCON1bits __asm__ ("ADCCMPCON1") __attribute__((section("sfrs"), address(0xBF84B0A0)));
#define ADCCMPCON2 ADCCMPCON2
extern volatile uint32_t   ADCCMPCON2 __attribute__((section("sfrs"), address(0xBF84B0A4)));
typedef struct {
  uint32_t IELOLO:1;
  uint32_t IELOHI:1;
  uint32_t IEHILO:1;
  uint32_t IEHIHI:1;
  uint32_t IEBTWN:1;
  uint32_t DCMPED:1;
  uint32_t DCMPGIEN:1;
  uint32_t ENDCMP:1;
  uint32_t AINID:5;
} __ADCCMPCON2bits_t;
extern volatile __ADCCMPCON2bits_t ADCCMPCON2bits __asm__ ("ADCCMPCON2") __attribute__((section("sfrs"), address(0xBF84B0A4)));
#define ADCCMPCON3 ADCCMPCON3
extern volatile uint32_t   ADCCMPCON3 __attribute__((section("sfrs"), address(0xBF84B0A8)));
typedef struct {
  uint32_t IELOLO:1;
  uint32_t IELOHI:1;
  uint32_t IEHILO:1;
  uint32_t IEHIHI:1;
  uint32_t IEBTWN:1;
  uint32_t DCMPED:1;
  uint32_t DCMPGIEN:1;
  uint32_t ENDCMP:1;
  uint32_t AINID:5;
} __ADCCMPCON3bits_t;
extern volatile __ADCCMPCON3bits_t ADCCMPCON3bits __asm__ ("ADCCMPCON3") __attribute__((section("sfrs"), address(0xBF84B0A8)));
#define ADCCMPCON4 ADCCMPCON4
extern volatile uint32_t   ADCCMPCON4 __attribute__((section("sfrs"), address(0xBF84B0AC)));
typedef struct {
  uint32_t IELOLO:1;
  uint32_t IELOHI:1;
  uint32_t IEHILO:1;
  uint32_t IEHIHI:1;
  uint32_t IEBTWN:1;
  uint32_t DCMPED:1;
  uint32_t DCMPGIEN:1;
  uint32_t ENDCMP:1;
  uint32_t AINID:5;
} __ADCCMPCON4bits_t;
extern volatile __ADCCMPCON4bits_t ADCCMPCON4bits __asm__ ("ADCCMPCON4") __attribute__((section("sfrs"), address(0xBF84B0AC)));
#define ADCCMPCON5 ADCCMPCON5
extern volatile uint32_t   ADCCMPCON5 __attribute__((section("sfrs"), address(0xBF84B0B0)));
typedef struct {
  uint32_t IELOLO:1;
  uint32_t IELOHI:1;
  uint32_t IEHILO:1;
  uint32_t IEHIHI:1;
  uint32_t IEBTWN:1;
  uint32_t DCMPED:1;
  uint32_t DCMPGIEN:1;
  uint32_t ENDCMP:1;
  uint32_t AINID:5;
} __ADCCMPCON5bits_t;
extern volatile __ADCCMPCON5bits_t ADCCMPCON5bits __asm__ ("ADCCMPCON5") __attribute__((section("sfrs"), address(0xBF84B0B0)));
#define ADCCMPCON6 ADCCMPCON6
extern volatile uint32_t   ADCCMPCON6 __attribute__((section("sfrs"), address(0xBF84B0B4)));
typedef struct {
  uint32_t IELOLO:1;
  uint32_t IELOHI:1;
  uint32_t IEHILO:1;
  uint32_t IEHIHI:1;
  uint32_t IEBTWN:1;
  uint32_t DCMPED:1;
  uint32_t DCMPGIEN:1;
  uint32_t ENDCMP:1;
  uint32_t AINID:5;
} __ADCCMPCON6bits_t;
extern volatile __ADCCMPCON6bits_t ADCCMPCON6bits __asm__ ("ADCCMPCON6") __attribute__((section("sfrs"), address(0xBF84B0B4)));
#define ADCFSTAT ADCFSTAT
extern volatile uint32_t   ADCFSTAT __attribute__((section("sfrs"), address(0xBF84B0B8)));
typedef struct {
  uint32_t ADCID:3;
  uint32_t :4;
  uint32_t FSIGN:1;
  uint32_t FCNT:8;
  uint32_t :5;
  uint32_t FWROVERR:1;
  uint32_t FRDY:1;
  uint32_t FIEN:1;
  uint32_t ADC0EN:1;
  uint32_t ADC1EN:1;
  uint32_t ADC2EN:1;
  uint32_t ADC3EN:1;
  uint32_t ADC4EN:1;
  uint32_t :2;
  uint32_t FEN:1;
} __ADCFSTATbits_t;
extern volatile __ADCFSTATbits_t ADCFSTATbits __asm__ ("ADCFSTAT") __attribute__((section("sfrs"), address(0xBF84B0B8)));
#define ADCFIFO ADCFIFO
extern volatile uint32_t   ADCFIFO __attribute__((section("sfrs"), address(0xBF84B0BC)));
typedef struct {
  uint32_t DATA:32;
} __ADCFIFObits_t;
extern volatile __ADCFIFObits_t ADCFIFObits __asm__ ("ADCFIFO") __attribute__((section("sfrs"), address(0xBF84B0BC)));
#define ADCBASE ADCBASE
extern volatile uint32_t   ADCBASE __attribute__((section("sfrs"), address(0xBF84B0C0)));
typedef struct {
  uint32_t ADCBASE:16;
} __ADCBASEbits_t;
extern volatile __ADCBASEbits_t ADCBASEbits __asm__ ("ADCBASE") __attribute__((section("sfrs"), address(0xBF84B0C0)));
#define ADCTRGSNS ADCTRGSNS
extern volatile uint32_t   ADCTRGSNS __attribute__((section("sfrs"), address(0xBF84B0D0)));
typedef struct {
  uint32_t LVL0:1;
  uint32_t LVL1:1;
  uint32_t LVL2:1;
  uint32_t LVL3:1;
  uint32_t LVL4:1;
  uint32_t LVL5:1;
  uint32_t LVL6:1;
  uint32_t LVL7:1;
  uint32_t LVL8:1;
  uint32_t LVL9:1;
  uint32_t LVL10:1;
  uint32_t LVL11:1;
} __ADCTRGSNSbits_t;
extern volatile __ADCTRGSNSbits_t ADCTRGSNSbits __asm__ ("ADCTRGSNS") __attribute__((section("sfrs"), address(0xBF84B0D0)));
#define ADC0TIME ADC0TIME
extern volatile uint32_t   ADC0TIME __attribute__((section("sfrs"), address(0xBF84B0D4)));
typedef struct {
  uint32_t SAMC:10;
  uint32_t :6;
  uint32_t ADCDIV:7;
  uint32_t :1;
  uint32_t SELRES:2;
  uint32_t ADCEIS:3;
} __ADC0TIMEbits_t;
extern volatile __ADC0TIMEbits_t ADC0TIMEbits __asm__ ("ADC0TIME") __attribute__((section("sfrs"), address(0xBF84B0D4)));
#define ADC1TIME ADC1TIME
extern volatile uint32_t   ADC1TIME __attribute__((section("sfrs"), address(0xBF84B0D8)));
typedef struct {
  uint32_t SAMC:10;
  uint32_t :6;
  uint32_t ADCDIV:7;
  uint32_t :1;
  uint32_t SELRES:2;
  uint32_t ADCEIS:3;
} __ADC1TIMEbits_t;
extern volatile __ADC1TIMEbits_t ADC1TIMEbits __asm__ ("ADC1TIME") __attribute__((section("sfrs"), address(0xBF84B0D8)));
#define ADC2TIME ADC2TIME
extern volatile uint32_t   ADC2TIME __attribute__((section("sfrs"), address(0xBF84B0DC)));
typedef struct {
  uint32_t SAMC:10;
  uint32_t :6;
  uint32_t ADCDIV:7;
  uint32_t :1;
  uint32_t SELRES:2;
  uint32_t ADCEIS:3;
} __ADC2TIMEbits_t;
extern volatile __ADC2TIMEbits_t ADC2TIMEbits __asm__ ("ADC2TIME") __attribute__((section("sfrs"), address(0xBF84B0DC)));
#define ADC3TIME ADC3TIME
extern volatile uint32_t   ADC3TIME __attribute__((section("sfrs"), address(0xBF84B0E0)));
typedef struct {
  uint32_t SAMC:10;
  uint32_t :6;
  uint32_t ADCDIV:7;
  uint32_t :1;
  uint32_t SELRES:2;
  uint32_t ADCEIS:3;
} __ADC3TIMEbits_t;
extern volatile __ADC3TIMEbits_t ADC3TIMEbits __asm__ ("ADC3TIME") __attribute__((section("sfrs"), address(0xBF84B0E0)));
#define ADC4TIME ADC4TIME
extern volatile uint32_t   ADC4TIME __attribute__((section("sfrs"), address(0xBF84B0E4)));
typedef struct {
  uint32_t SAMC:10;
  uint32_t :6;
  uint32_t ADCDIV:7;
  uint32_t :1;
  uint32_t SELRES:2;
  uint32_t ADCEIS:3;
} __ADC4TIMEbits_t;
extern volatile __ADC4TIMEbits_t ADC4TIMEbits __asm__ ("ADC4TIME") __attribute__((section("sfrs"), address(0xBF84B0E4)));
#define ADCEIEN1 ADCEIEN1
extern volatile uint32_t   ADCEIEN1 __attribute__((section("sfrs"), address(0xBF84B0F0)));
typedef struct {
  uint32_t EIEN0:1;
  uint32_t EIEN1:1;
  uint32_t EIEN2:1;
  uint32_t EIEN3:1;
  uint32_t EIEN4:1;
  uint32_t EIEN5:1;
  uint32_t EIEN6:1;
  uint32_t EIEN7:1;
  uint32_t EIEN8:1;
  uint32_t EIEN9:1;
  uint32_t EIEN10:1;
  uint32_t EIEN11:1;
  uint32_t EIEN12:1;
  uint32_t EIEN13:1;
  uint32_t EIEN14:1;
  uint32_t EIEN15:1;
  uint32_t EIEN16:1;
  uint32_t EIEN17:1;
  uint32_t EIEN18:1;
} __ADCEIEN1bits_t;
extern volatile __ADCEIEN1bits_t ADCEIEN1bits __asm__ ("ADCEIEN1") __attribute__((section("sfrs"), address(0xBF84B0F0)));
#define ADCEIEN2 ADCEIEN2
extern volatile uint32_t   ADCEIEN2 __attribute__((section("sfrs"), address(0xBF84B0F4)));
typedef struct {
  uint32_t :11;
  uint32_t EIEN43:1;
  uint32_t EIEN44:1;
} __ADCEIEN2bits_t;
extern volatile __ADCEIEN2bits_t ADCEIEN2bits __asm__ ("ADCEIEN2") __attribute__((section("sfrs"), address(0xBF84B0F4)));
#define ADCEISTAT1 ADCEISTAT1
extern volatile uint32_t   ADCEISTAT1 __attribute__((section("sfrs"), address(0xBF84B0F8)));
typedef struct {
  uint32_t EIRDY0:1;
  uint32_t EIRDY1:1;
  uint32_t EIRDY2:1;
  uint32_t EIRDY3:1;
  uint32_t EIRDY4:1;
  uint32_t EIRDY5:1;
  uint32_t EIRDY6:1;
  uint32_t EIRDY7:1;
  uint32_t EIRDY8:1;
  uint32_t EIRDY9:1;
  uint32_t EIRDY10:1;
  uint32_t EIRDY11:1;
  uint32_t EIRDY12:1;
  uint32_t EIRDY13:1;
  uint32_t EIRDY14:1;
  uint32_t EIRDY15:1;
  uint32_t EIRDY16:1;
  uint32_t EIRDY17:1;
  uint32_t EIRDY18:1;
} __ADCEISTAT1bits_t;
extern volatile __ADCEISTAT1bits_t ADCEISTAT1bits __asm__ ("ADCEISTAT1") __attribute__((section("sfrs"), address(0xBF84B0F8)));
#define ADCEISTAT2 ADCEISTAT2
extern volatile uint32_t   ADCEISTAT2 __attribute__((section("sfrs"), address(0xBF84B0FC)));
typedef struct {
  uint32_t :11;
  uint32_t EIRDY43:1;
  uint32_t EIRDY44:1;
} __ADCEISTAT2bits_t;
extern volatile __ADCEISTAT2bits_t ADCEISTAT2bits __asm__ ("ADCEISTAT2") __attribute__((section("sfrs"), address(0xBF84B0FC)));
#define ADCANCON ADCANCON
extern volatile uint32_t   ADCANCON __attribute__((section("sfrs"), address(0xBF84B100)));
typedef struct {
  uint32_t ANEN0:1;
  uint32_t ANEN1:1;
  uint32_t ANEN2:1;
  uint32_t ANEN3:1;
  uint32_t ANEN4:1;
  uint32_t :2;
  uint32_t ANEN7:1;
  uint32_t WKRDY0:1;
  uint32_t WKRDY1:1;
  uint32_t WKRDY2:1;
  uint32_t WKRDY3:1;
  uint32_t WKRDY4:1;
  uint32_t :2;
  uint32_t WKRDY7:1;
  uint32_t WKIEN0:1;
  uint32_t WKIEN1:1;
  uint32_t WKIEN2:1;
  uint32_t WKIEN3:1;
  uint32_t WKIEN4:1;
  uint32_t :2;
  uint32_t WKIEN7:1;
  uint32_t WKUPCLKCNT:4;
} __ADCANCONbits_t;
extern volatile __ADCANCONbits_t ADCANCONbits __asm__ ("ADCANCON") __attribute__((section("sfrs"), address(0xBF84B100)));
#define ADC0CFG ADC0CFG
extern volatile uint32_t   ADC0CFG __attribute__((section("sfrs"), address(0xBF84B180)));
typedef struct {
  uint32_t ADCCFG:32;
} __ADC0CFGbits_t;
extern volatile __ADC0CFGbits_t ADC0CFGbits __asm__ ("ADC0CFG") __attribute__((section("sfrs"), address(0xBF84B180)));
#define ADC1CFG ADC1CFG
extern volatile uint32_t   ADC1CFG __attribute__((section("sfrs"), address(0xBF84B184)));
typedef struct {
  uint32_t ADCCFG:32;
} __ADC1CFGbits_t;
extern volatile __ADC1CFGbits_t ADC1CFGbits __asm__ ("ADC1CFG") __attribute__((section("sfrs"), address(0xBF84B184)));
#define ADC2CFG ADC2CFG
extern volatile uint32_t   ADC2CFG __attribute__((section("sfrs"), address(0xBF84B188)));
typedef struct {
  uint32_t ADCCFG:32;
} __ADC2CFGbits_t;
extern volatile __ADC2CFGbits_t ADC2CFGbits __asm__ ("ADC2CFG") __attribute__((section("sfrs"), address(0xBF84B188)));
#define ADC3CFG ADC3CFG
extern volatile uint32_t   ADC3CFG __attribute__((section("sfrs"), address(0xBF84B18C)));
typedef struct {
  uint32_t ADCCFG:32;
} __ADC3CFGbits_t;
extern volatile __ADC3CFGbits_t ADC3CFGbits __asm__ ("ADC3CFG") __attribute__((section("sfrs"), address(0xBF84B18C)));
#define ADC4CFG ADC4CFG
extern volatile uint32_t   ADC4CFG __attribute__((section("sfrs"), address(0xBF84B190)));
typedef struct {
  uint32_t ADCCFG:32;
} __ADC4CFGbits_t;
extern volatile __ADC4CFGbits_t ADC4CFGbits __asm__ ("ADC4CFG") __attribute__((section("sfrs"), address(0xBF84B190)));
#define ADC7CFG ADC7CFG
extern volatile uint32_t   ADC7CFG __attribute__((section("sfrs"), address(0xBF84B19C)));
typedef struct {
  uint32_t ADCCFG:32;
} __ADC7CFGbits_t;
extern volatile __ADC7CFGbits_t ADC7CFGbits __asm__ ("ADC7CFG") __attribute__((section("sfrs"), address(0xBF84B19C)));
#define ADCSYSCFG0 ADCSYSCFG0
extern volatile uint32_t   ADCSYSCFG0 __attribute__((section("sfrs"), address(0xBF84B1C0)));
typedef struct {
  uint32_t AN0:1;
  uint32_t AN1:1;
  uint32_t AN2:1;
  uint32_t AN3:1;
  uint32_t AN4:1;
  uint32_t AN5:1;
  uint32_t AN6:1;
  uint32_t AN7:1;
  uint32_t AN8:1;
  uint32_t AN9:1;
  uint32_t AN10:1;
  uint32_t AN11:1;
  uint32_t AN12:1;
  uint32_t AN13:1;
  uint32_t AN14:1;
  uint32_t AN15:1;
  uint32_t AN16:1;
  uint32_t AN17:1;
  uint32_t AN18:1;
  uint32_t AN19:1;
  uint32_t AN20:1;
  uint32_t AN21:1;
  uint32_t AN22:1;
  uint32_t AN23:1;
  uint32_t AN24:1;
  uint32_t AN25:1;
  uint32_t AN26:1;
  uint32_t AN27:1;
  uint32_t AN28:1;
  uint32_t AN29:1;
  uint32_t AN30:1;
  uint32_t AN31:1;
} __ADCSYSCFG0bits_t;
extern volatile __ADCSYSCFG0bits_t ADCSYSCFG0bits __asm__ ("ADCSYSCFG0") __attribute__((section("sfrs"), address(0xBF84B1C0)));
#define ADCSYSCFG1 ADCSYSCFG1
extern volatile uint32_t   ADCSYSCFG1 __attribute__((section("sfrs"), address(0xBF84B1C4)));
typedef struct {
  uint32_t AN32:1;
  uint32_t AN33:1;
  uint32_t AN34:1;
  uint32_t AN35:1;
  uint32_t AN36:1;
  uint32_t AN37:1;
  uint32_t AN38:1;
  uint32_t AN39:1;
  uint32_t AN40:1;
  uint32_t AN41:1;
  uint32_t AN42:1;
  uint32_t AN43:1;
  uint32_t AN44:1;
  uint32_t AN45:1;
  uint32_t AN46:1;
  uint32_t AN47:1;
  uint32_t AN48:1;
  uint32_t AN49:1;
  uint32_t AN50:1;
  uint32_t AN51:1;
  uint32_t AN52:1;
  uint32_t AN53:1;
  uint32_t AN54:1;
  uint32_t AN55:1;
  uint32_t AN56:1;
  uint32_t AN57:1;
  uint32_t AN58:1;
  uint32_t AN59:1;
  uint32_t AN60:1;
  uint32_t AN61:1;
  uint32_t AN62:1;
  uint32_t AN63:1;
} __ADCSYSCFG1bits_t;
extern volatile __ADCSYSCFG1bits_t ADCSYSCFG1bits __asm__ ("ADCSYSCFG1") __attribute__((section("sfrs"), address(0xBF84B1C4)));
#define ADCDATA0 ADCDATA0
extern volatile uint32_t   ADCDATA0 __attribute__((section("sfrs"), address(0xBF84B200)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA0bits_t;
extern volatile __ADCDATA0bits_t ADCDATA0bits __asm__ ("ADCDATA0") __attribute__((section("sfrs"), address(0xBF84B200)));
#define ADCDATA1 ADCDATA1
extern volatile uint32_t   ADCDATA1 __attribute__((section("sfrs"), address(0xBF84B204)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA1bits_t;
extern volatile __ADCDATA1bits_t ADCDATA1bits __asm__ ("ADCDATA1") __attribute__((section("sfrs"), address(0xBF84B204)));
#define ADCDATA2 ADCDATA2
extern volatile uint32_t   ADCDATA2 __attribute__((section("sfrs"), address(0xBF84B208)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA2bits_t;
extern volatile __ADCDATA2bits_t ADCDATA2bits __asm__ ("ADCDATA2") __attribute__((section("sfrs"), address(0xBF84B208)));
#define ADCDATA3 ADCDATA3
extern volatile uint32_t   ADCDATA3 __attribute__((section("sfrs"), address(0xBF84B20C)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA3bits_t;
extern volatile __ADCDATA3bits_t ADCDATA3bits __asm__ ("ADCDATA3") __attribute__((section("sfrs"), address(0xBF84B20C)));
#define ADCDATA4 ADCDATA4
extern volatile uint32_t   ADCDATA4 __attribute__((section("sfrs"), address(0xBF84B210)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA4bits_t;
extern volatile __ADCDATA4bits_t ADCDATA4bits __asm__ ("ADCDATA4") __attribute__((section("sfrs"), address(0xBF84B210)));
#define ADCDATA5 ADCDATA5
extern volatile uint32_t   ADCDATA5 __attribute__((section("sfrs"), address(0xBF84B214)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA5bits_t;
extern volatile __ADCDATA5bits_t ADCDATA5bits __asm__ ("ADCDATA5") __attribute__((section("sfrs"), address(0xBF84B214)));
#define ADCDATA6 ADCDATA6
extern volatile uint32_t   ADCDATA6 __attribute__((section("sfrs"), address(0xBF84B218)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA6bits_t;
extern volatile __ADCDATA6bits_t ADCDATA6bits __asm__ ("ADCDATA6") __attribute__((section("sfrs"), address(0xBF84B218)));
#define ADCDATA7 ADCDATA7
extern volatile uint32_t   ADCDATA7 __attribute__((section("sfrs"), address(0xBF84B21C)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA7bits_t;
extern volatile __ADCDATA7bits_t ADCDATA7bits __asm__ ("ADCDATA7") __attribute__((section("sfrs"), address(0xBF84B21C)));
#define ADCDATA8 ADCDATA8
extern volatile uint32_t   ADCDATA8 __attribute__((section("sfrs"), address(0xBF84B220)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA8bits_t;
extern volatile __ADCDATA8bits_t ADCDATA8bits __asm__ ("ADCDATA8") __attribute__((section("sfrs"), address(0xBF84B220)));
#define ADCDATA9 ADCDATA9
extern volatile uint32_t   ADCDATA9 __attribute__((section("sfrs"), address(0xBF84B224)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA9bits_t;
extern volatile __ADCDATA9bits_t ADCDATA9bits __asm__ ("ADCDATA9") __attribute__((section("sfrs"), address(0xBF84B224)));
#define ADCDATA10 ADCDATA10
extern volatile uint32_t   ADCDATA10 __attribute__((section("sfrs"), address(0xBF84B228)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA10bits_t;
extern volatile __ADCDATA10bits_t ADCDATA10bits __asm__ ("ADCDATA10") __attribute__((section("sfrs"), address(0xBF84B228)));
#define ADCDATA11 ADCDATA11
extern volatile uint32_t   ADCDATA11 __attribute__((section("sfrs"), address(0xBF84B22C)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA11bits_t;
extern volatile __ADCDATA11bits_t ADCDATA11bits __asm__ ("ADCDATA11") __attribute__((section("sfrs"), address(0xBF84B22C)));
#define ADCDATA12 ADCDATA12
extern volatile uint32_t   ADCDATA12 __attribute__((section("sfrs"), address(0xBF84B230)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA12bits_t;
extern volatile __ADCDATA12bits_t ADCDATA12bits __asm__ ("ADCDATA12") __attribute__((section("sfrs"), address(0xBF84B230)));
#define ADCDATA13 ADCDATA13
extern volatile uint32_t   ADCDATA13 __attribute__((section("sfrs"), address(0xBF84B234)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA13bits_t;
extern volatile __ADCDATA13bits_t ADCDATA13bits __asm__ ("ADCDATA13") __attribute__((section("sfrs"), address(0xBF84B234)));
#define ADCDATA14 ADCDATA14
extern volatile uint32_t   ADCDATA14 __attribute__((section("sfrs"), address(0xBF84B238)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA14bits_t;
extern volatile __ADCDATA14bits_t ADCDATA14bits __asm__ ("ADCDATA14") __attribute__((section("sfrs"), address(0xBF84B238)));
#define ADCDATA15 ADCDATA15
extern volatile uint32_t   ADCDATA15 __attribute__((section("sfrs"), address(0xBF84B23C)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA15bits_t;
extern volatile __ADCDATA15bits_t ADCDATA15bits __asm__ ("ADCDATA15") __attribute__((section("sfrs"), address(0xBF84B23C)));
#define ADCDATA16 ADCDATA16
extern volatile uint32_t   ADCDATA16 __attribute__((section("sfrs"), address(0xBF84B240)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA16bits_t;
extern volatile __ADCDATA16bits_t ADCDATA16bits __asm__ ("ADCDATA16") __attribute__((section("sfrs"), address(0xBF84B240)));
#define ADCDATA17 ADCDATA17
extern volatile uint32_t   ADCDATA17 __attribute__((section("sfrs"), address(0xBF84B244)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA17bits_t;
extern volatile __ADCDATA17bits_t ADCDATA17bits __asm__ ("ADCDATA17") __attribute__((section("sfrs"), address(0xBF84B244)));
#define ADCDATA18 ADCDATA18
extern volatile uint32_t   ADCDATA18 __attribute__((section("sfrs"), address(0xBF84B248)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA18bits_t;
extern volatile __ADCDATA18bits_t ADCDATA18bits __asm__ ("ADCDATA18") __attribute__((section("sfrs"), address(0xBF84B248)));
#define ADCDATA43 ADCDATA43
extern volatile uint32_t   ADCDATA43 __attribute__((section("sfrs"), address(0xBF84B2AC)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA43bits_t;
extern volatile __ADCDATA43bits_t ADCDATA43bits __asm__ ("ADCDATA43") __attribute__((section("sfrs"), address(0xBF84B2AC)));
#define ADCDATA44 ADCDATA44
extern volatile uint32_t   ADCDATA44 __attribute__((section("sfrs"), address(0xBF84B2B0)));
typedef struct {
  uint32_t DATA:32;
} __ADCDATA44bits_t;
extern volatile __ADCDATA44bits_t ADCDATA44bits __asm__ ("ADCDATA44") __attribute__((section("sfrs"), address(0xBF84B2B0)));
#define CM1CON CM1CON
extern volatile uint32_t   CM1CON __attribute__((section("sfrs"), address(0xBF84C000)));
typedef union {
  struct {
    uint32_t CCH:2;
    uint32_t :2;
    uint32_t CREF:1;
    uint32_t :1;
    uint32_t EVPOL:2;
    uint32_t COUT:1;
    uint32_t :4;
    uint32_t CPOL:1;
    uint32_t COE:1;
    uint32_t ON:1;
  };
  struct {
    uint32_t CCH0:1;
    uint32_t CCH1:1;
    uint32_t :4;
    uint32_t EVPOL0:1;
    uint32_t EVPOL1:1;
  };
  struct {
    uint32_t w:32;
  };
} __CM1CONbits_t;
extern volatile __CM1CONbits_t CM1CONbits __asm__ ("CM1CON") __attribute__((section("sfrs"), address(0xBF84C000)));
extern volatile uint32_t        CM1CONCLR __attribute__((section("sfrs"),address(0xBF84C004)));
extern volatile uint32_t        CM1CONSET __attribute__((section("sfrs"),address(0xBF84C008)));
extern volatile uint32_t        CM1CONINV __attribute__((section("sfrs"),address(0xBF84C00C)));
#define CM2CON CM2CON
extern volatile uint32_t   CM2CON __attribute__((section("sfrs"), address(0xBF84C010)));
typedef union {
  struct {
    uint32_t CCH:2;
    uint32_t :2;
    uint32_t CREF:1;
    uint32_t :1;
    uint32_t EVPOL:2;
    uint32_t COUT:1;
    uint32_t :4;
    uint32_t CPOL:1;
    uint32_t COE:1;
    uint32_t ON:1;
  };
  struct {
    uint32_t CCH0:1;
    uint32_t CCH1:1;
    uint32_t :4;
    uint32_t EVPOL0:1;
    uint32_t EVPOL1:1;
  };
  struct {
    uint32_t w:32;
  };
} __CM2CONbits_t;
extern volatile __CM2CONbits_t CM2CONbits __asm__ ("CM2CON") __attribute__((section("sfrs"), address(0xBF84C010)));
extern volatile uint32_t        CM2CONCLR __attribute__((section("sfrs"),address(0xBF84C014)));
extern volatile uint32_t        CM2CONSET __attribute__((section("sfrs"),address(0xBF84C018)));
extern volatile uint32_t        CM2CONINV __attribute__((section("sfrs"),address(0xBF84C01C)));
#define CMSTAT CMSTAT
extern volatile uint32_t   CMSTAT __attribute__((section("sfrs"), address(0xBF84C060)));
typedef union {
  struct {
    uint32_t C1OUT:1;
    uint32_t C2OUT:1;
    uint32_t :11;
    uint32_t SIDL:1;
  };
  struct {
    uint32_t w:32;
  };
} __CMSTATbits_t;
extern volatile __CMSTATbits_t CMSTATbits __asm__ ("CMSTAT") __attribute__((section("sfrs"), address(0xBF84C060)));
extern volatile uint32_t        CMSTATCLR __attribute__((section("sfrs"),address(0xBF84C064)));
extern volatile uint32_t        CMSTATSET __attribute__((section("sfrs"),address(0xBF84C068)));
extern volatile uint32_t        CMSTATINV __attribute__((section("sfrs"),address(0xBF84C06C)));
#define ANSELB ANSELB
extern volatile uint32_t   ANSELB __attribute__((section("sfrs"), address(0xBF860100)));
typedef union {
  struct {
    uint32_t ANSB0:1;
    uint32_t ANSB1:1;
    uint32_t ANSB2:1;
    uint32_t ANSB3:1;
    uint32_t ANSB4:1;
    uint32_t ANSB5:1;
    uint32_t ANSB6:1;
    uint32_t ANSB7:1;
    uint32_t ANSB8:1;
    uint32_t ANSB9:1;
    uint32_t ANSB10:1;
    uint32_t ANSB11:1;
    uint32_t ANSB12:1;
    uint32_t ANSB13:1;
    uint32_t ANSB14:1;
    uint32_t ANSB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __ANSELBbits_t;
extern volatile __ANSELBbits_t ANSELBbits __asm__ ("ANSELB") __attribute__((section("sfrs"), address(0xBF860100)));
extern volatile uint32_t        ANSELBCLR __attribute__((section("sfrs"),address(0xBF860104)));
extern volatile uint32_t        ANSELBSET __attribute__((section("sfrs"),address(0xBF860108)));
extern volatile uint32_t        ANSELBINV __attribute__((section("sfrs"),address(0xBF86010C)));
#define TRISB TRISB
extern volatile uint32_t   TRISB __attribute__((section("sfrs"), address(0xBF860110)));
typedef union {
  struct {
    uint32_t TRISB0:1;
    uint32_t TRISB1:1;
    uint32_t TRISB2:1;
    uint32_t TRISB3:1;
    uint32_t TRISB4:1;
    uint32_t TRISB5:1;
    uint32_t TRISB6:1;
    uint32_t TRISB7:1;
    uint32_t TRISB8:1;
    uint32_t TRISB9:1;
    uint32_t TRISB10:1;
    uint32_t TRISB11:1;
    uint32_t TRISB12:1;
    uint32_t TRISB13:1;
    uint32_t TRISB14:1;
    uint32_t TRISB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __TRISBbits_t;
extern volatile __TRISBbits_t TRISBbits __asm__ ("TRISB") __attribute__((section("sfrs"), address(0xBF860110)));
extern volatile uint32_t        TRISBCLR __attribute__((section("sfrs"),address(0xBF860114)));
extern volatile uint32_t        TRISBSET __attribute__((section("sfrs"),address(0xBF860118)));
extern volatile uint32_t        TRISBINV __attribute__((section("sfrs"),address(0xBF86011C)));
#define PORTB PORTB
extern volatile uint32_t   PORTB __attribute__((section("sfrs"), address(0xBF860120)));
typedef union {
  struct {
    uint32_t RB0:1;
    uint32_t RB1:1;
    uint32_t RB2:1;
    uint32_t RB3:1;
    uint32_t RB4:1;
    uint32_t RB5:1;
    uint32_t RB6:1;
    uint32_t RB7:1;
    uint32_t RB8:1;
    uint32_t RB9:1;
    uint32_t RB10:1;
    uint32_t RB11:1;
    uint32_t RB12:1;
    uint32_t RB13:1;
    uint32_t RB14:1;
    uint32_t RB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __PORTBbits_t;
extern volatile __PORTBbits_t PORTBbits __asm__ ("PORTB") __attribute__((section("sfrs"), address(0xBF860120)));
extern volatile uint32_t        PORTBCLR __attribute__((section("sfrs"),address(0xBF860124)));
extern volatile uint32_t        PORTBSET __attribute__((section("sfrs"),address(0xBF860128)));
extern volatile uint32_t        PORTBINV __attribute__((section("sfrs"),address(0xBF86012C)));
#define LATB LATB
extern volatile uint32_t   LATB __attribute__((section("sfrs"), address(0xBF860130)));
typedef union {
  struct {
    uint32_t LATB0:1;
    uint32_t LATB1:1;
    uint32_t LATB2:1;
    uint32_t LATB3:1;
    uint32_t LATB4:1;
    uint32_t LATB5:1;
    uint32_t LATB6:1;
    uint32_t LATB7:1;
    uint32_t LATB8:1;
    uint32_t LATB9:1;
    uint32_t LATB10:1;
    uint32_t LATB11:1;
    uint32_t LATB12:1;
    uint32_t LATB13:1;
    uint32_t LATB14:1;
    uint32_t LATB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __LATBbits_t;
extern volatile __LATBbits_t LATBbits __asm__ ("LATB") __attribute__((section("sfrs"), address(0xBF860130)));
extern volatile uint32_t        LATBCLR __attribute__((section("sfrs"),address(0xBF860134)));
extern volatile uint32_t        LATBSET __attribute__((section("sfrs"),address(0xBF860138)));
extern volatile uint32_t        LATBINV __attribute__((section("sfrs"),address(0xBF86013C)));
#define ODCB ODCB
extern volatile uint32_t   ODCB __attribute__((section("sfrs"), address(0xBF860140)));
typedef union {
  struct {
    uint32_t ODCB0:1;
    uint32_t ODCB1:1;
    uint32_t ODCB2:1;
    uint32_t ODCB3:1;
    uint32_t ODCB4:1;
    uint32_t ODCB5:1;
    uint32_t ODCB6:1;
    uint32_t ODCB7:1;
    uint32_t ODCB8:1;
    uint32_t ODCB9:1;
    uint32_t ODCB10:1;
    uint32_t ODCB11:1;
    uint32_t ODCB12:1;
    uint32_t ODCB13:1;
    uint32_t ODCB14:1;
    uint32_t ODCB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __ODCBbits_t;
extern volatile __ODCBbits_t ODCBbits __asm__ ("ODCB") __attribute__((section("sfrs"), address(0xBF860140)));
extern volatile uint32_t        ODCBCLR __attribute__((section("sfrs"),address(0xBF860144)));
extern volatile uint32_t        ODCBSET __attribute__((section("sfrs"),address(0xBF860148)));
extern volatile uint32_t        ODCBINV __attribute__((section("sfrs"),address(0xBF86014C)));
#define CNPUB CNPUB
extern volatile uint32_t   CNPUB __attribute__((section("sfrs"), address(0xBF860150)));
typedef union {
  struct {
    uint32_t CNPUB0:1;
    uint32_t CNPUB1:1;
    uint32_t CNPUB2:1;
    uint32_t CNPUB3:1;
    uint32_t CNPUB4:1;
    uint32_t CNPUB5:1;
    uint32_t CNPUB6:1;
    uint32_t CNPUB7:1;
    uint32_t CNPUB8:1;
    uint32_t CNPUB9:1;
    uint32_t CNPUB10:1;
    uint32_t CNPUB11:1;
    uint32_t CNPUB12:1;
    uint32_t CNPUB13:1;
    uint32_t CNPUB14:1;
    uint32_t CNPUB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPUBbits_t;
extern volatile __CNPUBbits_t CNPUBbits __asm__ ("CNPUB") __attribute__((section("sfrs"), address(0xBF860150)));
extern volatile uint32_t        CNPUBCLR __attribute__((section("sfrs"),address(0xBF860154)));
extern volatile uint32_t        CNPUBSET __attribute__((section("sfrs"),address(0xBF860158)));
extern volatile uint32_t        CNPUBINV __attribute__((section("sfrs"),address(0xBF86015C)));
#define CNPDB CNPDB
extern volatile uint32_t   CNPDB __attribute__((section("sfrs"), address(0xBF860160)));
typedef union {
  struct {
    uint32_t CNPDB0:1;
    uint32_t CNPDB1:1;
    uint32_t CNPDB2:1;
    uint32_t CNPDB3:1;
    uint32_t CNPDB4:1;
    uint32_t CNPDB5:1;
    uint32_t CNPDB6:1;
    uint32_t CNPDB7:1;
    uint32_t CNPDB8:1;
    uint32_t CNPDB9:1;
    uint32_t CNPDB10:1;
    uint32_t CNPDB11:1;
    uint32_t CNPDB12:1;
    uint32_t CNPDB13:1;
    uint32_t CNPDB14:1;
    uint32_t CNPDB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPDBbits_t;
extern volatile __CNPDBbits_t CNPDBbits __asm__ ("CNPDB") __attribute__((section("sfrs"), address(0xBF860160)));
extern volatile uint32_t        CNPDBCLR __attribute__((section("sfrs"),address(0xBF860164)));
extern volatile uint32_t        CNPDBSET __attribute__((section("sfrs"),address(0xBF860168)));
extern volatile uint32_t        CNPDBINV __attribute__((section("sfrs"),address(0xBF86016C)));
#define CNCONB CNCONB
extern volatile uint32_t   CNCONB __attribute__((section("sfrs"), address(0xBF860170)));
typedef union {
  struct {
    uint32_t :11;
    uint32_t EDGEDETECT:1;
    uint32_t :3;
    uint32_t ON:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNCONBbits_t;
extern volatile __CNCONBbits_t CNCONBbits __asm__ ("CNCONB") __attribute__((section("sfrs"), address(0xBF860170)));
extern volatile uint32_t        CNCONBCLR __attribute__((section("sfrs"),address(0xBF860174)));
extern volatile uint32_t        CNCONBSET __attribute__((section("sfrs"),address(0xBF860178)));
extern volatile uint32_t        CNCONBINV __attribute__((section("sfrs"),address(0xBF86017C)));
#define CNENB CNENB
extern volatile uint32_t   CNENB __attribute__((section("sfrs"), address(0xBF860180)));
typedef union {
  struct {
    uint32_t CNIEB0:1;
    uint32_t CNIEB1:1;
    uint32_t CNIEB2:1;
    uint32_t CNIEB3:1;
    uint32_t CNIEB4:1;
    uint32_t CNIEB5:1;
    uint32_t CNIEB6:1;
    uint32_t CNIEB7:1;
    uint32_t CNIEB8:1;
    uint32_t CNIEB9:1;
    uint32_t CNIEB10:1;
    uint32_t CNIEB11:1;
    uint32_t CNIEB12:1;
    uint32_t CNIEB13:1;
    uint32_t CNIEB14:1;
    uint32_t CNIEB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNENBbits_t;
extern volatile __CNENBbits_t CNENBbits __asm__ ("CNENB") __attribute__((section("sfrs"), address(0xBF860180)));
extern volatile uint32_t        CNENBCLR __attribute__((section("sfrs"),address(0xBF860184)));
extern volatile uint32_t        CNENBSET __attribute__((section("sfrs"),address(0xBF860188)));
extern volatile uint32_t        CNENBINV __attribute__((section("sfrs"),address(0xBF86018C)));
#define CNSTATB CNSTATB
extern volatile uint32_t   CNSTATB __attribute__((section("sfrs"), address(0xBF860190)));
typedef union {
  struct {
    uint32_t CNSTATB0:1;
    uint32_t CNSTATB1:1;
    uint32_t CNSTATB2:1;
    uint32_t CNSTATB3:1;
    uint32_t CNSTATB4:1;
    uint32_t CNSTATB5:1;
    uint32_t CNSTATB6:1;
    uint32_t CNSTATB7:1;
    uint32_t CNSTATB8:1;
    uint32_t CNSTATB9:1;
    uint32_t CNSTATB10:1;
    uint32_t CNSTATB11:1;
    uint32_t CNSTATB12:1;
    uint32_t CNSTATB13:1;
    uint32_t CNSTATB14:1;
    uint32_t CNSTATB15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNSTATBbits_t;
extern volatile __CNSTATBbits_t CNSTATBbits __asm__ ("CNSTATB") __attribute__((section("sfrs"), address(0xBF860190)));
extern volatile uint32_t        CNSTATBCLR __attribute__((section("sfrs"),address(0xBF860194)));
extern volatile uint32_t        CNSTATBSET __attribute__((section("sfrs"),address(0xBF860198)));
extern volatile uint32_t        CNSTATBINV __attribute__((section("sfrs"),address(0xBF86019C)));
#define CNNEB CNNEB
extern volatile uint32_t   CNNEB __attribute__((section("sfrs"), address(0xBF8601A0)));
typedef struct {
  uint32_t CNNEB0:1;
  uint32_t CNNEB1:1;
  uint32_t CNNEB2:1;
  uint32_t CNNEB3:1;
  uint32_t CNNEB4:1;
  uint32_t CNNEB5:1;
  uint32_t CNNEB6:1;
  uint32_t CNNEB7:1;
  uint32_t CNNEB8:1;
  uint32_t CNNEB9:1;
  uint32_t CNNEB10:1;
  uint32_t CNNEB11:1;
  uint32_t CNNEB12:1;
  uint32_t CNNEB13:1;
  uint32_t CNNEB14:1;
  uint32_t CNNEB15:1;
} __CNNEBbits_t;
extern volatile __CNNEBbits_t CNNEBbits __asm__ ("CNNEB") __attribute__((section("sfrs"), address(0xBF8601A0)));
extern volatile uint32_t        CNNEBCLR __attribute__((section("sfrs"),address(0xBF8601A4)));
extern volatile uint32_t        CNNEBSET __attribute__((section("sfrs"),address(0xBF8601A8)));
extern volatile uint32_t        CNNEBINV __attribute__((section("sfrs"),address(0xBF8601AC)));
#define CNFB CNFB
extern volatile uint32_t   CNFB __attribute__((section("sfrs"), address(0xBF8601B0)));
typedef struct {
  uint32_t CNFB0:1;
  uint32_t CNFB1:1;
  uint32_t CNFB2:1;
  uint32_t CNFB3:1;
  uint32_t CNFB4:1;
  uint32_t CNFB5:1;
  uint32_t CNFB6:1;
  uint32_t CNFB7:1;
  uint32_t CNFB8:1;
  uint32_t CNFB9:1;
  uint32_t CNFB10:1;
  uint32_t CNFB11:1;
  uint32_t CNFB12:1;
  uint32_t CNFB13:1;
  uint32_t CNFB14:1;
  uint32_t CNFB15:1;
} __CNFBbits_t;
extern volatile __CNFBbits_t CNFBbits __asm__ ("CNFB") __attribute__((section("sfrs"), address(0xBF8601B0)));
extern volatile uint32_t        CNFBCLR __attribute__((section("sfrs"),address(0xBF8601B4)));
extern volatile uint32_t        CNFBSET __attribute__((section("sfrs"),address(0xBF8601B8)));
extern volatile uint32_t        CNFBINV __attribute__((section("sfrs"),address(0xBF8601BC)));
#define SRCON0B SRCON0B
extern volatile uint32_t   SRCON0B __attribute__((section("sfrs"), address(0xBF8601C0)));
typedef struct {
  uint32_t :3;
  uint32_t SR0B3:1;
  uint32_t :1;
  uint32_t SR0B5:1;
  uint32_t :2;
  uint32_t SR0B8:1;
  uint32_t SR0B9:1;
  uint32_t SR0B10:1;
  uint32_t :3;
  uint32_t SR0B14:1;
} __SRCON0Bbits_t;
extern volatile __SRCON0Bbits_t SRCON0Bbits __asm__ ("SRCON0B") __attribute__((section("sfrs"), address(0xBF8601C0)));
extern volatile uint32_t        SRCON0BCLR __attribute__((section("sfrs"),address(0xBF8601C4)));
extern volatile uint32_t        SRCON0BSET __attribute__((section("sfrs"),address(0xBF8601C8)));
extern volatile uint32_t        SRCON0BINV __attribute__((section("sfrs"),address(0xBF8601CC)));
#define SRCON1B SRCON1B
extern volatile uint32_t   SRCON1B __attribute__((section("sfrs"), address(0xBF8601D0)));
typedef struct {
  uint32_t :3;
  uint32_t SR1B3:1;
  uint32_t :1;
  uint32_t SR1B5:1;
  uint32_t :2;
  uint32_t SR1B8:1;
  uint32_t SR1B9:1;
  uint32_t SR1B10:1;
  uint32_t :3;
  uint32_t SR1B14:1;
} __SRCON1Bbits_t;
extern volatile __SRCON1Bbits_t SRCON1Bbits __asm__ ("SRCON1B") __attribute__((section("sfrs"), address(0xBF8601D0)));
extern volatile uint32_t        SRCON1BCLR __attribute__((section("sfrs"),address(0xBF8601D4)));
extern volatile uint32_t        SRCON1BSET __attribute__((section("sfrs"),address(0xBF8601D8)));
extern volatile uint32_t        SRCON1BINV __attribute__((section("sfrs"),address(0xBF8601DC)));
#define TRISC TRISC
extern volatile uint32_t   TRISC __attribute__((section("sfrs"), address(0xBF860210)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t TRISC12:1;
    uint32_t TRISC13:1;
    uint32_t TRISC14:1;
    uint32_t TRISC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __TRISCbits_t;
extern volatile __TRISCbits_t TRISCbits __asm__ ("TRISC") __attribute__((section("sfrs"), address(0xBF860210)));
extern volatile uint32_t        TRISCCLR __attribute__((section("sfrs"),address(0xBF860214)));
extern volatile uint32_t        TRISCSET __attribute__((section("sfrs"),address(0xBF860218)));
extern volatile uint32_t        TRISCINV __attribute__((section("sfrs"),address(0xBF86021C)));
#define PORTC PORTC
extern volatile uint32_t   PORTC __attribute__((section("sfrs"), address(0xBF860220)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t RC12:1;
    uint32_t RC13:1;
    uint32_t RC14:1;
    uint32_t RC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __PORTCbits_t;
extern volatile __PORTCbits_t PORTCbits __asm__ ("PORTC") __attribute__((section("sfrs"), address(0xBF860220)));
extern volatile uint32_t        PORTCCLR __attribute__((section("sfrs"),address(0xBF860224)));
extern volatile uint32_t        PORTCSET __attribute__((section("sfrs"),address(0xBF860228)));
extern volatile uint32_t        PORTCINV __attribute__((section("sfrs"),address(0xBF86022C)));
#define LATC LATC
extern volatile uint32_t   LATC __attribute__((section("sfrs"), address(0xBF860230)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t LATC12:1;
    uint32_t LATC13:1;
    uint32_t LATC14:1;
    uint32_t LATC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __LATCbits_t;
extern volatile __LATCbits_t LATCbits __asm__ ("LATC") __attribute__((section("sfrs"), address(0xBF860230)));
extern volatile uint32_t        LATCCLR __attribute__((section("sfrs"),address(0xBF860234)));
extern volatile uint32_t        LATCSET __attribute__((section("sfrs"),address(0xBF860238)));
extern volatile uint32_t        LATCINV __attribute__((section("sfrs"),address(0xBF86023C)));
#define ODCC ODCC
extern volatile uint32_t   ODCC __attribute__((section("sfrs"), address(0xBF860240)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t ODCC12:1;
    uint32_t ODCC13:1;
    uint32_t ODCC14:1;
    uint32_t ODCC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __ODCCbits_t;
extern volatile __ODCCbits_t ODCCbits __asm__ ("ODCC") __attribute__((section("sfrs"), address(0xBF860240)));
extern volatile uint32_t        ODCCCLR __attribute__((section("sfrs"),address(0xBF860244)));
extern volatile uint32_t        ODCCSET __attribute__((section("sfrs"),address(0xBF860248)));
extern volatile uint32_t        ODCCINV __attribute__((section("sfrs"),address(0xBF86024C)));
#define CNPUC CNPUC
extern volatile uint32_t   CNPUC __attribute__((section("sfrs"), address(0xBF860250)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t CNPUC12:1;
    uint32_t CNPUC13:1;
    uint32_t CNPUC14:1;
    uint32_t CNPUC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPUCbits_t;
extern volatile __CNPUCbits_t CNPUCbits __asm__ ("CNPUC") __attribute__((section("sfrs"), address(0xBF860250)));
extern volatile uint32_t        CNPUCCLR __attribute__((section("sfrs"),address(0xBF860254)));
extern volatile uint32_t        CNPUCSET __attribute__((section("sfrs"),address(0xBF860258)));
extern volatile uint32_t        CNPUCINV __attribute__((section("sfrs"),address(0xBF86025C)));
#define CNPDC CNPDC
extern volatile uint32_t   CNPDC __attribute__((section("sfrs"), address(0xBF860260)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t CNPDC12:1;
    uint32_t CNPDC13:1;
    uint32_t CNPDC14:1;
    uint32_t CNPDC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPDCbits_t;
extern volatile __CNPDCbits_t CNPDCbits __asm__ ("CNPDC") __attribute__((section("sfrs"), address(0xBF860260)));
extern volatile uint32_t        CNPDCCLR __attribute__((section("sfrs"),address(0xBF860264)));
extern volatile uint32_t        CNPDCSET __attribute__((section("sfrs"),address(0xBF860268)));
extern volatile uint32_t        CNPDCINV __attribute__((section("sfrs"),address(0xBF86026C)));
#define CNCONC CNCONC
extern volatile uint32_t   CNCONC __attribute__((section("sfrs"), address(0xBF860270)));
typedef union {
  struct {
    uint32_t :11;
    uint32_t EDGEDETECT:1;
    uint32_t :3;
    uint32_t ON:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNCONCbits_t;
extern volatile __CNCONCbits_t CNCONCbits __asm__ ("CNCONC") __attribute__((section("sfrs"), address(0xBF860270)));
extern volatile uint32_t        CNCONCCLR __attribute__((section("sfrs"),address(0xBF860274)));
extern volatile uint32_t        CNCONCSET __attribute__((section("sfrs"),address(0xBF860278)));
extern volatile uint32_t        CNCONCINV __attribute__((section("sfrs"),address(0xBF86027C)));
#define CNENC CNENC
extern volatile uint32_t   CNENC __attribute__((section("sfrs"), address(0xBF860280)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t CNIEC12:1;
    uint32_t CNIEC13:1;
    uint32_t CNIEC14:1;
    uint32_t CNIEC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNENCbits_t;
extern volatile __CNENCbits_t CNENCbits __asm__ ("CNENC") __attribute__((section("sfrs"), address(0xBF860280)));
extern volatile uint32_t        CNENCCLR __attribute__((section("sfrs"),address(0xBF860284)));
extern volatile uint32_t        CNENCSET __attribute__((section("sfrs"),address(0xBF860288)));
extern volatile uint32_t        CNENCINV __attribute__((section("sfrs"),address(0xBF86028C)));
#define CNSTATC CNSTATC
extern volatile uint32_t   CNSTATC __attribute__((section("sfrs"), address(0xBF860290)));
typedef union {
  struct {
    uint32_t :12;
    uint32_t CNSTATC12:1;
    uint32_t CNSTATC13:1;
    uint32_t CNSTATC14:1;
    uint32_t CNSTATC15:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNSTATCbits_t;
extern volatile __CNSTATCbits_t CNSTATCbits __asm__ ("CNSTATC") __attribute__((section("sfrs"), address(0xBF860290)));
extern volatile uint32_t        CNSTATCCLR __attribute__((section("sfrs"),address(0xBF860294)));
extern volatile uint32_t        CNSTATCSET __attribute__((section("sfrs"),address(0xBF860298)));
extern volatile uint32_t        CNSTATCINV __attribute__((section("sfrs"),address(0xBF86029C)));
#define CNNEC CNNEC
extern volatile uint32_t   CNNEC __attribute__((section("sfrs"), address(0xBF8602A0)));
typedef struct {
  uint32_t :12;
  uint32_t CNNEC12:1;
  uint32_t CNNEC13:1;
  uint32_t CNNEC14:1;
  uint32_t CNNEC15:1;
} __CNNECbits_t;
extern volatile __CNNECbits_t CNNECbits __asm__ ("CNNEC") __attribute__((section("sfrs"), address(0xBF8602A0)));
extern volatile uint32_t        CNNECCLR __attribute__((section("sfrs"),address(0xBF8602A4)));
extern volatile uint32_t        CNNECSET __attribute__((section("sfrs"),address(0xBF8602A8)));
extern volatile uint32_t        CNNECINV __attribute__((section("sfrs"),address(0xBF8602AC)));
#define CNFC CNFC
extern volatile uint32_t   CNFC __attribute__((section("sfrs"), address(0xBF8602B0)));
typedef struct {
  uint32_t :12;
  uint32_t CNFC12:1;
  uint32_t CNFC13:1;
  uint32_t CNFC14:1;
  uint32_t CNFC15:1;
} __CNFCbits_t;
extern volatile __CNFCbits_t CNFCbits __asm__ ("CNFC") __attribute__((section("sfrs"), address(0xBF8602B0)));
extern volatile uint32_t        CNFCCLR __attribute__((section("sfrs"),address(0xBF8602B4)));
extern volatile uint32_t        CNFCSET __attribute__((section("sfrs"),address(0xBF8602B8)));
extern volatile uint32_t        CNFCINV __attribute__((section("sfrs"),address(0xBF8602BC)));
#define TRISD TRISD
extern volatile uint32_t   TRISD __attribute__((section("sfrs"), address(0xBF860310)));
typedef union {
  struct {
    uint32_t TRISD0:1;
    uint32_t TRISD1:1;
    uint32_t TRISD2:1;
    uint32_t TRISD3:1;
    uint32_t TRISD4:1;
    uint32_t TRISD5:1;
    uint32_t :3;
    uint32_t TRISD9:1;
    uint32_t TRISD10:1;
    uint32_t TRISD11:1;
  };
  struct {
    uint32_t w:32;
  };
} __TRISDbits_t;
extern volatile __TRISDbits_t TRISDbits __asm__ ("TRISD") __attribute__((section("sfrs"), address(0xBF860310)));
extern volatile uint32_t        TRISDCLR __attribute__((section("sfrs"),address(0xBF860314)));
extern volatile uint32_t        TRISDSET __attribute__((section("sfrs"),address(0xBF860318)));
extern volatile uint32_t        TRISDINV __attribute__((section("sfrs"),address(0xBF86031C)));
#define PORTD PORTD
extern volatile uint32_t   PORTD __attribute__((section("sfrs"), address(0xBF860320)));
typedef union {
  struct {
    uint32_t RD0:1;
    uint32_t RD1:1;
    uint32_t RD2:1;
    uint32_t RD3:1;
    uint32_t RD4:1;
    uint32_t RD5:1;
    uint32_t :3;
    uint32_t RD9:1;
    uint32_t RD10:1;
    uint32_t RD11:1;
  };
  struct {
    uint32_t w:32;
  };
} __PORTDbits_t;
extern volatile __PORTDbits_t PORTDbits __asm__ ("PORTD") __attribute__((section("sfrs"), address(0xBF860320)));
extern volatile uint32_t        PORTDCLR __attribute__((section("sfrs"),address(0xBF860324)));
extern volatile uint32_t        PORTDSET __attribute__((section("sfrs"),address(0xBF860328)));
extern volatile uint32_t        PORTDINV __attribute__((section("sfrs"),address(0xBF86032C)));
#define LATD LATD
extern volatile uint32_t   LATD __attribute__((section("sfrs"), address(0xBF860330)));
typedef union {
  struct {
    uint32_t LATD0:1;
    uint32_t LATD1:1;
    uint32_t LATD2:1;
    uint32_t LATD3:1;
    uint32_t LATD4:1;
    uint32_t LATD5:1;
    uint32_t :3;
    uint32_t LATD9:1;
    uint32_t LATD10:1;
    uint32_t LATD11:1;
  };
  struct {
    uint32_t w:32;
  };
} __LATDbits_t;
extern volatile __LATDbits_t LATDbits __asm__ ("LATD") __attribute__((section("sfrs"), address(0xBF860330)));
extern volatile uint32_t        LATDCLR __attribute__((section("sfrs"),address(0xBF860334)));
extern volatile uint32_t        LATDSET __attribute__((section("sfrs"),address(0xBF860338)));
extern volatile uint32_t        LATDINV __attribute__((section("sfrs"),address(0xBF86033C)));
#define ODCD ODCD
extern volatile uint32_t   ODCD __attribute__((section("sfrs"), address(0xBF860340)));
typedef union {
  struct {
    uint32_t ODCD0:1;
    uint32_t ODCD1:1;
    uint32_t ODCD2:1;
    uint32_t ODCD3:1;
    uint32_t ODCD4:1;
    uint32_t ODCD5:1;
    uint32_t :3;
    uint32_t ODCD9:1;
    uint32_t ODCD10:1;
    uint32_t ODCD11:1;
  };
  struct {
    uint32_t w:32;
  };
} __ODCDbits_t;
extern volatile __ODCDbits_t ODCDbits __asm__ ("ODCD") __attribute__((section("sfrs"), address(0xBF860340)));
extern volatile uint32_t        ODCDCLR __attribute__((section("sfrs"),address(0xBF860344)));
extern volatile uint32_t        ODCDSET __attribute__((section("sfrs"),address(0xBF860348)));
extern volatile uint32_t        ODCDINV __attribute__((section("sfrs"),address(0xBF86034C)));
#define CNPUD CNPUD
extern volatile uint32_t   CNPUD __attribute__((section("sfrs"), address(0xBF860350)));
typedef union {
  struct {
    uint32_t CNPUD0:1;
    uint32_t CNPUD1:1;
    uint32_t CNPUD2:1;
    uint32_t CNPUD3:1;
    uint32_t CNPUD4:1;
    uint32_t CNPUD5:1;
    uint32_t :3;
    uint32_t CNPUD9:1;
    uint32_t CNPUD10:1;
    uint32_t CNPUD11:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPUDbits_t;
extern volatile __CNPUDbits_t CNPUDbits __asm__ ("CNPUD") __attribute__((section("sfrs"), address(0xBF860350)));
extern volatile uint32_t        CNPUDCLR __attribute__((section("sfrs"),address(0xBF860354)));
extern volatile uint32_t        CNPUDSET __attribute__((section("sfrs"),address(0xBF860358)));
extern volatile uint32_t        CNPUDINV __attribute__((section("sfrs"),address(0xBF86035C)));
#define CNPDD CNPDD
extern volatile uint32_t   CNPDD __attribute__((section("sfrs"), address(0xBF860360)));
typedef union {
  struct {
    uint32_t CNPDD0:1;
    uint32_t CNPDD1:1;
    uint32_t CNPDD2:1;
    uint32_t CNPDD3:1;
    uint32_t CNPDD4:1;
    uint32_t CNPDD5:1;
    uint32_t :3;
    uint32_t CNPDD9:1;
    uint32_t CNPDD10:1;
    uint32_t CNPDD11:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPDDbits_t;
extern volatile __CNPDDbits_t CNPDDbits __asm__ ("CNPDD") __attribute__((section("sfrs"), address(0xBF860360)));
extern volatile uint32_t        CNPDDCLR __attribute__((section("sfrs"),address(0xBF860364)));
extern volatile uint32_t        CNPDDSET __attribute__((section("sfrs"),address(0xBF860368)));
extern volatile uint32_t        CNPDDINV __attribute__((section("sfrs"),address(0xBF86036C)));
#define CNCOND CNCOND
extern volatile uint32_t   CNCOND __attribute__((section("sfrs"), address(0xBF860370)));
typedef union {
  struct {
    uint32_t :11;
    uint32_t EDGEDETECT:1;
    uint32_t :3;
    uint32_t ON:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNCONDbits_t;
extern volatile __CNCONDbits_t CNCONDbits __asm__ ("CNCOND") __attribute__((section("sfrs"), address(0xBF860370)));
extern volatile uint32_t        CNCONDCLR __attribute__((section("sfrs"),address(0xBF860374)));
extern volatile uint32_t        CNCONDSET __attribute__((section("sfrs"),address(0xBF860378)));
extern volatile uint32_t        CNCONDINV __attribute__((section("sfrs"),address(0xBF86037C)));
#define CNEND CNEND
extern volatile uint32_t   CNEND __attribute__((section("sfrs"), address(0xBF860380)));
typedef union {
  struct {
    uint32_t CNIED0:1;
    uint32_t CNIED1:1;
    uint32_t CNIED2:1;
    uint32_t CNIED3:1;
    uint32_t CNIED4:1;
    uint32_t CNIED5:1;
    uint32_t :3;
    uint32_t CNIED9:1;
    uint32_t CNIED10:1;
    uint32_t CNIED11:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNENDbits_t;
extern volatile __CNENDbits_t CNENDbits __asm__ ("CNEND") __attribute__((section("sfrs"), address(0xBF860380)));
extern volatile uint32_t        CNENDCLR __attribute__((section("sfrs"),address(0xBF860384)));
extern volatile uint32_t        CNENDSET __attribute__((section("sfrs"),address(0xBF860388)));
extern volatile uint32_t        CNENDINV __attribute__((section("sfrs"),address(0xBF86038C)));
#define CNSTATD CNSTATD
extern volatile uint32_t   CNSTATD __attribute__((section("sfrs"), address(0xBF860390)));
typedef union {
  struct {
    uint32_t CNSTATD0:1;
    uint32_t CNSTATD1:1;
    uint32_t CNSTATD2:1;
    uint32_t CNSTATD3:1;
    uint32_t CNSTATD4:1;
    uint32_t CNSTATD5:1;
    uint32_t :3;
    uint32_t CNSTATD9:1;
    uint32_t CNSTATD10:1;
    uint32_t CNSTATD11:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNSTATDbits_t;
extern volatile __CNSTATDbits_t CNSTATDbits __asm__ ("CNSTATD") __attribute__((section("sfrs"), address(0xBF860390)));
extern volatile uint32_t        CNSTATDCLR __attribute__((section("sfrs"),address(0xBF860394)));
extern volatile uint32_t        CNSTATDSET __attribute__((section("sfrs"),address(0xBF860398)));
extern volatile uint32_t        CNSTATDINV __attribute__((section("sfrs"),address(0xBF86039C)));
#define CNNED CNNED
extern volatile uint32_t   CNNED __attribute__((section("sfrs"), address(0xBF8603A0)));
typedef struct {
  uint32_t CNNED0:1;
  uint32_t CNNED1:1;
  uint32_t CNNED2:1;
  uint32_t CNNED3:1;
  uint32_t CNNED4:1;
  uint32_t CNNED5:1;
  uint32_t :3;
  uint32_t CNNED9:1;
  uint32_t CNNED10:1;
  uint32_t CNNED11:1;
} __CNNEDbits_t;
extern volatile __CNNEDbits_t CNNEDbits __asm__ ("CNNED") __attribute__((section("sfrs"), address(0xBF8603A0)));
extern volatile uint32_t        CNNEDCLR __attribute__((section("sfrs"),address(0xBF8603A4)));
extern volatile uint32_t        CNNEDSET __attribute__((section("sfrs"),address(0xBF8603A8)));
extern volatile uint32_t        CNNEDINV __attribute__((section("sfrs"),address(0xBF8603AC)));
#define CNFD CNFD
extern volatile uint32_t   CNFD __attribute__((section("sfrs"), address(0xBF8603B0)));
typedef struct {
  uint32_t CNFD0:1;
  uint32_t CNFD1:1;
  uint32_t CNFD2:1;
  uint32_t CNFD3:1;
  uint32_t CNFD4:1;
  uint32_t CNFD5:1;
  uint32_t :3;
  uint32_t CNFD9:1;
  uint32_t CNFD10:1;
  uint32_t CNFD11:1;
} __CNFDbits_t;
extern volatile __CNFDbits_t CNFDbits __asm__ ("CNFD") __attribute__((section("sfrs"), address(0xBF8603B0)));
extern volatile uint32_t        CNFDCLR __attribute__((section("sfrs"),address(0xBF8603B4)));
extern volatile uint32_t        CNFDSET __attribute__((section("sfrs"),address(0xBF8603B8)));
extern volatile uint32_t        CNFDINV __attribute__((section("sfrs"),address(0xBF8603BC)));
#define ANSELE ANSELE
extern volatile uint32_t   ANSELE __attribute__((section("sfrs"), address(0xBF860400)));
typedef union {
  struct {
    uint32_t :4;
    uint32_t ANSE4:1;
    uint32_t ANSE5:1;
    uint32_t ANSE6:1;
    uint32_t ANSE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __ANSELEbits_t;
extern volatile __ANSELEbits_t ANSELEbits __asm__ ("ANSELE") __attribute__((section("sfrs"), address(0xBF860400)));
extern volatile uint32_t        ANSELECLR __attribute__((section("sfrs"),address(0xBF860404)));
extern volatile uint32_t        ANSELESET __attribute__((section("sfrs"),address(0xBF860408)));
extern volatile uint32_t        ANSELEINV __attribute__((section("sfrs"),address(0xBF86040C)));
#define TRISE TRISE
extern volatile uint32_t   TRISE __attribute__((section("sfrs"), address(0xBF860410)));
typedef union {
  struct {
    uint32_t TRISE0:1;
    uint32_t TRISE1:1;
    uint32_t TRISE2:1;
    uint32_t TRISE3:1;
    uint32_t TRISE4:1;
    uint32_t TRISE5:1;
    uint32_t TRISE6:1;
    uint32_t TRISE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __TRISEbits_t;
extern volatile __TRISEbits_t TRISEbits __asm__ ("TRISE") __attribute__((section("sfrs"), address(0xBF860410)));
extern volatile uint32_t        TRISECLR __attribute__((section("sfrs"),address(0xBF860414)));
extern volatile uint32_t        TRISESET __attribute__((section("sfrs"),address(0xBF860418)));
extern volatile uint32_t        TRISEINV __attribute__((section("sfrs"),address(0xBF86041C)));
#define PORTE PORTE
extern volatile uint32_t   PORTE __attribute__((section("sfrs"), address(0xBF860420)));
typedef union {
  struct {
    uint32_t RE0:1;
    uint32_t RE1:1;
    uint32_t RE2:1;
    uint32_t RE3:1;
    uint32_t RE4:1;
    uint32_t RE5:1;
    uint32_t RE6:1;
    uint32_t RE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __PORTEbits_t;
extern volatile __PORTEbits_t PORTEbits __asm__ ("PORTE") __attribute__((section("sfrs"), address(0xBF860420)));
extern volatile uint32_t        PORTECLR __attribute__((section("sfrs"),address(0xBF860424)));
extern volatile uint32_t        PORTESET __attribute__((section("sfrs"),address(0xBF860428)));
extern volatile uint32_t        PORTEINV __attribute__((section("sfrs"),address(0xBF86042C)));
#define LATE LATE
extern volatile uint32_t   LATE __attribute__((section("sfrs"), address(0xBF860430)));
typedef union {
  struct {
    uint32_t LATE0:1;
    uint32_t LATE1:1;
    uint32_t LATE2:1;
    uint32_t LATE3:1;
    uint32_t LATE4:1;
    uint32_t LATE5:1;
    uint32_t LATE6:1;
    uint32_t LATE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __LATEbits_t;
extern volatile __LATEbits_t LATEbits __asm__ ("LATE") __attribute__((section("sfrs"), address(0xBF860430)));
extern volatile uint32_t        LATECLR __attribute__((section("sfrs"),address(0xBF860434)));
extern volatile uint32_t        LATESET __attribute__((section("sfrs"),address(0xBF860438)));
extern volatile uint32_t        LATEINV __attribute__((section("sfrs"),address(0xBF86043C)));
#define ODCE ODCE
extern volatile uint32_t   ODCE __attribute__((section("sfrs"), address(0xBF860440)));
typedef union {
  struct {
    uint32_t ODCE0:1;
    uint32_t ODCE1:1;
    uint32_t ODCE2:1;
    uint32_t ODCE3:1;
    uint32_t ODCE4:1;
    uint32_t ODCE5:1;
    uint32_t ODCE6:1;
    uint32_t ODCE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __ODCEbits_t;
extern volatile __ODCEbits_t ODCEbits __asm__ ("ODCE") __attribute__((section("sfrs"), address(0xBF860440)));
extern volatile uint32_t        ODCECLR __attribute__((section("sfrs"),address(0xBF860444)));
extern volatile uint32_t        ODCESET __attribute__((section("sfrs"),address(0xBF860448)));
extern volatile uint32_t        ODCEINV __attribute__((section("sfrs"),address(0xBF86044C)));
#define CNPUE CNPUE
extern volatile uint32_t   CNPUE __attribute__((section("sfrs"), address(0xBF860450)));
typedef union {
  struct {
    uint32_t CNPUE0:1;
    uint32_t CNPUE1:1;
    uint32_t CNPUE2:1;
    uint32_t CNPUE3:1;
    uint32_t CNPUE4:1;
    uint32_t CNPUE5:1;
    uint32_t CNPUE6:1;
    uint32_t CNPUE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPUEbits_t;
extern volatile __CNPUEbits_t CNPUEbits __asm__ ("CNPUE") __attribute__((section("sfrs"), address(0xBF860450)));
extern volatile uint32_t        CNPUECLR __attribute__((section("sfrs"),address(0xBF860454)));
extern volatile uint32_t        CNPUESET __attribute__((section("sfrs"),address(0xBF860458)));
extern volatile uint32_t        CNPUEINV __attribute__((section("sfrs"),address(0xBF86045C)));
#define CNPDE CNPDE
extern volatile uint32_t   CNPDE __attribute__((section("sfrs"), address(0xBF860460)));
typedef union {
  struct {
    uint32_t CNPDE0:1;
    uint32_t CNPDE1:1;
    uint32_t CNPDE2:1;
    uint32_t CNPDE3:1;
    uint32_t CNPDE4:1;
    uint32_t CNPDE5:1;
    uint32_t CNPDE6:1;
    uint32_t CNPDE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPDEbits_t;
extern volatile __CNPDEbits_t CNPDEbits __asm__ ("CNPDE") __attribute__((section("sfrs"), address(0xBF860460)));
extern volatile uint32_t        CNPDECLR __attribute__((section("sfrs"),address(0xBF860464)));
extern volatile uint32_t        CNPDESET __attribute__((section("sfrs"),address(0xBF860468)));
extern volatile uint32_t        CNPDEINV __attribute__((section("sfrs"),address(0xBF86046C)));
#define CNCONE CNCONE
extern volatile uint32_t   CNCONE __attribute__((section("sfrs"), address(0xBF860470)));
typedef union {
  struct {
    uint32_t :11;
    uint32_t EDGEDETECT:1;
    uint32_t :3;
    uint32_t ON:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNCONEbits_t;
extern volatile __CNCONEbits_t CNCONEbits __asm__ ("CNCONE") __attribute__((section("sfrs"), address(0xBF860470)));
extern volatile uint32_t        CNCONECLR __attribute__((section("sfrs"),address(0xBF860474)));
extern volatile uint32_t        CNCONESET __attribute__((section("sfrs"),address(0xBF860478)));
extern volatile uint32_t        CNCONEINV __attribute__((section("sfrs"),address(0xBF86047C)));
#define CNENE CNENE
extern volatile uint32_t   CNENE __attribute__((section("sfrs"), address(0xBF860480)));
typedef union {
  struct {
    uint32_t CNIEE0:1;
    uint32_t CNIEE1:1;
    uint32_t CNIEE2:1;
    uint32_t CNIEE3:1;
    uint32_t CNIEE4:1;
    uint32_t CNIEE5:1;
    uint32_t CNIEE6:1;
    uint32_t CNIEE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNENEbits_t;
extern volatile __CNENEbits_t CNENEbits __asm__ ("CNENE") __attribute__((section("sfrs"), address(0xBF860480)));
extern volatile uint32_t        CNENECLR __attribute__((section("sfrs"),address(0xBF860484)));
extern volatile uint32_t        CNENESET __attribute__((section("sfrs"),address(0xBF860488)));
extern volatile uint32_t        CNENEINV __attribute__((section("sfrs"),address(0xBF86048C)));
#define CNSTATE CNSTATE
extern volatile uint32_t   CNSTATE __attribute__((section("sfrs"), address(0xBF860490)));
typedef union {
  struct {
    uint32_t CNSTATE0:1;
    uint32_t CNSTATE1:1;
    uint32_t CNSTATE2:1;
    uint32_t CNSTATE3:1;
    uint32_t CNSTATE4:1;
    uint32_t CNSTATE5:1;
    uint32_t CNSTATE6:1;
    uint32_t CNSTATE7:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNSTATEbits_t;
extern volatile __CNSTATEbits_t CNSTATEbits __asm__ ("CNSTATE") __attribute__((section("sfrs"), address(0xBF860490)));
extern volatile uint32_t        CNSTATECLR __attribute__((section("sfrs"),address(0xBF860494)));
extern volatile uint32_t        CNSTATESET __attribute__((section("sfrs"),address(0xBF860498)));
extern volatile uint32_t        CNSTATEINV __attribute__((section("sfrs"),address(0xBF86049C)));
#define CNNEE CNNEE
extern volatile uint32_t   CNNEE __attribute__((section("sfrs"), address(0xBF8604A0)));
typedef struct {
  uint32_t CNNEE0:1;
  uint32_t CNNEE1:1;
  uint32_t CNNEE2:1;
  uint32_t CNNEE3:1;
  uint32_t CNNEE4:1;
  uint32_t CNNEE5:1;
  uint32_t CNNEE6:1;
  uint32_t CNNEE7:1;
} __CNNEEbits_t;
extern volatile __CNNEEbits_t CNNEEbits __asm__ ("CNNEE") __attribute__((section("sfrs"), address(0xBF8604A0)));
extern volatile uint32_t        CNNEECLR __attribute__((section("sfrs"),address(0xBF8604A4)));
extern volatile uint32_t        CNNEESET __attribute__((section("sfrs"),address(0xBF8604A8)));
extern volatile uint32_t        CNNEEINV __attribute__((section("sfrs"),address(0xBF8604AC)));
#define CNFE CNFE
extern volatile uint32_t   CNFE __attribute__((section("sfrs"), address(0xBF8604B0)));
typedef struct {
  uint32_t CNFE0:1;
  uint32_t CNFE1:1;
  uint32_t CNFE2:1;
  uint32_t CNFE3:1;
  uint32_t CNFE4:1;
  uint32_t CNFE5:1;
  uint32_t CNFE6:1;
  uint32_t CNFE7:1;
} __CNFEbits_t;
extern volatile __CNFEbits_t CNFEbits __asm__ ("CNFE") __attribute__((section("sfrs"), address(0xBF8604B0)));
extern volatile uint32_t        CNFECLR __attribute__((section("sfrs"),address(0xBF8604B4)));
extern volatile uint32_t        CNFESET __attribute__((section("sfrs"),address(0xBF8604B8)));
extern volatile uint32_t        CNFEINV __attribute__((section("sfrs"),address(0xBF8604BC)));
#define SRCON0E SRCON0E
extern volatile uint32_t   SRCON0E __attribute__((section("sfrs"), address(0xBF8604C0)));
typedef struct {
  uint32_t SR0E0:1;
  uint32_t SR0E1:1;
  uint32_t SR0E2:1;
  uint32_t SR0E3:1;
} __SRCON0Ebits_t;
extern volatile __SRCON0Ebits_t SRCON0Ebits __asm__ ("SRCON0E") __attribute__((section("sfrs"), address(0xBF8604C0)));
extern volatile uint32_t        SRCON0ECLR __attribute__((section("sfrs"),address(0xBF8604C4)));
extern volatile uint32_t        SRCON0ESET __attribute__((section("sfrs"),address(0xBF8604C8)));
extern volatile uint32_t        SRCON0EINV __attribute__((section("sfrs"),address(0xBF8604CC)));
#define SRCON1E SRCON1E
extern volatile uint32_t   SRCON1E __attribute__((section("sfrs"), address(0xBF8604D0)));
typedef struct {
  uint32_t SR1E0:1;
  uint32_t SR1E1:1;
  uint32_t SR1E2:1;
  uint32_t SR1E3:1;
} __SRCON1Ebits_t;
extern volatile __SRCON1Ebits_t SRCON1Ebits __asm__ ("SRCON1E") __attribute__((section("sfrs"), address(0xBF8604D0)));
extern volatile uint32_t        SRCON1ECLR __attribute__((section("sfrs"),address(0xBF8604D4)));
extern volatile uint32_t        SRCON1ESET __attribute__((section("sfrs"),address(0xBF8604D8)));
extern volatile uint32_t        SRCON1EINV __attribute__((section("sfrs"),address(0xBF8604DC)));
#define TRISF TRISF
extern volatile uint32_t   TRISF __attribute__((section("sfrs"), address(0xBF860510)));
typedef union {
  struct {
    uint32_t TRISF0:1;
    uint32_t TRISF1:1;
    uint32_t :1;
    uint32_t TRISF3:1;
    uint32_t TRISF4:1;
    uint32_t TRISF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __TRISFbits_t;
extern volatile __TRISFbits_t TRISFbits __asm__ ("TRISF") __attribute__((section("sfrs"), address(0xBF860510)));
extern volatile uint32_t        TRISFCLR __attribute__((section("sfrs"),address(0xBF860514)));
extern volatile uint32_t        TRISFSET __attribute__((section("sfrs"),address(0xBF860518)));
extern volatile uint32_t        TRISFINV __attribute__((section("sfrs"),address(0xBF86051C)));
#define PORTF PORTF
extern volatile uint32_t   PORTF __attribute__((section("sfrs"), address(0xBF860520)));
typedef union {
  struct {
    uint32_t RF0:1;
    uint32_t RF1:1;
    uint32_t :1;
    uint32_t RF3:1;
    uint32_t RF4:1;
    uint32_t RF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __PORTFbits_t;
extern volatile __PORTFbits_t PORTFbits __asm__ ("PORTF") __attribute__((section("sfrs"), address(0xBF860520)));
extern volatile uint32_t        PORTFCLR __attribute__((section("sfrs"),address(0xBF860524)));
extern volatile uint32_t        PORTFSET __attribute__((section("sfrs"),address(0xBF860528)));
extern volatile uint32_t        PORTFINV __attribute__((section("sfrs"),address(0xBF86052C)));
#define LATF LATF
extern volatile uint32_t   LATF __attribute__((section("sfrs"), address(0xBF860530)));
typedef union {
  struct {
    uint32_t LATF0:1;
    uint32_t LATF1:1;
    uint32_t :1;
    uint32_t LATF3:1;
    uint32_t LATF4:1;
    uint32_t LATF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __LATFbits_t;
extern volatile __LATFbits_t LATFbits __asm__ ("LATF") __attribute__((section("sfrs"), address(0xBF860530)));
extern volatile uint32_t        LATFCLR __attribute__((section("sfrs"),address(0xBF860534)));
extern volatile uint32_t        LATFSET __attribute__((section("sfrs"),address(0xBF860538)));
extern volatile uint32_t        LATFINV __attribute__((section("sfrs"),address(0xBF86053C)));
#define ODCF ODCF
extern volatile uint32_t   ODCF __attribute__((section("sfrs"), address(0xBF860540)));
typedef union {
  struct {
    uint32_t ODCF0:1;
    uint32_t ODCF1:1;
    uint32_t :1;
    uint32_t ODCF3:1;
    uint32_t ODCF4:1;
    uint32_t ODCF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __ODCFbits_t;
extern volatile __ODCFbits_t ODCFbits __asm__ ("ODCF") __attribute__((section("sfrs"), address(0xBF860540)));
extern volatile uint32_t        ODCFCLR __attribute__((section("sfrs"),address(0xBF860544)));
extern volatile uint32_t        ODCFSET __attribute__((section("sfrs"),address(0xBF860548)));
extern volatile uint32_t        ODCFINV __attribute__((section("sfrs"),address(0xBF86054C)));
#define CNPUF CNPUF
extern volatile uint32_t   CNPUF __attribute__((section("sfrs"), address(0xBF860550)));
typedef union {
  struct {
    uint32_t CNPUF0:1;
    uint32_t CNPUF1:1;
    uint32_t :1;
    uint32_t CNPUF3:1;
    uint32_t CNPUF4:1;
    uint32_t CNPUF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPUFbits_t;
extern volatile __CNPUFbits_t CNPUFbits __asm__ ("CNPUF") __attribute__((section("sfrs"), address(0xBF860550)));
extern volatile uint32_t        CNPUFCLR __attribute__((section("sfrs"),address(0xBF860554)));
extern volatile uint32_t        CNPUFSET __attribute__((section("sfrs"),address(0xBF860558)));
extern volatile uint32_t        CNPUFINV __attribute__((section("sfrs"),address(0xBF86055C)));
#define CNPDF CNPDF
extern volatile uint32_t   CNPDF __attribute__((section("sfrs"), address(0xBF860560)));
typedef union {
  struct {
    uint32_t CNPDF0:1;
    uint32_t CNPDF1:1;
    uint32_t :1;
    uint32_t CNPDF3:1;
    uint32_t CNPDF4:1;
    uint32_t CNPDF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPDFbits_t;
extern volatile __CNPDFbits_t CNPDFbits __asm__ ("CNPDF") __attribute__((section("sfrs"), address(0xBF860560)));
extern volatile uint32_t        CNPDFCLR __attribute__((section("sfrs"),address(0xBF860564)));
extern volatile uint32_t        CNPDFSET __attribute__((section("sfrs"),address(0xBF860568)));
extern volatile uint32_t        CNPDFINV __attribute__((section("sfrs"),address(0xBF86056C)));
#define CNCONF CNCONF
extern volatile uint32_t   CNCONF __attribute__((section("sfrs"), address(0xBF860570)));
typedef union {
  struct {
    uint32_t :11;
    uint32_t EDGEDETECT:1;
    uint32_t :3;
    uint32_t ON:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNCONFbits_t;
extern volatile __CNCONFbits_t CNCONFbits __asm__ ("CNCONF") __attribute__((section("sfrs"), address(0xBF860570)));
extern volatile uint32_t        CNCONFCLR __attribute__((section("sfrs"),address(0xBF860574)));
extern volatile uint32_t        CNCONFSET __attribute__((section("sfrs"),address(0xBF860578)));
extern volatile uint32_t        CNCONFINV __attribute__((section("sfrs"),address(0xBF86057C)));
#define CNENF CNENF
extern volatile uint32_t   CNENF __attribute__((section("sfrs"), address(0xBF860580)));
typedef union {
  struct {
    uint32_t CNIEF0:1;
    uint32_t CNIEF1:1;
    uint32_t :1;
    uint32_t CNIEF3:1;
    uint32_t CNIEF4:1;
    uint32_t CNIEF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNENFbits_t;
extern volatile __CNENFbits_t CNENFbits __asm__ ("CNENF") __attribute__((section("sfrs"), address(0xBF860580)));
extern volatile uint32_t        CNENFCLR __attribute__((section("sfrs"),address(0xBF860584)));
extern volatile uint32_t        CNENFSET __attribute__((section("sfrs"),address(0xBF860588)));
extern volatile uint32_t        CNENFINV __attribute__((section("sfrs"),address(0xBF86058C)));
#define CNSTATF CNSTATF
extern volatile uint32_t   CNSTATF __attribute__((section("sfrs"), address(0xBF860590)));
typedef union {
  struct {
    uint32_t CNSTATF0:1;
    uint32_t CNSTATF1:1;
    uint32_t :1;
    uint32_t CNSTATF3:1;
    uint32_t CNSTATF4:1;
    uint32_t CNSTATF5:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNSTATFbits_t;
extern volatile __CNSTATFbits_t CNSTATFbits __asm__ ("CNSTATF") __attribute__((section("sfrs"), address(0xBF860590)));
extern volatile uint32_t        CNSTATFCLR __attribute__((section("sfrs"),address(0xBF860594)));
extern volatile uint32_t        CNSTATFSET __attribute__((section("sfrs"),address(0xBF860598)));
extern volatile uint32_t        CNSTATFINV __attribute__((section("sfrs"),address(0xBF86059C)));
#define CNNEF CNNEF
extern volatile uint32_t   CNNEF __attribute__((section("sfrs"), address(0xBF8605A0)));
typedef struct {
  uint32_t CNNEF0:1;
  uint32_t CNNEF1:1;
  uint32_t :1;
  uint32_t CNNEF3:1;
  uint32_t CNNEF4:1;
  uint32_t CNNEF5:1;
} __CNNEFbits_t;
extern volatile __CNNEFbits_t CNNEFbits __asm__ ("CNNEF") __attribute__((section("sfrs"), address(0xBF8605A0)));
extern volatile uint32_t        CNNEFCLR __attribute__((section("sfrs"),address(0xBF8605A4)));
extern volatile uint32_t        CNNEFSET __attribute__((section("sfrs"),address(0xBF8605A8)));
extern volatile uint32_t        CNNEFINV __attribute__((section("sfrs"),address(0xBF8605AC)));
#define CNFF CNFF
extern volatile uint32_t   CNFF __attribute__((section("sfrs"), address(0xBF8605B0)));
typedef struct {
  uint32_t CNFF0:1;
  uint32_t CNFF1:1;
  uint32_t :1;
  uint32_t CNFF3:1;
  uint32_t CNFF4:1;
  uint32_t CNFF5:1;
} __CNFFbits_t;
extern volatile __CNFFbits_t CNFFbits __asm__ ("CNFF") __attribute__((section("sfrs"), address(0xBF8605B0)));
extern volatile uint32_t        CNFFCLR __attribute__((section("sfrs"),address(0xBF8605B4)));
extern volatile uint32_t        CNFFSET __attribute__((section("sfrs"),address(0xBF8605B8)));
extern volatile uint32_t        CNFFINV __attribute__((section("sfrs"),address(0xBF8605BC)));
#define SRCON0F SRCON0F
extern volatile uint32_t   SRCON0F __attribute__((section("sfrs"), address(0xBF8605C0)));
typedef struct {
  uint32_t SR0F0:1;
  uint32_t SR0F1:1;
} __SRCON0Fbits_t;
extern volatile __SRCON0Fbits_t SRCON0Fbits __asm__ ("SRCON0F") __attribute__((section("sfrs"), address(0xBF8605C0)));
extern volatile uint32_t        SRCON0FCLR __attribute__((section("sfrs"),address(0xBF8605C4)));
extern volatile uint32_t        SRCON0FSET __attribute__((section("sfrs"),address(0xBF8605C8)));
extern volatile uint32_t        SRCON0FINV __attribute__((section("sfrs"),address(0xBF8605CC)));
#define SRCON1F SRCON1F
extern volatile uint32_t   SRCON1F __attribute__((section("sfrs"), address(0xBF8605D0)));
typedef struct {
  uint32_t SR1F0:1;
  uint32_t SR1F1:1;
} __SRCON1Fbits_t;
extern volatile __SRCON1Fbits_t SRCON1Fbits __asm__ ("SRCON1F") __attribute__((section("sfrs"), address(0xBF8605D0)));
extern volatile uint32_t        SRCON1FCLR __attribute__((section("sfrs"),address(0xBF8605D4)));
extern volatile uint32_t        SRCON1FSET __attribute__((section("sfrs"),address(0xBF8605D8)));
extern volatile uint32_t        SRCON1FINV __attribute__((section("sfrs"),address(0xBF8605DC)));
#define ANSELG ANSELG
extern volatile uint32_t   ANSELG __attribute__((section("sfrs"), address(0xBF860600)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t ANSG6:1;
    uint32_t ANSG7:1;
    uint32_t ANSG8:1;
    uint32_t ANSG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __ANSELGbits_t;
extern volatile __ANSELGbits_t ANSELGbits __asm__ ("ANSELG") __attribute__((section("sfrs"), address(0xBF860600)));
extern volatile uint32_t        ANSELGCLR __attribute__((section("sfrs"),address(0xBF860604)));
extern volatile uint32_t        ANSELGSET __attribute__((section("sfrs"),address(0xBF860608)));
extern volatile uint32_t        ANSELGINV __attribute__((section("sfrs"),address(0xBF86060C)));
#define TRISG TRISG
extern volatile uint32_t   TRISG __attribute__((section("sfrs"), address(0xBF860610)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t TRISG6:1;
    uint32_t TRISG7:1;
    uint32_t TRISG8:1;
    uint32_t TRISG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __TRISGbits_t;
extern volatile __TRISGbits_t TRISGbits __asm__ ("TRISG") __attribute__((section("sfrs"), address(0xBF860610)));
extern volatile uint32_t        TRISGCLR __attribute__((section("sfrs"),address(0xBF860614)));
extern volatile uint32_t        TRISGSET __attribute__((section("sfrs"),address(0xBF860618)));
extern volatile uint32_t        TRISGINV __attribute__((section("sfrs"),address(0xBF86061C)));
#define PORTG PORTG
extern volatile uint32_t   PORTG __attribute__((section("sfrs"), address(0xBF860620)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t RG6:1;
    uint32_t RG7:1;
    uint32_t RG8:1;
    uint32_t RG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __PORTGbits_t;
extern volatile __PORTGbits_t PORTGbits __asm__ ("PORTG") __attribute__((section("sfrs"), address(0xBF860620)));
extern volatile uint32_t        PORTGCLR __attribute__((section("sfrs"),address(0xBF860624)));
extern volatile uint32_t        PORTGSET __attribute__((section("sfrs"),address(0xBF860628)));
extern volatile uint32_t        PORTGINV __attribute__((section("sfrs"),address(0xBF86062C)));
#define LATG LATG
extern volatile uint32_t   LATG __attribute__((section("sfrs"), address(0xBF860630)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t LATG6:1;
    uint32_t LATG7:1;
    uint32_t LATG8:1;
    uint32_t LATG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __LATGbits_t;
extern volatile __LATGbits_t LATGbits __asm__ ("LATG") __attribute__((section("sfrs"), address(0xBF860630)));
extern volatile uint32_t        LATGCLR __attribute__((section("sfrs"),address(0xBF860634)));
extern volatile uint32_t        LATGSET __attribute__((section("sfrs"),address(0xBF860638)));
extern volatile uint32_t        LATGINV __attribute__((section("sfrs"),address(0xBF86063C)));
#define ODCG ODCG
extern volatile uint32_t   ODCG __attribute__((section("sfrs"), address(0xBF860640)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t ODCG6:1;
    uint32_t ODCG7:1;
    uint32_t ODCG8:1;
    uint32_t ODCG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __ODCGbits_t;
extern volatile __ODCGbits_t ODCGbits __asm__ ("ODCG") __attribute__((section("sfrs"), address(0xBF860640)));
extern volatile uint32_t        ODCGCLR __attribute__((section("sfrs"),address(0xBF860644)));
extern volatile uint32_t        ODCGSET __attribute__((section("sfrs"),address(0xBF860648)));
extern volatile uint32_t        ODCGINV __attribute__((section("sfrs"),address(0xBF86064C)));
#define CNPUG CNPUG
extern volatile uint32_t   CNPUG __attribute__((section("sfrs"), address(0xBF860650)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t CNPUG6:1;
    uint32_t CNPUG7:1;
    uint32_t CNPUG8:1;
    uint32_t CNPUG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPUGbits_t;
extern volatile __CNPUGbits_t CNPUGbits __asm__ ("CNPUG") __attribute__((section("sfrs"), address(0xBF860650)));
extern volatile uint32_t        CNPUGCLR __attribute__((section("sfrs"),address(0xBF860654)));
extern volatile uint32_t        CNPUGSET __attribute__((section("sfrs"),address(0xBF860658)));
extern volatile uint32_t        CNPUGINV __attribute__((section("sfrs"),address(0xBF86065C)));
#define CNPDG CNPDG
extern volatile uint32_t   CNPDG __attribute__((section("sfrs"), address(0xBF860660)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t CNPDG6:1;
    uint32_t CNPDG7:1;
    uint32_t CNPDG8:1;
    uint32_t CNPDG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNPDGbits_t;
extern volatile __CNPDGbits_t CNPDGbits __asm__ ("CNPDG") __attribute__((section("sfrs"), address(0xBF860660)));
extern volatile uint32_t        CNPDGCLR __attribute__((section("sfrs"),address(0xBF860664)));
extern volatile uint32_t        CNPDGSET __attribute__((section("sfrs"),address(0xBF860668)));
extern volatile uint32_t        CNPDGINV __attribute__((section("sfrs"),address(0xBF86066C)));
#define CNCONG CNCONG
extern volatile uint32_t   CNCONG __attribute__((section("sfrs"), address(0xBF860670)));
typedef union {
  struct {
    uint32_t :11;
    uint32_t EDGEDETECT:1;
    uint32_t :3;
    uint32_t ON:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNCONGbits_t;
extern volatile __CNCONGbits_t CNCONGbits __asm__ ("CNCONG") __attribute__((section("sfrs"), address(0xBF860670)));
extern volatile uint32_t        CNCONGCLR __attribute__((section("sfrs"),address(0xBF860674)));
extern volatile uint32_t        CNCONGSET __attribute__((section("sfrs"),address(0xBF860678)));
extern volatile uint32_t        CNCONGINV __attribute__((section("sfrs"),address(0xBF86067C)));
#define CNENG CNENG
extern volatile uint32_t   CNENG __attribute__((section("sfrs"), address(0xBF860680)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t CNIEG6:1;
    uint32_t CNIEG7:1;
    uint32_t CNIEG8:1;
    uint32_t CNIEG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNENGbits_t;
extern volatile __CNENGbits_t CNENGbits __asm__ ("CNENG") __attribute__((section("sfrs"), address(0xBF860680)));
extern volatile uint32_t        CNENGCLR __attribute__((section("sfrs"),address(0xBF860684)));
extern volatile uint32_t        CNENGSET __attribute__((section("sfrs"),address(0xBF860688)));
extern volatile uint32_t        CNENGINV __attribute__((section("sfrs"),address(0xBF86068C)));
#define CNSTATG CNSTATG
extern volatile uint32_t   CNSTATG __attribute__((section("sfrs"), address(0xBF860690)));
typedef union {
  struct {
    uint32_t :6;
    uint32_t CNSTATG6:1;
    uint32_t CNSTATG7:1;
    uint32_t CNSTATG8:1;
    uint32_t CNSTATG9:1;
  };
  struct {
    uint32_t w:32;
  };
} __CNSTATGbits_t;
extern volatile __CNSTATGbits_t CNSTATGbits __asm__ ("CNSTATG") __attribute__((section("sfrs"), address(0xBF860690)));
extern volatile uint32_t        CNSTATGCLR __attribute__((section("sfrs"),address(0xBF860694)));
extern volatile uint32_t        CNSTATGSET __attribute__((section("sfrs"),address(0xBF860698)));
extern volatile uint32_t        CNSTATGINV __attribute__((section("sfrs"),address(0xBF86069C)));
#define CNNEG CNNEG
extern volatile uint32_t   CNNEG __attribute__((section("sfrs"), address(0xBF8606A0)));
typedef struct {
  uint32_t :6;
  uint32_t CNNEG6:1;
  uint32_t CNNEG7:1;
  uint32_t CNNEG8:1;
  uint32_t CNNEG9:1;
} __CNNEGbits_t;
extern volatile __CNNEGbits_t CNNEGbits __asm__ ("CNNEG") __attribute__((section("sfrs"), address(0xBF8606A0)));
extern volatile uint32_t        CNNEGCLR __attribute__((section("sfrs"),address(0xBF8606A4)));
extern volatile uint32_t        CNNEGSET __attribute__((section("sfrs"),address(0xBF8606A8)));
extern volatile uint32_t        CNNEGINV __attribute__((section("sfrs"),address(0xBF8606AC)));
#define CNFG CNFG
extern volatile uint32_t   CNFG __attribute__((section("sfrs"), address(0xBF8606B0)));
typedef struct {
  uint32_t :6;
  uint32_t CNFG6:1;
  uint32_t CNFG7:1;
  uint32_t CNFG8:1;
  uint32_t CNFG9:1;
} __CNFGbits_t;
extern volatile __CNFGbits_t CNFGbits __asm__ ("CNFG") __attribute__((section("sfrs"), address(0xBF8606B0)));
extern volatile uint32_t        CNFGCLR __attribute__((section("sfrs"),address(0xBF8606B4)));
extern volatile uint32_t        CNFGSET __attribute__((section("sfrs"),address(0xBF8606B8)));
extern volatile uint32_t        CNFGINV __attribute__((section("sfrs"),address(0xBF8606BC)));
#define SRCON0G SRCON0G
extern volatile uint32_t   SRCON0G __attribute__((section("sfrs"), address(0xBF8606C0)));
typedef struct {
  uint32_t :6;
  uint32_t SR0G6:1;
  uint32_t :2;
  uint32_t SR0G9:1;
} __SRCON0Gbits_t;
extern volatile __SRCON0Gbits_t SRCON0Gbits __asm__ ("SRCON0G") __attribute__((section("sfrs"), address(0xBF8606C0)));
extern volatile uint32_t        SRCON0GCLR __attribute__((section("sfrs"),address(0xBF8606C4)));
extern volatile uint32_t        SRCON0GSET __attribute__((section("sfrs"),address(0xBF8606C8)));
extern volatile uint32_t        SRCON0GINV __attribute__((section("sfrs"),address(0xBF8606CC)));
#define SRCON1G SRCON1G
extern volatile uint32_t   SRCON1G __attribute__((section("sfrs"), address(0xBF8606D0)));
typedef struct {
  uint32_t :6;
  uint32_t SR1G6:1;
  uint32_t :2;
  uint32_t SR1G9:1;
} __SRCON1Gbits_t;
extern volatile __SRCON1Gbits_t SRCON1Gbits __asm__ ("SRCON1G") __attribute__((section("sfrs"), address(0xBF8606D0)));
extern volatile uint32_t        SRCON1GCLR __attribute__((section("sfrs"),address(0xBF8606D4)));
extern volatile uint32_t        SRCON1GSET __attribute__((section("sfrs"),address(0xBF8606D8)));
extern volatile uint32_t        SRCON1GINV __attribute__((section("sfrs"),address(0xBF8606DC)));
#define C1CON C1CON
extern volatile uint32_t   C1CON __attribute__((section("sfrs"), address(0xBF880000)));
typedef union {
  struct {
    uint32_t DNCNT:5;
    uint32_t :6;
    uint32_t CANBUSY:1;
    uint32_t :1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t :4;
    uint32_t CANCAP:1;
    uint32_t OPMOD:3;
    uint32_t REQOP:3;
    uint32_t ABAT:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1CONbits_t;
extern volatile __C1CONbits_t C1CONbits __asm__ ("C1CON") __attribute__((section("sfrs"), address(0xBF880000)));
extern volatile uint32_t        C1CONCLR __attribute__((section("sfrs"),address(0xBF880004)));
extern volatile uint32_t        C1CONSET __attribute__((section("sfrs"),address(0xBF880008)));
extern volatile uint32_t        C1CONINV __attribute__((section("sfrs"),address(0xBF88000C)));
#define C1CFG C1CFG
extern volatile uint32_t   C1CFG __attribute__((section("sfrs"), address(0xBF880010)));
typedef union {
  struct {
    uint32_t BRP:6;
    uint32_t SJW:2;
    uint32_t PRSEG:3;
    uint32_t SEG1PH:3;
    uint32_t SAM:1;
    uint32_t SEG2PHTS:1;
    uint32_t SEG2PH:3;
    uint32_t :3;
    uint32_t WAKFIL:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1CFGbits_t;
extern volatile __C1CFGbits_t C1CFGbits __asm__ ("C1CFG") __attribute__((section("sfrs"), address(0xBF880010)));
extern volatile uint32_t        C1CFGCLR __attribute__((section("sfrs"),address(0xBF880014)));
extern volatile uint32_t        C1CFGSET __attribute__((section("sfrs"),address(0xBF880018)));
extern volatile uint32_t        C1CFGINV __attribute__((section("sfrs"),address(0xBF88001C)));
#define C1INT C1INT
extern volatile uint32_t   C1INT __attribute__((section("sfrs"), address(0xBF880020)));
typedef union {
  struct {
    uint32_t TBIF:1;
    uint32_t RBIF:1;
    uint32_t CTMRIF:1;
    uint32_t MODIF:1;
    uint32_t :7;
    uint32_t RBOVIF:1;
    uint32_t SERRIF:1;
    uint32_t CERRIF:1;
    uint32_t WAKIF:1;
    uint32_t IVRIF:1;
    uint32_t TBIE:1;
    uint32_t RBIE:1;
    uint32_t CTMRIE:1;
    uint32_t MODIE:1;
    uint32_t :7;
    uint32_t RBOVIE:1;
    uint32_t SERRIE:1;
    uint32_t CERRIE:1;
    uint32_t WAKIE:1;
    uint32_t IVRIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1INTbits_t;
extern volatile __C1INTbits_t C1INTbits __asm__ ("C1INT") __attribute__((section("sfrs"), address(0xBF880020)));
extern volatile uint32_t        C1INTCLR __attribute__((section("sfrs"),address(0xBF880024)));
extern volatile uint32_t        C1INTSET __attribute__((section("sfrs"),address(0xBF880028)));
extern volatile uint32_t        C1INTINV __attribute__((section("sfrs"),address(0xBF88002C)));
#define C1VEC C1VEC
extern volatile uint32_t   C1VEC __attribute__((section("sfrs"), address(0xBF880030)));
typedef union {
  struct {
    uint32_t ICODE:7;
    uint32_t :1;
    uint32_t FILHIT:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1VECbits_t;
extern volatile __C1VECbits_t C1VECbits __asm__ ("C1VEC") __attribute__((section("sfrs"), address(0xBF880030)));
extern volatile uint32_t        C1VECCLR __attribute__((section("sfrs"),address(0xBF880034)));
extern volatile uint32_t        C1VECSET __attribute__((section("sfrs"),address(0xBF880038)));
extern volatile uint32_t        C1VECINV __attribute__((section("sfrs"),address(0xBF88003C)));
#define C1TREC C1TREC
extern volatile uint32_t   C1TREC __attribute__((section("sfrs"), address(0xBF880040)));
typedef union {
  struct {
    uint32_t RERRCNT:8;
    uint32_t TERRCNT:8;
    uint32_t EWARN:1;
    uint32_t RXWARN:1;
    uint32_t TXWARN:1;
    uint32_t RXBP:1;
    uint32_t TXBP:1;
    uint32_t TXBO:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1TRECbits_t;
extern volatile __C1TRECbits_t C1TRECbits __asm__ ("C1TREC") __attribute__((section("sfrs"), address(0xBF880040)));
extern volatile uint32_t        C1TRECCLR __attribute__((section("sfrs"),address(0xBF880044)));
extern volatile uint32_t        C1TRECSET __attribute__((section("sfrs"),address(0xBF880048)));
extern volatile uint32_t        C1TRECINV __attribute__((section("sfrs"),address(0xBF88004C)));
#define C1FSTAT C1FSTAT
extern volatile uint32_t   C1FSTAT __attribute__((section("sfrs"), address(0xBF880050)));
typedef union {
  struct {
    uint32_t FIFOIP:32;
  };
  struct {
    uint32_t FIFOIP0:1;
    uint32_t FIFOIP1:1;
    uint32_t FIFOIP2:1;
    uint32_t FIFOIP3:1;
    uint32_t FIFOIP4:1;
    uint32_t FIFOIP5:1;
    uint32_t FIFOIP6:1;
    uint32_t FIFOIP7:1;
    uint32_t FIFOIP8:1;
    uint32_t FIFOIP9:1;
    uint32_t FIFOIP10:1;
    uint32_t FIFOIP11:1;
    uint32_t FIFOIP12:1;
    uint32_t FIFOIP13:1;
    uint32_t FIFOIP14:1;
    uint32_t FIFOIP15:1;
    uint32_t FIFOIP16:1;
    uint32_t FIFOIP17:1;
    uint32_t FIFOIP18:1;
    uint32_t FIFOIP19:1;
    uint32_t FIFOIP20:1;
    uint32_t FIFOIP21:1;
    uint32_t FIFOIP22:1;
    uint32_t FIFOIP23:1;
    uint32_t FIFOIP24:1;
    uint32_t FIFOIP25:1;
    uint32_t FIFOIP26:1;
    uint32_t FIFOIP27:1;
    uint32_t FIFOIP28:1;
    uint32_t FIFOIP29:1;
    uint32_t FIFOIP30:1;
    uint32_t FIFOIP31:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FSTATbits_t;
extern volatile __C1FSTATbits_t C1FSTATbits __asm__ ("C1FSTAT") __attribute__((section("sfrs"), address(0xBF880050)));
extern volatile uint32_t        C1FSTATCLR __attribute__((section("sfrs"),address(0xBF880054)));
extern volatile uint32_t        C1FSTATSET __attribute__((section("sfrs"),address(0xBF880058)));
extern volatile uint32_t        C1FSTATINV __attribute__((section("sfrs"),address(0xBF88005C)));
#define C1RXOVF C1RXOVF
extern volatile uint32_t   C1RXOVF __attribute__((section("sfrs"), address(0xBF880060)));
typedef union {
  struct {
    uint32_t RXOVF:32;
  };
  struct {
    uint32_t RXOVF0:1;
    uint32_t RXOVF1:1;
    uint32_t RXOVF2:1;
    uint32_t RXOVF3:1;
    uint32_t RXOVF4:1;
    uint32_t RXOVF5:1;
    uint32_t RXOVF6:1;
    uint32_t RXOVF7:1;
    uint32_t RXOVF8:1;
    uint32_t RXOVF9:1;
    uint32_t RXOVF10:1;
    uint32_t RXOVF11:1;
    uint32_t RXOVF12:1;
    uint32_t RXOVF13:1;
    uint32_t RXOVF14:1;
    uint32_t RXOVF15:1;
    uint32_t RXOVF16:1;
    uint32_t RXOVF17:1;
    uint32_t RXOVF18:1;
    uint32_t RXOVF19:1;
    uint32_t RXOVF20:1;
    uint32_t RXOVF21:1;
    uint32_t RXOVF22:1;
    uint32_t RXOVF23:1;
    uint32_t RXOVF24:1;
    uint32_t RXOVF25:1;
    uint32_t RXOVF26:1;
    uint32_t RXOVF27:1;
    uint32_t RXOVF28:1;
    uint32_t RXOVF29:1;
    uint32_t RXOVF30:1;
    uint32_t RXOVF31:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXOVFbits_t;
extern volatile __C1RXOVFbits_t C1RXOVFbits __asm__ ("C1RXOVF") __attribute__((section("sfrs"), address(0xBF880060)));
extern volatile uint32_t        C1RXOVFCLR __attribute__((section("sfrs"),address(0xBF880064)));
extern volatile uint32_t        C1RXOVFSET __attribute__((section("sfrs"),address(0xBF880068)));
extern volatile uint32_t        C1RXOVFINV __attribute__((section("sfrs"),address(0xBF88006C)));
#define C1TMR C1TMR
extern volatile uint32_t   C1TMR __attribute__((section("sfrs"), address(0xBF880070)));
typedef union {
  struct {
    uint32_t CANTSPRE:16;
    uint32_t CANTS:16;
  };
  struct {
    uint32_t w:32;
  };
} __C1TMRbits_t;
extern volatile __C1TMRbits_t C1TMRbits __asm__ ("C1TMR") __attribute__((section("sfrs"), address(0xBF880070)));
extern volatile uint32_t        C1TMRCLR __attribute__((section("sfrs"),address(0xBF880074)));
extern volatile uint32_t        C1TMRSET __attribute__((section("sfrs"),address(0xBF880078)));
extern volatile uint32_t        C1TMRINV __attribute__((section("sfrs"),address(0xBF88007C)));
#define C1RXM0 C1RXM0
extern volatile uint32_t   C1RXM0 __attribute__((section("sfrs"), address(0xBF880080)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXM0bits_t;
extern volatile __C1RXM0bits_t C1RXM0bits __asm__ ("C1RXM0") __attribute__((section("sfrs"), address(0xBF880080)));
extern volatile uint32_t        C1RXM0CLR __attribute__((section("sfrs"),address(0xBF880084)));
extern volatile uint32_t        C1RXM0SET __attribute__((section("sfrs"),address(0xBF880088)));
extern volatile uint32_t        C1RXM0INV __attribute__((section("sfrs"),address(0xBF88008C)));
#define C1RXM1 C1RXM1
extern volatile uint32_t   C1RXM1 __attribute__((section("sfrs"), address(0xBF880090)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXM1bits_t;
extern volatile __C1RXM1bits_t C1RXM1bits __asm__ ("C1RXM1") __attribute__((section("sfrs"), address(0xBF880090)));
extern volatile uint32_t        C1RXM1CLR __attribute__((section("sfrs"),address(0xBF880094)));
extern volatile uint32_t        C1RXM1SET __attribute__((section("sfrs"),address(0xBF880098)));
extern volatile uint32_t        C1RXM1INV __attribute__((section("sfrs"),address(0xBF88009C)));
#define C1RXM2 C1RXM2
extern volatile uint32_t   C1RXM2 __attribute__((section("sfrs"), address(0xBF8800A0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXM2bits_t;
extern volatile __C1RXM2bits_t C1RXM2bits __asm__ ("C1RXM2") __attribute__((section("sfrs"), address(0xBF8800A0)));
extern volatile uint32_t        C1RXM2CLR __attribute__((section("sfrs"),address(0xBF8800A4)));
extern volatile uint32_t        C1RXM2SET __attribute__((section("sfrs"),address(0xBF8800A8)));
extern volatile uint32_t        C1RXM2INV __attribute__((section("sfrs"),address(0xBF8800AC)));
#define C1RXM3 C1RXM3
extern volatile uint32_t   C1RXM3 __attribute__((section("sfrs"), address(0xBF8800B0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXM3bits_t;
extern volatile __C1RXM3bits_t C1RXM3bits __asm__ ("C1RXM3") __attribute__((section("sfrs"), address(0xBF8800B0)));
extern volatile uint32_t        C1RXM3CLR __attribute__((section("sfrs"),address(0xBF8800B4)));
extern volatile uint32_t        C1RXM3SET __attribute__((section("sfrs"),address(0xBF8800B8)));
extern volatile uint32_t        C1RXM3INV __attribute__((section("sfrs"),address(0xBF8800BC)));
#define C1FLTCON0 C1FLTCON0
extern volatile uint32_t   C1FLTCON0 __attribute__((section("sfrs"), address(0xBF8800C0)));
typedef union {
  struct {
    uint32_t FSEL0:5;
    uint32_t MSEL0:2;
    uint32_t FLTEN0:1;
    uint32_t FSEL1:5;
    uint32_t MSEL1:2;
    uint32_t FLTEN1:1;
    uint32_t FSEL2:5;
    uint32_t MSEL2:2;
    uint32_t FLTEN2:1;
    uint32_t FSEL3:5;
    uint32_t MSEL3:2;
    uint32_t FLTEN3:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON0bits_t;
extern volatile __C1FLTCON0bits_t C1FLTCON0bits __asm__ ("C1FLTCON0") __attribute__((section("sfrs"), address(0xBF8800C0)));
extern volatile uint32_t        C1FLTCON0CLR __attribute__((section("sfrs"),address(0xBF8800C4)));
extern volatile uint32_t        C1FLTCON0SET __attribute__((section("sfrs"),address(0xBF8800C8)));
extern volatile uint32_t        C1FLTCON0INV __attribute__((section("sfrs"),address(0xBF8800CC)));
#define C1FLTCON1 C1FLTCON1
extern volatile uint32_t   C1FLTCON1 __attribute__((section("sfrs"), address(0xBF8800D0)));
typedef union {
  struct {
    uint32_t FSEL4:5;
    uint32_t MSEL4:2;
    uint32_t FLTEN4:1;
    uint32_t FSEL5:5;
    uint32_t MSEL5:2;
    uint32_t FLTEN5:1;
    uint32_t FSEL6:5;
    uint32_t MSEL6:2;
    uint32_t FLTEN6:1;
    uint32_t FSEL7:5;
    uint32_t MSEL7:2;
    uint32_t FLTEN7:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON1bits_t;
extern volatile __C1FLTCON1bits_t C1FLTCON1bits __asm__ ("C1FLTCON1") __attribute__((section("sfrs"), address(0xBF8800D0)));
extern volatile uint32_t        C1FLTCON1CLR __attribute__((section("sfrs"),address(0xBF8800D4)));
extern volatile uint32_t        C1FLTCON1SET __attribute__((section("sfrs"),address(0xBF8800D8)));
extern volatile uint32_t        C1FLTCON1INV __attribute__((section("sfrs"),address(0xBF8800DC)));
#define C1FLTCON2 C1FLTCON2
extern volatile uint32_t   C1FLTCON2 __attribute__((section("sfrs"), address(0xBF8800E0)));
typedef union {
  struct {
    uint32_t FSEL8:5;
    uint32_t MSEL8:2;
    uint32_t FLTEN8:1;
    uint32_t FSEL9:5;
    uint32_t MSEL9:2;
    uint32_t FLTEN9:1;
    uint32_t FSEL10:5;
    uint32_t MSEL10:2;
    uint32_t FLTEN10:1;
    uint32_t FSEL11:5;
    uint32_t MSEL11:2;
    uint32_t FLTEN11:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON2bits_t;
extern volatile __C1FLTCON2bits_t C1FLTCON2bits __asm__ ("C1FLTCON2") __attribute__((section("sfrs"), address(0xBF8800E0)));
extern volatile uint32_t        C1FLTCON2CLR __attribute__((section("sfrs"),address(0xBF8800E4)));
extern volatile uint32_t        C1FLTCON2SET __attribute__((section("sfrs"),address(0xBF8800E8)));
extern volatile uint32_t        C1FLTCON2INV __attribute__((section("sfrs"),address(0xBF8800EC)));
#define C1FLTCON3 C1FLTCON3
extern volatile uint32_t   C1FLTCON3 __attribute__((section("sfrs"), address(0xBF8800F0)));
typedef union {
  struct {
    uint32_t FSEL12:5;
    uint32_t MSEL12:2;
    uint32_t FLTEN12:1;
    uint32_t FSEL13:5;
    uint32_t MSEL13:2;
    uint32_t FLTEN13:1;
    uint32_t FSEL14:5;
    uint32_t MSEL14:2;
    uint32_t FLTEN14:1;
    uint32_t FSEL15:5;
    uint32_t MSEL15:2;
    uint32_t FLTEN15:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON3bits_t;
extern volatile __C1FLTCON3bits_t C1FLTCON3bits __asm__ ("C1FLTCON3") __attribute__((section("sfrs"), address(0xBF8800F0)));
extern volatile uint32_t        C1FLTCON3CLR __attribute__((section("sfrs"),address(0xBF8800F4)));
extern volatile uint32_t        C1FLTCON3SET __attribute__((section("sfrs"),address(0xBF8800F8)));
extern volatile uint32_t        C1FLTCON3INV __attribute__((section("sfrs"),address(0xBF8800FC)));
#define C1FLTCON4 C1FLTCON4
extern volatile uint32_t   C1FLTCON4 __attribute__((section("sfrs"), address(0xBF880100)));
typedef union {
  struct {
    uint32_t FSEL16:5;
    uint32_t MSEL16:2;
    uint32_t FLTEN16:1;
    uint32_t FSEL17:5;
    uint32_t MSEL17:2;
    uint32_t FLTEN17:1;
    uint32_t FSEL18:5;
    uint32_t MSEL18:2;
    uint32_t FLTEN18:1;
    uint32_t FSEL19:5;
    uint32_t MSEL19:2;
    uint32_t FLTEN19:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON4bits_t;
extern volatile __C1FLTCON4bits_t C1FLTCON4bits __asm__ ("C1FLTCON4") __attribute__((section("sfrs"), address(0xBF880100)));
extern volatile uint32_t        C1FLTCON4CLR __attribute__((section("sfrs"),address(0xBF880104)));
extern volatile uint32_t        C1FLTCON4SET __attribute__((section("sfrs"),address(0xBF880108)));
extern volatile uint32_t        C1FLTCON4INV __attribute__((section("sfrs"),address(0xBF88010C)));
#define C1FLTCON5 C1FLTCON5
extern volatile uint32_t   C1FLTCON5 __attribute__((section("sfrs"), address(0xBF880110)));
typedef union {
  struct {
    uint32_t FSEL20:5;
    uint32_t MSEL20:2;
    uint32_t FLTEN20:1;
    uint32_t FSEL21:5;
    uint32_t MSEL21:2;
    uint32_t FLTEN21:1;
    uint32_t FSEL22:5;
    uint32_t MSEL22:2;
    uint32_t FLTEN22:1;
    uint32_t FSEL23:5;
    uint32_t MSEL23:2;
    uint32_t FLTEN23:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON5bits_t;
extern volatile __C1FLTCON5bits_t C1FLTCON5bits __asm__ ("C1FLTCON5") __attribute__((section("sfrs"), address(0xBF880110)));
extern volatile uint32_t        C1FLTCON5CLR __attribute__((section("sfrs"),address(0xBF880114)));
extern volatile uint32_t        C1FLTCON5SET __attribute__((section("sfrs"),address(0xBF880118)));
extern volatile uint32_t        C1FLTCON5INV __attribute__((section("sfrs"),address(0xBF88011C)));
#define C1FLTCON6 C1FLTCON6
extern volatile uint32_t   C1FLTCON6 __attribute__((section("sfrs"), address(0xBF880120)));
typedef union {
  struct {
    uint32_t FSEL24:5;
    uint32_t MSEL24:2;
    uint32_t FLTEN24:1;
    uint32_t FSEL25:5;
    uint32_t MSEL25:2;
    uint32_t FLTEN25:1;
    uint32_t FSEL26:5;
    uint32_t MSEL26:2;
    uint32_t FLTEN26:1;
    uint32_t FSEL27:5;
    uint32_t MSEL27:2;
    uint32_t FLTEN27:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON6bits_t;
extern volatile __C1FLTCON6bits_t C1FLTCON6bits __asm__ ("C1FLTCON6") __attribute__((section("sfrs"), address(0xBF880120)));
extern volatile uint32_t        C1FLTCON6CLR __attribute__((section("sfrs"),address(0xBF880124)));
extern volatile uint32_t        C1FLTCON6SET __attribute__((section("sfrs"),address(0xBF880128)));
extern volatile uint32_t        C1FLTCON6INV __attribute__((section("sfrs"),address(0xBF88012C)));
#define C1FLTCON7 C1FLTCON7
extern volatile uint32_t   C1FLTCON7 __attribute__((section("sfrs"), address(0xBF880130)));
typedef union {
  struct {
    uint32_t FSEL28:5;
    uint32_t MSEL28:2;
    uint32_t FLTEN28:1;
    uint32_t FSEL29:5;
    uint32_t MSEL29:2;
    uint32_t FLTEN29:1;
    uint32_t FSEL30:5;
    uint32_t MSEL30:2;
    uint32_t FLTEN30:1;
    uint32_t FSEL31:5;
    uint32_t MSEL31:2;
    uint32_t FLTEN31:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FLTCON7bits_t;
extern volatile __C1FLTCON7bits_t C1FLTCON7bits __asm__ ("C1FLTCON7") __attribute__((section("sfrs"), address(0xBF880130)));
extern volatile uint32_t        C1FLTCON7CLR __attribute__((section("sfrs"),address(0xBF880134)));
extern volatile uint32_t        C1FLTCON7SET __attribute__((section("sfrs"),address(0xBF880138)));
extern volatile uint32_t        C1FLTCON7INV __attribute__((section("sfrs"),address(0xBF88013C)));
#define C1RXF0 C1RXF0
extern volatile uint32_t   C1RXF0 __attribute__((section("sfrs"), address(0xBF880140)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF0bits_t;
extern volatile __C1RXF0bits_t C1RXF0bits __asm__ ("C1RXF0") __attribute__((section("sfrs"), address(0xBF880140)));
extern volatile uint32_t        C1RXF0CLR __attribute__((section("sfrs"),address(0xBF880144)));
extern volatile uint32_t        C1RXF0SET __attribute__((section("sfrs"),address(0xBF880148)));
extern volatile uint32_t        C1RXF0INV __attribute__((section("sfrs"),address(0xBF88014C)));
#define C1RXF1 C1RXF1
extern volatile uint32_t   C1RXF1 __attribute__((section("sfrs"), address(0xBF880150)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF1bits_t;
extern volatile __C1RXF1bits_t C1RXF1bits __asm__ ("C1RXF1") __attribute__((section("sfrs"), address(0xBF880150)));
extern volatile uint32_t        C1RXF1CLR __attribute__((section("sfrs"),address(0xBF880154)));
extern volatile uint32_t        C1RXF1SET __attribute__((section("sfrs"),address(0xBF880158)));
extern volatile uint32_t        C1RXF1INV __attribute__((section("sfrs"),address(0xBF88015C)));
#define C1RXF2 C1RXF2
extern volatile uint32_t   C1RXF2 __attribute__((section("sfrs"), address(0xBF880160)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF2bits_t;
extern volatile __C1RXF2bits_t C1RXF2bits __asm__ ("C1RXF2") __attribute__((section("sfrs"), address(0xBF880160)));
extern volatile uint32_t        C1RXF2CLR __attribute__((section("sfrs"),address(0xBF880164)));
extern volatile uint32_t        C1RXF2SET __attribute__((section("sfrs"),address(0xBF880168)));
extern volatile uint32_t        C1RXF2INV __attribute__((section("sfrs"),address(0xBF88016C)));
#define C1RXF3 C1RXF3
extern volatile uint32_t   C1RXF3 __attribute__((section("sfrs"), address(0xBF880170)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF3bits_t;
extern volatile __C1RXF3bits_t C1RXF3bits __asm__ ("C1RXF3") __attribute__((section("sfrs"), address(0xBF880170)));
extern volatile uint32_t        C1RXF3CLR __attribute__((section("sfrs"),address(0xBF880174)));
extern volatile uint32_t        C1RXF3SET __attribute__((section("sfrs"),address(0xBF880178)));
extern volatile uint32_t        C1RXF3INV __attribute__((section("sfrs"),address(0xBF88017C)));
#define C1RXF4 C1RXF4
extern volatile uint32_t   C1RXF4 __attribute__((section("sfrs"), address(0xBF880180)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF4bits_t;
extern volatile __C1RXF4bits_t C1RXF4bits __asm__ ("C1RXF4") __attribute__((section("sfrs"), address(0xBF880180)));
extern volatile uint32_t        C1RXF4CLR __attribute__((section("sfrs"),address(0xBF880184)));
extern volatile uint32_t        C1RXF4SET __attribute__((section("sfrs"),address(0xBF880188)));
extern volatile uint32_t        C1RXF4INV __attribute__((section("sfrs"),address(0xBF88018C)));
#define C1RXF5 C1RXF5
extern volatile uint32_t   C1RXF5 __attribute__((section("sfrs"), address(0xBF880190)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF5bits_t;
extern volatile __C1RXF5bits_t C1RXF5bits __asm__ ("C1RXF5") __attribute__((section("sfrs"), address(0xBF880190)));
extern volatile uint32_t        C1RXF5CLR __attribute__((section("sfrs"),address(0xBF880194)));
extern volatile uint32_t        C1RXF5SET __attribute__((section("sfrs"),address(0xBF880198)));
extern volatile uint32_t        C1RXF5INV __attribute__((section("sfrs"),address(0xBF88019C)));
#define C1RXF6 C1RXF6
extern volatile uint32_t   C1RXF6 __attribute__((section("sfrs"), address(0xBF8801A0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF6bits_t;
extern volatile __C1RXF6bits_t C1RXF6bits __asm__ ("C1RXF6") __attribute__((section("sfrs"), address(0xBF8801A0)));
extern volatile uint32_t        C1RXF6CLR __attribute__((section("sfrs"),address(0xBF8801A4)));
extern volatile uint32_t        C1RXF6SET __attribute__((section("sfrs"),address(0xBF8801A8)));
extern volatile uint32_t        C1RXF6INV __attribute__((section("sfrs"),address(0xBF8801AC)));
#define C1RXF7 C1RXF7
extern volatile uint32_t   C1RXF7 __attribute__((section("sfrs"), address(0xBF8801B0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF7bits_t;
extern volatile __C1RXF7bits_t C1RXF7bits __asm__ ("C1RXF7") __attribute__((section("sfrs"), address(0xBF8801B0)));
extern volatile uint32_t        C1RXF7CLR __attribute__((section("sfrs"),address(0xBF8801B4)));
extern volatile uint32_t        C1RXF7SET __attribute__((section("sfrs"),address(0xBF8801B8)));
extern volatile uint32_t        C1RXF7INV __attribute__((section("sfrs"),address(0xBF8801BC)));
#define C1RXF8 C1RXF8
extern volatile uint32_t   C1RXF8 __attribute__((section("sfrs"), address(0xBF8801C0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF8bits_t;
extern volatile __C1RXF8bits_t C1RXF8bits __asm__ ("C1RXF8") __attribute__((section("sfrs"), address(0xBF8801C0)));
extern volatile uint32_t        C1RXF8CLR __attribute__((section("sfrs"),address(0xBF8801C4)));
extern volatile uint32_t        C1RXF8SET __attribute__((section("sfrs"),address(0xBF8801C8)));
extern volatile uint32_t        C1RXF8INV __attribute__((section("sfrs"),address(0xBF8801CC)));
#define C1RXF9 C1RXF9
extern volatile uint32_t   C1RXF9 __attribute__((section("sfrs"), address(0xBF8801D0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF9bits_t;
extern volatile __C1RXF9bits_t C1RXF9bits __asm__ ("C1RXF9") __attribute__((section("sfrs"), address(0xBF8801D0)));
extern volatile uint32_t        C1RXF9CLR __attribute__((section("sfrs"),address(0xBF8801D4)));
extern volatile uint32_t        C1RXF9SET __attribute__((section("sfrs"),address(0xBF8801D8)));
extern volatile uint32_t        C1RXF9INV __attribute__((section("sfrs"),address(0xBF8801DC)));
#define C1RXF10 C1RXF10
extern volatile uint32_t   C1RXF10 __attribute__((section("sfrs"), address(0xBF8801E0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF10bits_t;
extern volatile __C1RXF10bits_t C1RXF10bits __asm__ ("C1RXF10") __attribute__((section("sfrs"), address(0xBF8801E0)));
extern volatile uint32_t        C1RXF10CLR __attribute__((section("sfrs"),address(0xBF8801E4)));
extern volatile uint32_t        C1RXF10SET __attribute__((section("sfrs"),address(0xBF8801E8)));
extern volatile uint32_t        C1RXF10INV __attribute__((section("sfrs"),address(0xBF8801EC)));
#define C1RXF11 C1RXF11
extern volatile uint32_t   C1RXF11 __attribute__((section("sfrs"), address(0xBF8801F0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF11bits_t;
extern volatile __C1RXF11bits_t C1RXF11bits __asm__ ("C1RXF11") __attribute__((section("sfrs"), address(0xBF8801F0)));
extern volatile uint32_t        C1RXF11CLR __attribute__((section("sfrs"),address(0xBF8801F4)));
extern volatile uint32_t        C1RXF11SET __attribute__((section("sfrs"),address(0xBF8801F8)));
extern volatile uint32_t        C1RXF11INV __attribute__((section("sfrs"),address(0xBF8801FC)));
#define C1RXF12 C1RXF12
extern volatile uint32_t   C1RXF12 __attribute__((section("sfrs"), address(0xBF880200)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF12bits_t;
extern volatile __C1RXF12bits_t C1RXF12bits __asm__ ("C1RXF12") __attribute__((section("sfrs"), address(0xBF880200)));
extern volatile uint32_t        C1RXF12CLR __attribute__((section("sfrs"),address(0xBF880204)));
extern volatile uint32_t        C1RXF12SET __attribute__((section("sfrs"),address(0xBF880208)));
extern volatile uint32_t        C1RXF12INV __attribute__((section("sfrs"),address(0xBF88020C)));
#define C1RXF13 C1RXF13
extern volatile uint32_t   C1RXF13 __attribute__((section("sfrs"), address(0xBF880210)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF13bits_t;
extern volatile __C1RXF13bits_t C1RXF13bits __asm__ ("C1RXF13") __attribute__((section("sfrs"), address(0xBF880210)));
extern volatile uint32_t        C1RXF13CLR __attribute__((section("sfrs"),address(0xBF880214)));
extern volatile uint32_t        C1RXF13SET __attribute__((section("sfrs"),address(0xBF880218)));
extern volatile uint32_t        C1RXF13INV __attribute__((section("sfrs"),address(0xBF88021C)));
#define C1RXF14 C1RXF14
extern volatile uint32_t   C1RXF14 __attribute__((section("sfrs"), address(0xBF880220)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF14bits_t;
extern volatile __C1RXF14bits_t C1RXF14bits __asm__ ("C1RXF14") __attribute__((section("sfrs"), address(0xBF880220)));
extern volatile uint32_t        C1RXF14CLR __attribute__((section("sfrs"),address(0xBF880224)));
extern volatile uint32_t        C1RXF14SET __attribute__((section("sfrs"),address(0xBF880228)));
extern volatile uint32_t        C1RXF14INV __attribute__((section("sfrs"),address(0xBF88022C)));
#define C1RXF15 C1RXF15
extern volatile uint32_t   C1RXF15 __attribute__((section("sfrs"), address(0xBF880230)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF15bits_t;
extern volatile __C1RXF15bits_t C1RXF15bits __asm__ ("C1RXF15") __attribute__((section("sfrs"), address(0xBF880230)));
extern volatile uint32_t        C1RXF15CLR __attribute__((section("sfrs"),address(0xBF880234)));
extern volatile uint32_t        C1RXF15SET __attribute__((section("sfrs"),address(0xBF880238)));
extern volatile uint32_t        C1RXF15INV __attribute__((section("sfrs"),address(0xBF88023C)));
#define C1RXF16 C1RXF16
extern volatile uint32_t   C1RXF16 __attribute__((section("sfrs"), address(0xBF880240)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF16bits_t;
extern volatile __C1RXF16bits_t C1RXF16bits __asm__ ("C1RXF16") __attribute__((section("sfrs"), address(0xBF880240)));
extern volatile uint32_t        C1RXF16CLR __attribute__((section("sfrs"),address(0xBF880244)));
extern volatile uint32_t        C1RXF16SET __attribute__((section("sfrs"),address(0xBF880248)));
extern volatile uint32_t        C1RXF16INV __attribute__((section("sfrs"),address(0xBF88024C)));
#define C1RXF17 C1RXF17
extern volatile uint32_t   C1RXF17 __attribute__((section("sfrs"), address(0xBF880250)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF17bits_t;
extern volatile __C1RXF17bits_t C1RXF17bits __asm__ ("C1RXF17") __attribute__((section("sfrs"), address(0xBF880250)));
extern volatile uint32_t        C1RXF17CLR __attribute__((section("sfrs"),address(0xBF880254)));
extern volatile uint32_t        C1RXF17SET __attribute__((section("sfrs"),address(0xBF880258)));
extern volatile uint32_t        C1RXF17INV __attribute__((section("sfrs"),address(0xBF88025C)));
#define C1RXF18 C1RXF18
extern volatile uint32_t   C1RXF18 __attribute__((section("sfrs"), address(0xBF880260)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF18bits_t;
extern volatile __C1RXF18bits_t C1RXF18bits __asm__ ("C1RXF18") __attribute__((section("sfrs"), address(0xBF880260)));
extern volatile uint32_t        C1RXF18CLR __attribute__((section("sfrs"),address(0xBF880264)));
extern volatile uint32_t        C1RXF18SET __attribute__((section("sfrs"),address(0xBF880268)));
extern volatile uint32_t        C1RXF18INV __attribute__((section("sfrs"),address(0xBF88026C)));
#define C1RXF19 C1RXF19
extern volatile uint32_t   C1RXF19 __attribute__((section("sfrs"), address(0xBF880270)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF19bits_t;
extern volatile __C1RXF19bits_t C1RXF19bits __asm__ ("C1RXF19") __attribute__((section("sfrs"), address(0xBF880270)));
extern volatile uint32_t        C1RXF19CLR __attribute__((section("sfrs"),address(0xBF880274)));
extern volatile uint32_t        C1RXF19SET __attribute__((section("sfrs"),address(0xBF880278)));
extern volatile uint32_t        C1RXF19INV __attribute__((section("sfrs"),address(0xBF88027C)));
#define C1RXF20 C1RXF20
extern volatile uint32_t   C1RXF20 __attribute__((section("sfrs"), address(0xBF880280)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF20bits_t;
extern volatile __C1RXF20bits_t C1RXF20bits __asm__ ("C1RXF20") __attribute__((section("sfrs"), address(0xBF880280)));
extern volatile uint32_t        C1RXF20CLR __attribute__((section("sfrs"),address(0xBF880284)));
extern volatile uint32_t        C1RXF20SET __attribute__((section("sfrs"),address(0xBF880288)));
extern volatile uint32_t        C1RXF20INV __attribute__((section("sfrs"),address(0xBF88028C)));
#define C1RXF21 C1RXF21
extern volatile uint32_t   C1RXF21 __attribute__((section("sfrs"), address(0xBF880290)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF21bits_t;
extern volatile __C1RXF21bits_t C1RXF21bits __asm__ ("C1RXF21") __attribute__((section("sfrs"), address(0xBF880290)));
extern volatile uint32_t        C1RXF21CLR __attribute__((section("sfrs"),address(0xBF880294)));
extern volatile uint32_t        C1RXF21SET __attribute__((section("sfrs"),address(0xBF880298)));
extern volatile uint32_t        C1RXF21INV __attribute__((section("sfrs"),address(0xBF88029C)));
#define C1RXF22 C1RXF22
extern volatile uint32_t   C1RXF22 __attribute__((section("sfrs"), address(0xBF8802A0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF22bits_t;
extern volatile __C1RXF22bits_t C1RXF22bits __asm__ ("C1RXF22") __attribute__((section("sfrs"), address(0xBF8802A0)));
extern volatile uint32_t        C1RXF22CLR __attribute__((section("sfrs"),address(0xBF8802A4)));
extern volatile uint32_t        C1RXF22SET __attribute__((section("sfrs"),address(0xBF8802A8)));
extern volatile uint32_t        C1RXF22INV __attribute__((section("sfrs"),address(0xBF8802AC)));
#define C1RXF23 C1RXF23
extern volatile uint32_t   C1RXF23 __attribute__((section("sfrs"), address(0xBF8802B0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF23bits_t;
extern volatile __C1RXF23bits_t C1RXF23bits __asm__ ("C1RXF23") __attribute__((section("sfrs"), address(0xBF8802B0)));
extern volatile uint32_t        C1RXF23CLR __attribute__((section("sfrs"),address(0xBF8802B4)));
extern volatile uint32_t        C1RXF23SET __attribute__((section("sfrs"),address(0xBF8802B8)));
extern volatile uint32_t        C1RXF23INV __attribute__((section("sfrs"),address(0xBF8802BC)));
#define C1RXF24 C1RXF24
extern volatile uint32_t   C1RXF24 __attribute__((section("sfrs"), address(0xBF8802C0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF24bits_t;
extern volatile __C1RXF24bits_t C1RXF24bits __asm__ ("C1RXF24") __attribute__((section("sfrs"), address(0xBF8802C0)));
extern volatile uint32_t        C1RXF24CLR __attribute__((section("sfrs"),address(0xBF8802C4)));
extern volatile uint32_t        C1RXF24SET __attribute__((section("sfrs"),address(0xBF8802C8)));
extern volatile uint32_t        C1RXF24INV __attribute__((section("sfrs"),address(0xBF8802CC)));
#define C1RXF25 C1RXF25
extern volatile uint32_t   C1RXF25 __attribute__((section("sfrs"), address(0xBF8802D0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF25bits_t;
extern volatile __C1RXF25bits_t C1RXF25bits __asm__ ("C1RXF25") __attribute__((section("sfrs"), address(0xBF8802D0)));
extern volatile uint32_t        C1RXF25CLR __attribute__((section("sfrs"),address(0xBF8802D4)));
extern volatile uint32_t        C1RXF25SET __attribute__((section("sfrs"),address(0xBF8802D8)));
extern volatile uint32_t        C1RXF25INV __attribute__((section("sfrs"),address(0xBF8802DC)));
#define C1RXF26 C1RXF26
extern volatile uint32_t   C1RXF26 __attribute__((section("sfrs"), address(0xBF8802E0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF26bits_t;
extern volatile __C1RXF26bits_t C1RXF26bits __asm__ ("C1RXF26") __attribute__((section("sfrs"), address(0xBF8802E0)));
extern volatile uint32_t        C1RXF26CLR __attribute__((section("sfrs"),address(0xBF8802E4)));
extern volatile uint32_t        C1RXF26SET __attribute__((section("sfrs"),address(0xBF8802E8)));
extern volatile uint32_t        C1RXF26INV __attribute__((section("sfrs"),address(0xBF8802EC)));
#define C1RXF27 C1RXF27
extern volatile uint32_t   C1RXF27 __attribute__((section("sfrs"), address(0xBF8802F0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF27bits_t;
extern volatile __C1RXF27bits_t C1RXF27bits __asm__ ("C1RXF27") __attribute__((section("sfrs"), address(0xBF8802F0)));
extern volatile uint32_t        C1RXF27CLR __attribute__((section("sfrs"),address(0xBF8802F4)));
extern volatile uint32_t        C1RXF27SET __attribute__((section("sfrs"),address(0xBF8802F8)));
extern volatile uint32_t        C1RXF27INV __attribute__((section("sfrs"),address(0xBF8802FC)));
#define C1RXF28 C1RXF28
extern volatile uint32_t   C1RXF28 __attribute__((section("sfrs"), address(0xBF880300)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF28bits_t;
extern volatile __C1RXF28bits_t C1RXF28bits __asm__ ("C1RXF28") __attribute__((section("sfrs"), address(0xBF880300)));
extern volatile uint32_t        C1RXF28CLR __attribute__((section("sfrs"),address(0xBF880304)));
extern volatile uint32_t        C1RXF28SET __attribute__((section("sfrs"),address(0xBF880308)));
extern volatile uint32_t        C1RXF28INV __attribute__((section("sfrs"),address(0xBF88030C)));
#define C1RXF29 C1RXF29
extern volatile uint32_t   C1RXF29 __attribute__((section("sfrs"), address(0xBF880310)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF29bits_t;
extern volatile __C1RXF29bits_t C1RXF29bits __asm__ ("C1RXF29") __attribute__((section("sfrs"), address(0xBF880310)));
extern volatile uint32_t        C1RXF29CLR __attribute__((section("sfrs"),address(0xBF880314)));
extern volatile uint32_t        C1RXF29SET __attribute__((section("sfrs"),address(0xBF880318)));
extern volatile uint32_t        C1RXF29INV __attribute__((section("sfrs"),address(0xBF88031C)));
#define C1RXF30 C1RXF30
extern volatile uint32_t   C1RXF30 __attribute__((section("sfrs"), address(0xBF880320)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF30bits_t;
extern volatile __C1RXF30bits_t C1RXF30bits __asm__ ("C1RXF30") __attribute__((section("sfrs"), address(0xBF880320)));
extern volatile uint32_t        C1RXF30CLR __attribute__((section("sfrs"),address(0xBF880324)));
extern volatile uint32_t        C1RXF30SET __attribute__((section("sfrs"),address(0xBF880328)));
extern volatile uint32_t        C1RXF30INV __attribute__((section("sfrs"),address(0xBF88032C)));
#define C1RXF31 C1RXF31
extern volatile uint32_t   C1RXF31 __attribute__((section("sfrs"), address(0xBF880330)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C1RXF31bits_t;
extern volatile __C1RXF31bits_t C1RXF31bits __asm__ ("C1RXF31") __attribute__((section("sfrs"), address(0xBF880330)));
extern volatile uint32_t        C1RXF31CLR __attribute__((section("sfrs"),address(0xBF880334)));
extern volatile uint32_t        C1RXF31SET __attribute__((section("sfrs"),address(0xBF880338)));
extern volatile uint32_t        C1RXF31INV __attribute__((section("sfrs"),address(0xBF88033C)));
#define C1FIFOBA C1FIFOBA
extern volatile uint32_t   C1FIFOBA __attribute__((section("sfrs"), address(0xBF880340)));
extern volatile uint32_t        C1FIFOBACLR __attribute__((section("sfrs"),address(0xBF880344)));
extern volatile uint32_t        C1FIFOBASET __attribute__((section("sfrs"),address(0xBF880348)));
extern volatile uint32_t        C1FIFOBAINV __attribute__((section("sfrs"),address(0xBF88034C)));
#define C1FIFOCON0 C1FIFOCON0
extern volatile uint32_t   C1FIFOCON0 __attribute__((section("sfrs"), address(0xBF880350)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON0bits_t;
extern volatile __C1FIFOCON0bits_t C1FIFOCON0bits __asm__ ("C1FIFOCON0") __attribute__((section("sfrs"), address(0xBF880350)));
extern volatile uint32_t        C1FIFOCON0CLR __attribute__((section("sfrs"),address(0xBF880354)));
extern volatile uint32_t        C1FIFOCON0SET __attribute__((section("sfrs"),address(0xBF880358)));
extern volatile uint32_t        C1FIFOCON0INV __attribute__((section("sfrs"),address(0xBF88035C)));
#define C1FIFOINT0 C1FIFOINT0
extern volatile uint32_t   C1FIFOINT0 __attribute__((section("sfrs"), address(0xBF880360)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT0bits_t;
extern volatile __C1FIFOINT0bits_t C1FIFOINT0bits __asm__ ("C1FIFOINT0") __attribute__((section("sfrs"), address(0xBF880360)));
extern volatile uint32_t        C1FIFOINT0CLR __attribute__((section("sfrs"),address(0xBF880364)));
extern volatile uint32_t        C1FIFOINT0SET __attribute__((section("sfrs"),address(0xBF880368)));
extern volatile uint32_t        C1FIFOINT0INV __attribute__((section("sfrs"),address(0xBF88036C)));
#define C1FIFOUA0 C1FIFOUA0
extern volatile uint32_t   C1FIFOUA0 __attribute__((section("sfrs"), address(0xBF880370)));
extern volatile uint32_t        C1FIFOUA0CLR __attribute__((section("sfrs"),address(0xBF880374)));
extern volatile uint32_t        C1FIFOUA0SET __attribute__((section("sfrs"),address(0xBF880378)));
extern volatile uint32_t        C1FIFOUA0INV __attribute__((section("sfrs"),address(0xBF88037C)));
#define C1FIFOCI0 C1FIFOCI0
extern volatile uint32_t   C1FIFOCI0 __attribute__((section("sfrs"), address(0xBF880380)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI0bits_t;
extern volatile __C1FIFOCI0bits_t C1FIFOCI0bits __asm__ ("C1FIFOCI0") __attribute__((section("sfrs"), address(0xBF880380)));
extern volatile uint32_t        C1FIFOCI0CLR __attribute__((section("sfrs"),address(0xBF880384)));
extern volatile uint32_t        C1FIFOCI0SET __attribute__((section("sfrs"),address(0xBF880388)));
extern volatile uint32_t        C1FIFOCI0INV __attribute__((section("sfrs"),address(0xBF88038C)));
#define C1FIFOCON1 C1FIFOCON1
extern volatile uint32_t   C1FIFOCON1 __attribute__((section("sfrs"), address(0xBF880390)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON1bits_t;
extern volatile __C1FIFOCON1bits_t C1FIFOCON1bits __asm__ ("C1FIFOCON1") __attribute__((section("sfrs"), address(0xBF880390)));
extern volatile uint32_t        C1FIFOCON1CLR __attribute__((section("sfrs"),address(0xBF880394)));
extern volatile uint32_t        C1FIFOCON1SET __attribute__((section("sfrs"),address(0xBF880398)));
extern volatile uint32_t        C1FIFOCON1INV __attribute__((section("sfrs"),address(0xBF88039C)));
#define C1FIFOINT1 C1FIFOINT1
extern volatile uint32_t   C1FIFOINT1 __attribute__((section("sfrs"), address(0xBF8803A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT1bits_t;
extern volatile __C1FIFOINT1bits_t C1FIFOINT1bits __asm__ ("C1FIFOINT1") __attribute__((section("sfrs"), address(0xBF8803A0)));
extern volatile uint32_t        C1FIFOINT1CLR __attribute__((section("sfrs"),address(0xBF8803A4)));
extern volatile uint32_t        C1FIFOINT1SET __attribute__((section("sfrs"),address(0xBF8803A8)));
extern volatile uint32_t        C1FIFOINT1INV __attribute__((section("sfrs"),address(0xBF8803AC)));
#define C1FIFOUA1 C1FIFOUA1
extern volatile uint32_t   C1FIFOUA1 __attribute__((section("sfrs"), address(0xBF8803B0)));
extern volatile uint32_t        C1FIFOUA1CLR __attribute__((section("sfrs"),address(0xBF8803B4)));
extern volatile uint32_t        C1FIFOUA1SET __attribute__((section("sfrs"),address(0xBF8803B8)));
extern volatile uint32_t        C1FIFOUA1INV __attribute__((section("sfrs"),address(0xBF8803BC)));
#define C1FIFOCI1 C1FIFOCI1
extern volatile uint32_t   C1FIFOCI1 __attribute__((section("sfrs"), address(0xBF8803C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI1bits_t;
extern volatile __C1FIFOCI1bits_t C1FIFOCI1bits __asm__ ("C1FIFOCI1") __attribute__((section("sfrs"), address(0xBF8803C0)));
extern volatile uint32_t        C1FIFOCI1CLR __attribute__((section("sfrs"),address(0xBF8803C4)));
extern volatile uint32_t        C1FIFOCI1SET __attribute__((section("sfrs"),address(0xBF8803C8)));
extern volatile uint32_t        C1FIFOCI1INV __attribute__((section("sfrs"),address(0xBF8803CC)));
#define C1FIFOCON2 C1FIFOCON2
extern volatile uint32_t   C1FIFOCON2 __attribute__((section("sfrs"), address(0xBF8803D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON2bits_t;
extern volatile __C1FIFOCON2bits_t C1FIFOCON2bits __asm__ ("C1FIFOCON2") __attribute__((section("sfrs"), address(0xBF8803D0)));
extern volatile uint32_t        C1FIFOCON2CLR __attribute__((section("sfrs"),address(0xBF8803D4)));
extern volatile uint32_t        C1FIFOCON2SET __attribute__((section("sfrs"),address(0xBF8803D8)));
extern volatile uint32_t        C1FIFOCON2INV __attribute__((section("sfrs"),address(0xBF8803DC)));
#define C1FIFOINT2 C1FIFOINT2
extern volatile uint32_t   C1FIFOINT2 __attribute__((section("sfrs"), address(0xBF8803E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT2bits_t;
extern volatile __C1FIFOINT2bits_t C1FIFOINT2bits __asm__ ("C1FIFOINT2") __attribute__((section("sfrs"), address(0xBF8803E0)));
extern volatile uint32_t        C1FIFOINT2CLR __attribute__((section("sfrs"),address(0xBF8803E4)));
extern volatile uint32_t        C1FIFOINT2SET __attribute__((section("sfrs"),address(0xBF8803E8)));
extern volatile uint32_t        C1FIFOINT2INV __attribute__((section("sfrs"),address(0xBF8803EC)));
#define C1FIFOUA2 C1FIFOUA2
extern volatile uint32_t   C1FIFOUA2 __attribute__((section("sfrs"), address(0xBF8803F0)));
extern volatile uint32_t        C1FIFOUA2CLR __attribute__((section("sfrs"),address(0xBF8803F4)));
extern volatile uint32_t        C1FIFOUA2SET __attribute__((section("sfrs"),address(0xBF8803F8)));
extern volatile uint32_t        C1FIFOUA2INV __attribute__((section("sfrs"),address(0xBF8803FC)));
#define C1FIFOCI2 C1FIFOCI2
extern volatile uint32_t   C1FIFOCI2 __attribute__((section("sfrs"), address(0xBF880400)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI2bits_t;
extern volatile __C1FIFOCI2bits_t C1FIFOCI2bits __asm__ ("C1FIFOCI2") __attribute__((section("sfrs"), address(0xBF880400)));
extern volatile uint32_t        C1FIFOCI2CLR __attribute__((section("sfrs"),address(0xBF880404)));
extern volatile uint32_t        C1FIFOCI2SET __attribute__((section("sfrs"),address(0xBF880408)));
extern volatile uint32_t        C1FIFOCI2INV __attribute__((section("sfrs"),address(0xBF88040C)));
#define C1FIFOCON3 C1FIFOCON3
extern volatile uint32_t   C1FIFOCON3 __attribute__((section("sfrs"), address(0xBF880410)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON3bits_t;
extern volatile __C1FIFOCON3bits_t C1FIFOCON3bits __asm__ ("C1FIFOCON3") __attribute__((section("sfrs"), address(0xBF880410)));
extern volatile uint32_t        C1FIFOCON3CLR __attribute__((section("sfrs"),address(0xBF880414)));
extern volatile uint32_t        C1FIFOCON3SET __attribute__((section("sfrs"),address(0xBF880418)));
extern volatile uint32_t        C1FIFOCON3INV __attribute__((section("sfrs"),address(0xBF88041C)));
#define C1FIFOINT3 C1FIFOINT3
extern volatile uint32_t   C1FIFOINT3 __attribute__((section("sfrs"), address(0xBF880420)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT3bits_t;
extern volatile __C1FIFOINT3bits_t C1FIFOINT3bits __asm__ ("C1FIFOINT3") __attribute__((section("sfrs"), address(0xBF880420)));
extern volatile uint32_t        C1FIFOINT3CLR __attribute__((section("sfrs"),address(0xBF880424)));
extern volatile uint32_t        C1FIFOINT3SET __attribute__((section("sfrs"),address(0xBF880428)));
extern volatile uint32_t        C1FIFOINT3INV __attribute__((section("sfrs"),address(0xBF88042C)));
#define C1FIFOUA3 C1FIFOUA3
extern volatile uint32_t   C1FIFOUA3 __attribute__((section("sfrs"), address(0xBF880430)));
extern volatile uint32_t        C1FIFOUA3CLR __attribute__((section("sfrs"),address(0xBF880434)));
extern volatile uint32_t        C1FIFOUA3SET __attribute__((section("sfrs"),address(0xBF880438)));
extern volatile uint32_t        C1FIFOUA3INV __attribute__((section("sfrs"),address(0xBF88043C)));
#define C1FIFOCI3 C1FIFOCI3
extern volatile uint32_t   C1FIFOCI3 __attribute__((section("sfrs"), address(0xBF880440)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI3bits_t;
extern volatile __C1FIFOCI3bits_t C1FIFOCI3bits __asm__ ("C1FIFOCI3") __attribute__((section("sfrs"), address(0xBF880440)));
extern volatile uint32_t        C1FIFOCI3CLR __attribute__((section("sfrs"),address(0xBF880444)));
extern volatile uint32_t        C1FIFOCI3SET __attribute__((section("sfrs"),address(0xBF880448)));
extern volatile uint32_t        C1FIFOCI3INV __attribute__((section("sfrs"),address(0xBF88044C)));
#define C1FIFOCON4 C1FIFOCON4
extern volatile uint32_t   C1FIFOCON4 __attribute__((section("sfrs"), address(0xBF880450)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON4bits_t;
extern volatile __C1FIFOCON4bits_t C1FIFOCON4bits __asm__ ("C1FIFOCON4") __attribute__((section("sfrs"), address(0xBF880450)));
extern volatile uint32_t        C1FIFOCON4CLR __attribute__((section("sfrs"),address(0xBF880454)));
extern volatile uint32_t        C1FIFOCON4SET __attribute__((section("sfrs"),address(0xBF880458)));
extern volatile uint32_t        C1FIFOCON4INV __attribute__((section("sfrs"),address(0xBF88045C)));
#define C1FIFOINT4 C1FIFOINT4
extern volatile uint32_t   C1FIFOINT4 __attribute__((section("sfrs"), address(0xBF880460)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT4bits_t;
extern volatile __C1FIFOINT4bits_t C1FIFOINT4bits __asm__ ("C1FIFOINT4") __attribute__((section("sfrs"), address(0xBF880460)));
extern volatile uint32_t        C1FIFOINT4CLR __attribute__((section("sfrs"),address(0xBF880464)));
extern volatile uint32_t        C1FIFOINT4SET __attribute__((section("sfrs"),address(0xBF880468)));
extern volatile uint32_t        C1FIFOINT4INV __attribute__((section("sfrs"),address(0xBF88046C)));
#define C1FIFOUA4 C1FIFOUA4
extern volatile uint32_t   C1FIFOUA4 __attribute__((section("sfrs"), address(0xBF880470)));
extern volatile uint32_t        C1FIFOUA4CLR __attribute__((section("sfrs"),address(0xBF880474)));
extern volatile uint32_t        C1FIFOUA4SET __attribute__((section("sfrs"),address(0xBF880478)));
extern volatile uint32_t        C1FIFOUA4INV __attribute__((section("sfrs"),address(0xBF88047C)));
#define C1FIFOCI4 C1FIFOCI4
extern volatile uint32_t   C1FIFOCI4 __attribute__((section("sfrs"), address(0xBF880480)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI4bits_t;
extern volatile __C1FIFOCI4bits_t C1FIFOCI4bits __asm__ ("C1FIFOCI4") __attribute__((section("sfrs"), address(0xBF880480)));
extern volatile uint32_t        C1FIFOCI4CLR __attribute__((section("sfrs"),address(0xBF880484)));
extern volatile uint32_t        C1FIFOCI4SET __attribute__((section("sfrs"),address(0xBF880488)));
extern volatile uint32_t        C1FIFOCI4INV __attribute__((section("sfrs"),address(0xBF88048C)));
#define C1FIFOCON5 C1FIFOCON5
extern volatile uint32_t   C1FIFOCON5 __attribute__((section("sfrs"), address(0xBF880490)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON5bits_t;
extern volatile __C1FIFOCON5bits_t C1FIFOCON5bits __asm__ ("C1FIFOCON5") __attribute__((section("sfrs"), address(0xBF880490)));
extern volatile uint32_t        C1FIFOCON5CLR __attribute__((section("sfrs"),address(0xBF880494)));
extern volatile uint32_t        C1FIFOCON5SET __attribute__((section("sfrs"),address(0xBF880498)));
extern volatile uint32_t        C1FIFOCON5INV __attribute__((section("sfrs"),address(0xBF88049C)));
#define C1FIFOINT5 C1FIFOINT5
extern volatile uint32_t   C1FIFOINT5 __attribute__((section("sfrs"), address(0xBF8804A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT5bits_t;
extern volatile __C1FIFOINT5bits_t C1FIFOINT5bits __asm__ ("C1FIFOINT5") __attribute__((section("sfrs"), address(0xBF8804A0)));
extern volatile uint32_t        C1FIFOINT5CLR __attribute__((section("sfrs"),address(0xBF8804A4)));
extern volatile uint32_t        C1FIFOINT5SET __attribute__((section("sfrs"),address(0xBF8804A8)));
extern volatile uint32_t        C1FIFOINT5INV __attribute__((section("sfrs"),address(0xBF8804AC)));
#define C1FIFOUA5 C1FIFOUA5
extern volatile uint32_t   C1FIFOUA5 __attribute__((section("sfrs"), address(0xBF8804B0)));
extern volatile uint32_t        C1FIFOUA5CLR __attribute__((section("sfrs"),address(0xBF8804B4)));
extern volatile uint32_t        C1FIFOUA5SET __attribute__((section("sfrs"),address(0xBF8804B8)));
extern volatile uint32_t        C1FIFOUA5INV __attribute__((section("sfrs"),address(0xBF8804BC)));
#define C1FIFOCI5 C1FIFOCI5
extern volatile uint32_t   C1FIFOCI5 __attribute__((section("sfrs"), address(0xBF8804C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI5bits_t;
extern volatile __C1FIFOCI5bits_t C1FIFOCI5bits __asm__ ("C1FIFOCI5") __attribute__((section("sfrs"), address(0xBF8804C0)));
extern volatile uint32_t        C1FIFOCI5CLR __attribute__((section("sfrs"),address(0xBF8804C4)));
extern volatile uint32_t        C1FIFOCI5SET __attribute__((section("sfrs"),address(0xBF8804C8)));
extern volatile uint32_t        C1FIFOCI5INV __attribute__((section("sfrs"),address(0xBF8804CC)));
#define C1FIFOCON6 C1FIFOCON6
extern volatile uint32_t   C1FIFOCON6 __attribute__((section("sfrs"), address(0xBF8804D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON6bits_t;
extern volatile __C1FIFOCON6bits_t C1FIFOCON6bits __asm__ ("C1FIFOCON6") __attribute__((section("sfrs"), address(0xBF8804D0)));
extern volatile uint32_t        C1FIFOCON6CLR __attribute__((section("sfrs"),address(0xBF8804D4)));
extern volatile uint32_t        C1FIFOCON6SET __attribute__((section("sfrs"),address(0xBF8804D8)));
extern volatile uint32_t        C1FIFOCON6INV __attribute__((section("sfrs"),address(0xBF8804DC)));
#define C1FIFOINT6 C1FIFOINT6
extern volatile uint32_t   C1FIFOINT6 __attribute__((section("sfrs"), address(0xBF8804E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT6bits_t;
extern volatile __C1FIFOINT6bits_t C1FIFOINT6bits __asm__ ("C1FIFOINT6") __attribute__((section("sfrs"), address(0xBF8804E0)));
extern volatile uint32_t        C1FIFOINT6CLR __attribute__((section("sfrs"),address(0xBF8804E4)));
extern volatile uint32_t        C1FIFOINT6SET __attribute__((section("sfrs"),address(0xBF8804E8)));
extern volatile uint32_t        C1FIFOINT6INV __attribute__((section("sfrs"),address(0xBF8804EC)));
#define C1FIFOUA6 C1FIFOUA6
extern volatile uint32_t   C1FIFOUA6 __attribute__((section("sfrs"), address(0xBF8804F0)));
extern volatile uint32_t        C1FIFOUA6CLR __attribute__((section("sfrs"),address(0xBF8804F4)));
extern volatile uint32_t        C1FIFOUA6SET __attribute__((section("sfrs"),address(0xBF8804F8)));
extern volatile uint32_t        C1FIFOUA6INV __attribute__((section("sfrs"),address(0xBF8804FC)));
#define C1FIFOCI6 C1FIFOCI6
extern volatile uint32_t   C1FIFOCI6 __attribute__((section("sfrs"), address(0xBF880500)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI6bits_t;
extern volatile __C1FIFOCI6bits_t C1FIFOCI6bits __asm__ ("C1FIFOCI6") __attribute__((section("sfrs"), address(0xBF880500)));
extern volatile uint32_t        C1FIFOCI6CLR __attribute__((section("sfrs"),address(0xBF880504)));
extern volatile uint32_t        C1FIFOCI6SET __attribute__((section("sfrs"),address(0xBF880508)));
extern volatile uint32_t        C1FIFOCI6INV __attribute__((section("sfrs"),address(0xBF88050C)));
#define C1FIFOCON7 C1FIFOCON7
extern volatile uint32_t   C1FIFOCON7 __attribute__((section("sfrs"), address(0xBF880510)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON7bits_t;
extern volatile __C1FIFOCON7bits_t C1FIFOCON7bits __asm__ ("C1FIFOCON7") __attribute__((section("sfrs"), address(0xBF880510)));
extern volatile uint32_t        C1FIFOCON7CLR __attribute__((section("sfrs"),address(0xBF880514)));
extern volatile uint32_t        C1FIFOCON7SET __attribute__((section("sfrs"),address(0xBF880518)));
extern volatile uint32_t        C1FIFOCON7INV __attribute__((section("sfrs"),address(0xBF88051C)));
#define C1FIFOINT7 C1FIFOINT7
extern volatile uint32_t   C1FIFOINT7 __attribute__((section("sfrs"), address(0xBF880520)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT7bits_t;
extern volatile __C1FIFOINT7bits_t C1FIFOINT7bits __asm__ ("C1FIFOINT7") __attribute__((section("sfrs"), address(0xBF880520)));
extern volatile uint32_t        C1FIFOINT7CLR __attribute__((section("sfrs"),address(0xBF880524)));
extern volatile uint32_t        C1FIFOINT7SET __attribute__((section("sfrs"),address(0xBF880528)));
extern volatile uint32_t        C1FIFOINT7INV __attribute__((section("sfrs"),address(0xBF88052C)));
#define C1FIFOUA7 C1FIFOUA7
extern volatile uint32_t   C1FIFOUA7 __attribute__((section("sfrs"), address(0xBF880530)));
extern volatile uint32_t        C1FIFOUA7CLR __attribute__((section("sfrs"),address(0xBF880534)));
extern volatile uint32_t        C1FIFOUA7SET __attribute__((section("sfrs"),address(0xBF880538)));
extern volatile uint32_t        C1FIFOUA7INV __attribute__((section("sfrs"),address(0xBF88053C)));
#define C1FIFOCI7 C1FIFOCI7
extern volatile uint32_t   C1FIFOCI7 __attribute__((section("sfrs"), address(0xBF880540)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI7bits_t;
extern volatile __C1FIFOCI7bits_t C1FIFOCI7bits __asm__ ("C1FIFOCI7") __attribute__((section("sfrs"), address(0xBF880540)));
extern volatile uint32_t        C1FIFOCI7CLR __attribute__((section("sfrs"),address(0xBF880544)));
extern volatile uint32_t        C1FIFOCI7SET __attribute__((section("sfrs"),address(0xBF880548)));
extern volatile uint32_t        C1FIFOCI7INV __attribute__((section("sfrs"),address(0xBF88054C)));
#define C1FIFOCON8 C1FIFOCON8
extern volatile uint32_t   C1FIFOCON8 __attribute__((section("sfrs"), address(0xBF880550)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON8bits_t;
extern volatile __C1FIFOCON8bits_t C1FIFOCON8bits __asm__ ("C1FIFOCON8") __attribute__((section("sfrs"), address(0xBF880550)));
extern volatile uint32_t        C1FIFOCON8CLR __attribute__((section("sfrs"),address(0xBF880554)));
extern volatile uint32_t        C1FIFOCON8SET __attribute__((section("sfrs"),address(0xBF880558)));
extern volatile uint32_t        C1FIFOCON8INV __attribute__((section("sfrs"),address(0xBF88055C)));
#define C1FIFOINT8 C1FIFOINT8
extern volatile uint32_t   C1FIFOINT8 __attribute__((section("sfrs"), address(0xBF880560)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT8bits_t;
extern volatile __C1FIFOINT8bits_t C1FIFOINT8bits __asm__ ("C1FIFOINT8") __attribute__((section("sfrs"), address(0xBF880560)));
extern volatile uint32_t        C1FIFOINT8CLR __attribute__((section("sfrs"),address(0xBF880564)));
extern volatile uint32_t        C1FIFOINT8SET __attribute__((section("sfrs"),address(0xBF880568)));
extern volatile uint32_t        C1FIFOINT8INV __attribute__((section("sfrs"),address(0xBF88056C)));
#define C1FIFOUA8 C1FIFOUA8
extern volatile uint32_t   C1FIFOUA8 __attribute__((section("sfrs"), address(0xBF880570)));
extern volatile uint32_t        C1FIFOUA8CLR __attribute__((section("sfrs"),address(0xBF880574)));
extern volatile uint32_t        C1FIFOUA8SET __attribute__((section("sfrs"),address(0xBF880578)));
extern volatile uint32_t        C1FIFOUA8INV __attribute__((section("sfrs"),address(0xBF88057C)));
#define C1FIFOCI8 C1FIFOCI8
extern volatile uint32_t   C1FIFOCI8 __attribute__((section("sfrs"), address(0xBF880580)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI8bits_t;
extern volatile __C1FIFOCI8bits_t C1FIFOCI8bits __asm__ ("C1FIFOCI8") __attribute__((section("sfrs"), address(0xBF880580)));
extern volatile uint32_t        C1FIFOCI8CLR __attribute__((section("sfrs"),address(0xBF880584)));
extern volatile uint32_t        C1FIFOCI8SET __attribute__((section("sfrs"),address(0xBF880588)));
extern volatile uint32_t        C1FIFOCI8INV __attribute__((section("sfrs"),address(0xBF88058C)));
#define C1FIFOCON9 C1FIFOCON9
extern volatile uint32_t   C1FIFOCON9 __attribute__((section("sfrs"), address(0xBF880590)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON9bits_t;
extern volatile __C1FIFOCON9bits_t C1FIFOCON9bits __asm__ ("C1FIFOCON9") __attribute__((section("sfrs"), address(0xBF880590)));
extern volatile uint32_t        C1FIFOCON9CLR __attribute__((section("sfrs"),address(0xBF880594)));
extern volatile uint32_t        C1FIFOCON9SET __attribute__((section("sfrs"),address(0xBF880598)));
extern volatile uint32_t        C1FIFOCON9INV __attribute__((section("sfrs"),address(0xBF88059C)));
#define C1FIFOINT9 C1FIFOINT9
extern volatile uint32_t   C1FIFOINT9 __attribute__((section("sfrs"), address(0xBF8805A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT9bits_t;
extern volatile __C1FIFOINT9bits_t C1FIFOINT9bits __asm__ ("C1FIFOINT9") __attribute__((section("sfrs"), address(0xBF8805A0)));
extern volatile uint32_t        C1FIFOINT9CLR __attribute__((section("sfrs"),address(0xBF8805A4)));
extern volatile uint32_t        C1FIFOINT9SET __attribute__((section("sfrs"),address(0xBF8805A8)));
extern volatile uint32_t        C1FIFOINT9INV __attribute__((section("sfrs"),address(0xBF8805AC)));
#define C1FIFOUA9 C1FIFOUA9
extern volatile uint32_t   C1FIFOUA9 __attribute__((section("sfrs"), address(0xBF8805B0)));
extern volatile uint32_t        C1FIFOUA9CLR __attribute__((section("sfrs"),address(0xBF8805B4)));
extern volatile uint32_t        C1FIFOUA9SET __attribute__((section("sfrs"),address(0xBF8805B8)));
extern volatile uint32_t        C1FIFOUA9INV __attribute__((section("sfrs"),address(0xBF8805BC)));
#define C1FIFOCI9 C1FIFOCI9
extern volatile uint32_t   C1FIFOCI9 __attribute__((section("sfrs"), address(0xBF8805C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI9bits_t;
extern volatile __C1FIFOCI9bits_t C1FIFOCI9bits __asm__ ("C1FIFOCI9") __attribute__((section("sfrs"), address(0xBF8805C0)));
extern volatile uint32_t        C1FIFOCI9CLR __attribute__((section("sfrs"),address(0xBF8805C4)));
extern volatile uint32_t        C1FIFOCI9SET __attribute__((section("sfrs"),address(0xBF8805C8)));
extern volatile uint32_t        C1FIFOCI9INV __attribute__((section("sfrs"),address(0xBF8805CC)));
#define C1FIFOCON10 C1FIFOCON10
extern volatile uint32_t   C1FIFOCON10 __attribute__((section("sfrs"), address(0xBF8805D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON10bits_t;
extern volatile __C1FIFOCON10bits_t C1FIFOCON10bits __asm__ ("C1FIFOCON10") __attribute__((section("sfrs"), address(0xBF8805D0)));
extern volatile uint32_t        C1FIFOCON10CLR __attribute__((section("sfrs"),address(0xBF8805D4)));
extern volatile uint32_t        C1FIFOCON10SET __attribute__((section("sfrs"),address(0xBF8805D8)));
extern volatile uint32_t        C1FIFOCON10INV __attribute__((section("sfrs"),address(0xBF8805DC)));
#define C1FIFOINT10 C1FIFOINT10
extern volatile uint32_t   C1FIFOINT10 __attribute__((section("sfrs"), address(0xBF8805E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT10bits_t;
extern volatile __C1FIFOINT10bits_t C1FIFOINT10bits __asm__ ("C1FIFOINT10") __attribute__((section("sfrs"), address(0xBF8805E0)));
extern volatile uint32_t        C1FIFOINT10CLR __attribute__((section("sfrs"),address(0xBF8805E4)));
extern volatile uint32_t        C1FIFOINT10SET __attribute__((section("sfrs"),address(0xBF8805E8)));
extern volatile uint32_t        C1FIFOINT10INV __attribute__((section("sfrs"),address(0xBF8805EC)));
#define C1FIFOUA10 C1FIFOUA10
extern volatile uint32_t   C1FIFOUA10 __attribute__((section("sfrs"), address(0xBF8805F0)));
extern volatile uint32_t        C1FIFOUA10CLR __attribute__((section("sfrs"),address(0xBF8805F4)));
extern volatile uint32_t        C1FIFOUA10SET __attribute__((section("sfrs"),address(0xBF8805F8)));
extern volatile uint32_t        C1FIFOUA10INV __attribute__((section("sfrs"),address(0xBF8805FC)));
#define C1FIFOCI10 C1FIFOCI10
extern volatile uint32_t   C1FIFOCI10 __attribute__((section("sfrs"), address(0xBF880600)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI10bits_t;
extern volatile __C1FIFOCI10bits_t C1FIFOCI10bits __asm__ ("C1FIFOCI10") __attribute__((section("sfrs"), address(0xBF880600)));
extern volatile uint32_t        C1FIFOCI10CLR __attribute__((section("sfrs"),address(0xBF880604)));
extern volatile uint32_t        C1FIFOCI10SET __attribute__((section("sfrs"),address(0xBF880608)));
extern volatile uint32_t        C1FIFOCI10INV __attribute__((section("sfrs"),address(0xBF88060C)));
#define C1FIFOCON11 C1FIFOCON11
extern volatile uint32_t   C1FIFOCON11 __attribute__((section("sfrs"), address(0xBF880610)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON11bits_t;
extern volatile __C1FIFOCON11bits_t C1FIFOCON11bits __asm__ ("C1FIFOCON11") __attribute__((section("sfrs"), address(0xBF880610)));
extern volatile uint32_t        C1FIFOCON11CLR __attribute__((section("sfrs"),address(0xBF880614)));
extern volatile uint32_t        C1FIFOCON11SET __attribute__((section("sfrs"),address(0xBF880618)));
extern volatile uint32_t        C1FIFOCON11INV __attribute__((section("sfrs"),address(0xBF88061C)));
#define C1FIFOINT11 C1FIFOINT11
extern volatile uint32_t   C1FIFOINT11 __attribute__((section("sfrs"), address(0xBF880620)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT11bits_t;
extern volatile __C1FIFOINT11bits_t C1FIFOINT11bits __asm__ ("C1FIFOINT11") __attribute__((section("sfrs"), address(0xBF880620)));
extern volatile uint32_t        C1FIFOINT11CLR __attribute__((section("sfrs"),address(0xBF880624)));
extern volatile uint32_t        C1FIFOINT11SET __attribute__((section("sfrs"),address(0xBF880628)));
extern volatile uint32_t        C1FIFOINT11INV __attribute__((section("sfrs"),address(0xBF88062C)));
#define C1FIFOUA11 C1FIFOUA11
extern volatile uint32_t   C1FIFOUA11 __attribute__((section("sfrs"), address(0xBF880630)));
extern volatile uint32_t        C1FIFOUA11CLR __attribute__((section("sfrs"),address(0xBF880634)));
extern volatile uint32_t        C1FIFOUA11SET __attribute__((section("sfrs"),address(0xBF880638)));
extern volatile uint32_t        C1FIFOUA11INV __attribute__((section("sfrs"),address(0xBF88063C)));
#define C1FIFOCI11 C1FIFOCI11
extern volatile uint32_t   C1FIFOCI11 __attribute__((section("sfrs"), address(0xBF880640)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI11bits_t;
extern volatile __C1FIFOCI11bits_t C1FIFOCI11bits __asm__ ("C1FIFOCI11") __attribute__((section("sfrs"), address(0xBF880640)));
extern volatile uint32_t        C1FIFOCI11CLR __attribute__((section("sfrs"),address(0xBF880644)));
extern volatile uint32_t        C1FIFOCI11SET __attribute__((section("sfrs"),address(0xBF880648)));
extern volatile uint32_t        C1FIFOCI11INV __attribute__((section("sfrs"),address(0xBF88064C)));
#define C1FIFOCON12 C1FIFOCON12
extern volatile uint32_t   C1FIFOCON12 __attribute__((section("sfrs"), address(0xBF880650)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON12bits_t;
extern volatile __C1FIFOCON12bits_t C1FIFOCON12bits __asm__ ("C1FIFOCON12") __attribute__((section("sfrs"), address(0xBF880650)));
extern volatile uint32_t        C1FIFOCON12CLR __attribute__((section("sfrs"),address(0xBF880654)));
extern volatile uint32_t        C1FIFOCON12SET __attribute__((section("sfrs"),address(0xBF880658)));
extern volatile uint32_t        C1FIFOCON12INV __attribute__((section("sfrs"),address(0xBF88065C)));
#define C1FIFOINT12 C1FIFOINT12
extern volatile uint32_t   C1FIFOINT12 __attribute__((section("sfrs"), address(0xBF880660)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT12bits_t;
extern volatile __C1FIFOINT12bits_t C1FIFOINT12bits __asm__ ("C1FIFOINT12") __attribute__((section("sfrs"), address(0xBF880660)));
extern volatile uint32_t        C1FIFOINT12CLR __attribute__((section("sfrs"),address(0xBF880664)));
extern volatile uint32_t        C1FIFOINT12SET __attribute__((section("sfrs"),address(0xBF880668)));
extern volatile uint32_t        C1FIFOINT12INV __attribute__((section("sfrs"),address(0xBF88066C)));
#define C1FIFOUA12 C1FIFOUA12
extern volatile uint32_t   C1FIFOUA12 __attribute__((section("sfrs"), address(0xBF880670)));
extern volatile uint32_t        C1FIFOUA12CLR __attribute__((section("sfrs"),address(0xBF880674)));
extern volatile uint32_t        C1FIFOUA12SET __attribute__((section("sfrs"),address(0xBF880678)));
extern volatile uint32_t        C1FIFOUA12INV __attribute__((section("sfrs"),address(0xBF88067C)));
#define C1FIFOCI12 C1FIFOCI12
extern volatile uint32_t   C1FIFOCI12 __attribute__((section("sfrs"), address(0xBF880680)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI12bits_t;
extern volatile __C1FIFOCI12bits_t C1FIFOCI12bits __asm__ ("C1FIFOCI12") __attribute__((section("sfrs"), address(0xBF880680)));
extern volatile uint32_t        C1FIFOCI12CLR __attribute__((section("sfrs"),address(0xBF880684)));
extern volatile uint32_t        C1FIFOCI12SET __attribute__((section("sfrs"),address(0xBF880688)));
extern volatile uint32_t        C1FIFOCI12INV __attribute__((section("sfrs"),address(0xBF88068C)));
#define C1FIFOCON13 C1FIFOCON13
extern volatile uint32_t   C1FIFOCON13 __attribute__((section("sfrs"), address(0xBF880690)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON13bits_t;
extern volatile __C1FIFOCON13bits_t C1FIFOCON13bits __asm__ ("C1FIFOCON13") __attribute__((section("sfrs"), address(0xBF880690)));
extern volatile uint32_t        C1FIFOCON13CLR __attribute__((section("sfrs"),address(0xBF880694)));
extern volatile uint32_t        C1FIFOCON13SET __attribute__((section("sfrs"),address(0xBF880698)));
extern volatile uint32_t        C1FIFOCON13INV __attribute__((section("sfrs"),address(0xBF88069C)));
#define C1FIFOINT13 C1FIFOINT13
extern volatile uint32_t   C1FIFOINT13 __attribute__((section("sfrs"), address(0xBF8806A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT13bits_t;
extern volatile __C1FIFOINT13bits_t C1FIFOINT13bits __asm__ ("C1FIFOINT13") __attribute__((section("sfrs"), address(0xBF8806A0)));
extern volatile uint32_t        C1FIFOINT13CLR __attribute__((section("sfrs"),address(0xBF8806A4)));
extern volatile uint32_t        C1FIFOINT13SET __attribute__((section("sfrs"),address(0xBF8806A8)));
extern volatile uint32_t        C1FIFOINT13INV __attribute__((section("sfrs"),address(0xBF8806AC)));
#define C1FIFOUA13 C1FIFOUA13
extern volatile uint32_t   C1FIFOUA13 __attribute__((section("sfrs"), address(0xBF8806B0)));
extern volatile uint32_t        C1FIFOUA13CLR __attribute__((section("sfrs"),address(0xBF8806B4)));
extern volatile uint32_t        C1FIFOUA13SET __attribute__((section("sfrs"),address(0xBF8806B8)));
extern volatile uint32_t        C1FIFOUA13INV __attribute__((section("sfrs"),address(0xBF8806BC)));
#define C1FIFOCI13 C1FIFOCI13
extern volatile uint32_t   C1FIFOCI13 __attribute__((section("sfrs"), address(0xBF8806C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI13bits_t;
extern volatile __C1FIFOCI13bits_t C1FIFOCI13bits __asm__ ("C1FIFOCI13") __attribute__((section("sfrs"), address(0xBF8806C0)));
extern volatile uint32_t        C1FIFOCI13CLR __attribute__((section("sfrs"),address(0xBF8806C4)));
extern volatile uint32_t        C1FIFOCI13SET __attribute__((section("sfrs"),address(0xBF8806C8)));
extern volatile uint32_t        C1FIFOCI13INV __attribute__((section("sfrs"),address(0xBF8806CC)));
#define C1FIFOCON14 C1FIFOCON14
extern volatile uint32_t   C1FIFOCON14 __attribute__((section("sfrs"), address(0xBF8806D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON14bits_t;
extern volatile __C1FIFOCON14bits_t C1FIFOCON14bits __asm__ ("C1FIFOCON14") __attribute__((section("sfrs"), address(0xBF8806D0)));
extern volatile uint32_t        C1FIFOCON14CLR __attribute__((section("sfrs"),address(0xBF8806D4)));
extern volatile uint32_t        C1FIFOCON14SET __attribute__((section("sfrs"),address(0xBF8806D8)));
extern volatile uint32_t        C1FIFOCON14INV __attribute__((section("sfrs"),address(0xBF8806DC)));
#define C1FIFOINT14 C1FIFOINT14
extern volatile uint32_t   C1FIFOINT14 __attribute__((section("sfrs"), address(0xBF8806E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT14bits_t;
extern volatile __C1FIFOINT14bits_t C1FIFOINT14bits __asm__ ("C1FIFOINT14") __attribute__((section("sfrs"), address(0xBF8806E0)));
extern volatile uint32_t        C1FIFOINT14CLR __attribute__((section("sfrs"),address(0xBF8806E4)));
extern volatile uint32_t        C1FIFOINT14SET __attribute__((section("sfrs"),address(0xBF8806E8)));
extern volatile uint32_t        C1FIFOINT14INV __attribute__((section("sfrs"),address(0xBF8806EC)));
#define C1FIFOUA14 C1FIFOUA14
extern volatile uint32_t   C1FIFOUA14 __attribute__((section("sfrs"), address(0xBF8806F0)));
extern volatile uint32_t        C1FIFOUA14CLR __attribute__((section("sfrs"),address(0xBF8806F4)));
extern volatile uint32_t        C1FIFOUA14SET __attribute__((section("sfrs"),address(0xBF8806F8)));
extern volatile uint32_t        C1FIFOUA14INV __attribute__((section("sfrs"),address(0xBF8806FC)));
#define C1FIFOCI14 C1FIFOCI14
extern volatile uint32_t   C1FIFOCI14 __attribute__((section("sfrs"), address(0xBF880700)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI14bits_t;
extern volatile __C1FIFOCI14bits_t C1FIFOCI14bits __asm__ ("C1FIFOCI14") __attribute__((section("sfrs"), address(0xBF880700)));
extern volatile uint32_t        C1FIFOCI14CLR __attribute__((section("sfrs"),address(0xBF880704)));
extern volatile uint32_t        C1FIFOCI14SET __attribute__((section("sfrs"),address(0xBF880708)));
extern volatile uint32_t        C1FIFOCI14INV __attribute__((section("sfrs"),address(0xBF88070C)));
#define C1FIFOCON15 C1FIFOCON15
extern volatile uint32_t   C1FIFOCON15 __attribute__((section("sfrs"), address(0xBF880710)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON15bits_t;
extern volatile __C1FIFOCON15bits_t C1FIFOCON15bits __asm__ ("C1FIFOCON15") __attribute__((section("sfrs"), address(0xBF880710)));
extern volatile uint32_t        C1FIFOCON15CLR __attribute__((section("sfrs"),address(0xBF880714)));
extern volatile uint32_t        C1FIFOCON15SET __attribute__((section("sfrs"),address(0xBF880718)));
extern volatile uint32_t        C1FIFOCON15INV __attribute__((section("sfrs"),address(0xBF88071C)));
#define C1FIFOINT15 C1FIFOINT15
extern volatile uint32_t   C1FIFOINT15 __attribute__((section("sfrs"), address(0xBF880720)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT15bits_t;
extern volatile __C1FIFOINT15bits_t C1FIFOINT15bits __asm__ ("C1FIFOINT15") __attribute__((section("sfrs"), address(0xBF880720)));
extern volatile uint32_t        C1FIFOINT15CLR __attribute__((section("sfrs"),address(0xBF880724)));
extern volatile uint32_t        C1FIFOINT15SET __attribute__((section("sfrs"),address(0xBF880728)));
extern volatile uint32_t        C1FIFOINT15INV __attribute__((section("sfrs"),address(0xBF88072C)));
#define C1FIFOUA15 C1FIFOUA15
extern volatile uint32_t   C1FIFOUA15 __attribute__((section("sfrs"), address(0xBF880730)));
extern volatile uint32_t        C1FIFOUA15CLR __attribute__((section("sfrs"),address(0xBF880734)));
extern volatile uint32_t        C1FIFOUA15SET __attribute__((section("sfrs"),address(0xBF880738)));
extern volatile uint32_t        C1FIFOUA15INV __attribute__((section("sfrs"),address(0xBF88073C)));
#define C1FIFOCI15 C1FIFOCI15
extern volatile uint32_t   C1FIFOCI15 __attribute__((section("sfrs"), address(0xBF880740)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI15bits_t;
extern volatile __C1FIFOCI15bits_t C1FIFOCI15bits __asm__ ("C1FIFOCI15") __attribute__((section("sfrs"), address(0xBF880740)));
extern volatile uint32_t        C1FIFOCI15CLR __attribute__((section("sfrs"),address(0xBF880744)));
extern volatile uint32_t        C1FIFOCI15SET __attribute__((section("sfrs"),address(0xBF880748)));
extern volatile uint32_t        C1FIFOCI15INV __attribute__((section("sfrs"),address(0xBF88074C)));
#define C1FIFOCON16 C1FIFOCON16
extern volatile uint32_t   C1FIFOCON16 __attribute__((section("sfrs"), address(0xBF880750)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON16bits_t;
extern volatile __C1FIFOCON16bits_t C1FIFOCON16bits __asm__ ("C1FIFOCON16") __attribute__((section("sfrs"), address(0xBF880750)));
extern volatile uint32_t        C1FIFOCON16CLR __attribute__((section("sfrs"),address(0xBF880754)));
extern volatile uint32_t        C1FIFOCON16SET __attribute__((section("sfrs"),address(0xBF880758)));
extern volatile uint32_t        C1FIFOCON16INV __attribute__((section("sfrs"),address(0xBF88075C)));
#define C1FIFOINT16 C1FIFOINT16
extern volatile uint32_t   C1FIFOINT16 __attribute__((section("sfrs"), address(0xBF880760)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT16bits_t;
extern volatile __C1FIFOINT16bits_t C1FIFOINT16bits __asm__ ("C1FIFOINT16") __attribute__((section("sfrs"), address(0xBF880760)));
extern volatile uint32_t        C1FIFOINT16CLR __attribute__((section("sfrs"),address(0xBF880764)));
extern volatile uint32_t        C1FIFOINT16SET __attribute__((section("sfrs"),address(0xBF880768)));
extern volatile uint32_t        C1FIFOINT16INV __attribute__((section("sfrs"),address(0xBF88076C)));
#define C1FIFOUA16 C1FIFOUA16
extern volatile uint32_t   C1FIFOUA16 __attribute__((section("sfrs"), address(0xBF880770)));
extern volatile uint32_t        C1FIFOUA16CLR __attribute__((section("sfrs"),address(0xBF880774)));
extern volatile uint32_t        C1FIFOUA16SET __attribute__((section("sfrs"),address(0xBF880778)));
extern volatile uint32_t        C1FIFOUA16INV __attribute__((section("sfrs"),address(0xBF88077C)));
#define C1FIFOCI16 C1FIFOCI16
extern volatile uint32_t   C1FIFOCI16 __attribute__((section("sfrs"), address(0xBF880780)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI16bits_t;
extern volatile __C1FIFOCI16bits_t C1FIFOCI16bits __asm__ ("C1FIFOCI16") __attribute__((section("sfrs"), address(0xBF880780)));
extern volatile uint32_t        C1FIFOCI16CLR __attribute__((section("sfrs"),address(0xBF880784)));
extern volatile uint32_t        C1FIFOCI16SET __attribute__((section("sfrs"),address(0xBF880788)));
extern volatile uint32_t        C1FIFOCI16INV __attribute__((section("sfrs"),address(0xBF88078C)));
#define C1FIFOCON17 C1FIFOCON17
extern volatile uint32_t   C1FIFOCON17 __attribute__((section("sfrs"), address(0xBF880790)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON17bits_t;
extern volatile __C1FIFOCON17bits_t C1FIFOCON17bits __asm__ ("C1FIFOCON17") __attribute__((section("sfrs"), address(0xBF880790)));
extern volatile uint32_t        C1FIFOCON17CLR __attribute__((section("sfrs"),address(0xBF880794)));
extern volatile uint32_t        C1FIFOCON17SET __attribute__((section("sfrs"),address(0xBF880798)));
extern volatile uint32_t        C1FIFOCON17INV __attribute__((section("sfrs"),address(0xBF88079C)));
#define C1FIFOINT17 C1FIFOINT17
extern volatile uint32_t   C1FIFOINT17 __attribute__((section("sfrs"), address(0xBF8807A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT17bits_t;
extern volatile __C1FIFOINT17bits_t C1FIFOINT17bits __asm__ ("C1FIFOINT17") __attribute__((section("sfrs"), address(0xBF8807A0)));
extern volatile uint32_t        C1FIFOINT17CLR __attribute__((section("sfrs"),address(0xBF8807A4)));
extern volatile uint32_t        C1FIFOINT17SET __attribute__((section("sfrs"),address(0xBF8807A8)));
extern volatile uint32_t        C1FIFOINT17INV __attribute__((section("sfrs"),address(0xBF8807AC)));
#define C1FIFOUA17 C1FIFOUA17
extern volatile uint32_t   C1FIFOUA17 __attribute__((section("sfrs"), address(0xBF8807B0)));
extern volatile uint32_t        C1FIFOUA17CLR __attribute__((section("sfrs"),address(0xBF8807B4)));
extern volatile uint32_t        C1FIFOUA17SET __attribute__((section("sfrs"),address(0xBF8807B8)));
extern volatile uint32_t        C1FIFOUA17INV __attribute__((section("sfrs"),address(0xBF8807BC)));
#define C1FIFOCI17 C1FIFOCI17
extern volatile uint32_t   C1FIFOCI17 __attribute__((section("sfrs"), address(0xBF8807C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI17bits_t;
extern volatile __C1FIFOCI17bits_t C1FIFOCI17bits __asm__ ("C1FIFOCI17") __attribute__((section("sfrs"), address(0xBF8807C0)));
extern volatile uint32_t        C1FIFOCI17CLR __attribute__((section("sfrs"),address(0xBF8807C4)));
extern volatile uint32_t        C1FIFOCI17SET __attribute__((section("sfrs"),address(0xBF8807C8)));
extern volatile uint32_t        C1FIFOCI17INV __attribute__((section("sfrs"),address(0xBF8807CC)));
#define C1FIFOCON18 C1FIFOCON18
extern volatile uint32_t   C1FIFOCON18 __attribute__((section("sfrs"), address(0xBF8807D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON18bits_t;
extern volatile __C1FIFOCON18bits_t C1FIFOCON18bits __asm__ ("C1FIFOCON18") __attribute__((section("sfrs"), address(0xBF8807D0)));
extern volatile uint32_t        C1FIFOCON18CLR __attribute__((section("sfrs"),address(0xBF8807D4)));
extern volatile uint32_t        C1FIFOCON18SET __attribute__((section("sfrs"),address(0xBF8807D8)));
extern volatile uint32_t        C1FIFOCON18INV __attribute__((section("sfrs"),address(0xBF8807DC)));
#define C1FIFOINT18 C1FIFOINT18
extern volatile uint32_t   C1FIFOINT18 __attribute__((section("sfrs"), address(0xBF8807E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT18bits_t;
extern volatile __C1FIFOINT18bits_t C1FIFOINT18bits __asm__ ("C1FIFOINT18") __attribute__((section("sfrs"), address(0xBF8807E0)));
extern volatile uint32_t        C1FIFOINT18CLR __attribute__((section("sfrs"),address(0xBF8807E4)));
extern volatile uint32_t        C1FIFOINT18SET __attribute__((section("sfrs"),address(0xBF8807E8)));
extern volatile uint32_t        C1FIFOINT18INV __attribute__((section("sfrs"),address(0xBF8807EC)));
#define C1FIFOUA18 C1FIFOUA18
extern volatile uint32_t   C1FIFOUA18 __attribute__((section("sfrs"), address(0xBF8807F0)));
extern volatile uint32_t        C1FIFOUA18CLR __attribute__((section("sfrs"),address(0xBF8807F4)));
extern volatile uint32_t        C1FIFOUA18SET __attribute__((section("sfrs"),address(0xBF8807F8)));
extern volatile uint32_t        C1FIFOUA18INV __attribute__((section("sfrs"),address(0xBF8807FC)));
#define C1FIFOCI18 C1FIFOCI18
extern volatile uint32_t   C1FIFOCI18 __attribute__((section("sfrs"), address(0xBF880800)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI18bits_t;
extern volatile __C1FIFOCI18bits_t C1FIFOCI18bits __asm__ ("C1FIFOCI18") __attribute__((section("sfrs"), address(0xBF880800)));
extern volatile uint32_t        C1FIFOCI18CLR __attribute__((section("sfrs"),address(0xBF880804)));
extern volatile uint32_t        C1FIFOCI18SET __attribute__((section("sfrs"),address(0xBF880808)));
extern volatile uint32_t        C1FIFOCI18INV __attribute__((section("sfrs"),address(0xBF88080C)));
#define C1FIFOCON19 C1FIFOCON19
extern volatile uint32_t   C1FIFOCON19 __attribute__((section("sfrs"), address(0xBF880810)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON19bits_t;
extern volatile __C1FIFOCON19bits_t C1FIFOCON19bits __asm__ ("C1FIFOCON19") __attribute__((section("sfrs"), address(0xBF880810)));
extern volatile uint32_t        C1FIFOCON19CLR __attribute__((section("sfrs"),address(0xBF880814)));
extern volatile uint32_t        C1FIFOCON19SET __attribute__((section("sfrs"),address(0xBF880818)));
extern volatile uint32_t        C1FIFOCON19INV __attribute__((section("sfrs"),address(0xBF88081C)));
#define C1FIFOINT19 C1FIFOINT19
extern volatile uint32_t   C1FIFOINT19 __attribute__((section("sfrs"), address(0xBF880820)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT19bits_t;
extern volatile __C1FIFOINT19bits_t C1FIFOINT19bits __asm__ ("C1FIFOINT19") __attribute__((section("sfrs"), address(0xBF880820)));
extern volatile uint32_t        C1FIFOINT19CLR __attribute__((section("sfrs"),address(0xBF880824)));
extern volatile uint32_t        C1FIFOINT19SET __attribute__((section("sfrs"),address(0xBF880828)));
extern volatile uint32_t        C1FIFOINT19INV __attribute__((section("sfrs"),address(0xBF88082C)));
#define C1FIFOUA19 C1FIFOUA19
extern volatile uint32_t   C1FIFOUA19 __attribute__((section("sfrs"), address(0xBF880830)));
extern volatile uint32_t        C1FIFOUA19CLR __attribute__((section("sfrs"),address(0xBF880834)));
extern volatile uint32_t        C1FIFOUA19SET __attribute__((section("sfrs"),address(0xBF880838)));
extern volatile uint32_t        C1FIFOUA19INV __attribute__((section("sfrs"),address(0xBF88083C)));
#define C1FIFOCI19 C1FIFOCI19
extern volatile uint32_t   C1FIFOCI19 __attribute__((section("sfrs"), address(0xBF880840)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI19bits_t;
extern volatile __C1FIFOCI19bits_t C1FIFOCI19bits __asm__ ("C1FIFOCI19") __attribute__((section("sfrs"), address(0xBF880840)));
extern volatile uint32_t        C1FIFOCI19CLR __attribute__((section("sfrs"),address(0xBF880844)));
extern volatile uint32_t        C1FIFOCI19SET __attribute__((section("sfrs"),address(0xBF880848)));
extern volatile uint32_t        C1FIFOCI19INV __attribute__((section("sfrs"),address(0xBF88084C)));
#define C1FIFOCON20 C1FIFOCON20
extern volatile uint32_t   C1FIFOCON20 __attribute__((section("sfrs"), address(0xBF880850)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON20bits_t;
extern volatile __C1FIFOCON20bits_t C1FIFOCON20bits __asm__ ("C1FIFOCON20") __attribute__((section("sfrs"), address(0xBF880850)));
extern volatile uint32_t        C1FIFOCON20CLR __attribute__((section("sfrs"),address(0xBF880854)));
extern volatile uint32_t        C1FIFOCON20SET __attribute__((section("sfrs"),address(0xBF880858)));
extern volatile uint32_t        C1FIFOCON20INV __attribute__((section("sfrs"),address(0xBF88085C)));
#define C1FIFOINT20 C1FIFOINT20
extern volatile uint32_t   C1FIFOINT20 __attribute__((section("sfrs"), address(0xBF880860)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT20bits_t;
extern volatile __C1FIFOINT20bits_t C1FIFOINT20bits __asm__ ("C1FIFOINT20") __attribute__((section("sfrs"), address(0xBF880860)));
extern volatile uint32_t        C1FIFOINT20CLR __attribute__((section("sfrs"),address(0xBF880864)));
extern volatile uint32_t        C1FIFOINT20SET __attribute__((section("sfrs"),address(0xBF880868)));
extern volatile uint32_t        C1FIFOINT20INV __attribute__((section("sfrs"),address(0xBF88086C)));
#define C1FIFOUA20 C1FIFOUA20
extern volatile uint32_t   C1FIFOUA20 __attribute__((section("sfrs"), address(0xBF880870)));
extern volatile uint32_t        C1FIFOUA20CLR __attribute__((section("sfrs"),address(0xBF880874)));
extern volatile uint32_t        C1FIFOUA20SET __attribute__((section("sfrs"),address(0xBF880878)));
extern volatile uint32_t        C1FIFOUA20INV __attribute__((section("sfrs"),address(0xBF88087C)));
#define C1FIFOCI20 C1FIFOCI20
extern volatile uint32_t   C1FIFOCI20 __attribute__((section("sfrs"), address(0xBF880880)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI20bits_t;
extern volatile __C1FIFOCI20bits_t C1FIFOCI20bits __asm__ ("C1FIFOCI20") __attribute__((section("sfrs"), address(0xBF880880)));
extern volatile uint32_t        C1FIFOCI20CLR __attribute__((section("sfrs"),address(0xBF880884)));
extern volatile uint32_t        C1FIFOCI20SET __attribute__((section("sfrs"),address(0xBF880888)));
extern volatile uint32_t        C1FIFOCI20INV __attribute__((section("sfrs"),address(0xBF88088C)));
#define C1FIFOCON21 C1FIFOCON21
extern volatile uint32_t   C1FIFOCON21 __attribute__((section("sfrs"), address(0xBF880890)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON21bits_t;
extern volatile __C1FIFOCON21bits_t C1FIFOCON21bits __asm__ ("C1FIFOCON21") __attribute__((section("sfrs"), address(0xBF880890)));
extern volatile uint32_t        C1FIFOCON21CLR __attribute__((section("sfrs"),address(0xBF880894)));
extern volatile uint32_t        C1FIFOCON21SET __attribute__((section("sfrs"),address(0xBF880898)));
extern volatile uint32_t        C1FIFOCON21INV __attribute__((section("sfrs"),address(0xBF88089C)));
#define C1FIFOINT21 C1FIFOINT21
extern volatile uint32_t   C1FIFOINT21 __attribute__((section("sfrs"), address(0xBF8808A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT21bits_t;
extern volatile __C1FIFOINT21bits_t C1FIFOINT21bits __asm__ ("C1FIFOINT21") __attribute__((section("sfrs"), address(0xBF8808A0)));
extern volatile uint32_t        C1FIFOINT21CLR __attribute__((section("sfrs"),address(0xBF8808A4)));
extern volatile uint32_t        C1FIFOINT21SET __attribute__((section("sfrs"),address(0xBF8808A8)));
extern volatile uint32_t        C1FIFOINT21INV __attribute__((section("sfrs"),address(0xBF8808AC)));
#define C1FIFOUA21 C1FIFOUA21
extern volatile uint32_t   C1FIFOUA21 __attribute__((section("sfrs"), address(0xBF8808B0)));
extern volatile uint32_t        C1FIFOUA21CLR __attribute__((section("sfrs"),address(0xBF8808B4)));
extern volatile uint32_t        C1FIFOUA21SET __attribute__((section("sfrs"),address(0xBF8808B8)));
extern volatile uint32_t        C1FIFOUA21INV __attribute__((section("sfrs"),address(0xBF8808BC)));
#define C1FIFOCI21 C1FIFOCI21
extern volatile uint32_t   C1FIFOCI21 __attribute__((section("sfrs"), address(0xBF8808C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI21bits_t;
extern volatile __C1FIFOCI21bits_t C1FIFOCI21bits __asm__ ("C1FIFOCI21") __attribute__((section("sfrs"), address(0xBF8808C0)));
extern volatile uint32_t        C1FIFOCI21CLR __attribute__((section("sfrs"),address(0xBF8808C4)));
extern volatile uint32_t        C1FIFOCI21SET __attribute__((section("sfrs"),address(0xBF8808C8)));
extern volatile uint32_t        C1FIFOCI21INV __attribute__((section("sfrs"),address(0xBF8808CC)));
#define C1FIFOCON22 C1FIFOCON22
extern volatile uint32_t   C1FIFOCON22 __attribute__((section("sfrs"), address(0xBF8808D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON22bits_t;
extern volatile __C1FIFOCON22bits_t C1FIFOCON22bits __asm__ ("C1FIFOCON22") __attribute__((section("sfrs"), address(0xBF8808D0)));
extern volatile uint32_t        C1FIFOCON22CLR __attribute__((section("sfrs"),address(0xBF8808D4)));
extern volatile uint32_t        C1FIFOCON22SET __attribute__((section("sfrs"),address(0xBF8808D8)));
extern volatile uint32_t        C1FIFOCON22INV __attribute__((section("sfrs"),address(0xBF8808DC)));
#define C1FIFOINT22 C1FIFOINT22
extern volatile uint32_t   C1FIFOINT22 __attribute__((section("sfrs"), address(0xBF8808E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT22bits_t;
extern volatile __C1FIFOINT22bits_t C1FIFOINT22bits __asm__ ("C1FIFOINT22") __attribute__((section("sfrs"), address(0xBF8808E0)));
extern volatile uint32_t        C1FIFOINT22CLR __attribute__((section("sfrs"),address(0xBF8808E4)));
extern volatile uint32_t        C1FIFOINT22SET __attribute__((section("sfrs"),address(0xBF8808E8)));
extern volatile uint32_t        C1FIFOINT22INV __attribute__((section("sfrs"),address(0xBF8808EC)));
#define C1FIFOUA22 C1FIFOUA22
extern volatile uint32_t   C1FIFOUA22 __attribute__((section("sfrs"), address(0xBF8808F0)));
extern volatile uint32_t        C1FIFOUA22CLR __attribute__((section("sfrs"),address(0xBF8808F4)));
extern volatile uint32_t        C1FIFOUA22SET __attribute__((section("sfrs"),address(0xBF8808F8)));
extern volatile uint32_t        C1FIFOUA22INV __attribute__((section("sfrs"),address(0xBF8808FC)));
#define C1FIFOCI22 C1FIFOCI22
extern volatile uint32_t   C1FIFOCI22 __attribute__((section("sfrs"), address(0xBF880900)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI22bits_t;
extern volatile __C1FIFOCI22bits_t C1FIFOCI22bits __asm__ ("C1FIFOCI22") __attribute__((section("sfrs"), address(0xBF880900)));
extern volatile uint32_t        C1FIFOCI22CLR __attribute__((section("sfrs"),address(0xBF880904)));
extern volatile uint32_t        C1FIFOCI22SET __attribute__((section("sfrs"),address(0xBF880908)));
extern volatile uint32_t        C1FIFOCI22INV __attribute__((section("sfrs"),address(0xBF88090C)));
#define C1FIFOCON23 C1FIFOCON23
extern volatile uint32_t   C1FIFOCON23 __attribute__((section("sfrs"), address(0xBF880910)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON23bits_t;
extern volatile __C1FIFOCON23bits_t C1FIFOCON23bits __asm__ ("C1FIFOCON23") __attribute__((section("sfrs"), address(0xBF880910)));
extern volatile uint32_t        C1FIFOCON23CLR __attribute__((section("sfrs"),address(0xBF880914)));
extern volatile uint32_t        C1FIFOCON23SET __attribute__((section("sfrs"),address(0xBF880918)));
extern volatile uint32_t        C1FIFOCON23INV __attribute__((section("sfrs"),address(0xBF88091C)));
#define C1FIFOINT23 C1FIFOINT23
extern volatile uint32_t   C1FIFOINT23 __attribute__((section("sfrs"), address(0xBF880920)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT23bits_t;
extern volatile __C1FIFOINT23bits_t C1FIFOINT23bits __asm__ ("C1FIFOINT23") __attribute__((section("sfrs"), address(0xBF880920)));
extern volatile uint32_t        C1FIFOINT23CLR __attribute__((section("sfrs"),address(0xBF880924)));
extern volatile uint32_t        C1FIFOINT23SET __attribute__((section("sfrs"),address(0xBF880928)));
extern volatile uint32_t        C1FIFOINT23INV __attribute__((section("sfrs"),address(0xBF88092C)));
#define C1FIFOUA23 C1FIFOUA23
extern volatile uint32_t   C1FIFOUA23 __attribute__((section("sfrs"), address(0xBF880930)));
extern volatile uint32_t        C1FIFOUA23CLR __attribute__((section("sfrs"),address(0xBF880934)));
extern volatile uint32_t        C1FIFOUA23SET __attribute__((section("sfrs"),address(0xBF880938)));
extern volatile uint32_t        C1FIFOUA23INV __attribute__((section("sfrs"),address(0xBF88093C)));
#define C1FIFOCI23 C1FIFOCI23
extern volatile uint32_t   C1FIFOCI23 __attribute__((section("sfrs"), address(0xBF880940)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI23bits_t;
extern volatile __C1FIFOCI23bits_t C1FIFOCI23bits __asm__ ("C1FIFOCI23") __attribute__((section("sfrs"), address(0xBF880940)));
extern volatile uint32_t        C1FIFOCI23CLR __attribute__((section("sfrs"),address(0xBF880944)));
extern volatile uint32_t        C1FIFOCI23SET __attribute__((section("sfrs"),address(0xBF880948)));
extern volatile uint32_t        C1FIFOCI23INV __attribute__((section("sfrs"),address(0xBF88094C)));
#define C1FIFOCON24 C1FIFOCON24
extern volatile uint32_t   C1FIFOCON24 __attribute__((section("sfrs"), address(0xBF880950)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON24bits_t;
extern volatile __C1FIFOCON24bits_t C1FIFOCON24bits __asm__ ("C1FIFOCON24") __attribute__((section("sfrs"), address(0xBF880950)));
extern volatile uint32_t        C1FIFOCON24CLR __attribute__((section("sfrs"),address(0xBF880954)));
extern volatile uint32_t        C1FIFOCON24SET __attribute__((section("sfrs"),address(0xBF880958)));
extern volatile uint32_t        C1FIFOCON24INV __attribute__((section("sfrs"),address(0xBF88095C)));
#define C1FIFOINT24 C1FIFOINT24
extern volatile uint32_t   C1FIFOINT24 __attribute__((section("sfrs"), address(0xBF880960)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT24bits_t;
extern volatile __C1FIFOINT24bits_t C1FIFOINT24bits __asm__ ("C1FIFOINT24") __attribute__((section("sfrs"), address(0xBF880960)));
extern volatile uint32_t        C1FIFOINT24CLR __attribute__((section("sfrs"),address(0xBF880964)));
extern volatile uint32_t        C1FIFOINT24SET __attribute__((section("sfrs"),address(0xBF880968)));
extern volatile uint32_t        C1FIFOINT24INV __attribute__((section("sfrs"),address(0xBF88096C)));
#define C1FIFOUA24 C1FIFOUA24
extern volatile uint32_t   C1FIFOUA24 __attribute__((section("sfrs"), address(0xBF880970)));
extern volatile uint32_t        C1FIFOUA24CLR __attribute__((section("sfrs"),address(0xBF880974)));
extern volatile uint32_t        C1FIFOUA24SET __attribute__((section("sfrs"),address(0xBF880978)));
extern volatile uint32_t        C1FIFOUA24INV __attribute__((section("sfrs"),address(0xBF88097C)));
#define C1FIFOCI24 C1FIFOCI24
extern volatile uint32_t   C1FIFOCI24 __attribute__((section("sfrs"), address(0xBF880980)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI24bits_t;
extern volatile __C1FIFOCI24bits_t C1FIFOCI24bits __asm__ ("C1FIFOCI24") __attribute__((section("sfrs"), address(0xBF880980)));
extern volatile uint32_t        C1FIFOCI24CLR __attribute__((section("sfrs"),address(0xBF880984)));
extern volatile uint32_t        C1FIFOCI24SET __attribute__((section("sfrs"),address(0xBF880988)));
extern volatile uint32_t        C1FIFOCI24INV __attribute__((section("sfrs"),address(0xBF88098C)));
#define C1FIFOCON25 C1FIFOCON25
extern volatile uint32_t   C1FIFOCON25 __attribute__((section("sfrs"), address(0xBF880990)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON25bits_t;
extern volatile __C1FIFOCON25bits_t C1FIFOCON25bits __asm__ ("C1FIFOCON25") __attribute__((section("sfrs"), address(0xBF880990)));
extern volatile uint32_t        C1FIFOCON25CLR __attribute__((section("sfrs"),address(0xBF880994)));
extern volatile uint32_t        C1FIFOCON25SET __attribute__((section("sfrs"),address(0xBF880998)));
extern volatile uint32_t        C1FIFOCON25INV __attribute__((section("sfrs"),address(0xBF88099C)));
#define C1FIFOINT25 C1FIFOINT25
extern volatile uint32_t   C1FIFOINT25 __attribute__((section("sfrs"), address(0xBF8809A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT25bits_t;
extern volatile __C1FIFOINT25bits_t C1FIFOINT25bits __asm__ ("C1FIFOINT25") __attribute__((section("sfrs"), address(0xBF8809A0)));
extern volatile uint32_t        C1FIFOINT25CLR __attribute__((section("sfrs"),address(0xBF8809A4)));
extern volatile uint32_t        C1FIFOINT25SET __attribute__((section("sfrs"),address(0xBF8809A8)));
extern volatile uint32_t        C1FIFOINT25INV __attribute__((section("sfrs"),address(0xBF8809AC)));
#define C1FIFOUA25 C1FIFOUA25
extern volatile uint32_t   C1FIFOUA25 __attribute__((section("sfrs"), address(0xBF8809B0)));
extern volatile uint32_t        C1FIFOUA25CLR __attribute__((section("sfrs"),address(0xBF8809B4)));
extern volatile uint32_t        C1FIFOUA25SET __attribute__((section("sfrs"),address(0xBF8809B8)));
extern volatile uint32_t        C1FIFOUA25INV __attribute__((section("sfrs"),address(0xBF8809BC)));
#define C1FIFOCI25 C1FIFOCI25
extern volatile uint32_t   C1FIFOCI25 __attribute__((section("sfrs"), address(0xBF8809C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI25bits_t;
extern volatile __C1FIFOCI25bits_t C1FIFOCI25bits __asm__ ("C1FIFOCI25") __attribute__((section("sfrs"), address(0xBF8809C0)));
extern volatile uint32_t        C1FIFOCI25CLR __attribute__((section("sfrs"),address(0xBF8809C4)));
extern volatile uint32_t        C1FIFOCI25SET __attribute__((section("sfrs"),address(0xBF8809C8)));
extern volatile uint32_t        C1FIFOCI25INV __attribute__((section("sfrs"),address(0xBF8809CC)));
#define C1FIFOCON26 C1FIFOCON26
extern volatile uint32_t   C1FIFOCON26 __attribute__((section("sfrs"), address(0xBF8809D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON26bits_t;
extern volatile __C1FIFOCON26bits_t C1FIFOCON26bits __asm__ ("C1FIFOCON26") __attribute__((section("sfrs"), address(0xBF8809D0)));
extern volatile uint32_t        C1FIFOCON26CLR __attribute__((section("sfrs"),address(0xBF8809D4)));
extern volatile uint32_t        C1FIFOCON26SET __attribute__((section("sfrs"),address(0xBF8809D8)));
extern volatile uint32_t        C1FIFOCON26INV __attribute__((section("sfrs"),address(0xBF8809DC)));
#define C1FIFOINT26 C1FIFOINT26
extern volatile uint32_t   C1FIFOINT26 __attribute__((section("sfrs"), address(0xBF8809E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT26bits_t;
extern volatile __C1FIFOINT26bits_t C1FIFOINT26bits __asm__ ("C1FIFOINT26") __attribute__((section("sfrs"), address(0xBF8809E0)));
extern volatile uint32_t        C1FIFOINT26CLR __attribute__((section("sfrs"),address(0xBF8809E4)));
extern volatile uint32_t        C1FIFOINT26SET __attribute__((section("sfrs"),address(0xBF8809E8)));
extern volatile uint32_t        C1FIFOINT26INV __attribute__((section("sfrs"),address(0xBF8809EC)));
#define C1FIFOUA26 C1FIFOUA26
extern volatile uint32_t   C1FIFOUA26 __attribute__((section("sfrs"), address(0xBF8809F0)));
extern volatile uint32_t        C1FIFOUA26CLR __attribute__((section("sfrs"),address(0xBF8809F4)));
extern volatile uint32_t        C1FIFOUA26SET __attribute__((section("sfrs"),address(0xBF8809F8)));
extern volatile uint32_t        C1FIFOUA26INV __attribute__((section("sfrs"),address(0xBF8809FC)));
#define C1FIFOCI26 C1FIFOCI26
extern volatile uint32_t   C1FIFOCI26 __attribute__((section("sfrs"), address(0xBF880A00)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI26bits_t;
extern volatile __C1FIFOCI26bits_t C1FIFOCI26bits __asm__ ("C1FIFOCI26") __attribute__((section("sfrs"), address(0xBF880A00)));
extern volatile uint32_t        C1FIFOCI26CLR __attribute__((section("sfrs"),address(0xBF880A04)));
extern volatile uint32_t        C1FIFOCI26SET __attribute__((section("sfrs"),address(0xBF880A08)));
extern volatile uint32_t        C1FIFOCI26INV __attribute__((section("sfrs"),address(0xBF880A0C)));
#define C1FIFOCON27 C1FIFOCON27
extern volatile uint32_t   C1FIFOCON27 __attribute__((section("sfrs"), address(0xBF880A10)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON27bits_t;
extern volatile __C1FIFOCON27bits_t C1FIFOCON27bits __asm__ ("C1FIFOCON27") __attribute__((section("sfrs"), address(0xBF880A10)));
extern volatile uint32_t        C1FIFOCON27CLR __attribute__((section("sfrs"),address(0xBF880A14)));
extern volatile uint32_t        C1FIFOCON27SET __attribute__((section("sfrs"),address(0xBF880A18)));
extern volatile uint32_t        C1FIFOCON27INV __attribute__((section("sfrs"),address(0xBF880A1C)));
#define C1FIFOINT27 C1FIFOINT27
extern volatile uint32_t   C1FIFOINT27 __attribute__((section("sfrs"), address(0xBF880A20)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT27bits_t;
extern volatile __C1FIFOINT27bits_t C1FIFOINT27bits __asm__ ("C1FIFOINT27") __attribute__((section("sfrs"), address(0xBF880A20)));
extern volatile uint32_t        C1FIFOINT27CLR __attribute__((section("sfrs"),address(0xBF880A24)));
extern volatile uint32_t        C1FIFOINT27SET __attribute__((section("sfrs"),address(0xBF880A28)));
extern volatile uint32_t        C1FIFOINT27INV __attribute__((section("sfrs"),address(0xBF880A2C)));
#define C1FIFOUA27 C1FIFOUA27
extern volatile uint32_t   C1FIFOUA27 __attribute__((section("sfrs"), address(0xBF880A30)));
extern volatile uint32_t        C1FIFOUA27CLR __attribute__((section("sfrs"),address(0xBF880A34)));
extern volatile uint32_t        C1FIFOUA27SET __attribute__((section("sfrs"),address(0xBF880A38)));
extern volatile uint32_t        C1FIFOUA27INV __attribute__((section("sfrs"),address(0xBF880A3C)));
#define C1FIFOCI27 C1FIFOCI27
extern volatile uint32_t   C1FIFOCI27 __attribute__((section("sfrs"), address(0xBF880A40)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI27bits_t;
extern volatile __C1FIFOCI27bits_t C1FIFOCI27bits __asm__ ("C1FIFOCI27") __attribute__((section("sfrs"), address(0xBF880A40)));
extern volatile uint32_t        C1FIFOCI27CLR __attribute__((section("sfrs"),address(0xBF880A44)));
extern volatile uint32_t        C1FIFOCI27SET __attribute__((section("sfrs"),address(0xBF880A48)));
extern volatile uint32_t        C1FIFOCI27INV __attribute__((section("sfrs"),address(0xBF880A4C)));
#define C1FIFOCON28 C1FIFOCON28
extern volatile uint32_t   C1FIFOCON28 __attribute__((section("sfrs"), address(0xBF880A50)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON28bits_t;
extern volatile __C1FIFOCON28bits_t C1FIFOCON28bits __asm__ ("C1FIFOCON28") __attribute__((section("sfrs"), address(0xBF880A50)));
extern volatile uint32_t        C1FIFOCON28CLR __attribute__((section("sfrs"),address(0xBF880A54)));
extern volatile uint32_t        C1FIFOCON28SET __attribute__((section("sfrs"),address(0xBF880A58)));
extern volatile uint32_t        C1FIFOCON28INV __attribute__((section("sfrs"),address(0xBF880A5C)));
#define C1FIFOINT28 C1FIFOINT28
extern volatile uint32_t   C1FIFOINT28 __attribute__((section("sfrs"), address(0xBF880A60)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT28bits_t;
extern volatile __C1FIFOINT28bits_t C1FIFOINT28bits __asm__ ("C1FIFOINT28") __attribute__((section("sfrs"), address(0xBF880A60)));
extern volatile uint32_t        C1FIFOINT28CLR __attribute__((section("sfrs"),address(0xBF880A64)));
extern volatile uint32_t        C1FIFOINT28SET __attribute__((section("sfrs"),address(0xBF880A68)));
extern volatile uint32_t        C1FIFOINT28INV __attribute__((section("sfrs"),address(0xBF880A6C)));
#define C1FIFOUA28 C1FIFOUA28
extern volatile uint32_t   C1FIFOUA28 __attribute__((section("sfrs"), address(0xBF880A70)));
extern volatile uint32_t        C1FIFOUA28CLR __attribute__((section("sfrs"),address(0xBF880A74)));
extern volatile uint32_t        C1FIFOUA28SET __attribute__((section("sfrs"),address(0xBF880A78)));
extern volatile uint32_t        C1FIFOUA28INV __attribute__((section("sfrs"),address(0xBF880A7C)));
#define C1FIFOCI28 C1FIFOCI28
extern volatile uint32_t   C1FIFOCI28 __attribute__((section("sfrs"), address(0xBF880A80)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI28bits_t;
extern volatile __C1FIFOCI28bits_t C1FIFOCI28bits __asm__ ("C1FIFOCI28") __attribute__((section("sfrs"), address(0xBF880A80)));
extern volatile uint32_t        C1FIFOCI28CLR __attribute__((section("sfrs"),address(0xBF880A84)));
extern volatile uint32_t        C1FIFOCI28SET __attribute__((section("sfrs"),address(0xBF880A88)));
extern volatile uint32_t        C1FIFOCI28INV __attribute__((section("sfrs"),address(0xBF880A8C)));
#define C1FIFOCON29 C1FIFOCON29
extern volatile uint32_t   C1FIFOCON29 __attribute__((section("sfrs"), address(0xBF880A90)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON29bits_t;
extern volatile __C1FIFOCON29bits_t C1FIFOCON29bits __asm__ ("C1FIFOCON29") __attribute__((section("sfrs"), address(0xBF880A90)));
extern volatile uint32_t        C1FIFOCON29CLR __attribute__((section("sfrs"),address(0xBF880A94)));
extern volatile uint32_t        C1FIFOCON29SET __attribute__((section("sfrs"),address(0xBF880A98)));
extern volatile uint32_t        C1FIFOCON29INV __attribute__((section("sfrs"),address(0xBF880A9C)));
#define C1FIFOINT29 C1FIFOINT29
extern volatile uint32_t   C1FIFOINT29 __attribute__((section("sfrs"), address(0xBF880AA0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT29bits_t;
extern volatile __C1FIFOINT29bits_t C1FIFOINT29bits __asm__ ("C1FIFOINT29") __attribute__((section("sfrs"), address(0xBF880AA0)));
extern volatile uint32_t        C1FIFOINT29CLR __attribute__((section("sfrs"),address(0xBF880AA4)));
extern volatile uint32_t        C1FIFOINT29SET __attribute__((section("sfrs"),address(0xBF880AA8)));
extern volatile uint32_t        C1FIFOINT29INV __attribute__((section("sfrs"),address(0xBF880AAC)));
#define C1FIFOUA29 C1FIFOUA29
extern volatile uint32_t   C1FIFOUA29 __attribute__((section("sfrs"), address(0xBF880AB0)));
extern volatile uint32_t        C1FIFOUA29CLR __attribute__((section("sfrs"),address(0xBF880AB4)));
extern volatile uint32_t        C1FIFOUA29SET __attribute__((section("sfrs"),address(0xBF880AB8)));
extern volatile uint32_t        C1FIFOUA29INV __attribute__((section("sfrs"),address(0xBF880ABC)));
#define C1FIFOCI29 C1FIFOCI29
extern volatile uint32_t   C1FIFOCI29 __attribute__((section("sfrs"), address(0xBF880AC0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI29bits_t;
extern volatile __C1FIFOCI29bits_t C1FIFOCI29bits __asm__ ("C1FIFOCI29") __attribute__((section("sfrs"), address(0xBF880AC0)));
extern volatile uint32_t        C1FIFOCI29CLR __attribute__((section("sfrs"),address(0xBF880AC4)));
extern volatile uint32_t        C1FIFOCI29SET __attribute__((section("sfrs"),address(0xBF880AC8)));
extern volatile uint32_t        C1FIFOCI29INV __attribute__((section("sfrs"),address(0xBF880ACC)));
#define C1FIFOCON30 C1FIFOCON30
extern volatile uint32_t   C1FIFOCON30 __attribute__((section("sfrs"), address(0xBF880AD0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON30bits_t;
extern volatile __C1FIFOCON30bits_t C1FIFOCON30bits __asm__ ("C1FIFOCON30") __attribute__((section("sfrs"), address(0xBF880AD0)));
extern volatile uint32_t        C1FIFOCON30CLR __attribute__((section("sfrs"),address(0xBF880AD4)));
extern volatile uint32_t        C1FIFOCON30SET __attribute__((section("sfrs"),address(0xBF880AD8)));
extern volatile uint32_t        C1FIFOCON30INV __attribute__((section("sfrs"),address(0xBF880ADC)));
#define C1FIFOINT30 C1FIFOINT30
extern volatile uint32_t   C1FIFOINT30 __attribute__((section("sfrs"), address(0xBF880AE0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT30bits_t;
extern volatile __C1FIFOINT30bits_t C1FIFOINT30bits __asm__ ("C1FIFOINT30") __attribute__((section("sfrs"), address(0xBF880AE0)));
extern volatile uint32_t        C1FIFOINT30CLR __attribute__((section("sfrs"),address(0xBF880AE4)));
extern volatile uint32_t        C1FIFOINT30SET __attribute__((section("sfrs"),address(0xBF880AE8)));
extern volatile uint32_t        C1FIFOINT30INV __attribute__((section("sfrs"),address(0xBF880AEC)));
#define C1FIFOUA30 C1FIFOUA30
extern volatile uint32_t   C1FIFOUA30 __attribute__((section("sfrs"), address(0xBF880AF0)));
extern volatile uint32_t        C1FIFOUA30CLR __attribute__((section("sfrs"),address(0xBF880AF4)));
extern volatile uint32_t        C1FIFOUA30SET __attribute__((section("sfrs"),address(0xBF880AF8)));
extern volatile uint32_t        C1FIFOUA30INV __attribute__((section("sfrs"),address(0xBF880AFC)));
#define C1FIFOCI30 C1FIFOCI30
extern volatile uint32_t   C1FIFOCI30 __attribute__((section("sfrs"), address(0xBF880B00)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI30bits_t;
extern volatile __C1FIFOCI30bits_t C1FIFOCI30bits __asm__ ("C1FIFOCI30") __attribute__((section("sfrs"), address(0xBF880B00)));
extern volatile uint32_t        C1FIFOCI30CLR __attribute__((section("sfrs"),address(0xBF880B04)));
extern volatile uint32_t        C1FIFOCI30SET __attribute__((section("sfrs"),address(0xBF880B08)));
extern volatile uint32_t        C1FIFOCI30INV __attribute__((section("sfrs"),address(0xBF880B0C)));
#define C1FIFOCON31 C1FIFOCON31
extern volatile uint32_t   C1FIFOCON31 __attribute__((section("sfrs"), address(0xBF880B10)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCON31bits_t;
extern volatile __C1FIFOCON31bits_t C1FIFOCON31bits __asm__ ("C1FIFOCON31") __attribute__((section("sfrs"), address(0xBF880B10)));
extern volatile uint32_t        C1FIFOCON31CLR __attribute__((section("sfrs"),address(0xBF880B14)));
extern volatile uint32_t        C1FIFOCON31SET __attribute__((section("sfrs"),address(0xBF880B18)));
extern volatile uint32_t        C1FIFOCON31INV __attribute__((section("sfrs"),address(0xBF880B1C)));
#define C1FIFOINT31 C1FIFOINT31
extern volatile uint32_t   C1FIFOINT31 __attribute__((section("sfrs"), address(0xBF880B20)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOINT31bits_t;
extern volatile __C1FIFOINT31bits_t C1FIFOINT31bits __asm__ ("C1FIFOINT31") __attribute__((section("sfrs"), address(0xBF880B20)));
extern volatile uint32_t        C1FIFOINT31CLR __attribute__((section("sfrs"),address(0xBF880B24)));
extern volatile uint32_t        C1FIFOINT31SET __attribute__((section("sfrs"),address(0xBF880B28)));
extern volatile uint32_t        C1FIFOINT31INV __attribute__((section("sfrs"),address(0xBF880B2C)));
#define C1FIFOUA31 C1FIFOUA31
extern volatile uint32_t   C1FIFOUA31 __attribute__((section("sfrs"), address(0xBF880B30)));
extern volatile uint32_t        C1FIFOUA31CLR __attribute__((section("sfrs"),address(0xBF880B34)));
extern volatile uint32_t        C1FIFOUA31SET __attribute__((section("sfrs"),address(0xBF880B38)));
extern volatile uint32_t        C1FIFOUA31INV __attribute__((section("sfrs"),address(0xBF880B3C)));
#define C1FIFOCI31 C1FIFOCI31
extern volatile uint32_t   C1FIFOCI31 __attribute__((section("sfrs"), address(0xBF880B40)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C1FIFOCI31bits_t;
extern volatile __C1FIFOCI31bits_t C1FIFOCI31bits __asm__ ("C1FIFOCI31") __attribute__((section("sfrs"), address(0xBF880B40)));
extern volatile uint32_t        C1FIFOCI31CLR __attribute__((section("sfrs"),address(0xBF880B44)));
extern volatile uint32_t        C1FIFOCI31SET __attribute__((section("sfrs"),address(0xBF880B48)));
extern volatile uint32_t        C1FIFOCI31INV __attribute__((section("sfrs"),address(0xBF880B4C)));
#define C2CON C2CON
extern volatile uint32_t   C2CON __attribute__((section("sfrs"), address(0xBF881000)));
typedef union {
  struct {
    uint32_t DNCNT:5;
    uint32_t :6;
    uint32_t CANBUSY:1;
    uint32_t :1;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t :4;
    uint32_t CANCAP:1;
    uint32_t OPMOD:3;
    uint32_t REQOP:3;
    uint32_t ABAT:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2CONbits_t;
extern volatile __C2CONbits_t C2CONbits __asm__ ("C2CON") __attribute__((section("sfrs"), address(0xBF881000)));
extern volatile uint32_t        C2CONCLR __attribute__((section("sfrs"),address(0xBF881004)));
extern volatile uint32_t        C2CONSET __attribute__((section("sfrs"),address(0xBF881008)));
extern volatile uint32_t        C2CONINV __attribute__((section("sfrs"),address(0xBF88100C)));
#define C2CFG C2CFG
extern volatile uint32_t   C2CFG __attribute__((section("sfrs"), address(0xBF881010)));
typedef union {
  struct {
    uint32_t BRP:6;
    uint32_t SJW:2;
    uint32_t PRSEG:3;
    uint32_t SEG1PH:3;
    uint32_t SAM:1;
    uint32_t SEG2PHTS:1;
    uint32_t SEG2PH:3;
    uint32_t :3;
    uint32_t WAKFIL:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2CFGbits_t;
extern volatile __C2CFGbits_t C2CFGbits __asm__ ("C2CFG") __attribute__((section("sfrs"), address(0xBF881010)));
extern volatile uint32_t        C2CFGCLR __attribute__((section("sfrs"),address(0xBF881014)));
extern volatile uint32_t        C2CFGSET __attribute__((section("sfrs"),address(0xBF881018)));
extern volatile uint32_t        C2CFGINV __attribute__((section("sfrs"),address(0xBF88101C)));
#define C2INT C2INT
extern volatile uint32_t   C2INT __attribute__((section("sfrs"), address(0xBF881020)));
typedef union {
  struct {
    uint32_t TBIF:1;
    uint32_t RBIF:1;
    uint32_t CTMRIF:1;
    uint32_t MODIF:1;
    uint32_t :7;
    uint32_t RBOVIF:1;
    uint32_t SERRIF:1;
    uint32_t CERRIF:1;
    uint32_t WAKIF:1;
    uint32_t IVRIF:1;
    uint32_t TBIE:1;
    uint32_t RBIE:1;
    uint32_t CTMRIE:1;
    uint32_t MODIE:1;
    uint32_t :7;
    uint32_t RBOVIE:1;
    uint32_t SERRIE:1;
    uint32_t CERRIE:1;
    uint32_t WAKIE:1;
    uint32_t IVRIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2INTbits_t;
extern volatile __C2INTbits_t C2INTbits __asm__ ("C2INT") __attribute__((section("sfrs"), address(0xBF881020)));
extern volatile uint32_t        C2INTCLR __attribute__((section("sfrs"),address(0xBF881024)));
extern volatile uint32_t        C2INTSET __attribute__((section("sfrs"),address(0xBF881028)));
extern volatile uint32_t        C2INTINV __attribute__((section("sfrs"),address(0xBF88102C)));
#define C2VEC C2VEC
extern volatile uint32_t   C2VEC __attribute__((section("sfrs"), address(0xBF881030)));
typedef union {
  struct {
    uint32_t ICODE:7;
    uint32_t :1;
    uint32_t FILHIT:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2VECbits_t;
extern volatile __C2VECbits_t C2VECbits __asm__ ("C2VEC") __attribute__((section("sfrs"), address(0xBF881030)));
extern volatile uint32_t        C2VECCLR __attribute__((section("sfrs"),address(0xBF881034)));
extern volatile uint32_t        C2VECSET __attribute__((section("sfrs"),address(0xBF881038)));
extern volatile uint32_t        C2VECINV __attribute__((section("sfrs"),address(0xBF88103C)));
#define C2TREC C2TREC
extern volatile uint32_t   C2TREC __attribute__((section("sfrs"), address(0xBF881040)));
typedef union {
  struct {
    uint32_t RERRCNT:8;
    uint32_t TERRCNT:8;
    uint32_t EWARN:1;
    uint32_t RXWARN:1;
    uint32_t TXWARN:1;
    uint32_t RXBP:1;
    uint32_t TXBP:1;
    uint32_t TXBO:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2TRECbits_t;
extern volatile __C2TRECbits_t C2TRECbits __asm__ ("C2TREC") __attribute__((section("sfrs"), address(0xBF881040)));
extern volatile uint32_t        C2TRECCLR __attribute__((section("sfrs"),address(0xBF881044)));
extern volatile uint32_t        C2TRECSET __attribute__((section("sfrs"),address(0xBF881048)));
extern volatile uint32_t        C2TRECINV __attribute__((section("sfrs"),address(0xBF88104C)));
#define C2FSTAT C2FSTAT
extern volatile uint32_t   C2FSTAT __attribute__((section("sfrs"), address(0xBF881050)));
typedef union {
  struct {
    uint32_t FIFOIP:32;
  };
  struct {
    uint32_t FIFOIP0:1;
    uint32_t FIFOIP1:1;
    uint32_t FIFOIP2:1;
    uint32_t FIFOIP3:1;
    uint32_t FIFOIP4:1;
    uint32_t FIFOIP5:1;
    uint32_t FIFOIP6:1;
    uint32_t FIFOIP7:1;
    uint32_t FIFOIP8:1;
    uint32_t FIFOIP9:1;
    uint32_t FIFOIP10:1;
    uint32_t FIFOIP11:1;
    uint32_t FIFOIP12:1;
    uint32_t FIFOIP13:1;
    uint32_t FIFOIP14:1;
    uint32_t FIFOIP15:1;
    uint32_t FIFOIP16:1;
    uint32_t FIFOIP17:1;
    uint32_t FIFOIP18:1;
    uint32_t FIFOIP19:1;
    uint32_t FIFOIP20:1;
    uint32_t FIFOIP21:1;
    uint32_t FIFOIP22:1;
    uint32_t FIFOIP23:1;
    uint32_t FIFOIP24:1;
    uint32_t FIFOIP25:1;
    uint32_t FIFOIP26:1;
    uint32_t FIFOIP27:1;
    uint32_t FIFOIP28:1;
    uint32_t FIFOIP29:1;
    uint32_t FIFOIP30:1;
    uint32_t FIFOIP31:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FSTATbits_t;
extern volatile __C2FSTATbits_t C2FSTATbits __asm__ ("C2FSTAT") __attribute__((section("sfrs"), address(0xBF881050)));
extern volatile uint32_t        C2FSTATCLR __attribute__((section("sfrs"),address(0xBF881054)));
extern volatile uint32_t        C2FSTATSET __attribute__((section("sfrs"),address(0xBF881058)));
extern volatile uint32_t        C2FSTATINV __attribute__((section("sfrs"),address(0xBF88105C)));
#define C2RXOVF C2RXOVF
extern volatile uint32_t   C2RXOVF __attribute__((section("sfrs"), address(0xBF881060)));
typedef union {
  struct {
    uint32_t RXOVF:32;
  };
  struct {
    uint32_t RXOVF0:1;
    uint32_t RXOVF1:1;
    uint32_t RXOVF2:1;
    uint32_t RXOVF3:1;
    uint32_t RXOVF4:1;
    uint32_t RXOVF5:1;
    uint32_t RXOVF6:1;
    uint32_t RXOVF7:1;
    uint32_t RXOVF8:1;
    uint32_t RXOVF9:1;
    uint32_t RXOVF10:1;
    uint32_t RXOVF11:1;
    uint32_t RXOVF12:1;
    uint32_t RXOVF13:1;
    uint32_t RXOVF14:1;
    uint32_t RXOVF15:1;
    uint32_t RXOVF16:1;
    uint32_t RXOVF17:1;
    uint32_t RXOVF18:1;
    uint32_t RXOVF19:1;
    uint32_t RXOVF20:1;
    uint32_t RXOVF21:1;
    uint32_t RXOVF22:1;
    uint32_t RXOVF23:1;
    uint32_t RXOVF24:1;
    uint32_t RXOVF25:1;
    uint32_t RXOVF26:1;
    uint32_t RXOVF27:1;
    uint32_t RXOVF28:1;
    uint32_t RXOVF29:1;
    uint32_t RXOVF30:1;
    uint32_t RXOVF31:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXOVFbits_t;
extern volatile __C2RXOVFbits_t C2RXOVFbits __asm__ ("C2RXOVF") __attribute__((section("sfrs"), address(0xBF881060)));
extern volatile uint32_t        C2RXOVFCLR __attribute__((section("sfrs"),address(0xBF881064)));
extern volatile uint32_t        C2RXOVFSET __attribute__((section("sfrs"),address(0xBF881068)));
extern volatile uint32_t        C2RXOVFINV __attribute__((section("sfrs"),address(0xBF88106C)));
#define C2TMR C2TMR
extern volatile uint32_t   C2TMR __attribute__((section("sfrs"), address(0xBF881070)));
typedef union {
  struct {
    uint32_t CANTSPRE:16;
    uint32_t CANTS:16;
  };
  struct {
    uint32_t w:32;
  };
} __C2TMRbits_t;
extern volatile __C2TMRbits_t C2TMRbits __asm__ ("C2TMR") __attribute__((section("sfrs"), address(0xBF881070)));
extern volatile uint32_t        C2TMRCLR __attribute__((section("sfrs"),address(0xBF881074)));
extern volatile uint32_t        C2TMRSET __attribute__((section("sfrs"),address(0xBF881078)));
extern volatile uint32_t        C2TMRINV __attribute__((section("sfrs"),address(0xBF88107C)));
#define C2RXM0 C2RXM0
extern volatile uint32_t   C2RXM0 __attribute__((section("sfrs"), address(0xBF881080)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXM0bits_t;
extern volatile __C2RXM0bits_t C2RXM0bits __asm__ ("C2RXM0") __attribute__((section("sfrs"), address(0xBF881080)));
extern volatile uint32_t        C2RXM0CLR __attribute__((section("sfrs"),address(0xBF881084)));
extern volatile uint32_t        C2RXM0SET __attribute__((section("sfrs"),address(0xBF881088)));
extern volatile uint32_t        C2RXM0INV __attribute__((section("sfrs"),address(0xBF88108C)));
#define C2RXM1 C2RXM1
extern volatile uint32_t   C2RXM1 __attribute__((section("sfrs"), address(0xBF881090)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXM1bits_t;
extern volatile __C2RXM1bits_t C2RXM1bits __asm__ ("C2RXM1") __attribute__((section("sfrs"), address(0xBF881090)));
extern volatile uint32_t        C2RXM1CLR __attribute__((section("sfrs"),address(0xBF881094)));
extern volatile uint32_t        C2RXM1SET __attribute__((section("sfrs"),address(0xBF881098)));
extern volatile uint32_t        C2RXM1INV __attribute__((section("sfrs"),address(0xBF88109C)));
#define C2RXM2 C2RXM2
extern volatile uint32_t   C2RXM2 __attribute__((section("sfrs"), address(0xBF8810A0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXM2bits_t;
extern volatile __C2RXM2bits_t C2RXM2bits __asm__ ("C2RXM2") __attribute__((section("sfrs"), address(0xBF8810A0)));
extern volatile uint32_t        C2RXM2CLR __attribute__((section("sfrs"),address(0xBF8810A4)));
extern volatile uint32_t        C2RXM2SET __attribute__((section("sfrs"),address(0xBF8810A8)));
extern volatile uint32_t        C2RXM2INV __attribute__((section("sfrs"),address(0xBF8810AC)));
#define C2RXM3 C2RXM3
extern volatile uint32_t   C2RXM3 __attribute__((section("sfrs"), address(0xBF8810B0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t MIDE:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXM3bits_t;
extern volatile __C2RXM3bits_t C2RXM3bits __asm__ ("C2RXM3") __attribute__((section("sfrs"), address(0xBF8810B0)));
extern volatile uint32_t        C2RXM3CLR __attribute__((section("sfrs"),address(0xBF8810B4)));
extern volatile uint32_t        C2RXM3SET __attribute__((section("sfrs"),address(0xBF8810B8)));
extern volatile uint32_t        C2RXM3INV __attribute__((section("sfrs"),address(0xBF8810BC)));
#define C2FLTCON0 C2FLTCON0
extern volatile uint32_t   C2FLTCON0 __attribute__((section("sfrs"), address(0xBF8810C0)));
typedef union {
  struct {
    uint32_t FSEL0:5;
    uint32_t MSEL0:2;
    uint32_t FLTEN0:1;
    uint32_t FSEL1:5;
    uint32_t MSEL1:2;
    uint32_t FLTEN1:1;
    uint32_t FSEL2:5;
    uint32_t MSEL2:2;
    uint32_t FLTEN2:1;
    uint32_t FSEL3:5;
    uint32_t MSEL3:2;
    uint32_t FLTEN3:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON0bits_t;
extern volatile __C2FLTCON0bits_t C2FLTCON0bits __asm__ ("C2FLTCON0") __attribute__((section("sfrs"), address(0xBF8810C0)));
extern volatile uint32_t        C2FLTCON0CLR __attribute__((section("sfrs"),address(0xBF8810C4)));
extern volatile uint32_t        C2FLTCON0SET __attribute__((section("sfrs"),address(0xBF8810C8)));
extern volatile uint32_t        C2FLTCON0INV __attribute__((section("sfrs"),address(0xBF8810CC)));
#define C2FLTCON1 C2FLTCON1
extern volatile uint32_t   C2FLTCON1 __attribute__((section("sfrs"), address(0xBF8810D0)));
typedef union {
  struct {
    uint32_t FSEL4:5;
    uint32_t MSEL4:2;
    uint32_t FLTEN4:1;
    uint32_t FSEL5:5;
    uint32_t MSEL5:2;
    uint32_t FLTEN5:1;
    uint32_t FSEL6:5;
    uint32_t MSEL6:2;
    uint32_t FLTEN6:1;
    uint32_t FSEL7:5;
    uint32_t MSEL7:2;
    uint32_t FLTEN7:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON1bits_t;
extern volatile __C2FLTCON1bits_t C2FLTCON1bits __asm__ ("C2FLTCON1") __attribute__((section("sfrs"), address(0xBF8810D0)));
extern volatile uint32_t        C2FLTCON1CLR __attribute__((section("sfrs"),address(0xBF8810D4)));
extern volatile uint32_t        C2FLTCON1SET __attribute__((section("sfrs"),address(0xBF8810D8)));
extern volatile uint32_t        C2FLTCON1INV __attribute__((section("sfrs"),address(0xBF8810DC)));
#define C2FLTCON2 C2FLTCON2
extern volatile uint32_t   C2FLTCON2 __attribute__((section("sfrs"), address(0xBF8810E0)));
typedef union {
  struct {
    uint32_t FSEL8:5;
    uint32_t MSEL8:2;
    uint32_t FLTEN8:1;
    uint32_t FSEL9:5;
    uint32_t MSEL9:2;
    uint32_t FLTEN9:1;
    uint32_t FSEL10:5;
    uint32_t MSEL10:2;
    uint32_t FLTEN10:1;
    uint32_t FSEL11:5;
    uint32_t MSEL11:2;
    uint32_t FLTEN11:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON2bits_t;
extern volatile __C2FLTCON2bits_t C2FLTCON2bits __asm__ ("C2FLTCON2") __attribute__((section("sfrs"), address(0xBF8810E0)));
extern volatile uint32_t        C2FLTCON2CLR __attribute__((section("sfrs"),address(0xBF8810E4)));
extern volatile uint32_t        C2FLTCON2SET __attribute__((section("sfrs"),address(0xBF8810E8)));
extern volatile uint32_t        C2FLTCON2INV __attribute__((section("sfrs"),address(0xBF8810EC)));
#define C2FLTCON3 C2FLTCON3
extern volatile uint32_t   C2FLTCON3 __attribute__((section("sfrs"), address(0xBF8810F0)));
typedef union {
  struct {
    uint32_t FSEL12:5;
    uint32_t MSEL12:2;
    uint32_t FLTEN12:1;
    uint32_t FSEL13:5;
    uint32_t MSEL13:2;
    uint32_t FLTEN13:1;
    uint32_t FSEL14:5;
    uint32_t MSEL14:2;
    uint32_t FLTEN14:1;
    uint32_t FSEL15:5;
    uint32_t MSEL15:2;
    uint32_t FLTEN15:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON3bits_t;
extern volatile __C2FLTCON3bits_t C2FLTCON3bits __asm__ ("C2FLTCON3") __attribute__((section("sfrs"), address(0xBF8810F0)));
extern volatile uint32_t        C2FLTCON3CLR __attribute__((section("sfrs"),address(0xBF8810F4)));
extern volatile uint32_t        C2FLTCON3SET __attribute__((section("sfrs"),address(0xBF8810F8)));
extern volatile uint32_t        C2FLTCON3INV __attribute__((section("sfrs"),address(0xBF8810FC)));
#define C2FLTCON4 C2FLTCON4
extern volatile uint32_t   C2FLTCON4 __attribute__((section("sfrs"), address(0xBF881100)));
typedef union {
  struct {
    uint32_t FSEL16:5;
    uint32_t MSEL16:2;
    uint32_t FLTEN16:1;
    uint32_t FSEL17:5;
    uint32_t MSEL17:2;
    uint32_t FLTEN17:1;
    uint32_t FSEL18:5;
    uint32_t MSEL18:2;
    uint32_t FLTEN18:1;
    uint32_t FSEL19:5;
    uint32_t MSEL19:2;
    uint32_t FLTEN19:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON4bits_t;
extern volatile __C2FLTCON4bits_t C2FLTCON4bits __asm__ ("C2FLTCON4") __attribute__((section("sfrs"), address(0xBF881100)));
extern volatile uint32_t        C2FLTCON4CLR __attribute__((section("sfrs"),address(0xBF881104)));
extern volatile uint32_t        C2FLTCON4SET __attribute__((section("sfrs"),address(0xBF881108)));
extern volatile uint32_t        C2FLTCON4INV __attribute__((section("sfrs"),address(0xBF88110C)));
#define C2FLTCON5 C2FLTCON5
extern volatile uint32_t   C2FLTCON5 __attribute__((section("sfrs"), address(0xBF881110)));
typedef union {
  struct {
    uint32_t FSEL20:5;
    uint32_t MSEL20:2;
    uint32_t FLTEN20:1;
    uint32_t FSEL21:5;
    uint32_t MSEL21:2;
    uint32_t FLTEN21:1;
    uint32_t FSEL22:5;
    uint32_t MSEL22:2;
    uint32_t FLTEN22:1;
    uint32_t FSEL23:5;
    uint32_t MSEL23:2;
    uint32_t FLTEN23:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON5bits_t;
extern volatile __C2FLTCON5bits_t C2FLTCON5bits __asm__ ("C2FLTCON5") __attribute__((section("sfrs"), address(0xBF881110)));
extern volatile uint32_t        C2FLTCON5CLR __attribute__((section("sfrs"),address(0xBF881114)));
extern volatile uint32_t        C2FLTCON5SET __attribute__((section("sfrs"),address(0xBF881118)));
extern volatile uint32_t        C2FLTCON5INV __attribute__((section("sfrs"),address(0xBF88111C)));
#define C2FLTCON6 C2FLTCON6
extern volatile uint32_t   C2FLTCON6 __attribute__((section("sfrs"), address(0xBF881120)));
typedef union {
  struct {
    uint32_t FSEL24:5;
    uint32_t MSEL24:2;
    uint32_t FLTEN24:1;
    uint32_t FSEL25:5;
    uint32_t MSEL25:2;
    uint32_t FLTEN25:1;
    uint32_t FSEL26:5;
    uint32_t MSEL26:2;
    uint32_t FLTEN26:1;
    uint32_t FSEL27:5;
    uint32_t MSEL27:2;
    uint32_t FLTEN27:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON6bits_t;
extern volatile __C2FLTCON6bits_t C2FLTCON6bits __asm__ ("C2FLTCON6") __attribute__((section("sfrs"), address(0xBF881120)));
extern volatile uint32_t        C2FLTCON6CLR __attribute__((section("sfrs"),address(0xBF881124)));
extern volatile uint32_t        C2FLTCON6SET __attribute__((section("sfrs"),address(0xBF881128)));
extern volatile uint32_t        C2FLTCON6INV __attribute__((section("sfrs"),address(0xBF88112C)));
#define C2FLTCON7 C2FLTCON7
extern volatile uint32_t   C2FLTCON7 __attribute__((section("sfrs"), address(0xBF881130)));
typedef union {
  struct {
    uint32_t FSEL28:5;
    uint32_t MSEL28:2;
    uint32_t FLTEN28:1;
    uint32_t FSEL29:5;
    uint32_t MSEL29:2;
    uint32_t FLTEN29:1;
    uint32_t FSEL30:5;
    uint32_t MSEL30:2;
    uint32_t FLTEN30:1;
    uint32_t FSEL31:5;
    uint32_t MSEL31:2;
    uint32_t FLTEN31:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FLTCON7bits_t;
extern volatile __C2FLTCON7bits_t C2FLTCON7bits __asm__ ("C2FLTCON7") __attribute__((section("sfrs"), address(0xBF881130)));
extern volatile uint32_t        C2FLTCON7CLR __attribute__((section("sfrs"),address(0xBF881134)));
extern volatile uint32_t        C2FLTCON7SET __attribute__((section("sfrs"),address(0xBF881138)));
extern volatile uint32_t        C2FLTCON7INV __attribute__((section("sfrs"),address(0xBF88113C)));
#define C2RXF0 C2RXF0
extern volatile uint32_t   C2RXF0 __attribute__((section("sfrs"), address(0xBF881140)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF0bits_t;
extern volatile __C2RXF0bits_t C2RXF0bits __asm__ ("C2RXF0") __attribute__((section("sfrs"), address(0xBF881140)));
extern volatile uint32_t        C2RXF0CLR __attribute__((section("sfrs"),address(0xBF881144)));
extern volatile uint32_t        C2RXF0SET __attribute__((section("sfrs"),address(0xBF881148)));
extern volatile uint32_t        C2RXF0INV __attribute__((section("sfrs"),address(0xBF88114C)));
#define C2RXF1 C2RXF1
extern volatile uint32_t   C2RXF1 __attribute__((section("sfrs"), address(0xBF881150)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF1bits_t;
extern volatile __C2RXF1bits_t C2RXF1bits __asm__ ("C2RXF1") __attribute__((section("sfrs"), address(0xBF881150)));
extern volatile uint32_t        C2RXF1CLR __attribute__((section("sfrs"),address(0xBF881154)));
extern volatile uint32_t        C2RXF1SET __attribute__((section("sfrs"),address(0xBF881158)));
extern volatile uint32_t        C2RXF1INV __attribute__((section("sfrs"),address(0xBF88115C)));
#define C2RXF2 C2RXF2
extern volatile uint32_t   C2RXF2 __attribute__((section("sfrs"), address(0xBF881160)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF2bits_t;
extern volatile __C2RXF2bits_t C2RXF2bits __asm__ ("C2RXF2") __attribute__((section("sfrs"), address(0xBF881160)));
extern volatile uint32_t        C2RXF2CLR __attribute__((section("sfrs"),address(0xBF881164)));
extern volatile uint32_t        C2RXF2SET __attribute__((section("sfrs"),address(0xBF881168)));
extern volatile uint32_t        C2RXF2INV __attribute__((section("sfrs"),address(0xBF88116C)));
#define C2RXF3 C2RXF3
extern volatile uint32_t   C2RXF3 __attribute__((section("sfrs"), address(0xBF881170)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF3bits_t;
extern volatile __C2RXF3bits_t C2RXF3bits __asm__ ("C2RXF3") __attribute__((section("sfrs"), address(0xBF881170)));
extern volatile uint32_t        C2RXF3CLR __attribute__((section("sfrs"),address(0xBF881174)));
extern volatile uint32_t        C2RXF3SET __attribute__((section("sfrs"),address(0xBF881178)));
extern volatile uint32_t        C2RXF3INV __attribute__((section("sfrs"),address(0xBF88117C)));
#define C2RXF4 C2RXF4
extern volatile uint32_t   C2RXF4 __attribute__((section("sfrs"), address(0xBF881180)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF4bits_t;
extern volatile __C2RXF4bits_t C2RXF4bits __asm__ ("C2RXF4") __attribute__((section("sfrs"), address(0xBF881180)));
extern volatile uint32_t        C2RXF4CLR __attribute__((section("sfrs"),address(0xBF881184)));
extern volatile uint32_t        C2RXF4SET __attribute__((section("sfrs"),address(0xBF881188)));
extern volatile uint32_t        C2RXF4INV __attribute__((section("sfrs"),address(0xBF88118C)));
#define C2RXF5 C2RXF5
extern volatile uint32_t   C2RXF5 __attribute__((section("sfrs"), address(0xBF881190)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF5bits_t;
extern volatile __C2RXF5bits_t C2RXF5bits __asm__ ("C2RXF5") __attribute__((section("sfrs"), address(0xBF881190)));
extern volatile uint32_t        C2RXF5CLR __attribute__((section("sfrs"),address(0xBF881194)));
extern volatile uint32_t        C2RXF5SET __attribute__((section("sfrs"),address(0xBF881198)));
extern volatile uint32_t        C2RXF5INV __attribute__((section("sfrs"),address(0xBF88119C)));
#define C2RXF6 C2RXF6
extern volatile uint32_t   C2RXF6 __attribute__((section("sfrs"), address(0xBF8811A0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF6bits_t;
extern volatile __C2RXF6bits_t C2RXF6bits __asm__ ("C2RXF6") __attribute__((section("sfrs"), address(0xBF8811A0)));
extern volatile uint32_t        C2RXF6CLR __attribute__((section("sfrs"),address(0xBF8811A4)));
extern volatile uint32_t        C2RXF6SET __attribute__((section("sfrs"),address(0xBF8811A8)));
extern volatile uint32_t        C2RXF6INV __attribute__((section("sfrs"),address(0xBF8811AC)));
#define C2RXF7 C2RXF7
extern volatile uint32_t   C2RXF7 __attribute__((section("sfrs"), address(0xBF8811B0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF7bits_t;
extern volatile __C2RXF7bits_t C2RXF7bits __asm__ ("C2RXF7") __attribute__((section("sfrs"), address(0xBF8811B0)));
extern volatile uint32_t        C2RXF7CLR __attribute__((section("sfrs"),address(0xBF8811B4)));
extern volatile uint32_t        C2RXF7SET __attribute__((section("sfrs"),address(0xBF8811B8)));
extern volatile uint32_t        C2RXF7INV __attribute__((section("sfrs"),address(0xBF8811BC)));
#define C2RXF8 C2RXF8
extern volatile uint32_t   C2RXF8 __attribute__((section("sfrs"), address(0xBF8811C0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF8bits_t;
extern volatile __C2RXF8bits_t C2RXF8bits __asm__ ("C2RXF8") __attribute__((section("sfrs"), address(0xBF8811C0)));
extern volatile uint32_t        C2RXF8CLR __attribute__((section("sfrs"),address(0xBF8811C4)));
extern volatile uint32_t        C2RXF8SET __attribute__((section("sfrs"),address(0xBF8811C8)));
extern volatile uint32_t        C2RXF8INV __attribute__((section("sfrs"),address(0xBF8811CC)));
#define C2RXF9 C2RXF9
extern volatile uint32_t   C2RXF9 __attribute__((section("sfrs"), address(0xBF8811D0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF9bits_t;
extern volatile __C2RXF9bits_t C2RXF9bits __asm__ ("C2RXF9") __attribute__((section("sfrs"), address(0xBF8811D0)));
extern volatile uint32_t        C2RXF9CLR __attribute__((section("sfrs"),address(0xBF8811D4)));
extern volatile uint32_t        C2RXF9SET __attribute__((section("sfrs"),address(0xBF8811D8)));
extern volatile uint32_t        C2RXF9INV __attribute__((section("sfrs"),address(0xBF8811DC)));
#define C2RXF10 C2RXF10
extern volatile uint32_t   C2RXF10 __attribute__((section("sfrs"), address(0xBF8811E0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF10bits_t;
extern volatile __C2RXF10bits_t C2RXF10bits __asm__ ("C2RXF10") __attribute__((section("sfrs"), address(0xBF8811E0)));
extern volatile uint32_t        C2RXF10CLR __attribute__((section("sfrs"),address(0xBF8811E4)));
extern volatile uint32_t        C2RXF10SET __attribute__((section("sfrs"),address(0xBF8811E8)));
extern volatile uint32_t        C2RXF10INV __attribute__((section("sfrs"),address(0xBF8811EC)));
#define C2RXF11 C2RXF11
extern volatile uint32_t   C2RXF11 __attribute__((section("sfrs"), address(0xBF8811F0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF11bits_t;
extern volatile __C2RXF11bits_t C2RXF11bits __asm__ ("C2RXF11") __attribute__((section("sfrs"), address(0xBF8811F0)));
extern volatile uint32_t        C2RXF11CLR __attribute__((section("sfrs"),address(0xBF8811F4)));
extern volatile uint32_t        C2RXF11SET __attribute__((section("sfrs"),address(0xBF8811F8)));
extern volatile uint32_t        C2RXF11INV __attribute__((section("sfrs"),address(0xBF8811FC)));
#define C2RXF12 C2RXF12
extern volatile uint32_t   C2RXF12 __attribute__((section("sfrs"), address(0xBF881200)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF12bits_t;
extern volatile __C2RXF12bits_t C2RXF12bits __asm__ ("C2RXF12") __attribute__((section("sfrs"), address(0xBF881200)));
extern volatile uint32_t        C2RXF12CLR __attribute__((section("sfrs"),address(0xBF881204)));
extern volatile uint32_t        C2RXF12SET __attribute__((section("sfrs"),address(0xBF881208)));
extern volatile uint32_t        C2RXF12INV __attribute__((section("sfrs"),address(0xBF88120C)));
#define C2RXF13 C2RXF13
extern volatile uint32_t   C2RXF13 __attribute__((section("sfrs"), address(0xBF881210)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF13bits_t;
extern volatile __C2RXF13bits_t C2RXF13bits __asm__ ("C2RXF13") __attribute__((section("sfrs"), address(0xBF881210)));
extern volatile uint32_t        C2RXF13CLR __attribute__((section("sfrs"),address(0xBF881214)));
extern volatile uint32_t        C2RXF13SET __attribute__((section("sfrs"),address(0xBF881218)));
extern volatile uint32_t        C2RXF13INV __attribute__((section("sfrs"),address(0xBF88121C)));
#define C2RXF14 C2RXF14
extern volatile uint32_t   C2RXF14 __attribute__((section("sfrs"), address(0xBF881220)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF14bits_t;
extern volatile __C2RXF14bits_t C2RXF14bits __asm__ ("C2RXF14") __attribute__((section("sfrs"), address(0xBF881220)));
extern volatile uint32_t        C2RXF14CLR __attribute__((section("sfrs"),address(0xBF881224)));
extern volatile uint32_t        C2RXF14SET __attribute__((section("sfrs"),address(0xBF881228)));
extern volatile uint32_t        C2RXF14INV __attribute__((section("sfrs"),address(0xBF88122C)));
#define C2RXF15 C2RXF15
extern volatile uint32_t   C2RXF15 __attribute__((section("sfrs"), address(0xBF881230)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF15bits_t;
extern volatile __C2RXF15bits_t C2RXF15bits __asm__ ("C2RXF15") __attribute__((section("sfrs"), address(0xBF881230)));
extern volatile uint32_t        C2RXF15CLR __attribute__((section("sfrs"),address(0xBF881234)));
extern volatile uint32_t        C2RXF15SET __attribute__((section("sfrs"),address(0xBF881238)));
extern volatile uint32_t        C2RXF15INV __attribute__((section("sfrs"),address(0xBF88123C)));
#define C2RXF16 C2RXF16
extern volatile uint32_t   C2RXF16 __attribute__((section("sfrs"), address(0xBF881240)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF16bits_t;
extern volatile __C2RXF16bits_t C2RXF16bits __asm__ ("C2RXF16") __attribute__((section("sfrs"), address(0xBF881240)));
extern volatile uint32_t        C2RXF16CLR __attribute__((section("sfrs"),address(0xBF881244)));
extern volatile uint32_t        C2RXF16SET __attribute__((section("sfrs"),address(0xBF881248)));
extern volatile uint32_t        C2RXF16INV __attribute__((section("sfrs"),address(0xBF88124C)));
#define C2RXF17 C2RXF17
extern volatile uint32_t   C2RXF17 __attribute__((section("sfrs"), address(0xBF881250)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF17bits_t;
extern volatile __C2RXF17bits_t C2RXF17bits __asm__ ("C2RXF17") __attribute__((section("sfrs"), address(0xBF881250)));
extern volatile uint32_t        C2RXF17CLR __attribute__((section("sfrs"),address(0xBF881254)));
extern volatile uint32_t        C2RXF17SET __attribute__((section("sfrs"),address(0xBF881258)));
extern volatile uint32_t        C2RXF17INV __attribute__((section("sfrs"),address(0xBF88125C)));
#define C2RXF18 C2RXF18
extern volatile uint32_t   C2RXF18 __attribute__((section("sfrs"), address(0xBF881260)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF18bits_t;
extern volatile __C2RXF18bits_t C2RXF18bits __asm__ ("C2RXF18") __attribute__((section("sfrs"), address(0xBF881260)));
extern volatile uint32_t        C2RXF18CLR __attribute__((section("sfrs"),address(0xBF881264)));
extern volatile uint32_t        C2RXF18SET __attribute__((section("sfrs"),address(0xBF881268)));
extern volatile uint32_t        C2RXF18INV __attribute__((section("sfrs"),address(0xBF88126C)));
#define C2RXF19 C2RXF19
extern volatile uint32_t   C2RXF19 __attribute__((section("sfrs"), address(0xBF881270)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF19bits_t;
extern volatile __C2RXF19bits_t C2RXF19bits __asm__ ("C2RXF19") __attribute__((section("sfrs"), address(0xBF881270)));
extern volatile uint32_t        C2RXF19CLR __attribute__((section("sfrs"),address(0xBF881274)));
extern volatile uint32_t        C2RXF19SET __attribute__((section("sfrs"),address(0xBF881278)));
extern volatile uint32_t        C2RXF19INV __attribute__((section("sfrs"),address(0xBF88127C)));
#define C2RXF20 C2RXF20
extern volatile uint32_t   C2RXF20 __attribute__((section("sfrs"), address(0xBF881280)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF20bits_t;
extern volatile __C2RXF20bits_t C2RXF20bits __asm__ ("C2RXF20") __attribute__((section("sfrs"), address(0xBF881280)));
extern volatile uint32_t        C2RXF20CLR __attribute__((section("sfrs"),address(0xBF881284)));
extern volatile uint32_t        C2RXF20SET __attribute__((section("sfrs"),address(0xBF881288)));
extern volatile uint32_t        C2RXF20INV __attribute__((section("sfrs"),address(0xBF88128C)));
#define C2RXF21 C2RXF21
extern volatile uint32_t   C2RXF21 __attribute__((section("sfrs"), address(0xBF881290)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF21bits_t;
extern volatile __C2RXF21bits_t C2RXF21bits __asm__ ("C2RXF21") __attribute__((section("sfrs"), address(0xBF881290)));
extern volatile uint32_t        C2RXF21CLR __attribute__((section("sfrs"),address(0xBF881294)));
extern volatile uint32_t        C2RXF21SET __attribute__((section("sfrs"),address(0xBF881298)));
extern volatile uint32_t        C2RXF21INV __attribute__((section("sfrs"),address(0xBF88129C)));
#define C2RXF22 C2RXF22
extern volatile uint32_t   C2RXF22 __attribute__((section("sfrs"), address(0xBF8812A0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF22bits_t;
extern volatile __C2RXF22bits_t C2RXF22bits __asm__ ("C2RXF22") __attribute__((section("sfrs"), address(0xBF8812A0)));
extern volatile uint32_t        C2RXF22CLR __attribute__((section("sfrs"),address(0xBF8812A4)));
extern volatile uint32_t        C2RXF22SET __attribute__((section("sfrs"),address(0xBF8812A8)));
extern volatile uint32_t        C2RXF22INV __attribute__((section("sfrs"),address(0xBF8812AC)));
#define C2RXF23 C2RXF23
extern volatile uint32_t   C2RXF23 __attribute__((section("sfrs"), address(0xBF8812B0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF23bits_t;
extern volatile __C2RXF23bits_t C2RXF23bits __asm__ ("C2RXF23") __attribute__((section("sfrs"), address(0xBF8812B0)));
extern volatile uint32_t        C2RXF23CLR __attribute__((section("sfrs"),address(0xBF8812B4)));
extern volatile uint32_t        C2RXF23SET __attribute__((section("sfrs"),address(0xBF8812B8)));
extern volatile uint32_t        C2RXF23INV __attribute__((section("sfrs"),address(0xBF8812BC)));
#define C2RXF24 C2RXF24
extern volatile uint32_t   C2RXF24 __attribute__((section("sfrs"), address(0xBF8812C0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF24bits_t;
extern volatile __C2RXF24bits_t C2RXF24bits __asm__ ("C2RXF24") __attribute__((section("sfrs"), address(0xBF8812C0)));
extern volatile uint32_t        C2RXF24CLR __attribute__((section("sfrs"),address(0xBF8812C4)));
extern volatile uint32_t        C2RXF24SET __attribute__((section("sfrs"),address(0xBF8812C8)));
extern volatile uint32_t        C2RXF24INV __attribute__((section("sfrs"),address(0xBF8812CC)));
#define C2RXF25 C2RXF25
extern volatile uint32_t   C2RXF25 __attribute__((section("sfrs"), address(0xBF8812D0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF25bits_t;
extern volatile __C2RXF25bits_t C2RXF25bits __asm__ ("C2RXF25") __attribute__((section("sfrs"), address(0xBF8812D0)));
extern volatile uint32_t        C2RXF25CLR __attribute__((section("sfrs"),address(0xBF8812D4)));
extern volatile uint32_t        C2RXF25SET __attribute__((section("sfrs"),address(0xBF8812D8)));
extern volatile uint32_t        C2RXF25INV __attribute__((section("sfrs"),address(0xBF8812DC)));
#define C2RXF26 C2RXF26
extern volatile uint32_t   C2RXF26 __attribute__((section("sfrs"), address(0xBF8812E0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF26bits_t;
extern volatile __C2RXF26bits_t C2RXF26bits __asm__ ("C2RXF26") __attribute__((section("sfrs"), address(0xBF8812E0)));
extern volatile uint32_t        C2RXF26CLR __attribute__((section("sfrs"),address(0xBF8812E4)));
extern volatile uint32_t        C2RXF26SET __attribute__((section("sfrs"),address(0xBF8812E8)));
extern volatile uint32_t        C2RXF26INV __attribute__((section("sfrs"),address(0xBF8812EC)));
#define C2RXF27 C2RXF27
extern volatile uint32_t   C2RXF27 __attribute__((section("sfrs"), address(0xBF8812F0)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF27bits_t;
extern volatile __C2RXF27bits_t C2RXF27bits __asm__ ("C2RXF27") __attribute__((section("sfrs"), address(0xBF8812F0)));
extern volatile uint32_t        C2RXF27CLR __attribute__((section("sfrs"),address(0xBF8812F4)));
extern volatile uint32_t        C2RXF27SET __attribute__((section("sfrs"),address(0xBF8812F8)));
extern volatile uint32_t        C2RXF27INV __attribute__((section("sfrs"),address(0xBF8812FC)));
#define C2RXF28 C2RXF28
extern volatile uint32_t   C2RXF28 __attribute__((section("sfrs"), address(0xBF881300)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF28bits_t;
extern volatile __C2RXF28bits_t C2RXF28bits __asm__ ("C2RXF28") __attribute__((section("sfrs"), address(0xBF881300)));
extern volatile uint32_t        C2RXF28CLR __attribute__((section("sfrs"),address(0xBF881304)));
extern volatile uint32_t        C2RXF28SET __attribute__((section("sfrs"),address(0xBF881308)));
extern volatile uint32_t        C2RXF28INV __attribute__((section("sfrs"),address(0xBF88130C)));
#define C2RXF29 C2RXF29
extern volatile uint32_t   C2RXF29 __attribute__((section("sfrs"), address(0xBF881310)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF29bits_t;
extern volatile __C2RXF29bits_t C2RXF29bits __asm__ ("C2RXF29") __attribute__((section("sfrs"), address(0xBF881310)));
extern volatile uint32_t        C2RXF29CLR __attribute__((section("sfrs"),address(0xBF881314)));
extern volatile uint32_t        C2RXF29SET __attribute__((section("sfrs"),address(0xBF881318)));
extern volatile uint32_t        C2RXF29INV __attribute__((section("sfrs"),address(0xBF88131C)));
#define C2RXF30 C2RXF30
extern volatile uint32_t   C2RXF30 __attribute__((section("sfrs"), address(0xBF881320)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF30bits_t;
extern volatile __C2RXF30bits_t C2RXF30bits __asm__ ("C2RXF30") __attribute__((section("sfrs"), address(0xBF881320)));
extern volatile uint32_t        C2RXF30CLR __attribute__((section("sfrs"),address(0xBF881324)));
extern volatile uint32_t        C2RXF30SET __attribute__((section("sfrs"),address(0xBF881328)));
extern volatile uint32_t        C2RXF30INV __attribute__((section("sfrs"),address(0xBF88132C)));
#define C2RXF31 C2RXF31
extern volatile uint32_t   C2RXF31 __attribute__((section("sfrs"), address(0xBF881330)));
typedef union {
  struct {
    uint32_t EID:18;
    uint32_t :1;
    uint32_t EXID:1;
    uint32_t :1;
    uint32_t SID:11;
  };
  struct {
    uint32_t w:32;
  };
} __C2RXF31bits_t;
extern volatile __C2RXF31bits_t C2RXF31bits __asm__ ("C2RXF31") __attribute__((section("sfrs"), address(0xBF881330)));
extern volatile uint32_t        C2RXF31CLR __attribute__((section("sfrs"),address(0xBF881334)));
extern volatile uint32_t        C2RXF31SET __attribute__((section("sfrs"),address(0xBF881338)));
extern volatile uint32_t        C2RXF31INV __attribute__((section("sfrs"),address(0xBF88133C)));
#define C2FIFOBA C2FIFOBA
extern volatile uint32_t   C2FIFOBA __attribute__((section("sfrs"), address(0xBF881340)));
extern volatile uint32_t        C2FIFOBACLR __attribute__((section("sfrs"),address(0xBF881344)));
extern volatile uint32_t        C2FIFOBASET __attribute__((section("sfrs"),address(0xBF881348)));
extern volatile uint32_t        C2FIFOBAINV __attribute__((section("sfrs"),address(0xBF88134C)));
#define C2FIFOCON0 C2FIFOCON0
extern volatile uint32_t   C2FIFOCON0 __attribute__((section("sfrs"), address(0xBF881350)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON0bits_t;
extern volatile __C2FIFOCON0bits_t C2FIFOCON0bits __asm__ ("C2FIFOCON0") __attribute__((section("sfrs"), address(0xBF881350)));
extern volatile uint32_t        C2FIFOCON0CLR __attribute__((section("sfrs"),address(0xBF881354)));
extern volatile uint32_t        C2FIFOCON0SET __attribute__((section("sfrs"),address(0xBF881358)));
extern volatile uint32_t        C2FIFOCON0INV __attribute__((section("sfrs"),address(0xBF88135C)));
#define C2FIFOINT0 C2FIFOINT0
extern volatile uint32_t   C2FIFOINT0 __attribute__((section("sfrs"), address(0xBF881360)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT0bits_t;
extern volatile __C2FIFOINT0bits_t C2FIFOINT0bits __asm__ ("C2FIFOINT0") __attribute__((section("sfrs"), address(0xBF881360)));
extern volatile uint32_t        C2FIFOINT0CLR __attribute__((section("sfrs"),address(0xBF881364)));
extern volatile uint32_t        C2FIFOINT0SET __attribute__((section("sfrs"),address(0xBF881368)));
extern volatile uint32_t        C2FIFOINT0INV __attribute__((section("sfrs"),address(0xBF88136C)));
#define C2FIFOUA0 C2FIFOUA0
extern volatile uint32_t   C2FIFOUA0 __attribute__((section("sfrs"), address(0xBF881370)));
extern volatile uint32_t        C2FIFOUA0CLR __attribute__((section("sfrs"),address(0xBF881374)));
extern volatile uint32_t        C2FIFOUA0SET __attribute__((section("sfrs"),address(0xBF881378)));
extern volatile uint32_t        C2FIFOUA0INV __attribute__((section("sfrs"),address(0xBF88137C)));
#define C2FIFOCI0 C2FIFOCI0
extern volatile uint32_t   C2FIFOCI0 __attribute__((section("sfrs"), address(0xBF881380)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI0bits_t;
extern volatile __C2FIFOCI0bits_t C2FIFOCI0bits __asm__ ("C2FIFOCI0") __attribute__((section("sfrs"), address(0xBF881380)));
extern volatile uint32_t        C2FIFOCI0CLR __attribute__((section("sfrs"),address(0xBF881384)));
extern volatile uint32_t        C2FIFOCI0SET __attribute__((section("sfrs"),address(0xBF881388)));
extern volatile uint32_t        C2FIFOCI0INV __attribute__((section("sfrs"),address(0xBF88138C)));
#define C2FIFOCON1 C2FIFOCON1
extern volatile uint32_t   C2FIFOCON1 __attribute__((section("sfrs"), address(0xBF881390)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON1bits_t;
extern volatile __C2FIFOCON1bits_t C2FIFOCON1bits __asm__ ("C2FIFOCON1") __attribute__((section("sfrs"), address(0xBF881390)));
extern volatile uint32_t        C2FIFOCON1CLR __attribute__((section("sfrs"),address(0xBF881394)));
extern volatile uint32_t        C2FIFOCON1SET __attribute__((section("sfrs"),address(0xBF881398)));
extern volatile uint32_t        C2FIFOCON1INV __attribute__((section("sfrs"),address(0xBF88139C)));
#define C2FIFOINT1 C2FIFOINT1
extern volatile uint32_t   C2FIFOINT1 __attribute__((section("sfrs"), address(0xBF8813A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT1bits_t;
extern volatile __C2FIFOINT1bits_t C2FIFOINT1bits __asm__ ("C2FIFOINT1") __attribute__((section("sfrs"), address(0xBF8813A0)));
extern volatile uint32_t        C2FIFOINT1CLR __attribute__((section("sfrs"),address(0xBF8813A4)));
extern volatile uint32_t        C2FIFOINT1SET __attribute__((section("sfrs"),address(0xBF8813A8)));
extern volatile uint32_t        C2FIFOINT1INV __attribute__((section("sfrs"),address(0xBF8813AC)));
#define C2FIFOUA1 C2FIFOUA1
extern volatile uint32_t   C2FIFOUA1 __attribute__((section("sfrs"), address(0xBF8813B0)));
extern volatile uint32_t        C2FIFOUA1CLR __attribute__((section("sfrs"),address(0xBF8813B4)));
extern volatile uint32_t        C2FIFOUA1SET __attribute__((section("sfrs"),address(0xBF8813B8)));
extern volatile uint32_t        C2FIFOUA1INV __attribute__((section("sfrs"),address(0xBF8813BC)));
#define C2FIFOCI1 C2FIFOCI1
extern volatile uint32_t   C2FIFOCI1 __attribute__((section("sfrs"), address(0xBF8813C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI1bits_t;
extern volatile __C2FIFOCI1bits_t C2FIFOCI1bits __asm__ ("C2FIFOCI1") __attribute__((section("sfrs"), address(0xBF8813C0)));
extern volatile uint32_t        C2FIFOCI1CLR __attribute__((section("sfrs"),address(0xBF8813C4)));
extern volatile uint32_t        C2FIFOCI1SET __attribute__((section("sfrs"),address(0xBF8813C8)));
extern volatile uint32_t        C2FIFOCI1INV __attribute__((section("sfrs"),address(0xBF8813CC)));
#define C2FIFOCON2 C2FIFOCON2
extern volatile uint32_t   C2FIFOCON2 __attribute__((section("sfrs"), address(0xBF8813D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON2bits_t;
extern volatile __C2FIFOCON2bits_t C2FIFOCON2bits __asm__ ("C2FIFOCON2") __attribute__((section("sfrs"), address(0xBF8813D0)));
extern volatile uint32_t        C2FIFOCON2CLR __attribute__((section("sfrs"),address(0xBF8813D4)));
extern volatile uint32_t        C2FIFOCON2SET __attribute__((section("sfrs"),address(0xBF8813D8)));
extern volatile uint32_t        C2FIFOCON2INV __attribute__((section("sfrs"),address(0xBF8813DC)));
#define C2FIFOINT2 C2FIFOINT2
extern volatile uint32_t   C2FIFOINT2 __attribute__((section("sfrs"), address(0xBF8813E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT2bits_t;
extern volatile __C2FIFOINT2bits_t C2FIFOINT2bits __asm__ ("C2FIFOINT2") __attribute__((section("sfrs"), address(0xBF8813E0)));
extern volatile uint32_t        C2FIFOINT2CLR __attribute__((section("sfrs"),address(0xBF8813E4)));
extern volatile uint32_t        C2FIFOINT2SET __attribute__((section("sfrs"),address(0xBF8813E8)));
extern volatile uint32_t        C2FIFOINT2INV __attribute__((section("sfrs"),address(0xBF8813EC)));
#define C2FIFOUA2 C2FIFOUA2
extern volatile uint32_t   C2FIFOUA2 __attribute__((section("sfrs"), address(0xBF8813F0)));
extern volatile uint32_t        C2FIFOUA2CLR __attribute__((section("sfrs"),address(0xBF8813F4)));
extern volatile uint32_t        C2FIFOUA2SET __attribute__((section("sfrs"),address(0xBF8813F8)));
extern volatile uint32_t        C2FIFOUA2INV __attribute__((section("sfrs"),address(0xBF8813FC)));
#define C2FIFOCI2 C2FIFOCI2
extern volatile uint32_t   C2FIFOCI2 __attribute__((section("sfrs"), address(0xBF881400)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI2bits_t;
extern volatile __C2FIFOCI2bits_t C2FIFOCI2bits __asm__ ("C2FIFOCI2") __attribute__((section("sfrs"), address(0xBF881400)));
extern volatile uint32_t        C2FIFOCI2CLR __attribute__((section("sfrs"),address(0xBF881404)));
extern volatile uint32_t        C2FIFOCI2SET __attribute__((section("sfrs"),address(0xBF881408)));
extern volatile uint32_t        C2FIFOCI2INV __attribute__((section("sfrs"),address(0xBF88140C)));
#define C2FIFOCON3 C2FIFOCON3
extern volatile uint32_t   C2FIFOCON3 __attribute__((section("sfrs"), address(0xBF881410)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON3bits_t;
extern volatile __C2FIFOCON3bits_t C2FIFOCON3bits __asm__ ("C2FIFOCON3") __attribute__((section("sfrs"), address(0xBF881410)));
extern volatile uint32_t        C2FIFOCON3CLR __attribute__((section("sfrs"),address(0xBF881414)));
extern volatile uint32_t        C2FIFOCON3SET __attribute__((section("sfrs"),address(0xBF881418)));
extern volatile uint32_t        C2FIFOCON3INV __attribute__((section("sfrs"),address(0xBF88141C)));
#define C2FIFOINT3 C2FIFOINT3
extern volatile uint32_t   C2FIFOINT3 __attribute__((section("sfrs"), address(0xBF881420)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT3bits_t;
extern volatile __C2FIFOINT3bits_t C2FIFOINT3bits __asm__ ("C2FIFOINT3") __attribute__((section("sfrs"), address(0xBF881420)));
extern volatile uint32_t        C2FIFOINT3CLR __attribute__((section("sfrs"),address(0xBF881424)));
extern volatile uint32_t        C2FIFOINT3SET __attribute__((section("sfrs"),address(0xBF881428)));
extern volatile uint32_t        C2FIFOINT3INV __attribute__((section("sfrs"),address(0xBF88142C)));
#define C2FIFOUA3 C2FIFOUA3
extern volatile uint32_t   C2FIFOUA3 __attribute__((section("sfrs"), address(0xBF881430)));
extern volatile uint32_t        C2FIFOUA3CLR __attribute__((section("sfrs"),address(0xBF881434)));
extern volatile uint32_t        C2FIFOUA3SET __attribute__((section("sfrs"),address(0xBF881438)));
extern volatile uint32_t        C2FIFOUA3INV __attribute__((section("sfrs"),address(0xBF88143C)));
#define C2FIFOCI3 C2FIFOCI3
extern volatile uint32_t   C2FIFOCI3 __attribute__((section("sfrs"), address(0xBF881440)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI3bits_t;
extern volatile __C2FIFOCI3bits_t C2FIFOCI3bits __asm__ ("C2FIFOCI3") __attribute__((section("sfrs"), address(0xBF881440)));
extern volatile uint32_t        C2FIFOCI3CLR __attribute__((section("sfrs"),address(0xBF881444)));
extern volatile uint32_t        C2FIFOCI3SET __attribute__((section("sfrs"),address(0xBF881448)));
extern volatile uint32_t        C2FIFOCI3INV __attribute__((section("sfrs"),address(0xBF88144C)));
#define C2FIFOCON4 C2FIFOCON4
extern volatile uint32_t   C2FIFOCON4 __attribute__((section("sfrs"), address(0xBF881450)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON4bits_t;
extern volatile __C2FIFOCON4bits_t C2FIFOCON4bits __asm__ ("C2FIFOCON4") __attribute__((section("sfrs"), address(0xBF881450)));
extern volatile uint32_t        C2FIFOCON4CLR __attribute__((section("sfrs"),address(0xBF881454)));
extern volatile uint32_t        C2FIFOCON4SET __attribute__((section("sfrs"),address(0xBF881458)));
extern volatile uint32_t        C2FIFOCON4INV __attribute__((section("sfrs"),address(0xBF88145C)));
#define C2FIFOINT4 C2FIFOINT4
extern volatile uint32_t   C2FIFOINT4 __attribute__((section("sfrs"), address(0xBF881460)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT4bits_t;
extern volatile __C2FIFOINT4bits_t C2FIFOINT4bits __asm__ ("C2FIFOINT4") __attribute__((section("sfrs"), address(0xBF881460)));
extern volatile uint32_t        C2FIFOINT4CLR __attribute__((section("sfrs"),address(0xBF881464)));
extern volatile uint32_t        C2FIFOINT4SET __attribute__((section("sfrs"),address(0xBF881468)));
extern volatile uint32_t        C2FIFOINT4INV __attribute__((section("sfrs"),address(0xBF88146C)));
#define C2FIFOUA4 C2FIFOUA4
extern volatile uint32_t   C2FIFOUA4 __attribute__((section("sfrs"), address(0xBF881470)));
extern volatile uint32_t        C2FIFOUA4CLR __attribute__((section("sfrs"),address(0xBF881474)));
extern volatile uint32_t        C2FIFOUA4SET __attribute__((section("sfrs"),address(0xBF881478)));
extern volatile uint32_t        C2FIFOUA4INV __attribute__((section("sfrs"),address(0xBF88147C)));
#define C2FIFOCI4 C2FIFOCI4
extern volatile uint32_t   C2FIFOCI4 __attribute__((section("sfrs"), address(0xBF881480)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI4bits_t;
extern volatile __C2FIFOCI4bits_t C2FIFOCI4bits __asm__ ("C2FIFOCI4") __attribute__((section("sfrs"), address(0xBF881480)));
extern volatile uint32_t        C2FIFOCI4CLR __attribute__((section("sfrs"),address(0xBF881484)));
extern volatile uint32_t        C2FIFOCI4SET __attribute__((section("sfrs"),address(0xBF881488)));
extern volatile uint32_t        C2FIFOCI4INV __attribute__((section("sfrs"),address(0xBF88148C)));
#define C2FIFOCON5 C2FIFOCON5
extern volatile uint32_t   C2FIFOCON5 __attribute__((section("sfrs"), address(0xBF881490)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON5bits_t;
extern volatile __C2FIFOCON5bits_t C2FIFOCON5bits __asm__ ("C2FIFOCON5") __attribute__((section("sfrs"), address(0xBF881490)));
extern volatile uint32_t        C2FIFOCON5CLR __attribute__((section("sfrs"),address(0xBF881494)));
extern volatile uint32_t        C2FIFOCON5SET __attribute__((section("sfrs"),address(0xBF881498)));
extern volatile uint32_t        C2FIFOCON5INV __attribute__((section("sfrs"),address(0xBF88149C)));
#define C2FIFOINT5 C2FIFOINT5
extern volatile uint32_t   C2FIFOINT5 __attribute__((section("sfrs"), address(0xBF8814A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT5bits_t;
extern volatile __C2FIFOINT5bits_t C2FIFOINT5bits __asm__ ("C2FIFOINT5") __attribute__((section("sfrs"), address(0xBF8814A0)));
extern volatile uint32_t        C2FIFOINT5CLR __attribute__((section("sfrs"),address(0xBF8814A4)));
extern volatile uint32_t        C2FIFOINT5SET __attribute__((section("sfrs"),address(0xBF8814A8)));
extern volatile uint32_t        C2FIFOINT5INV __attribute__((section("sfrs"),address(0xBF8814AC)));
#define C2FIFOUA5 C2FIFOUA5
extern volatile uint32_t   C2FIFOUA5 __attribute__((section("sfrs"), address(0xBF8814B0)));
extern volatile uint32_t        C2FIFOUA5CLR __attribute__((section("sfrs"),address(0xBF8814B4)));
extern volatile uint32_t        C2FIFOUA5SET __attribute__((section("sfrs"),address(0xBF8814B8)));
extern volatile uint32_t        C2FIFOUA5INV __attribute__((section("sfrs"),address(0xBF8814BC)));
#define C2FIFOCI5 C2FIFOCI5
extern volatile uint32_t   C2FIFOCI5 __attribute__((section("sfrs"), address(0xBF8814C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI5bits_t;
extern volatile __C2FIFOCI5bits_t C2FIFOCI5bits __asm__ ("C2FIFOCI5") __attribute__((section("sfrs"), address(0xBF8814C0)));
extern volatile uint32_t        C2FIFOCI5CLR __attribute__((section("sfrs"),address(0xBF8814C4)));
extern volatile uint32_t        C2FIFOCI5SET __attribute__((section("sfrs"),address(0xBF8814C8)));
extern volatile uint32_t        C2FIFOCI5INV __attribute__((section("sfrs"),address(0xBF8814CC)));
#define C2FIFOCON6 C2FIFOCON6
extern volatile uint32_t   C2FIFOCON6 __attribute__((section("sfrs"), address(0xBF8814D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON6bits_t;
extern volatile __C2FIFOCON6bits_t C2FIFOCON6bits __asm__ ("C2FIFOCON6") __attribute__((section("sfrs"), address(0xBF8814D0)));
extern volatile uint32_t        C2FIFOCON6CLR __attribute__((section("sfrs"),address(0xBF8814D4)));
extern volatile uint32_t        C2FIFOCON6SET __attribute__((section("sfrs"),address(0xBF8814D8)));
extern volatile uint32_t        C2FIFOCON6INV __attribute__((section("sfrs"),address(0xBF8814DC)));
#define C2FIFOINT6 C2FIFOINT6
extern volatile uint32_t   C2FIFOINT6 __attribute__((section("sfrs"), address(0xBF8814E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT6bits_t;
extern volatile __C2FIFOINT6bits_t C2FIFOINT6bits __asm__ ("C2FIFOINT6") __attribute__((section("sfrs"), address(0xBF8814E0)));
extern volatile uint32_t        C2FIFOINT6CLR __attribute__((section("sfrs"),address(0xBF8814E4)));
extern volatile uint32_t        C2FIFOINT6SET __attribute__((section("sfrs"),address(0xBF8814E8)));
extern volatile uint32_t        C2FIFOINT6INV __attribute__((section("sfrs"),address(0xBF8814EC)));
#define C2FIFOUA6 C2FIFOUA6
extern volatile uint32_t   C2FIFOUA6 __attribute__((section("sfrs"), address(0xBF8814F0)));
extern volatile uint32_t        C2FIFOUA6CLR __attribute__((section("sfrs"),address(0xBF8814F4)));
extern volatile uint32_t        C2FIFOUA6SET __attribute__((section("sfrs"),address(0xBF8814F8)));
extern volatile uint32_t        C2FIFOUA6INV __attribute__((section("sfrs"),address(0xBF8814FC)));
#define C2FIFOCI6 C2FIFOCI6
extern volatile uint32_t   C2FIFOCI6 __attribute__((section("sfrs"), address(0xBF881500)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI6bits_t;
extern volatile __C2FIFOCI6bits_t C2FIFOCI6bits __asm__ ("C2FIFOCI6") __attribute__((section("sfrs"), address(0xBF881500)));
extern volatile uint32_t        C2FIFOCI6CLR __attribute__((section("sfrs"),address(0xBF881504)));
extern volatile uint32_t        C2FIFOCI6SET __attribute__((section("sfrs"),address(0xBF881508)));
extern volatile uint32_t        C2FIFOCI6INV __attribute__((section("sfrs"),address(0xBF88150C)));
#define C2FIFOCON7 C2FIFOCON7
extern volatile uint32_t   C2FIFOCON7 __attribute__((section("sfrs"), address(0xBF881510)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON7bits_t;
extern volatile __C2FIFOCON7bits_t C2FIFOCON7bits __asm__ ("C2FIFOCON7") __attribute__((section("sfrs"), address(0xBF881510)));
extern volatile uint32_t        C2FIFOCON7CLR __attribute__((section("sfrs"),address(0xBF881514)));
extern volatile uint32_t        C2FIFOCON7SET __attribute__((section("sfrs"),address(0xBF881518)));
extern volatile uint32_t        C2FIFOCON7INV __attribute__((section("sfrs"),address(0xBF88151C)));
#define C2FIFOINT7 C2FIFOINT7
extern volatile uint32_t   C2FIFOINT7 __attribute__((section("sfrs"), address(0xBF881520)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT7bits_t;
extern volatile __C2FIFOINT7bits_t C2FIFOINT7bits __asm__ ("C2FIFOINT7") __attribute__((section("sfrs"), address(0xBF881520)));
extern volatile uint32_t        C2FIFOINT7CLR __attribute__((section("sfrs"),address(0xBF881524)));
extern volatile uint32_t        C2FIFOINT7SET __attribute__((section("sfrs"),address(0xBF881528)));
extern volatile uint32_t        C2FIFOINT7INV __attribute__((section("sfrs"),address(0xBF88152C)));
#define C2FIFOUA7 C2FIFOUA7
extern volatile uint32_t   C2FIFOUA7 __attribute__((section("sfrs"), address(0xBF881530)));
extern volatile uint32_t        C2FIFOUA7CLR __attribute__((section("sfrs"),address(0xBF881534)));
extern volatile uint32_t        C2FIFOUA7SET __attribute__((section("sfrs"),address(0xBF881538)));
extern volatile uint32_t        C2FIFOUA7INV __attribute__((section("sfrs"),address(0xBF88153C)));
#define C2FIFOCI7 C2FIFOCI7
extern volatile uint32_t   C2FIFOCI7 __attribute__((section("sfrs"), address(0xBF881540)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI7bits_t;
extern volatile __C2FIFOCI7bits_t C2FIFOCI7bits __asm__ ("C2FIFOCI7") __attribute__((section("sfrs"), address(0xBF881540)));
extern volatile uint32_t        C2FIFOCI7CLR __attribute__((section("sfrs"),address(0xBF881544)));
extern volatile uint32_t        C2FIFOCI7SET __attribute__((section("sfrs"),address(0xBF881548)));
extern volatile uint32_t        C2FIFOCI7INV __attribute__((section("sfrs"),address(0xBF88154C)));
#define C2FIFOCON8 C2FIFOCON8
extern volatile uint32_t   C2FIFOCON8 __attribute__((section("sfrs"), address(0xBF881550)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON8bits_t;
extern volatile __C2FIFOCON8bits_t C2FIFOCON8bits __asm__ ("C2FIFOCON8") __attribute__((section("sfrs"), address(0xBF881550)));
extern volatile uint32_t        C2FIFOCON8CLR __attribute__((section("sfrs"),address(0xBF881554)));
extern volatile uint32_t        C2FIFOCON8SET __attribute__((section("sfrs"),address(0xBF881558)));
extern volatile uint32_t        C2FIFOCON8INV __attribute__((section("sfrs"),address(0xBF88155C)));
#define C2FIFOINT8 C2FIFOINT8
extern volatile uint32_t   C2FIFOINT8 __attribute__((section("sfrs"), address(0xBF881560)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT8bits_t;
extern volatile __C2FIFOINT8bits_t C2FIFOINT8bits __asm__ ("C2FIFOINT8") __attribute__((section("sfrs"), address(0xBF881560)));
extern volatile uint32_t        C2FIFOINT8CLR __attribute__((section("sfrs"),address(0xBF881564)));
extern volatile uint32_t        C2FIFOINT8SET __attribute__((section("sfrs"),address(0xBF881568)));
extern volatile uint32_t        C2FIFOINT8INV __attribute__((section("sfrs"),address(0xBF88156C)));
#define C2FIFOUA8 C2FIFOUA8
extern volatile uint32_t   C2FIFOUA8 __attribute__((section("sfrs"), address(0xBF881570)));
extern volatile uint32_t        C2FIFOUA8CLR __attribute__((section("sfrs"),address(0xBF881574)));
extern volatile uint32_t        C2FIFOUA8SET __attribute__((section("sfrs"),address(0xBF881578)));
extern volatile uint32_t        C2FIFOUA8INV __attribute__((section("sfrs"),address(0xBF88157C)));
#define C2FIFOCI8 C2FIFOCI8
extern volatile uint32_t   C2FIFOCI8 __attribute__((section("sfrs"), address(0xBF881580)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI8bits_t;
extern volatile __C2FIFOCI8bits_t C2FIFOCI8bits __asm__ ("C2FIFOCI8") __attribute__((section("sfrs"), address(0xBF881580)));
extern volatile uint32_t        C2FIFOCI8CLR __attribute__((section("sfrs"),address(0xBF881584)));
extern volatile uint32_t        C2FIFOCI8SET __attribute__((section("sfrs"),address(0xBF881588)));
extern volatile uint32_t        C2FIFOCI8INV __attribute__((section("sfrs"),address(0xBF88158C)));
#define C2FIFOCON9 C2FIFOCON9
extern volatile uint32_t   C2FIFOCON9 __attribute__((section("sfrs"), address(0xBF881590)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON9bits_t;
extern volatile __C2FIFOCON9bits_t C2FIFOCON9bits __asm__ ("C2FIFOCON9") __attribute__((section("sfrs"), address(0xBF881590)));
extern volatile uint32_t        C2FIFOCON9CLR __attribute__((section("sfrs"),address(0xBF881594)));
extern volatile uint32_t        C2FIFOCON9SET __attribute__((section("sfrs"),address(0xBF881598)));
extern volatile uint32_t        C2FIFOCON9INV __attribute__((section("sfrs"),address(0xBF88159C)));
#define C2FIFOINT9 C2FIFOINT9
extern volatile uint32_t   C2FIFOINT9 __attribute__((section("sfrs"), address(0xBF8815A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT9bits_t;
extern volatile __C2FIFOINT9bits_t C2FIFOINT9bits __asm__ ("C2FIFOINT9") __attribute__((section("sfrs"), address(0xBF8815A0)));
extern volatile uint32_t        C2FIFOINT9CLR __attribute__((section("sfrs"),address(0xBF8815A4)));
extern volatile uint32_t        C2FIFOINT9SET __attribute__((section("sfrs"),address(0xBF8815A8)));
extern volatile uint32_t        C2FIFOINT9INV __attribute__((section("sfrs"),address(0xBF8815AC)));
#define C2FIFOUA9 C2FIFOUA9
extern volatile uint32_t   C2FIFOUA9 __attribute__((section("sfrs"), address(0xBF8815B0)));
extern volatile uint32_t        C2FIFOUA9CLR __attribute__((section("sfrs"),address(0xBF8815B4)));
extern volatile uint32_t        C2FIFOUA9SET __attribute__((section("sfrs"),address(0xBF8815B8)));
extern volatile uint32_t        C2FIFOUA9INV __attribute__((section("sfrs"),address(0xBF8815BC)));
#define C2FIFOCI9 C2FIFOCI9
extern volatile uint32_t   C2FIFOCI9 __attribute__((section("sfrs"), address(0xBF8815C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI9bits_t;
extern volatile __C2FIFOCI9bits_t C2FIFOCI9bits __asm__ ("C2FIFOCI9") __attribute__((section("sfrs"), address(0xBF8815C0)));
extern volatile uint32_t        C2FIFOCI9CLR __attribute__((section("sfrs"),address(0xBF8815C4)));
extern volatile uint32_t        C2FIFOCI9SET __attribute__((section("sfrs"),address(0xBF8815C8)));
extern volatile uint32_t        C2FIFOCI9INV __attribute__((section("sfrs"),address(0xBF8815CC)));
#define C2FIFOCON10 C2FIFOCON10
extern volatile uint32_t   C2FIFOCON10 __attribute__((section("sfrs"), address(0xBF8815D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON10bits_t;
extern volatile __C2FIFOCON10bits_t C2FIFOCON10bits __asm__ ("C2FIFOCON10") __attribute__((section("sfrs"), address(0xBF8815D0)));
extern volatile uint32_t        C2FIFOCON10CLR __attribute__((section("sfrs"),address(0xBF8815D4)));
extern volatile uint32_t        C2FIFOCON10SET __attribute__((section("sfrs"),address(0xBF8815D8)));
extern volatile uint32_t        C2FIFOCON10INV __attribute__((section("sfrs"),address(0xBF8815DC)));
#define C2FIFOINT10 C2FIFOINT10
extern volatile uint32_t   C2FIFOINT10 __attribute__((section("sfrs"), address(0xBF8815E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT10bits_t;
extern volatile __C2FIFOINT10bits_t C2FIFOINT10bits __asm__ ("C2FIFOINT10") __attribute__((section("sfrs"), address(0xBF8815E0)));
extern volatile uint32_t        C2FIFOINT10CLR __attribute__((section("sfrs"),address(0xBF8815E4)));
extern volatile uint32_t        C2FIFOINT10SET __attribute__((section("sfrs"),address(0xBF8815E8)));
extern volatile uint32_t        C2FIFOINT10INV __attribute__((section("sfrs"),address(0xBF8815EC)));
#define C2FIFOUA10 C2FIFOUA10
extern volatile uint32_t   C2FIFOUA10 __attribute__((section("sfrs"), address(0xBF8815F0)));
extern volatile uint32_t        C2FIFOUA10CLR __attribute__((section("sfrs"),address(0xBF8815F4)));
extern volatile uint32_t        C2FIFOUA10SET __attribute__((section("sfrs"),address(0xBF8815F8)));
extern volatile uint32_t        C2FIFOUA10INV __attribute__((section("sfrs"),address(0xBF8815FC)));
#define C2FIFOCI10 C2FIFOCI10
extern volatile uint32_t   C2FIFOCI10 __attribute__((section("sfrs"), address(0xBF881600)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI10bits_t;
extern volatile __C2FIFOCI10bits_t C2FIFOCI10bits __asm__ ("C2FIFOCI10") __attribute__((section("sfrs"), address(0xBF881600)));
extern volatile uint32_t        C2FIFOCI10CLR __attribute__((section("sfrs"),address(0xBF881604)));
extern volatile uint32_t        C2FIFOCI10SET __attribute__((section("sfrs"),address(0xBF881608)));
extern volatile uint32_t        C2FIFOCI10INV __attribute__((section("sfrs"),address(0xBF88160C)));
#define C2FIFOCON11 C2FIFOCON11
extern volatile uint32_t   C2FIFOCON11 __attribute__((section("sfrs"), address(0xBF881610)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON11bits_t;
extern volatile __C2FIFOCON11bits_t C2FIFOCON11bits __asm__ ("C2FIFOCON11") __attribute__((section("sfrs"), address(0xBF881610)));
extern volatile uint32_t        C2FIFOCON11CLR __attribute__((section("sfrs"),address(0xBF881614)));
extern volatile uint32_t        C2FIFOCON11SET __attribute__((section("sfrs"),address(0xBF881618)));
extern volatile uint32_t        C2FIFOCON11INV __attribute__((section("sfrs"),address(0xBF88161C)));
#define C2FIFOINT11 C2FIFOINT11
extern volatile uint32_t   C2FIFOINT11 __attribute__((section("sfrs"), address(0xBF881620)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT11bits_t;
extern volatile __C2FIFOINT11bits_t C2FIFOINT11bits __asm__ ("C2FIFOINT11") __attribute__((section("sfrs"), address(0xBF881620)));
extern volatile uint32_t        C2FIFOINT11CLR __attribute__((section("sfrs"),address(0xBF881624)));
extern volatile uint32_t        C2FIFOINT11SET __attribute__((section("sfrs"),address(0xBF881628)));
extern volatile uint32_t        C2FIFOINT11INV __attribute__((section("sfrs"),address(0xBF88162C)));
#define C2FIFOUA11 C2FIFOUA11
extern volatile uint32_t   C2FIFOUA11 __attribute__((section("sfrs"), address(0xBF881630)));
extern volatile uint32_t        C2FIFOUA11CLR __attribute__((section("sfrs"),address(0xBF881634)));
extern volatile uint32_t        C2FIFOUA11SET __attribute__((section("sfrs"),address(0xBF881638)));
extern volatile uint32_t        C2FIFOUA11INV __attribute__((section("sfrs"),address(0xBF88163C)));
#define C2FIFOCI11 C2FIFOCI11
extern volatile uint32_t   C2FIFOCI11 __attribute__((section("sfrs"), address(0xBF881640)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI11bits_t;
extern volatile __C2FIFOCI11bits_t C2FIFOCI11bits __asm__ ("C2FIFOCI11") __attribute__((section("sfrs"), address(0xBF881640)));
extern volatile uint32_t        C2FIFOCI11CLR __attribute__((section("sfrs"),address(0xBF881644)));
extern volatile uint32_t        C2FIFOCI11SET __attribute__((section("sfrs"),address(0xBF881648)));
extern volatile uint32_t        C2FIFOCI11INV __attribute__((section("sfrs"),address(0xBF88164C)));
#define C2FIFOCON12 C2FIFOCON12
extern volatile uint32_t   C2FIFOCON12 __attribute__((section("sfrs"), address(0xBF881650)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON12bits_t;
extern volatile __C2FIFOCON12bits_t C2FIFOCON12bits __asm__ ("C2FIFOCON12") __attribute__((section("sfrs"), address(0xBF881650)));
extern volatile uint32_t        C2FIFOCON12CLR __attribute__((section("sfrs"),address(0xBF881654)));
extern volatile uint32_t        C2FIFOCON12SET __attribute__((section("sfrs"),address(0xBF881658)));
extern volatile uint32_t        C2FIFOCON12INV __attribute__((section("sfrs"),address(0xBF88165C)));
#define C2FIFOINT12 C2FIFOINT12
extern volatile uint32_t   C2FIFOINT12 __attribute__((section("sfrs"), address(0xBF881660)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT12bits_t;
extern volatile __C2FIFOINT12bits_t C2FIFOINT12bits __asm__ ("C2FIFOINT12") __attribute__((section("sfrs"), address(0xBF881660)));
extern volatile uint32_t        C2FIFOINT12CLR __attribute__((section("sfrs"),address(0xBF881664)));
extern volatile uint32_t        C2FIFOINT12SET __attribute__((section("sfrs"),address(0xBF881668)));
extern volatile uint32_t        C2FIFOINT12INV __attribute__((section("sfrs"),address(0xBF88166C)));
#define C2FIFOUA12 C2FIFOUA12
extern volatile uint32_t   C2FIFOUA12 __attribute__((section("sfrs"), address(0xBF881670)));
extern volatile uint32_t        C2FIFOUA12CLR __attribute__((section("sfrs"),address(0xBF881674)));
extern volatile uint32_t        C2FIFOUA12SET __attribute__((section("sfrs"),address(0xBF881678)));
extern volatile uint32_t        C2FIFOUA12INV __attribute__((section("sfrs"),address(0xBF88167C)));
#define C2FIFOCI12 C2FIFOCI12
extern volatile uint32_t   C2FIFOCI12 __attribute__((section("sfrs"), address(0xBF881680)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI12bits_t;
extern volatile __C2FIFOCI12bits_t C2FIFOCI12bits __asm__ ("C2FIFOCI12") __attribute__((section("sfrs"), address(0xBF881680)));
extern volatile uint32_t        C2FIFOCI12CLR __attribute__((section("sfrs"),address(0xBF881684)));
extern volatile uint32_t        C2FIFOCI12SET __attribute__((section("sfrs"),address(0xBF881688)));
extern volatile uint32_t        C2FIFOCI12INV __attribute__((section("sfrs"),address(0xBF88168C)));
#define C2FIFOCON13 C2FIFOCON13
extern volatile uint32_t   C2FIFOCON13 __attribute__((section("sfrs"), address(0xBF881690)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON13bits_t;
extern volatile __C2FIFOCON13bits_t C2FIFOCON13bits __asm__ ("C2FIFOCON13") __attribute__((section("sfrs"), address(0xBF881690)));
extern volatile uint32_t        C2FIFOCON13CLR __attribute__((section("sfrs"),address(0xBF881694)));
extern volatile uint32_t        C2FIFOCON13SET __attribute__((section("sfrs"),address(0xBF881698)));
extern volatile uint32_t        C2FIFOCON13INV __attribute__((section("sfrs"),address(0xBF88169C)));
#define C2FIFOINT13 C2FIFOINT13
extern volatile uint32_t   C2FIFOINT13 __attribute__((section("sfrs"), address(0xBF8816A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT13bits_t;
extern volatile __C2FIFOINT13bits_t C2FIFOINT13bits __asm__ ("C2FIFOINT13") __attribute__((section("sfrs"), address(0xBF8816A0)));
extern volatile uint32_t        C2FIFOINT13CLR __attribute__((section("sfrs"),address(0xBF8816A4)));
extern volatile uint32_t        C2FIFOINT13SET __attribute__((section("sfrs"),address(0xBF8816A8)));
extern volatile uint32_t        C2FIFOINT13INV __attribute__((section("sfrs"),address(0xBF8816AC)));
#define C2FIFOUA13 C2FIFOUA13
extern volatile uint32_t   C2FIFOUA13 __attribute__((section("sfrs"), address(0xBF8816B0)));
extern volatile uint32_t        C2FIFOUA13CLR __attribute__((section("sfrs"),address(0xBF8816B4)));
extern volatile uint32_t        C2FIFOUA13SET __attribute__((section("sfrs"),address(0xBF8816B8)));
extern volatile uint32_t        C2FIFOUA13INV __attribute__((section("sfrs"),address(0xBF8816BC)));
#define C2FIFOCI13 C2FIFOCI13
extern volatile uint32_t   C2FIFOCI13 __attribute__((section("sfrs"), address(0xBF8816C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI13bits_t;
extern volatile __C2FIFOCI13bits_t C2FIFOCI13bits __asm__ ("C2FIFOCI13") __attribute__((section("sfrs"), address(0xBF8816C0)));
extern volatile uint32_t        C2FIFOCI13CLR __attribute__((section("sfrs"),address(0xBF8816C4)));
extern volatile uint32_t        C2FIFOCI13SET __attribute__((section("sfrs"),address(0xBF8816C8)));
extern volatile uint32_t        C2FIFOCI13INV __attribute__((section("sfrs"),address(0xBF8816CC)));
#define C2FIFOCON14 C2FIFOCON14
extern volatile uint32_t   C2FIFOCON14 __attribute__((section("sfrs"), address(0xBF8816D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON14bits_t;
extern volatile __C2FIFOCON14bits_t C2FIFOCON14bits __asm__ ("C2FIFOCON14") __attribute__((section("sfrs"), address(0xBF8816D0)));
extern volatile uint32_t        C2FIFOCON14CLR __attribute__((section("sfrs"),address(0xBF8816D4)));
extern volatile uint32_t        C2FIFOCON14SET __attribute__((section("sfrs"),address(0xBF8816D8)));
extern volatile uint32_t        C2FIFOCON14INV __attribute__((section("sfrs"),address(0xBF8816DC)));
#define C2FIFOINT14 C2FIFOINT14
extern volatile uint32_t   C2FIFOINT14 __attribute__((section("sfrs"), address(0xBF8816E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT14bits_t;
extern volatile __C2FIFOINT14bits_t C2FIFOINT14bits __asm__ ("C2FIFOINT14") __attribute__((section("sfrs"), address(0xBF8816E0)));
extern volatile uint32_t        C2FIFOINT14CLR __attribute__((section("sfrs"),address(0xBF8816E4)));
extern volatile uint32_t        C2FIFOINT14SET __attribute__((section("sfrs"),address(0xBF8816E8)));
extern volatile uint32_t        C2FIFOINT14INV __attribute__((section("sfrs"),address(0xBF8816EC)));
#define C2FIFOUA14 C2FIFOUA14
extern volatile uint32_t   C2FIFOUA14 __attribute__((section("sfrs"), address(0xBF8816F0)));
extern volatile uint32_t        C2FIFOUA14CLR __attribute__((section("sfrs"),address(0xBF8816F4)));
extern volatile uint32_t        C2FIFOUA14SET __attribute__((section("sfrs"),address(0xBF8816F8)));
extern volatile uint32_t        C2FIFOUA14INV __attribute__((section("sfrs"),address(0xBF8816FC)));
#define C2FIFOCI14 C2FIFOCI14
extern volatile uint32_t   C2FIFOCI14 __attribute__((section("sfrs"), address(0xBF881700)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI14bits_t;
extern volatile __C2FIFOCI14bits_t C2FIFOCI14bits __asm__ ("C2FIFOCI14") __attribute__((section("sfrs"), address(0xBF881700)));
extern volatile uint32_t        C2FIFOCI14CLR __attribute__((section("sfrs"),address(0xBF881704)));
extern volatile uint32_t        C2FIFOCI14SET __attribute__((section("sfrs"),address(0xBF881708)));
extern volatile uint32_t        C2FIFOCI14INV __attribute__((section("sfrs"),address(0xBF88170C)));
#define C2FIFOCON15 C2FIFOCON15
extern volatile uint32_t   C2FIFOCON15 __attribute__((section("sfrs"), address(0xBF881710)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON15bits_t;
extern volatile __C2FIFOCON15bits_t C2FIFOCON15bits __asm__ ("C2FIFOCON15") __attribute__((section("sfrs"), address(0xBF881710)));
extern volatile uint32_t        C2FIFOCON15CLR __attribute__((section("sfrs"),address(0xBF881714)));
extern volatile uint32_t        C2FIFOCON15SET __attribute__((section("sfrs"),address(0xBF881718)));
extern volatile uint32_t        C2FIFOCON15INV __attribute__((section("sfrs"),address(0xBF88171C)));
#define C2FIFOINT15 C2FIFOINT15
extern volatile uint32_t   C2FIFOINT15 __attribute__((section("sfrs"), address(0xBF881720)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT15bits_t;
extern volatile __C2FIFOINT15bits_t C2FIFOINT15bits __asm__ ("C2FIFOINT15") __attribute__((section("sfrs"), address(0xBF881720)));
extern volatile uint32_t        C2FIFOINT15CLR __attribute__((section("sfrs"),address(0xBF881724)));
extern volatile uint32_t        C2FIFOINT15SET __attribute__((section("sfrs"),address(0xBF881728)));
extern volatile uint32_t        C2FIFOINT15INV __attribute__((section("sfrs"),address(0xBF88172C)));
#define C2FIFOUA15 C2FIFOUA15
extern volatile uint32_t   C2FIFOUA15 __attribute__((section("sfrs"), address(0xBF881730)));
extern volatile uint32_t        C2FIFOUA15CLR __attribute__((section("sfrs"),address(0xBF881734)));
extern volatile uint32_t        C2FIFOUA15SET __attribute__((section("sfrs"),address(0xBF881738)));
extern volatile uint32_t        C2FIFOUA15INV __attribute__((section("sfrs"),address(0xBF88173C)));
#define C2FIFOCI15 C2FIFOCI15
extern volatile uint32_t   C2FIFOCI15 __attribute__((section("sfrs"), address(0xBF881740)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI15bits_t;
extern volatile __C2FIFOCI15bits_t C2FIFOCI15bits __asm__ ("C2FIFOCI15") __attribute__((section("sfrs"), address(0xBF881740)));
extern volatile uint32_t        C2FIFOCI15CLR __attribute__((section("sfrs"),address(0xBF881744)));
extern volatile uint32_t        C2FIFOCI15SET __attribute__((section("sfrs"),address(0xBF881748)));
extern volatile uint32_t        C2FIFOCI15INV __attribute__((section("sfrs"),address(0xBF88174C)));
#define C2FIFOCON16 C2FIFOCON16
extern volatile uint32_t   C2FIFOCON16 __attribute__((section("sfrs"), address(0xBF881750)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON16bits_t;
extern volatile __C2FIFOCON16bits_t C2FIFOCON16bits __asm__ ("C2FIFOCON16") __attribute__((section("sfrs"), address(0xBF881750)));
extern volatile uint32_t        C2FIFOCON16CLR __attribute__((section("sfrs"),address(0xBF881754)));
extern volatile uint32_t        C2FIFOCON16SET __attribute__((section("sfrs"),address(0xBF881758)));
extern volatile uint32_t        C2FIFOCON16INV __attribute__((section("sfrs"),address(0xBF88175C)));
#define C2FIFOINT16 C2FIFOINT16
extern volatile uint32_t   C2FIFOINT16 __attribute__((section("sfrs"), address(0xBF881760)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT16bits_t;
extern volatile __C2FIFOINT16bits_t C2FIFOINT16bits __asm__ ("C2FIFOINT16") __attribute__((section("sfrs"), address(0xBF881760)));
extern volatile uint32_t        C2FIFOINT16CLR __attribute__((section("sfrs"),address(0xBF881764)));
extern volatile uint32_t        C2FIFOINT16SET __attribute__((section("sfrs"),address(0xBF881768)));
extern volatile uint32_t        C2FIFOINT16INV __attribute__((section("sfrs"),address(0xBF88176C)));
#define C2FIFOUA16 C2FIFOUA16
extern volatile uint32_t   C2FIFOUA16 __attribute__((section("sfrs"), address(0xBF881770)));
extern volatile uint32_t        C2FIFOUA16CLR __attribute__((section("sfrs"),address(0xBF881774)));
extern volatile uint32_t        C2FIFOUA16SET __attribute__((section("sfrs"),address(0xBF881778)));
extern volatile uint32_t        C2FIFOUA16INV __attribute__((section("sfrs"),address(0xBF88177C)));
#define C2FIFOCI16 C2FIFOCI16
extern volatile uint32_t   C2FIFOCI16 __attribute__((section("sfrs"), address(0xBF881780)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI16bits_t;
extern volatile __C2FIFOCI16bits_t C2FIFOCI16bits __asm__ ("C2FIFOCI16") __attribute__((section("sfrs"), address(0xBF881780)));
extern volatile uint32_t        C2FIFOCI16CLR __attribute__((section("sfrs"),address(0xBF881784)));
extern volatile uint32_t        C2FIFOCI16SET __attribute__((section("sfrs"),address(0xBF881788)));
extern volatile uint32_t        C2FIFOCI16INV __attribute__((section("sfrs"),address(0xBF88178C)));
#define C2FIFOCON17 C2FIFOCON17
extern volatile uint32_t   C2FIFOCON17 __attribute__((section("sfrs"), address(0xBF881790)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON17bits_t;
extern volatile __C2FIFOCON17bits_t C2FIFOCON17bits __asm__ ("C2FIFOCON17") __attribute__((section("sfrs"), address(0xBF881790)));
extern volatile uint32_t        C2FIFOCON17CLR __attribute__((section("sfrs"),address(0xBF881794)));
extern volatile uint32_t        C2FIFOCON17SET __attribute__((section("sfrs"),address(0xBF881798)));
extern volatile uint32_t        C2FIFOCON17INV __attribute__((section("sfrs"),address(0xBF88179C)));
#define C2FIFOINT17 C2FIFOINT17
extern volatile uint32_t   C2FIFOINT17 __attribute__((section("sfrs"), address(0xBF8817A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT17bits_t;
extern volatile __C2FIFOINT17bits_t C2FIFOINT17bits __asm__ ("C2FIFOINT17") __attribute__((section("sfrs"), address(0xBF8817A0)));
extern volatile uint32_t        C2FIFOINT17CLR __attribute__((section("sfrs"),address(0xBF8817A4)));
extern volatile uint32_t        C2FIFOINT17SET __attribute__((section("sfrs"),address(0xBF8817A8)));
extern volatile uint32_t        C2FIFOINT17INV __attribute__((section("sfrs"),address(0xBF8817AC)));
#define C2FIFOUA17 C2FIFOUA17
extern volatile uint32_t   C2FIFOUA17 __attribute__((section("sfrs"), address(0xBF8817B0)));
extern volatile uint32_t        C2FIFOUA17CLR __attribute__((section("sfrs"),address(0xBF8817B4)));
extern volatile uint32_t        C2FIFOUA17SET __attribute__((section("sfrs"),address(0xBF8817B8)));
extern volatile uint32_t        C2FIFOUA17INV __attribute__((section("sfrs"),address(0xBF8817BC)));
#define C2FIFOCI17 C2FIFOCI17
extern volatile uint32_t   C2FIFOCI17 __attribute__((section("sfrs"), address(0xBF8817C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI17bits_t;
extern volatile __C2FIFOCI17bits_t C2FIFOCI17bits __asm__ ("C2FIFOCI17") __attribute__((section("sfrs"), address(0xBF8817C0)));
extern volatile uint32_t        C2FIFOCI17CLR __attribute__((section("sfrs"),address(0xBF8817C4)));
extern volatile uint32_t        C2FIFOCI17SET __attribute__((section("sfrs"),address(0xBF8817C8)));
extern volatile uint32_t        C2FIFOCI17INV __attribute__((section("sfrs"),address(0xBF8817CC)));
#define C2FIFOCON18 C2FIFOCON18
extern volatile uint32_t   C2FIFOCON18 __attribute__((section("sfrs"), address(0xBF8817D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON18bits_t;
extern volatile __C2FIFOCON18bits_t C2FIFOCON18bits __asm__ ("C2FIFOCON18") __attribute__((section("sfrs"), address(0xBF8817D0)));
extern volatile uint32_t        C2FIFOCON18CLR __attribute__((section("sfrs"),address(0xBF8817D4)));
extern volatile uint32_t        C2FIFOCON18SET __attribute__((section("sfrs"),address(0xBF8817D8)));
extern volatile uint32_t        C2FIFOCON18INV __attribute__((section("sfrs"),address(0xBF8817DC)));
#define C2FIFOINT18 C2FIFOINT18
extern volatile uint32_t   C2FIFOINT18 __attribute__((section("sfrs"), address(0xBF8817E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT18bits_t;
extern volatile __C2FIFOINT18bits_t C2FIFOINT18bits __asm__ ("C2FIFOINT18") __attribute__((section("sfrs"), address(0xBF8817E0)));
extern volatile uint32_t        C2FIFOINT18CLR __attribute__((section("sfrs"),address(0xBF8817E4)));
extern volatile uint32_t        C2FIFOINT18SET __attribute__((section("sfrs"),address(0xBF8817E8)));
extern volatile uint32_t        C2FIFOINT18INV __attribute__((section("sfrs"),address(0xBF8817EC)));
#define C2FIFOUA18 C2FIFOUA18
extern volatile uint32_t   C2FIFOUA18 __attribute__((section("sfrs"), address(0xBF8817F0)));
extern volatile uint32_t        C2FIFOUA18CLR __attribute__((section("sfrs"),address(0xBF8817F4)));
extern volatile uint32_t        C2FIFOUA18SET __attribute__((section("sfrs"),address(0xBF8817F8)));
extern volatile uint32_t        C2FIFOUA18INV __attribute__((section("sfrs"),address(0xBF8817FC)));
#define C2FIFOCI18 C2FIFOCI18
extern volatile uint32_t   C2FIFOCI18 __attribute__((section("sfrs"), address(0xBF881800)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI18bits_t;
extern volatile __C2FIFOCI18bits_t C2FIFOCI18bits __asm__ ("C2FIFOCI18") __attribute__((section("sfrs"), address(0xBF881800)));
extern volatile uint32_t        C2FIFOCI18CLR __attribute__((section("sfrs"),address(0xBF881804)));
extern volatile uint32_t        C2FIFOCI18SET __attribute__((section("sfrs"),address(0xBF881808)));
extern volatile uint32_t        C2FIFOCI18INV __attribute__((section("sfrs"),address(0xBF88180C)));
#define C2FIFOCON19 C2FIFOCON19
extern volatile uint32_t   C2FIFOCON19 __attribute__((section("sfrs"), address(0xBF881810)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON19bits_t;
extern volatile __C2FIFOCON19bits_t C2FIFOCON19bits __asm__ ("C2FIFOCON19") __attribute__((section("sfrs"), address(0xBF881810)));
extern volatile uint32_t        C2FIFOCON19CLR __attribute__((section("sfrs"),address(0xBF881814)));
extern volatile uint32_t        C2FIFOCON19SET __attribute__((section("sfrs"),address(0xBF881818)));
extern volatile uint32_t        C2FIFOCON19INV __attribute__((section("sfrs"),address(0xBF88181C)));
#define C2FIFOINT19 C2FIFOINT19
extern volatile uint32_t   C2FIFOINT19 __attribute__((section("sfrs"), address(0xBF881820)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT19bits_t;
extern volatile __C2FIFOINT19bits_t C2FIFOINT19bits __asm__ ("C2FIFOINT19") __attribute__((section("sfrs"), address(0xBF881820)));
extern volatile uint32_t        C2FIFOINT19CLR __attribute__((section("sfrs"),address(0xBF881824)));
extern volatile uint32_t        C2FIFOINT19SET __attribute__((section("sfrs"),address(0xBF881828)));
extern volatile uint32_t        C2FIFOINT19INV __attribute__((section("sfrs"),address(0xBF88182C)));
#define C2FIFOUA19 C2FIFOUA19
extern volatile uint32_t   C2FIFOUA19 __attribute__((section("sfrs"), address(0xBF881830)));
extern volatile uint32_t        C2FIFOUA19CLR __attribute__((section("sfrs"),address(0xBF881834)));
extern volatile uint32_t        C2FIFOUA19SET __attribute__((section("sfrs"),address(0xBF881838)));
extern volatile uint32_t        C2FIFOUA19INV __attribute__((section("sfrs"),address(0xBF88183C)));
#define C2FIFOCI19 C2FIFOCI19
extern volatile uint32_t   C2FIFOCI19 __attribute__((section("sfrs"), address(0xBF881840)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI19bits_t;
extern volatile __C2FIFOCI19bits_t C2FIFOCI19bits __asm__ ("C2FIFOCI19") __attribute__((section("sfrs"), address(0xBF881840)));
extern volatile uint32_t        C2FIFOCI19CLR __attribute__((section("sfrs"),address(0xBF881844)));
extern volatile uint32_t        C2FIFOCI19SET __attribute__((section("sfrs"),address(0xBF881848)));
extern volatile uint32_t        C2FIFOCI19INV __attribute__((section("sfrs"),address(0xBF88184C)));
#define C2FIFOCON20 C2FIFOCON20
extern volatile uint32_t   C2FIFOCON20 __attribute__((section("sfrs"), address(0xBF881850)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON20bits_t;
extern volatile __C2FIFOCON20bits_t C2FIFOCON20bits __asm__ ("C2FIFOCON20") __attribute__((section("sfrs"), address(0xBF881850)));
extern volatile uint32_t        C2FIFOCON20CLR __attribute__((section("sfrs"),address(0xBF881854)));
extern volatile uint32_t        C2FIFOCON20SET __attribute__((section("sfrs"),address(0xBF881858)));
extern volatile uint32_t        C2FIFOCON20INV __attribute__((section("sfrs"),address(0xBF88185C)));
#define C2FIFOINT20 C2FIFOINT20
extern volatile uint32_t   C2FIFOINT20 __attribute__((section("sfrs"), address(0xBF881860)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT20bits_t;
extern volatile __C2FIFOINT20bits_t C2FIFOINT20bits __asm__ ("C2FIFOINT20") __attribute__((section("sfrs"), address(0xBF881860)));
extern volatile uint32_t        C2FIFOINT20CLR __attribute__((section("sfrs"),address(0xBF881864)));
extern volatile uint32_t        C2FIFOINT20SET __attribute__((section("sfrs"),address(0xBF881868)));
extern volatile uint32_t        C2FIFOINT20INV __attribute__((section("sfrs"),address(0xBF88186C)));
#define C2FIFOUA20 C2FIFOUA20
extern volatile uint32_t   C2FIFOUA20 __attribute__((section("sfrs"), address(0xBF881870)));
extern volatile uint32_t        C2FIFOUA20CLR __attribute__((section("sfrs"),address(0xBF881874)));
extern volatile uint32_t        C2FIFOUA20SET __attribute__((section("sfrs"),address(0xBF881878)));
extern volatile uint32_t        C2FIFOUA20INV __attribute__((section("sfrs"),address(0xBF88187C)));
#define C2FIFOCI20 C2FIFOCI20
extern volatile uint32_t   C2FIFOCI20 __attribute__((section("sfrs"), address(0xBF881880)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI20bits_t;
extern volatile __C2FIFOCI20bits_t C2FIFOCI20bits __asm__ ("C2FIFOCI20") __attribute__((section("sfrs"), address(0xBF881880)));
extern volatile uint32_t        C2FIFOCI20CLR __attribute__((section("sfrs"),address(0xBF881884)));
extern volatile uint32_t        C2FIFOCI20SET __attribute__((section("sfrs"),address(0xBF881888)));
extern volatile uint32_t        C2FIFOCI20INV __attribute__((section("sfrs"),address(0xBF88188C)));
#define C2FIFOCON21 C2FIFOCON21
extern volatile uint32_t   C2FIFOCON21 __attribute__((section("sfrs"), address(0xBF881890)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON21bits_t;
extern volatile __C2FIFOCON21bits_t C2FIFOCON21bits __asm__ ("C2FIFOCON21") __attribute__((section("sfrs"), address(0xBF881890)));
extern volatile uint32_t        C2FIFOCON21CLR __attribute__((section("sfrs"),address(0xBF881894)));
extern volatile uint32_t        C2FIFOCON21SET __attribute__((section("sfrs"),address(0xBF881898)));
extern volatile uint32_t        C2FIFOCON21INV __attribute__((section("sfrs"),address(0xBF88189C)));
#define C2FIFOINT21 C2FIFOINT21
extern volatile uint32_t   C2FIFOINT21 __attribute__((section("sfrs"), address(0xBF8818A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT21bits_t;
extern volatile __C2FIFOINT21bits_t C2FIFOINT21bits __asm__ ("C2FIFOINT21") __attribute__((section("sfrs"), address(0xBF8818A0)));
extern volatile uint32_t        C2FIFOINT21CLR __attribute__((section("sfrs"),address(0xBF8818A4)));
extern volatile uint32_t        C2FIFOINT21SET __attribute__((section("sfrs"),address(0xBF8818A8)));
extern volatile uint32_t        C2FIFOINT21INV __attribute__((section("sfrs"),address(0xBF8818AC)));
#define C2FIFOUA21 C2FIFOUA21
extern volatile uint32_t   C2FIFOUA21 __attribute__((section("sfrs"), address(0xBF8818B0)));
extern volatile uint32_t        C2FIFOUA21CLR __attribute__((section("sfrs"),address(0xBF8818B4)));
extern volatile uint32_t        C2FIFOUA21SET __attribute__((section("sfrs"),address(0xBF8818B8)));
extern volatile uint32_t        C2FIFOUA21INV __attribute__((section("sfrs"),address(0xBF8818BC)));
#define C2FIFOCI21 C2FIFOCI21
extern volatile uint32_t   C2FIFOCI21 __attribute__((section("sfrs"), address(0xBF8818C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI21bits_t;
extern volatile __C2FIFOCI21bits_t C2FIFOCI21bits __asm__ ("C2FIFOCI21") __attribute__((section("sfrs"), address(0xBF8818C0)));
extern volatile uint32_t        C2FIFOCI21CLR __attribute__((section("sfrs"),address(0xBF8818C4)));
extern volatile uint32_t        C2FIFOCI21SET __attribute__((section("sfrs"),address(0xBF8818C8)));
extern volatile uint32_t        C2FIFOCI21INV __attribute__((section("sfrs"),address(0xBF8818CC)));
#define C2FIFOCON22 C2FIFOCON22
extern volatile uint32_t   C2FIFOCON22 __attribute__((section("sfrs"), address(0xBF8818D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON22bits_t;
extern volatile __C2FIFOCON22bits_t C2FIFOCON22bits __asm__ ("C2FIFOCON22") __attribute__((section("sfrs"), address(0xBF8818D0)));
extern volatile uint32_t        C2FIFOCON22CLR __attribute__((section("sfrs"),address(0xBF8818D4)));
extern volatile uint32_t        C2FIFOCON22SET __attribute__((section("sfrs"),address(0xBF8818D8)));
extern volatile uint32_t        C2FIFOCON22INV __attribute__((section("sfrs"),address(0xBF8818DC)));
#define C2FIFOINT22 C2FIFOINT22
extern volatile uint32_t   C2FIFOINT22 __attribute__((section("sfrs"), address(0xBF8818E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT22bits_t;
extern volatile __C2FIFOINT22bits_t C2FIFOINT22bits __asm__ ("C2FIFOINT22") __attribute__((section("sfrs"), address(0xBF8818E0)));
extern volatile uint32_t        C2FIFOINT22CLR __attribute__((section("sfrs"),address(0xBF8818E4)));
extern volatile uint32_t        C2FIFOINT22SET __attribute__((section("sfrs"),address(0xBF8818E8)));
extern volatile uint32_t        C2FIFOINT22INV __attribute__((section("sfrs"),address(0xBF8818EC)));
#define C2FIFOUA22 C2FIFOUA22
extern volatile uint32_t   C2FIFOUA22 __attribute__((section("sfrs"), address(0xBF8818F0)));
extern volatile uint32_t        C2FIFOUA22CLR __attribute__((section("sfrs"),address(0xBF8818F4)));
extern volatile uint32_t        C2FIFOUA22SET __attribute__((section("sfrs"),address(0xBF8818F8)));
extern volatile uint32_t        C2FIFOUA22INV __attribute__((section("sfrs"),address(0xBF8818FC)));
#define C2FIFOCI22 C2FIFOCI22
extern volatile uint32_t   C2FIFOCI22 __attribute__((section("sfrs"), address(0xBF881900)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI22bits_t;
extern volatile __C2FIFOCI22bits_t C2FIFOCI22bits __asm__ ("C2FIFOCI22") __attribute__((section("sfrs"), address(0xBF881900)));
extern volatile uint32_t        C2FIFOCI22CLR __attribute__((section("sfrs"),address(0xBF881904)));
extern volatile uint32_t        C2FIFOCI22SET __attribute__((section("sfrs"),address(0xBF881908)));
extern volatile uint32_t        C2FIFOCI22INV __attribute__((section("sfrs"),address(0xBF88190C)));
#define C2FIFOCON23 C2FIFOCON23
extern volatile uint32_t   C2FIFOCON23 __attribute__((section("sfrs"), address(0xBF881910)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON23bits_t;
extern volatile __C2FIFOCON23bits_t C2FIFOCON23bits __asm__ ("C2FIFOCON23") __attribute__((section("sfrs"), address(0xBF881910)));
extern volatile uint32_t        C2FIFOCON23CLR __attribute__((section("sfrs"),address(0xBF881914)));
extern volatile uint32_t        C2FIFOCON23SET __attribute__((section("sfrs"),address(0xBF881918)));
extern volatile uint32_t        C2FIFOCON23INV __attribute__((section("sfrs"),address(0xBF88191C)));
#define C2FIFOINT23 C2FIFOINT23
extern volatile uint32_t   C2FIFOINT23 __attribute__((section("sfrs"), address(0xBF881920)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT23bits_t;
extern volatile __C2FIFOINT23bits_t C2FIFOINT23bits __asm__ ("C2FIFOINT23") __attribute__((section("sfrs"), address(0xBF881920)));
extern volatile uint32_t        C2FIFOINT23CLR __attribute__((section("sfrs"),address(0xBF881924)));
extern volatile uint32_t        C2FIFOINT23SET __attribute__((section("sfrs"),address(0xBF881928)));
extern volatile uint32_t        C2FIFOINT23INV __attribute__((section("sfrs"),address(0xBF88192C)));
#define C2FIFOUA23 C2FIFOUA23
extern volatile uint32_t   C2FIFOUA23 __attribute__((section("sfrs"), address(0xBF881930)));
extern volatile uint32_t        C2FIFOUA23CLR __attribute__((section("sfrs"),address(0xBF881934)));
extern volatile uint32_t        C2FIFOUA23SET __attribute__((section("sfrs"),address(0xBF881938)));
extern volatile uint32_t        C2FIFOUA23INV __attribute__((section("sfrs"),address(0xBF88193C)));
#define C2FIFOCI23 C2FIFOCI23
extern volatile uint32_t   C2FIFOCI23 __attribute__((section("sfrs"), address(0xBF881940)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI23bits_t;
extern volatile __C2FIFOCI23bits_t C2FIFOCI23bits __asm__ ("C2FIFOCI23") __attribute__((section("sfrs"), address(0xBF881940)));
extern volatile uint32_t        C2FIFOCI23CLR __attribute__((section("sfrs"),address(0xBF881944)));
extern volatile uint32_t        C2FIFOCI23SET __attribute__((section("sfrs"),address(0xBF881948)));
extern volatile uint32_t        C2FIFOCI23INV __attribute__((section("sfrs"),address(0xBF88194C)));
#define C2FIFOCON24 C2FIFOCON24
extern volatile uint32_t   C2FIFOCON24 __attribute__((section("sfrs"), address(0xBF881950)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON24bits_t;
extern volatile __C2FIFOCON24bits_t C2FIFOCON24bits __asm__ ("C2FIFOCON24") __attribute__((section("sfrs"), address(0xBF881950)));
extern volatile uint32_t        C2FIFOCON24CLR __attribute__((section("sfrs"),address(0xBF881954)));
extern volatile uint32_t        C2FIFOCON24SET __attribute__((section("sfrs"),address(0xBF881958)));
extern volatile uint32_t        C2FIFOCON24INV __attribute__((section("sfrs"),address(0xBF88195C)));
#define C2FIFOINT24 C2FIFOINT24
extern volatile uint32_t   C2FIFOINT24 __attribute__((section("sfrs"), address(0xBF881960)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT24bits_t;
extern volatile __C2FIFOINT24bits_t C2FIFOINT24bits __asm__ ("C2FIFOINT24") __attribute__((section("sfrs"), address(0xBF881960)));
extern volatile uint32_t        C2FIFOINT24CLR __attribute__((section("sfrs"),address(0xBF881964)));
extern volatile uint32_t        C2FIFOINT24SET __attribute__((section("sfrs"),address(0xBF881968)));
extern volatile uint32_t        C2FIFOINT24INV __attribute__((section("sfrs"),address(0xBF88196C)));
#define C2FIFOUA24 C2FIFOUA24
extern volatile uint32_t   C2FIFOUA24 __attribute__((section("sfrs"), address(0xBF881970)));
extern volatile uint32_t        C2FIFOUA24CLR __attribute__((section("sfrs"),address(0xBF881974)));
extern volatile uint32_t        C2FIFOUA24SET __attribute__((section("sfrs"),address(0xBF881978)));
extern volatile uint32_t        C2FIFOUA24INV __attribute__((section("sfrs"),address(0xBF88197C)));
#define C2FIFOCI24 C2FIFOCI24
extern volatile uint32_t   C2FIFOCI24 __attribute__((section("sfrs"), address(0xBF881980)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI24bits_t;
extern volatile __C2FIFOCI24bits_t C2FIFOCI24bits __asm__ ("C2FIFOCI24") __attribute__((section("sfrs"), address(0xBF881980)));
extern volatile uint32_t        C2FIFOCI24CLR __attribute__((section("sfrs"),address(0xBF881984)));
extern volatile uint32_t        C2FIFOCI24SET __attribute__((section("sfrs"),address(0xBF881988)));
extern volatile uint32_t        C2FIFOCI24INV __attribute__((section("sfrs"),address(0xBF88198C)));
#define C2FIFOCON25 C2FIFOCON25
extern volatile uint32_t   C2FIFOCON25 __attribute__((section("sfrs"), address(0xBF881990)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON25bits_t;
extern volatile __C2FIFOCON25bits_t C2FIFOCON25bits __asm__ ("C2FIFOCON25") __attribute__((section("sfrs"), address(0xBF881990)));
extern volatile uint32_t        C2FIFOCON25CLR __attribute__((section("sfrs"),address(0xBF881994)));
extern volatile uint32_t        C2FIFOCON25SET __attribute__((section("sfrs"),address(0xBF881998)));
extern volatile uint32_t        C2FIFOCON25INV __attribute__((section("sfrs"),address(0xBF88199C)));
#define C2FIFOINT25 C2FIFOINT25
extern volatile uint32_t   C2FIFOINT25 __attribute__((section("sfrs"), address(0xBF8819A0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT25bits_t;
extern volatile __C2FIFOINT25bits_t C2FIFOINT25bits __asm__ ("C2FIFOINT25") __attribute__((section("sfrs"), address(0xBF8819A0)));
extern volatile uint32_t        C2FIFOINT25CLR __attribute__((section("sfrs"),address(0xBF8819A4)));
extern volatile uint32_t        C2FIFOINT25SET __attribute__((section("sfrs"),address(0xBF8819A8)));
extern volatile uint32_t        C2FIFOINT25INV __attribute__((section("sfrs"),address(0xBF8819AC)));
#define C2FIFOUA25 C2FIFOUA25
extern volatile uint32_t   C2FIFOUA25 __attribute__((section("sfrs"), address(0xBF8819B0)));
extern volatile uint32_t        C2FIFOUA25CLR __attribute__((section("sfrs"),address(0xBF8819B4)));
extern volatile uint32_t        C2FIFOUA25SET __attribute__((section("sfrs"),address(0xBF8819B8)));
extern volatile uint32_t        C2FIFOUA25INV __attribute__((section("sfrs"),address(0xBF8819BC)));
#define C2FIFOCI25 C2FIFOCI25
extern volatile uint32_t   C2FIFOCI25 __attribute__((section("sfrs"), address(0xBF8819C0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI25bits_t;
extern volatile __C2FIFOCI25bits_t C2FIFOCI25bits __asm__ ("C2FIFOCI25") __attribute__((section("sfrs"), address(0xBF8819C0)));
extern volatile uint32_t        C2FIFOCI25CLR __attribute__((section("sfrs"),address(0xBF8819C4)));
extern volatile uint32_t        C2FIFOCI25SET __attribute__((section("sfrs"),address(0xBF8819C8)));
extern volatile uint32_t        C2FIFOCI25INV __attribute__((section("sfrs"),address(0xBF8819CC)));
#define C2FIFOCON26 C2FIFOCON26
extern volatile uint32_t   C2FIFOCON26 __attribute__((section("sfrs"), address(0xBF8819D0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON26bits_t;
extern volatile __C2FIFOCON26bits_t C2FIFOCON26bits __asm__ ("C2FIFOCON26") __attribute__((section("sfrs"), address(0xBF8819D0)));
extern volatile uint32_t        C2FIFOCON26CLR __attribute__((section("sfrs"),address(0xBF8819D4)));
extern volatile uint32_t        C2FIFOCON26SET __attribute__((section("sfrs"),address(0xBF8819D8)));
extern volatile uint32_t        C2FIFOCON26INV __attribute__((section("sfrs"),address(0xBF8819DC)));
#define C2FIFOINT26 C2FIFOINT26
extern volatile uint32_t   C2FIFOINT26 __attribute__((section("sfrs"), address(0xBF8819E0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT26bits_t;
extern volatile __C2FIFOINT26bits_t C2FIFOINT26bits __asm__ ("C2FIFOINT26") __attribute__((section("sfrs"), address(0xBF8819E0)));
extern volatile uint32_t        C2FIFOINT26CLR __attribute__((section("sfrs"),address(0xBF8819E4)));
extern volatile uint32_t        C2FIFOINT26SET __attribute__((section("sfrs"),address(0xBF8819E8)));
extern volatile uint32_t        C2FIFOINT26INV __attribute__((section("sfrs"),address(0xBF8819EC)));
#define C2FIFOUA26 C2FIFOUA26
extern volatile uint32_t   C2FIFOUA26 __attribute__((section("sfrs"), address(0xBF8819F0)));
extern volatile uint32_t        C2FIFOUA26CLR __attribute__((section("sfrs"),address(0xBF8819F4)));
extern volatile uint32_t        C2FIFOUA26SET __attribute__((section("sfrs"),address(0xBF8819F8)));
extern volatile uint32_t        C2FIFOUA26INV __attribute__((section("sfrs"),address(0xBF8819FC)));
#define C2FIFOCI26 C2FIFOCI26
extern volatile uint32_t   C2FIFOCI26 __attribute__((section("sfrs"), address(0xBF881A00)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI26bits_t;
extern volatile __C2FIFOCI26bits_t C2FIFOCI26bits __asm__ ("C2FIFOCI26") __attribute__((section("sfrs"), address(0xBF881A00)));
extern volatile uint32_t        C2FIFOCI26CLR __attribute__((section("sfrs"),address(0xBF881A04)));
extern volatile uint32_t        C2FIFOCI26SET __attribute__((section("sfrs"),address(0xBF881A08)));
extern volatile uint32_t        C2FIFOCI26INV __attribute__((section("sfrs"),address(0xBF881A0C)));
#define C2FIFOCON27 C2FIFOCON27
extern volatile uint32_t   C2FIFOCON27 __attribute__((section("sfrs"), address(0xBF881A10)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON27bits_t;
extern volatile __C2FIFOCON27bits_t C2FIFOCON27bits __asm__ ("C2FIFOCON27") __attribute__((section("sfrs"), address(0xBF881A10)));
extern volatile uint32_t        C2FIFOCON27CLR __attribute__((section("sfrs"),address(0xBF881A14)));
extern volatile uint32_t        C2FIFOCON27SET __attribute__((section("sfrs"),address(0xBF881A18)));
extern volatile uint32_t        C2FIFOCON27INV __attribute__((section("sfrs"),address(0xBF881A1C)));
#define C2FIFOINT27 C2FIFOINT27
extern volatile uint32_t   C2FIFOINT27 __attribute__((section("sfrs"), address(0xBF881A20)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT27bits_t;
extern volatile __C2FIFOINT27bits_t C2FIFOINT27bits __asm__ ("C2FIFOINT27") __attribute__((section("sfrs"), address(0xBF881A20)));
extern volatile uint32_t        C2FIFOINT27CLR __attribute__((section("sfrs"),address(0xBF881A24)));
extern volatile uint32_t        C2FIFOINT27SET __attribute__((section("sfrs"),address(0xBF881A28)));
extern volatile uint32_t        C2FIFOINT27INV __attribute__((section("sfrs"),address(0xBF881A2C)));
#define C2FIFOUA27 C2FIFOUA27
extern volatile uint32_t   C2FIFOUA27 __attribute__((section("sfrs"), address(0xBF881A30)));
extern volatile uint32_t        C2FIFOUA27CLR __attribute__((section("sfrs"),address(0xBF881A34)));
extern volatile uint32_t        C2FIFOUA27SET __attribute__((section("sfrs"),address(0xBF881A38)));
extern volatile uint32_t        C2FIFOUA27INV __attribute__((section("sfrs"),address(0xBF881A3C)));
#define C2FIFOCI27 C2FIFOCI27
extern volatile uint32_t   C2FIFOCI27 __attribute__((section("sfrs"), address(0xBF881A40)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI27bits_t;
extern volatile __C2FIFOCI27bits_t C2FIFOCI27bits __asm__ ("C2FIFOCI27") __attribute__((section("sfrs"), address(0xBF881A40)));
extern volatile uint32_t        C2FIFOCI27CLR __attribute__((section("sfrs"),address(0xBF881A44)));
extern volatile uint32_t        C2FIFOCI27SET __attribute__((section("sfrs"),address(0xBF881A48)));
extern volatile uint32_t        C2FIFOCI27INV __attribute__((section("sfrs"),address(0xBF881A4C)));
#define C2FIFOCON28 C2FIFOCON28
extern volatile uint32_t   C2FIFOCON28 __attribute__((section("sfrs"), address(0xBF881A50)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON28bits_t;
extern volatile __C2FIFOCON28bits_t C2FIFOCON28bits __asm__ ("C2FIFOCON28") __attribute__((section("sfrs"), address(0xBF881A50)));
extern volatile uint32_t        C2FIFOCON28CLR __attribute__((section("sfrs"),address(0xBF881A54)));
extern volatile uint32_t        C2FIFOCON28SET __attribute__((section("sfrs"),address(0xBF881A58)));
extern volatile uint32_t        C2FIFOCON28INV __attribute__((section("sfrs"),address(0xBF881A5C)));
#define C2FIFOINT28 C2FIFOINT28
extern volatile uint32_t   C2FIFOINT28 __attribute__((section("sfrs"), address(0xBF881A60)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT28bits_t;
extern volatile __C2FIFOINT28bits_t C2FIFOINT28bits __asm__ ("C2FIFOINT28") __attribute__((section("sfrs"), address(0xBF881A60)));
extern volatile uint32_t        C2FIFOINT28CLR __attribute__((section("sfrs"),address(0xBF881A64)));
extern volatile uint32_t        C2FIFOINT28SET __attribute__((section("sfrs"),address(0xBF881A68)));
extern volatile uint32_t        C2FIFOINT28INV __attribute__((section("sfrs"),address(0xBF881A6C)));
#define C2FIFOUA28 C2FIFOUA28
extern volatile uint32_t   C2FIFOUA28 __attribute__((section("sfrs"), address(0xBF881A70)));
extern volatile uint32_t        C2FIFOUA28CLR __attribute__((section("sfrs"),address(0xBF881A74)));
extern volatile uint32_t        C2FIFOUA28SET __attribute__((section("sfrs"),address(0xBF881A78)));
extern volatile uint32_t        C2FIFOUA28INV __attribute__((section("sfrs"),address(0xBF881A7C)));
#define C2FIFOCI28 C2FIFOCI28
extern volatile uint32_t   C2FIFOCI28 __attribute__((section("sfrs"), address(0xBF881A80)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI28bits_t;
extern volatile __C2FIFOCI28bits_t C2FIFOCI28bits __asm__ ("C2FIFOCI28") __attribute__((section("sfrs"), address(0xBF881A80)));
extern volatile uint32_t        C2FIFOCI28CLR __attribute__((section("sfrs"),address(0xBF881A84)));
extern volatile uint32_t        C2FIFOCI28SET __attribute__((section("sfrs"),address(0xBF881A88)));
extern volatile uint32_t        C2FIFOCI28INV __attribute__((section("sfrs"),address(0xBF881A8C)));
#define C2FIFOCON29 C2FIFOCON29
extern volatile uint32_t   C2FIFOCON29 __attribute__((section("sfrs"), address(0xBF881A90)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON29bits_t;
extern volatile __C2FIFOCON29bits_t C2FIFOCON29bits __asm__ ("C2FIFOCON29") __attribute__((section("sfrs"), address(0xBF881A90)));
extern volatile uint32_t        C2FIFOCON29CLR __attribute__((section("sfrs"),address(0xBF881A94)));
extern volatile uint32_t        C2FIFOCON29SET __attribute__((section("sfrs"),address(0xBF881A98)));
extern volatile uint32_t        C2FIFOCON29INV __attribute__((section("sfrs"),address(0xBF881A9C)));
#define C2FIFOINT29 C2FIFOINT29
extern volatile uint32_t   C2FIFOINT29 __attribute__((section("sfrs"), address(0xBF881AA0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT29bits_t;
extern volatile __C2FIFOINT29bits_t C2FIFOINT29bits __asm__ ("C2FIFOINT29") __attribute__((section("sfrs"), address(0xBF881AA0)));
extern volatile uint32_t        C2FIFOINT29CLR __attribute__((section("sfrs"),address(0xBF881AA4)));
extern volatile uint32_t        C2FIFOINT29SET __attribute__((section("sfrs"),address(0xBF881AA8)));
extern volatile uint32_t        C2FIFOINT29INV __attribute__((section("sfrs"),address(0xBF881AAC)));
#define C2FIFOUA29 C2FIFOUA29
extern volatile uint32_t   C2FIFOUA29 __attribute__((section("sfrs"), address(0xBF881AB0)));
extern volatile uint32_t        C2FIFOUA29CLR __attribute__((section("sfrs"),address(0xBF881AB4)));
extern volatile uint32_t        C2FIFOUA29SET __attribute__((section("sfrs"),address(0xBF881AB8)));
extern volatile uint32_t        C2FIFOUA29INV __attribute__((section("sfrs"),address(0xBF881ABC)));
#define C2FIFOCI29 C2FIFOCI29
extern volatile uint32_t   C2FIFOCI29 __attribute__((section("sfrs"), address(0xBF881AC0)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI29bits_t;
extern volatile __C2FIFOCI29bits_t C2FIFOCI29bits __asm__ ("C2FIFOCI29") __attribute__((section("sfrs"), address(0xBF881AC0)));
extern volatile uint32_t        C2FIFOCI29CLR __attribute__((section("sfrs"),address(0xBF881AC4)));
extern volatile uint32_t        C2FIFOCI29SET __attribute__((section("sfrs"),address(0xBF881AC8)));
extern volatile uint32_t        C2FIFOCI29INV __attribute__((section("sfrs"),address(0xBF881ACC)));
#define C2FIFOCON30 C2FIFOCON30
extern volatile uint32_t   C2FIFOCON30 __attribute__((section("sfrs"), address(0xBF881AD0)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON30bits_t;
extern volatile __C2FIFOCON30bits_t C2FIFOCON30bits __asm__ ("C2FIFOCON30") __attribute__((section("sfrs"), address(0xBF881AD0)));
extern volatile uint32_t        C2FIFOCON30CLR __attribute__((section("sfrs"),address(0xBF881AD4)));
extern volatile uint32_t        C2FIFOCON30SET __attribute__((section("sfrs"),address(0xBF881AD8)));
extern volatile uint32_t        C2FIFOCON30INV __attribute__((section("sfrs"),address(0xBF881ADC)));
#define C2FIFOINT30 C2FIFOINT30
extern volatile uint32_t   C2FIFOINT30 __attribute__((section("sfrs"), address(0xBF881AE0)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT30bits_t;
extern volatile __C2FIFOINT30bits_t C2FIFOINT30bits __asm__ ("C2FIFOINT30") __attribute__((section("sfrs"), address(0xBF881AE0)));
extern volatile uint32_t        C2FIFOINT30CLR __attribute__((section("sfrs"),address(0xBF881AE4)));
extern volatile uint32_t        C2FIFOINT30SET __attribute__((section("sfrs"),address(0xBF881AE8)));
extern volatile uint32_t        C2FIFOINT30INV __attribute__((section("sfrs"),address(0xBF881AEC)));
#define C2FIFOUA30 C2FIFOUA30
extern volatile uint32_t   C2FIFOUA30 __attribute__((section("sfrs"), address(0xBF881AF0)));
extern volatile uint32_t        C2FIFOUA30CLR __attribute__((section("sfrs"),address(0xBF881AF4)));
extern volatile uint32_t        C2FIFOUA30SET __attribute__((section("sfrs"),address(0xBF881AF8)));
extern volatile uint32_t        C2FIFOUA30INV __attribute__((section("sfrs"),address(0xBF881AFC)));
#define C2FIFOCI30 C2FIFOCI30
extern volatile uint32_t   C2FIFOCI30 __attribute__((section("sfrs"), address(0xBF881B00)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI30bits_t;
extern volatile __C2FIFOCI30bits_t C2FIFOCI30bits __asm__ ("C2FIFOCI30") __attribute__((section("sfrs"), address(0xBF881B00)));
extern volatile uint32_t        C2FIFOCI30CLR __attribute__((section("sfrs"),address(0xBF881B04)));
extern volatile uint32_t        C2FIFOCI30SET __attribute__((section("sfrs"),address(0xBF881B08)));
extern volatile uint32_t        C2FIFOCI30INV __attribute__((section("sfrs"),address(0xBF881B0C)));
#define C2FIFOCON31 C2FIFOCON31
extern volatile uint32_t   C2FIFOCON31 __attribute__((section("sfrs"), address(0xBF881B10)));
typedef union {
  struct {
    uint32_t TXPRI:2;
    uint32_t RTREN:1;
    uint32_t TXREQ:1;
    uint32_t TXERR:1;
    uint32_t TXLARB:1;
    uint32_t TXABAT:1;
    uint32_t TXEN:1;
    uint32_t :4;
    uint32_t DONLY:1;
    uint32_t UINC:1;
    uint32_t FRESET:1;
    uint32_t :1;
    uint32_t FSIZE:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCON31bits_t;
extern volatile __C2FIFOCON31bits_t C2FIFOCON31bits __asm__ ("C2FIFOCON31") __attribute__((section("sfrs"), address(0xBF881B10)));
extern volatile uint32_t        C2FIFOCON31CLR __attribute__((section("sfrs"),address(0xBF881B14)));
extern volatile uint32_t        C2FIFOCON31SET __attribute__((section("sfrs"),address(0xBF881B18)));
extern volatile uint32_t        C2FIFOCON31INV __attribute__((section("sfrs"),address(0xBF881B1C)));
#define C2FIFOINT31 C2FIFOINT31
extern volatile uint32_t   C2FIFOINT31 __attribute__((section("sfrs"), address(0xBF881B20)));
typedef union {
  struct {
    uint32_t RXNEMPTYIF:1;
    uint32_t RXHALFIF:1;
    uint32_t RXFULLIF:1;
    uint32_t RXOVFLIF:1;
    uint32_t :4;
    uint32_t TXEMPTYIF:1;
    uint32_t TXHALFIF:1;
    uint32_t TXNFULLIF:1;
    uint32_t :5;
    uint32_t RXNEMPTYIE:1;
    uint32_t RXHALFIE:1;
    uint32_t RXFULLIE:1;
    uint32_t RXOVFLIE:1;
    uint32_t :4;
    uint32_t TXEMPTYIE:1;
    uint32_t TXHALFIE:1;
    uint32_t TXNFULLIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOINT31bits_t;
extern volatile __C2FIFOINT31bits_t C2FIFOINT31bits __asm__ ("C2FIFOINT31") __attribute__((section("sfrs"), address(0xBF881B20)));
extern volatile uint32_t        C2FIFOINT31CLR __attribute__((section("sfrs"),address(0xBF881B24)));
extern volatile uint32_t        C2FIFOINT31SET __attribute__((section("sfrs"),address(0xBF881B28)));
extern volatile uint32_t        C2FIFOINT31INV __attribute__((section("sfrs"),address(0xBF881B2C)));
#define C2FIFOUA31 C2FIFOUA31
extern volatile uint32_t   C2FIFOUA31 __attribute__((section("sfrs"), address(0xBF881B30)));
extern volatile uint32_t        C2FIFOUA31CLR __attribute__((section("sfrs"),address(0xBF881B34)));
extern volatile uint32_t        C2FIFOUA31SET __attribute__((section("sfrs"),address(0xBF881B38)));
extern volatile uint32_t        C2FIFOUA31INV __attribute__((section("sfrs"),address(0xBF881B3C)));
#define C2FIFOCI31 C2FIFOCI31
extern volatile uint32_t   C2FIFOCI31 __attribute__((section("sfrs"), address(0xBF881B40)));
typedef union {
  struct {
    uint32_t CFIFOCI:5;
  };
  struct {
    uint32_t w:32;
  };
} __C2FIFOCI31bits_t;
extern volatile __C2FIFOCI31bits_t C2FIFOCI31bits __asm__ ("C2FIFOCI31") __attribute__((section("sfrs"), address(0xBF881B40)));
extern volatile uint32_t        C2FIFOCI31CLR __attribute__((section("sfrs"),address(0xBF881B44)));
extern volatile uint32_t        C2FIFOCI31SET __attribute__((section("sfrs"),address(0xBF881B48)));
extern volatile uint32_t        C2FIFOCI31INV __attribute__((section("sfrs"),address(0xBF881B4C)));
#define ETHCON1 ETHCON1
extern volatile uint32_t   ETHCON1 __attribute__((section("sfrs"), address(0xBF882000)));
typedef union {
  struct {
    uint32_t BUFCDEC:1;
    uint32_t :3;
    uint32_t MANFC:1;
    uint32_t :2;
    uint32_t AUTOFC:1;
    uint32_t RXEN:1;
    uint32_t TXRTS:1;
    uint32_t :3;
    uint32_t SIDL:1;
    uint32_t :1;
    uint32_t ON:1;
    uint32_t PTV:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHCON1bits_t;
extern volatile __ETHCON1bits_t ETHCON1bits __asm__ ("ETHCON1") __attribute__((section("sfrs"), address(0xBF882000)));
extern volatile uint32_t        ETHCON1CLR __attribute__((section("sfrs"),address(0xBF882004)));
extern volatile uint32_t        ETHCON1SET __attribute__((section("sfrs"),address(0xBF882008)));
extern volatile uint32_t        ETHCON1INV __attribute__((section("sfrs"),address(0xBF88200C)));
#define ETHCON2 ETHCON2
extern volatile uint32_t   ETHCON2 __attribute__((section("sfrs"), address(0xBF882010)));
typedef union {
  struct {
    uint32_t :4;
    uint32_t RXBUF_SZ:7;
  };
  struct {
    uint32_t w:32;
  };
} __ETHCON2bits_t;
extern volatile __ETHCON2bits_t ETHCON2bits __asm__ ("ETHCON2") __attribute__((section("sfrs"), address(0xBF882010)));
extern volatile uint32_t        ETHCON2CLR __attribute__((section("sfrs"),address(0xBF882014)));
extern volatile uint32_t        ETHCON2SET __attribute__((section("sfrs"),address(0xBF882018)));
extern volatile uint32_t        ETHCON2INV __attribute__((section("sfrs"),address(0xBF88201C)));
#define ETHTXST ETHTXST
extern volatile uint32_t   ETHTXST __attribute__((section("sfrs"), address(0xBF882020)));
typedef union {
  struct {
    uint32_t :2;
    uint32_t TXSTADDR:30;
  };
  struct {
    uint32_t w:32;
  };
} __ETHTXSTbits_t;
extern volatile __ETHTXSTbits_t ETHTXSTbits __asm__ ("ETHTXST") __attribute__((section("sfrs"), address(0xBF882020)));
extern volatile uint32_t        ETHTXSTCLR __attribute__((section("sfrs"),address(0xBF882024)));
extern volatile uint32_t        ETHTXSTSET __attribute__((section("sfrs"),address(0xBF882028)));
extern volatile uint32_t        ETHTXSTINV __attribute__((section("sfrs"),address(0xBF88202C)));
#define ETHRXST ETHRXST
extern volatile uint32_t   ETHRXST __attribute__((section("sfrs"), address(0xBF882030)));
typedef union {
  struct {
    uint32_t :2;
    uint32_t RXSTADDR:30;
  };
  struct {
    uint32_t w:32;
  };
} __ETHRXSTbits_t;
extern volatile __ETHRXSTbits_t ETHRXSTbits __asm__ ("ETHRXST") __attribute__((section("sfrs"), address(0xBF882030)));
extern volatile uint32_t        ETHRXSTCLR __attribute__((section("sfrs"),address(0xBF882034)));
extern volatile uint32_t        ETHRXSTSET __attribute__((section("sfrs"),address(0xBF882038)));
extern volatile uint32_t        ETHRXSTINV __attribute__((section("sfrs"),address(0xBF88203C)));
#define ETHHT0 ETHHT0
extern volatile uint32_t   ETHHT0 __attribute__((section("sfrs"), address(0xBF882040)));
typedef union {
  struct {
    uint32_t w:32;
  };
  struct {
    uint32_t HTLOWER:32;
  };
} __ETHHT0bits_t;
extern volatile __ETHHT0bits_t ETHHT0bits __asm__ ("ETHHT0") __attribute__((section("sfrs"), address(0xBF882040)));
extern volatile uint32_t        ETHHT0CLR __attribute__((section("sfrs"),address(0xBF882044)));
extern volatile uint32_t        ETHHT0SET __attribute__((section("sfrs"),address(0xBF882048)));
extern volatile uint32_t        ETHHT0INV __attribute__((section("sfrs"),address(0xBF88204C)));
#define ETHHT1 ETHHT1
extern volatile uint32_t   ETHHT1 __attribute__((section("sfrs"), address(0xBF882050)));
typedef union {
  struct {
    uint32_t w:32;
  };
  struct {
    uint32_t HTUPPER:32;
  };
} __ETHHT1bits_t;
extern volatile __ETHHT1bits_t ETHHT1bits __asm__ ("ETHHT1") __attribute__((section("sfrs"), address(0xBF882050)));
extern volatile uint32_t        ETHHT1CLR __attribute__((section("sfrs"),address(0xBF882054)));
extern volatile uint32_t        ETHHT1SET __attribute__((section("sfrs"),address(0xBF882058)));
extern volatile uint32_t        ETHHT1INV __attribute__((section("sfrs"),address(0xBF88205C)));
#define ETHPMM0 ETHPMM0
extern volatile uint32_t   ETHPMM0 __attribute__((section("sfrs"), address(0xBF882060)));
typedef union {
  struct {
    uint32_t w:32;
  };
  struct {
    uint32_t PMMLOWER:32;
  };
} __ETHPMM0bits_t;
extern volatile __ETHPMM0bits_t ETHPMM0bits __asm__ ("ETHPMM0") __attribute__((section("sfrs"), address(0xBF882060)));
extern volatile uint32_t        ETHPMM0CLR __attribute__((section("sfrs"),address(0xBF882064)));
extern volatile uint32_t        ETHPMM0SET __attribute__((section("sfrs"),address(0xBF882068)));
extern volatile uint32_t        ETHPMM0INV __attribute__((section("sfrs"),address(0xBF88206C)));
#define ETHPMM1 ETHPMM1
extern volatile uint32_t   ETHPMM1 __attribute__((section("sfrs"), address(0xBF882070)));
typedef union {
  struct {
    uint32_t w:32;
  };
  struct {
    uint32_t PMMUPPER:32;
  };
} __ETHPMM1bits_t;
extern volatile __ETHPMM1bits_t ETHPMM1bits __asm__ ("ETHPMM1") __attribute__((section("sfrs"), address(0xBF882070)));
extern volatile uint32_t        ETHPMM1CLR __attribute__((section("sfrs"),address(0xBF882074)));
extern volatile uint32_t        ETHPMM1SET __attribute__((section("sfrs"),address(0xBF882078)));
extern volatile uint32_t        ETHPMM1INV __attribute__((section("sfrs"),address(0xBF88207C)));
#define ETHPMCS ETHPMCS
extern volatile uint32_t   ETHPMCS __attribute__((section("sfrs"), address(0xBF882080)));
typedef union {
  struct {
    uint32_t PMCS:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHPMCSbits_t;
extern volatile __ETHPMCSbits_t ETHPMCSbits __asm__ ("ETHPMCS") __attribute__((section("sfrs"), address(0xBF882080)));
extern volatile uint32_t        ETHPMCSCLR __attribute__((section("sfrs"),address(0xBF882084)));
extern volatile uint32_t        ETHPMCSSET __attribute__((section("sfrs"),address(0xBF882088)));
extern volatile uint32_t        ETHPMCSINV __attribute__((section("sfrs"),address(0xBF88208C)));
#define ETHPMO ETHPMO
extern volatile uint32_t   ETHPMO __attribute__((section("sfrs"), address(0xBF882090)));
typedef union {
  struct {
    uint32_t PMO:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHPMObits_t;
extern volatile __ETHPMObits_t ETHPMObits __asm__ ("ETHPMO") __attribute__((section("sfrs"), address(0xBF882090)));
extern volatile uint32_t        ETHPMOCLR __attribute__((section("sfrs"),address(0xBF882094)));
extern volatile uint32_t        ETHPMOSET __attribute__((section("sfrs"),address(0xBF882098)));
extern volatile uint32_t        ETHPMOINV __attribute__((section("sfrs"),address(0xBF88209C)));
#define ETHRXFC ETHRXFC
extern volatile uint32_t   ETHRXFC __attribute__((section("sfrs"), address(0xBF8820A0)));
typedef union {
  struct {
    uint32_t BCEN:1;
    uint32_t MCEN:1;
    uint32_t NOTMEEN:1;
    uint32_t UCEN:1;
    uint32_t RUNTEN:1;
    uint32_t RUNTERREN:1;
    uint32_t CRCOKEN:1;
    uint32_t CRCERREN:1;
    uint32_t PMMODE:4;
    uint32_t NOTPM:1;
    uint32_t :1;
    uint32_t MPEN:1;
    uint32_t HTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __ETHRXFCbits_t;
extern volatile __ETHRXFCbits_t ETHRXFCbits __asm__ ("ETHRXFC") __attribute__((section("sfrs"), address(0xBF8820A0)));
extern volatile uint32_t        ETHRXFCCLR __attribute__((section("sfrs"),address(0xBF8820A4)));
extern volatile uint32_t        ETHRXFCSET __attribute__((section("sfrs"),address(0xBF8820A8)));
extern volatile uint32_t        ETHRXFCINV __attribute__((section("sfrs"),address(0xBF8820AC)));
#define ETHRXWM ETHRXWM
extern volatile uint32_t   ETHRXWM __attribute__((section("sfrs"), address(0xBF8820B0)));
typedef union {
  struct {
    uint32_t RXEWM:8;
    uint32_t :8;
    uint32_t RXFWM:8;
  };
  struct {
    uint32_t w:32;
  };
} __ETHRXWMbits_t;
extern volatile __ETHRXWMbits_t ETHRXWMbits __asm__ ("ETHRXWM") __attribute__((section("sfrs"), address(0xBF8820B0)));
extern volatile uint32_t        ETHRXWMCLR __attribute__((section("sfrs"),address(0xBF8820B4)));
extern volatile uint32_t        ETHRXWMSET __attribute__((section("sfrs"),address(0xBF8820B8)));
extern volatile uint32_t        ETHRXWMINV __attribute__((section("sfrs"),address(0xBF8820BC)));
#define ETHIEN ETHIEN
extern volatile uint32_t   ETHIEN __attribute__((section("sfrs"), address(0xBF8820C0)));
typedef union {
  struct {
    uint32_t RXOVFLWIE:1;
    uint32_t RXBUFNAIE:1;
    uint32_t TXABORTIE:1;
    uint32_t TXDONEIE:1;
    uint32_t :1;
    uint32_t RXACTIE:1;
    uint32_t PKTPENDIE:1;
    uint32_t RXDONEIE:1;
    uint32_t FWMARKIE:1;
    uint32_t EWMARKIE:1;
    uint32_t :3;
    uint32_t RXBUSEIE:1;
    uint32_t TXBUSEIE:1;
  };
  struct {
    uint32_t w:32;
  };
} __ETHIENbits_t;
extern volatile __ETHIENbits_t ETHIENbits __asm__ ("ETHIEN") __attribute__((section("sfrs"), address(0xBF8820C0)));
extern volatile uint32_t        ETHIENCLR __attribute__((section("sfrs"),address(0xBF8820C4)));
extern volatile uint32_t        ETHIENSET __attribute__((section("sfrs"),address(0xBF8820C8)));
extern volatile uint32_t        ETHIENINV __attribute__((section("sfrs"),address(0xBF8820CC)));
#define ETHIRQ ETHIRQ
extern volatile uint32_t   ETHIRQ __attribute__((section("sfrs"), address(0xBF8820D0)));
typedef union {
  struct {
    uint32_t RXOVFLW:1;
    uint32_t RXBUFNA:1;
    uint32_t TXABORT:1;
    uint32_t TXDONE:1;
    uint32_t :1;
    uint32_t RXACT:1;
    uint32_t PKTPEND:1;
    uint32_t RXDONE:1;
    uint32_t FWMARK:1;
    uint32_t EWMARK:1;
    uint32_t :3;
    uint32_t RXBUSE:1;
    uint32_t TXBUSE:1;
  };
  struct {
    uint32_t w:32;
  };
} __ETHIRQbits_t;
extern volatile __ETHIRQbits_t ETHIRQbits __asm__ ("ETHIRQ") __attribute__((section("sfrs"), address(0xBF8820D0)));
extern volatile uint32_t        ETHIRQCLR __attribute__((section("sfrs"),address(0xBF8820D4)));
extern volatile uint32_t        ETHIRQSET __attribute__((section("sfrs"),address(0xBF8820D8)));
extern volatile uint32_t        ETHIRQINV __attribute__((section("sfrs"),address(0xBF8820DC)));
#define ETHSTAT ETHSTAT
extern volatile uint32_t   ETHSTAT __attribute__((section("sfrs"), address(0xBF8820E0)));
typedef union {
  struct {
    uint32_t :5;
    uint32_t RXBUSY:1;
    uint32_t TXBUSY:1;
    uint32_t BUSY:1;
    uint32_t :8;
    uint32_t BUFCNT:8;
  };
  struct {
    uint32_t :7;
    uint32_t ETHBUSY:1;
  };
  struct {
    uint32_t w:32;
  };
} __ETHSTATbits_t;
extern volatile __ETHSTATbits_t ETHSTATbits __asm__ ("ETHSTAT") __attribute__((section("sfrs"), address(0xBF8820E0)));
extern volatile uint32_t        ETHSTATCLR __attribute__((section("sfrs"),address(0xBF8820E4)));
extern volatile uint32_t        ETHSTATSET __attribute__((section("sfrs"),address(0xBF8820E8)));
extern volatile uint32_t        ETHSTATINV __attribute__((section("sfrs"),address(0xBF8820EC)));
#define ETHRXOVFLOW ETHRXOVFLOW
extern volatile uint32_t   ETHRXOVFLOW __attribute__((section("sfrs"), address(0xBF882100)));
typedef union {
  struct {
    uint32_t RXOVFLWCNT:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHRXOVFLOWbits_t;
extern volatile __ETHRXOVFLOWbits_t ETHRXOVFLOWbits __asm__ ("ETHRXOVFLOW") __attribute__((section("sfrs"), address(0xBF882100)));
extern volatile uint32_t        ETHRXOVFLOWCLR __attribute__((section("sfrs"),address(0xBF882104)));
extern volatile uint32_t        ETHRXOVFLOWSET __attribute__((section("sfrs"),address(0xBF882108)));
extern volatile uint32_t        ETHRXOVFLOWINV __attribute__((section("sfrs"),address(0xBF88210C)));
#define ETHFRMTXOK ETHFRMTXOK
extern volatile uint32_t   ETHFRMTXOK __attribute__((section("sfrs"), address(0xBF882110)));
typedef union {
  struct {
    uint32_t FRMTXOKCNT:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHFRMTXOKbits_t;
extern volatile __ETHFRMTXOKbits_t ETHFRMTXOKbits __asm__ ("ETHFRMTXOK") __attribute__((section("sfrs"), address(0xBF882110)));
extern volatile uint32_t        ETHFRMTXOKCLR __attribute__((section("sfrs"),address(0xBF882114)));
extern volatile uint32_t        ETHFRMTXOKSET __attribute__((section("sfrs"),address(0xBF882118)));
extern volatile uint32_t        ETHFRMTXOKINV __attribute__((section("sfrs"),address(0xBF88211C)));
#define ETHSCOLFRM ETHSCOLFRM
extern volatile uint32_t   ETHSCOLFRM __attribute__((section("sfrs"), address(0xBF882120)));
typedef union {
  struct {
    uint32_t SCOLFRMCNT:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHSCOLFRMbits_t;
extern volatile __ETHSCOLFRMbits_t ETHSCOLFRMbits __asm__ ("ETHSCOLFRM") __attribute__((section("sfrs"), address(0xBF882120)));
extern volatile uint32_t        ETHSCOLFRMCLR __attribute__((section("sfrs"),address(0xBF882124)));
extern volatile uint32_t        ETHSCOLFRMSET __attribute__((section("sfrs"),address(0xBF882128)));
extern volatile uint32_t        ETHSCOLFRMINV __attribute__((section("sfrs"),address(0xBF88212C)));
#define ETHMCOLFRM ETHMCOLFRM
extern volatile uint32_t   ETHMCOLFRM __attribute__((section("sfrs"), address(0xBF882130)));
typedef union {
  struct {
    uint32_t MCOLFRMCNT:16;
  };
  struct {
    uint32_t MCOLFRM_CNT:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHMCOLFRMbits_t;
extern volatile __ETHMCOLFRMbits_t ETHMCOLFRMbits __asm__ ("ETHMCOLFRM") __attribute__((section("sfrs"), address(0xBF882130)));
extern volatile uint32_t        ETHMCOLFRMCLR __attribute__((section("sfrs"),address(0xBF882134)));
extern volatile uint32_t        ETHMCOLFRMSET __attribute__((section("sfrs"),address(0xBF882138)));
extern volatile uint32_t        ETHMCOLFRMINV __attribute__((section("sfrs"),address(0xBF88213C)));
#define ETHFRMRXOK ETHFRMRXOK
extern volatile uint32_t   ETHFRMRXOK __attribute__((section("sfrs"), address(0xBF882140)));
typedef union {
  struct {
    uint32_t FRMRXOKCNT:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHFRMRXOKbits_t;
extern volatile __ETHFRMRXOKbits_t ETHFRMRXOKbits __asm__ ("ETHFRMRXOK") __attribute__((section("sfrs"), address(0xBF882140)));
extern volatile uint32_t        ETHFRMRXOKCLR __attribute__((section("sfrs"),address(0xBF882144)));
extern volatile uint32_t        ETHFRMRXOKSET __attribute__((section("sfrs"),address(0xBF882148)));
extern volatile uint32_t        ETHFRMRXOKINV __attribute__((section("sfrs"),address(0xBF88214C)));
#define ETHFCSERR ETHFCSERR
extern volatile uint32_t   ETHFCSERR __attribute__((section("sfrs"), address(0xBF882150)));
typedef union {
  struct {
    uint32_t FCSERRCNT:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHFCSERRbits_t;
extern volatile __ETHFCSERRbits_t ETHFCSERRbits __asm__ ("ETHFCSERR") __attribute__((section("sfrs"), address(0xBF882150)));
extern volatile uint32_t        ETHFCSERRCLR __attribute__((section("sfrs"),address(0xBF882154)));
extern volatile uint32_t        ETHFCSERRSET __attribute__((section("sfrs"),address(0xBF882158)));
extern volatile uint32_t        ETHFCSERRINV __attribute__((section("sfrs"),address(0xBF88215C)));
#define ETHALGNERR ETHALGNERR
extern volatile uint32_t   ETHALGNERR __attribute__((section("sfrs"), address(0xBF882160)));
typedef union {
  struct {
    uint32_t ALGNERRCNT:16;
  };
  struct {
    uint32_t w:32;
  };
} __ETHALGNERRbits_t;
extern volatile __ETHALGNERRbits_t ETHALGNERRbits __asm__ ("ETHALGNERR") __attribute__((section("sfrs"), address(0xBF882160)));
extern volatile uint32_t        ETHALGNERRCLR __attribute__((section("sfrs"),address(0xBF882164)));
extern volatile uint32_t        ETHALGNERRSET __attribute__((section("sfrs"),address(0xBF882168)));
extern volatile uint32_t        ETHALGNERRINV __attribute__((section("sfrs"),address(0xBF88216C)));
#define EMAC1CFG1 EMAC1CFG1
extern volatile uint32_t   EMAC1CFG1 __attribute__((section("sfrs"), address(0xBF882200)));
typedef union {
  struct {
    uint32_t RXENABLE:1;
    uint32_t PASSALL:1;
    uint32_t RXPAUSE:1;
    uint32_t TXPAUSE:1;
    uint32_t LOOPBACK:1;
    uint32_t :3;
    uint32_t RESETTFUN:1;
    uint32_t RESETTMCS:1;
    uint32_t RESETRFUN:1;
    uint32_t RESETRMCS:1;
    uint32_t :2;
    uint32_t SIMRESET:1;
    uint32_t SOFTRESET:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1CFG1bits_t;
extern volatile __EMAC1CFG1bits_t EMAC1CFG1bits __asm__ ("EMAC1CFG1") __attribute__((section("sfrs"), address(0xBF882200)));
#define EMACxCFG1 EMACxCFG1
extern volatile uint32_t   EMACxCFG1 __attribute__((section("sfrs"), address(0xBF882200)));
typedef union {
  struct {
    uint32_t RXENABLE:1;
    uint32_t PASSALL:1;
    uint32_t RXPAUSE:1;
    uint32_t TXPAUSE:1;
    uint32_t LOOPBACK:1;
    uint32_t :3;
    uint32_t RESETTFUN:1;
    uint32_t RESETTMCS:1;
    uint32_t RESETRFUN:1;
    uint32_t RESETRMCS:1;
    uint32_t :2;
    uint32_t SIMRESET:1;
    uint32_t SOFTRESET:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxCFG1bits_t;
extern volatile __EMACxCFG1bits_t EMACxCFG1bits __asm__ ("EMACxCFG1") __attribute__((section("sfrs"), address(0xBF882200)));
extern volatile uint32_t        EMAC1CFG1CLR __attribute__((section("sfrs"),address(0xBF882204)));
extern volatile uint32_t        EMACxCFG1CLR __attribute__((section("sfrs"),address(0xBF882204)));
extern volatile uint32_t        EMAC1CFG1SET __attribute__((section("sfrs"),address(0xBF882208)));
extern volatile uint32_t        EMACxCFG1SET __attribute__((section("sfrs"),address(0xBF882208)));
extern volatile uint32_t        EMAC1CFG1INV __attribute__((section("sfrs"),address(0xBF88220C)));
extern volatile uint32_t        EMACxCFG1INV __attribute__((section("sfrs"),address(0xBF88220C)));
#define EMAC1CFG2 EMAC1CFG2
extern volatile uint32_t   EMAC1CFG2 __attribute__((section("sfrs"), address(0xBF882210)));
typedef union {
  struct {
    uint32_t FULLDPLX:1;
    uint32_t LENGTHCK:1;
    uint32_t HUGEFRM:1;
    uint32_t DELAYCRC:1;
    uint32_t CRCENABLE:1;
    uint32_t PADENABLE:1;
    uint32_t VLANPAD:1;
    uint32_t AUTOPAD:1;
    uint32_t PUREPRE:1;
    uint32_t LONGPRE:1;
    uint32_t :2;
    uint32_t NOBKOFF:1;
    uint32_t BPNOBKOFF:1;
    uint32_t EXCESSDFR:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1CFG2bits_t;
extern volatile __EMAC1CFG2bits_t EMAC1CFG2bits __asm__ ("EMAC1CFG2") __attribute__((section("sfrs"), address(0xBF882210)));
#define EMACxCFG2 EMACxCFG2
extern volatile uint32_t   EMACxCFG2 __attribute__((section("sfrs"), address(0xBF882210)));
typedef union {
  struct {
    uint32_t FULLDPLX:1;
    uint32_t LENGTHCK:1;
    uint32_t HUGEFRM:1;
    uint32_t DELAYCRC:1;
    uint32_t CRCENABLE:1;
    uint32_t PADENABLE:1;
    uint32_t VLANPAD:1;
    uint32_t AUTOPAD:1;
    uint32_t PUREPRE:1;
    uint32_t LONGPRE:1;
    uint32_t :2;
    uint32_t NOBKOFF:1;
    uint32_t BPNOBKOFF:1;
    uint32_t EXCESSDFR:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxCFG2bits_t;
extern volatile __EMACxCFG2bits_t EMACxCFG2bits __asm__ ("EMACxCFG2") __attribute__((section("sfrs"), address(0xBF882210)));
extern volatile uint32_t        EMAC1CFG2CLR __attribute__((section("sfrs"),address(0xBF882214)));
extern volatile uint32_t        EMACxCFG2CLR __attribute__((section("sfrs"),address(0xBF882214)));
extern volatile uint32_t        EMAC1CFG2SET __attribute__((section("sfrs"),address(0xBF882218)));
extern volatile uint32_t        EMACxCFG2SET __attribute__((section("sfrs"),address(0xBF882218)));
extern volatile uint32_t        EMAC1CFG2INV __attribute__((section("sfrs"),address(0xBF88221C)));
extern volatile uint32_t        EMACxCFG2INV __attribute__((section("sfrs"),address(0xBF88221C)));
#define EMAC1IPGT EMAC1IPGT
extern volatile uint32_t   EMAC1IPGT __attribute__((section("sfrs"), address(0xBF882220)));
typedef union {
  struct {
    uint32_t B2BIPKTGP:7;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1IPGTbits_t;
extern volatile __EMAC1IPGTbits_t EMAC1IPGTbits __asm__ ("EMAC1IPGT") __attribute__((section("sfrs"), address(0xBF882220)));
#define EMACxIPGT EMACxIPGT
extern volatile uint32_t   EMACxIPGT __attribute__((section("sfrs"), address(0xBF882220)));
typedef union {
  struct {
    uint32_t B2BIPKTGP:7;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxIPGTbits_t;
extern volatile __EMACxIPGTbits_t EMACxIPGTbits __asm__ ("EMACxIPGT") __attribute__((section("sfrs"), address(0xBF882220)));
extern volatile uint32_t        EMAC1IPGTCLR __attribute__((section("sfrs"),address(0xBF882224)));
extern volatile uint32_t        EMACxIPGTCLR __attribute__((section("sfrs"),address(0xBF882224)));
extern volatile uint32_t        EMAC1IPGTSET __attribute__((section("sfrs"),address(0xBF882228)));
extern volatile uint32_t        EMACxIPGTSET __attribute__((section("sfrs"),address(0xBF882228)));
extern volatile uint32_t        EMAC1IPGTINV __attribute__((section("sfrs"),address(0xBF88222C)));
extern volatile uint32_t        EMACxIPGTINV __attribute__((section("sfrs"),address(0xBF88222C)));
#define EMAC1IPGR EMAC1IPGR
extern volatile uint32_t   EMAC1IPGR __attribute__((section("sfrs"), address(0xBF882230)));
typedef union {
  struct {
    uint32_t NB2BIPKTGP2:7;
    uint32_t :1;
    uint32_t NB2BIPKTGP1:7;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1IPGRbits_t;
extern volatile __EMAC1IPGRbits_t EMAC1IPGRbits __asm__ ("EMAC1IPGR") __attribute__((section("sfrs"), address(0xBF882230)));
#define EMACxIPGR EMACxIPGR
extern volatile uint32_t   EMACxIPGR __attribute__((section("sfrs"), address(0xBF882230)));
typedef union {
  struct {
    uint32_t NB2BIPKTGP2:7;
    uint32_t :1;
    uint32_t NB2BIPKTGP1:7;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxIPGRbits_t;
extern volatile __EMACxIPGRbits_t EMACxIPGRbits __asm__ ("EMACxIPGR") __attribute__((section("sfrs"), address(0xBF882230)));
extern volatile uint32_t        EMAC1IPGRCLR __attribute__((section("sfrs"),address(0xBF882234)));
extern volatile uint32_t        EMACxIPGRCLR __attribute__((section("sfrs"),address(0xBF882234)));
extern volatile uint32_t        EMAC1IPGRSET __attribute__((section("sfrs"),address(0xBF882238)));
extern volatile uint32_t        EMACxIPGRSET __attribute__((section("sfrs"),address(0xBF882238)));
extern volatile uint32_t        EMAC1IPGRINV __attribute__((section("sfrs"),address(0xBF88223C)));
extern volatile uint32_t        EMACxIPGRINV __attribute__((section("sfrs"),address(0xBF88223C)));
#define EMAC1CLRT EMAC1CLRT
extern volatile uint32_t   EMAC1CLRT __attribute__((section("sfrs"), address(0xBF882240)));
typedef union {
  struct {
    uint32_t RETX:4;
    uint32_t :4;
    uint32_t CWINDOW:6;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1CLRTbits_t;
extern volatile __EMAC1CLRTbits_t EMAC1CLRTbits __asm__ ("EMAC1CLRT") __attribute__((section("sfrs"), address(0xBF882240)));
#define EMACxCLRT EMACxCLRT
extern volatile uint32_t   EMACxCLRT __attribute__((section("sfrs"), address(0xBF882240)));
typedef union {
  struct {
    uint32_t RETX:4;
    uint32_t :4;
    uint32_t CWINDOW:6;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxCLRTbits_t;
extern volatile __EMACxCLRTbits_t EMACxCLRTbits __asm__ ("EMACxCLRT") __attribute__((section("sfrs"), address(0xBF882240)));
extern volatile uint32_t        EMAC1CLRTCLR __attribute__((section("sfrs"),address(0xBF882244)));
extern volatile uint32_t        EMACxCLRTCLR __attribute__((section("sfrs"),address(0xBF882244)));
extern volatile uint32_t        EMAC1CLRTSET __attribute__((section("sfrs"),address(0xBF882248)));
extern volatile uint32_t        EMACxCLRTSET __attribute__((section("sfrs"),address(0xBF882248)));
extern volatile uint32_t        EMAC1CLRTINV __attribute__((section("sfrs"),address(0xBF88224C)));
extern volatile uint32_t        EMACxCLRTINV __attribute__((section("sfrs"),address(0xBF88224C)));
#define EMAC1MAXF EMAC1MAXF
extern volatile uint32_t   EMAC1MAXF __attribute__((section("sfrs"), address(0xBF882250)));
typedef union {
  struct {
    uint32_t MACMAXF:16;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1MAXFbits_t;
extern volatile __EMAC1MAXFbits_t EMAC1MAXFbits __asm__ ("EMAC1MAXF") __attribute__((section("sfrs"), address(0xBF882250)));
#define EMACxMAXF EMACxMAXF
extern volatile uint32_t   EMACxMAXF __attribute__((section("sfrs"), address(0xBF882250)));
typedef union {
  struct {
    uint32_t MACMAXF:16;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxMAXFbits_t;
extern volatile __EMACxMAXFbits_t EMACxMAXFbits __asm__ ("EMACxMAXF") __attribute__((section("sfrs"), address(0xBF882250)));
extern volatile uint32_t        EMAC1MAXFCLR __attribute__((section("sfrs"),address(0xBF882254)));
extern volatile uint32_t        EMACxMAXFCLR __attribute__((section("sfrs"),address(0xBF882254)));
extern volatile uint32_t        EMAC1MAXFSET __attribute__((section("sfrs"),address(0xBF882258)));
extern volatile uint32_t        EMACxMAXFSET __attribute__((section("sfrs"),address(0xBF882258)));
extern volatile uint32_t        EMAC1MAXFINV __attribute__((section("sfrs"),address(0xBF88225C)));
extern volatile uint32_t        EMACxMAXFINV __attribute__((section("sfrs"),address(0xBF88225C)));
#define EMAC1SUPP EMAC1SUPP
extern volatile uint32_t   EMAC1SUPP __attribute__((section("sfrs"), address(0xBF882260)));
typedef union {
  struct {
    uint32_t :8;
    uint32_t SPEEDRMII:1;
    uint32_t :2;
    uint32_t RESETRMII:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1SUPPbits_t;
extern volatile __EMAC1SUPPbits_t EMAC1SUPPbits __asm__ ("EMAC1SUPP") __attribute__((section("sfrs"), address(0xBF882260)));
#define EMACxSUPP EMACxSUPP
extern volatile uint32_t   EMACxSUPP __attribute__((section("sfrs"), address(0xBF882260)));
typedef union {
  struct {
    uint32_t :8;
    uint32_t SPEEDRMII:1;
    uint32_t :2;
    uint32_t RESETRMII:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxSUPPbits_t;
extern volatile __EMACxSUPPbits_t EMACxSUPPbits __asm__ ("EMACxSUPP") __attribute__((section("sfrs"), address(0xBF882260)));
extern volatile uint32_t        EMAC1SUPPCLR __attribute__((section("sfrs"),address(0xBF882264)));
extern volatile uint32_t        EMACxSUPPCLR __attribute__((section("sfrs"),address(0xBF882264)));
extern volatile uint32_t        EMAC1SUPPSET __attribute__((section("sfrs"),address(0xBF882268)));
extern volatile uint32_t        EMACxSUPPSET __attribute__((section("sfrs"),address(0xBF882268)));
extern volatile uint32_t        EMAC1SUPPINV __attribute__((section("sfrs"),address(0xBF88226C)));
extern volatile uint32_t        EMACxSUPPINV __attribute__((section("sfrs"),address(0xBF88226C)));
#define EMAC1TEST EMAC1TEST
extern volatile uint32_t   EMAC1TEST __attribute__((section("sfrs"), address(0xBF882270)));
typedef union {
  struct {
    uint32_t SHRTQNTA:1;
    uint32_t TESTPAUSE:1;
    uint32_t TESTBP:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1TESTbits_t;
extern volatile __EMAC1TESTbits_t EMAC1TESTbits __asm__ ("EMAC1TEST") __attribute__((section("sfrs"), address(0xBF882270)));
#define EMACxTEST EMACxTEST
extern volatile uint32_t   EMACxTEST __attribute__((section("sfrs"), address(0xBF882270)));
typedef union {
  struct {
    uint32_t SHRTQNTA:1;
    uint32_t TESTPAUSE:1;
    uint32_t TESTBP:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxTESTbits_t;
extern volatile __EMACxTESTbits_t EMACxTESTbits __asm__ ("EMACxTEST") __attribute__((section("sfrs"), address(0xBF882270)));
extern volatile uint32_t        EMAC1TESTCLR __attribute__((section("sfrs"),address(0xBF882274)));
extern volatile uint32_t        EMACxTESTCLR __attribute__((section("sfrs"),address(0xBF882274)));
extern volatile uint32_t        EMAC1TESTSET __attribute__((section("sfrs"),address(0xBF882278)));
extern volatile uint32_t        EMACxTESTSET __attribute__((section("sfrs"),address(0xBF882278)));
extern volatile uint32_t        EMAC1TESTINV __attribute__((section("sfrs"),address(0xBF88227C)));
extern volatile uint32_t        EMACxTESTINV __attribute__((section("sfrs"),address(0xBF88227C)));
#define EMAC1MCFG EMAC1MCFG
extern volatile uint32_t   EMAC1MCFG __attribute__((section("sfrs"), address(0xBF882280)));
typedef union {
  struct {
    uint32_t SCANINC:1;
    uint32_t NOPRE:1;
    uint32_t CLKSEL:4;
    uint32_t :9;
    uint32_t RESETMGMT:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1MCFGbits_t;
extern volatile __EMAC1MCFGbits_t EMAC1MCFGbits __asm__ ("EMAC1MCFG") __attribute__((section("sfrs"), address(0xBF882280)));
#define EMACxMCFG EMACxMCFG
extern volatile uint32_t   EMACxMCFG __attribute__((section("sfrs"), address(0xBF882280)));
typedef union {
  struct {
    uint32_t SCANINC:1;
    uint32_t NOPRE:1;
    uint32_t CLKSEL:4;
    uint32_t :9;
    uint32_t RESETMGMT:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxMCFGbits_t;
extern volatile __EMACxMCFGbits_t EMACxMCFGbits __asm__ ("EMACxMCFG") __attribute__((section("sfrs"), address(0xBF882280)));
extern volatile uint32_t        EMAC1MCFGCLR __attribute__((section("sfrs"),address(0xBF882284)));
extern volatile uint32_t        EMACxMCFGCLR __attribute__((section("sfrs"),address(0xBF882284)));
extern volatile uint32_t        EMAC1MCFGSET __attribute__((section("sfrs"),address(0xBF882288)));
extern volatile uint32_t        EMACxMCFGSET __attribute__((section("sfrs"),address(0xBF882288)));
extern volatile uint32_t        EMAC1MCFGINV __attribute__((section("sfrs"),address(0xBF88228C)));
extern volatile uint32_t        EMACxMCFGINV __attribute__((section("sfrs"),address(0xBF88228C)));
#define EMAC1MCMD EMAC1MCMD
extern volatile uint32_t   EMAC1MCMD __attribute__((section("sfrs"), address(0xBF882290)));
typedef union {
  struct {
    uint32_t READ:1;
    uint32_t SCAN:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1MCMDbits_t;
extern volatile __EMAC1MCMDbits_t EMAC1MCMDbits __asm__ ("EMAC1MCMD") __attribute__((section("sfrs"), address(0xBF882290)));
#define EMACxMCMD EMACxMCMD
extern volatile uint32_t   EMACxMCMD __attribute__((section("sfrs"), address(0xBF882290)));
typedef union {
  struct {
    uint32_t READ:1;
    uint32_t SCAN:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxMCMDbits_t;
extern volatile __EMACxMCMDbits_t EMACxMCMDbits __asm__ ("EMACxMCMD") __attribute__((section("sfrs"), address(0xBF882290)));
extern volatile uint32_t        EMAC1MCMDCLR __attribute__((section("sfrs"),address(0xBF882294)));
extern volatile uint32_t        EMACxMCMDCLR __attribute__((section("sfrs"),address(0xBF882294)));
extern volatile uint32_t        EMAC1MCMDSET __attribute__((section("sfrs"),address(0xBF882298)));
extern volatile uint32_t        EMACxMCMDSET __attribute__((section("sfrs"),address(0xBF882298)));
extern volatile uint32_t        EMAC1MCMDINV __attribute__((section("sfrs"),address(0xBF88229C)));
extern volatile uint32_t        EMACxMCMDINV __attribute__((section("sfrs"),address(0xBF88229C)));
#define EMAC1MADR EMAC1MADR
extern volatile uint32_t   EMAC1MADR __attribute__((section("sfrs"), address(0xBF8822A0)));
typedef union {
  struct {
    uint32_t REGADDR:5;
    uint32_t :3;
    uint32_t PHYADDR:5;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1MADRbits_t;
extern volatile __EMAC1MADRbits_t EMAC1MADRbits __asm__ ("EMAC1MADR") __attribute__((section("sfrs"), address(0xBF8822A0)));
#define EMACxMADR EMACxMADR
extern volatile uint32_t   EMACxMADR __attribute__((section("sfrs"), address(0xBF8822A0)));
typedef union {
  struct {
    uint32_t REGADDR:5;
    uint32_t :3;
    uint32_t PHYADDR:5;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxMADRbits_t;
extern volatile __EMACxMADRbits_t EMACxMADRbits __asm__ ("EMACxMADR") __attribute__((section("sfrs"), address(0xBF8822A0)));
extern volatile uint32_t        EMAC1MADRCLR __attribute__((section("sfrs"),address(0xBF8822A4)));
extern volatile uint32_t        EMACxMADRCLR __attribute__((section("sfrs"),address(0xBF8822A4)));
extern volatile uint32_t        EMAC1MADRSET __attribute__((section("sfrs"),address(0xBF8822A8)));
extern volatile uint32_t        EMACxMADRSET __attribute__((section("sfrs"),address(0xBF8822A8)));
extern volatile uint32_t        EMAC1MADRINV __attribute__((section("sfrs"),address(0xBF8822AC)));
extern volatile uint32_t        EMACxMADRINV __attribute__((section("sfrs"),address(0xBF8822AC)));
#define EMAC1MWTD EMAC1MWTD
extern volatile uint32_t   EMAC1MWTD __attribute__((section("sfrs"), address(0xBF8822B0)));
typedef union {
  struct {
    uint32_t MWTD:16;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1MWTDbits_t;
extern volatile __EMAC1MWTDbits_t EMAC1MWTDbits __asm__ ("EMAC1MWTD") __attribute__((section("sfrs"), address(0xBF8822B0)));
#define EMACxMWTD EMACxMWTD
extern volatile uint32_t   EMACxMWTD __attribute__((section("sfrs"), address(0xBF8822B0)));
typedef union {
  struct {
    uint32_t MWTD:16;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxMWTDbits_t;
extern volatile __EMACxMWTDbits_t EMACxMWTDbits __asm__ ("EMACxMWTD") __attribute__((section("sfrs"), address(0xBF8822B0)));
extern volatile uint32_t        EMAC1MWTDCLR __attribute__((section("sfrs"),address(0xBF8822B4)));
extern volatile uint32_t        EMACxMWTDCLR __attribute__((section("sfrs"),address(0xBF8822B4)));
extern volatile uint32_t        EMAC1MWTDSET __attribute__((section("sfrs"),address(0xBF8822B8)));
extern volatile uint32_t        EMACxMWTDSET __attribute__((section("sfrs"),address(0xBF8822B8)));
extern volatile uint32_t        EMAC1MWTDINV __attribute__((section("sfrs"),address(0xBF8822BC)));
extern volatile uint32_t        EMACxMWTDINV __attribute__((section("sfrs"),address(0xBF8822BC)));
#define EMAC1MRDD EMAC1MRDD
extern volatile uint32_t   EMAC1MRDD __attribute__((section("sfrs"), address(0xBF8822C0)));
typedef union {
  struct {
    uint32_t MRDD:16;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1MRDDbits_t;
extern volatile __EMAC1MRDDbits_t EMAC1MRDDbits __asm__ ("EMAC1MRDD") __attribute__((section("sfrs"), address(0xBF8822C0)));
#define EMACxMRDD EMACxMRDD
extern volatile uint32_t   EMACxMRDD __attribute__((section("sfrs"), address(0xBF8822C0)));
typedef union {
  struct {
    uint32_t MRDD:16;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxMRDDbits_t;
extern volatile __EMACxMRDDbits_t EMACxMRDDbits __asm__ ("EMACxMRDD") __attribute__((section("sfrs"), address(0xBF8822C0)));
extern volatile uint32_t        EMAC1MRDDCLR __attribute__((section("sfrs"),address(0xBF8822C4)));
extern volatile uint32_t        EMACxMRDDCLR __attribute__((section("sfrs"),address(0xBF8822C4)));
extern volatile uint32_t        EMAC1MRDDSET __attribute__((section("sfrs"),address(0xBF8822C8)));
extern volatile uint32_t        EMACxMRDDSET __attribute__((section("sfrs"),address(0xBF8822C8)));
extern volatile uint32_t        EMAC1MRDDINV __attribute__((section("sfrs"),address(0xBF8822CC)));
extern volatile uint32_t        EMACxMRDDINV __attribute__((section("sfrs"),address(0xBF8822CC)));
#define EMAC1MIND EMAC1MIND
extern volatile uint32_t   EMAC1MIND __attribute__((section("sfrs"), address(0xBF8822D0)));
typedef union {
  struct {
    uint32_t MIIMBUSY:1;
    uint32_t SCAN:1;
    uint32_t NOTVALID:1;
    uint32_t LINKFAIL:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1MINDbits_t;
extern volatile __EMAC1MINDbits_t EMAC1MINDbits __asm__ ("EMAC1MIND") __attribute__((section("sfrs"), address(0xBF8822D0)));
#define EMACxMIND EMACxMIND
extern volatile uint32_t   EMACxMIND __attribute__((section("sfrs"), address(0xBF8822D0)));
typedef union {
  struct {
    uint32_t MIIMBUSY:1;
    uint32_t SCAN:1;
    uint32_t NOTVALID:1;
    uint32_t LINKFAIL:1;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxMINDbits_t;
extern volatile __EMACxMINDbits_t EMACxMINDbits __asm__ ("EMACxMIND") __attribute__((section("sfrs"), address(0xBF8822D0)));
extern volatile uint32_t        EMAC1MINDCLR __attribute__((section("sfrs"),address(0xBF8822D4)));
extern volatile uint32_t        EMACxMINDCLR __attribute__((section("sfrs"),address(0xBF8822D4)));
extern volatile uint32_t        EMAC1MINDSET __attribute__((section("sfrs"),address(0xBF8822D8)));
extern volatile uint32_t        EMACxMINDSET __attribute__((section("sfrs"),address(0xBF8822D8)));
extern volatile uint32_t        EMAC1MINDINV __attribute__((section("sfrs"),address(0xBF8822DC)));
extern volatile uint32_t        EMACxMINDINV __attribute__((section("sfrs"),address(0xBF8822DC)));
#define EMAC1SA0 EMAC1SA0
extern volatile uint32_t   EMAC1SA0 __attribute__((section("sfrs"), address(0xBF882300)));
typedef union {
  struct {
    uint32_t STNADDR5:8;
    uint32_t STNADDR6:8;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1SA0bits_t;
extern volatile __EMAC1SA0bits_t EMAC1SA0bits __asm__ ("EMAC1SA0") __attribute__((section("sfrs"), address(0xBF882300)));
#define EMACxSA0 EMACxSA0
extern volatile uint32_t   EMACxSA0 __attribute__((section("sfrs"), address(0xBF882300)));
typedef union {
  struct {
    uint32_t STNADDR5:8;
    uint32_t STNADDR6:8;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxSA0bits_t;
extern volatile __EMACxSA0bits_t EMACxSA0bits __asm__ ("EMACxSA0") __attribute__((section("sfrs"), address(0xBF882300)));
extern volatile uint32_t        EMAC1SA0CLR __attribute__((section("sfrs"),address(0xBF882304)));
extern volatile uint32_t        EMACxSA0CLR __attribute__((section("sfrs"),address(0xBF882304)));
extern volatile uint32_t        EMAC1SA0SET __attribute__((section("sfrs"),address(0xBF882308)));
extern volatile uint32_t        EMACxSA0SET __attribute__((section("sfrs"),address(0xBF882308)));
extern volatile uint32_t        EMAC1SA0INV __attribute__((section("sfrs"),address(0xBF88230C)));
extern volatile uint32_t        EMACxSA0INV __attribute__((section("sfrs"),address(0xBF88230C)));
#define EMAC1SA1 EMAC1SA1
extern volatile uint32_t   EMAC1SA1 __attribute__((section("sfrs"), address(0xBF882310)));
typedef union {
  struct {
    uint32_t STNADDR3:8;
    uint32_t STNADDR4:8;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1SA1bits_t;
extern volatile __EMAC1SA1bits_t EMAC1SA1bits __asm__ ("EMAC1SA1") __attribute__((section("sfrs"), address(0xBF882310)));
#define EMACxSA1 EMACxSA1
extern volatile uint32_t   EMACxSA1 __attribute__((section("sfrs"), address(0xBF882310)));
typedef union {
  struct {
    uint32_t STNADDR3:8;
    uint32_t STNADDR4:8;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxSA1bits_t;
extern volatile __EMACxSA1bits_t EMACxSA1bits __asm__ ("EMACxSA1") __attribute__((section("sfrs"), address(0xBF882310)));
extern volatile uint32_t        EMAC1SA1CLR __attribute__((section("sfrs"),address(0xBF882314)));
extern volatile uint32_t        EMACxSA1CLR __attribute__((section("sfrs"),address(0xBF882314)));
extern volatile uint32_t        EMAC1SA1SET __attribute__((section("sfrs"),address(0xBF882318)));
extern volatile uint32_t        EMACxSA1SET __attribute__((section("sfrs"),address(0xBF882318)));
extern volatile uint32_t        EMAC1SA1INV __attribute__((section("sfrs"),address(0xBF88231C)));
extern volatile uint32_t        EMACxSA1INV __attribute__((section("sfrs"),address(0xBF88231C)));
#define EMAC1SA2 EMAC1SA2
extern volatile uint32_t   EMAC1SA2 __attribute__((section("sfrs"), address(0xBF882320)));
typedef union {
  struct {
    uint32_t STNADDR1:8;
    uint32_t STNADDR2:8;
  };
  struct {
    uint32_t w:32;
  };
} __EMAC1SA2bits_t;
extern volatile __EMAC1SA2bits_t EMAC1SA2bits __asm__ ("EMAC1SA2") __attribute__((section("sfrs"), address(0xBF882320)));
#define EMACxSA2 EMACxSA2
extern volatile uint32_t   EMACxSA2 __attribute__((section("sfrs"), address(0xBF882320)));
typedef union {
  struct {
    uint32_t STNADDR1:8;
    uint32_t STNADDR2:8;
  };
  struct {
    uint32_t w:32;
  };
} __EMACxSA2bits_t;
extern volatile __EMACxSA2bits_t EMACxSA2bits __asm__ ("EMACxSA2") __attribute__((section("sfrs"), address(0xBF882320)));
extern volatile uint32_t        EMAC1SA2CLR __attribute__((section("sfrs"),address(0xBF882324)));
extern volatile uint32_t        EMACxSA2CLR __attribute__((section("sfrs"),address(0xBF882324)));
extern volatile uint32_t        EMAC1SA2SET __attribute__((section("sfrs"),address(0xBF882328)));
extern volatile uint32_t        EMACxSA2SET __attribute__((section("sfrs"),address(0xBF882328)));
extern volatile uint32_t        EMAC1SA2INV __attribute__((section("sfrs"),address(0xBF88232C)));
extern volatile uint32_t        EMACxSA2INV __attribute__((section("sfrs"),address(0xBF88232C)));
#define USBCRCON USBCRCON
extern volatile uint32_t   USBCRCON __attribute__((section("sfrs"), address(0xBF884000)));
typedef struct {
  uint32_t USBWKUPEN:1;
  uint32_t USBRIE:1;
  uint32_t USBIE:1;
  uint32_t SENDMONEN:1;
  uint32_t BSVALMONEN:1;
  uint32_t ASVALMONEN:1;
  uint32_t VBUSMONEN:1;
  uint32_t PHYIDEN:1;
  uint32_t USBIDVAL:1;
  uint32_t USBIDOVEN:1;
  uint32_t :14;
  uint32_t USBWKUP:1;
  uint32_t USBRF:1;
  uint32_t USBIF:1;
} __USBCRCONbits_t;
extern volatile __USBCRCONbits_t USBCRCONbits __asm__ ("USBCRCON") __attribute__((section("sfrs"), address(0xBF884000)));
#define PRECON PRECON
extern volatile uint32_t   PRECON __attribute__((section("sfrs"), address(0xBF8E0000)));
typedef struct {
  uint32_t PFMWS:3;
  uint32_t :1;
  uint32_t PREFEN:2;
  uint32_t :20;
  uint32_t PFMSECEN:1;
} __PRECONbits_t;
extern volatile __PRECONbits_t PRECONbits __asm__ ("PRECON") __attribute__((section("sfrs"), address(0xBF8E0000)));
extern volatile uint32_t        PRECONCLR __attribute__((section("sfrs"),address(0xBF8E0004)));
extern volatile uint32_t        PRECONSET __attribute__((section("sfrs"),address(0xBF8E0008)));
extern volatile uint32_t        PRECONINV __attribute__((section("sfrs"),address(0xBF8E000C)));
#define PRESTAT PRESTAT
extern volatile uint32_t   PRESTAT __attribute__((section("sfrs"), address(0xBF8E0010)));
typedef struct {
  uint32_t PFMSECCNT:8;
  uint32_t :18;
  uint32_t PFMSEC:1;
  uint32_t PFMDED:1;
} __PRESTATbits_t;
extern volatile __PRESTATbits_t PRESTATbits __asm__ ("PRESTAT") __attribute__((section("sfrs"), address(0xBF8E0010)));
extern volatile uint32_t        PRESTATCLR __attribute__((section("sfrs"),address(0xBF8E0014)));
extern volatile uint32_t        PRESTATSET __attribute__((section("sfrs"),address(0xBF8E0018)));
extern volatile uint32_t        PRESTATINV __attribute__((section("sfrs"),address(0xBF8E001C)));
#define SQI1XCON1 SQI1XCON1
extern volatile uint32_t   SQI1XCON1 __attribute__((section("sfrs"), address(0xBF8E2000)));
typedef struct {
  uint32_t TYPECMD:2;
  uint32_t TYPEADDR:2;
  uint32_t TYPEMODE:2;
  uint32_t TYPEDUMMY:2;
  uint32_t TYPEDATA:2;
  uint32_t READOPCODE:8;
  uint32_t ADDRBYTES:3;
  uint32_t DUMMYBYTES:3;
  uint32_t DDRCMD:1;
  uint32_t DDRADDR:1;
  uint32_t DDRMODE:1;
  uint32_t DDRDUMMY:1;
  uint32_t DDRDATA:1;
  uint32_t SDRCMD:1;
} __SQI1XCON1bits_t;
extern volatile __SQI1XCON1bits_t SQI1XCON1bits __asm__ ("SQI1XCON1") __attribute__((section("sfrs"), address(0xBF8E2000)));
#define SQI1XCON2 SQI1XCON2
extern volatile uint32_t   SQI1XCON2 __attribute__((section("sfrs"), address(0xBF8E2004)));
typedef struct {
  uint32_t MODECODE:8;
  uint32_t MODEBYTES:2;
  uint32_t DEVSEL:2;
} __SQI1XCON2bits_t;
extern volatile __SQI1XCON2bits_t SQI1XCON2bits __asm__ ("SQI1XCON2") __attribute__((section("sfrs"), address(0xBF8E2004)));
#define SQI1CFG SQI1CFG
extern volatile uint32_t   SQI1CFG __attribute__((section("sfrs"), address(0xBF8E2008)));
typedef struct {
  uint32_t MODE:3;
  uint32_t CPHA:1;
  uint32_t CPOL:1;
  uint32_t LSBF:1;
  uint32_t :3;
  uint32_t WP:1;
  uint32_t HOLD:1;
  uint32_t :1;
  uint32_t BURSTEN:1;
  uint32_t :3;
  uint32_t RESET:1;
  uint32_t TXBUFRST:1;
  uint32_t RXBUFRST:1;
  uint32_t CONBUFRST:1;
  uint32_t DATAEN:2;
  uint32_t :1;
  uint32_t SQIEN:1;
  uint32_t CSEN:2;
} __SQI1CFGbits_t;
extern volatile __SQI1CFGbits_t SQI1CFGbits __asm__ ("SQI1CFG") __attribute__((section("sfrs"), address(0xBF8E2008)));
#define SQI1CON SQI1CON
extern volatile uint32_t   SQI1CON __attribute__((section("sfrs"), address(0xBF8E200C)));
typedef struct {
  uint32_t TXRXCOUNT:16;
  uint32_t CMDINIT:2;
  uint32_t LANEMODE:2;
  uint32_t DEVSEL:2;
  uint32_t DASSERT:1;
  uint32_t DDRMODE:1;
  uint32_t SCHECK:1;
} __SQI1CONbits_t;
extern volatile __SQI1CONbits_t SQI1CONbits __asm__ ("SQI1CON") __attribute__((section("sfrs"), address(0xBF8E200C)));
#define SQI1CLKCON SQI1CLKCON
extern volatile uint32_t   SQI1CLKCON __attribute__((section("sfrs"), address(0xBF8E2010)));
typedef struct {
  uint32_t EN:1;
  uint32_t STABLE:1;
  uint32_t :6;
  uint32_t CLKDIV:11;
} __SQI1CLKCONbits_t;
extern volatile __SQI1CLKCONbits_t SQI1CLKCONbits __asm__ ("SQI1CLKCON") __attribute__((section("sfrs"), address(0xBF8E2010)));
#define SQI1CMDTHR SQI1CMDTHR
extern volatile uint32_t   SQI1CMDTHR __attribute__((section("sfrs"), address(0xBF8E2014)));
typedef struct {
  uint32_t RXCMDTHR:6;
  uint32_t :2;
  uint32_t TXCMDTHR:6;
} __SQI1CMDTHRbits_t;
extern volatile __SQI1CMDTHRbits_t SQI1CMDTHRbits __asm__ ("SQI1CMDTHR") __attribute__((section("sfrs"), address(0xBF8E2014)));
#define SQI1INTTHR SQI1INTTHR
extern volatile uint32_t   SQI1INTTHR __attribute__((section("sfrs"), address(0xBF8E2018)));
typedef struct {
  uint32_t RXINTTHR:6;
  uint32_t :2;
  uint32_t TXINTTHR:6;
} __SQI1INTTHRbits_t;
extern volatile __SQI1INTTHRbits_t SQI1INTTHRbits __asm__ ("SQI1INTTHR") __attribute__((section("sfrs"), address(0xBF8E2018)));
#define SQI1INTEN SQI1INTEN
extern volatile uint32_t   SQI1INTEN __attribute__((section("sfrs"), address(0xBF8E201C)));
typedef struct {
  uint32_t TXEMPTYIE:1;
  uint32_t TXFULLIE:1;
  uint32_t TXTHRIE:1;
  uint32_t RXEMPTYIE:1;
  uint32_t RXFULLIE:1;
  uint32_t RXTHRIE:1;
  uint32_t CONFULLIE:1;
  uint32_t CONEMPTYIE:1;
  uint32_t CONTHRIE:1;
  uint32_t BDDONEIE:1;
  uint32_t PKTCOMPIE:1;
  uint32_t DMAEIE:1;
} __SQI1INTENbits_t;
extern volatile __SQI1INTENbits_t SQI1INTENbits __asm__ ("SQI1INTEN") __attribute__((section("sfrs"), address(0xBF8E201C)));
#define SQI1INTSTAT SQI1INTSTAT
extern volatile uint32_t   SQI1INTSTAT __attribute__((section("sfrs"), address(0xBF8E2020)));
typedef struct {
  uint32_t TXEMPTYIF:1;
  uint32_t TXFULLIF:1;
  uint32_t TXTHRIF:1;
  uint32_t RXEMPTYIF:1;
  uint32_t RXFULLIF:1;
  uint32_t RXTHRIF:1;
  uint32_t CONFULLIF:1;
  uint32_t CONEMPTYIF:1;
  uint32_t CONTHRIF:1;
  uint32_t BDDONEIF:1;
  uint32_t PKTCOMPIF:1;
  uint32_t DMAEIF:1;
} __SQI1INTSTATbits_t;
extern volatile __SQI1INTSTATbits_t SQI1INTSTATbits __asm__ ("SQI1INTSTAT") __attribute__((section("sfrs"), address(0xBF8E2020)));
#define SQI1TXDATA SQI1TXDATA
extern volatile uint32_t   SQI1TXDATA __attribute__((section("sfrs"), address(0xBF8E2024)));
typedef struct {
  uint32_t TXDATA:32;
} __SQI1TXDATAbits_t;
extern volatile __SQI1TXDATAbits_t SQI1TXDATAbits __asm__ ("SQI1TXDATA") __attribute__((section("sfrs"), address(0xBF8E2024)));
#define SQI1RXDATA SQI1RXDATA
extern volatile uint32_t   SQI1RXDATA __attribute__((section("sfrs"), address(0xBF8E2028)));
typedef struct {
  uint32_t RXDATA:32;
} __SQI1RXDATAbits_t;
extern volatile __SQI1RXDATAbits_t SQI1RXDATAbits __asm__ ("SQI1RXDATA") __attribute__((section("sfrs"), address(0xBF8E2028)));
#define SQI1STAT1 SQI1STAT1
extern volatile uint32_t   SQI1STAT1 __attribute__((section("sfrs"), address(0xBF8E202C)));
typedef struct {
  uint32_t RXBUFCNT:6;
  uint32_t :10;
  uint32_t TXBUFFREE:6;
} __SQI1STAT1bits_t;
extern volatile __SQI1STAT1bits_t SQI1STAT1bits __asm__ ("SQI1STAT1") __attribute__((section("sfrs"), address(0xBF8E202C)));
#define SQI1STAT2 SQI1STAT2
extern volatile uint32_t   SQI1STAT2 __attribute__((section("sfrs"), address(0xBF8E2030)));
typedef struct {
  uint32_t TXOV:1;
  uint32_t RXUN:1;
  uint32_t :1;
  uint32_t SQID0:1;
  uint32_t SQID1:1;
  uint32_t SQID2:1;
  uint32_t SQID3:1;
  uint32_t CONAVAIL:4;
  uint32_t :5;
  uint32_t CMDSTAT:2;
} __SQI1STAT2bits_t;
extern volatile __SQI1STAT2bits_t SQI1STAT2bits __asm__ ("SQI1STAT2") __attribute__((section("sfrs"), address(0xBF8E2030)));
#define SQI1BDCON SQI1BDCON
extern volatile uint32_t   SQI1BDCON __attribute__((section("sfrs"), address(0xBF8E2034)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t POLLEN:1;
  uint32_t START:1;
} __SQI1BDCONbits_t;
extern volatile __SQI1BDCONbits_t SQI1BDCONbits __asm__ ("SQI1BDCON") __attribute__((section("sfrs"), address(0xBF8E2034)));
#define SQI1BDCURADD SQI1BDCURADD
extern volatile uint32_t   SQI1BDCURADD __attribute__((section("sfrs"), address(0xBF8E2038)));
typedef struct {
  uint32_t BDCURRADDR:32;
} __SQI1BDCURADDbits_t;
extern volatile __SQI1BDCURADDbits_t SQI1BDCURADDbits __asm__ ("SQI1BDCURADD") __attribute__((section("sfrs"), address(0xBF8E2038)));
#define SQI1BDBASEADD SQI1BDBASEADD
extern volatile uint32_t   SQI1BDBASEADD __attribute__((section("sfrs"), address(0xBF8E2040)));
typedef struct {
  uint32_t BDADDR:32;
} __SQI1BDBASEADDbits_t;
extern volatile __SQI1BDBASEADDbits_t SQI1BDBASEADDbits __asm__ ("SQI1BDBASEADD") __attribute__((section("sfrs"), address(0xBF8E2040)));
#define SQI1BDSTAT SQI1BDSTAT
extern volatile uint32_t   SQI1BDSTAT __attribute__((section("sfrs"), address(0xBF8E2044)));
typedef struct {
  uint32_t BDCON:16;
  uint32_t DMAACTV:1;
  uint32_t DMASTART:1;
  uint32_t BDSTATE:4;
} __SQI1BDSTATbits_t;
extern volatile __SQI1BDSTATbits_t SQI1BDSTATbits __asm__ ("SQI1BDSTAT") __attribute__((section("sfrs"), address(0xBF8E2044)));
#define SQI1BDPOLLCON SQI1BDPOLLCON
extern volatile uint32_t   SQI1BDPOLLCON __attribute__((section("sfrs"), address(0xBF8E2048)));
typedef struct {
  uint32_t POLLCON:16;
} __SQI1BDPOLLCONbits_t;
extern volatile __SQI1BDPOLLCONbits_t SQI1BDPOLLCONbits __asm__ ("SQI1BDPOLLCON") __attribute__((section("sfrs"), address(0xBF8E2048)));
#define SQI1BDTXDSTAT SQI1BDTXDSTAT
extern volatile uint32_t   SQI1BDTXDSTAT __attribute__((section("sfrs"), address(0xBF8E204C)));
typedef struct {
  uint32_t TXCURBUFLEN:9;
  uint32_t :7;
  uint32_t TXBUFCNT:5;
  uint32_t :4;
  uint32_t TXSTATE:4;
} __SQI1BDTXDSTATbits_t;
extern volatile __SQI1BDTXDSTATbits_t SQI1BDTXDSTATbits __asm__ ("SQI1BDTXDSTAT") __attribute__((section("sfrs"), address(0xBF8E204C)));
#define SQI1BDRXDSTAT SQI1BDRXDSTAT
extern volatile uint32_t   SQI1BDRXDSTAT __attribute__((section("sfrs"), address(0xBF8E2050)));
typedef struct {
  uint32_t RXCURBUFLEN:9;
  uint32_t :7;
  uint32_t RXBUFCNT:5;
  uint32_t :4;
  uint32_t RXSTATE:4;
} __SQI1BDRXDSTATbits_t;
extern volatile __SQI1BDRXDSTATbits_t SQI1BDRXDSTATbits __asm__ ("SQI1BDRXDSTAT") __attribute__((section("sfrs"), address(0xBF8E2050)));
#define SQI1THR SQI1THR
extern volatile uint32_t   SQI1THR __attribute__((section("sfrs"), address(0xBF8E2054)));
typedef struct {
  uint32_t THRES:4;
} __SQI1THRbits_t;
extern volatile __SQI1THRbits_t SQI1THRbits __asm__ ("SQI1THR") __attribute__((section("sfrs"), address(0xBF8E2054)));
#define SQI1INTSIGEN SQI1INTSIGEN
extern volatile uint32_t   SQI1INTSIGEN __attribute__((section("sfrs"), address(0xBF8E2058)));
typedef struct {
  uint32_t TXEMPTYISE:1;
  uint32_t TXFULLISE:1;
  uint32_t TXTHRISE:1;
  uint32_t RXEMPTYISE:1;
  uint32_t RXFULLISE:1;
  uint32_t RXTHRISE:1;
  uint32_t CONFULLISE:1;
  uint32_t CONEMPTYISE:1;
  uint32_t CONTHRISE:1;
  uint32_t BDDONEISE:1;
  uint32_t PKTCOMPISE:1;
  uint32_t DMAEISE:1;
} __SQI1INTSIGENbits_t;
extern volatile __SQI1INTSIGENbits_t SQI1INTSIGENbits __asm__ ("SQI1INTSIGEN") __attribute__((section("sfrs"), address(0xBF8E2058)));
#define SQI1TAPCON SQI1TAPCON
extern volatile uint32_t   SQI1TAPCON __attribute__((section("sfrs"), address(0xBF8E205C)));
typedef struct {
  uint32_t CLKOUTDLY:4;
  uint32_t DATAOUTDLY:4;
  uint32_t SDRCLKINDLY:6;
} __SQI1TAPCONbits_t;
extern volatile __SQI1TAPCONbits_t SQI1TAPCONbits __asm__ ("SQI1TAPCON") __attribute__((section("sfrs"), address(0xBF8E205C)));
#define SQI1MEMSTAT SQI1MEMSTAT
extern volatile uint32_t   SQI1MEMSTAT __attribute__((section("sfrs"), address(0xBF8E2060)));
typedef struct {
  uint32_t STATCMD:16;
  uint32_t STATBYTES:2;
  uint32_t STATTYPE:2;
  uint32_t STATPOS:1;
} __SQI1MEMSTATbits_t;
extern volatile __SQI1MEMSTATbits_t SQI1MEMSTATbits __asm__ ("SQI1MEMSTAT") __attribute__((section("sfrs"), address(0xBF8E2060)));
#define SQI1XCON3 SQI1XCON3
extern volatile uint32_t   SQI1XCON3 __attribute__((section("sfrs"), address(0xBF8E2064)));
typedef struct {
  uint32_t INIT1CMD1:8;
  uint32_t INIT1CMD2:8;
  uint32_t INIT1CMD3:8;
  uint32_t INIT1TYPE:2;
  uint32_t INIT1COUNT:2;
  uint32_t INIT1SCHECK:1;
} __SQI1XCON3bits_t;
extern volatile __SQI1XCON3bits_t SQI1XCON3bits __asm__ ("SQI1XCON3") __attribute__((section("sfrs"), address(0xBF8E2064)));
#define SQI1XCON4 SQI1XCON4
extern volatile uint32_t   SQI1XCON4 __attribute__((section("sfrs"), address(0xBF8E2068)));
typedef struct {
  uint32_t INIT2CMD1:8;
  uint32_t INIT2CMD2:8;
  uint32_t INIT2CMD3:8;
  uint32_t INIT2TYPE:2;
  uint32_t INIT2COUNT:2;
  uint32_t INIT2SCHECK:1;
} __SQI1XCON4bits_t;
extern volatile __SQI1XCON4bits_t SQI1XCON4bits __asm__ ("SQI1XCON4") __attribute__((section("sfrs"), address(0xBF8E2068)));
#define USBCSR0 USBCSR0
extern volatile uint32_t   USBCSR0 __attribute__((section("sfrs"), address(0xBF8E3000)));
typedef struct {
  uint32_t FUNC:7;
  uint32_t :1;
  uint32_t SUSPEN:1;
  uint32_t SUSPMODE:1;
  uint32_t RESUME:1;
  uint32_t RESET:1;
  uint32_t HSMODE:1;
  uint32_t HSEN:1;
  uint32_t SOFTCONN:1;
  uint32_t ISOUPD:1;
  uint32_t EP0IF:1;
  uint32_t EP1TXIF:1;
  uint32_t EP2TXIF:1;
  uint32_t EP3TXIF:1;
  uint32_t EP4TXIF:1;
  uint32_t EP5TXIF:1;
  uint32_t EP6TXIF:1;
  uint32_t EP7TXIF:1;
} __USBCSR0bits_t;
extern volatile __USBCSR0bits_t USBCSR0bits __asm__ ("USBCSR0") __attribute__((section("sfrs"), address(0xBF8E3000)));
#define USBCSR1 USBCSR1
extern volatile uint32_t   USBCSR1 __attribute__((section("sfrs"), address(0xBF8E3004)));
typedef struct {
  uint32_t :1;
  uint32_t EP1RXIF:1;
  uint32_t EP2RXIF:1;
  uint32_t EP3RXIF:1;
  uint32_t EP4RXIF:1;
  uint32_t EP5RXIF:1;
  uint32_t EP6RXIF:1;
  uint32_t EP7RXIF:1;
  uint32_t :8;
  uint32_t EP0IE:1;
  uint32_t EP1TXIE:1;
  uint32_t EP2TXIE:1;
  uint32_t EP3TXIE:1;
  uint32_t EP4TXIE:1;
  uint32_t EP5TXIE:1;
  uint32_t EP6TXIE:1;
  uint32_t EP7TXIE:1;
} __USBCSR1bits_t;
extern volatile __USBCSR1bits_t USBCSR1bits __asm__ ("USBCSR1") __attribute__((section("sfrs"), address(0xBF8E3004)));
#define USBCSR2 USBCSR2
extern volatile uint32_t   USBCSR2 __attribute__((section("sfrs"), address(0xBF8E3008)));
typedef struct {
  uint32_t :1;
  uint32_t EP1RXIE:1;
  uint32_t EP2RXIE:1;
  uint32_t EP3RXIE:1;
  uint32_t EP4RXIE:1;
  uint32_t EP5RXIE:1;
  uint32_t EP6RXIE:1;
  uint32_t EP7RXIE:1;
  uint32_t :8;
  uint32_t SUSPIF:1;
  uint32_t RESUMEIF:1;
  uint32_t RESETIF:1;
  uint32_t SOFIF:1;
  uint32_t CONNIF:1;
  uint32_t DISCONIF:1;
  uint32_t SESSRQIF:1;
  uint32_t VBUSERRIF:1;
  uint32_t SUSPIE:1;
  uint32_t RESUMEIE:1;
  uint32_t RESETIE:1;
  uint32_t SOFIE:1;
  uint32_t CONNIE:1;
  uint32_t DISCONIE:1;
  uint32_t SESSRQIE:1;
  uint32_t VBUSERRIE:1;
} __USBCSR2bits_t;
extern volatile __USBCSR2bits_t USBCSR2bits __asm__ ("USBCSR2") __attribute__((section("sfrs"), address(0xBF8E3008)));
#define USBCSR3 USBCSR3
extern volatile uint32_t   USBCSR3 __attribute__((section("sfrs"), address(0xBF8E300C)));
typedef struct {
  uint32_t RFRMNUM:11;
  uint32_t :5;
  uint32_t ENDPOINT:4;
  uint32_t :4;
  uint32_t NAK:1;
  uint32_t TESTJ:1;
  uint32_t TESTK:1;
  uint32_t PACKET:1;
  uint32_t FORCEHS:1;
  uint32_t FORCEFS:1;
  uint32_t FIFOACC:1;
  uint32_t FORCEHST:1;
} __USBCSR3bits_t;
extern volatile __USBCSR3bits_t USBCSR3bits __asm__ ("USBCSR3") __attribute__((section("sfrs"), address(0xBF8E300C)));
#define USBIENCSR1 USBIENCSR1
extern volatile uint32_t   USBIENCSR1 __attribute__((section("sfrs"), address(0xBF8E3014)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t OVERRUN:1;
    uint32_t DATAERR:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :5;
    uint32_t DISNYET:1;
    uint32_t :1;
    uint32_t ISO:1;
  };
} __USBIENCSR1bits_t;
extern volatile __USBIENCSR1bits_t USBIENCSR1bits __asm__ ("USBIENCSR1") __attribute__((section("sfrs"), address(0xBF8E3014)));
#define USBFIFO0 USBFIFO0
extern volatile uint32_t   USBFIFO0 __attribute__((section("sfrs"), address(0xBF8E3020)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO0bits_t;
extern volatile __USBFIFO0bits_t USBFIFO0bits __asm__ ("USBFIFO0") __attribute__((section("sfrs"), address(0xBF8E3020)));
#define USBFIFO1 USBFIFO1
extern volatile uint32_t   USBFIFO1 __attribute__((section("sfrs"), address(0xBF8E3024)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO1bits_t;
extern volatile __USBFIFO1bits_t USBFIFO1bits __asm__ ("USBFIFO1") __attribute__((section("sfrs"), address(0xBF8E3024)));
#define USBFIFO2 USBFIFO2
extern volatile uint32_t   USBFIFO2 __attribute__((section("sfrs"), address(0xBF8E3028)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO2bits_t;
extern volatile __USBFIFO2bits_t USBFIFO2bits __asm__ ("USBFIFO2") __attribute__((section("sfrs"), address(0xBF8E3028)));
#define USBFIFO3 USBFIFO3
extern volatile uint32_t   USBFIFO3 __attribute__((section("sfrs"), address(0xBF8E302C)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO3bits_t;
extern volatile __USBFIFO3bits_t USBFIFO3bits __asm__ ("USBFIFO3") __attribute__((section("sfrs"), address(0xBF8E302C)));
#define USBFIFO4 USBFIFO4
extern volatile uint32_t   USBFIFO4 __attribute__((section("sfrs"), address(0xBF8E3030)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO4bits_t;
extern volatile __USBFIFO4bits_t USBFIFO4bits __asm__ ("USBFIFO4") __attribute__((section("sfrs"), address(0xBF8E3030)));
#define USBFIFO5 USBFIFO5
extern volatile uint32_t   USBFIFO5 __attribute__((section("sfrs"), address(0xBF8E3034)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO5bits_t;
extern volatile __USBFIFO5bits_t USBFIFO5bits __asm__ ("USBFIFO5") __attribute__((section("sfrs"), address(0xBF8E3034)));
#define USBFIFO6 USBFIFO6
extern volatile uint32_t   USBFIFO6 __attribute__((section("sfrs"), address(0xBF8E3038)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO6bits_t;
extern volatile __USBFIFO6bits_t USBFIFO6bits __asm__ ("USBFIFO6") __attribute__((section("sfrs"), address(0xBF8E3038)));
#define USBFIFO7 USBFIFO7
extern volatile uint32_t   USBFIFO7 __attribute__((section("sfrs"), address(0xBF8E303C)));
typedef struct {
  uint32_t DATA:32;
} __USBFIFO7bits_t;
extern volatile __USBFIFO7bits_t USBFIFO7bits __asm__ ("USBFIFO7") __attribute__((section("sfrs"), address(0xBF8E303C)));
#define USBOTG USBOTG
extern volatile uint32_t   USBOTG __attribute__((section("sfrs"), address(0xBF8E3060)));
typedef struct {
  uint32_t SESSION:1;
  uint32_t HOSTREQ:1;
  uint32_t HOSTMODE:1;
  uint32_t VBUS:2;
  uint32_t LSDEV:1;
  uint32_t FSDEV:1;
  uint32_t BDEV:1;
  uint32_t RXEDMA:1;
  uint32_t TXEDMA:1;
  uint32_t :6;
  uint32_t TXFIFOSZ:4;
  uint32_t TXDPB:1;
  uint32_t :3;
  uint32_t RXFIFOSZ:4;
  uint32_t RXDPB:1;
} __USBOTGbits_t;
extern volatile __USBOTGbits_t USBOTGbits __asm__ ("USBOTG") __attribute__((section("sfrs"), address(0xBF8E3060)));
#define USBFIFOA USBFIFOA
extern volatile uint32_t   USBFIFOA __attribute__((section("sfrs"), address(0xBF8E3064)));
typedef struct {
  uint32_t TXFIFOAD:13;
  uint32_t :3;
  uint32_t RXFIFOAD:13;
} __USBFIFOAbits_t;
extern volatile __USBFIFOAbits_t USBFIFOAbits __asm__ ("USBFIFOA") __attribute__((section("sfrs"), address(0xBF8E3064)));
#define USBHWVER USBHWVER
extern volatile uint32_t   USBHWVER __attribute__((section("sfrs"), address(0xBF8E306C)));
typedef struct {
  uint32_t VERMINOR:10;
  uint32_t VERMAJOR:5;
  uint32_t RC:1;
} __USBHWVERbits_t;
extern volatile __USBHWVERbits_t USBHWVERbits __asm__ ("USBHWVER") __attribute__((section("sfrs"), address(0xBF8E306C)));
#define USBINFO USBINFO
extern volatile uint32_t   USBINFO __attribute__((section("sfrs"), address(0xBF8E3078)));
typedef struct {
  uint32_t TXENDPTS:4;
  uint32_t RXENDPTS:4;
  uint32_t RAMBITS:4;
  uint32_t DMACHANS:4;
  uint32_t WTID:4;
  uint32_t WTCON:4;
  uint32_t VPLEN:8;
} __USBINFObits_t;
extern volatile __USBINFObits_t USBINFObits __asm__ ("USBINFO") __attribute__((section("sfrs"), address(0xBF8E3078)));
#define USBEOFRST USBEOFRST
extern volatile uint32_t   USBEOFRST __attribute__((section("sfrs"), address(0xBF8E307C)));
typedef union {
  struct {
    uint32_t HSEOF:8;
    uint32_t FSEOF:8;
    uint32_t LSEOF:8;
    uint32_t NRST:1;
    uint32_t NRSTX:1;
  };
  struct {
    uint32_t :24;
    uint32_t SOFRST:8;
  };
} __USBEOFRSTbits_t;
extern volatile __USBEOFRSTbits_t USBEOFRSTbits __asm__ ("USBEOFRST") __attribute__((section("sfrs"), address(0xBF8E307C)));
#define USBE0TXA USBE0TXA
extern volatile uint32_t   USBE0TXA __attribute__((section("sfrs"), address(0xBF8E3080)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE0TXAbits_t;
extern volatile __USBE0TXAbits_t USBE0TXAbits __asm__ ("USBE0TXA") __attribute__((section("sfrs"), address(0xBF8E3080)));
#define USBE0RXA USBE0RXA
extern volatile uint32_t   USBE0RXA __attribute__((section("sfrs"), address(0xBF8E3084)));
typedef struct {
  uint32_t :16;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE0RXAbits_t;
extern volatile __USBE0RXAbits_t USBE0RXAbits __asm__ ("USBE0RXA") __attribute__((section("sfrs"), address(0xBF8E3084)));
#define USBE1TXA USBE1TXA
extern volatile uint32_t   USBE1TXA __attribute__((section("sfrs"), address(0xBF8E3088)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE1TXAbits_t;
extern volatile __USBE1TXAbits_t USBE1TXAbits __asm__ ("USBE1TXA") __attribute__((section("sfrs"), address(0xBF8E3088)));
#define USBE1RXA USBE1RXA
extern volatile uint32_t   USBE1RXA __attribute__((section("sfrs"), address(0xBF8E308C)));
typedef struct {
  uint32_t RXFADDR:7;
  uint32_t :9;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE1RXAbits_t;
extern volatile __USBE1RXAbits_t USBE1RXAbits __asm__ ("USBE1RXA") __attribute__((section("sfrs"), address(0xBF8E308C)));
#define USBE2TXA USBE2TXA
extern volatile uint32_t   USBE2TXA __attribute__((section("sfrs"), address(0xBF8E3090)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE2TXAbits_t;
extern volatile __USBE2TXAbits_t USBE2TXAbits __asm__ ("USBE2TXA") __attribute__((section("sfrs"), address(0xBF8E3090)));
#define USBE2RXA USBE2RXA
extern volatile uint32_t   USBE2RXA __attribute__((section("sfrs"), address(0xBF8E3094)));
typedef struct {
  uint32_t RXFADDR:7;
  uint32_t :9;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE2RXAbits_t;
extern volatile __USBE2RXAbits_t USBE2RXAbits __asm__ ("USBE2RXA") __attribute__((section("sfrs"), address(0xBF8E3094)));
#define USBE3TXA USBE3TXA
extern volatile uint32_t   USBE3TXA __attribute__((section("sfrs"), address(0xBF8E3098)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE3TXAbits_t;
extern volatile __USBE3TXAbits_t USBE3TXAbits __asm__ ("USBE3TXA") __attribute__((section("sfrs"), address(0xBF8E3098)));
#define USBE3RXA USBE3RXA
extern volatile uint32_t   USBE3RXA __attribute__((section("sfrs"), address(0xBF8E309C)));
typedef struct {
  uint32_t RXFADDR:7;
  uint32_t :9;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE3RXAbits_t;
extern volatile __USBE3RXAbits_t USBE3RXAbits __asm__ ("USBE3RXA") __attribute__((section("sfrs"), address(0xBF8E309C)));
#define USBE4TXA USBE4TXA
extern volatile uint32_t   USBE4TXA __attribute__((section("sfrs"), address(0xBF8E30A0)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE4TXAbits_t;
extern volatile __USBE4TXAbits_t USBE4TXAbits __asm__ ("USBE4TXA") __attribute__((section("sfrs"), address(0xBF8E30A0)));
#define USBE4RXA USBE4RXA
extern volatile uint32_t   USBE4RXA __attribute__((section("sfrs"), address(0xBF8E30A4)));
typedef struct {
  uint32_t RXFADDR:7;
  uint32_t :9;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE4RXAbits_t;
extern volatile __USBE4RXAbits_t USBE4RXAbits __asm__ ("USBE4RXA") __attribute__((section("sfrs"), address(0xBF8E30A4)));
#define USBE5TXA USBE5TXA
extern volatile uint32_t   USBE5TXA __attribute__((section("sfrs"), address(0xBF8E30A8)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE5TXAbits_t;
extern volatile __USBE5TXAbits_t USBE5TXAbits __asm__ ("USBE5TXA") __attribute__((section("sfrs"), address(0xBF8E30A8)));
#define USBE5RXA USBE5RXA
extern volatile uint32_t   USBE5RXA __attribute__((section("sfrs"), address(0xBF8E30AC)));
typedef struct {
  uint32_t RXFADDR:7;
  uint32_t :9;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE5RXAbits_t;
extern volatile __USBE5RXAbits_t USBE5RXAbits __asm__ ("USBE5RXA") __attribute__((section("sfrs"), address(0xBF8E30AC)));
#define USBE6TXA USBE6TXA
extern volatile uint32_t   USBE6TXA __attribute__((section("sfrs"), address(0xBF8E30B0)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE6TXAbits_t;
extern volatile __USBE6TXAbits_t USBE6TXAbits __asm__ ("USBE6TXA") __attribute__((section("sfrs"), address(0xBF8E30B0)));
#define USBE6RXA USBE6RXA
extern volatile uint32_t   USBE6RXA __attribute__((section("sfrs"), address(0xBF8E30B4)));
typedef struct {
  uint32_t RXFADDR:7;
  uint32_t :9;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE6RXAbits_t;
extern volatile __USBE6RXAbits_t USBE6RXAbits __asm__ ("USBE6RXA") __attribute__((section("sfrs"), address(0xBF8E30B4)));
#define USBE7TXA USBE7TXA
extern volatile uint32_t   USBE7TXA __attribute__((section("sfrs"), address(0xBF8E30B8)));
typedef struct {
  uint32_t TXFADDR:7;
  uint32_t :9;
  uint32_t TXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t TXHUBPRT:7;
} __USBE7TXAbits_t;
extern volatile __USBE7TXAbits_t USBE7TXAbits __asm__ ("USBE7TXA") __attribute__((section("sfrs"), address(0xBF8E30B8)));
#define USBE7RXA USBE7RXA
extern volatile uint32_t   USBE7RXA __attribute__((section("sfrs"), address(0xBF8E30BC)));
typedef struct {
  uint32_t RXFADDR:7;
  uint32_t :9;
  uint32_t RXHUBADD:7;
  uint32_t MULTTRAN:1;
  uint32_t RXHUBPRT:7;
} __USBE7RXAbits_t;
extern volatile __USBE7RXAbits_t USBE7RXAbits __asm__ ("USBE7RXA") __attribute__((section("sfrs"), address(0xBF8E30BC)));
#define USBE0CSR0 USBE0CSR0
extern volatile uint32_t   USBE0CSR0 __attribute__((section("sfrs"), address(0xBF8E3100)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t :5;
    uint32_t RXRDY:1;
    uint32_t TXRDY:1;
    uint32_t STALLED:1;
    uint32_t SETUP:1;
    uint32_t ERROR:1;
    uint32_t REQPKT:1;
    uint32_t STATUS:1;
    uint32_t NAKTO:1;
    uint32_t FLUSH:1;
    uint32_t DT:1;
    uint32_t DTWE:1;
  };
  struct {
    uint32_t :19;
    uint32_t DATAEND:1;
    uint32_t SETEND:1;
    uint32_t STALL:1;
    uint32_t RXRDYC:1;
    uint32_t SETENDC:1;
  };
} __USBE0CSR0bits_t;
extern volatile __USBE0CSR0bits_t USBE0CSR0bits __asm__ ("USBE0CSR0") __attribute__((section("sfrs"), address(0xBF8E3100)));
#define USBE0CSR2 USBE0CSR2
extern volatile uint32_t   USBE0CSR2 __attribute__((section("sfrs"), address(0xBF8E3108)));
typedef struct {
  uint32_t RXCNT:7;
  uint32_t :15;
  uint32_t SPEED:2;
  uint32_t NAKLIM:4;
} __USBE0CSR2bits_t;
extern volatile __USBE0CSR2bits_t USBE0CSR2bits __asm__ ("USBE0CSR2") __attribute__((section("sfrs"), address(0xBF8E3108)));
#define USBE0CSR3 USBE0CSR3
extern volatile uint32_t   USBE0CSR3 __attribute__((section("sfrs"), address(0xBF8E310C)));
typedef struct {
  uint32_t :24;
  uint32_t UTMIDWID:1;
  uint32_t SOFTCONE:1;
  uint32_t DYNFIFOS:1;
  uint32_t HBTXEN:1;
  uint32_t HBRXEN:1;
  uint32_t BIGEND:1;
  uint32_t MPTXEN:1;
  uint32_t MPRXEN:1;
} __USBE0CSR3bits_t;
extern volatile __USBE0CSR3bits_t USBE0CSR3bits __asm__ ("USBE0CSR3") __attribute__((section("sfrs"), address(0xBF8E310C)));
#define USBE1CSR0 USBE1CSR0
extern volatile uint32_t   USBE1CSR0 __attribute__((section("sfrs"), address(0xBF8E3110)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE1CSR0bits_t;
extern volatile __USBE1CSR0bits_t USBE1CSR0bits __asm__ ("USBE1CSR0") __attribute__((section("sfrs"), address(0xBF8E3110)));
#define USBE1CSR1 USBE1CSR1
extern volatile uint32_t   USBE1CSR1 __attribute__((section("sfrs"), address(0xBF8E3114)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE1CSR1bits_t;
extern volatile __USBE1CSR1bits_t USBE1CSR1bits __asm__ ("USBE1CSR1") __attribute__((section("sfrs"), address(0xBF8E3114)));
#define USBE1CSR2 USBE1CSR2
extern volatile uint32_t   USBE1CSR2 __attribute__((section("sfrs"), address(0xBF8E3118)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBE1CSR2bits_t;
extern volatile __USBE1CSR2bits_t USBE1CSR2bits __asm__ ("USBE1CSR2") __attribute__((section("sfrs"), address(0xBF8E3118)));
#define USBE1CSR3 USBE1CSR3
extern volatile uint32_t   USBE1CSR3 __attribute__((section("sfrs"), address(0xBF8E311C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBE1CSR3bits_t;
extern volatile __USBE1CSR3bits_t USBE1CSR3bits __asm__ ("USBE1CSR3") __attribute__((section("sfrs"), address(0xBF8E311C)));
#define USBE2CSR0 USBE2CSR0
extern volatile uint32_t   USBE2CSR0 __attribute__((section("sfrs"), address(0xBF8E3120)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE2CSR0bits_t;
extern volatile __USBE2CSR0bits_t USBE2CSR0bits __asm__ ("USBE2CSR0") __attribute__((section("sfrs"), address(0xBF8E3120)));
#define USBE2CSR1 USBE2CSR1
extern volatile uint32_t   USBE2CSR1 __attribute__((section("sfrs"), address(0xBF8E3124)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE2CSR1bits_t;
extern volatile __USBE2CSR1bits_t USBE2CSR1bits __asm__ ("USBE2CSR1") __attribute__((section("sfrs"), address(0xBF8E3124)));
#define USBE2CSR2 USBE2CSR2
extern volatile uint32_t   USBE2CSR2 __attribute__((section("sfrs"), address(0xBF8E3128)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBE2CSR2bits_t;
extern volatile __USBE2CSR2bits_t USBE2CSR2bits __asm__ ("USBE2CSR2") __attribute__((section("sfrs"), address(0xBF8E3128)));
#define USBE2CSR3 USBE2CSR3
extern volatile uint32_t   USBE2CSR3 __attribute__((section("sfrs"), address(0xBF8E312C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBE2CSR3bits_t;
extern volatile __USBE2CSR3bits_t USBE2CSR3bits __asm__ ("USBE2CSR3") __attribute__((section("sfrs"), address(0xBF8E312C)));
#define USBE3CSR0 USBE3CSR0
extern volatile uint32_t   USBE3CSR0 __attribute__((section("sfrs"), address(0xBF8E3130)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE3CSR0bits_t;
extern volatile __USBE3CSR0bits_t USBE3CSR0bits __asm__ ("USBE3CSR0") __attribute__((section("sfrs"), address(0xBF8E3130)));
#define USBE3CSR1 USBE3CSR1
extern volatile uint32_t   USBE3CSR1 __attribute__((section("sfrs"), address(0xBF8E3134)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE3CSR1bits_t;
extern volatile __USBE3CSR1bits_t USBE3CSR1bits __asm__ ("USBE3CSR1") __attribute__((section("sfrs"), address(0xBF8E3134)));
#define USBE3CSR2 USBE3CSR2
extern volatile uint32_t   USBE3CSR2 __attribute__((section("sfrs"), address(0xBF8E3138)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBE3CSR2bits_t;
extern volatile __USBE3CSR2bits_t USBE3CSR2bits __asm__ ("USBE3CSR2") __attribute__((section("sfrs"), address(0xBF8E3138)));
#define USBE3CSR3 USBE3CSR3
extern volatile uint32_t   USBE3CSR3 __attribute__((section("sfrs"), address(0xBF8E313C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBE3CSR3bits_t;
extern volatile __USBE3CSR3bits_t USBE3CSR3bits __asm__ ("USBE3CSR3") __attribute__((section("sfrs"), address(0xBF8E313C)));
#define USBE4CSR0 USBE4CSR0
extern volatile uint32_t   USBE4CSR0 __attribute__((section("sfrs"), address(0xBF8E3140)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE4CSR0bits_t;
extern volatile __USBE4CSR0bits_t USBE4CSR0bits __asm__ ("USBE4CSR0") __attribute__((section("sfrs"), address(0xBF8E3140)));
#define USBE4CSR1 USBE4CSR1
extern volatile uint32_t   USBE4CSR1 __attribute__((section("sfrs"), address(0xBF8E3144)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE4CSR1bits_t;
extern volatile __USBE4CSR1bits_t USBE4CSR1bits __asm__ ("USBE4CSR1") __attribute__((section("sfrs"), address(0xBF8E3144)));
#define USBE4CSR2 USBE4CSR2
extern volatile uint32_t   USBE4CSR2 __attribute__((section("sfrs"), address(0xBF8E3148)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBE4CSR2bits_t;
extern volatile __USBE4CSR2bits_t USBE4CSR2bits __asm__ ("USBE4CSR2") __attribute__((section("sfrs"), address(0xBF8E3148)));
#define USBE4CSR3 USBE4CSR3
extern volatile uint32_t   USBE4CSR3 __attribute__((section("sfrs"), address(0xBF8E314C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBE4CSR3bits_t;
extern volatile __USBE4CSR3bits_t USBE4CSR3bits __asm__ ("USBE4CSR3") __attribute__((section("sfrs"), address(0xBF8E314C)));
#define USBE5CSR0 USBE5CSR0
extern volatile uint32_t   USBE5CSR0 __attribute__((section("sfrs"), address(0xBF8E3150)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE5CSR0bits_t;
extern volatile __USBE5CSR0bits_t USBE5CSR0bits __asm__ ("USBE5CSR0") __attribute__((section("sfrs"), address(0xBF8E3150)));
#define USBE5CSR1 USBE5CSR1
extern volatile uint32_t   USBE5CSR1 __attribute__((section("sfrs"), address(0xBF8E3154)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE5CSR1bits_t;
extern volatile __USBE5CSR1bits_t USBE5CSR1bits __asm__ ("USBE5CSR1") __attribute__((section("sfrs"), address(0xBF8E3154)));
#define USBE5CSR2 USBE5CSR2
extern volatile uint32_t   USBE5CSR2 __attribute__((section("sfrs"), address(0xBF8E3158)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBE5CSR2bits_t;
extern volatile __USBE5CSR2bits_t USBE5CSR2bits __asm__ ("USBE5CSR2") __attribute__((section("sfrs"), address(0xBF8E3158)));
#define USBE5CSR3 USBE5CSR3
extern volatile uint32_t   USBE5CSR3 __attribute__((section("sfrs"), address(0xBF8E315C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBE5CSR3bits_t;
extern volatile __USBE5CSR3bits_t USBE5CSR3bits __asm__ ("USBE5CSR3") __attribute__((section("sfrs"), address(0xBF8E315C)));
#define USBE6CSR0 USBE6CSR0
extern volatile uint32_t   USBE6CSR0 __attribute__((section("sfrs"), address(0xBF8E3160)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE6CSR0bits_t;
extern volatile __USBE6CSR0bits_t USBE6CSR0bits __asm__ ("USBE6CSR0") __attribute__((section("sfrs"), address(0xBF8E3160)));
#define USBE6CSR1 USBE6CSR1
extern volatile uint32_t   USBE6CSR1 __attribute__((section("sfrs"), address(0xBF8E3164)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE6CSR1bits_t;
extern volatile __USBE6CSR1bits_t USBE6CSR1bits __asm__ ("USBE6CSR1") __attribute__((section("sfrs"), address(0xBF8E3164)));
#define USBE6CSR2 USBE6CSR2
extern volatile uint32_t   USBE6CSR2 __attribute__((section("sfrs"), address(0xBF8E3168)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBE6CSR2bits_t;
extern volatile __USBE6CSR2bits_t USBE6CSR2bits __asm__ ("USBE6CSR2") __attribute__((section("sfrs"), address(0xBF8E3168)));
#define USBE6CSR3 USBE6CSR3
extern volatile uint32_t   USBE6CSR3 __attribute__((section("sfrs"), address(0xBF8E316C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBE6CSR3bits_t;
extern volatile __USBE6CSR3bits_t USBE6CSR3bits __asm__ ("USBE6CSR3") __attribute__((section("sfrs"), address(0xBF8E316C)));
#define USBE7CSR0 USBE7CSR0
extern volatile uint32_t   USBE7CSR0 __attribute__((section("sfrs"), address(0xBF8E3170)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE7CSR0bits_t;
extern volatile __USBE7CSR0bits_t USBE7CSR0bits __asm__ ("USBE7CSR0") __attribute__((section("sfrs"), address(0xBF8E3170)));
#define USBE7CSR1 USBE7CSR1
extern volatile uint32_t   USBE7CSR1 __attribute__((section("sfrs"), address(0xBF8E3174)));
typedef union {
  struct {
    uint32_t RXMAXP:11;
    uint32_t MULT:5;
    uint32_t RXPKTRDY:1;
    uint32_t FIFOFULL:1;
    uint32_t ERROR:1;
    uint32_t DERRNAKT:1;
    uint32_t FLUSH:1;
    uint32_t REQPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t INCOMPRX:1;
    uint32_t DATATGGL:1;
    uint32_t DATATWEN:1;
    uint32_t DMAREQMD:1;
    uint32_t PIDERR:1;
    uint32_t DMAREQEN:1;
    uint32_t AUTORQ:1;
    uint32_t AUTOCLR:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBE7CSR1bits_t;
extern volatile __USBE7CSR1bits_t USBE7CSR1bits __asm__ ("USBE7CSR1") __attribute__((section("sfrs"), address(0xBF8E3174)));
#define USBE7CSR2 USBE7CSR2
extern volatile uint32_t   USBE7CSR2 __attribute__((section("sfrs"), address(0xBF8E3178)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBE7CSR2bits_t;
extern volatile __USBE7CSR2bits_t USBE7CSR2bits __asm__ ("USBE7CSR2") __attribute__((section("sfrs"), address(0xBF8E3178)));
#define USBE7CSR3 USBE7CSR3
extern volatile uint32_t   USBE7CSR3 __attribute__((section("sfrs"), address(0xBF8E317C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBE7CSR3bits_t;
extern volatile __USBE7CSR3bits_t USBE7CSR3bits __asm__ ("USBE7CSR3") __attribute__((section("sfrs"), address(0xBF8E317C)));
#define USBDMAINT USBDMAINT
extern volatile uint32_t   USBDMAINT __attribute__((section("sfrs"), address(0xBF8E3200)));
typedef struct {
  uint32_t DMA1IF:1;
  uint32_t DMA2IF:1;
  uint32_t DMA3IF:1;
  uint32_t DMA4IF:1;
  uint32_t DMA5IF:1;
  uint32_t DMA6IF:1;
  uint32_t DMA7IF:1;
  uint32_t DMA8IF:1;
} __USBDMAINTbits_t;
extern volatile __USBDMAINTbits_t USBDMAINTbits __asm__ ("USBDMAINT") __attribute__((section("sfrs"), address(0xBF8E3200)));
#define USBDMA1C USBDMA1C
extern volatile uint32_t   USBDMA1C __attribute__((section("sfrs"), address(0xBF8E3204)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA1Cbits_t;
extern volatile __USBDMA1Cbits_t USBDMA1Cbits __asm__ ("USBDMA1C") __attribute__((section("sfrs"), address(0xBF8E3204)));
#define USBDMA1A USBDMA1A
extern volatile uint32_t   USBDMA1A __attribute__((section("sfrs"), address(0xBF8E3208)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA1Abits_t;
extern volatile __USBDMA1Abits_t USBDMA1Abits __asm__ ("USBDMA1A") __attribute__((section("sfrs"), address(0xBF8E3208)));
#define USBDMA1N USBDMA1N
extern volatile uint32_t   USBDMA1N __attribute__((section("sfrs"), address(0xBF8E320C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA1Nbits_t;
extern volatile __USBDMA1Nbits_t USBDMA1Nbits __asm__ ("USBDMA1N") __attribute__((section("sfrs"), address(0xBF8E320C)));
#define USBDMA2C USBDMA2C
extern volatile uint32_t   USBDMA2C __attribute__((section("sfrs"), address(0xBF8E3214)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA2Cbits_t;
extern volatile __USBDMA2Cbits_t USBDMA2Cbits __asm__ ("USBDMA2C") __attribute__((section("sfrs"), address(0xBF8E3214)));
#define USBDMA2A USBDMA2A
extern volatile uint32_t   USBDMA2A __attribute__((section("sfrs"), address(0xBF8E3218)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA2Abits_t;
extern volatile __USBDMA2Abits_t USBDMA2Abits __asm__ ("USBDMA2A") __attribute__((section("sfrs"), address(0xBF8E3218)));
#define USBDMA2N USBDMA2N
extern volatile uint32_t   USBDMA2N __attribute__((section("sfrs"), address(0xBF8E321C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA2Nbits_t;
extern volatile __USBDMA2Nbits_t USBDMA2Nbits __asm__ ("USBDMA2N") __attribute__((section("sfrs"), address(0xBF8E321C)));
#define USBDMA3C USBDMA3C
extern volatile uint32_t   USBDMA3C __attribute__((section("sfrs"), address(0xBF8E3224)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA3Cbits_t;
extern volatile __USBDMA3Cbits_t USBDMA3Cbits __asm__ ("USBDMA3C") __attribute__((section("sfrs"), address(0xBF8E3224)));
#define USBDMA3A USBDMA3A
extern volatile uint32_t   USBDMA3A __attribute__((section("sfrs"), address(0xBF8E3228)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA3Abits_t;
extern volatile __USBDMA3Abits_t USBDMA3Abits __asm__ ("USBDMA3A") __attribute__((section("sfrs"), address(0xBF8E3228)));
#define USBDMA3N USBDMA3N
extern volatile uint32_t   USBDMA3N __attribute__((section("sfrs"), address(0xBF8E322C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA3Nbits_t;
extern volatile __USBDMA3Nbits_t USBDMA3Nbits __asm__ ("USBDMA3N") __attribute__((section("sfrs"), address(0xBF8E322C)));
#define USBDMA4C USBDMA4C
extern volatile uint32_t   USBDMA4C __attribute__((section("sfrs"), address(0xBF8E3234)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA4Cbits_t;
extern volatile __USBDMA4Cbits_t USBDMA4Cbits __asm__ ("USBDMA4C") __attribute__((section("sfrs"), address(0xBF8E3234)));
#define USBDMA4A USBDMA4A
extern volatile uint32_t   USBDMA4A __attribute__((section("sfrs"), address(0xBF8E3238)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA4Abits_t;
extern volatile __USBDMA4Abits_t USBDMA4Abits __asm__ ("USBDMA4A") __attribute__((section("sfrs"), address(0xBF8E3238)));
#define USBDMA4N USBDMA4N
extern volatile uint32_t   USBDMA4N __attribute__((section("sfrs"), address(0xBF8E323C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA4Nbits_t;
extern volatile __USBDMA4Nbits_t USBDMA4Nbits __asm__ ("USBDMA4N") __attribute__((section("sfrs"), address(0xBF8E323C)));
#define USBDMA5C USBDMA5C
extern volatile uint32_t   USBDMA5C __attribute__((section("sfrs"), address(0xBF8E3244)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA5Cbits_t;
extern volatile __USBDMA5Cbits_t USBDMA5Cbits __asm__ ("USBDMA5C") __attribute__((section("sfrs"), address(0xBF8E3244)));
#define USBDMA5A USBDMA5A
extern volatile uint32_t   USBDMA5A __attribute__((section("sfrs"), address(0xBF8E3248)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA5Abits_t;
extern volatile __USBDMA5Abits_t USBDMA5Abits __asm__ ("USBDMA5A") __attribute__((section("sfrs"), address(0xBF8E3248)));
#define USBDMA5N USBDMA5N
extern volatile uint32_t   USBDMA5N __attribute__((section("sfrs"), address(0xBF8E324C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA5Nbits_t;
extern volatile __USBDMA5Nbits_t USBDMA5Nbits __asm__ ("USBDMA5N") __attribute__((section("sfrs"), address(0xBF8E324C)));
#define USBDMA6C USBDMA6C
extern volatile uint32_t   USBDMA6C __attribute__((section("sfrs"), address(0xBF8E3254)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA6Cbits_t;
extern volatile __USBDMA6Cbits_t USBDMA6Cbits __asm__ ("USBDMA6C") __attribute__((section("sfrs"), address(0xBF8E3254)));
#define USBDMA6A USBDMA6A
extern volatile uint32_t   USBDMA6A __attribute__((section("sfrs"), address(0xBF8E3258)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA6Abits_t;
extern volatile __USBDMA6Abits_t USBDMA6Abits __asm__ ("USBDMA6A") __attribute__((section("sfrs"), address(0xBF8E3258)));
#define USBDMA6N USBDMA6N
extern volatile uint32_t   USBDMA6N __attribute__((section("sfrs"), address(0xBF8E325C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA6Nbits_t;
extern volatile __USBDMA6Nbits_t USBDMA6Nbits __asm__ ("USBDMA6N") __attribute__((section("sfrs"), address(0xBF8E325C)));
#define USBDMA7C USBDMA7C
extern volatile uint32_t   USBDMA7C __attribute__((section("sfrs"), address(0xBF8E3264)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA7Cbits_t;
extern volatile __USBDMA7Cbits_t USBDMA7Cbits __asm__ ("USBDMA7C") __attribute__((section("sfrs"), address(0xBF8E3264)));
#define USBDMA7A USBDMA7A
extern volatile uint32_t   USBDMA7A __attribute__((section("sfrs"), address(0xBF8E3268)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA7Abits_t;
extern volatile __USBDMA7Abits_t USBDMA7Abits __asm__ ("USBDMA7A") __attribute__((section("sfrs"), address(0xBF8E3268)));
#define USBDMA7N USBDMA7N
extern volatile uint32_t   USBDMA7N __attribute__((section("sfrs"), address(0xBF8E326C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA7Nbits_t;
extern volatile __USBDMA7Nbits_t USBDMA7Nbits __asm__ ("USBDMA7N") __attribute__((section("sfrs"), address(0xBF8E326C)));
#define USBDMA8C USBDMA8C
extern volatile uint32_t   USBDMA8C __attribute__((section("sfrs"), address(0xBF8E3274)));
typedef struct {
  uint32_t DMAEN:1;
  uint32_t DMADIR:1;
  uint32_t DMAMODE:1;
  uint32_t DMAIE:1;
  uint32_t DMAEP:4;
  uint32_t DMAERR:1;
  uint32_t DMABRSTM:2;
} __USBDMA8Cbits_t;
extern volatile __USBDMA8Cbits_t USBDMA8Cbits __asm__ ("USBDMA8C") __attribute__((section("sfrs"), address(0xBF8E3274)));
#define USBDMA8A USBDMA8A
extern volatile uint32_t   USBDMA8A __attribute__((section("sfrs"), address(0xBF8E3278)));
typedef struct {
  uint32_t DMAADDR:32;
} __USBDMA8Abits_t;
extern volatile __USBDMA8Abits_t USBDMA8Abits __asm__ ("USBDMA8A") __attribute__((section("sfrs"), address(0xBF8E3278)));
#define USBDMA8N USBDMA8N
extern volatile uint32_t   USBDMA8N __attribute__((section("sfrs"), address(0xBF8E327C)));
typedef struct {
  uint32_t DMACOUNT:32;
} __USBDMA8Nbits_t;
extern volatile __USBDMA8Nbits_t USBDMA8Nbits __asm__ ("USBDMA8N") __attribute__((section("sfrs"), address(0xBF8E327C)));
#define USBE1RPC USBE1RPC
extern volatile uint32_t   USBE1RPC __attribute__((section("sfrs"), address(0xBF8E3304)));
typedef struct {
  uint32_t RQPKTCNT:16;
} __USBE1RPCbits_t;
extern volatile __USBE1RPCbits_t USBE1RPCbits __asm__ ("USBE1RPC") __attribute__((section("sfrs"), address(0xBF8E3304)));
#define USBE2RPC USBE2RPC
extern volatile uint32_t   USBE2RPC __attribute__((section("sfrs"), address(0xBF8E3308)));
typedef struct {
  uint32_t RQPKTCNT:16;
} __USBE2RPCbits_t;
extern volatile __USBE2RPCbits_t USBE2RPCbits __asm__ ("USBE2RPC") __attribute__((section("sfrs"), address(0xBF8E3308)));
#define USBE3RPC USBE3RPC
extern volatile uint32_t   USBE3RPC __attribute__((section("sfrs"), address(0xBF8E330C)));
typedef struct {
  uint32_t RQPKTCNT:16;
} __USBE3RPCbits_t;
extern volatile __USBE3RPCbits_t USBE3RPCbits __asm__ ("USBE3RPC") __attribute__((section("sfrs"), address(0xBF8E330C)));
#define USBE4RPC USBE4RPC
extern volatile uint32_t   USBE4RPC __attribute__((section("sfrs"), address(0xBF8E3310)));
typedef struct {
  uint32_t RQPKTCNT:16;
} __USBE4RPCbits_t;
extern volatile __USBE4RPCbits_t USBE4RPCbits __asm__ ("USBE4RPC") __attribute__((section("sfrs"), address(0xBF8E3310)));
#define USBE5RPC USBE5RPC
extern volatile uint32_t   USBE5RPC __attribute__((section("sfrs"), address(0xBF8E3314)));
typedef struct {
  uint32_t RQPKTCNT:16;
} __USBE5RPCbits_t;
extern volatile __USBE5RPCbits_t USBE5RPCbits __asm__ ("USBE5RPC") __attribute__((section("sfrs"), address(0xBF8E3314)));
#define USBE6RPC USBE6RPC
extern volatile uint32_t   USBE6RPC __attribute__((section("sfrs"), address(0xBF8E3318)));
typedef struct {
  uint32_t RQPKTCNT:16;
} __USBE6RPCbits_t;
extern volatile __USBE6RPCbits_t USBE6RPCbits __asm__ ("USBE6RPC") __attribute__((section("sfrs"), address(0xBF8E3318)));
#define USBE7RPC USBE7RPC
extern volatile uint32_t   USBE7RPC __attribute__((section("sfrs"), address(0xBF8E331C)));
typedef struct {
  uint32_t RQPKTCNT:16;
} __USBE7RPCbits_t;
extern volatile __USBE7RPCbits_t USBE7RPCbits __asm__ ("USBE7RPC") __attribute__((section("sfrs"), address(0xBF8E331C)));
#define USBDPBFD USBDPBFD
extern volatile uint32_t   USBDPBFD __attribute__((section("sfrs"), address(0xBF8E3340)));
typedef struct {
  uint32_t :1;
  uint32_t EP1RXD:1;
  uint32_t EP2RXD:1;
  uint32_t EP3RXD:1;
  uint32_t EP4RXD:1;
  uint32_t EP5RXD:1;
  uint32_t EP6RXD:1;
  uint32_t EP7RXD:1;
  uint32_t :9;
  uint32_t EP1TXD:1;
  uint32_t EP2TXD:1;
  uint32_t EP3TXD:1;
  uint32_t EP4TXD:1;
  uint32_t EP5TXD:1;
  uint32_t EP6TXD:1;
  uint32_t EP7TXD:1;
} __USBDPBFDbits_t;
extern volatile __USBDPBFDbits_t USBDPBFDbits __asm__ ("USBDPBFD") __attribute__((section("sfrs"), address(0xBF8E3340)));
#define USBTMCON1 USBTMCON1
extern volatile uint32_t   USBTMCON1 __attribute__((section("sfrs"), address(0xBF8E3344)));
typedef struct {
  uint32_t TUCH:16;
  uint32_t THHSRTN:16;
} __USBTMCON1bits_t;
extern volatile __USBTMCON1bits_t USBTMCON1bits __asm__ ("USBTMCON1") __attribute__((section("sfrs"), address(0xBF8E3344)));
#define USBTMCON2 USBTMCON2
extern volatile uint32_t   USBTMCON2 __attribute__((section("sfrs"), address(0xBF8E3348)));
typedef struct {
  uint32_t THSBT:4;
} __USBTMCON2bits_t;
extern volatile __USBTMCON2bits_t USBTMCON2bits __asm__ ("USBTMCON2") __attribute__((section("sfrs"), address(0xBF8E3348)));
#define USBLPMR1 USBLPMR1
extern volatile uint32_t   USBLPMR1 __attribute__((section("sfrs"), address(0xBF8E3360)));
typedef struct {
  uint32_t LNKSTATE:4;
  uint32_t HIRD:4;
  uint32_t RMTWAK:1;
  uint32_t :3;
  uint32_t ENDPOINT:4;
  uint32_t LPMXMT:1;
  uint32_t LPMRES:1;
  uint32_t LPMEN:2;
  uint32_t LPMNAK:1;
  uint32_t :3;
  uint32_t LPMTOIE:1;
  uint32_t LPMSTIE:1;
  uint32_t LPMNYIE:1;
  uint32_t LPMACKIE:1;
  uint32_t LPMRESIE:1;
  uint32_t LPMERRIE:1;
} __USBLPMR1bits_t;
extern volatile __USBLPMR1bits_t USBLPMR1bits __asm__ ("USBLPMR1") __attribute__((section("sfrs"), address(0xBF8E3360)));
#define USBLMPR2 USBLMPR2
extern volatile uint32_t   USBLMPR2 __attribute__((section("sfrs"), address(0xBF8E3364)));
typedef struct {
  uint32_t LPMST:1;
  uint32_t LPMNY:1;
  uint32_t LPMACK:1;
  uint32_t LPMNC:1;
  uint32_t LPMRES:1;
  uint32_t LPMERR:1;
  uint32_t :2;
  uint32_t LPMFADDR:7;
} __USBLMPR2bits_t;
extern volatile __USBLMPR2bits_t USBLMPR2bits __asm__ ("USBLMPR2") __attribute__((section("sfrs"), address(0xBF8E3364)));
#define USBLPMP2 USBLPMP2
extern volatile uint32_t   USBLPMP2 __attribute__((section("sfrs"), address(0xBF8E3364)));
typedef struct {
  uint32_t LPMST:1;
  uint32_t LPMNY:1;
  uint32_t LPMACK:1;
  uint32_t LPMNC:1;
  uint32_t LPMRES:1;
  uint32_t LPMERR:1;
  uint32_t :2;
  uint32_t LPMFADDR:7;
} __USBLPMP2bits_t;
extern volatile __USBLPMP2bits_t USBLPMP2bits __asm__ ("USBLPMP2") __attribute__((section("sfrs"), address(0xBF8E3364)));
#define RNGVER RNGVER
extern volatile uint32_t   RNGVER __attribute__((section("sfrs"), address(0xBF8E6000)));
typedef struct {
  uint32_t REVISION:7;
  uint32_t VERSION:9;
  uint32_t ID:16;
} __RNGVERbits_t;
extern volatile __RNGVERbits_t RNGVERbits __asm__ ("RNGVER") __attribute__((section("sfrs"), address(0xBF8E6000)));
#define RNGCON RNGCON
extern volatile uint32_t   RNGCON __attribute__((section("sfrs"), address(0xBF8E6004)));
typedef struct {
  uint32_t PLEN:8;
  uint32_t TRNGEN:1;
  uint32_t PRNGEN:1;
  uint32_t CONT:1;
  uint32_t TRNGMODE:1;
  uint32_t LOAD:1;
} __RNGCONbits_t;
extern volatile __RNGCONbits_t RNGCONbits __asm__ ("RNGCON") __attribute__((section("sfrs"), address(0xBF8E6004)));
#define RNGPOLY1 RNGPOLY1
extern volatile uint32_t   RNGPOLY1 __attribute__((section("sfrs"), address(0xBF8E6008)));
typedef struct {
  uint32_t POLY:32;
} __RNGPOLY1bits_t;
extern volatile __RNGPOLY1bits_t RNGPOLY1bits __asm__ ("RNGPOLY1") __attribute__((section("sfrs"), address(0xBF8E6008)));
#define RNGPOLY2 RNGPOLY2
extern volatile uint32_t   RNGPOLY2 __attribute__((section("sfrs"), address(0xBF8E600C)));
typedef struct {
  uint32_t POLY:32;
} __RNGPOLY2bits_t;
extern volatile __RNGPOLY2bits_t RNGPOLY2bits __asm__ ("RNGPOLY2") __attribute__((section("sfrs"), address(0xBF8E600C)));
#define RNGNUMGEN1 RNGNUMGEN1
extern volatile uint32_t   RNGNUMGEN1 __attribute__((section("sfrs"), address(0xBF8E6010)));
typedef struct {
  uint32_t RNG:32;
} __RNGNUMGEN1bits_t;
extern volatile __RNGNUMGEN1bits_t RNGNUMGEN1bits __asm__ ("RNGNUMGEN1") __attribute__((section("sfrs"), address(0xBF8E6010)));
#define RNGNUMGEN2 RNGNUMGEN2
extern volatile uint32_t   RNGNUMGEN2 __attribute__((section("sfrs"), address(0xBF8E6014)));
typedef struct {
  uint32_t RNG:32;
} __RNGNUMGEN2bits_t;
extern volatile __RNGNUMGEN2bits_t RNGNUMGEN2bits __asm__ ("RNGNUMGEN2") __attribute__((section("sfrs"), address(0xBF8E6014)));
#define RNGSEED1 RNGSEED1
extern volatile uint32_t   RNGSEED1 __attribute__((section("sfrs"), address(0xBF8E6018)));
typedef struct {
  uint32_t SEED:32;
} __RNGSEED1bits_t;
extern volatile __RNGSEED1bits_t RNGSEED1bits __asm__ ("RNGSEED1") __attribute__((section("sfrs"), address(0xBF8E6018)));
#define RNGSEED2 RNGSEED2
extern volatile uint32_t   RNGSEED2 __attribute__((section("sfrs"), address(0xBF8E601C)));
typedef struct {
  uint32_t SEED:32;
} __RNGSEED2bits_t;
extern volatile __RNGSEED2bits_t RNGSEED2bits __asm__ ("RNGSEED2") __attribute__((section("sfrs"), address(0xBF8E601C)));
#define RNGCNT RNGCNT
extern volatile uint32_t   RNGCNT __attribute__((section("sfrs"), address(0xBF8E6020)));
typedef struct {
  uint32_t RCNT:7;
} __RNGCNTbits_t;
extern volatile __RNGCNTbits_t RNGCNTbits __asm__ ("RNGCNT") __attribute__((section("sfrs"), address(0xBF8E6020)));
#define SBFLAG SBFLAG
extern volatile uint32_t   SBFLAG __attribute__((section("sfrs"), address(0xBF8F0510)));
typedef struct {
  uint32_t T0PGV:1;
  uint32_t T1PGV:1;
  uint32_t T2PGV:1;
  uint32_t T3PGV:1;
  uint32_t T4PGV:1;
  uint32_t T5PGV:1;
  uint32_t T6PGV:1;
  uint32_t T7PGV:1;
  uint32_t T8PGV:1;
  uint32_t T9PGV:1;
  uint32_t T10PGV:1;
  uint32_t T11PGV:1;
  uint32_t T12PGV:1;
  uint32_t T13PGV:1;
} __SBFLAGbits_t;
extern volatile __SBFLAGbits_t SBFLAGbits __asm__ ("SBFLAG") __attribute__((section("sfrs"), address(0xBF8F0510)));
#define SBT0ELOG1 SBT0ELOG1
extern volatile uint32_t   SBT0ELOG1 __attribute__((section("sfrs"), address(0xBF8F8020)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT0ELOG1bits_t;
extern volatile __SBT0ELOG1bits_t SBT0ELOG1bits __asm__ ("SBT0ELOG1") __attribute__((section("sfrs"), address(0xBF8F8020)));
#define SBT0ELOG2 SBT0ELOG2
extern volatile uint32_t   SBT0ELOG2 __attribute__((section("sfrs"), address(0xBF8F8024)));
typedef struct {
  uint32_t GROUP:2;
} __SBT0ELOG2bits_t;
extern volatile __SBT0ELOG2bits_t SBT0ELOG2bits __asm__ ("SBT0ELOG2") __attribute__((section("sfrs"), address(0xBF8F8024)));
#define SBT0ECON SBT0ECON
extern volatile uint32_t   SBT0ECON __attribute__((section("sfrs"), address(0xBF8F8028)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT0ECONbits_t;
extern volatile __SBT0ECONbits_t SBT0ECONbits __asm__ ("SBT0ECON") __attribute__((section("sfrs"), address(0xBF8F8028)));
#define SBT0ECLRS SBT0ECLRS
extern volatile uint32_t   SBT0ECLRS __attribute__((section("sfrs"), address(0xBF8F8030)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT0ECLRSbits_t;
extern volatile __SBT0ECLRSbits_t SBT0ECLRSbits __asm__ ("SBT0ECLRS") __attribute__((section("sfrs"), address(0xBF8F8030)));
#define SBT0ECLRM SBT0ECLRM
extern volatile uint32_t   SBT0ECLRM __attribute__((section("sfrs"), address(0xBF8F8038)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT0ECLRMbits_t;
extern volatile __SBT0ECLRMbits_t SBT0ECLRMbits __asm__ ("SBT0ECLRM") __attribute__((section("sfrs"), address(0xBF8F8038)));
#define SBT0REG0 SBT0REG0
extern volatile uint32_t   SBT0REG0 __attribute__((section("sfrs"), address(0xBF8F8040)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT0REG0bits_t;
extern volatile __SBT0REG0bits_t SBT0REG0bits __asm__ ("SBT0REG0") __attribute__((section("sfrs"), address(0xBF8F8040)));
#define SBT0RD0 SBT0RD0
extern volatile uint32_t   SBT0RD0 __attribute__((section("sfrs"), address(0xBF8F8050)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT0RD0bits_t;
extern volatile __SBT0RD0bits_t SBT0RD0bits __asm__ ("SBT0RD0") __attribute__((section("sfrs"), address(0xBF8F8050)));
#define SBT0WR0 SBT0WR0
extern volatile uint32_t   SBT0WR0 __attribute__((section("sfrs"), address(0xBF8F8058)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT0WR0bits_t;
extern volatile __SBT0WR0bits_t SBT0WR0bits __asm__ ("SBT0WR0") __attribute__((section("sfrs"), address(0xBF8F8058)));
#define SBT0REG1 SBT0REG1
extern volatile uint32_t   SBT0REG1 __attribute__((section("sfrs"), address(0xBF8F8060)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT0REG1bits_t;
extern volatile __SBT0REG1bits_t SBT0REG1bits __asm__ ("SBT0REG1") __attribute__((section("sfrs"), address(0xBF8F8060)));
#define SBT0RD1 SBT0RD1
extern volatile uint32_t   SBT0RD1 __attribute__((section("sfrs"), address(0xBF8F8070)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT0RD1bits_t;
extern volatile __SBT0RD1bits_t SBT0RD1bits __asm__ ("SBT0RD1") __attribute__((section("sfrs"), address(0xBF8F8070)));
#define SBT0WR1 SBT0WR1
extern volatile uint32_t   SBT0WR1 __attribute__((section("sfrs"), address(0xBF8F8078)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT0WR1bits_t;
extern volatile __SBT0WR1bits_t SBT0WR1bits __asm__ ("SBT0WR1") __attribute__((section("sfrs"), address(0xBF8F8078)));
#define SBT1ELOG1 SBT1ELOG1
extern volatile uint32_t   SBT1ELOG1 __attribute__((section("sfrs"), address(0xBF8F8420)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT1ELOG1bits_t;
extern volatile __SBT1ELOG1bits_t SBT1ELOG1bits __asm__ ("SBT1ELOG1") __attribute__((section("sfrs"), address(0xBF8F8420)));
#define SBT1ELOG2 SBT1ELOG2
extern volatile uint32_t   SBT1ELOG2 __attribute__((section("sfrs"), address(0xBF8F8424)));
typedef struct {
  uint32_t GROUP:2;
} __SBT1ELOG2bits_t;
extern volatile __SBT1ELOG2bits_t SBT1ELOG2bits __asm__ ("SBT1ELOG2") __attribute__((section("sfrs"), address(0xBF8F8424)));
#define SBT1ECON SBT1ECON
extern volatile uint32_t   SBT1ECON __attribute__((section("sfrs"), address(0xBF8F8428)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT1ECONbits_t;
extern volatile __SBT1ECONbits_t SBT1ECONbits __asm__ ("SBT1ECON") __attribute__((section("sfrs"), address(0xBF8F8428)));
#define SBT1ECLRS SBT1ECLRS
extern volatile uint32_t   SBT1ECLRS __attribute__((section("sfrs"), address(0xBF8F8430)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT1ECLRSbits_t;
extern volatile __SBT1ECLRSbits_t SBT1ECLRSbits __asm__ ("SBT1ECLRS") __attribute__((section("sfrs"), address(0xBF8F8430)));
#define SBT1ECLRM SBT1ECLRM
extern volatile uint32_t   SBT1ECLRM __attribute__((section("sfrs"), address(0xBF8F8438)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT1ECLRMbits_t;
extern volatile __SBT1ECLRMbits_t SBT1ECLRMbits __asm__ ("SBT1ECLRM") __attribute__((section("sfrs"), address(0xBF8F8438)));
#define SBT1REG0 SBT1REG0
extern volatile uint32_t   SBT1REG0 __attribute__((section("sfrs"), address(0xBF8F8440)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG0bits_t;
extern volatile __SBT1REG0bits_t SBT1REG0bits __asm__ ("SBT1REG0") __attribute__((section("sfrs"), address(0xBF8F8440)));
#define SBT1RD0 SBT1RD0
extern volatile uint32_t   SBT1RD0 __attribute__((section("sfrs"), address(0xBF8F8450)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD0bits_t;
extern volatile __SBT1RD0bits_t SBT1RD0bits __asm__ ("SBT1RD0") __attribute__((section("sfrs"), address(0xBF8F8450)));
#define SBT1WR0 SBT1WR0
extern volatile uint32_t   SBT1WR0 __attribute__((section("sfrs"), address(0xBF8F8458)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR0bits_t;
extern volatile __SBT1WR0bits_t SBT1WR0bits __asm__ ("SBT1WR0") __attribute__((section("sfrs"), address(0xBF8F8458)));
#define SBT1REG2 SBT1REG2
extern volatile uint32_t   SBT1REG2 __attribute__((section("sfrs"), address(0xBF8F8480)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG2bits_t;
extern volatile __SBT1REG2bits_t SBT1REG2bits __asm__ ("SBT1REG2") __attribute__((section("sfrs"), address(0xBF8F8480)));
#define SBT1RD2 SBT1RD2
extern volatile uint32_t   SBT1RD2 __attribute__((section("sfrs"), address(0xBF8F8490)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD2bits_t;
extern volatile __SBT1RD2bits_t SBT1RD2bits __asm__ ("SBT1RD2") __attribute__((section("sfrs"), address(0xBF8F8490)));
#define SBT1WR2 SBT1WR2
extern volatile uint32_t   SBT1WR2 __attribute__((section("sfrs"), address(0xBF8F8498)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR2bits_t;
extern volatile __SBT1WR2bits_t SBT1WR2bits __asm__ ("SBT1WR2") __attribute__((section("sfrs"), address(0xBF8F8498)));
#define SBT1REG3 SBT1REG3
extern volatile uint32_t   SBT1REG3 __attribute__((section("sfrs"), address(0xBF8F84A0)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG3bits_t;
extern volatile __SBT1REG3bits_t SBT1REG3bits __asm__ ("SBT1REG3") __attribute__((section("sfrs"), address(0xBF8F84A0)));
#define SBT1RD3 SBT1RD3
extern volatile uint32_t   SBT1RD3 __attribute__((section("sfrs"), address(0xBF8F84B0)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD3bits_t;
extern volatile __SBT1RD3bits_t SBT1RD3bits __asm__ ("SBT1RD3") __attribute__((section("sfrs"), address(0xBF8F84B0)));
#define SBT1WR3 SBT1WR3
extern volatile uint32_t   SBT1WR3 __attribute__((section("sfrs"), address(0xBF8F84B8)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR3bits_t;
extern volatile __SBT1WR3bits_t SBT1WR3bits __asm__ ("SBT1WR3") __attribute__((section("sfrs"), address(0xBF8F84B8)));
#define SBT1REG4 SBT1REG4
extern volatile uint32_t   SBT1REG4 __attribute__((section("sfrs"), address(0xBF8F84C0)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG4bits_t;
extern volatile __SBT1REG4bits_t SBT1REG4bits __asm__ ("SBT1REG4") __attribute__((section("sfrs"), address(0xBF8F84C0)));
#define SBT1RD4 SBT1RD4
extern volatile uint32_t   SBT1RD4 __attribute__((section("sfrs"), address(0xBF8F84D0)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD4bits_t;
extern volatile __SBT1RD4bits_t SBT1RD4bits __asm__ ("SBT1RD4") __attribute__((section("sfrs"), address(0xBF8F84D0)));
#define SBT1WR4 SBT1WR4
extern volatile uint32_t   SBT1WR4 __attribute__((section("sfrs"), address(0xBF8F84D8)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR4bits_t;
extern volatile __SBT1WR4bits_t SBT1WR4bits __asm__ ("SBT1WR4") __attribute__((section("sfrs"), address(0xBF8F84D8)));
#define SBT1REG5 SBT1REG5
extern volatile uint32_t   SBT1REG5 __attribute__((section("sfrs"), address(0xBF8F84E0)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG5bits_t;
extern volatile __SBT1REG5bits_t SBT1REG5bits __asm__ ("SBT1REG5") __attribute__((section("sfrs"), address(0xBF8F84E0)));
#define SBT1RD5 SBT1RD5
extern volatile uint32_t   SBT1RD5 __attribute__((section("sfrs"), address(0xBF8F84F0)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD5bits_t;
extern volatile __SBT1RD5bits_t SBT1RD5bits __asm__ ("SBT1RD5") __attribute__((section("sfrs"), address(0xBF8F84F0)));
#define SBT1WR5 SBT1WR5
extern volatile uint32_t   SBT1WR5 __attribute__((section("sfrs"), address(0xBF8F84F8)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR5bits_t;
extern volatile __SBT1WR5bits_t SBT1WR5bits __asm__ ("SBT1WR5") __attribute__((section("sfrs"), address(0xBF8F84F8)));
#define SBT1REG6 SBT1REG6
extern volatile uint32_t   SBT1REG6 __attribute__((section("sfrs"), address(0xBF8F8500)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG6bits_t;
extern volatile __SBT1REG6bits_t SBT1REG6bits __asm__ ("SBT1REG6") __attribute__((section("sfrs"), address(0xBF8F8500)));
#define SBT1RD6 SBT1RD6
extern volatile uint32_t   SBT1RD6 __attribute__((section("sfrs"), address(0xBF8F8510)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD6bits_t;
extern volatile __SBT1RD6bits_t SBT1RD6bits __asm__ ("SBT1RD6") __attribute__((section("sfrs"), address(0xBF8F8510)));
#define SBT1WR6 SBT1WR6
extern volatile uint32_t   SBT1WR6 __attribute__((section("sfrs"), address(0xBF8F8518)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR6bits_t;
extern volatile __SBT1WR6bits_t SBT1WR6bits __asm__ ("SBT1WR6") __attribute__((section("sfrs"), address(0xBF8F8518)));
#define SBT1REG7 SBT1REG7
extern volatile uint32_t   SBT1REG7 __attribute__((section("sfrs"), address(0xBF8F8520)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG7bits_t;
extern volatile __SBT1REG7bits_t SBT1REG7bits __asm__ ("SBT1REG7") __attribute__((section("sfrs"), address(0xBF8F8520)));
#define SBT1RD7 SBT1RD7
extern volatile uint32_t   SBT1RD7 __attribute__((section("sfrs"), address(0xBF8F8530)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD7bits_t;
extern volatile __SBT1RD7bits_t SBT1RD7bits __asm__ ("SBT1RD7") __attribute__((section("sfrs"), address(0xBF8F8530)));
#define SBT1WR7 SBT1WR7
extern volatile uint32_t   SBT1WR7 __attribute__((section("sfrs"), address(0xBF8F8538)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR7bits_t;
extern volatile __SBT1WR7bits_t SBT1WR7bits __asm__ ("SBT1WR7") __attribute__((section("sfrs"), address(0xBF8F8538)));
#define SBT1REG8 SBT1REG8
extern volatile uint32_t   SBT1REG8 __attribute__((section("sfrs"), address(0xBF8F8540)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT1REG8bits_t;
extern volatile __SBT1REG8bits_t SBT1REG8bits __asm__ ("SBT1REG8") __attribute__((section("sfrs"), address(0xBF8F8540)));
#define SBT1RD8 SBT1RD8
extern volatile uint32_t   SBT1RD8 __attribute__((section("sfrs"), address(0xBF8F8550)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1RD8bits_t;
extern volatile __SBT1RD8bits_t SBT1RD8bits __asm__ ("SBT1RD8") __attribute__((section("sfrs"), address(0xBF8F8550)));
#define SBT1WR8 SBT1WR8
extern volatile uint32_t   SBT1WR8 __attribute__((section("sfrs"), address(0xBF8F8558)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT1WR8bits_t;
extern volatile __SBT1WR8bits_t SBT1WR8bits __asm__ ("SBT1WR8") __attribute__((section("sfrs"), address(0xBF8F8558)));
#define SBT2ELOG1 SBT2ELOG1
extern volatile uint32_t   SBT2ELOG1 __attribute__((section("sfrs"), address(0xBF8F8820)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT2ELOG1bits_t;
extern volatile __SBT2ELOG1bits_t SBT2ELOG1bits __asm__ ("SBT2ELOG1") __attribute__((section("sfrs"), address(0xBF8F8820)));
#define SBT2ELOG2 SBT2ELOG2
extern volatile uint32_t   SBT2ELOG2 __attribute__((section("sfrs"), address(0xBF8F8824)));
typedef struct {
  uint32_t GROUP:2;
} __SBT2ELOG2bits_t;
extern volatile __SBT2ELOG2bits_t SBT2ELOG2bits __asm__ ("SBT2ELOG2") __attribute__((section("sfrs"), address(0xBF8F8824)));
#define SBT2ECON SBT2ECON
extern volatile uint32_t   SBT2ECON __attribute__((section("sfrs"), address(0xBF8F8828)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT2ECONbits_t;
extern volatile __SBT2ECONbits_t SBT2ECONbits __asm__ ("SBT2ECON") __attribute__((section("sfrs"), address(0xBF8F8828)));
#define SBT2ECLRS SBT2ECLRS
extern volatile uint32_t   SBT2ECLRS __attribute__((section("sfrs"), address(0xBF8F8830)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT2ECLRSbits_t;
extern volatile __SBT2ECLRSbits_t SBT2ECLRSbits __asm__ ("SBT2ECLRS") __attribute__((section("sfrs"), address(0xBF8F8830)));
#define SBT2ECLRM SBT2ECLRM
extern volatile uint32_t   SBT2ECLRM __attribute__((section("sfrs"), address(0xBF8F8838)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT2ECLRMbits_t;
extern volatile __SBT2ECLRMbits_t SBT2ECLRMbits __asm__ ("SBT2ECLRM") __attribute__((section("sfrs"), address(0xBF8F8838)));
#define SBT2REG0 SBT2REG0
extern volatile uint32_t   SBT2REG0 __attribute__((section("sfrs"), address(0xBF8F8840)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT2REG0bits_t;
extern volatile __SBT2REG0bits_t SBT2REG0bits __asm__ ("SBT2REG0") __attribute__((section("sfrs"), address(0xBF8F8840)));
#define SBT2RD0 SBT2RD0
extern volatile uint32_t   SBT2RD0 __attribute__((section("sfrs"), address(0xBF8F8850)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT2RD0bits_t;
extern volatile __SBT2RD0bits_t SBT2RD0bits __asm__ ("SBT2RD0") __attribute__((section("sfrs"), address(0xBF8F8850)));
#define SBT2WR0 SBT2WR0
extern volatile uint32_t   SBT2WR0 __attribute__((section("sfrs"), address(0xBF8F8858)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT2WR0bits_t;
extern volatile __SBT2WR0bits_t SBT2WR0bits __asm__ ("SBT2WR0") __attribute__((section("sfrs"), address(0xBF8F8858)));
#define SBT2REG1 SBT2REG1
extern volatile uint32_t   SBT2REG1 __attribute__((section("sfrs"), address(0xBF8F8860)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT2REG1bits_t;
extern volatile __SBT2REG1bits_t SBT2REG1bits __asm__ ("SBT2REG1") __attribute__((section("sfrs"), address(0xBF8F8860)));
#define SBT2RD1 SBT2RD1
extern volatile uint32_t   SBT2RD1 __attribute__((section("sfrs"), address(0xBF8F8870)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT2RD1bits_t;
extern volatile __SBT2RD1bits_t SBT2RD1bits __asm__ ("SBT2RD1") __attribute__((section("sfrs"), address(0xBF8F8870)));
#define SBT2WR1 SBT2WR1
extern volatile uint32_t   SBT2WR1 __attribute__((section("sfrs"), address(0xBF8F8878)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT2WR1bits_t;
extern volatile __SBT2WR1bits_t SBT2WR1bits __asm__ ("SBT2WR1") __attribute__((section("sfrs"), address(0xBF8F8878)));
#define SBT2REG2 SBT2REG2
extern volatile uint32_t   SBT2REG2 __attribute__((section("sfrs"), address(0xBF8F8880)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT2REG2bits_t;
extern volatile __SBT2REG2bits_t SBT2REG2bits __asm__ ("SBT2REG2") __attribute__((section("sfrs"), address(0xBF8F8880)));
#define SBT2RD2 SBT2RD2
extern volatile uint32_t   SBT2RD2 __attribute__((section("sfrs"), address(0xBF8F8890)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT2RD2bits_t;
extern volatile __SBT2RD2bits_t SBT2RD2bits __asm__ ("SBT2RD2") __attribute__((section("sfrs"), address(0xBF8F8890)));
#define SBT2WR2 SBT2WR2
extern volatile uint32_t   SBT2WR2 __attribute__((section("sfrs"), address(0xBF8F8898)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT2WR2bits_t;
extern volatile __SBT2WR2bits_t SBT2WR2bits __asm__ ("SBT2WR2") __attribute__((section("sfrs"), address(0xBF8F8898)));
#define SBT3ELOG1 SBT3ELOG1
extern volatile uint32_t   SBT3ELOG1 __attribute__((section("sfrs"), address(0xBF8F8C20)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT3ELOG1bits_t;
extern volatile __SBT3ELOG1bits_t SBT3ELOG1bits __asm__ ("SBT3ELOG1") __attribute__((section("sfrs"), address(0xBF8F8C20)));
#define SBT3ELOG2 SBT3ELOG2
extern volatile uint32_t   SBT3ELOG2 __attribute__((section("sfrs"), address(0xBF8F8C24)));
typedef struct {
  uint32_t GROUP:2;
} __SBT3ELOG2bits_t;
extern volatile __SBT3ELOG2bits_t SBT3ELOG2bits __asm__ ("SBT3ELOG2") __attribute__((section("sfrs"), address(0xBF8F8C24)));
#define SBT3ECON SBT3ECON
extern volatile uint32_t   SBT3ECON __attribute__((section("sfrs"), address(0xBF8F8C28)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT3ECONbits_t;
extern volatile __SBT3ECONbits_t SBT3ECONbits __asm__ ("SBT3ECON") __attribute__((section("sfrs"), address(0xBF8F8C28)));
#define SBT3ECLRS SBT3ECLRS
extern volatile uint32_t   SBT3ECLRS __attribute__((section("sfrs"), address(0xBF8F8C30)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT3ECLRSbits_t;
extern volatile __SBT3ECLRSbits_t SBT3ECLRSbits __asm__ ("SBT3ECLRS") __attribute__((section("sfrs"), address(0xBF8F8C30)));
#define SBT3ECLRM SBT3ECLRM
extern volatile uint32_t   SBT3ECLRM __attribute__((section("sfrs"), address(0xBF8F8C38)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT3ECLRMbits_t;
extern volatile __SBT3ECLRMbits_t SBT3ECLRMbits __asm__ ("SBT3ECLRM") __attribute__((section("sfrs"), address(0xBF8F8C38)));
#define SBT3REG0 SBT3REG0
extern volatile uint32_t   SBT3REG0 __attribute__((section("sfrs"), address(0xBF8F8C40)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT3REG0bits_t;
extern volatile __SBT3REG0bits_t SBT3REG0bits __asm__ ("SBT3REG0") __attribute__((section("sfrs"), address(0xBF8F8C40)));
#define SBT3RD0 SBT3RD0
extern volatile uint32_t   SBT3RD0 __attribute__((section("sfrs"), address(0xBF8F8C50)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT3RD0bits_t;
extern volatile __SBT3RD0bits_t SBT3RD0bits __asm__ ("SBT3RD0") __attribute__((section("sfrs"), address(0xBF8F8C50)));
#define SBT3WR0 SBT3WR0
extern volatile uint32_t   SBT3WR0 __attribute__((section("sfrs"), address(0xBF8F8C58)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT3WR0bits_t;
extern volatile __SBT3WR0bits_t SBT3WR0bits __asm__ ("SBT3WR0") __attribute__((section("sfrs"), address(0xBF8F8C58)));
#define SBT3REG1 SBT3REG1
extern volatile uint32_t   SBT3REG1 __attribute__((section("sfrs"), address(0xBF8F8C60)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT3REG1bits_t;
extern volatile __SBT3REG1bits_t SBT3REG1bits __asm__ ("SBT3REG1") __attribute__((section("sfrs"), address(0xBF8F8C60)));
#define SBT3RD1 SBT3RD1
extern volatile uint32_t   SBT3RD1 __attribute__((section("sfrs"), address(0xBF8F8C70)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT3RD1bits_t;
extern volatile __SBT3RD1bits_t SBT3RD1bits __asm__ ("SBT3RD1") __attribute__((section("sfrs"), address(0xBF8F8C70)));
#define SBT3WR1 SBT3WR1
extern volatile uint32_t   SBT3WR1 __attribute__((section("sfrs"), address(0xBF8F8C78)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT3WR1bits_t;
extern volatile __SBT3WR1bits_t SBT3WR1bits __asm__ ("SBT3WR1") __attribute__((section("sfrs"), address(0xBF8F8C78)));
#define SBT3REG2 SBT3REG2
extern volatile uint32_t   SBT3REG2 __attribute__((section("sfrs"), address(0xBF8F8C80)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT3REG2bits_t;
extern volatile __SBT3REG2bits_t SBT3REG2bits __asm__ ("SBT3REG2") __attribute__((section("sfrs"), address(0xBF8F8C80)));
#define SBT3RD2 SBT3RD2
extern volatile uint32_t   SBT3RD2 __attribute__((section("sfrs"), address(0xBF8F8C90)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT3RD2bits_t;
extern volatile __SBT3RD2bits_t SBT3RD2bits __asm__ ("SBT3RD2") __attribute__((section("sfrs"), address(0xBF8F8C90)));
#define SBT3WR2 SBT3WR2
extern volatile uint32_t   SBT3WR2 __attribute__((section("sfrs"), address(0xBF8F8C98)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT3WR2bits_t;
extern volatile __SBT3WR2bits_t SBT3WR2bits __asm__ ("SBT3WR2") __attribute__((section("sfrs"), address(0xBF8F8C98)));
#define SBT4ELOG1 SBT4ELOG1
extern volatile uint32_t   SBT4ELOG1 __attribute__((section("sfrs"), address(0xBF8F9020)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT4ELOG1bits_t;
extern volatile __SBT4ELOG1bits_t SBT4ELOG1bits __asm__ ("SBT4ELOG1") __attribute__((section("sfrs"), address(0xBF8F9020)));
#define SBT4ELOG2 SBT4ELOG2
extern volatile uint32_t   SBT4ELOG2 __attribute__((section("sfrs"), address(0xBF8F9024)));
typedef struct {
  uint32_t GROUP:2;
} __SBT4ELOG2bits_t;
extern volatile __SBT4ELOG2bits_t SBT4ELOG2bits __asm__ ("SBT4ELOG2") __attribute__((section("sfrs"), address(0xBF8F9024)));
#define SBT4ECON SBT4ECON
extern volatile uint32_t   SBT4ECON __attribute__((section("sfrs"), address(0xBF8F9028)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT4ECONbits_t;
extern volatile __SBT4ECONbits_t SBT4ECONbits __asm__ ("SBT4ECON") __attribute__((section("sfrs"), address(0xBF8F9028)));
#define SBT4ECLRS SBT4ECLRS
extern volatile uint32_t   SBT4ECLRS __attribute__((section("sfrs"), address(0xBF8F9030)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT4ECLRSbits_t;
extern volatile __SBT4ECLRSbits_t SBT4ECLRSbits __asm__ ("SBT4ECLRS") __attribute__((section("sfrs"), address(0xBF8F9030)));
#define SBT4ECLRM SBT4ECLRM
extern volatile uint32_t   SBT4ECLRM __attribute__((section("sfrs"), address(0xBF8F9038)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT4ECLRMbits_t;
extern volatile __SBT4ECLRMbits_t SBT4ECLRMbits __asm__ ("SBT4ECLRM") __attribute__((section("sfrs"), address(0xBF8F9038)));
#define SBT4REG0 SBT4REG0
extern volatile uint32_t   SBT4REG0 __attribute__((section("sfrs"), address(0xBF8F9040)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT4REG0bits_t;
extern volatile __SBT4REG0bits_t SBT4REG0bits __asm__ ("SBT4REG0") __attribute__((section("sfrs"), address(0xBF8F9040)));
#define SBT4RD0 SBT4RD0
extern volatile uint32_t   SBT4RD0 __attribute__((section("sfrs"), address(0xBF8F9050)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT4RD0bits_t;
extern volatile __SBT4RD0bits_t SBT4RD0bits __asm__ ("SBT4RD0") __attribute__((section("sfrs"), address(0xBF8F9050)));
#define SBT4WR0 SBT4WR0
extern volatile uint32_t   SBT4WR0 __attribute__((section("sfrs"), address(0xBF8F9058)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT4WR0bits_t;
extern volatile __SBT4WR0bits_t SBT4WR0bits __asm__ ("SBT4WR0") __attribute__((section("sfrs"), address(0xBF8F9058)));
#define SBT4REG2 SBT4REG2
extern volatile uint32_t   SBT4REG2 __attribute__((section("sfrs"), address(0xBF8F9080)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT4REG2bits_t;
extern volatile __SBT4REG2bits_t SBT4REG2bits __asm__ ("SBT4REG2") __attribute__((section("sfrs"), address(0xBF8F9080)));
#define SBT4RD2 SBT4RD2
extern volatile uint32_t   SBT4RD2 __attribute__((section("sfrs"), address(0xBF8F9090)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT4RD2bits_t;
extern volatile __SBT4RD2bits_t SBT4RD2bits __asm__ ("SBT4RD2") __attribute__((section("sfrs"), address(0xBF8F9090)));
#define SBT4WR2 SBT4WR2
extern volatile uint32_t   SBT4WR2 __attribute__((section("sfrs"), address(0xBF8F9098)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT4WR2bits_t;
extern volatile __SBT4WR2bits_t SBT4WR2bits __asm__ ("SBT4WR2") __attribute__((section("sfrs"), address(0xBF8F9098)));
#define SBT5ELOG1 SBT5ELOG1
extern volatile uint32_t   SBT5ELOG1 __attribute__((section("sfrs"), address(0xBF8F9420)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT5ELOG1bits_t;
extern volatile __SBT5ELOG1bits_t SBT5ELOG1bits __asm__ ("SBT5ELOG1") __attribute__((section("sfrs"), address(0xBF8F9420)));
#define SBT5ELOG2 SBT5ELOG2
extern volatile uint32_t   SBT5ELOG2 __attribute__((section("sfrs"), address(0xBF8F9424)));
typedef struct {
  uint32_t GROUP:2;
} __SBT5ELOG2bits_t;
extern volatile __SBT5ELOG2bits_t SBT5ELOG2bits __asm__ ("SBT5ELOG2") __attribute__((section("sfrs"), address(0xBF8F9424)));
#define SBT5ECON SBT5ECON
extern volatile uint32_t   SBT5ECON __attribute__((section("sfrs"), address(0xBF8F9428)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT5ECONbits_t;
extern volatile __SBT5ECONbits_t SBT5ECONbits __asm__ ("SBT5ECON") __attribute__((section("sfrs"), address(0xBF8F9428)));
#define SBT5ECLRS SBT5ECLRS
extern volatile uint32_t   SBT5ECLRS __attribute__((section("sfrs"), address(0xBF8F9430)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT5ECLRSbits_t;
extern volatile __SBT5ECLRSbits_t SBT5ECLRSbits __asm__ ("SBT5ECLRS") __attribute__((section("sfrs"), address(0xBF8F9430)));
#define SBT5ECLRM SBT5ECLRM
extern volatile uint32_t   SBT5ECLRM __attribute__((section("sfrs"), address(0xBF8F9438)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT5ECLRMbits_t;
extern volatile __SBT5ECLRMbits_t SBT5ECLRMbits __asm__ ("SBT5ECLRM") __attribute__((section("sfrs"), address(0xBF8F9438)));
#define SBT5REG0 SBT5REG0
extern volatile uint32_t   SBT5REG0 __attribute__((section("sfrs"), address(0xBF8F9440)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT5REG0bits_t;
extern volatile __SBT5REG0bits_t SBT5REG0bits __asm__ ("SBT5REG0") __attribute__((section("sfrs"), address(0xBF8F9440)));
#define SBT5RD0 SBT5RD0
extern volatile uint32_t   SBT5RD0 __attribute__((section("sfrs"), address(0xBF8F9450)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT5RD0bits_t;
extern volatile __SBT5RD0bits_t SBT5RD0bits __asm__ ("SBT5RD0") __attribute__((section("sfrs"), address(0xBF8F9450)));
#define SBT5WR0 SBT5WR0
extern volatile uint32_t   SBT5WR0 __attribute__((section("sfrs"), address(0xBF8F9458)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT5WR0bits_t;
extern volatile __SBT5WR0bits_t SBT5WR0bits __asm__ ("SBT5WR0") __attribute__((section("sfrs"), address(0xBF8F9458)));
#define SBT5REG1 SBT5REG1
extern volatile uint32_t   SBT5REG1 __attribute__((section("sfrs"), address(0xBF8F9460)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT5REG1bits_t;
extern volatile __SBT5REG1bits_t SBT5REG1bits __asm__ ("SBT5REG1") __attribute__((section("sfrs"), address(0xBF8F9460)));
#define SBT5RD1 SBT5RD1
extern volatile uint32_t   SBT5RD1 __attribute__((section("sfrs"), address(0xBF8F9470)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT5RD1bits_t;
extern volatile __SBT5RD1bits_t SBT5RD1bits __asm__ ("SBT5RD1") __attribute__((section("sfrs"), address(0xBF8F9470)));
#define SBT5WR1 SBT5WR1
extern volatile uint32_t   SBT5WR1 __attribute__((section("sfrs"), address(0xBF8F9478)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT5WR1bits_t;
extern volatile __SBT5WR1bits_t SBT5WR1bits __asm__ ("SBT5WR1") __attribute__((section("sfrs"), address(0xBF8F9478)));
#define SBT5REG2 SBT5REG2
extern volatile uint32_t   SBT5REG2 __attribute__((section("sfrs"), address(0xBF8F9480)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT5REG2bits_t;
extern volatile __SBT5REG2bits_t SBT5REG2bits __asm__ ("SBT5REG2") __attribute__((section("sfrs"), address(0xBF8F9480)));
#define SBT5RD2 SBT5RD2
extern volatile uint32_t   SBT5RD2 __attribute__((section("sfrs"), address(0xBF8F9490)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT5RD2bits_t;
extern volatile __SBT5RD2bits_t SBT5RD2bits __asm__ ("SBT5RD2") __attribute__((section("sfrs"), address(0xBF8F9490)));
#define SBT5WR2 SBT5WR2
extern volatile uint32_t   SBT5WR2 __attribute__((section("sfrs"), address(0xBF8F9498)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT5WR2bits_t;
extern volatile __SBT5WR2bits_t SBT5WR2bits __asm__ ("SBT5WR2") __attribute__((section("sfrs"), address(0xBF8F9498)));
#define SBT6ELOG1 SBT6ELOG1
extern volatile uint32_t   SBT6ELOG1 __attribute__((section("sfrs"), address(0xBF8F9820)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT6ELOG1bits_t;
extern volatile __SBT6ELOG1bits_t SBT6ELOG1bits __asm__ ("SBT6ELOG1") __attribute__((section("sfrs"), address(0xBF8F9820)));
#define SBT6ELOG2 SBT6ELOG2
extern volatile uint32_t   SBT6ELOG2 __attribute__((section("sfrs"), address(0xBF8F9824)));
typedef struct {
  uint32_t GROUP:2;
} __SBT6ELOG2bits_t;
extern volatile __SBT6ELOG2bits_t SBT6ELOG2bits __asm__ ("SBT6ELOG2") __attribute__((section("sfrs"), address(0xBF8F9824)));
#define SBT6ECON SBT6ECON
extern volatile uint32_t   SBT6ECON __attribute__((section("sfrs"), address(0xBF8F9828)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT6ECONbits_t;
extern volatile __SBT6ECONbits_t SBT6ECONbits __asm__ ("SBT6ECON") __attribute__((section("sfrs"), address(0xBF8F9828)));
#define SBT6ECLRS SBT6ECLRS
extern volatile uint32_t   SBT6ECLRS __attribute__((section("sfrs"), address(0xBF8F9830)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT6ECLRSbits_t;
extern volatile __SBT6ECLRSbits_t SBT6ECLRSbits __asm__ ("SBT6ECLRS") __attribute__((section("sfrs"), address(0xBF8F9830)));
#define SBT6ECLRM SBT6ECLRM
extern volatile uint32_t   SBT6ECLRM __attribute__((section("sfrs"), address(0xBF8F9838)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT6ECLRMbits_t;
extern volatile __SBT6ECLRMbits_t SBT6ECLRMbits __asm__ ("SBT6ECLRM") __attribute__((section("sfrs"), address(0xBF8F9838)));
#define SBT6REG0 SBT6REG0
extern volatile uint32_t   SBT6REG0 __attribute__((section("sfrs"), address(0xBF8F9840)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT6REG0bits_t;
extern volatile __SBT6REG0bits_t SBT6REG0bits __asm__ ("SBT6REG0") __attribute__((section("sfrs"), address(0xBF8F9840)));
#define SBT6RD0 SBT6RD0
extern volatile uint32_t   SBT6RD0 __attribute__((section("sfrs"), address(0xBF8F9850)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT6RD0bits_t;
extern volatile __SBT6RD0bits_t SBT6RD0bits __asm__ ("SBT6RD0") __attribute__((section("sfrs"), address(0xBF8F9850)));
#define SBT6WR0 SBT6WR0
extern volatile uint32_t   SBT6WR0 __attribute__((section("sfrs"), address(0xBF8F9858)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT6WR0bits_t;
extern volatile __SBT6WR0bits_t SBT6WR0bits __asm__ ("SBT6WR0") __attribute__((section("sfrs"), address(0xBF8F9858)));
#define SBT6REG1 SBT6REG1
extern volatile uint32_t   SBT6REG1 __attribute__((section("sfrs"), address(0xBF8F9860)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT6REG1bits_t;
extern volatile __SBT6REG1bits_t SBT6REG1bits __asm__ ("SBT6REG1") __attribute__((section("sfrs"), address(0xBF8F9860)));
#define SBT6RD1 SBT6RD1
extern volatile uint32_t   SBT6RD1 __attribute__((section("sfrs"), address(0xBF8F9870)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT6RD1bits_t;
extern volatile __SBT6RD1bits_t SBT6RD1bits __asm__ ("SBT6RD1") __attribute__((section("sfrs"), address(0xBF8F9870)));
#define SBT6WR1 SBT6WR1
extern volatile uint32_t   SBT6WR1 __attribute__((section("sfrs"), address(0xBF8F9878)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT6WR1bits_t;
extern volatile __SBT6WR1bits_t SBT6WR1bits __asm__ ("SBT6WR1") __attribute__((section("sfrs"), address(0xBF8F9878)));
#define SBT7ELOG1 SBT7ELOG1
extern volatile uint32_t   SBT7ELOG1 __attribute__((section("sfrs"), address(0xBF8F9C20)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT7ELOG1bits_t;
extern volatile __SBT7ELOG1bits_t SBT7ELOG1bits __asm__ ("SBT7ELOG1") __attribute__((section("sfrs"), address(0xBF8F9C20)));
#define SBT7ELOG2 SBT7ELOG2
extern volatile uint32_t   SBT7ELOG2 __attribute__((section("sfrs"), address(0xBF8F9C24)));
typedef struct {
  uint32_t GROUP:2;
} __SBT7ELOG2bits_t;
extern volatile __SBT7ELOG2bits_t SBT7ELOG2bits __asm__ ("SBT7ELOG2") __attribute__((section("sfrs"), address(0xBF8F9C24)));
#define SBT7ECON SBT7ECON
extern volatile uint32_t   SBT7ECON __attribute__((section("sfrs"), address(0xBF8F9C28)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT7ECONbits_t;
extern volatile __SBT7ECONbits_t SBT7ECONbits __asm__ ("SBT7ECON") __attribute__((section("sfrs"), address(0xBF8F9C28)));
#define SBT7ECLRS SBT7ECLRS
extern volatile uint32_t   SBT7ECLRS __attribute__((section("sfrs"), address(0xBF8F9C30)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT7ECLRSbits_t;
extern volatile __SBT7ECLRSbits_t SBT7ECLRSbits __asm__ ("SBT7ECLRS") __attribute__((section("sfrs"), address(0xBF8F9C30)));
#define SBT7ECLRM SBT7ECLRM
extern volatile uint32_t   SBT7ECLRM __attribute__((section("sfrs"), address(0xBF8F9C38)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT7ECLRMbits_t;
extern volatile __SBT7ECLRMbits_t SBT7ECLRMbits __asm__ ("SBT7ECLRM") __attribute__((section("sfrs"), address(0xBF8F9C38)));
#define SBT7REG0 SBT7REG0
extern volatile uint32_t   SBT7REG0 __attribute__((section("sfrs"), address(0xBF8F9C40)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT7REG0bits_t;
extern volatile __SBT7REG0bits_t SBT7REG0bits __asm__ ("SBT7REG0") __attribute__((section("sfrs"), address(0xBF8F9C40)));
#define SBT7RD0 SBT7RD0
extern volatile uint32_t   SBT7RD0 __attribute__((section("sfrs"), address(0xBF8F9C50)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT7RD0bits_t;
extern volatile __SBT7RD0bits_t SBT7RD0bits __asm__ ("SBT7RD0") __attribute__((section("sfrs"), address(0xBF8F9C50)));
#define SBT7WR0 SBT7WR0
extern volatile uint32_t   SBT7WR0 __attribute__((section("sfrs"), address(0xBF8F9C58)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT7WR0bits_t;
extern volatile __SBT7WR0bits_t SBT7WR0bits __asm__ ("SBT7WR0") __attribute__((section("sfrs"), address(0xBF8F9C58)));
#define SBT7REG1 SBT7REG1
extern volatile uint32_t   SBT7REG1 __attribute__((section("sfrs"), address(0xBF8F9C60)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT7REG1bits_t;
extern volatile __SBT7REG1bits_t SBT7REG1bits __asm__ ("SBT7REG1") __attribute__((section("sfrs"), address(0xBF8F9C60)));
#define SBT7RD1 SBT7RD1
extern volatile uint32_t   SBT7RD1 __attribute__((section("sfrs"), address(0xBF8F9C70)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT7RD1bits_t;
extern volatile __SBT7RD1bits_t SBT7RD1bits __asm__ ("SBT7RD1") __attribute__((section("sfrs"), address(0xBF8F9C70)));
#define SBT7WR1 SBT7WR1
extern volatile uint32_t   SBT7WR1 __attribute__((section("sfrs"), address(0xBF8F9C78)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT7WR1bits_t;
extern volatile __SBT7WR1bits_t SBT7WR1bits __asm__ ("SBT7WR1") __attribute__((section("sfrs"), address(0xBF8F9C78)));
#define SBT8ELOG1 SBT8ELOG1
extern volatile uint32_t   SBT8ELOG1 __attribute__((section("sfrs"), address(0xBF8FA020)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT8ELOG1bits_t;
extern volatile __SBT8ELOG1bits_t SBT8ELOG1bits __asm__ ("SBT8ELOG1") __attribute__((section("sfrs"), address(0xBF8FA020)));
#define SBT8ELOG2 SBT8ELOG2
extern volatile uint32_t   SBT8ELOG2 __attribute__((section("sfrs"), address(0xBF8FA024)));
typedef struct {
  uint32_t GROUP:2;
} __SBT8ELOG2bits_t;
extern volatile __SBT8ELOG2bits_t SBT8ELOG2bits __asm__ ("SBT8ELOG2") __attribute__((section("sfrs"), address(0xBF8FA024)));
#define SBT8ECON SBT8ECON
extern volatile uint32_t   SBT8ECON __attribute__((section("sfrs"), address(0xBF8FA028)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT8ECONbits_t;
extern volatile __SBT8ECONbits_t SBT8ECONbits __asm__ ("SBT8ECON") __attribute__((section("sfrs"), address(0xBF8FA028)));
#define SBT8ECLRS SBT8ECLRS
extern volatile uint32_t   SBT8ECLRS __attribute__((section("sfrs"), address(0xBF8FA030)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT8ECLRSbits_t;
extern volatile __SBT8ECLRSbits_t SBT8ECLRSbits __asm__ ("SBT8ECLRS") __attribute__((section("sfrs"), address(0xBF8FA030)));
#define SBT8ECLRM SBT8ECLRM
extern volatile uint32_t   SBT8ECLRM __attribute__((section("sfrs"), address(0xBF8FA038)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT8ECLRMbits_t;
extern volatile __SBT8ECLRMbits_t SBT8ECLRMbits __asm__ ("SBT8ECLRM") __attribute__((section("sfrs"), address(0xBF8FA038)));
#define SBT8REG0 SBT8REG0
extern volatile uint32_t   SBT8REG0 __attribute__((section("sfrs"), address(0xBF8FA040)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT8REG0bits_t;
extern volatile __SBT8REG0bits_t SBT8REG0bits __asm__ ("SBT8REG0") __attribute__((section("sfrs"), address(0xBF8FA040)));
#define SBT8RD0 SBT8RD0
extern volatile uint32_t   SBT8RD0 __attribute__((section("sfrs"), address(0xBF8FA050)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT8RD0bits_t;
extern volatile __SBT8RD0bits_t SBT8RD0bits __asm__ ("SBT8RD0") __attribute__((section("sfrs"), address(0xBF8FA050)));
#define SBT8WR0 SBT8WR0
extern volatile uint32_t   SBT8WR0 __attribute__((section("sfrs"), address(0xBF8FA058)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT8WR0bits_t;
extern volatile __SBT8WR0bits_t SBT8WR0bits __asm__ ("SBT8WR0") __attribute__((section("sfrs"), address(0xBF8FA058)));
#define SBT8REG1 SBT8REG1
extern volatile uint32_t   SBT8REG1 __attribute__((section("sfrs"), address(0xBF8FA060)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT8REG1bits_t;
extern volatile __SBT8REG1bits_t SBT8REG1bits __asm__ ("SBT8REG1") __attribute__((section("sfrs"), address(0xBF8FA060)));
#define SBT8RD1 SBT8RD1
extern volatile uint32_t   SBT8RD1 __attribute__((section("sfrs"), address(0xBF8FA070)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT8RD1bits_t;
extern volatile __SBT8RD1bits_t SBT8RD1bits __asm__ ("SBT8RD1") __attribute__((section("sfrs"), address(0xBF8FA070)));
#define SBT8WR1 SBT8WR1
extern volatile uint32_t   SBT8WR1 __attribute__((section("sfrs"), address(0xBF8FA078)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT8WR1bits_t;
extern volatile __SBT8WR1bits_t SBT8WR1bits __asm__ ("SBT8WR1") __attribute__((section("sfrs"), address(0xBF8FA078)));
#define SBT9ELOG1 SBT9ELOG1
extern volatile uint32_t   SBT9ELOG1 __attribute__((section("sfrs"), address(0xBF8FA420)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT9ELOG1bits_t;
extern volatile __SBT9ELOG1bits_t SBT9ELOG1bits __asm__ ("SBT9ELOG1") __attribute__((section("sfrs"), address(0xBF8FA420)));
#define SBT9ELOG2 SBT9ELOG2
extern volatile uint32_t   SBT9ELOG2 __attribute__((section("sfrs"), address(0xBF8FA424)));
typedef struct {
  uint32_t GROUP:2;
} __SBT9ELOG2bits_t;
extern volatile __SBT9ELOG2bits_t SBT9ELOG2bits __asm__ ("SBT9ELOG2") __attribute__((section("sfrs"), address(0xBF8FA424)));
#define SBT9ECON SBT9ECON
extern volatile uint32_t   SBT9ECON __attribute__((section("sfrs"), address(0xBF8FA428)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT9ECONbits_t;
extern volatile __SBT9ECONbits_t SBT9ECONbits __asm__ ("SBT9ECON") __attribute__((section("sfrs"), address(0xBF8FA428)));
#define SBT9ECLRS SBT9ECLRS
extern volatile uint32_t   SBT9ECLRS __attribute__((section("sfrs"), address(0xBF8FA430)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT9ECLRSbits_t;
extern volatile __SBT9ECLRSbits_t SBT9ECLRSbits __asm__ ("SBT9ECLRS") __attribute__((section("sfrs"), address(0xBF8FA430)));
#define SBT9ECLRM SBT9ECLRM
extern volatile uint32_t   SBT9ECLRM __attribute__((section("sfrs"), address(0xBF8FA438)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT9ECLRMbits_t;
extern volatile __SBT9ECLRMbits_t SBT9ECLRMbits __asm__ ("SBT9ECLRM") __attribute__((section("sfrs"), address(0xBF8FA438)));
#define SBT9REG0 SBT9REG0
extern volatile uint32_t   SBT9REG0 __attribute__((section("sfrs"), address(0xBF8FA440)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT9REG0bits_t;
extern volatile __SBT9REG0bits_t SBT9REG0bits __asm__ ("SBT9REG0") __attribute__((section("sfrs"), address(0xBF8FA440)));
#define SBT9RD0 SBT9RD0
extern volatile uint32_t   SBT9RD0 __attribute__((section("sfrs"), address(0xBF8FA450)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT9RD0bits_t;
extern volatile __SBT9RD0bits_t SBT9RD0bits __asm__ ("SBT9RD0") __attribute__((section("sfrs"), address(0xBF8FA450)));
#define SBT9WR0 SBT9WR0
extern volatile uint32_t   SBT9WR0 __attribute__((section("sfrs"), address(0xBF8FA458)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT9WR0bits_t;
extern volatile __SBT9WR0bits_t SBT9WR0bits __asm__ ("SBT9WR0") __attribute__((section("sfrs"), address(0xBF8FA458)));
#define SBT9REG1 SBT9REG1
extern volatile uint32_t   SBT9REG1 __attribute__((section("sfrs"), address(0xBF8FA460)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT9REG1bits_t;
extern volatile __SBT9REG1bits_t SBT9REG1bits __asm__ ("SBT9REG1") __attribute__((section("sfrs"), address(0xBF8FA460)));
#define SBT9RD1 SBT9RD1
extern volatile uint32_t   SBT9RD1 __attribute__((section("sfrs"), address(0xBF8FA470)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT9RD1bits_t;
extern volatile __SBT9RD1bits_t SBT9RD1bits __asm__ ("SBT9RD1") __attribute__((section("sfrs"), address(0xBF8FA470)));
#define SBT9WR1 SBT9WR1
extern volatile uint32_t   SBT9WR1 __attribute__((section("sfrs"), address(0xBF8FA478)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT9WR1bits_t;
extern volatile __SBT9WR1bits_t SBT9WR1bits __asm__ ("SBT9WR1") __attribute__((section("sfrs"), address(0xBF8FA478)));
#define SBT10ELOG1 SBT10ELOG1
extern volatile uint32_t   SBT10ELOG1 __attribute__((section("sfrs"), address(0xBF8FA820)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT10ELOG1bits_t;
extern volatile __SBT10ELOG1bits_t SBT10ELOG1bits __asm__ ("SBT10ELOG1") __attribute__((section("sfrs"), address(0xBF8FA820)));
#define SBT10ELOG2 SBT10ELOG2
extern volatile uint32_t   SBT10ELOG2 __attribute__((section("sfrs"), address(0xBF8FA824)));
typedef struct {
  uint32_t GROUP:2;
} __SBT10ELOG2bits_t;
extern volatile __SBT10ELOG2bits_t SBT10ELOG2bits __asm__ ("SBT10ELOG2") __attribute__((section("sfrs"), address(0xBF8FA824)));
#define SBT10ECON SBT10ECON
extern volatile uint32_t   SBT10ECON __attribute__((section("sfrs"), address(0xBF8FA828)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT10ECONbits_t;
extern volatile __SBT10ECONbits_t SBT10ECONbits __asm__ ("SBT10ECON") __attribute__((section("sfrs"), address(0xBF8FA828)));
#define SBT10ECLRS SBT10ECLRS
extern volatile uint32_t   SBT10ECLRS __attribute__((section("sfrs"), address(0xBF8FA830)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT10ECLRSbits_t;
extern volatile __SBT10ECLRSbits_t SBT10ECLRSbits __asm__ ("SBT10ECLRS") __attribute__((section("sfrs"), address(0xBF8FA830)));
#define SBT10ECLRM SBT10ECLRM
extern volatile uint32_t   SBT10ECLRM __attribute__((section("sfrs"), address(0xBF8FA838)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT10ECLRMbits_t;
extern volatile __SBT10ECLRMbits_t SBT10ECLRMbits __asm__ ("SBT10ECLRM") __attribute__((section("sfrs"), address(0xBF8FA838)));
#define SBT10REG0 SBT10REG0
extern volatile uint32_t   SBT10REG0 __attribute__((section("sfrs"), address(0xBF8FA840)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT10REG0bits_t;
extern volatile __SBT10REG0bits_t SBT10REG0bits __asm__ ("SBT10REG0") __attribute__((section("sfrs"), address(0xBF8FA840)));
#define SBT10RD0 SBT10RD0
extern volatile uint32_t   SBT10RD0 __attribute__((section("sfrs"), address(0xBF8FA850)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT10RD0bits_t;
extern volatile __SBT10RD0bits_t SBT10RD0bits __asm__ ("SBT10RD0") __attribute__((section("sfrs"), address(0xBF8FA850)));
#define SBT10WR0 SBT10WR0
extern volatile uint32_t   SBT10WR0 __attribute__((section("sfrs"), address(0xBF8FA858)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT10WR0bits_t;
extern volatile __SBT10WR0bits_t SBT10WR0bits __asm__ ("SBT10WR0") __attribute__((section("sfrs"), address(0xBF8FA858)));
#define SBT11ELOG1 SBT11ELOG1
extern volatile uint32_t   SBT11ELOG1 __attribute__((section("sfrs"), address(0xBF8FAC20)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT11ELOG1bits_t;
extern volatile __SBT11ELOG1bits_t SBT11ELOG1bits __asm__ ("SBT11ELOG1") __attribute__((section("sfrs"), address(0xBF8FAC20)));
#define SBT11ELOG2 SBT11ELOG2
extern volatile uint32_t   SBT11ELOG2 __attribute__((section("sfrs"), address(0xBF8FAC24)));
typedef struct {
  uint32_t GROUP:2;
} __SBT11ELOG2bits_t;
extern volatile __SBT11ELOG2bits_t SBT11ELOG2bits __asm__ ("SBT11ELOG2") __attribute__((section("sfrs"), address(0xBF8FAC24)));
#define SBT11ECON SBT11ECON
extern volatile uint32_t   SBT11ECON __attribute__((section("sfrs"), address(0xBF8FAC28)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT11ECONbits_t;
extern volatile __SBT11ECONbits_t SBT11ECONbits __asm__ ("SBT11ECON") __attribute__((section("sfrs"), address(0xBF8FAC28)));
#define SBT11ECLRS SBT11ECLRS
extern volatile uint32_t   SBT11ECLRS __attribute__((section("sfrs"), address(0xBF8FAC30)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT11ECLRSbits_t;
extern volatile __SBT11ECLRSbits_t SBT11ECLRSbits __asm__ ("SBT11ECLRS") __attribute__((section("sfrs"), address(0xBF8FAC30)));
#define SBT11ECLRM SBT11ECLRM
extern volatile uint32_t   SBT11ECLRM __attribute__((section("sfrs"), address(0xBF8FAC38)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT11ECLRMbits_t;
extern volatile __SBT11ECLRMbits_t SBT11ECLRMbits __asm__ ("SBT11ECLRM") __attribute__((section("sfrs"), address(0xBF8FAC38)));
#define SBT11REG0 SBT11REG0
extern volatile uint32_t   SBT11REG0 __attribute__((section("sfrs"), address(0xBF8FAC40)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT11REG0bits_t;
extern volatile __SBT11REG0bits_t SBT11REG0bits __asm__ ("SBT11REG0") __attribute__((section("sfrs"), address(0xBF8FAC40)));
#define SBT11RD0 SBT11RD0
extern volatile uint32_t   SBT11RD0 __attribute__((section("sfrs"), address(0xBF8FAC50)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT11RD0bits_t;
extern volatile __SBT11RD0bits_t SBT11RD0bits __asm__ ("SBT11RD0") __attribute__((section("sfrs"), address(0xBF8FAC50)));
#define SBT11WR0 SBT11WR0
extern volatile uint32_t   SBT11WR0 __attribute__((section("sfrs"), address(0xBF8FAC58)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT11WR0bits_t;
extern volatile __SBT11WR0bits_t SBT11WR0bits __asm__ ("SBT11WR0") __attribute__((section("sfrs"), address(0xBF8FAC58)));
#define SBT11REG1 SBT11REG1
extern volatile uint32_t   SBT11REG1 __attribute__((section("sfrs"), address(0xBF8FAC60)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT11REG1bits_t;
extern volatile __SBT11REG1bits_t SBT11REG1bits __asm__ ("SBT11REG1") __attribute__((section("sfrs"), address(0xBF8FAC60)));
#define SBT11RD1 SBT11RD1
extern volatile uint32_t   SBT11RD1 __attribute__((section("sfrs"), address(0xBF8FAC70)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT11RD1bits_t;
extern volatile __SBT11RD1bits_t SBT11RD1bits __asm__ ("SBT11RD1") __attribute__((section("sfrs"), address(0xBF8FAC70)));
#define SBT11WR1 SBT11WR1
extern volatile uint32_t   SBT11WR1 __attribute__((section("sfrs"), address(0xBF8FAC78)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT11WR1bits_t;
extern volatile __SBT11WR1bits_t SBT11WR1bits __asm__ ("SBT11WR1") __attribute__((section("sfrs"), address(0xBF8FAC78)));
#define SBT12ELOG1 SBT12ELOG1
extern volatile uint32_t   SBT12ELOG1 __attribute__((section("sfrs"), address(0xBF8FB020)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT12ELOG1bits_t;
extern volatile __SBT12ELOG1bits_t SBT12ELOG1bits __asm__ ("SBT12ELOG1") __attribute__((section("sfrs"), address(0xBF8FB020)));
#define SBT12ELOG2 SBT12ELOG2
extern volatile uint32_t   SBT12ELOG2 __attribute__((section("sfrs"), address(0xBF8FB024)));
typedef struct {
  uint32_t GROUP:2;
} __SBT12ELOG2bits_t;
extern volatile __SBT12ELOG2bits_t SBT12ELOG2bits __asm__ ("SBT12ELOG2") __attribute__((section("sfrs"), address(0xBF8FB024)));
#define SBT12ECON SBT12ECON
extern volatile uint32_t   SBT12ECON __attribute__((section("sfrs"), address(0xBF8FB028)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT12ECONbits_t;
extern volatile __SBT12ECONbits_t SBT12ECONbits __asm__ ("SBT12ECON") __attribute__((section("sfrs"), address(0xBF8FB028)));
#define SBT12ECLRS SBT12ECLRS
extern volatile uint32_t   SBT12ECLRS __attribute__((section("sfrs"), address(0xBF8FB030)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT12ECLRSbits_t;
extern volatile __SBT12ECLRSbits_t SBT12ECLRSbits __asm__ ("SBT12ECLRS") __attribute__((section("sfrs"), address(0xBF8FB030)));
#define SBT12ECLRM SBT12ECLRM
extern volatile uint32_t   SBT12ECLRM __attribute__((section("sfrs"), address(0xBF8FB038)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT12ECLRMbits_t;
extern volatile __SBT12ECLRMbits_t SBT12ECLRMbits __asm__ ("SBT12ECLRM") __attribute__((section("sfrs"), address(0xBF8FB038)));
#define SBT12REG0 SBT12REG0
extern volatile uint32_t   SBT12REG0 __attribute__((section("sfrs"), address(0xBF8FB040)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT12REG0bits_t;
extern volatile __SBT12REG0bits_t SBT12REG0bits __asm__ ("SBT12REG0") __attribute__((section("sfrs"), address(0xBF8FB040)));
#define SBT12RD0 SBT12RD0
extern volatile uint32_t   SBT12RD0 __attribute__((section("sfrs"), address(0xBF8FB050)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT12RD0bits_t;
extern volatile __SBT12RD0bits_t SBT12RD0bits __asm__ ("SBT12RD0") __attribute__((section("sfrs"), address(0xBF8FB050)));
#define SBT12WR0 SBT12WR0
extern volatile uint32_t   SBT12WR0 __attribute__((section("sfrs"), address(0xBF8FB058)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT12WR0bits_t;
extern volatile __SBT12WR0bits_t SBT12WR0bits __asm__ ("SBT12WR0") __attribute__((section("sfrs"), address(0xBF8FB058)));
#define SBT13ELOG1 SBT13ELOG1
extern volatile uint32_t   SBT13ELOG1 __attribute__((section("sfrs"), address(0xBF8FB420)));
typedef struct {
  uint32_t CMD:3;
  uint32_t :1;
  uint32_t REGION:4;
  uint32_t INITID:8;
  uint32_t :8;
  uint32_t CODE:4;
  uint32_t :3;
  uint32_t MULTI:1;
} __SBT13ELOG1bits_t;
extern volatile __SBT13ELOG1bits_t SBT13ELOG1bits __asm__ ("SBT13ELOG1") __attribute__((section("sfrs"), address(0xBF8FB420)));
#define SBT13ELOG2 SBT13ELOG2
extern volatile uint32_t   SBT13ELOG2 __attribute__((section("sfrs"), address(0xBF8FB424)));
typedef struct {
  uint32_t GROUP:2;
} __SBT13ELOG2bits_t;
extern volatile __SBT13ELOG2bits_t SBT13ELOG2bits __asm__ ("SBT13ELOG2") __attribute__((section("sfrs"), address(0xBF8FB424)));
#define SBT13ECON SBT13ECON
extern volatile uint32_t   SBT13ECON __attribute__((section("sfrs"), address(0xBF8FB428)));
typedef struct {
  uint32_t :24;
  uint32_t ERRP:1;
} __SBT13ECONbits_t;
extern volatile __SBT13ECONbits_t SBT13ECONbits __asm__ ("SBT13ECON") __attribute__((section("sfrs"), address(0xBF8FB428)));
#define SBT13ECLRS SBT13ECLRS
extern volatile uint32_t   SBT13ECLRS __attribute__((section("sfrs"), address(0xBF8FB430)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT13ECLRSbits_t;
extern volatile __SBT13ECLRSbits_t SBT13ECLRSbits __asm__ ("SBT13ECLRS") __attribute__((section("sfrs"), address(0xBF8FB430)));
#define SBT13ECLRM SBT13ECLRM
extern volatile uint32_t   SBT13ECLRM __attribute__((section("sfrs"), address(0xBF8FB438)));
typedef struct {
  uint32_t CLEAR:1;
} __SBT13ECLRMbits_t;
extern volatile __SBT13ECLRMbits_t SBT13ECLRMbits __asm__ ("SBT13ECLRM") __attribute__((section("sfrs"), address(0xBF8FB438)));
#define SBT13REG0 SBT13REG0
extern volatile uint32_t   SBT13REG0 __attribute__((section("sfrs"), address(0xBF8FB440)));
typedef struct {
  uint32_t :3;
  uint32_t SIZE:5;
  uint32_t :1;
  uint32_t PRI:1;
  uint32_t BASE:22;
} __SBT13REG0bits_t;
extern volatile __SBT13REG0bits_t SBT13REG0bits __asm__ ("SBT13REG0") __attribute__((section("sfrs"), address(0xBF8FB440)));
#define SBT13RD0 SBT13RD0
extern volatile uint32_t   SBT13RD0 __attribute__((section("sfrs"), address(0xBF8FB450)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT13RD0bits_t;
extern volatile __SBT13RD0bits_t SBT13RD0bits __asm__ ("SBT13RD0") __attribute__((section("sfrs"), address(0xBF8FB450)));
#define SBT13WR0 SBT13WR0
extern volatile uint32_t   SBT13WR0 __attribute__((section("sfrs"), address(0xBF8FB458)));
typedef struct {
  uint32_t GROUP0:1;
  uint32_t GROUP1:1;
  uint32_t GROUP2:1;
  uint32_t GROUP3:1;
} __SBT13WR0bits_t;
extern volatile __SBT13WR0bits_t SBT13WR0bits __asm__ ("SBT13WR0") __attribute__((section("sfrs"), address(0xBF8FB458)));
#define USBIE0CSR0 USBIE0CSR0
extern volatile uint32_t   USBIE0CSR0 __attribute__((section("sfrs"), address(0xBF8E3010)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t :5;
    uint32_t RXRDY:1;
    uint32_t TXRDY:1;
    uint32_t STALLED:1;
    uint32_t SETUP:1;
    uint32_t ERROR:1;
    uint32_t REQPKT:1;
    uint32_t STATUS:1;
    uint32_t NAKTO:1;
    uint32_t FLUSH:1;
    uint32_t DT:1;
    uint32_t DTWE:1;
  };
  struct {
    uint32_t :19;
    uint32_t DATAEND:1;
    uint32_t SETEND:1;
    uint32_t STALL:1;
    uint32_t RXRDYC:1;
    uint32_t SETENDC:1;
  };
} __USBIE0CSR0bits_t;
extern volatile __USBIE0CSR0bits_t USBIE0CSR0bits __asm__ ("USBIE0CSR0") __attribute__((section("sfrs"), address(0xBF8E3010)));
#define USBIENCSR0 USBIENCSR0
extern volatile uint32_t   USBIENCSR0 __attribute__((section("sfrs"), address(0xBF8E3010)));
typedef union {
  struct {
    uint32_t TXMAXP:11;
    uint32_t MULT:5;
    uint32_t TXPKTRDY:1;
    uint32_t FIFONE:1;
    uint32_t ERROR:1;
    uint32_t FLUSH:1;
    uint32_t SETUPPKT:1;
    uint32_t RXSTALL:1;
    uint32_t CLRDT:1;
    uint32_t NAKTMOUT:1;
    uint32_t DATATGGL:1;
    uint32_t DTWREN:1;
    uint32_t DMAREQMD:1;
    uint32_t FRCDATTG:1;
    uint32_t DMAREQEN:1;
    uint32_t MODE:1;
    uint32_t :1;
    uint32_t AUTOSET:1;
  };
  struct {
    uint32_t :18;
    uint32_t UNDERRUN:1;
    uint32_t :1;
    uint32_t SENDSTALL:1;
    uint32_t SENTSTALL:1;
    uint32_t :1;
    uint32_t INCOMPTX:1;
    uint32_t :6;
    uint32_t ISO:1;
  };
} __USBIENCSR0bits_t;
extern volatile __USBIENCSR0bits_t USBIENCSR0bits __asm__ ("USBIENCSR0") __attribute__((section("sfrs"), address(0xBF8E3010)));
#define USBIE0CSR2 USBIE0CSR2
extern volatile uint32_t   USBIE0CSR2 __attribute__((section("sfrs"), address(0xBF8E3018)));
typedef struct {
  uint32_t RXCNT:7;
  uint32_t :15;
  uint32_t SPEED:2;
  uint32_t NAKLIM:4;
} __USBIE0CSR2bits_t;
extern volatile __USBIE0CSR2bits_t USBIE0CSR2bits __asm__ ("USBIE0CSR2") __attribute__((section("sfrs"), address(0xBF8E3018)));
#define USBIENCSR2 USBIENCSR2
extern volatile uint32_t   USBIENCSR2 __attribute__((section("sfrs"), address(0xBF8E3018)));
typedef struct {
  uint32_t RXCNT:14;
  uint32_t :2;
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t TXINTERV:8;
} __USBIENCSR2bits_t;
extern volatile __USBIENCSR2bits_t USBIENCSR2bits __asm__ ("USBIENCSR2") __attribute__((section("sfrs"), address(0xBF8E3018)));
#define USBIE0CSR3 USBIE0CSR3
extern volatile uint32_t   USBIE0CSR3 __attribute__((section("sfrs"), address(0xBF8E301C)));
typedef struct {
  uint32_t :24;
  uint32_t UTMIDWID:1;
  uint32_t SOFTCONE:1;
  uint32_t DYNFIFOS:1;
  uint32_t HBTXEN:1;
  uint32_t HBRXEN:1;
  uint32_t BIGEND:1;
  uint32_t MPTXEN:1;
  uint32_t MPRXEN:1;
} __USBIE0CSR3bits_t;
extern volatile __USBIE0CSR3bits_t USBIE0CSR3bits __asm__ ("USBIE0CSR3") __attribute__((section("sfrs"), address(0xBF8E301C)));
#define USBIENCSR3 USBIENCSR3
extern volatile uint32_t   USBIENCSR3 __attribute__((section("sfrs"), address(0xBF8E301C)));
typedef struct {
  uint32_t TEP:4;
  uint32_t PROTOCOL:2;
  uint32_t SPEED:2;
  uint32_t RXINTERV:8;
  uint32_t :8;
  uint32_t TXFIFOSZ:4;
  uint32_t RXFIFOSZ:4;
} __USBIENCSR3bits_t;
extern volatile __USBIENCSR3bits_t USBIENCSR3bits __asm__ ("USBIENCSR3") __attribute__((section("sfrs"), address(0xBF8E301C)));
#define DEVCFG3 DEVCFG3
extern volatile uint32_t   DEVCFG3 __attribute__((section("sfrs"), address(0xBFC0FFC0)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __DEVCFG3bits_t;
extern volatile __DEVCFG3bits_t DEVCFG3bits __asm__ ("DEVCFG3") __attribute__((section("sfrs"), address(0xBFC0FFC0)));
#define DEVCFG2 DEVCFG2
extern volatile uint32_t   DEVCFG2 __attribute__((section("sfrs"), address(0xBFC0FFC4)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __DEVCFG2bits_t;
extern volatile __DEVCFG2bits_t DEVCFG2bits __asm__ ("DEVCFG2") __attribute__((section("sfrs"), address(0xBFC0FFC4)));
#define DEVCFG1 DEVCFG1
extern volatile uint32_t   DEVCFG1 __attribute__((section("sfrs"), address(0xBFC0FFC8)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __DEVCFG1bits_t;
extern volatile __DEVCFG1bits_t DEVCFG1bits __asm__ ("DEVCFG1") __attribute__((section("sfrs"), address(0xBFC0FFC8)));
#define DEVCFG0 DEVCFG0
extern volatile uint32_t   DEVCFG0 __attribute__((section("sfrs"), address(0xBFC0FFCC)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __DEVCFG0bits_t;
extern volatile __DEVCFG0bits_t DEVCFG0bits __asm__ ("DEVCFG0") __attribute__((section("sfrs"), address(0xBFC0FFCC)));
#define DEVCP3 DEVCP3
extern volatile uint32_t   DEVCP3 __attribute__((section("sfrs"), address(0xBFC0FFD0)));
#define DEVCP2 DEVCP2
extern volatile uint32_t   DEVCP2 __attribute__((section("sfrs"), address(0xBFC0FFD4)));
#define DEVCP1 DEVCP1
extern volatile uint32_t   DEVCP1 __attribute__((section("sfrs"), address(0xBFC0FFD8)));
#define DEVCP0 DEVCP0
extern volatile uint32_t   DEVCP0 __attribute__((section("sfrs"), address(0xBFC0FFDC)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __DEVCP0bits_t;
extern volatile __DEVCP0bits_t DEVCP0bits __asm__ ("DEVCP0") __attribute__((section("sfrs"), address(0xBFC0FFDC)));
#define DEVSIGN3 DEVSIGN3
extern volatile uint32_t   DEVSIGN3 __attribute__((section("sfrs"), address(0xBFC0FFE0)));
#define DEVSIGN2 DEVSIGN2
extern volatile uint32_t   DEVSIGN2 __attribute__((section("sfrs"), address(0xBFC0FFE4)));
#define DEVSIGN1 DEVSIGN1
extern volatile uint32_t   DEVSIGN1 __attribute__((section("sfrs"), address(0xBFC0FFE8)));
#define DEVSIGN0 DEVSIGN0
extern volatile uint32_t   DEVSIGN0 __attribute__((section("sfrs"), address(0xBFC0FFEC)));
#define SEQ3 SEQ3
extern volatile uint32_t   SEQ3 __attribute__((section("sfrs"), address(0xBFC0FFF0)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __SEQ3bits_t;
extern volatile __SEQ3bits_t SEQ3bits __asm__ ("SEQ3") __attribute__((section("sfrs"), address(0xBFC0FFF0)));
#define SEQ2 SEQ2
extern volatile uint32_t   SEQ2 __attribute__((section("sfrs"), address(0xBFC0FFF4)));
#define SEQ1 SEQ1
extern volatile uint32_t   SEQ1 __attribute__((section("sfrs"), address(0xBFC0FFF8)));
#define SEQ0 SEQ0
extern volatile uint32_t   SEQ0 __attribute__((section("sfrs"), address(0xBFC0FFFC)));
#define DEVADC0 DEVADC0
extern volatile uint32_t   DEVADC0 __attribute__((section("sfrs"), address(0xBFC54000)));
typedef union {
  struct {
    uint32_t ADCFG:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVADC0bits_t;
extern volatile __DEVADC0bits_t DEVADC0bits __asm__ ("DEVADC0") __attribute__((section("sfrs"), address(0xBFC54000)));
#define DEVADC1 DEVADC1
extern volatile uint32_t   DEVADC1 __attribute__((section("sfrs"), address(0xBFC54004)));
typedef union {
  struct {
    uint32_t ADCFG:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVADC1bits_t;
extern volatile __DEVADC1bits_t DEVADC1bits __asm__ ("DEVADC1") __attribute__((section("sfrs"), address(0xBFC54004)));
#define DEVADC2 DEVADC2
extern volatile uint32_t   DEVADC2 __attribute__((section("sfrs"), address(0xBFC54008)));
typedef union {
  struct {
    uint32_t ADCFG:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVADC2bits_t;
extern volatile __DEVADC2bits_t DEVADC2bits __asm__ ("DEVADC2") __attribute__((section("sfrs"), address(0xBFC54008)));
#define DEVADC3 DEVADC3
extern volatile uint32_t   DEVADC3 __attribute__((section("sfrs"), address(0xBFC5400C)));
typedef union {
  struct {
    uint32_t ADCFG:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVADC3bits_t;
extern volatile __DEVADC3bits_t DEVADC3bits __asm__ ("DEVADC3") __attribute__((section("sfrs"), address(0xBFC5400C)));
#define DEVADC4 DEVADC4
extern volatile uint32_t   DEVADC4 __attribute__((section("sfrs"), address(0xBFC54010)));
typedef union {
  struct {
    uint32_t ADCFG:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVADC4bits_t;
extern volatile __DEVADC4bits_t DEVADC4bits __asm__ ("DEVADC4") __attribute__((section("sfrs"), address(0xBFC54010)));
#define DEVADC7 DEVADC7
extern volatile uint32_t   DEVADC7 __attribute__((section("sfrs"), address(0xBFC5401C)));
typedef union {
  struct {
    uint32_t ADCFG:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVADC7bits_t;
extern volatile __DEVADC7bits_t DEVADC7bits __asm__ ("DEVADC7") __attribute__((section("sfrs"), address(0xBFC5401C)));
#define DEVSN0 DEVSN0
extern volatile uint32_t   DEVSN0 __attribute__((section("sfrs"), address(0xBFC54020)));
typedef union {
  struct {
    uint32_t SN:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVSN0bits_t;
extern volatile __DEVSN0bits_t DEVSN0bits __asm__ ("DEVSN0") __attribute__((section("sfrs"), address(0xBFC54020)));
#define DEVSN1 DEVSN1
extern volatile uint32_t   DEVSN1 __attribute__((section("sfrs"), address(0xBFC54024)));
typedef union {
  struct {
    uint32_t SN:32;
  };
  struct {
    uint32_t w:32;
  };
} __DEVSN1bits_t;
extern volatile __DEVSN1bits_t DEVSN1bits __asm__ ("DEVSN1") __attribute__((section("sfrs"), address(0xBFC54024)));
#define ADEVCFG3 ADEVCFG3
extern volatile uint32_t   ADEVCFG3 __attribute__((section("sfrs"), address(0xBFC0FF40)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __ADEVCFG3bits_t;
extern volatile __ADEVCFG3bits_t ADEVCFG3bits __asm__ ("ADEVCFG3") __attribute__((section("sfrs"), address(0xBFC0FF40)));
#define ADEVCFG2 ADEVCFG2
extern volatile uint32_t   ADEVCFG2 __attribute__((section("sfrs"), address(0xBFC0FF44)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __ADEVCFG2bits_t;
extern volatile __ADEVCFG2bits_t ADEVCFG2bits __asm__ ("ADEVCFG2") __attribute__((section("sfrs"), address(0xBFC0FF44)));
#define ADEVCFG1 ADEVCFG1
extern volatile uint32_t   ADEVCFG1 __attribute__((section("sfrs"), address(0xBFC0FF48)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __ADEVCFG1bits_t;
extern volatile __ADEVCFG1bits_t ADEVCFG1bits __asm__ ("ADEVCFG1") __attribute__((section("sfrs"), address(0xBFC0FF48)));
#define ADEVCFG0 ADEVCFG0
extern volatile uint32_t   ADEVCFG0 __attribute__((section("sfrs"), address(0xBFC0FF4C)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __ADEVCFG0bits_t;
extern volatile __ADEVCFG0bits_t ADEVCFG0bits __asm__ ("ADEVCFG0") __attribute__((section("sfrs"), address(0xBFC0FF4C)));
#define ADEVCP3 ADEVCP3
extern volatile uint32_t   ADEVCP3 __attribute__((section("sfrs"), address(0xBFC0FF50)));
#define ADEVCP2 ADEVCP2
extern volatile uint32_t   ADEVCP2 __attribute__((section("sfrs"), address(0xBFC0FF54)));
#define ADEVCP1 ADEVCP1
extern volatile uint32_t   ADEVCP1 __attribute__((section("sfrs"), address(0xBFC0FF58)));
#define ADEVCP0 ADEVCP0
extern volatile uint32_t   ADEVCP0 __attribute__((section("sfrs"), address(0xBFC0FF5C)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __ADEVCP0bits_t;
extern volatile __ADEVCP0bits_t ADEVCP0bits __asm__ ("ADEVCP0") __attribute__((section("sfrs"), address(0xBFC0FF5C)));
#define ADEVSIGN3 ADEVSIGN3
extern volatile uint32_t   ADEVSIGN3 __attribute__((section("sfrs"), address(0xBFC0FF60)));
#define ADEVSIGN2 ADEVSIGN2
extern volatile uint32_t   ADEVSIGN2 __attribute__((section("sfrs"), address(0xBFC0FF64)));
#define ADEVSIGN1 ADEVSIGN1
extern volatile uint32_t   ADEVSIGN1 __attribute__((section("sfrs"), address(0xBFC0FF68)));
#define ADEVSIGN0 ADEVSIGN0
extern volatile uint32_t   ADEVSIGN0 __attribute__((section("sfrs"), address(0xBFC0FF6C)));
#define ASEQ3 ASEQ3
extern volatile uint32_t   ASEQ3 __attribute__((section("sfrs"), address(0xBFC0FF70)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __ASEQ3bits_t;
extern volatile __ASEQ3bits_t ASEQ3bits __asm__ ("ASEQ3") __attribute__((section("sfrs"), address(0xBFC0FF70)));
#define ASEQ2 ASEQ2
extern volatile uint32_t   ASEQ2 __attribute__((section("sfrs"), address(0xBFC0FF74)));
#define ASEQ1 ASEQ1
extern volatile uint32_t   ASEQ1 __attribute__((section("sfrs"), address(0xBFC0FF78)));
#define ASEQ0 ASEQ0
extern volatile uint32_t   ASEQ0 __attribute__((section("sfrs"), address(0xBFC0FF7C)));
#define AUBADEVCFG3 AUBADEVCFG3
extern volatile uint32_t   AUBADEVCFG3 __attribute__((section("sfrs"), address(0xBFC2FF40)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __AUBADEVCFG3bits_t;
extern volatile __AUBADEVCFG3bits_t AUBADEVCFG3bits __asm__ ("AUBADEVCFG3") __attribute__((section("sfrs"), address(0xBFC2FF40)));
#define AUBADEVCFG2 AUBADEVCFG2
extern volatile uint32_t   AUBADEVCFG2 __attribute__((section("sfrs"), address(0xBFC2FF44)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __AUBADEVCFG2bits_t;
extern volatile __AUBADEVCFG2bits_t AUBADEVCFG2bits __asm__ ("AUBADEVCFG2") __attribute__((section("sfrs"), address(0xBFC2FF44)));
#define AUBADEVCFG1 AUBADEVCFG1
extern volatile uint32_t   AUBADEVCFG1 __attribute__((section("sfrs"), address(0xBFC2FF48)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __AUBADEVCFG1bits_t;
extern volatile __AUBADEVCFG1bits_t AUBADEVCFG1bits __asm__ ("AUBADEVCFG1") __attribute__((section("sfrs"), address(0xBFC2FF48)));
#define AUBADEVCFG0 AUBADEVCFG0
extern volatile uint32_t   AUBADEVCFG0 __attribute__((section("sfrs"), address(0xBFC2FF4C)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __AUBADEVCFG0bits_t;
extern volatile __AUBADEVCFG0bits_t AUBADEVCFG0bits __asm__ ("AUBADEVCFG0") __attribute__((section("sfrs"), address(0xBFC2FF4C)));
#define AUBADEVCP3 AUBADEVCP3
extern volatile uint32_t   AUBADEVCP3 __attribute__((section("sfrs"), address(0xBFC2FF50)));
#define AUBADEVCP2 AUBADEVCP2
extern volatile uint32_t   AUBADEVCP2 __attribute__((section("sfrs"), address(0xBFC2FF54)));
#define AUBADEVCP1 AUBADEVCP1
extern volatile uint32_t   AUBADEVCP1 __attribute__((section("sfrs"), address(0xBFC2FF58)));
#define AUBADEVCP0 AUBADEVCP0
extern volatile uint32_t   AUBADEVCP0 __attribute__((section("sfrs"), address(0xBFC2FF5C)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __AUBADEVCP0bits_t;
extern volatile __AUBADEVCP0bits_t AUBADEVCP0bits __asm__ ("AUBADEVCP0") __attribute__((section("sfrs"), address(0xBFC2FF5C)));
#define AUBADEVSIGN3 AUBADEVSIGN3
extern volatile uint32_t   AUBADEVSIGN3 __attribute__((section("sfrs"), address(0xBFC2FF60)));
#define AUBADEVSIGN2 AUBADEVSIGN2
extern volatile uint32_t   AUBADEVSIGN2 __attribute__((section("sfrs"), address(0xBFC2FF64)));
#define AUBADEVSIGN1 AUBADEVSIGN1
extern volatile uint32_t   AUBADEVSIGN1 __attribute__((section("sfrs"), address(0xBFC2FF68)));
#define AUBADEVSIGN0 AUBADEVSIGN0
extern volatile uint32_t   AUBADEVSIGN0 __attribute__((section("sfrs"), address(0xBFC2FF6C)));
#define AUBASEQ3 AUBASEQ3
extern volatile uint32_t   AUBASEQ3 __attribute__((section("sfrs"), address(0xBFC2FF70)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __AUBASEQ3bits_t;
extern volatile __AUBASEQ3bits_t AUBASEQ3bits __asm__ ("AUBASEQ3") __attribute__((section("sfrs"), address(0xBFC2FF70)));
#define AUBASEQ2 AUBASEQ2
extern volatile uint32_t   AUBASEQ2 __attribute__((section("sfrs"), address(0xBFC2FF74)));
#define AUBASEQ1 AUBASEQ1
extern volatile uint32_t   AUBASEQ1 __attribute__((section("sfrs"), address(0xBFC2FF78)));
#define AUBASEQ0 AUBASEQ0
extern volatile uint32_t   AUBASEQ0 __attribute__((section("sfrs"), address(0xBFC2FF7C)));
#define UBADEVCFG3 UBADEVCFG3
extern volatile uint32_t   UBADEVCFG3 __attribute__((section("sfrs"), address(0xBFC2FFC0)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __UBADEVCFG3bits_t;
extern volatile __UBADEVCFG3bits_t UBADEVCFG3bits __asm__ ("UBADEVCFG3") __attribute__((section("sfrs"), address(0xBFC2FFC0)));
#define UBADEVCFG2 UBADEVCFG2
extern volatile uint32_t   UBADEVCFG2 __attribute__((section("sfrs"), address(0xBFC2FFC4)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __UBADEVCFG2bits_t;
extern volatile __UBADEVCFG2bits_t UBADEVCFG2bits __asm__ ("UBADEVCFG2") __attribute__((section("sfrs"), address(0xBFC2FFC4)));
#define UBADEVCFG1 UBADEVCFG1
extern volatile uint32_t   UBADEVCFG1 __attribute__((section("sfrs"), address(0xBFC2FFC8)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __UBADEVCFG1bits_t;
extern volatile __UBADEVCFG1bits_t UBADEVCFG1bits __asm__ ("UBADEVCFG1") __attribute__((section("sfrs"), address(0xBFC2FFC8)));
#define UBADEVCFG0 UBADEVCFG0
extern volatile uint32_t   UBADEVCFG0 __attribute__((section("sfrs"), address(0xBFC2FFCC)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __UBADEVCFG0bits_t;
extern volatile __UBADEVCFG0bits_t UBADEVCFG0bits __asm__ ("UBADEVCFG0") __attribute__((section("sfrs"), address(0xBFC2FFCC)));
#define UBADEVCP3 UBADEVCP3
extern volatile uint32_t   UBADEVCP3 __attribute__((section("sfrs"), address(0xBFC2FFD0)));
#define UBADEVCP2 UBADEVCP2
extern volatile uint32_t   UBADEVCP2 __attribute__((section("sfrs"), address(0xBFC2FFD4)));
#define UBADEVCP1 UBADEVCP1
extern volatile uint32_t   UBADEVCP1 __attribute__((section("sfrs"), address(0xBFC2FFD8)));
#define UBADEVCP0 UBADEVCP0
extern volatile uint32_t   UBADEVCP0 __attribute__((section("sfrs"), address(0xBFC2FFDC)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __UBADEVCP0bits_t;
extern volatile __UBADEVCP0bits_t UBADEVCP0bits __asm__ ("UBADEVCP0") __attribute__((section("sfrs"), address(0xBFC2FFDC)));
#define UBADEVSIGN3 UBADEVSIGN3
extern volatile uint32_t   UBADEVSIGN3 __attribute__((section("sfrs"), address(0xBFC2FFE0)));
#define UBADEVSIGN2 UBADEVSIGN2
extern volatile uint32_t   UBADEVSIGN2 __attribute__((section("sfrs"), address(0xBFC2FFE4)));
#define UBADEVSIGN1 UBADEVSIGN1
extern volatile uint32_t   UBADEVSIGN1 __attribute__((section("sfrs"), address(0xBFC2FFE8)));
#define UBADEVSIGN0 UBADEVSIGN0
extern volatile uint32_t   UBADEVSIGN0 __attribute__((section("sfrs"), address(0xBFC2FFEC)));
#define UBASEQ3 UBASEQ3
extern volatile uint32_t   UBASEQ3 __attribute__((section("sfrs"), address(0xBFC2FFF0)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __UBASEQ3bits_t;
extern volatile __UBASEQ3bits_t UBASEQ3bits __asm__ ("UBASEQ3") __attribute__((section("sfrs"), address(0xBFC2FFF0)));
#define UBASEQ2 UBASEQ2
extern volatile uint32_t   UBASEQ2 __attribute__((section("sfrs"), address(0xBFC2FFF4)));
#define UBASEQ1 UBASEQ1
extern volatile uint32_t   UBASEQ1 __attribute__((section("sfrs"), address(0xBFC2FFF8)));
#define UBASEQ0 UBASEQ0
extern volatile uint32_t   UBASEQ0 __attribute__((section("sfrs"), address(0xBFC2FFFC)));
#define ABF1DEVCFG3 ABF1DEVCFG3
extern volatile uint32_t   ABF1DEVCFG3 __attribute__((section("sfrs"), address(0xBFC4FF40)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF1DEVCFG3bits_t;
extern volatile __ABF1DEVCFG3bits_t ABF1DEVCFG3bits __asm__ ("ABF1DEVCFG3") __attribute__((section("sfrs"), address(0xBFC4FF40)));
#define ABF1DEVCFG2 ABF1DEVCFG2
extern volatile uint32_t   ABF1DEVCFG2 __attribute__((section("sfrs"), address(0xBFC4FF44)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF1DEVCFG2bits_t;
extern volatile __ABF1DEVCFG2bits_t ABF1DEVCFG2bits __asm__ ("ABF1DEVCFG2") __attribute__((section("sfrs"), address(0xBFC4FF44)));
#define ABF1DEVCFG1 ABF1DEVCFG1
extern volatile uint32_t   ABF1DEVCFG1 __attribute__((section("sfrs"), address(0xBFC4FF48)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF1DEVCFG1bits_t;
extern volatile __ABF1DEVCFG1bits_t ABF1DEVCFG1bits __asm__ ("ABF1DEVCFG1") __attribute__((section("sfrs"), address(0xBFC4FF48)));
#define ABF1DEVCFG0 ABF1DEVCFG0
extern volatile uint32_t   ABF1DEVCFG0 __attribute__((section("sfrs"), address(0xBFC4FF4C)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __ABF1DEVCFG0bits_t;
extern volatile __ABF1DEVCFG0bits_t ABF1DEVCFG0bits __asm__ ("ABF1DEVCFG0") __attribute__((section("sfrs"), address(0xBFC4FF4C)));
#define ABF1DEVCP3 ABF1DEVCP3
extern volatile uint32_t   ABF1DEVCP3 __attribute__((section("sfrs"), address(0xBFC4FF50)));
#define ABF1DEVCP2 ABF1DEVCP2
extern volatile uint32_t   ABF1DEVCP2 __attribute__((section("sfrs"), address(0xBFC4FF54)));
#define ABF1DEVCP1 ABF1DEVCP1
extern volatile uint32_t   ABF1DEVCP1 __attribute__((section("sfrs"), address(0xBFC4FF58)));
#define ABF1DEVCP0 ABF1DEVCP0
extern volatile uint32_t   ABF1DEVCP0 __attribute__((section("sfrs"), address(0xBFC4FF5C)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF1DEVCP0bits_t;
extern volatile __ABF1DEVCP0bits_t ABF1DEVCP0bits __asm__ ("ABF1DEVCP0") __attribute__((section("sfrs"), address(0xBFC4FF5C)));
#define ABF1DEVSIGN3 ABF1DEVSIGN3
extern volatile uint32_t   ABF1DEVSIGN3 __attribute__((section("sfrs"), address(0xBFC4FF60)));
#define ABF1DEVSIGN2 ABF1DEVSIGN2
extern volatile uint32_t   ABF1DEVSIGN2 __attribute__((section("sfrs"), address(0xBFC4FF64)));
#define ABF1DEVSIGN1 ABF1DEVSIGN1
extern volatile uint32_t   ABF1DEVSIGN1 __attribute__((section("sfrs"), address(0xBFC4FF68)));
#define ABF1DEVSIGN0 ABF1DEVSIGN0
extern volatile uint32_t   ABF1DEVSIGN0 __attribute__((section("sfrs"), address(0xBFC4FF6C)));
#define ABF1SEQ3 ABF1SEQ3
extern volatile uint32_t   ABF1SEQ3 __attribute__((section("sfrs"), address(0xBFC4FF70)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __ABF1SEQ3bits_t;
extern volatile __ABF1SEQ3bits_t ABF1SEQ3bits __asm__ ("ABF1SEQ3") __attribute__((section("sfrs"), address(0xBFC4FF70)));
#define ABF1SEQ2 ABF1SEQ2
extern volatile uint32_t   ABF1SEQ2 __attribute__((section("sfrs"), address(0xBFC4FF74)));
#define ABF1SEQ1 ABF1SEQ1
extern volatile uint32_t   ABF1SEQ1 __attribute__((section("sfrs"), address(0xBFC4FF78)));
#define ABF1SEQ0 ABF1SEQ0
extern volatile uint32_t   ABF1SEQ0 __attribute__((section("sfrs"), address(0xBFC4FF7C)));
#define BF1DEVCFG3 BF1DEVCFG3
extern volatile uint32_t   BF1DEVCFG3 __attribute__((section("sfrs"), address(0xBFC4FFC0)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF1DEVCFG3bits_t;
extern volatile __BF1DEVCFG3bits_t BF1DEVCFG3bits __asm__ ("BF1DEVCFG3") __attribute__((section("sfrs"), address(0xBFC4FFC0)));
#define BF1DEVCFG2 BF1DEVCFG2
extern volatile uint32_t   BF1DEVCFG2 __attribute__((section("sfrs"), address(0xBFC4FFC4)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF1DEVCFG2bits_t;
extern volatile __BF1DEVCFG2bits_t BF1DEVCFG2bits __asm__ ("BF1DEVCFG2") __attribute__((section("sfrs"), address(0xBFC4FFC4)));
#define BF1DEVCFG1 BF1DEVCFG1
extern volatile uint32_t   BF1DEVCFG1 __attribute__((section("sfrs"), address(0xBFC4FFC8)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF1DEVCFG1bits_t;
extern volatile __BF1DEVCFG1bits_t BF1DEVCFG1bits __asm__ ("BF1DEVCFG1") __attribute__((section("sfrs"), address(0xBFC4FFC8)));
#define BF1DEVCFG0 BF1DEVCFG0
extern volatile uint32_t   BF1DEVCFG0 __attribute__((section("sfrs"), address(0xBFC4FFCC)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __BF1DEVCFG0bits_t;
extern volatile __BF1DEVCFG0bits_t BF1DEVCFG0bits __asm__ ("BF1DEVCFG0") __attribute__((section("sfrs"), address(0xBFC4FFCC)));
#define BF1DEVCP3 BF1DEVCP3
extern volatile uint32_t   BF1DEVCP3 __attribute__((section("sfrs"), address(0xBFC4FFD0)));
#define BF1DEVCP2 BF1DEVCP2
extern volatile uint32_t   BF1DEVCP2 __attribute__((section("sfrs"), address(0xBFC4FFD4)));
#define BF1DEVCP1 BF1DEVCP1
extern volatile uint32_t   BF1DEVCP1 __attribute__((section("sfrs"), address(0xBFC4FFD8)));
#define BF1DEVCP0 BF1DEVCP0
extern volatile uint32_t   BF1DEVCP0 __attribute__((section("sfrs"), address(0xBFC4FFDC)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF1DEVCP0bits_t;
extern volatile __BF1DEVCP0bits_t BF1DEVCP0bits __asm__ ("BF1DEVCP0") __attribute__((section("sfrs"), address(0xBFC4FFDC)));
#define BF1DEVSIGN3 BF1DEVSIGN3
extern volatile uint32_t   BF1DEVSIGN3 __attribute__((section("sfrs"), address(0xBFC4FFE0)));
#define BF1DEVSIGN2 BF1DEVSIGN2
extern volatile uint32_t   BF1DEVSIGN2 __attribute__((section("sfrs"), address(0xBFC4FFE4)));
#define BF1DEVSIGN1 BF1DEVSIGN1
extern volatile uint32_t   BF1DEVSIGN1 __attribute__((section("sfrs"), address(0xBFC4FFE8)));
#define BF1DEVSIGN0 BF1DEVSIGN0
extern volatile uint32_t   BF1DEVSIGN0 __attribute__((section("sfrs"), address(0xBFC4FFEC)));
#define BF1SEQ3 BF1SEQ3
extern volatile uint32_t   BF1SEQ3 __attribute__((section("sfrs"), address(0xBFC4FFF0)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __BF1SEQ3bits_t;
extern volatile __BF1SEQ3bits_t BF1SEQ3bits __asm__ ("BF1SEQ3") __attribute__((section("sfrs"), address(0xBFC4FFF0)));
#define BF1SEQ2 BF1SEQ2
extern volatile uint32_t   BF1SEQ2 __attribute__((section("sfrs"), address(0xBFC4FFF4)));
#define BF1SEQ1 BF1SEQ1
extern volatile uint32_t   BF1SEQ1 __attribute__((section("sfrs"), address(0xBFC4FFF8)));
#define BF1SEQ0 BF1SEQ0
extern volatile uint32_t   BF1SEQ0 __attribute__((section("sfrs"), address(0xBFC4FFFC)));
#define ABF2DEVCFG3 ABF2DEVCFG3
extern volatile uint32_t   ABF2DEVCFG3 __attribute__((section("sfrs"), address(0xBFC6FF40)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF2DEVCFG3bits_t;
extern volatile __ABF2DEVCFG3bits_t ABF2DEVCFG3bits __asm__ ("ABF2DEVCFG3") __attribute__((section("sfrs"), address(0xBFC6FF40)));
#define ABF2DEVCFG2 ABF2DEVCFG2
extern volatile uint32_t   ABF2DEVCFG2 __attribute__((section("sfrs"), address(0xBFC6FF44)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF2DEVCFG2bits_t;
extern volatile __ABF2DEVCFG2bits_t ABF2DEVCFG2bits __asm__ ("ABF2DEVCFG2") __attribute__((section("sfrs"), address(0xBFC6FF44)));
#define ABF2DEVCFG1 ABF2DEVCFG1
extern volatile uint32_t   ABF2DEVCFG1 __attribute__((section("sfrs"), address(0xBFC6FF48)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF2DEVCFG1bits_t;
extern volatile __ABF2DEVCFG1bits_t ABF2DEVCFG1bits __asm__ ("ABF2DEVCFG1") __attribute__((section("sfrs"), address(0xBFC6FF48)));
#define ABF2DEVCFG0 ABF2DEVCFG0
extern volatile uint32_t   ABF2DEVCFG0 __attribute__((section("sfrs"), address(0xBFC6FF4C)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __ABF2DEVCFG0bits_t;
extern volatile __ABF2DEVCFG0bits_t ABF2DEVCFG0bits __asm__ ("ABF2DEVCFG0") __attribute__((section("sfrs"), address(0xBFC6FF4C)));
#define ABF2DEVCP3 ABF2DEVCP3
extern volatile uint32_t   ABF2DEVCP3 __attribute__((section("sfrs"), address(0xBFC6FF50)));
#define ABF2DEVCP2 ABF2DEVCP2
extern volatile uint32_t   ABF2DEVCP2 __attribute__((section("sfrs"), address(0xBFC6FF54)));
#define ABF2DEVCP1 ABF2DEVCP1
extern volatile uint32_t   ABF2DEVCP1 __attribute__((section("sfrs"), address(0xBFC6FF58)));
#define ABF2DEVCP0 ABF2DEVCP0
extern volatile uint32_t   ABF2DEVCP0 __attribute__((section("sfrs"), address(0xBFC6FF5C)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __ABF2DEVCP0bits_t;
extern volatile __ABF2DEVCP0bits_t ABF2DEVCP0bits __asm__ ("ABF2DEVCP0") __attribute__((section("sfrs"), address(0xBFC6FF5C)));
#define ABF2DEVSIGN3 ABF2DEVSIGN3
extern volatile uint32_t   ABF2DEVSIGN3 __attribute__((section("sfrs"), address(0xBFC6FF60)));
#define ABF2DEVSIGN2 ABF2DEVSIGN2
extern volatile uint32_t   ABF2DEVSIGN2 __attribute__((section("sfrs"), address(0xBFC6FF64)));
#define ABF2DEVSIGN1 ABF2DEVSIGN1
extern volatile uint32_t   ABF2DEVSIGN1 __attribute__((section("sfrs"), address(0xBFC6FF68)));
#define ABF2DEVSIGN0 ABF2DEVSIGN0
extern volatile uint32_t   ABF2DEVSIGN0 __attribute__((section("sfrs"), address(0xBFC6FF6C)));
#define ABF2SEQ3 ABF2SEQ3
extern volatile uint32_t   ABF2SEQ3 __attribute__((section("sfrs"), address(0xBFC6FF70)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __ABF2SEQ3bits_t;
extern volatile __ABF2SEQ3bits_t ABF2SEQ3bits __asm__ ("ABF2SEQ3") __attribute__((section("sfrs"), address(0xBFC6FF70)));
#define ABF2SEQ2 ABF2SEQ2
extern volatile uint32_t   ABF2SEQ2 __attribute__((section("sfrs"), address(0xBFC6FF74)));
#define ABF2SEQ1 ABF2SEQ1
extern volatile uint32_t   ABF2SEQ1 __attribute__((section("sfrs"), address(0xBFC6FF78)));
#define ABF2SEQ0 ABF2SEQ0
extern volatile uint32_t   ABF2SEQ0 __attribute__((section("sfrs"), address(0xBFC6FF7C)));
#define BF2DEVCFG3 BF2DEVCFG3
extern volatile uint32_t   BF2DEVCFG3 __attribute__((section("sfrs"), address(0xBFC6FFC0)));
typedef union {
  struct {
    uint32_t USERID:16;
    uint32_t :8;
    uint32_t FMIIEN:1;
    uint32_t FETHIO:1;
    uint32_t :1;
    uint32_t PGL1WAY:1;
    uint32_t PMDL1WAY:1;
    uint32_t IOL1WAY:1;
    uint32_t FUSBIDIO:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF2DEVCFG3bits_t;
extern volatile __BF2DEVCFG3bits_t BF2DEVCFG3bits __asm__ ("BF2DEVCFG3") __attribute__((section("sfrs"), address(0xBFC6FFC0)));
#define BF2DEVCFG2 BF2DEVCFG2
extern volatile uint32_t   BF2DEVCFG2 __attribute__((section("sfrs"), address(0xBFC6FFC4)));
typedef union {
  struct {
    uint32_t FPLLIDIV:3;
    uint32_t :1;
    uint32_t FPLLRNG:3;
    uint32_t FPLLICLK:1;
    uint32_t FPLLMULT:7;
    uint32_t :1;
    uint32_t FPLLODIV:3;
    uint32_t :11;
    uint32_t UPLLFSEL:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF2DEVCFG2bits_t;
extern volatile __BF2DEVCFG2bits_t BF2DEVCFG2bits __asm__ ("BF2DEVCFG2") __attribute__((section("sfrs"), address(0xBFC6FFC4)));
#define BF2DEVCFG1 BF2DEVCFG1
extern volatile uint32_t   BF2DEVCFG1 __attribute__((section("sfrs"), address(0xBFC6FFC8)));
typedef union {
  struct {
    uint32_t FNOSC:3;
    uint32_t DMTINTV:3;
    uint32_t FSOSCEN:1;
    uint32_t IESO:1;
    uint32_t POSCMOD:2;
    uint32_t OSCIOFNC:1;
    uint32_t :3;
    uint32_t FCKSM:2;
    uint32_t WDTPS:5;
    uint32_t WDTSPGM:1;
    uint32_t WINDIS:1;
    uint32_t FWDTEN:1;
    uint32_t FWDTWINSZ:2;
    uint32_t DMTCNT:5;
    uint32_t FDMTEN:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF2DEVCFG1bits_t;
extern volatile __BF2DEVCFG1bits_t BF2DEVCFG1bits __asm__ ("BF2DEVCFG1") __attribute__((section("sfrs"), address(0xBFC6FFC8)));
#define BF2DEVCFG0 BF2DEVCFG0
extern volatile uint32_t   BF2DEVCFG0 __attribute__((section("sfrs"), address(0xBFC6FFCC)));
typedef union {
  struct {
    uint32_t DEBUG:2;
    uint32_t JTAGEN:1;
    uint32_t ICESEL:2;
    uint32_t TRCEN:1;
    uint32_t BOOTISA:1;
    uint32_t :1;
    uint32_t FECCCON:2;
    uint32_t FSLEEP:1;
    uint32_t :1;
    uint32_t DBGPER:3;
    uint32_t SMCLR:1;
    uint32_t SOSCGAIN:2;
    uint32_t SOSCBOOST:1;
    uint32_t POSCGAIN:2;
    uint32_t POSCBOOST:1;
    uint32_t :8;
    uint32_t EJTAGBEN:1;
  };
  struct {
    uint32_t FDEBUG:2;
  };
  struct {
    uint32_t w:32;
  };
} __BF2DEVCFG0bits_t;
extern volatile __BF2DEVCFG0bits_t BF2DEVCFG0bits __asm__ ("BF2DEVCFG0") __attribute__((section("sfrs"), address(0xBFC6FFCC)));
#define BF2DEVCP3 BF2DEVCP3
extern volatile uint32_t   BF2DEVCP3 __attribute__((section("sfrs"), address(0xBFC6FFD0)));
#define BF2DEVCP2 BF2DEVCP2
extern volatile uint32_t   BF2DEVCP2 __attribute__((section("sfrs"), address(0xBFC6FFD4)));
#define BF2DEVCP1 BF2DEVCP1
extern volatile uint32_t   BF2DEVCP1 __attribute__((section("sfrs"), address(0xBFC6FFD8)));
#define BF2DEVCP0 BF2DEVCP0
extern volatile uint32_t   BF2DEVCP0 __attribute__((section("sfrs"), address(0xBFC6FFDC)));
typedef union {
  struct {
    uint32_t :28;
    uint32_t CP:1;
  };
  struct {
    uint32_t w:32;
  };
} __BF2DEVCP0bits_t;
extern volatile __BF2DEVCP0bits_t BF2DEVCP0bits __asm__ ("BF2DEVCP0") __attribute__((section("sfrs"), address(0xBFC6FFDC)));
#define BF2DEVSIGN3 BF2DEVSIGN3
extern volatile uint32_t   BF2DEVSIGN3 __attribute__((section("sfrs"), address(0xBFC6FFE0)));
#define BF2DEVSIGN2 BF2DEVSIGN2
extern volatile uint32_t   BF2DEVSIGN2 __attribute__((section("sfrs"), address(0xBFC6FFE4)));
#define BF2DEVSIGN1 BF2DEVSIGN1
extern volatile uint32_t   BF2DEVSIGN1 __attribute__((section("sfrs"), address(0xBFC6FFE8)));
#define BF2DEVSIGN0 BF2DEVSIGN0
extern volatile uint32_t   BF2DEVSIGN0 __attribute__((section("sfrs"), address(0xBFC6FFEC)));
#define BF2SEQ3 BF2SEQ3
extern volatile uint32_t   BF2SEQ3 __attribute__((section("sfrs"), address(0xBFC6FFF0)));
typedef union {
  struct {
    uint32_t TSEQ:16;
    uint32_t CSEQ:16;
  };
  struct {
    uint32_t w:32;
  };
} __BF2SEQ3bits_t;
extern volatile __BF2SEQ3bits_t BF2SEQ3bits __asm__ ("BF2SEQ3") __attribute__((section("sfrs"), address(0xBFC6FFF0)));
#define BF2SEQ2 BF2SEQ2
extern volatile uint32_t   BF2SEQ2 __attribute__((section("sfrs"), address(0xBFC6FFF4)));
#define BF2SEQ1 BF2SEQ1
extern volatile uint32_t   BF2SEQ1 __attribute__((section("sfrs"), address(0xBFC6FFF8)));
#define BF2SEQ0 BF2SEQ0
extern volatile uint32_t   BF2SEQ0 __attribute__((section("sfrs"), address(0xBFC6FFFC)));
#ifdef __cplusplus
}
#endif

#elif defined (__LANGUAGE_ASSEMBLY__)
  .extern CFGCON           /* 0xBF800000 */
  .extern DEVID            /* 0xBF800020 */
  .extern SYSKEY           /* 0xBF800030 */
  .extern PMD1             /* 0xBF800040 */
  .extern PMD1CLR          /* 0xBF800044 */
  .extern PMD1SET          /* 0xBF800048 */
  .extern PMD1INV          /* 0xBF80004C */
  .extern PMD2             /* 0xBF800050 */
  .extern PMD2CLR          /* 0xBF800054 */
  .extern PMD2SET          /* 0xBF800058 */
  .extern PMD2INV          /* 0xBF80005C */
  .extern PMD3             /* 0xBF800060 */
  .extern PMD3CLR          /* 0xBF800064 */
  .extern PMD3SET          /* 0xBF800068 */
  .extern PMD3INV          /* 0xBF80006C */
  .extern PMD4             /* 0xBF800070 */
  .extern PMD4CLR          /* 0xBF800074 */
  .extern PMD4SET          /* 0xBF800078 */
  .extern PMD4INV          /* 0xBF80007C */
  .extern PMD5             /* 0xBF800080 */
  .extern PMD5CLR          /* 0xBF800084 */
  .extern PMD5SET          /* 0xBF800088 */
  .extern PMD5INV          /* 0xBF80008C */
  .extern PMD6             /* 0xBF800090 */
  .extern PMD6CLR          /* 0xBF800094 */
  .extern PMD6SET          /* 0xBF800098 */
  .extern PMD6INV          /* 0xBF80009C */
  .extern PMD7             /* 0xBF8000A0 */
  .extern PMD7CLR          /* 0xBF8000A4 */
  .extern PMD7SET          /* 0xBF8000A8 */
  .extern PMD7INV          /* 0xBF8000AC */
  .extern CFGPG            /* 0xBF8000E0 */
  .extern NVMCON           /* 0xBF800600 */
  .extern NVMCONCLR        /* 0xBF800604 */
  .extern NVMCONSET        /* 0xBF800608 */
  .extern NVMCONINV        /* 0xBF80060C */
  .extern NVMKEY           /* 0xBF800610 */
  .extern NVMADDR          /* 0xBF800620 */
  .extern NVMADDRCLR       /* 0xBF800624 */
  .extern NVMADDRSET       /* 0xBF800628 */
  .extern NVMADDRINV       /* 0xBF80062C */
  .extern NVMDATA0         /* 0xBF800630 */
  .extern NVMDATA0CLR      /* 0xBF800634 */
  .extern NVMDATA0SET      /* 0xBF800638 */
  .extern NVMDATA0INV      /* 0xBF80063C */
  .extern NVMDATA1         /* 0xBF800640 */
  .extern NVMDATA1CLR      /* 0xBF800644 */
  .extern NVMDATA1SET      /* 0xBF800648 */
  .extern NVMDATA1INV      /* 0xBF80064C */
  .extern NVMDATA2         /* 0xBF800650 */
  .extern NVMDATA2CLR      /* 0xBF800654 */
  .extern NVMDATA2SET      /* 0xBF800658 */
  .extern NVMDATA2INV      /* 0xBF80065C */
  .extern NVMDATA3         /* 0xBF800660 */
  .extern NVMDATA3CLR      /* 0xBF800664 */
  .extern NVMDATA3SET      /* 0xBF800668 */
  .extern NVMDATA3INV      /* 0xBF80066C */
  .extern NVMSRCADDR       /* 0xBF800670 */
  .extern NVMSRCADDRCLR    /* 0xBF800674 */
  .extern NVMSRCADDRSET    /* 0xBF800678 */
  .extern NVMSRCADDRINV    /* 0xBF80067C */
  .extern NVMPWP           /* 0xBF800680 */
  .extern NVMPWPCLR        /* 0xBF800684 */
  .extern NVMPWPSET        /* 0xBF800688 */
  .extern NVMPWPINV        /* 0xBF80068C */
  .extern NVMBWP           /* 0xBF800690 */
  .extern NVMBWPCLR        /* 0xBF800694 */
  .extern NVMBWPSET        /* 0xBF800698 */
  .extern NVMBWPINV        /* 0xBF80069C */
  .extern NVMCON2          /* 0xBF8006A0 */
  .extern NVMCON2CLR       /* 0xBF8006A4 */
  .extern NVMCON2SET       /* 0xBF8006A8 */
  .extern NVMCON2INV       /* 0xBF8006AC */
  .extern WDTCON           /* 0xBF800800 */
  .extern WDTCONCLR        /* 0xBF800804 */
  .extern WDTCONSET        /* 0xBF800808 */
  .extern WDTCONINV        /* 0xBF80080C */
  .extern DMTCON           /* 0xBF800A00 */
  .extern DMTPRECLR        /* 0xBF800A10 */
  .extern DMTCLR           /* 0xBF800A20 */
  .extern DMTSTAT          /* 0xBF800A30 */
  .extern DMTCNT           /* 0xBF800A40 */
  .extern DMTPSCNT         /* 0xBF800A60 */
  .extern DMTPSINTV        /* 0xBF800A70 */
  .extern RTCCON           /* 0xBF800C00 */
  .extern RTCCONCLR        /* 0xBF800C04 */
  .extern RTCCONSET        /* 0xBF800C08 */
  .extern RTCCONINV        /* 0xBF800C0C */
  .extern RTCALRM          /* 0xBF800C10 */
  .extern RTCALRMCLR       /* 0xBF800C14 */
  .extern RTCALRMSET       /* 0xBF800C18 */
  .extern RTCALRMINV       /* 0xBF800C1C */
  .extern RTCTIME          /* 0xBF800C20 */
  .extern RTCTIMECLR       /* 0xBF800C24 */
  .extern RTCTIMESET       /* 0xBF800C28 */
  .extern RTCTIMEINV       /* 0xBF800C2C */
  .extern RTCDATE          /* 0xBF800C30 */
  .extern RTCDATECLR       /* 0xBF800C34 */
  .extern RTCDATESET       /* 0xBF800C38 */
  .extern RTCDATEINV       /* 0xBF800C3C */
  .extern ALRMTIME         /* 0xBF800C40 */
  .extern ALRMTIMECLR      /* 0xBF800C44 */
  .extern ALRMTIMESET      /* 0xBF800C48 */
  .extern ALRMTIMEINV      /* 0xBF800C4C */
  .extern ALRMDATE         /* 0xBF800C50 */
  .extern ALRMDATECLR      /* 0xBF800C54 */
  .extern ALRMDATESET      /* 0xBF800C58 */
  .extern ALRMDATEINV      /* 0xBF800C5C */
  .extern CVRCON           /* 0xBF800E00 */
  .extern CVRCONCLR        /* 0xBF800E04 */
  .extern CVRCONSET        /* 0xBF800E08 */
  .extern CVRCONINV        /* 0xBF800E0C */
  .extern _ICDCON          /* 0xBF801130 */
  .extern _ICDSTAT         /* 0xBF801140 */
  .extern OSCCON           /* 0xBF801200 */
  .extern OSCCONCLR        /* 0xBF801204 */
  .extern OSCCONSET        /* 0xBF801208 */
  .extern OSCCONINV        /* 0xBF80120C */
  .extern OSCTUN           /* 0xBF801210 */
  .extern OSCTUNCLR        /* 0xBF801214 */
  .extern OSCTUNSET        /* 0xBF801218 */
  .extern OSCTUNINV        /* 0xBF80121C */
  .extern SPLLCON          /* 0xBF801220 */
  .extern SPLLCONCLR       /* 0xBF801224 */
  .extern SPLLCONSET       /* 0xBF801228 */
  .extern SPLLCONINV       /* 0xBF80122C */
  .extern RCON             /* 0xBF801240 */
  .extern RCONCLR          /* 0xBF801244 */
  .extern RCONSET          /* 0xBF801248 */
  .extern RCONINV          /* 0xBF80124C */
  .extern RSWRST           /* 0xBF801250 */
  .extern RSWRSTCLR        /* 0xBF801254 */
  .extern RSWRSTSET        /* 0xBF801258 */
  .extern RSWRSTINV        /* 0xBF80125C */
  .extern RNMICON          /* 0xBF801260 */
  .extern RNMICONCLR       /* 0xBF801264 */
  .extern RNMICONSET       /* 0xBF801268 */
  .extern RNMICONINV       /* 0xBF80126C */
  .extern PWRCON           /* 0xBF801270 */
  .extern PWRCONCLR        /* 0xBF801274 */
  .extern PWRCONSET        /* 0xBF801278 */
  .extern PWRCONINV        /* 0xBF80127C */
  .extern REFO1CON         /* 0xBF801280 */
  .extern REFO1CONCLR      /* 0xBF801284 */
  .extern REFO1CONSET      /* 0xBF801288 */
  .extern REFO1CONINV      /* 0xBF80128C */
  .extern REFO1TRIM        /* 0xBF801290 */
  .extern REFO1TRIMCLR     /* 0xBF801294 */
  .extern REFO1TRIMSET     /* 0xBF801298 */
  .extern REFO1TRIMINV     /* 0xBF80129C */
  .extern REFO2CON         /* 0xBF8012A0 */
  .extern REFO2CONCLR      /* 0xBF8012A4 */
  .extern REFO2CONSET      /* 0xBF8012A8 */
  .extern REFO2CONINV      /* 0xBF8012AC */
  .extern REFO2TRIM        /* 0xBF8012B0 */
  .extern REFO2TRIMCLR     /* 0xBF8012B4 */
  .extern REFO2TRIMSET     /* 0xBF8012B8 */
  .extern REFO2TRIMINV     /* 0xBF8012BC */
  .extern REFO3CON         /* 0xBF8012C0 */
  .extern REFO3CONCLR      /* 0xBF8012C4 */
  .extern REFO3CONSET      /* 0xBF8012C8 */
  .extern REFO3CONINV      /* 0xBF8012CC */
  .extern REFO3TRIM        /* 0xBF8012D0 */
  .extern REFO3TRIMCLR     /* 0xBF8012D4 */
  .extern REFO3TRIMSET     /* 0xBF8012D8 */
  .extern REFO3TRIMINV     /* 0xBF8012DC */
  .extern REFO4CON         /* 0xBF8012E0 */
  .extern REFO4CONCLR      /* 0xBF8012E4 */
  .extern REFO4CONSET      /* 0xBF8012E8 */
  .extern REFO4CONINV      /* 0xBF8012EC */
  .extern REFO4TRIM        /* 0xBF8012F0 */
  .extern REFO4TRIMCLR     /* 0xBF8012F4 */
  .extern REFO4TRIMSET     /* 0xBF8012F8 */
  .extern REFO4TRIMINV     /* 0xBF8012FC */
  .extern PB1DIV           /* 0xBF801300 */
  .extern PB1DIVCLR        /* 0xBF801304 */
  .extern PB1DIVSET        /* 0xBF801308 */
  .extern PB1DIVINV        /* 0xBF80130C */
  .extern PB2DIV           /* 0xBF801310 */
  .extern PB2DIVCLR        /* 0xBF801314 */
  .extern PB2DIVSET        /* 0xBF801318 */
  .extern PB2DIVINV        /* 0xBF80131C */
  .extern PB3DIV           /* 0xBF801320 */
  .extern PB3DIVCLR        /* 0xBF801324 */
  .extern PB3DIVSET        /* 0xBF801328 */
  .extern PB3DIVINV        /* 0xBF80132C */
  .extern PB4DIV           /* 0xBF801330 */
  .extern PB4DIVCLR        /* 0xBF801334 */
  .extern PB4DIVSET        /* 0xBF801338 */
  .extern PB4DIVINV        /* 0xBF80133C */
  .extern PB5DIV           /* 0xBF801340 */
  .extern PB5DIVCLR        /* 0xBF801344 */
  .extern PB5DIVSET        /* 0xBF801348 */
  .extern PB5DIVINV        /* 0xBF80134C */
  .extern PB7DIV           /* 0xBF801360 */
  .extern PB7DIVCLR        /* 0xBF801364 */
  .extern PB7DIVSET        /* 0xBF801368 */
  .extern PB7DIVINV        /* 0xBF80136C */
  .extern PB8DIV           /* 0xBF801370 */
  .extern PB8DIVCLR        /* 0xBF801374 */
  .extern PB8DIVSET        /* 0xBF801378 */
  .extern PB8DIVINV        /* 0xBF80137C */
  .extern SLEWCON          /* 0xBF8013C0 */
  .extern SLEWCONCLR       /* 0xBF8013C4 */
  .extern SLEWCONSET       /* 0xBF8013C8 */
  .extern SLEWCONINV       /* 0xBF8013CC */
  .extern CLKSTAT          /* 0xBF8013D0 */
  .extern CLKSTATCLR       /* 0xBF8013D4 */
  .extern CLKSTATSET       /* 0xBF8013D8 */
  .extern CLKSTATINV       /* 0xBF8013DC */
  .extern INT1R            /* 0xBF801404 */
  .extern INT2R            /* 0xBF801408 */
  .extern INT3R            /* 0xBF80140C */
  .extern INT4R            /* 0xBF801410 */
  .extern T2CKR            /* 0xBF801418 */
  .extern T3CKR            /* 0xBF80141C */
  .extern T4CKR            /* 0xBF801420 */
  .extern T5CKR            /* 0xBF801424 */
  .extern T6CKR            /* 0xBF801428 */
  .extern T7CKR            /* 0xBF80142C */
  .extern T8CKR            /* 0xBF801430 */
  .extern T9CKR            /* 0xBF801434 */
  .extern IC1R             /* 0xBF801438 */
  .extern IC2R             /* 0xBF80143C */
  .extern IC3R             /* 0xBF801440 */
  .extern IC4R             /* 0xBF801444 */
  .extern IC5R             /* 0xBF801448 */
  .extern IC6R             /* 0xBF80144C */
  .extern IC7R             /* 0xBF801450 */
  .extern IC8R             /* 0xBF801454 */
  .extern IC9R             /* 0xBF801458 */
  .extern OCFAR            /* 0xBF801460 */
  .extern U1RXR            /* 0xBF801468 */
  .extern U1CTSR           /* 0xBF80146C */
  .extern U2RXR            /* 0xBF801470 */
  .extern U2CTSR           /* 0xBF801474 */
  .extern U3RXR            /* 0xBF801478 */
  .extern U3CTSR           /* 0xBF80147C */
  .extern U4RXR            /* 0xBF801480 */
  .extern U4CTSR           /* 0xBF801484 */
  .extern U5RXR            /* 0xBF801488 */
  .extern U5CTSR           /* 0xBF80148C */
  .extern U6RXR            /* 0xBF801490 */
  .extern U6CTSR           /* 0xBF801494 */
  .extern SDI1R            /* 0xBF80149C */
  .extern SS1R             /* 0xBF8014A0 */
  .extern SDI2R            /* 0xBF8014A8 */
  .extern SS2R             /* 0xBF8014AC */
  .extern SDI3R            /* 0xBF8014B4 */
  .extern SS3R             /* 0xBF8014B8 */
  .extern SDI4R            /* 0xBF8014C0 */
  .extern SS4R             /* 0xBF8014C4 */
  .extern C1RXR            /* 0xBF8014E0 */
  .extern C2RXR            /* 0xBF8014E4 */
  .extern REFCLKI1R        /* 0xBF8014E8 */
  .extern REFCLKI3R        /* 0xBF8014F0 */
  .extern REFCLKI4R        /* 0xBF8014F4 */
  .extern RPB0R            /* 0xBF801540 */
  .extern RPB1R            /* 0xBF801544 */
  .extern RPB2R            /* 0xBF801548 */
  .extern RPB3R            /* 0xBF80154C */
  .extern RPB5R            /* 0xBF801554 */
  .extern RPB6R            /* 0xBF801558 */
  .extern RPB7R            /* 0xBF80155C */
  .extern RPB8R            /* 0xBF801560 */
  .extern RPB9R            /* 0xBF801564 */
  .extern RPB10R           /* 0xBF801568 */
  .extern RPB14R           /* 0xBF801578 */
  .extern RPB15R           /* 0xBF80157C */
  .extern RPC13R           /* 0xBF8015B4 */
  .extern RPC14R           /* 0xBF8015B8 */
  .extern RPD0R            /* 0xBF8015C0 */
  .extern RPD1R            /* 0xBF8015C4 */
  .extern RPD2R            /* 0xBF8015C8 */
  .extern RPD3R            /* 0xBF8015CC */
  .extern RPD4R            /* 0xBF8015D0 */
  .extern RPD5R            /* 0xBF8015D4 */
  .extern RPD9R            /* 0xBF8015E4 */
  .extern RPD10R           /* 0xBF8015E8 */
  .extern RPD11R           /* 0xBF8015EC */
  .extern RPE3R            /* 0xBF80160C */
  .extern RPE5R            /* 0xBF801614 */
  .extern RPF0R            /* 0xBF801640 */
  .extern RPF1R            /* 0xBF801644 */
  .extern RPF3R            /* 0xBF80164C */
  .extern RPF4R            /* 0xBF801650 */
  .extern RPF5R            /* 0xBF801654 */
  .extern RPG6R            /* 0xBF801698 */
  .extern RPG7R            /* 0xBF80169C */
  .extern RPG8R            /* 0xBF8016A0 */
  .extern RPG9R            /* 0xBF8016A4 */
  .extern INTCON           /* 0xBF810000 */
  .extern INTCONCLR        /* 0xBF810004 */
  .extern INTCONSET        /* 0xBF810008 */
  .extern INTCONINV        /* 0xBF81000C */
  .extern PRISS            /* 0xBF810010 */
  .extern PRISSCLR         /* 0xBF810014 */
  .extern PRISSSET         /* 0xBF810018 */
  .extern PRISSINV         /* 0xBF81001C */
  .extern INTSTAT          /* 0xBF810020 */
  .extern INTSTATCLR       /* 0xBF810024 */
  .extern INTSTATSET       /* 0xBF810028 */
  .extern INTSTATINV       /* 0xBF81002C */
  .extern IPTMR            /* 0xBF810030 */
  .extern IPTMRCLR         /* 0xBF810034 */
  .extern IPTMRSET         /* 0xBF810038 */
  .extern IPTMRINV         /* 0xBF81003C */
  .extern IFS0             /* 0xBF810040 */
  .extern IFS0CLR          /* 0xBF810044 */
  .extern IFS0SET          /* 0xBF810048 */
  .extern IFS0INV          /* 0xBF81004C */
  .extern IFS1             /* 0xBF810050 */
  .extern IFS1CLR          /* 0xBF810054 */
  .extern IFS1SET          /* 0xBF810058 */
  .extern IFS1INV          /* 0xBF81005C */
  .extern IFS2             /* 0xBF810060 */
  .extern IFS2CLR          /* 0xBF810064 */
  .extern IFS2SET          /* 0xBF810068 */
  .extern IFS2INV          /* 0xBF81006C */
  .extern IFS3             /* 0xBF810070 */
  .extern IFS3CLR          /* 0xBF810074 */
  .extern IFS3SET          /* 0xBF810078 */
  .extern IFS3INV          /* 0xBF81007C */
  .extern IFS4             /* 0xBF810080 */
  .extern IFS4CLR          /* 0xBF810084 */
  .extern IFS4SET          /* 0xBF810088 */
  .extern IFS4INV          /* 0xBF81008C */
  .extern IFS5             /* 0xBF810090 */
  .extern IFS5CLR          /* 0xBF810094 */
  .extern IFS5SET          /* 0xBF810098 */
  .extern IFS5INV          /* 0xBF81009C */
  .extern IFS6             /* 0xBF8100A0 */
  .extern IFS6CLR          /* 0xBF8100A4 */
  .extern IFS6SET          /* 0xBF8100A8 */
  .extern IFS6INV          /* 0xBF8100AC */
  .extern IEC0             /* 0xBF8100C0 */
  .extern IEC0CLR          /* 0xBF8100C4 */
  .extern IEC0SET          /* 0xBF8100C8 */
  .extern IEC0INV          /* 0xBF8100CC */
  .extern IEC1             /* 0xBF8100D0 */
  .extern IEC1CLR          /* 0xBF8100D4 */
  .extern IEC1SET          /* 0xBF8100D8 */
  .extern IEC1INV          /* 0xBF8100DC */
  .extern IEC2             /* 0xBF8100E0 */
  .extern IEC2CLR          /* 0xBF8100E4 */
  .extern IEC2SET          /* 0xBF8100E8 */
  .extern IEC2INV          /* 0xBF8100EC */
  .extern IEC3             /* 0xBF8100F0 */
  .extern IEC3CLR          /* 0xBF8100F4 */
  .extern IEC3SET          /* 0xBF8100F8 */
  .extern IEC3INV          /* 0xBF8100FC */
  .extern IEC4             /* 0xBF810100 */
  .extern IEC4CLR          /* 0xBF810104 */
  .extern IEC4SET          /* 0xBF810108 */
  .extern IEC4INV          /* 0xBF81010C */
  .extern IEC5             /* 0xBF810110 */
  .extern IEC5CLR          /* 0xBF810114 */
  .extern IEC5SET          /* 0xBF810118 */
  .extern IEC5INV          /* 0xBF81011C */
  .extern IEC6             /* 0xBF810120 */
  .extern IEC6CLR          /* 0xBF810124 */
  .extern IEC6SET          /* 0xBF810128 */
  .extern IEC6INV          /* 0xBF81012C */
  .extern IPC0             /* 0xBF810140 */
  .extern IPC0CLR          /* 0xBF810144 */
  .extern IPC0SET          /* 0xBF810148 */
  .extern IPC0INV          /* 0xBF81014C */
  .extern IPC1             /* 0xBF810150 */
  .extern IPC1CLR          /* 0xBF810154 */
  .extern IPC1SET          /* 0xBF810158 */
  .extern IPC1INV          /* 0xBF81015C */
  .extern IPC2             /* 0xBF810160 */
  .extern IPC2CLR          /* 0xBF810164 */
  .extern IPC2SET          /* 0xBF810168 */
  .extern IPC2INV          /* 0xBF81016C */
  .extern IPC3             /* 0xBF810170 */
  .extern IPC3CLR          /* 0xBF810174 */
  .extern IPC3SET          /* 0xBF810178 */
  .extern IPC3INV          /* 0xBF81017C */
  .extern IPC4             /* 0xBF810180 */
  .extern IPC4CLR          /* 0xBF810184 */
  .extern IPC4SET          /* 0xBF810188 */
  .extern IPC4INV          /* 0xBF81018C */
  .extern IPC5             /* 0xBF810190 */
  .extern IPC5CLR          /* 0xBF810194 */
  .extern IPC5SET          /* 0xBF810198 */
  .extern IPC5INV          /* 0xBF81019C */
  .extern IPC6             /* 0xBF8101A0 */
  .extern IPC6CLR          /* 0xBF8101A4 */
  .extern IPC6SET          /* 0xBF8101A8 */
  .extern IPC6INV          /* 0xBF8101AC */
  .extern IPC7             /* 0xBF8101B0 */
  .extern IPC7CLR          /* 0xBF8101B4 */
  .extern IPC7SET          /* 0xBF8101B8 */
  .extern IPC7INV          /* 0xBF8101BC */
  .extern IPC8             /* 0xBF8101C0 */
  .extern IPC8CLR          /* 0xBF8101C4 */
  .extern IPC8SET          /* 0xBF8101C8 */
  .extern IPC8INV          /* 0xBF8101CC */
  .extern IPC9             /* 0xBF8101D0 */
  .extern IPC9CLR          /* 0xBF8101D4 */
  .extern IPC9SET          /* 0xBF8101D8 */
  .extern IPC9INV          /* 0xBF8101DC */
  .extern IPC10            /* 0xBF8101E0 */
  .extern IPC10CLR         /* 0xBF8101E4 */
  .extern IPC10SET         /* 0xBF8101E8 */
  .extern IPC10INV         /* 0xBF8101EC */
  .extern IPC11            /* 0xBF8101F0 */
  .extern IPC11CLR         /* 0xBF8101F4 */
  .extern IPC11SET         /* 0xBF8101F8 */
  .extern IPC11INV         /* 0xBF8101FC */
  .extern IPC12            /* 0xBF810200 */
  .extern IPC12CLR         /* 0xBF810204 */
  .extern IPC12SET         /* 0xBF810208 */
  .extern IPC12INV         /* 0xBF81020C */
  .extern IPC13            /* 0xBF810210 */
  .extern IPC13CLR         /* 0xBF810214 */
  .extern IPC13SET         /* 0xBF810218 */
  .extern IPC13INV         /* 0xBF81021C */
  .extern IPC14            /* 0xBF810220 */
  .extern IPC14CLR         /* 0xBF810224 */
  .extern IPC14SET         /* 0xBF810228 */
  .extern IPC14INV         /* 0xBF81022C */
  .extern IPC15            /* 0xBF810230 */
  .extern IPC15CLR         /* 0xBF810234 */
  .extern IPC15SET         /* 0xBF810238 */
  .extern IPC15INV         /* 0xBF81023C */
  .extern IPC16            /* 0xBF810240 */
  .extern IPC16CLR         /* 0xBF810244 */
  .extern IPC16SET         /* 0xBF810248 */
  .extern IPC16INV         /* 0xBF81024C */
  .extern IPC17            /* 0xBF810250 */
  .extern IPC17CLR         /* 0xBF810254 */
  .extern IPC17SET         /* 0xBF810258 */
  .extern IPC17INV         /* 0xBF81025C */
  .extern IPC18            /* 0xBF810260 */
  .extern IPC18CLR         /* 0xBF810264 */
  .extern IPC18SET         /* 0xBF810268 */
  .extern IPC18INV         /* 0xBF81026C */
  .extern IPC19            /* 0xBF810270 */
  .extern IPC19CLR         /* 0xBF810274 */
  .extern IPC19SET         /* 0xBF810278 */
  .extern IPC19INV         /* 0xBF81027C */
  .extern IPC25            /* 0xBF8102D0 */
  .extern IPC25CLR         /* 0xBF8102D4 */
  .extern IPC25SET         /* 0xBF8102D8 */
  .extern IPC25INV         /* 0xBF8102DC */
  .extern IPC26            /* 0xBF8102E0 */
  .extern IPC26CLR         /* 0xBF8102E4 */
  .extern IPC26SET         /* 0xBF8102E8 */
  .extern IPC26INV         /* 0xBF8102EC */
  .extern IPC27            /* 0xBF8102F0 */
  .extern IPC27CLR         /* 0xBF8102F4 */
  .extern IPC27SET         /* 0xBF8102F8 */
  .extern IPC27INV         /* 0xBF8102FC */
  .extern IPC28            /* 0xBF810300 */
  .extern IPC28CLR         /* 0xBF810304 */
  .extern IPC28SET         /* 0xBF810308 */
  .extern IPC28INV         /* 0xBF81030C */
  .extern IPC29            /* 0xBF810310 */
  .extern IPC29CLR         /* 0xBF810314 */
  .extern IPC29SET         /* 0xBF810318 */
  .extern IPC29INV         /* 0xBF81031C */
  .extern IPC30            /* 0xBF810320 */
  .extern IPC30CLR         /* 0xBF810324 */
  .extern IPC30SET         /* 0xBF810328 */
  .extern IPC30INV         /* 0xBF81032C */
  .extern IPC31            /* 0xBF810330 */
  .extern IPC31CLR         /* 0xBF810334 */
  .extern IPC31SET         /* 0xBF810338 */
  .extern IPC31INV         /* 0xBF81033C */
  .extern IPC32            /* 0xBF810340 */
  .extern IPC32CLR         /* 0xBF810344 */
  .extern IPC32SET         /* 0xBF810348 */
  .extern IPC32INV         /* 0xBF81034C */
  .extern IPC33            /* 0xBF810350 */
  .extern IPC33CLR         /* 0xBF810354 */
  .extern IPC33SET         /* 0xBF810358 */
  .extern IPC33INV         /* 0xBF81035C */
  .extern IPC34            /* 0xBF810360 */
  .extern IPC34CLR         /* 0xBF810364 */
  .extern IPC34SET         /* 0xBF810368 */
  .extern IPC34INV         /* 0xBF81036C */
  .extern IPC35            /* 0xBF810370 */
  .extern IPC35CLR         /* 0xBF810374 */
  .extern IPC35SET         /* 0xBF810378 */
  .extern IPC35INV         /* 0xBF81037C */
  .extern IPC36            /* 0xBF810380 */
  .extern IPC36CLR         /* 0xBF810384 */
  .extern IPC36SET         /* 0xBF810388 */
  .extern IPC36INV         /* 0xBF81038C */
  .extern IPC37            /* 0xBF810390 */
  .extern IPC37CLR         /* 0xBF810394 */
  .extern IPC37SET         /* 0xBF810398 */
  .extern IPC37INV         /* 0xBF81039C */
  .extern IPC38            /* 0xBF8103A0 */
  .extern IPC38CLR         /* 0xBF8103A4 */
  .extern IPC38SET         /* 0xBF8103A8 */
  .extern IPC38INV         /* 0xBF8103AC */
  .extern IPC39            /* 0xBF8103B0 */
  .extern IPC39CLR         /* 0xBF8103B4 */
  .extern IPC39SET         /* 0xBF8103B8 */
  .extern IPC39INV         /* 0xBF8103BC */
  .extern IPC40            /* 0xBF8103C0 */
  .extern IPC40CLR         /* 0xBF8103C4 */
  .extern IPC40SET         /* 0xBF8103C8 */
  .extern IPC40INV         /* 0xBF8103CC */
  .extern IPC41            /* 0xBF8103D0 */
  .extern IPC41CLR         /* 0xBF8103D4 */
  .extern IPC41SET         /* 0xBF8103D8 */
  .extern IPC41INV         /* 0xBF8103DC */
  .extern IPC42            /* 0xBF8103E0 */
  .extern IPC42CLR         /* 0xBF8103E4 */
  .extern IPC42SET         /* 0xBF8103E8 */
  .extern IPC42INV         /* 0xBF8103EC */
  .extern IPC43            /* 0xBF8103F0 */
  .extern IPC43CLR         /* 0xBF8103F4 */
  .extern IPC43SET         /* 0xBF8103F8 */
  .extern IPC43INV         /* 0xBF8103FC */
  .extern IPC44            /* 0xBF810400 */
  .extern IPC44CLR         /* 0xBF810404 */
  .extern IPC44SET         /* 0xBF810408 */
  .extern IPC44INV         /* 0xBF81040C */
  .extern IPC45            /* 0xBF810410 */
  .extern IPC45CLR         /* 0xBF810414 */
  .extern IPC45SET         /* 0xBF810418 */
  .extern IPC45INV         /* 0xBF81041C */
  .extern IPC46            /* 0xBF810420 */
  .extern IPC46CLR         /* 0xBF810424 */
  .extern IPC46SET         /* 0xBF810428 */
  .extern IPC46INV         /* 0xBF81042C */
  .extern IPC47            /* 0xBF810430 */
  .extern IPC47CLR         /* 0xBF810434 */
  .extern IPC47SET         /* 0xBF810438 */
  .extern IPC47INV         /* 0xBF81043C */
  .extern IPC48            /* 0xBF810440 */
  .extern IPC48CLR         /* 0xBF810444 */
  .extern IPC48SET         /* 0xBF810448 */
  .extern IPC48INV         /* 0xBF81044C */
  .extern IPC49            /* 0xBF810450 */
  .extern IPC49CLR         /* 0xBF810454 */
  .extern IPC49SET         /* 0xBF810458 */
  .extern IPC49INV         /* 0xBF81045C */
  .extern IPC50            /* 0xBF810460 */
  .extern IPC50CLR         /* 0xBF810464 */
  .extern IPC50SET         /* 0xBF810468 */
  .extern IPC50INV         /* 0xBF81046C */
  .extern IPC51            /* 0xBF810470 */
  .extern IPC51CLR         /* 0xBF810474 */
  .extern IPC51SET         /* 0xBF810478 */
  .extern IPC51INV         /* 0xBF81047C */
  .extern IPC52            /* 0xBF810480 */
  .extern IPC52CLR         /* 0xBF810484 */
  .extern IPC52SET         /* 0xBF810488 */
  .extern IPC52INV         /* 0xBF81048C */
  .extern IPC53            /* 0xBF810490 */
  .extern IPC53CLR         /* 0xBF810494 */
  .extern IPC53SET         /* 0xBF810498 */
  .extern IPC53INV         /* 0xBF81049C */
  .extern OFF000           /* 0xBF810540 */
  .extern OFF001           /* 0xBF810544 */
  .extern OFF002           /* 0xBF810548 */
  .extern OFF003           /* 0xBF81054C */
  .extern OFF004           /* 0xBF810550 */
  .extern OFF005           /* 0xBF810554 */
  .extern OFF006           /* 0xBF810558 */
  .extern OFF007           /* 0xBF81055C */
  .extern OFF008           /* 0xBF810560 */
  .extern OFF009           /* 0xBF810564 */
  .extern OFF010           /* 0xBF810568 */
  .extern OFF011           /* 0xBF81056C */
  .extern OFF012           /* 0xBF810570 */
  .extern OFF013           /* 0xBF810574 */
  .extern OFF014           /* 0xBF810578 */
  .extern OFF015           /* 0xBF81057C */
  .extern OFF016           /* 0xBF810580 */
  .extern OFF017           /* 0xBF810584 */
  .extern OFF018           /* 0xBF810588 */
  .extern OFF019           /* 0xBF81058C */
  .extern OFF020           /* 0xBF810590 */
  .extern OFF021           /* 0xBF810594 */
  .extern OFF022           /* 0xBF810598 */
  .extern OFF023           /* 0xBF81059C */
  .extern OFF024           /* 0xBF8105A0 */
  .extern OFF025           /* 0xBF8105A4 */
  .extern OFF026           /* 0xBF8105A8 */
  .extern OFF027           /* 0xBF8105AC */
  .extern OFF028           /* 0xBF8105B0 */
  .extern OFF029           /* 0xBF8105B4 */
  .extern OFF030           /* 0xBF8105B8 */
  .extern OFF031           /* 0xBF8105BC */
  .extern OFF032           /* 0xBF8105C0 */
  .extern OFF033           /* 0xBF8105C4 */
  .extern OFF034           /* 0xBF8105C8 */
  .extern OFF035           /* 0xBF8105CC */
  .extern OFF036           /* 0xBF8105D0 */
  .extern OFF037           /* 0xBF8105D4 */
  .extern OFF038           /* 0xBF8105D8 */
  .extern OFF039           /* 0xBF8105DC */
  .extern OFF040           /* 0xBF8105E0 */
  .extern OFF041           /* 0xBF8105E4 */
  .extern OFF042           /* 0xBF8105E8 */
  .extern OFF043           /* 0xBF8105EC */
  .extern OFF044           /* 0xBF8105F0 */
  .extern OFF045           /* 0xBF8105F4 */
  .extern OFF046           /* 0xBF8105F8 */
  .extern OFF047           /* 0xBF8105FC */
  .extern OFF048           /* 0xBF810600 */
  .extern OFF049           /* 0xBF810604 */
  .extern OFF050           /* 0xBF810608 */
  .extern OFF051           /* 0xBF81060C */
  .extern OFF052           /* 0xBF810610 */
  .extern OFF053           /* 0xBF810614 */
  .extern OFF054           /* 0xBF810618 */
  .extern OFF055           /* 0xBF81061C */
  .extern OFF056           /* 0xBF810620 */
  .extern OFF057           /* 0xBF810624 */
  .extern OFF059           /* 0xBF81062C */
  .extern OFF060           /* 0xBF810630 */
  .extern OFF061           /* 0xBF810634 */
  .extern OFF062           /* 0xBF810638 */
  .extern OFF063           /* 0xBF81063C */
  .extern OFF064           /* 0xBF810640 */
  .extern OFF065           /* 0xBF810644 */
  .extern OFF066           /* 0xBF810648 */
  .extern OFF067           /* 0xBF81064C */
  .extern OFF068           /* 0xBF810650 */
  .extern OFF069           /* 0xBF810654 */
  .extern OFF070           /* 0xBF810658 */
  .extern OFF071           /* 0xBF81065C */
  .extern OFF072           /* 0xBF810660 */
  .extern OFF073           /* 0xBF810664 */
  .extern OFF074           /* 0xBF810668 */
  .extern OFF075           /* 0xBF81066C */
  .extern OFF076           /* 0xBF810670 */
  .extern OFF077           /* 0xBF810674 */
  .extern OFF102           /* 0xBF8106D8 */
  .extern OFF103           /* 0xBF8106DC */
  .extern OFF104           /* 0xBF8106E0 */
  .extern OFF105           /* 0xBF8106E4 */
  .extern OFF106           /* 0xBF8106E8 */
  .extern OFF109           /* 0xBF8106F4 */
  .extern OFF110           /* 0xBF8106F8 */
  .extern OFF111           /* 0xBF8106FC */
  .extern OFF112           /* 0xBF810700 */
  .extern OFF113           /* 0xBF810704 */
  .extern OFF114           /* 0xBF810708 */
  .extern OFF115           /* 0xBF81070C */
  .extern OFF116           /* 0xBF810710 */
  .extern OFF117           /* 0xBF810714 */
  .extern OFF119           /* 0xBF81071C */
  .extern OFF120           /* 0xBF810720 */
  .extern OFF121           /* 0xBF810724 */
  .extern OFF122           /* 0xBF810728 */
  .extern OFF123           /* 0xBF81072C */
  .extern OFF124           /* 0xBF810730 */
  .extern OFF128           /* 0xBF810740 */
  .extern OFF129           /* 0xBF810744 */
  .extern OFF130           /* 0xBF810748 */
  .extern OFF131           /* 0xBF81074C */
  .extern OFF132           /* 0xBF810750 */
  .extern OFF133           /* 0xBF810754 */
  .extern OFF134           /* 0xBF810758 */
  .extern OFF135           /* 0xBF81075C */
  .extern OFF136           /* 0xBF810760 */
  .extern OFF137           /* 0xBF810764 */
  .extern OFF138           /* 0xBF810768 */
  .extern OFF139           /* 0xBF81076C */
  .extern OFF140           /* 0xBF810770 */
  .extern OFF141           /* 0xBF810774 */
  .extern OFF142           /* 0xBF810778 */
  .extern OFF143           /* 0xBF81077C */
  .extern OFF144           /* 0xBF810780 */
  .extern OFF145           /* 0xBF810784 */
  .extern OFF146           /* 0xBF810788 */
  .extern OFF147           /* 0xBF81078C */
  .extern OFF151           /* 0xBF81079C */
  .extern OFF152           /* 0xBF8107A0 */
  .extern OFF153           /* 0xBF8107A4 */
  .extern OFF154           /* 0xBF8107A8 */
  .extern OFF155           /* 0xBF8107AC */
  .extern OFF156           /* 0xBF8107B0 */
  .extern OFF157           /* 0xBF8107B4 */
  .extern OFF158           /* 0xBF8107B8 */
  .extern OFF159           /* 0xBF8107BC */
  .extern OFF160           /* 0xBF8107C0 */
  .extern OFF161           /* 0xBF8107C4 */
  .extern OFF162           /* 0xBF8107C8 */
  .extern OFF163           /* 0xBF8107CC */
  .extern OFF164           /* 0xBF8107D0 */
  .extern OFF165           /* 0xBF8107D4 */
  .extern OFF166           /* 0xBF8107D8 */
  .extern OFF167           /* 0xBF8107DC */
  .extern OFF168           /* 0xBF8107E0 */
  .extern OFF169           /* 0xBF8107E4 */
  .extern OFF170           /* 0xBF8107E8 */
  .extern OFF171           /* 0xBF8107EC */
  .extern OFF172           /* 0xBF8107F0 */
  .extern OFF173           /* 0xBF8107F4 */
  .extern OFF174           /* 0xBF8107F8 */
  .extern OFF175           /* 0xBF8107FC */
  .extern OFF179           /* 0xBF81080C */
  .extern OFF180           /* 0xBF810810 */
  .extern OFF181           /* 0xBF810814 */
  .extern OFF182           /* 0xBF810818 */
  .extern OFF183           /* 0xBF81081C */
  .extern OFF184           /* 0xBF810820 */
  .extern OFF188           /* 0xBF810830 */
  .extern OFF189           /* 0xBF810834 */
  .extern OFF190           /* 0xBF810838 */
  .extern OFF192           /* 0xBF810840 */
  .extern OFF193           /* 0xBF810844 */
  .extern OFF194           /* 0xBF810848 */
  .extern OFF196           /* 0xBF810850 */
  .extern OFF198           /* 0xBF810858 */
  .extern OFF199           /* 0xBF81085C */
  .extern OFF200           /* 0xBF810860 */
  .extern OFF201           /* 0xBF810864 */
  .extern OFF202           /* 0xBF810868 */
  .extern OFF205           /* 0xBF810874 */
  .extern OFF206           /* 0xBF810878 */
  .extern OFF207           /* 0xBF81087C */
  .extern OFF208           /* 0xBF810880 */
  .extern OFF209           /* 0xBF810884 */
  .extern OFF210           /* 0xBF810888 */
  .extern OFF213           /* 0xBF810894 */
  .extern DMACON           /* 0xBF811000 */
  .extern DMACONCLR        /* 0xBF811004 */
  .extern DMACONSET        /* 0xBF811008 */
  .extern DMACONINV        /* 0xBF81100C */
  .extern DMASTAT          /* 0xBF811010 */
  .extern DMASTATCLR       /* 0xBF811014 */
  .extern DMASTATSET       /* 0xBF811018 */
  .extern DMASTATINV       /* 0xBF81101C */
  .extern DMAADDR          /* 0xBF811020 */
  .extern DMAADDRCLR       /* 0xBF811024 */
  .extern DMAADDRSET       /* 0xBF811028 */
  .extern DMAADDRINV       /* 0xBF81102C */
  .extern DCRCCON          /* 0xBF811030 */
  .extern DCRCCONCLR       /* 0xBF811034 */
  .extern DCRCCONSET       /* 0xBF811038 */
  .extern DCRCCONINV       /* 0xBF81103C */
  .extern DCRCDATA         /* 0xBF811040 */
  .extern DCRCDATACLR      /* 0xBF811044 */
  .extern DCRCDATASET      /* 0xBF811048 */
  .extern DCRCDATAINV      /* 0xBF81104C */
  .extern DCRCXOR          /* 0xBF811050 */
  .extern DCRCXORCLR       /* 0xBF811054 */
  .extern DCRCXORSET       /* 0xBF811058 */
  .extern DCRCXORINV       /* 0xBF81105C */
  .extern DCH0CON          /* 0xBF811060 */
  .extern DCH0CONCLR       /* 0xBF811064 */
  .extern DCH0CONSET       /* 0xBF811068 */
  .extern DCH0CONINV       /* 0xBF81106C */
  .extern DCH0ECON         /* 0xBF811070 */
  .extern DCH0ECONCLR      /* 0xBF811074 */
  .extern DCH0ECONSET      /* 0xBF811078 */
  .extern DCH0ECONINV      /* 0xBF81107C */
  .extern DCH0INT          /* 0xBF811080 */
  .extern DCH0INTCLR       /* 0xBF811084 */
  .extern DCH0INTSET       /* 0xBF811088 */
  .extern DCH0INTINV       /* 0xBF81108C */
  .extern DCH0SSA          /* 0xBF811090 */
  .extern DCH0SSACLR       /* 0xBF811094 */
  .extern DCH0SSASET       /* 0xBF811098 */
  .extern DCH0SSAINV       /* 0xBF81109C */
  .extern DCH0DSA          /* 0xBF8110A0 */
  .extern DCH0DSACLR       /* 0xBF8110A4 */
  .extern DCH0DSASET       /* 0xBF8110A8 */
  .extern DCH0DSAINV       /* 0xBF8110AC */
  .extern DCH0SSIZ         /* 0xBF8110B0 */
  .extern DCH0SSIZCLR      /* 0xBF8110B4 */
  .extern DCH0SSIZSET      /* 0xBF8110B8 */
  .extern DCH0SSIZINV      /* 0xBF8110BC */
  .extern DCH0DSIZ         /* 0xBF8110C0 */
  .extern DCH0DSIZCLR      /* 0xBF8110C4 */
  .extern DCH0DSIZSET      /* 0xBF8110C8 */
  .extern DCH0DSIZINV      /* 0xBF8110CC */
  .extern DCH0SPTR         /* 0xBF8110D0 */
  .extern DCH0SPTRCLR      /* 0xBF8110D4 */
  .extern DCH0SPTRSET      /* 0xBF8110D8 */
  .extern DCH0SPTRINV      /* 0xBF8110DC */
  .extern DCH0DPTR         /* 0xBF8110E0 */
  .extern DCH0DPTRCLR      /* 0xBF8110E4 */
  .extern DCH0DPTRSET      /* 0xBF8110E8 */
  .extern DCH0DPTRINV      /* 0xBF8110EC */
  .extern DCH0CSIZ         /* 0xBF8110F0 */
  .extern DCH0CSIZCLR      /* 0xBF8110F4 */
  .extern DCH0CSIZSET      /* 0xBF8110F8 */
  .extern DCH0CSIZINV      /* 0xBF8110FC */
  .extern DCH0CPTR         /* 0xBF811100 */
  .extern DCS0CPTR         /* 0xBF811100 */
  .extern DCH0CPTRCLR      /* 0xBF811104 */
  .extern DCS0CPTRCLR      /* 0xBF811104 */
  .extern DCH0CPTRSET      /* 0xBF811108 */
  .extern DCS0CPTRSET      /* 0xBF811108 */
  .extern DCH0CPTRINV      /* 0xBF81110C */
  .extern DCS0CPTRINV      /* 0xBF81110C */
  .extern DCH0DAT          /* 0xBF811110 */
  .extern DCH0DATCLR       /* 0xBF811114 */
  .extern DCH0DATSET       /* 0xBF811118 */
  .extern DCH0DATINV       /* 0xBF81111C */
  .extern DCH1CON          /* 0xBF811120 */
  .extern DCH1CONCLR       /* 0xBF811124 */
  .extern DCH1CONSET       /* 0xBF811128 */
  .extern DCH1CONINV       /* 0xBF81112C */
  .extern DCH1ECON         /* 0xBF811130 */
  .extern DCH1ECONCLR      /* 0xBF811134 */
  .extern DCH1ECONSET      /* 0xBF811138 */
  .extern DCH1ECONINV      /* 0xBF81113C */
  .extern DCH1INT          /* 0xBF811140 */
  .extern DCH1INTCLR       /* 0xBF811144 */
  .extern DCH1INTSET       /* 0xBF811148 */
  .extern DCH1INTINV       /* 0xBF81114C */
  .extern DCH1SSA          /* 0xBF811150 */
  .extern DCH1SSACLR       /* 0xBF811154 */
  .extern DCH1SSASET       /* 0xBF811158 */
  .extern DCH1SSAINV       /* 0xBF81115C */
  .extern DCH1DSA          /* 0xBF811160 */
  .extern DCH1DSACLR       /* 0xBF811164 */
  .extern DCH1DSASET       /* 0xBF811168 */
  .extern DCH1DSAINV       /* 0xBF81116C */
  .extern DCH1SSIZ         /* 0xBF811170 */
  .extern DCH1SSIZCLR      /* 0xBF811174 */
  .extern DCH1SSIZSET      /* 0xBF811178 */
  .extern DCH1SSIZINV      /* 0xBF81117C */
  .extern DCH1DSIZ         /* 0xBF811180 */
  .extern DCH1DSIZCLR      /* 0xBF811184 */
  .extern DCH1DSIZSET      /* 0xBF811188 */
  .extern DCH1DSIZINV      /* 0xBF81118C */
  .extern DCH1SPTR         /* 0xBF811190 */
  .extern DCH1SPTRCLR      /* 0xBF811194 */
  .extern DCH1SPTRSET      /* 0xBF811198 */
  .extern DCH1SPTRINV      /* 0xBF81119C */
  .extern DCH1DPTR         /* 0xBF8111A0 */
  .extern DCH1DPTRCLR      /* 0xBF8111A4 */
  .extern DCH1DPTRSET      /* 0xBF8111A8 */
  .extern DCH1DPTRINV      /* 0xBF8111AC */
  .extern DCH1CSIZ         /* 0xBF8111B0 */
  .extern DCH1CSIZCLR      /* 0xBF8111B4 */
  .extern DCH1CSIZSET      /* 0xBF8111B8 */
  .extern DCH1CSIZINV      /* 0xBF8111BC */
  .extern DCH1CPTR         /* 0xBF8111C0 */
  .extern DCS1CPTR         /* 0xBF8111C0 */
  .extern DCH1CPTRCLR      /* 0xBF8111C4 */
  .extern DCS1CPTRCLR      /* 0xBF8111C4 */
  .extern DCH1CPTRSET      /* 0xBF8111C8 */
  .extern DCS1CPTRSET      /* 0xBF8111C8 */
  .extern DCH1CPTRINV      /* 0xBF8111CC */
  .extern DCS1CPTRINV      /* 0xBF8111CC */
  .extern DCH1DAT          /* 0xBF8111D0 */
  .extern DCH1DATCLR       /* 0xBF8111D4 */
  .extern DCH1DATSET       /* 0xBF8111D8 */
  .extern DCH1DATINV       /* 0xBF8111DC */
  .extern DCH2CON          /* 0xBF8111E0 */
  .extern DCH2CONCLR       /* 0xBF8111E4 */
  .extern DCH2CONSET       /* 0xBF8111E8 */
  .extern DCH2CONINV       /* 0xBF8111EC */
  .extern DCH2ECON         /* 0xBF8111F0 */
  .extern DCH2ECONCLR      /* 0xBF8111F4 */
  .extern DCH2ECONSET      /* 0xBF8111F8 */
  .extern DCH2ECONINV      /* 0xBF8111FC */
  .extern DCH2INT          /* 0xBF811200 */
  .extern DCH2INTCLR       /* 0xBF811204 */
  .extern DCH2INTSET       /* 0xBF811208 */
  .extern DCH2INTINV       /* 0xBF81120C */
  .extern DCH2SSA          /* 0xBF811210 */
  .extern DCH2SSACLR       /* 0xBF811214 */
  .extern DCH2SSASET       /* 0xBF811218 */
  .extern DCH2SSAINV       /* 0xBF81121C */
  .extern DCH2DSA          /* 0xBF811220 */
  .extern DCH2DSACLR       /* 0xBF811224 */
  .extern DCH2DSASET       /* 0xBF811228 */
  .extern DCH2DSAINV       /* 0xBF81122C */
  .extern DCH2SSIZ         /* 0xBF811230 */
  .extern DCH2SSIZCLR      /* 0xBF811234 */
  .extern DCH2SSIZSET      /* 0xBF811238 */
  .extern DCH2SSIZINV      /* 0xBF81123C */
  .extern DCH2DSIZ         /* 0xBF811240 */
  .extern DCH2DSIZCLR      /* 0xBF811244 */
  .extern DCH2DSIZSET      /* 0xBF811248 */
  .extern DCH2DSIZINV      /* 0xBF81124C */
  .extern DCH2SPTR         /* 0xBF811250 */
  .extern DCH2SPTRCLR      /* 0xBF811254 */
  .extern DCH2SPTRSET      /* 0xBF811258 */
  .extern DCH2SPTRINV      /* 0xBF81125C */
  .extern DCH2DPTR         /* 0xBF811260 */
  .extern DCH2DPTRCLR      /* 0xBF811264 */
  .extern DCH2DPTRSET      /* 0xBF811268 */
  .extern DCH2DPTRINV      /* 0xBF81126C */
  .extern DCH2CSIZ         /* 0xBF811270 */
  .extern DCH2CSIZCLR      /* 0xBF811274 */
  .extern DCH2CSIZSET      /* 0xBF811278 */
  .extern DCH2CSIZINV      /* 0xBF81127C */
  .extern DCH2CPTR         /* 0xBF811280 */
  .extern DCS2CPTR         /* 0xBF811280 */
  .extern DCH2CPTRCLR      /* 0xBF811284 */
  .extern DCS2CPTRCLR      /* 0xBF811284 */
  .extern DCH2CPTRSET      /* 0xBF811288 */
  .extern DCS2CPTRSET      /* 0xBF811288 */
  .extern DCH2CPTRINV      /* 0xBF81128C */
  .extern DCS2CPTRINV      /* 0xBF81128C */
  .extern DCH2DAT          /* 0xBF811290 */
  .extern DCH2DATCLR       /* 0xBF811294 */
  .extern DCH2DATSET       /* 0xBF811298 */
  .extern DCH2DATINV       /* 0xBF81129C */
  .extern DCH3CON          /* 0xBF8112A0 */
  .extern DCH3CONCLR       /* 0xBF8112A4 */
  .extern DCH3CONSET       /* 0xBF8112A8 */
  .extern DCH3CONINV       /* 0xBF8112AC */
  .extern DCH3ECON         /* 0xBF8112B0 */
  .extern DCH3ECONCLR      /* 0xBF8112B4 */
  .extern DCH3ECONSET      /* 0xBF8112B8 */
  .extern DCH3ECONINV      /* 0xBF8112BC */
  .extern DCH3INT          /* 0xBF8112C0 */
  .extern DCH3INTCLR       /* 0xBF8112C4 */
  .extern DCH3INTSET       /* 0xBF8112C8 */
  .extern DCH3INTINV       /* 0xBF8112CC */
  .extern DCH3SSA          /* 0xBF8112D0 */
  .extern DCH3SSACLR       /* 0xBF8112D4 */
  .extern DCH3SSASET       /* 0xBF8112D8 */
  .extern DCH3SSAINV       /* 0xBF8112DC */
  .extern DCH3DSA          /* 0xBF8112E0 */
  .extern DCH3DSACLR       /* 0xBF8112E4 */
  .extern DCH3DSASET       /* 0xBF8112E8 */
  .extern DCH3DSAINV       /* 0xBF8112EC */
  .extern DCH3SSIZ         /* 0xBF8112F0 */
  .extern DCH3SSIZCLR      /* 0xBF8112F4 */
  .extern DCH3SSIZSET      /* 0xBF8112F8 */
  .extern DCH3SSIZINV      /* 0xBF8112FC */
  .extern DCH3DSIZ         /* 0xBF811300 */
  .extern DCH3DSIZCLR      /* 0xBF811304 */
  .extern DCH3DSIZSET      /* 0xBF811308 */
  .extern DCH3DSIZINV      /* 0xBF81130C */
  .extern DCH3SPTR         /* 0xBF811310 */
  .extern DCH3SPTRCLR      /* 0xBF811314 */
  .extern DCH3SPTRSET      /* 0xBF811318 */
  .extern DCH3SPTRINV      /* 0xBF81131C */
  .extern DCH3DPTR         /* 0xBF811320 */
  .extern DCH3DPTRCLR      /* 0xBF811324 */
  .extern DCH3DPTRSET      /* 0xBF811328 */
  .extern DCH3DPTRINV      /* 0xBF81132C */
  .extern DCH3CSIZ         /* 0xBF811330 */
  .extern DCH3CSIZCLR      /* 0xBF811334 */
  .extern DCH3CSIZSET      /* 0xBF811338 */
  .extern DCH3CSIZINV      /* 0xBF81133C */
  .extern DCH3CPTR         /* 0xBF811340 */
  .extern DCS3CPTR         /* 0xBF811340 */
  .extern DCH3CPTRCLR      /* 0xBF811344 */
  .extern DCS3CPTRCLR      /* 0xBF811344 */
  .extern DCH3CPTRSET      /* 0xBF811348 */
  .extern DCS3CPTRSET      /* 0xBF811348 */
  .extern DCH3CPTRINV      /* 0xBF81134C */
  .extern DCS3CPTRINV      /* 0xBF81134C */
  .extern DCH3DAT          /* 0xBF811350 */
  .extern DCH3DATCLR       /* 0xBF811354 */
  .extern DCH3DATSET       /* 0xBF811358 */
  .extern DCH3DATINV       /* 0xBF81135C */
  .extern DCH4CON          /* 0xBF811360 */
  .extern DCH4CONCLR       /* 0xBF811364 */
  .extern DCH4CONSET       /* 0xBF811368 */
  .extern DCH4CONINV       /* 0xBF81136C */
  .extern DCH4ECON         /* 0xBF811370 */
  .extern DCH4ECONCLR      /* 0xBF811374 */
  .extern DCH4ECONSET      /* 0xBF811378 */
  .extern DCH4ECONINV      /* 0xBF81137C */
  .extern DCH4INT          /* 0xBF811380 */
  .extern DCH4INTCLR       /* 0xBF811384 */
  .extern DCH4INTSET       /* 0xBF811388 */
  .extern DCH4INTINV       /* 0xBF81138C */
  .extern DCH4SSA          /* 0xBF811390 */
  .extern DCH4SSACLR       /* 0xBF811394 */
  .extern DCH4SSASET       /* 0xBF811398 */
  .extern DCH4SSAINV       /* 0xBF81139C */
  .extern DCH4DSA          /* 0xBF8113A0 */
  .extern DCH4DSACLR       /* 0xBF8113A4 */
  .extern DCH4DSASET       /* 0xBF8113A8 */
  .extern DCH4DSAINV       /* 0xBF8113AC */
  .extern DCH4SSIZ         /* 0xBF8113B0 */
  .extern DCH4SSIZCLR      /* 0xBF8113B4 */
  .extern DCH4SSIZSET      /* 0xBF8113B8 */
  .extern DCH4SSIZINV      /* 0xBF8113BC */
  .extern DCH4DSIZ         /* 0xBF8113C0 */
  .extern DCH4DSIZCLR      /* 0xBF8113C4 */
  .extern DCH4DSIZSET      /* 0xBF8113C8 */
  .extern DCH4DSIZINV      /* 0xBF8113CC */
  .extern DCH4SPTR         /* 0xBF8113D0 */
  .extern DCH4SPTRCLR      /* 0xBF8113D4 */
  .extern DCH4SPTRSET      /* 0xBF8113D8 */
  .extern DCH4SPTRINV      /* 0xBF8113DC */
  .extern DCH4DPTR         /* 0xBF8113E0 */
  .extern DCH4DPTRCLR      /* 0xBF8113E4 */
  .extern DCH4DPTRSET      /* 0xBF8113E8 */
  .extern DCH4DPTRINV      /* 0xBF8113EC */
  .extern DCH4CSIZ         /* 0xBF8113F0 */
  .extern DCH4CSIZCLR      /* 0xBF8113F4 */
  .extern DCH4CSIZSET      /* 0xBF8113F8 */
  .extern DCH4CSIZINV      /* 0xBF8113FC */
  .extern DCH4CPTR         /* 0xBF811400 */
  .extern DCS4CPTR         /* 0xBF811400 */
  .extern DCH4CPTRCLR      /* 0xBF811404 */
  .extern DCS4CPTRCLR      /* 0xBF811404 */
  .extern DCH4CPTRSET      /* 0xBF811408 */
  .extern DCS4CPTRSET      /* 0xBF811408 */
  .extern DCH4CPTRINV      /* 0xBF81140C */
  .extern DCS4CPTRINV      /* 0xBF81140C */
  .extern DCH4DAT          /* 0xBF811410 */
  .extern DCH4DATCLR       /* 0xBF811414 */
  .extern DCH4DATSET       /* 0xBF811418 */
  .extern DCH4DATINV       /* 0xBF81141C */
  .extern DCH5CON          /* 0xBF811420 */
  .extern DCH5CONCLR       /* 0xBF811424 */
  .extern DCH5CONSET       /* 0xBF811428 */
  .extern DCH5CONINV       /* 0xBF81142C */
  .extern DCH5ECON         /* 0xBF811430 */
  .extern DCH5ECONCLR      /* 0xBF811434 */
  .extern DCH5ECONSET      /* 0xBF811438 */
  .extern DCH5ECONINV      /* 0xBF81143C */
  .extern DCH5INT          /* 0xBF811440 */
  .extern DCH5INTCLR       /* 0xBF811444 */
  .extern DCH5INTSET       /* 0xBF811448 */
  .extern DCH5INTINV       /* 0xBF81144C */
  .extern DCH5SSA          /* 0xBF811450 */
  .extern DCH5SSACLR       /* 0xBF811454 */
  .extern DCH5SSASET       /* 0xBF811458 */
  .extern DCH5SSAINV       /* 0xBF81145C */
  .extern DCH5DSA          /* 0xBF811460 */
  .extern DCH5DSACLR       /* 0xBF811464 */
  .extern DCH5DSASET       /* 0xBF811468 */
  .extern DCH5DSAINV       /* 0xBF81146C */
  .extern DCH5SSIZ         /* 0xBF811470 */
  .extern DCH5SSIZCLR      /* 0xBF811474 */
  .extern DCH5SSIZSET      /* 0xBF811478 */
  .extern DCH5SSIZINV      /* 0xBF81147C */
  .extern DCH5DSIZ         /* 0xBF811480 */
  .extern DCH5DSIZCLR      /* 0xBF811484 */
  .extern DCH5DSIZSET      /* 0xBF811488 */
  .extern DCH5DSIZINV      /* 0xBF81148C */
  .extern DCH5SPTR         /* 0xBF811490 */
  .extern DCH5SPTRCLR      /* 0xBF811494 */
  .extern DCH5SPTRSET      /* 0xBF811498 */
  .extern DCH5SPTRINV      /* 0xBF81149C */
  .extern DCH5DPTR         /* 0xBF8114A0 */
  .extern DCH5DPTRCLR      /* 0xBF8114A4 */
  .extern DCH5DPTRSET      /* 0xBF8114A8 */
  .extern DCH5DPTRINV      /* 0xBF8114AC */
  .extern DCH5CSIZ         /* 0xBF8114B0 */
  .extern DCH5CSIZCLR      /* 0xBF8114B4 */
  .extern DCH5CSIZSET      /* 0xBF8114B8 */
  .extern DCH5CSIZINV      /* 0xBF8114BC */
  .extern DCH5CPTR         /* 0xBF8114C0 */
  .extern DCS5CPTR         /* 0xBF8114C0 */
  .extern DCH5CPTRCLR      /* 0xBF8114C4 */
  .extern DCS5CPTRCLR      /* 0xBF8114C4 */
  .extern DCH5CPTRSET      /* 0xBF8114C8 */
  .extern DCS5CPTRSET      /* 0xBF8114C8 */
  .extern DCH5CPTRINV      /* 0xBF8114CC */
  .extern DCS5CPTRINV      /* 0xBF8114CC */
  .extern DCH5DAT          /* 0xBF8114D0 */
  .extern DCH5DATCLR       /* 0xBF8114D4 */
  .extern DCH5DATSET       /* 0xBF8114D8 */
  .extern DCH5DATINV       /* 0xBF8114DC */
  .extern DCH6CON          /* 0xBF8114E0 */
  .extern DCH6CONCLR       /* 0xBF8114E4 */
  .extern DCH6CONSET       /* 0xBF8114E8 */
  .extern DCH6CONINV       /* 0xBF8114EC */
  .extern DCH6ECON         /* 0xBF8114F0 */
  .extern DCH6ECONCLR      /* 0xBF8114F4 */
  .extern DCH6ECONSET      /* 0xBF8114F8 */
  .extern DCH6ECONINV      /* 0xBF8114FC */
  .extern DCH6INT          /* 0xBF811500 */
  .extern DCH6INTCLR       /* 0xBF811504 */
  .extern DCH6INTSET       /* 0xBF811508 */
  .extern DCH6INTINV       /* 0xBF81150C */
  .extern DCH6SSA          /* 0xBF811510 */
  .extern DCH6SSACLR       /* 0xBF811514 */
  .extern DCH6SSASET       /* 0xBF811518 */
  .extern DCH6SSAINV       /* 0xBF81151C */
  .extern DCH6DSA          /* 0xBF811520 */
  .extern DCH6DSACLR       /* 0xBF811524 */
  .extern DCH6DSASET       /* 0xBF811528 */
  .extern DCH6DSAINV       /* 0xBF81152C */
  .extern DCH6SSIZ         /* 0xBF811530 */
  .extern DCH6SSIZCLR      /* 0xBF811534 */
  .extern DCH6SSIZSET      /* 0xBF811538 */
  .extern DCH6SSIZINV      /* 0xBF81153C */
  .extern DCH6DSIZ         /* 0xBF811540 */
  .extern DCH6DSIZCLR      /* 0xBF811544 */
  .extern DCH6DSIZSET      /* 0xBF811548 */
  .extern DCH6DSIZINV      /* 0xBF81154C */
  .extern DCH6SPTR         /* 0xBF811550 */
  .extern DCH6SPTRCLR      /* 0xBF811554 */
  .extern DCH6SPTRSET      /* 0xBF811558 */
  .extern DCH6SPTRINV      /* 0xBF81155C */
  .extern DCH6DPTR         /* 0xBF811560 */
  .extern DCH6DPTRCLR      /* 0xBF811564 */
  .extern DCH6DPTRSET      /* 0xBF811568 */
  .extern DCH6DPTRINV      /* 0xBF81156C */
  .extern DCH6CSIZ         /* 0xBF811570 */
  .extern DCH6CSIZCLR      /* 0xBF811574 */
  .extern DCH6CSIZSET      /* 0xBF811578 */
  .extern DCH6CSIZINV      /* 0xBF81157C */
  .extern DCH6CPTR         /* 0xBF811580 */
  .extern DCS6CPTR         /* 0xBF811580 */
  .extern DCH6CPTRCLR      /* 0xBF811584 */
  .extern DCS6CPTRCLR      /* 0xBF811584 */
  .extern DCH6CPTRSET      /* 0xBF811588 */
  .extern DCS6CPTRSET      /* 0xBF811588 */
  .extern DCH6CPTRINV      /* 0xBF81158C */
  .extern DCS6CPTRINV      /* 0xBF81158C */
  .extern DCH6DAT          /* 0xBF811590 */
  .extern DCH6DATCLR       /* 0xBF811594 */
  .extern DCH6DATSET       /* 0xBF811598 */
  .extern DCH6DATINV       /* 0xBF81159C */
  .extern DCH7CON          /* 0xBF8115A0 */
  .extern DCH7CONCLR       /* 0xBF8115A4 */
  .extern DCH7CONSET       /* 0xBF8115A8 */
  .extern DCH7CONINV       /* 0xBF8115AC */
  .extern DCH7ECON         /* 0xBF8115B0 */
  .extern DCH7ECONCLR      /* 0xBF8115B4 */
  .extern DCH7ECONSET      /* 0xBF8115B8 */
  .extern DCH7ECONINV      /* 0xBF8115BC */
  .extern DCH7INT          /* 0xBF8115C0 */
  .extern DCH7INTCLR       /* 0xBF8115C4 */
  .extern DCH7INTSET       /* 0xBF8115C8 */
  .extern DCH7INTINV       /* 0xBF8115CC */
  .extern DCH7SSA          /* 0xBF8115D0 */
  .extern DCH7SSACLR       /* 0xBF8115D4 */
  .extern DCH7SSASET       /* 0xBF8115D8 */
  .extern DCH7SSAINV       /* 0xBF8115DC */
  .extern DCH7DSA          /* 0xBF8115E0 */
  .extern DCH7DSACLR       /* 0xBF8115E4 */
  .extern DCH7DSASET       /* 0xBF8115E8 */
  .extern DCH7DSAINV       /* 0xBF8115EC */
  .extern DCH7SSIZ         /* 0xBF8115F0 */
  .extern DCH7SSIZCLR      /* 0xBF8115F4 */
  .extern DCH7SSIZSET      /* 0xBF8115F8 */
  .extern DCH7SSIZINV      /* 0xBF8115FC */
  .extern DCH7DSIZ         /* 0xBF811600 */
  .extern DCH7DSIZCLR      /* 0xBF811604 */
  .extern DCH7DSIZSET      /* 0xBF811608 */
  .extern DCH7DSIZINV      /* 0xBF81160C */
  .extern DCH7SPTR         /* 0xBF811610 */
  .extern DCH7SPTRCLR      /* 0xBF811614 */
  .extern DCH7SPTRSET      /* 0xBF811618 */
  .extern DCH7SPTRINV      /* 0xBF81161C */
  .extern DCH7DPTR         /* 0xBF811620 */
  .extern DCH7DPTRCLR      /* 0xBF811624 */
  .extern DCH7DPTRSET      /* 0xBF811628 */
  .extern DCH7DPTRINV      /* 0xBF81162C */
  .extern DCH7CSIZ         /* 0xBF811630 */
  .extern DCH7CSIZCLR      /* 0xBF811634 */
  .extern DCH7CSIZSET      /* 0xBF811638 */
  .extern DCH7CSIZINV      /* 0xBF81163C */
  .extern DCH7CPTR         /* 0xBF811640 */
  .extern DCS7CPTR         /* 0xBF811640 */
  .extern DCH7CPTRCLR      /* 0xBF811644 */
  .extern DCS7CPTRCLR      /* 0xBF811644 */
  .extern DCH7CPTRSET      /* 0xBF811648 */
  .extern DCS7CPTRSET      /* 0xBF811648 */
  .extern DCH7CPTRINV      /* 0xBF81164C */
  .extern DCS7CPTRINV      /* 0xBF81164C */
  .extern DCH7DAT          /* 0xBF811650 */
  .extern DCH7DATCLR       /* 0xBF811654 */
  .extern DCH7DATSET       /* 0xBF811658 */
  .extern DCH7DATINV       /* 0xBF81165C */
  .extern I2C1CON          /* 0xBF820000 */
  .extern I2C1CONCLR       /* 0xBF820004 */
  .extern I2C1CONSET       /* 0xBF820008 */
  .extern I2C1CONINV       /* 0xBF82000C */
  .extern I2C1STAT         /* 0xBF820010 */
  .extern I2C1STATCLR      /* 0xBF820014 */
  .extern I2C1STATSET      /* 0xBF820018 */
  .extern I2C1STATINV      /* 0xBF82001C */
  .extern I2C1ADD          /* 0xBF820020 */
  .extern I2C1ADDCLR       /* 0xBF820024 */
  .extern I2C1ADDSET       /* 0xBF820028 */
  .extern I2C1ADDINV       /* 0xBF82002C */
  .extern I2C1MSK          /* 0xBF820030 */
  .extern I2C1MSKCLR       /* 0xBF820034 */
  .extern I2C1MSKSET       /* 0xBF820038 */
  .extern I2C1MSKINV       /* 0xBF82003C */
  .extern I2C1BRG          /* 0xBF820040 */
  .extern I2C1BRGCLR       /* 0xBF820044 */
  .extern I2C1BRGSET       /* 0xBF820048 */
  .extern I2C1BRGINV       /* 0xBF82004C */
  .extern I2C1TRN          /* 0xBF820050 */
  .extern I2C1TRNCLR       /* 0xBF820054 */
  .extern I2C1TRNSET       /* 0xBF820058 */
  .extern I2C1TRNINV       /* 0xBF82005C */
  .extern I2C1RCV          /* 0xBF820060 */
  .extern I2C1RCVCLR       /* 0xBF820064 */
  .extern I2C1RCVSET       /* 0xBF820068 */
  .extern I2C1RCVINV       /* 0xBF82006C */
  .extern I2C3CON          /* 0xBF820400 */
  .extern I2C3CONCLR       /* 0xBF820404 */
  .extern I2C3CONSET       /* 0xBF820408 */
  .extern I2C3CONINV       /* 0xBF82040C */
  .extern I2C3STAT         /* 0xBF820410 */
  .extern I2C3STATCLR      /* 0xBF820414 */
  .extern I2C3STATSET      /* 0xBF820418 */
  .extern I2C3STATINV      /* 0xBF82041C */
  .extern I2C3ADD          /* 0xBF820420 */
  .extern I2C3ADDCLR       /* 0xBF820424 */
  .extern I2C3ADDSET       /* 0xBF820428 */
  .extern I2C3ADDINV       /* 0xBF82042C */
  .extern I2C3MSK          /* 0xBF820430 */
  .extern I2C3MSKCLR       /* 0xBF820434 */
  .extern I2C3MSKSET       /* 0xBF820438 */
  .extern I2C3MSKINV       /* 0xBF82043C */
  .extern I2C3BRG          /* 0xBF820440 */
  .extern I2C3BRGCLR       /* 0xBF820444 */
  .extern I2C3BRGSET       /* 0xBF820448 */
  .extern I2C3BRGINV       /* 0xBF82044C */
  .extern I2C3TRN          /* 0xBF820450 */
  .extern I2C3TRNCLR       /* 0xBF820454 */
  .extern I2C3TRNSET       /* 0xBF820458 */
  .extern I2C3TRNINV       /* 0xBF82045C */
  .extern I2C3RCV          /* 0xBF820460 */
  .extern I2C3RCVCLR       /* 0xBF820464 */
  .extern I2C3RCVSET       /* 0xBF820468 */
  .extern I2C3RCVINV       /* 0xBF82046C */
  .extern I2C4CON          /* 0xBF820600 */
  .extern I2C4CONCLR       /* 0xBF820604 */
  .extern I2C4CONSET       /* 0xBF820608 */
  .extern I2C4CONINV       /* 0xBF82060C */
  .extern I2C4STAT         /* 0xBF820610 */
  .extern I2C4STATCLR      /* 0xBF820614 */
  .extern I2C4STATSET      /* 0xBF820618 */
  .extern I2C4STATINV      /* 0xBF82061C */
  .extern I2C4ADD          /* 0xBF820620 */
  .extern I2C4ADDCLR       /* 0xBF820624 */
  .extern I2C4ADDSET       /* 0xBF820628 */
  .extern I2C4ADDINV       /* 0xBF82062C */
  .extern I2C4MSK          /* 0xBF820630 */
  .extern I2C4MSKCLR       /* 0xBF820634 */
  .extern I2C4MSKSET       /* 0xBF820638 */
  .extern I2C4MSKINV       /* 0xBF82063C */
  .extern I2C4BRG          /* 0xBF820640 */
  .extern I2C4BRGCLR       /* 0xBF820644 */
  .extern I2C4BRGSET       /* 0xBF820648 */
  .extern I2C4BRGINV       /* 0xBF82064C */
  .extern I2C4TRN          /* 0xBF820650 */
  .extern I2C4TRNCLR       /* 0xBF820654 */
  .extern I2C4TRNSET       /* 0xBF820658 */
  .extern I2C4TRNINV       /* 0xBF82065C */
  .extern I2C4RCV          /* 0xBF820660 */
  .extern I2C4RCVCLR       /* 0xBF820664 */
  .extern I2C4RCVSET       /* 0xBF820668 */
  .extern I2C4RCVINV       /* 0xBF82066C */
  .extern I2C5CON          /* 0xBF820800 */
  .extern I2C5CONCLR       /* 0xBF820804 */
  .extern I2C5CONSET       /* 0xBF820808 */
  .extern I2C5CONINV       /* 0xBF82080C */
  .extern I2C5STAT         /* 0xBF820810 */
  .extern I2C5STATCLR      /* 0xBF820814 */
  .extern I2C5STATSET      /* 0xBF820818 */
  .extern I2C5STATINV      /* 0xBF82081C */
  .extern I2C5ADD          /* 0xBF820820 */
  .extern I2C5ADDCLR       /* 0xBF820824 */
  .extern I2C5ADDSET       /* 0xBF820828 */
  .extern I2C5ADDINV       /* 0xBF82082C */
  .extern I2C5MSK          /* 0xBF820830 */
  .extern I2C5MSKCLR       /* 0xBF820834 */
  .extern I2C5MSKSET       /* 0xBF820838 */
  .extern I2C5MSKINV       /* 0xBF82083C */
  .extern I2C5BRG          /* 0xBF820840 */
  .extern I2C5BRGCLR       /* 0xBF820844 */
  .extern I2C5BRGSET       /* 0xBF820848 */
  .extern I2C5BRGINV       /* 0xBF82084C */
  .extern I2C5TRN          /* 0xBF820850 */
  .extern I2C5TRNCLR       /* 0xBF820854 */
  .extern I2C5TRNSET       /* 0xBF820858 */
  .extern I2C5TRNINV       /* 0xBF82085C */
  .extern I2C5RCV          /* 0xBF820860 */
  .extern I2C5RCVCLR       /* 0xBF820864 */
  .extern I2C5RCVSET       /* 0xBF820868 */
  .extern I2C5RCVINV       /* 0xBF82086C */
  .extern SPI1CON          /* 0xBF821000 */
  .extern SPI1CONCLR       /* 0xBF821004 */
  .extern SPI1CONSET       /* 0xBF821008 */
  .extern SPI1CONINV       /* 0xBF82100C */
  .extern SPI1STAT         /* 0xBF821010 */
  .extern SPI1STATCLR      /* 0xBF821014 */
  .extern SPI1STATSET      /* 0xBF821018 */
  .extern SPI1STATINV      /* 0xBF82101C */
  .extern SPI1BUF          /* 0xBF821020 */
  .extern SPI1BRG          /* 0xBF821030 */
  .extern SPI1BRGCLR       /* 0xBF821034 */
  .extern SPI1BRGSET       /* 0xBF821038 */
  .extern SPI1BRGINV       /* 0xBF82103C */
  .extern SPI1CON2         /* 0xBF821040 */
  .extern SPI1CON2CLR      /* 0xBF821044 */
  .extern SPI1CON2SET      /* 0xBF821048 */
  .extern SPI1CON2INV      /* 0xBF82104C */
  .extern SPI2CON          /* 0xBF821200 */
  .extern SPI2CONCLR       /* 0xBF821204 */
  .extern SPI2CONSET       /* 0xBF821208 */
  .extern SPI2CONINV       /* 0xBF82120C */
  .extern SPI2STAT         /* 0xBF821210 */
  .extern SPI2STATCLR      /* 0xBF821214 */
  .extern SPI2STATSET      /* 0xBF821218 */
  .extern SPI2STATINV      /* 0xBF82121C */
  .extern SPI2BUF          /* 0xBF821220 */
  .extern SPI2BRG          /* 0xBF821230 */
  .extern SPI2BRGCLR       /* 0xBF821234 */
  .extern SPI2BRGSET       /* 0xBF821238 */
  .extern SPI2BRGINV       /* 0xBF82123C */
  .extern SPI2CON2         /* 0xBF821240 */
  .extern SPI2CON2CLR      /* 0xBF821244 */
  .extern SPI2CON2SET      /* 0xBF821248 */
  .extern SPI2CON2INV      /* 0xBF82124C */
  .extern SPI3CON          /* 0xBF821400 */
  .extern SPI3CONCLR       /* 0xBF821404 */
  .extern SPI3CONSET       /* 0xBF821408 */
  .extern SPI3CONINV       /* 0xBF82140C */
  .extern SPI3STAT         /* 0xBF821410 */
  .extern SPI3STATCLR      /* 0xBF821414 */
  .extern SPI3STATSET      /* 0xBF821418 */
  .extern SPI3STATINV      /* 0xBF82141C */
  .extern SPI3BUF          /* 0xBF821420 */
  .extern SPI3BRG          /* 0xBF821430 */
  .extern SPI3BRGCLR       /* 0xBF821434 */
  .extern SPI3BRGSET       /* 0xBF821438 */
  .extern SPI3BRGINV       /* 0xBF82143C */
  .extern SPI3CON2         /* 0xBF821440 */
  .extern SPI3CON2CLR      /* 0xBF821444 */
  .extern SPI3CON2SET      /* 0xBF821448 */
  .extern SPI3CON2INV      /* 0xBF82144C */
  .extern SPI4CON          /* 0xBF821600 */
  .extern SPI4CONCLR       /* 0xBF821604 */
  .extern SPI4CONSET       /* 0xBF821608 */
  .extern SPI4CONINV       /* 0xBF82160C */
  .extern SPI4STAT         /* 0xBF821610 */
  .extern SPI4STATCLR      /* 0xBF821614 */
  .extern SPI4STATSET      /* 0xBF821618 */
  .extern SPI4STATINV      /* 0xBF82161C */
  .extern SPI4BUF          /* 0xBF821620 */
  .extern SPI4BRG          /* 0xBF821630 */
  .extern SPI4BRGCLR       /* 0xBF821634 */
  .extern SPI4BRGSET       /* 0xBF821638 */
  .extern SPI4BRGINV       /* 0xBF82163C */
  .extern SPI4CON2         /* 0xBF821640 */
  .extern SPI4CON2CLR      /* 0xBF821644 */
  .extern SPI4CON2SET      /* 0xBF821648 */
  .extern SPI4CON2INV      /* 0xBF82164C */
  .extern U1MODE           /* 0xBF822000 */
  .extern UABMODE          /* 0xBF822000 */
  .extern U1MODECLR        /* 0xBF822004 */
  .extern UABMODECLR       /* 0xBF822004 */
  .extern U1MODESET        /* 0xBF822008 */
  .extern UABMODESET       /* 0xBF822008 */
  .extern U1MODEINV        /* 0xBF82200C */
  .extern UABMODEINV       /* 0xBF82200C */
  .extern U1STA            /* 0xBF822010 */
  .extern UABSTA           /* 0xBF822010 */
  .extern U1STACLR         /* 0xBF822014 */
  .extern UABSTACLR        /* 0xBF822014 */
  .extern U1STASET         /* 0xBF822018 */
  .extern UABSTASET        /* 0xBF822018 */
  .extern U1STAINV         /* 0xBF82201C */
  .extern UABSTAINV        /* 0xBF82201C */
  .extern U1TXREG          /* 0xBF822020 */
  .extern UABTXREG         /* 0xBF822020 */
  .extern U1RXREG          /* 0xBF822030 */
  .extern UABRXREG         /* 0xBF822030 */
  .extern U1BRG            /* 0xBF822040 */
  .extern UABBRG           /* 0xBF822040 */
  .extern U1BRGCLR         /* 0xBF822044 */
  .extern UABBRGCLR        /* 0xBF822044 */
  .extern U1BRGSET         /* 0xBF822048 */
  .extern UABBRGSET        /* 0xBF822048 */
  .extern U1BRGINV         /* 0xBF82204C */
  .extern UABBRGINV        /* 0xBF82204C */
  .extern U2MODE           /* 0xBF822200 */
  .extern UCDMODE          /* 0xBF822200 */
  .extern U2MODECLR        /* 0xBF822204 */
  .extern UCDMODECLR       /* 0xBF822204 */
  .extern U2MODESET        /* 0xBF822208 */
  .extern UCDMODESET       /* 0xBF822208 */
  .extern U2MODEINV        /* 0xBF82220C */
  .extern UCDMODEINV       /* 0xBF82220C */
  .extern U2STA            /* 0xBF822210 */
  .extern UCDSTA           /* 0xBF822210 */
  .extern U2STACLR         /* 0xBF822214 */
  .extern UCDSTACLR        /* 0xBF822214 */
  .extern U2STASET         /* 0xBF822218 */
  .extern UCDSTASET        /* 0xBF822218 */
  .extern U2STAINV         /* 0xBF82221C */
  .extern UCDSTAINV        /* 0xBF82221C */
  .extern U2TXREG          /* 0xBF822220 */
  .extern UCDTXREG         /* 0xBF822220 */
  .extern U2RXREG          /* 0xBF822230 */
  .extern UCDRXREG         /* 0xBF822230 */
  .extern U2BRG            /* 0xBF822240 */
  .extern UCDBRG           /* 0xBF822240 */
  .extern U2BRGCLR         /* 0xBF822244 */
  .extern UCDBRGCLR        /* 0xBF822244 */
  .extern U2BRGSET         /* 0xBF822248 */
  .extern UCDBRGSET        /* 0xBF822248 */
  .extern U2BRGINV         /* 0xBF82224C */
  .extern UCDBRGINV        /* 0xBF82224C */
  .extern U3MODE           /* 0xBF822400 */
  .extern UEFMODE          /* 0xBF822400 */
  .extern U3MODECLR        /* 0xBF822404 */
  .extern UEFMODECLR       /* 0xBF822404 */
  .extern U3MODESET        /* 0xBF822408 */
  .extern UEFMODESET       /* 0xBF822408 */
  .extern U3MODEINV        /* 0xBF82240C */
  .extern UEFMODEINV       /* 0xBF82240C */
  .extern U3STA            /* 0x