# When this script runs, we assume it has been called as the default
# start-up script by LWDAQ/LWDAQ.app/Contents/MacOS/Wish, and that it
# resides in LWDAQ/LWDAQ.app/Contents/Resources/Scripts. This Wish shell
# may have been started from a terminal by giving its full name, or by
# double-clicking on the LWDAQ.app icon in the MacOS finder. We want
# to run LWDAQ/LWDAQ.app/Contents/LWDAQ/Init.tcl to initialize and start
# LWDAQ. First we construct the name of the initialization file, using
# the name of this script as a starting point.
set f \
	[file normalize \
		[file join \
			[file dirname [info script]] \
			../../LWDAQ/Init.tcl \
		] \
	]

# When this file is called by the Wish shell, the first element in
# the argument list is always one we don't want to use. If Wish
# has been started by double-clicking in the finder, the first 
# element will be a process number, starting with "-psn". If we
# start Wish from the command line, the first element will be 
# the name of an initialization script. But we already know the
# script we want to use for initialization. So we delete the first
# element in argv and pass the curtailed arguments to Init.tcl.
set argv [lreplace $argv 0 0]

# Now we run Init.tcl with the source command. Any command-line arguments
# that may have been passed to the Wish shell will be available to Init.tcl
# in the global argv variable.
source $f
