# LWDAQ

The Long-Wire Data Acquisition ([LWDAQ](http://www.bndhep.net/Electronics/LWDAQ/Manual.html)) software acquires, displays, analyzes and records data acquired with LWDAQ hardware, such as the Boston CCD Angle Monitor ([BCAM](http://www.bndhep.net/Devices/BCAM/User_Manual.html)), Octal Data Receiver ([A2037E](http://www.opensourceinstruments.com/Electronics/A3027/M3027.html)), or Laboratory Camera ([A2075A](http://www.bndhep.net/Electronics/A2075/M2075.html)). Communication with LWDAQ Devices passes through a TCPIP server, such as the LWDAQ Driver ([A2071E](http://www.bndhep.net/Electronics/A2071/M2071.html)). The software manages communication with instruments that combine a LWDAQ server with a data acquisition device, such as the Animal Location Tracker ([ALT](https://www.opensourceinstruments.com/ALT/)) and Telemetry Control Box ([TCB](http://www.opensourceinstruments.com/Electronics/A3042/M3042.html)). The software's Videoarchiver manages viewing and recording video from Animal Cage Cameras ([ACC](http://www.opensourceinstruments.com/ACC)).

The LWDAQ software runs on Windows, Linux, MacOS, and Raspberry Pi. You can download the zip-archive, multi-platform distribution of the latest version of LWDAQ from our [Software Downlod](http://www.bndhep.net/Software/Download/) page. We distribute the LWDAQ development repository for free on GitHub under the [GNU Puplic License](https://www.gnu.org/licenses/gpl-3.0.txt). At each release, we tag the master branch with the program version number. If you want to contribute an improvement, send us a pull request. You will find documentation at the links below.

[GitHub Repository](https://github.com/OSI-INC/LWDAQ): Development repository on GitHub.

[BNDHEP Software](http://www.bndhep.net/Software): LWDAQ Software manual, command reference, source files.

[BNDHEP Electronics](http://www.bndhep.net/Electronics): Manuals for LWDAQ circuits designed at Brandeis University.

[BNDHEP Instruments](http://www.bndhep.net/Devices): Manuals for LWDAQ instruments.

[LWDAQ Specification](http://www.bndhep.net/Devices): LWDAQ hardware specification.

[OSI Instruments](http://www.opensourceinstruments.com): Open Source Instruments main page.


