## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Define the files you want to work with.
##
##  1. calibration_list should be the BCAM_Parameters_Full.txt
##  file from the HEP website (the list of all existing calibrations
##  and the constants generated from them).
##
##  2.  problem_list is the list that will be created of calibrations 
##  that meet the criteria for flagging.  Can be changed to whatever file
##  name/extension you want.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set calibration_list BCAM_Parameters_Full.txt

set problem_list BCAM_Camera_Problems.txt


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Sets bounds with respect the optimal camera values that the script 
##  will check against depending on the camera type.  You can change these
##  values to whatever you want.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set bounds(x) 200
set bounds(y) 200
set bounds(z) 7
set bounds(axis-x) 1000
set bounds(axis-y) 1000
set bounds(axis-z) 0
set bounds(CCD-pivot) 500
set bounds(CCD-axis) 1000


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  "Error" messages of sorts that give some information as
##  to why a calibration made it onto the list.  You can change these
##  if you want.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set reason(x) {X_Pivot_Position}
set reason(y) {Y_Pivot_Position}
set reason(z) {Z_Pivot_Position}
set reason(axis-x) {X-axis_Direction}
set reason(axis-y) {Y-axis_Direction}
set reason(axis-z) {Z-axis_Direction}
set reason(CCD-pivot) {CCD-to-Pivot}
set reason(CCD-axis) {CCD-Rotation}


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  proper_spacing is a temporary file that gets deleted at the end.
##  Do not touch.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set proper_spacing BCAM_Parameter_proper_spacing.txt


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Lists the nominal values for cameras.  Don't touch anything below
##  line.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set blackAzi(x) -12.675
set blackAzi(y) 13.137
set blackAzi(z) 2.0
set blackAzi(axis-x) 0
set blackAzi(axis-y) 0
set blackAzi(CCD-pivot) 75.0
set blackAzi(CCD-axis) 3141.6

set blueAzi(x) -12.675
set blueAzi(y) -13.137
set blueAzi(z) 2.0
set blueAzi(axis-x) 0
set blueAzi(axis-y) 0
set blueAzi(CCD-pivot) 75.0
set blueAzi(CCD-axis) 0

set blackPolFC(x) 12.751
set blackPolFC(y) 35.311
set blackPolFC(z) 2.0
set blackPolFC(axis-x) 0
set blackPolFC(axis-y) 0
set blackPolFC(CCD-pivot) 75.0
set blackPolFC(CCD-axis) 0

set blackPolRC(x) -12.751
set blackPolRC(y) 35.311
set blackPolRC(z) -81.9
set blackPolRC(axis-x) 0
set blackPolRC(axis-y) 0
set blackPolRC(CCD-pivot) 75.0
set blackPolRC(CCD-axis) 0

set bluePolFC(x) 12.751
set bluePolFC(y) -35.311
set bluePolFC(z) 2.0
set bluePolFC(axis-x) 0
set bluePolFC(axis-y) 0
set bluePolFC(CCD-pivot) 75.0
set bluePolFC(CCD-axis) 3141.6

set bluePolRC(x) -12.751
set bluePolRC(y) -35.311
set bluePolRC(z) -81.9
set bluePolRC(axis-x) 0
set bluePolRC(axis-y) 0
set bluePolRC(CCD-pivot) 75.0
set bluePolRC(CCD-axis) 3141.6


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Opens the calibration list to get the data.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set fid [open $calibration_list r]
set raw [read $fid]
close $fid


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Now we must ensure that only one blank space remains between
##  each value in each line of the calibration list, and
##  generates a file to be read by the next section.  One blank
##  space between each value makes putting them into an array
##  much easier.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set rawLines [split $raw "\n"]

foreach {line} $rawLines {
	
	regsub -all " +" $line " " line 
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Puts the values for each calibration into the "data" array.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	
	
	foreach {one two three four five six seven eight nine ten} $line {
		set data(one) $one
		set data(two) $two
		set data(three) $three
		set data(four) $four
		set data(five) $five
		set data(six) $six
		set data(seven) $seven
		set data(eight) $eight
		set data(nine) $nine
		set data(ten) $ten
		
		
		## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
		##
		##  This weeds out source calibrations by checking to see if the last 
		##  array entry is a number.  If it is, the line is written to the 
		##  proper_spacing file.
		##
		## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
		
		
		if { [regexp {[0-9]+[.]*[0-9]*} $data(ten) match = 1] } {
			set ps [open $proper_spacing a]
			puts -nonewline $ps "$line "
			close $ps		
		} 
	}	
}


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Opens the proper_spacing file and reads it.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set fid [open $proper_spacing r]
set content [read $fid]
close $fid


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Opens the problem_list file for appending lines from the
##  calibration_list file.
##  Assigns the values on each line to an array called "calib."
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set tmp [open $problem_list a]

foreach {device_id timestamp x y z rx ry rz ccd ro} $content {
	
	set calib(id) $device_id
	set calib(timestamp) $timestamp
	set calib(x) $x
	set calib(y) $y
	set calib(z) $z
	set calib(axis-x) $rx
	set calib(axis-y) $ry
	set calib(axis-z) $rz
	set calib(CCD-pivot) $ccd
	set calib(CCD-axis) $ro
	
	set calValues "$calib(id) $calib(timestamp) $calib(x) $calib(y) $calib(z) $calib(axis-x) $calib(axis-y) $calib(axis-z) $calib(CCD-pivot) $calib(CCD-axis)"
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks each line against the serial number and the corresponding 
	##  value stored in the last array entry.  If the value is higher or lower
	##  than the bounds set in the bounds array and depending on the type
	##  of camera, the line is printed to the problem_list file.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Black Azimuthal calibrations.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	
	
	if { [regexp {20MABNDA} $calib(id) match] } {
		
			# Pivot X
	
			if {$calib(x) > [expr $blackAzi(x) - $bounds(x)]} {
				
				if {$calib(x) < [expr $blackAzi(x) + $bounds(x)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"
										
				}
					
			} elseif { $calib(x) < [expr $blackAzi(x) + $bounds(x)] } {
				
				if {$calib(x) > [expr $blackAzi(x) - $bounds(x)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"				
					
				}
			}	
			
			# Pivot Y
			
			if {$calib(y) > [expr $blackAzi(y) - $bounds(y)]} {
				
				if {$calib(y) < [expr $blackAzi(y) + $bounds(y)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"					
					
				}
					
			} elseif { $calib(y) < [expr $blackAzi(y) + $bounds(y)] } {
				
				if {$calib(y) > [expr $blackAzi(y) - $bounds(y)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"
										
				}
			}		
			
			# Pivot Z
	
			if {$calib(z) > [expr $blackAzi(z) - $bounds(z)]} {
				
				if {$calib(z) < [expr $blackAzi(z) + $bounds(z)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
					
			} elseif { $calib(z) < [expr $blackAzi(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blackAzi(z) - $bounds(z)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}		
			
			# X-axis rotation
			
			if {$calib(axis-x) > [expr $blackAzi(axis-x) - $bounds(axis-x)]} {
				
				if {$calib(axis-x) < [expr $blackAzi(axis-x) + $bounds(axis-x)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"					
					
				}
					
			} elseif { $calib(axis-x) < [expr $blackAzi(axis-x) + $bounds(axis-x)] } {
				
				if {$calib(axis-x) > [expr $blackAzi(axis-x) - $bounds(axis-x)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}
			}				
				
			# Y-axis rotation		
		
			if {$calib(axis-y) > [expr $blackAzi(axis-y) - $bounds(axis-y)]} {
				
				if {$calib(axis-y) < [expr $blackAzi(axis-y) + $bounds(axis-y)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
										
				}
					
			} elseif { $calib(axis-y) < [expr $blackAzi(axis-y) + $bounds(axis-y)] } {
				
				if {$calib(axis-y) > [expr $blackAzi(axis-y) - $bounds(axis-y)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"					
					
				}
			}			
			
			# Z-axis rotation
			
			if { $calib(axis-z) < 0 } {
								
				puts -nonewline $tmp "$calValues $reason(axis-z)\n"
								
			}
			
			# CCD-to-Pivot value	
			
			if {$calib(CCD-pivot) > [expr $blackAzi(CCD-pivot) - $bounds(CCD-pivot)]} {

				if {$calib(CCD-pivot) < [expr $blackAzi(CCD-pivot) + $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}

			} elseif { $calib(CCD-pivot) < [expr $blackAzi(CCD-pivot) + $bounds(CCD-pivot)] } {
				
				if {$calib(CCD-pivot) > [expr $blackAzi(CCD-pivot) - $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"					
					
				}
			}
			
			# CCD axis rotation		
			
			if {$calib(CCD-axis) > [expr $blackAzi(CCD-axis) - $bounds(CCD-axis)]} {

				if {$calib(CCD-axis) < [expr $blackAzi(CCD-axis) + $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"					
					
				}

			} elseif { $calib(CCD-axis) < [expr $blackAzi(CCD-axis) + $bounds(CCD-axis)] } {
				
				if {$calib(CCD-axis) > [expr $blackAzi(CCD-axis) - $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"					
					
				}
			}						
	}
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Blue Azis.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	

	if { [regexp {20MABNDB} $calib(id) match] } {
		
			# Pivot X

			if {$calib(x) > [expr $blueAzi(x) - $bounds(x)]} {

				if {$calib(x) < [expr $blueAzi(x) + $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"
										
				}

			} elseif { $calib(x) < [expr $blueAzi(x) + $bounds(x)] } {
				if {$calib(x) > [expr $blueAzi(x) - $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"
										
				}
			}	

			# Pivot Y

			if {$calib(y) > [expr $blueAzi(y) - $bounds(y)]} {

				if {$calib(y) < [expr $blueAzi(y) + $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"
										
				}

			} elseif { $calib(y) < [expr $blueAzi(y) + $bounds(y)] } {
				
				if {$calib(y) > [expr $blueAzi(y) - $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"					
					
				}
			}		

			# Pivot Z

			if {$calib(z) > [expr $blueAzi(z) - $bounds(z)]} {

				if {$calib(z) < [expr $blueAzi(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}

			} elseif { $calib(z) < [expr $blueAzi(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blueAzi(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}		

			# X-axis rotation
	
			if {$calib(axis-x) > [expr $blueAzi(axis-x) - $bounds(axis-x)]} {

				if {$calib(axis-x) < [expr $blueAzi(axis-x) + $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"					
					
				}

			} elseif { $calib(axis-x) < [expr $blueAzi(axis-x) + $bounds(axis-x)] } {
				
				if {$calib(axis-x) > [expr $blueAzi(axis-x) - $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"					
					
				}
			}				

			# Y-axis rotation

			if {$calib(axis-y) > [expr $blueAzi(axis-y) - $bounds(axis-y)]} {

				if {$calib(axis-y) < [expr $blueAzi(axis-y) + $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"					
					
				}

			} elseif { $calib(axis-y) < [expr $blueAzi(axis-y) + $bounds(axis-y)] } {
				
				if {$calib(axis-y) > [expr $blueAzi(axis-y) - $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
										
				}
			}			

			# Z-axis rotation

			if { $calib(axis-z) < 0 } {
				
				puts -nonewline $tmp "$calValues $reason(axis-z)\n"

			}

			# CCD-to-Pivot value


			if {$calib(CCD-pivot) > [expr $blueAzi(CCD-pivot) - $bounds(CCD-pivot)]} {

				if {$calib(CCD-pivot) < [expr $blueAzi(CCD-pivot) + $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"					
					
				}

			} elseif { $calib(CCD-pivot) < [expr $blueAzi(CCD-pivot) + $bounds(CCD-pivot)] } {
				
				if {$calib(CCD-pivot) > [expr $blueAzi(CCD-pivot) - $bounds(CCD-pivot)]} {

				} else {					
					
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"					
					
				}
			}
			
			# CCD axis rotation

			if {$calib(CCD-axis) > [expr $blueAzi(CCD-axis) - $bounds(CCD-axis)]} {

				if {$calib(CCD-axis) < [expr $blueAzi(CCD-axis) + $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"					
					
				}

			} elseif { $calib(CCD-axis) < [expr $blueAzi(CCD-axis) + $bounds(CCD-axis)] } {
				
				if {$calib(CCD-axis) > [expr $blueAzi(CCD-axis) - $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"					
					
				}
			}			
	}
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Black Polars.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##	
	

	if { [regexp {20MABNDL} $calib(id) match] } {
		
		# Z-axis rotation
		
		if { $calib(axis-z) > 0} { 
			
			# X Pivot
			
			if {$calib(x) > [expr $blackPolFC(x) - $bounds(x)]} {

				if {$calib(x) < [expr $blackPolFC(x) + $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"
										
				}

			} elseif { $calib(x) < [expr $blackPolFC(x) + $bounds(x)] } {
				
				if {$calib(x) > [expr $blackPolFC(x) - $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"
					
				}
			}
			
			# Y Pivot
			
			if {$calib(y) > [expr $blackPolFC(y) - $bounds(y)]} {

				if {$calib(y) < [expr $blackPolFC(y) + $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"
										
				}

			} elseif { $calib(y) < [expr $blackPolFC(y) + $bounds(y)] } {
				
				if {$calib(y) > [expr $blackPolFC(y) - $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"
					
				}
			}
			
			# Z Pivot
		
			if {$calib(z) > [expr $blackPolFC(z) - $bounds(z)]} {

				if {$calib(z) < [expr $blackPolFC(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}

			} elseif { $calib(z) < [expr $blackPolFC(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blackPolFC(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}
			
			# X-axis rotation
			
			if {$calib(axis-x) > [expr $blackPolFC(axis-x) - $bounds(axis-x)]} {

				if {$calib(axis-x) < [expr $blackPolFC(axis-x) + $bounds(axis-x)]} {

				} else {
					
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}

			} elseif { $calib(axis-x) < [expr $blackPolFC(axis-x) + $bounds(axis-x)] } {
				
				if {$calib(axis-x) > [expr $blackPolFC(axis-x) - $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}
			}			
								
			# Y-axis rotation

			if {$calib(axis-y) > [expr $blackPolFC(axis-y) - $bounds(axis-y)]} {

				if {$calib(axis-y) < [expr $blackPolFC(axis-y) + $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"					
					
				}

			} elseif { $calib(axis-y) < [expr $blackPolFC(axis-y) + $bounds(axis-y)] } {
				
				if {$calib(axis-y) > [expr $blackPolFC(axis-y) - $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
										
				}	
			}

			# CCD-to-Pivot value

			if {$calib(CCD-pivot) > [expr $blackPolFC(CCD-pivot) - $bounds(CCD-pivot)]} {

				if {$calib(CCD-pivot) < [expr $blackPolFC(CCD-pivot) + $bounds(CCD-pivot)]} {

				} else {
					
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}

			} elseif { $calib(CCD-pivot) < [expr $blackPolFC(CCD-pivot) + $bounds(CCD-pivot)] } {
				
				if {$calib(CCD-pivot) > [expr $blackPolFC(CCD-pivot) - $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}
			}

			# CCD axis rotation

			if {$calib(CCD-axis) > [expr $blackPolFC(CCD-axis) - $bounds(CCD-axis)]} {

				if {$calib(CCD-axis) < [expr $blackPolFC(CCD-axis) + $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"					
					
				}

			} elseif { $calib(CCD-axis) < [expr $blackPolFC(CCD-axis) + $bounds(CCD-axis)] } {
				
				if {$calib(CCD-axis) > [expr $blackPolFC(CCD-axis) - $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"					
					
				}		
			}
		} 
		
		# Z-axis rotation
		
		if { $calib(axis-z) < 0} {
			
			# X Pivot
			
			if {$calib(x) > [expr $blackPolRC(x) - $bounds(x)]} {

				if {$calib(x) < [expr $blackPolRC(x) + $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"					
					
				}

			} elseif { $calib(x) < [expr $blackPolRC(x) + $bounds(x)] } {
				
				if {$calib(x) > [expr $blackPolRC(x) - $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"					
					
				}
			}

			# Y Pivot

			if {$calib(y) > [expr $blackPolRC(y) - $bounds(y)]} {

				if {$calib(y) < [expr $blackPolRC(y) + $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"					
					
				}

			} elseif { $calib(y) < [expr $blackPolRC(y) + $bounds(y)] } {
				
				if {$calib(y) > [expr $blackPolRC(y) - $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"
										
				}
			}
			
			# Z Pivot

			if {$calib(z) > [expr $blackPolRC(z) - $bounds(z)]} {

				if {$calib(z) < [expr $blackPolRC(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"
										
				}

			} elseif { $calib(z) < [expr $blackPolRC(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blackPolRC(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"
										
				}
			}

			# X-axis rotation

			if {$calib(axis-x) > [expr $blackPolRC(axis-x) - $bounds(axis-x)]} {

				if {$calib(axis-x) < [expr $blackPolRC(axis-x) + $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}

			} elseif { $calib(axis-x) < [expr $blackPolRC(axis-x) + $bounds(axis-x)] } {
				
				if {$calib(axis-x) > [expr $blackPolRC(axis-x) - $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}
			}
			
			# Y-axis rotation			
			
			if {$calib(axis-y) > [expr $blackPolRC(axis-y) - $bounds(axis-y)]} {

				if {$calib(axis-y) < [expr $blackPolRC(axis-y) + $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
										
				}

			} elseif { $calib(axis-y) < [expr $blackPolRC(axis-y) + $bounds(axis-y)] } {
				
				if {$calib(axis-y) > [expr $blackPolRC(axis-y) - $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"					
					
				}
			}
			
			# CCD-to-Pivot value

			if {$calib(CCD-pivot) > [expr $blackPolRC(CCD-pivot) - $bounds(CCD-pivot)]} {

				if {$calib(CCD-pivot) < [expr $blackPolRC(CCD-pivot) + $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}

			} elseif { $calib(CCD-pivot) < [expr $blackPolRC(CCD-pivot) + $bounds(CCD-pivot)] } {
				
				if {$calib(CCD-pivot) > [expr $blackPolRC(CCD-pivot) - $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}
			}
			
			# CCD axis rotation

			if {$calib(CCD-axis) > [expr $blackPolRC(CCD-axis) - $bounds(CCD-axis)]} {

				if {$calib(CCD-axis) < [expr $blackPolRC(CCD-axis) + $bounds(CCD-axis)]} {

				} else {					
					
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"
										
				}

			} elseif { $calib(CCD-axis) < [expr $blackPolRC(CCD-axis) + $bounds(CCD-axis)] } {
				
				if {$calib(CCD-axis) > [expr $blackPolRC(CCD-axis) - $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"
										
				}
			}	
		}				
	}			
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Blue Polars.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##	
	
	
	if { [regexp {20MABNDM} $calib(id) match] } {
		
		# Z-axis rotation

		if { $calib(axis-z) > 0} { 
			
			# X Pivot

			if {$calib(x) > [expr $bluePolFC(x) - $bounds(x)]} {

				if {$calib(x) < [expr $bluePolFC(x) + $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"					
					
				}

			} elseif { $calib(x) < [expr $bluePolFC(x) + $bounds(x)] } {
				
				if {$calib(x) > [expr $bluePolFC(x) - $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"
										
				}
			}
			
			# Y Pivot

			if {$calib(y) > [expr $bluePolFC(y) - $bounds(y)]} {

				if {$calib(y) < [expr $bluePolFC(y) + $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"
										
				}

			} elseif { $calib(y) < [expr $bluePolFC(y) + $bounds(y)] } {
				
				if {$calib(y) > [expr $bluePolFC(y) - $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"
										
				}
			}
			
			# Z Pivot

			if {$calib(z) > [expr $bluePolFC(z) - $bounds(z)]} {

				if {$calib(z) < [expr $bluePolFC(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"
										
				}

			} elseif { $calib(z) < [expr $bluePolFC(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $bluePolFC(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}
			
			# X-axis rotation

			if {$calib(axis-x) > [expr $bluePolFC(axis-x) - $bounds(axis-x)]} {

				if {$calib(axis-x) < [expr $bluePolFC(axis-x) + $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}

			} elseif { $calib(axis-x) < [expr $bluePolFC(axis-x) + $bounds(axis-x)] } {
				
				if {$calib(axis-x) > [expr $bluePolFC(axis-x) - $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"					
					
				}
			}	
			
			# Y-axis rotation		

			if {$calib(axis-y) > [expr $bluePolFC(axis-y) - $bounds(axis-y)]} {

				if {$calib(axis-y) < [expr $bluePolFC(axis-y) + $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
									
				}

			} elseif { $calib(axis-y) < [expr $bluePolFC(axis-y) + $bounds(axis-y)] } {
				
				if {$calib(axis-y) > [expr $bluePolFC(axis-y) - $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
										
				}
			}
			
			# CCD-to-Pivot value

			if {$calib(CCD-pivot) > [expr $bluePolFC(CCD-pivot) - $bounds(CCD-pivot)]} {

				if {$calib(CCD-pivot) < [expr $bluePolFC(CCD-pivot) + $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}

			} elseif { $calib(CCD-pivot) < [expr $bluePolFC(CCD-pivot) + $bounds(CCD-pivot)] } {
				
				if {$calib(CCD-pivot) > [expr $bluePolFC(CCD-pivot) - $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}
			}
			
			# CCD axis rotation
			
			if {$calib(CCD-axis) > [expr $bluePolFC(CCD-axis) - $bounds(CCD-axis)]} {

				if {$calib(CCD-axis) < [expr $bluePolFC(CCD-axis) + $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"
										
				}

			} elseif { $calib(CCD-axis) < [expr $bluePolFC(CCD-axis) + $bounds(CCD-axis)] } {
				
				if {$calib(CCD-axis) > [expr $bluePolFC(CCD-axis) - $bounds(CCD-axis)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"
										
				}
			}
		} 

		# Z-axis rotation

		if { $calib(axis-z) < 0} {

			if {$calib(x) > [expr $bluePolRC(x) - $bounds(x)]} {

				if {$calib(x) < [expr $bluePolRC(x) + $bounds(x)]} {

				} else {
									
					puts -nonewline $tmp "$calValues $reason(x)\n"				
					
				}

			} elseif { $calib(x) < [expr $bluePolRC(x) + $bounds(x)] } {
				
				if {$calib(x) > [expr $bluePolRC(x) - $bounds(x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x)\n"
										
				}
			}
			
			# Y Pivot

			if {$calib(y) > [expr $bluePolRC(y) - $bounds(y)]} {

				if {$calib(y) < [expr $bluePolRC(y) + $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"					
					
				}

			} elseif { $calib(y) < [expr $bluePolRC(y) + $bounds(y)] } {
				
				if {$calib(y) > [expr $bluePolRC(y) - $bounds(y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y)\n"					
					
				}
			}
			
			# Z Pivot

			if {$calib(z) > [expr $bluePolRC(z) - $bounds(z)]} {

				if {$calib(z) < [expr $bluePolRC(z) + $bounds(z)]} {

				} else {
									
					puts -nonewline $tmp "$calValues $reason(z)\n"
										
				}

			} elseif { $calib(z) < [expr $bluePolRC(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $bluePolRC(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"
										
				}
			}
			
			# X-axis rotation

			if {$calib(axis-x) > [expr $bluePolRC(axis-x) - $bounds(axis-x)]} {

				if {$calib(axis-x) < [expr $bluePolRC(axis-x) + $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}

			} elseif { $calib(axis-x) < [expr $bluePolRC(axis-x) + $bounds(axis-x)] } {
				
				if {$calib(axis-x) > [expr $bluePolRC(axis-x) - $bounds(axis-x)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-x)\n"
										
				}
			}		
			
			# Y-axis rotation	

			if {$calib(axis-y) > [expr $bluePolRC(axis-y) - $bounds(axis-y)]} {

				if {$calib(axis-y) < [expr $bluePolRC(axis-y) + $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
									
				}

			} elseif { $calib(axis-y) < [expr $bluePolRC(axis-y) + $bounds(axis-y)] } {
				
				if {$calib(axis-y) > [expr $bluePolRC(axis-y) - $bounds(axis-y)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(axis-y)\n"
										
				}
			}

			# CCD-to-Pivot value

			if {$calib(CCD-pivot) > [expr $bluePolRC(CCD-pivot) - $bounds(CCD-pivot)]} {

				if {$calib(CCD-pivot) < [expr $bluePolRC(CCD-pivot) + $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}

			} elseif { $calib(CCD-pivot) < [expr $bluePolRC(CCD-pivot) + $bounds(CCD-pivot)] } {
				
				if {$calib(CCD-pivot) > [expr $bluePolRC(CCD-pivot) - $bounds(CCD-pivot)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(CCD-pivot)\n"
										
				}
			}
			
			# CCD axis rotation

			if {$calib(CCD-axis) > [expr $bluePolRC(CCD-axis) - $bounds(CCD-axis)]} {

				if {$calib(CCD-axis) < [expr $bluePolRC(CCD-axis) + $bounds(CCD-axis)]} {

				} else {
					
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"
										
				}

			} elseif { $calib(CCD-axis) < [expr $bluePolRC(CCD-axis) + $bounds(CCD-axis)] } {
				
				if {$calib(CCD-axis) > [expr $bluePolRC(CCD-axis) - $bounds(CCD-axis)]} {

				} else {
					
					puts -nonewline $tmp "$calValues $reason(CCD-axis)\n"					
					
				}
			}
		}			
	}			
	
	 	
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Bracket closes the foreach loop.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


}


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Closes the file written to with the problem calibrations.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


close $tmp

 
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Removes the proper_spacing file since it's useless.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	

file delete $proper_spacing

