## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Define the files you want to work with.
##
##  1. calibration_list should be the BCAM_Parameters_Full.txt
##  file from the HEP website (the list of all existing calibrations
##  and the constants generated from them).
##
##  2.  problem_list is the list that will be created of calibrations 
##  that meet the criteria for flagging.Can be changed to whatever file
##  name/extension you want.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set calibration_list BCAM_Parameters_Full.txt

set problem_list BCAM_Source_Problems.txt



## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Sets bounds with respect the optimal camera values that the script 
##  will check against depending on the camera type.  You can change these
##  to whatever you want.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set bounds(x1) 15
set bounds(y1) 10
set bounds(x2) 15
set bounds(y2) 20
set bounds(z) 50

set boundsPolX(x1) 5
set boundsPolX(x2) 20


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  "Error" messages of sorts that give some information as
##  to why a calibration made it onto the list.  You can change
##  these if you want, but there's really no reason to.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##

set reason(x1) {X1_Position}
set reason(y1) {Y1_Position}
set reason(x2) {X2_Position}
set reason(y2) {Y2_Position}
set reason(z) {Z_Position}


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  proper_spacing is a temporary file that gets deleted at the end.
##  Do not touch.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set proper_spacing BCAM_Parameter_proper_spacing.txt


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Lists the ideal values for sources.  Don't touch anything below this
##  comment box.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##

set blackAzi(x1) -20.676
set blackAzi(y1) 13.137
set blackAzi(x2) -4.764
set blackAzi(y2) 13.137
set blackAzi(z) 0.360

set blueAzi(x1) -20.676
set blueAzi(y1) -13.137
set blueAzi(x2) -4.764
set blueAzi(y2) -13.137
set blueAzi(z) 0.360

set blackPolFS(x1) 4.674
set blackPolFS(y1) 36.812
set blackPolFS(x2) 20.670
set blackPolFS(y2) 36.812
set blackPolFS(z) 0.360

set blackPolRS(x1) -4.674
set blackPolRS(y1) 36.812
set blackPolRS(x2) -20.670
set blackPolRS(y2) 36.812
set blackPolRS(z) -82.850

set bluePolFS(x1) 4.674
set bluePolFS(y1) -36.812
set bluePolFS(x2) 20.670
set bluePolFS(y2) -36.812
set bluePolFS(z) 0.360

set bluePolRS(x1) -4.674
set bluePolRS(y1) -36.812
set bluePolRS(x2) -20.670
set bluePolRS(y2) -36.812
set bluePolRS(z) -82.850


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Opens the calibration list to get the data.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set fid [open $calibration_list r]
set raw [read $fid]
close $fid


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Now we must ensure that only one blank space remains between
##  each value in each line of the calibration list, and
##  generates a file to be read by the next section.  One blank
##  space between each value makes putting them into an array
##  much easier.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set rawLines [split $raw "\n"]

foreach {line} $rawLines {
	
	regsub -all " +" $line " " line 
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Puts the values for each calibration into the "data" array.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	
	
	foreach {one two three four five six seven eight nine ten} $line {
		set data(one) $one
		set data(two) $two
		set data(three) $three
		set data(four) $four
		set data(five) $five
		set data(six) $six
		set data(seven) $seven
		set data(eight) $eight
		set data(nine) $nine
		set data(ten) $ten
		
		
		## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
		##
		##  This weeds out camera calibrations by checking to see if the last 
		##  array entry is a number.  If it isn't, the line is written to the 
		##  proper_spacing file.
		##
		## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
		
		
		if { [string is double -strict $data(ten)] == 0 } {
			set ps [open $proper_spacing a]
			puts -nonewline $ps "$line "
			close $ps		
		} 
	}	
}


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Opens the proper_spacing file and reads it.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set fid [open $proper_spacing r]
set content [read $fid]
close $fid


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Opens the problem_list file for appending lines from the
##  calibration_list file.
##  Assigns the values on each line to an array called "calib."
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


set tmp [open $problem_list a]

foreach {device_id timestamp x1 y1 x2 y2 z} $content {
	
	set calib(id) $device_id
	set calib(timestamp) $timestamp
	set calib(x1) $x1
	set calib(y1) $y1
	set calib(x2) $x2
	set calib(y2) $y2
	set calib(z) $z
	
	set calValues "$calib(id) $calib(timestamp) $calib(x1) $calib(y1) $calib(x2) $calib(y2) $calib(z)"
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks each line against the serial number and the corresponding 
	##  value stored in the last array entry.  If the value is higher or lower
	##  than the bounds set in the bounds array and depending on the type
	##  of camera, the line is printed to the problem_list file.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Black Azimuthal source calibrations.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	
	
	if { [regexp {20MABNDA} $calib(id) match] } {
		
			# X1
	
			if {$calib(x1) > [expr $blackAzi(x1) - $bounds(x1)]} {
				
				if {$calib(x1) < [expr $blackAzi(x1) + $bounds(x1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
										
				}
					
			} elseif { $calib(x1) < [expr $blackAzi(x1) + $bounds(x1)] } {
				
				if {$calib(x1) > [expr $blackAzi(x1) - $bounds(x1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"				
					
				}
			}	
			
			# Y1
			
			if {$calib(y1) > [expr $blackAzi(y1) - $bounds(y1)]} {
				
				if {$calib(y1) < [expr $blackAzi(y1) + $bounds(y1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"					
					
				}
					
			} elseif { $calib(y1) < [expr $blackAzi(y1) + $bounds(y1)] } {
				
				if {$calib(y1) > [expr $blackAzi(y1) - $bounds(y1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
										
				}
			}	
			
			# X2
	
			if {$calib(x2) > [expr $blackAzi(x2) - $bounds(x2)]} {
				
				if {$calib(x2) < [expr $blackAzi(x2) + $bounds(x2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
										
				}
					
			} elseif { $calib(x2) < [expr $blackAzi(x2) + $bounds(x2)] } {
				
				if {$calib(x2) > [expr $blackAzi(x2) - $bounds(x2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"				
					
				}
			}	
			
			# Y2
			
			if {$calib(y2) > [expr $blackAzi(y2) - $bounds(y2)]} {
				
				if {$calib(y2) < [expr $blackAzi(y2) + $bounds(y2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"					
					
				}
					
			} elseif { $calib(y2) < [expr $blackAzi(y2) + $bounds(y2)] } {
				
				if {$calib(y2) > [expr $blackAzi(y2) - $bounds(y2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
										
				}
			}	
			
			# Z
	
			if {$calib(z) > [expr $blackAzi(z) - $bounds(z)]} {
				
				if {$calib(z) < [expr $blackAzi(z) + $bounds(z)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
					
			} elseif { $calib(z) < [expr $blackAzi(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blackAzi(z) - $bounds(z)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}		
	}
		
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Blue Azi sources.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	

	if { [regexp {20MABNDB} $calib(id) match] } {
		
			# X1
	
			if {$calib(x1) > [expr $blueAzi(x1) - $bounds(x1)]} {
				
				if {$calib(x1) < [expr $blueAzi(x1) + $bounds(x1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
										
				}
					
			} elseif { $calib(x1) < [expr $blueAzi(x1) + $bounds(x1)] } {
				
				if {$calib(x1) > [expr $blueAzi(x1) - $bounds(x1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"				
					
				}
			}	
			
			# Y1
			
			if {$calib(y1) > [expr $blueAzi(y1) - $bounds(y1)]} {
				
				if {$calib(y1) < [expr $blueAzi(y1) + $bounds(y1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"					
					
				}
					
			} elseif { $calib(y1) < [expr $blueAzi(y1) + $bounds(y1)] } {
				
				if {$calib(y1) > [expr $blueAzi(y1) - $bounds(y1)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
										
				}
			}	
						
			# X2
	
			if {$calib(x2) > [expr $blueAzi(x2) - $bounds(x2)]} {
				
				if {$calib(x2) < [expr $blueAzi(x2) + $bounds(x2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
										
				}
					
			} elseif { $calib(x2) < [expr $blueAzi(x2) + $bounds(x2)] } {
				
				if {$calib(x2) > [expr $blueAzi(x2) - $bounds(x2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"				
					
				}
			}	
			
			# Y2
			
			if {$calib(y2) > [expr $blueAzi(y2) - $bounds(y2)]} {
				
				if {$calib(y2) < [expr $blueAzi(y2) + $bounds(y2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"					
					
				}
					
			} elseif { $calib(y2) < [expr $blueAzi(y2) + $bounds(y2)] } {
				
				if {$calib(y2) > [expr $blueAzi(y2) - $bounds(y2)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
										
				}
			}	
			
			# Z
	
			if {$calib(z) > [expr $blueAzi(z) - $bounds(z)]} {
				
				if {$calib(z) < [expr $blueAzi(z) + $bounds(z)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
					
			} elseif { $calib(z) < [expr $blueAzi(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blueAzi(z) - $bounds(z)]} {
						
				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}			
	}
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Black Polars.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##	
	

	if { [regexp {20MABNDL} $calib(id) match] } {
		
		# determines FS or RS by checking the sign of x1.  Positive value -> FS
		
		if { $calib(x1) > 0} { 
			
			# X1
			
			if {$calib(x1) > [expr $blackPolFS(x1) - $boundsPolX(x1)]} {

				if {$calib(x1) < [expr $blackPolFS(x1) + $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
										
				}

			} elseif { $calib(x1) < [expr $blackPolFS(x1) + $boundsPolX(x1)] } {
				
				if {$calib(x1) > [expr $blackPolFS(x1) - $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
					
				}
			}
			
			# Y1
			
			if {$calib(y1) > [expr $blackPolFS(y1) - $bounds(y1)]} {

				if {$calib(y1) < [expr $blackPolFS(y1) + $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
										
				}

			} elseif { $calib(y1) < [expr $blackPolFS(y1) + $bounds(y1)] } {
				
				if {$calib(y1) > [expr $blackPolFS(y1) - $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
					
				}
			}
			
			# X2
			
			if {$calib(x2) > [expr $blackPolFS(x2) - $boundsPolX(x2)]} {

				if {$calib(x2) < [expr $blackPolFS(x2) + $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
										
				}

			} elseif { $calib(x2) < [expr $blackPolFS(x2) + $boundsPolX(x2)] } {
				
				if {$calib(x2) > [expr $blackPolFS(x2) - $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
					
				}
			}
			
			# Y2
			
			if {$calib(y2) > [expr $blackPolFS(y2) - $bounds(y2)]} {

				if {$calib(y2) < [expr $blackPolFS(y2) + $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
										
				}

			} elseif { $calib(y2) < [expr $blackPolFS(y2) + $bounds(y2)] } {
				
				if {$calib(y2) > [expr $blackPolFS(y2) - $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
					
				}
			}
			
			# Z
		
			if {$calib(z) > [expr $blackPolFS(z) - $bounds(z)]} {

				if {$calib(z) < [expr $blackPolFS(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}

			} elseif { $calib(z) < [expr $blackPolFS(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blackPolFS(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}
		} 
		
		# Negative value -> RS
		
		if { $calib(x1) < 0} {
			
			# X1
			
			if {$calib(x1) > [expr $blackPolRS(x1) - $boundsPolX(x1)]} {

				if {$calib(x1) < [expr $blackPolRS(x1) + $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
										
				}

			} elseif { $calib(x1) < [expr $blackPolRS(x1) + $boundsPolX(x1)] } {
				
				if {$calib(x1) > [expr $blackPolRS(x1) - $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
					
				}
			}
			
			# Y1
			
			if {$calib(y1) > [expr $blackPolRS(y1) - $bounds(y1)]} {

				if {$calib(y1) < [expr $blackPolRS(y1) + $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
										
				}

			} elseif { $calib(y1) < [expr $blackPolRS(y1) + $bounds(y1)] } {
				
				if {$calib(y1) > [expr $blackPolRS(y1) - $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
					
				}
			}
			
			# X2
			
			if {$calib(x2) > [expr $blackPolRS(x2) - $boundsPolX(x2)]} {

				if {$calib(x2) < [expr $blackPolRS(x2) + $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
										
				}

			} elseif { $calib(x2) < [expr $blackPolRS(x2) + $boundsPolX(x2)] } {
				
				if {$calib(x2) > [expr $blackPolRS(x2) - $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
					
				}
			}
			
			# Y2
			
			if {$calib(y2) > [expr $blackPolRS(y2) - $bounds(y2)]} {

				if {$calib(y2) < [expr $blackPolRS(y2) + $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
										
				}

			} elseif { $calib(y2) < [expr $blackPolRS(y2) + $bounds(y2)] } {
				
				if {$calib(y2) > [expr $blackPolRS(y2) - $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
					
				}
			}
			
			# Z
		
			if {$calib(z) > [expr $blackPolRS(z) - $bounds(z)]} {

				if {$calib(z) < [expr $blackPolRS(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}

			} elseif { $calib(z) < [expr $blackPolRS(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $blackPolRS(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}
		 			
		}
	}		
	
	
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	##
	##  Checks Blue Polars.
	##
	## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##	
	
	
	if { [regexp {20MABNDM} $calib(id) match] } {
		
		# determines FS or RS by checking the sign of x1.  Positive value -> FS
		
		if { $calib(x1) > 0} { 
			
			# X1
			
			if {$calib(x1) > [expr $bluePolFS(x1) - $boundsPolX(x1)]} {

				if {$calib(x1) < [expr $bluePolFS(x1) + $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
										
				}

			} elseif { $calib(x1) < [expr $bluePolFS(x1) + $boundsPolX(x1)] } {
				
				if {$calib(x1) > [expr $bluePolFS(x1) - $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
					
				}
			}
			
			# Y1
			
			if {$calib(y1) > [expr $bluePolFS(y1) - $bounds(y1)]} {

				if {$calib(y1) < [expr $bluePolFS(y1) + $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
										
				}

			} elseif { $calib(y1) < [expr $bluePolFS(y1) + $bounds(y1)] } {
				
				if {$calib(y1) > [expr $bluePolFS(y1) - $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
					
				}
			}
			
			# X2
			
			if {$calib(x2) > [expr $bluePolFS(x2) - $boundsPolX(x2)]} {

				if {$calib(x2) < [expr $bluePolFS(x2) + $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
										
				}

			} elseif { $calib(x2) < [expr $bluePolFS(x2) + $boundsPolX(x2)] } {
				
				if {$calib(x2) > [expr $bluePolFS(x2) - $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
					
				}
			}
			
			# Y2
			
			if {$calib(y2) > [expr $bluePolFS(y2) - $bounds(y2)]} {

				if {$calib(y2) < [expr $bluePolFS(y2) + $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
										
				}

			} elseif { $calib(y2) < [expr $bluePolFS(y2) + $bounds(y2)] } {
				
				if {$calib(y2) > [expr $bluePolFS(y2) - $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
					
				}
			}
			
			# Z
		
			if {$calib(z) > [expr $bluePolFS(z) - $bounds(z)]} {

				if {$calib(z) < [expr $bluePolFS(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}

			} elseif { $calib(z) < [expr $bluePolFS(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $bluePolFS(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}
		} 
		
		# Negative value -> RS
		
		if { $calib(x1) < 0} {
			
			# X1
			
			if {$calib(x1) > [expr $bluePolRS(x1) - $boundsPolX(x1)]} {

				if {$calib(x1) < [expr $bluePolRS(x1) + $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
										
				}

			} elseif { $calib(x1) < [expr $bluePolRS(x1) + $boundsPolX(x1)] } {
				
				if {$calib(x1) > [expr $bluePolRS(x1) - $boundsPolX(x1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x1)\n"
					
				}
			}
			
			# Y1
			
			if {$calib(y1) > [expr $bluePolRS(y1) - $bounds(y1)]} {

				if {$calib(y1) < [expr $bluePolRS(y1) + $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
										
				}

			} elseif { $calib(y1) < [expr $bluePolRS(y1) + $bounds(y1)] } {
				
				if {$calib(y1) > [expr $bluePolRS(y1) - $bounds(y1)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y1)\n"
					
				}
			}
			
			# X2
			
			if {$calib(x2) > [expr $bluePolRS(x2) - $boundsPolX(x2)]} {

				if {$calib(x2) < [expr $bluePolRS(x2) + $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
										
				}

			} elseif { $calib(x2) < [expr $bluePolRS(x2) + $boundsPolX(x2)] } {
				
				if {$calib(x2) > [expr $bluePolRS(x2) - $boundsPolX(x2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(x2)\n"
					
				}
			}
			
			# Y2
			
			if {$calib(y2) > [expr $bluePolRS(y2) - $bounds(y2)]} {

				if {$calib(y2) < [expr $bluePolRS(y2) + $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
										
				}

			} elseif { $calib(y2) < [expr $bluePolRS(y2) + $bounds(y2)] } {
				
				if {$calib(y2) > [expr $bluePolRS(y2) - $bounds(y2)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(y2)\n"
					
				}
			}
			
			# Z
		
			if {$calib(z) > [expr $bluePolRS(z) - $bounds(z)]} {

				if {$calib(z) < [expr $bluePolRS(z) + $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}

			} elseif { $calib(z) < [expr $bluePolRS(z) + $bounds(z)] } {
				
				if {$calib(z) > [expr $bluePolRS(z) - $bounds(z)]} {

				} else {
										
					puts -nonewline $tmp "$calValues $reason(z)\n"					
					
				}
			}
		 			
		}
	}			

	 	
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Bracket closes the foreach loop.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


}


## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Closes the file written to with the problem calibrations.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##


close $tmp

 
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
##
##  Removes the proper_spacing file since it's useless.
##
## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ## ##
	

file delete $proper_spacing

